/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.ResponseHandler;
import org.elasticsearch.xpack.ccr.action.ShardFollowTask;
import org.elasticsearch.xpack.core.ccr.action.PauseFollowAction;

public class TransportPauseFollowAction
extends TransportMasterNodeAction<PauseFollowAction.Request, AcknowledgedResponse> {
    private final PersistentTasksService persistentTasksService;

    @Inject
    public TransportPauseFollowAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, PersistentTasksService persistentTasksService) {
        super("cluster:admin/xpack/ccr/pause_follow", transportService, clusterService, threadPool, actionFilters, PauseFollowAction.Request::new, indexNameExpressionResolver);
        this.persistentTasksService = persistentTasksService;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    protected void masterOperation(PauseFollowAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        PersistentTasksCustomMetaData persistentTasksMetaData = (PersistentTasksCustomMetaData)state.metaData().custom("persistent_tasks");
        if (persistentTasksMetaData == null) {
            listener.onFailure((Exception)new IllegalArgumentException("no shard follow tasks for [" + request.getFollowIndex() + "]"));
            return;
        }
        List shardFollowTaskIds = persistentTasksMetaData.tasks().stream().filter(persistentTask -> "xpack/ccr/shard_follow_task".equals(persistentTask.getTaskName())).filter(persistentTask -> {
            ShardFollowTask shardFollowTask = (ShardFollowTask)persistentTask.getParams();
            return shardFollowTask.getFollowShardId().getIndexName().equals(request.getFollowIndex());
        }).map(PersistentTasksCustomMetaData.PersistentTask::getId).collect(Collectors.toList());
        if (shardFollowTaskIds.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("no shard follow tasks for [" + request.getFollowIndex() + "]"));
            return;
        }
        int i = 0;
        ResponseHandler responseHandler = new ResponseHandler(shardFollowTaskIds.size(), listener);
        for (String taskId : shardFollowTaskIds) {
            int taskSlot = i++;
            this.persistentTasksService.sendRemoveRequest(taskId, responseHandler.getActionListener(taskSlot));
        }
    }

    protected ClusterBlockException checkBlock(PauseFollowAction.Request request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.getFollowIndex());
    }
}

