/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.DeleteAutoFollowPatternAction;

public class TransportDeleteAutoFollowPatternAction
extends TransportMasterNodeAction<DeleteAutoFollowPatternAction.Request, AcknowledgedResponse> {
    @Inject
    public TransportDeleteAutoFollowPatternAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/ccr/auto_follow_pattern/delete", transportService, clusterService, threadPool, actionFilters, DeleteAutoFollowPatternAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    protected void masterOperation(final DeleteAutoFollowPatternAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("put-auto-follow-pattern-" + request.getName(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, listener){

            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                return TransportDeleteAutoFollowPatternAction.innerDelete(request, currentState);
            }
        });
    }

    static ClusterState innerDelete(DeleteAutoFollowPatternAction.Request request, ClusterState currentState) {
        AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)currentState.metaData().custom("ccr_auto_follow");
        if (currentAutoFollowMetadata == null) {
            throw new ResourceNotFoundException("auto-follow pattern [{}] is missing", new Object[]{request.getName()});
        }
        Map patterns = currentAutoFollowMetadata.getPatterns();
        AutoFollowMetadata.AutoFollowPattern autoFollowPatternToRemove = (AutoFollowMetadata.AutoFollowPattern)patterns.get(request.getName());
        if (autoFollowPatternToRemove == null) {
            throw new ResourceNotFoundException("auto-follow pattern [{}] is missing", new Object[]{request.getName()});
        }
        HashMap patternsCopy = new HashMap(patterns);
        HashMap followedLeaderIndexUUIDSCopy = new HashMap(currentAutoFollowMetadata.getFollowedLeaderIndexUUIDs());
        HashMap headers = new HashMap(currentAutoFollowMetadata.getHeaders());
        patternsCopy.remove(request.getName());
        followedLeaderIndexUUIDSCopy.remove(request.getName());
        headers.remove(request.getName());
        AutoFollowMetadata newAutoFollowMetadata = new AutoFollowMetadata(patternsCopy, followedLeaderIndexUUIDSCopy, headers);
        ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
        newState.metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ccr_auto_follow", (MetaData.Custom)newAutoFollowMetadata).build());
        return newState.build();
    }

    protected ClusterBlockException checkBlock(DeleteAutoFollowPatternAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

