/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.AutoFollowStats;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;

public class AutoFollowCoordinator
extends AbstractLifecycleComponent
implements ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(AutoFollowCoordinator.class);
    private static final int MAX_AUTO_FOLLOW_ERRORS = 256;
    private final Client client;
    private final ClusterService clusterService;
    private final CcrLicenseChecker ccrLicenseChecker;
    private final LongSupplier relativeMillisTimeProvider;
    private final LongSupplier absoluteMillisTimeProvider;
    private volatile TimeValue waitForMetadataTimeOut;
    private volatile Map<String, AutoFollower> autoFollowers = Collections.emptyMap();
    private long numberOfSuccessfulIndicesAutoFollowed = 0L;
    private long numberOfFailedIndicesAutoFollowed = 0L;
    private long numberOfFailedRemoteClusterStateRequests = 0L;
    private final LinkedHashMap<String, Tuple<Long, ElasticsearchException>> recentAutoFollowErrors;

    public AutoFollowCoordinator(Settings settings, Client client, ClusterService clusterService, CcrLicenseChecker ccrLicenseChecker, LongSupplier relativeMillisTimeProvider, LongSupplier absoluteMillisTimeProvider) {
        this.client = client;
        this.clusterService = clusterService;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker, "ccrLicenseChecker");
        this.relativeMillisTimeProvider = relativeMillisTimeProvider;
        this.absoluteMillisTimeProvider = absoluteMillisTimeProvider;
        this.recentAutoFollowErrors = new LinkedHashMap<String, Tuple<Long, ElasticsearchException>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Tuple<Long, ElasticsearchException>> eldest) {
                return this.size() > 256;
            }
        };
        Consumer<TimeValue> updater = newWaitForTimeOut -> {
            if (!newWaitForTimeOut.equals((Object)this.waitForMetadataTimeOut)) {
                LOGGER.info("changing wait_for_metadata_timeout from [{}] to [{}]", (Object)this.waitForMetadataTimeOut, newWaitForTimeOut);
                this.waitForMetadataTimeOut = newWaitForTimeOut;
            }
        };
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CcrSettings.CCR_WAIT_FOR_METADATA_TIMEOUT, updater);
        this.waitForMetadataTimeOut = (TimeValue)CcrSettings.CCR_WAIT_FOR_METADATA_TIMEOUT.get(settings);
    }

    protected void doStart() {
        this.clusterService.addListener((ClusterStateListener)this);
    }

    protected void doStop() {
        this.clusterService.removeListener((ClusterStateListener)this);
        LOGGER.trace("stopping all auto-followers");
        this.autoFollowers.values().forEach(AutoFollower::stop);
    }

    protected void doClose() {
    }

    public synchronized AutoFollowStats getStats() {
        Map<String, AutoFollower> autoFollowers = this.autoFollowers;
        TreeMap<String, AutoFollowStats.AutoFollowedCluster> timesSinceLastAutoFollowPerRemoteCluster = new TreeMap<String, AutoFollowStats.AutoFollowedCluster>();
        for (Map.Entry<String, AutoFollower> entry : autoFollowers.entrySet()) {
            long lastAutoFollowTimeInMillis = entry.getValue().lastAutoFollowTimeInMillis;
            long lastSeenMetadataVersion = entry.getValue().metadataVersion;
            if (lastAutoFollowTimeInMillis != -1L) {
                long timeSinceLastCheckInMillis = this.relativeMillisTimeProvider.getAsLong() - lastAutoFollowTimeInMillis;
                timesSinceLastAutoFollowPerRemoteCluster.put(entry.getKey(), new AutoFollowStats.AutoFollowedCluster(timeSinceLastCheckInMillis, lastSeenMetadataVersion));
                continue;
            }
            timesSinceLastAutoFollowPerRemoteCluster.put(entry.getKey(), new AutoFollowStats.AutoFollowedCluster(-1L, lastSeenMetadataVersion));
        }
        return new AutoFollowStats(this.numberOfFailedIndicesAutoFollowed, this.numberOfFailedRemoteClusterStateRequests, this.numberOfSuccessfulIndicesAutoFollowed, new TreeMap<String, Tuple<Long, ElasticsearchException>>(this.recentAutoFollowErrors), timesSinceLastAutoFollowPerRemoteCluster);
    }

    synchronized void updateStats(List<AutoFollowResult> results) {
        long newStatsReceivedTimeStamp = this.absoluteMillisTimeProvider.getAsLong();
        for (AutoFollowResult result : results) {
            if (result.clusterStateFetchException != null) {
                this.recentAutoFollowErrors.put(result.autoFollowPatternName, (Tuple<Long, ElasticsearchException>)Tuple.tuple((Object)newStatsReceivedTimeStamp, (Object)new ElasticsearchException((Throwable)result.clusterStateFetchException)));
                ++this.numberOfFailedRemoteClusterStateRequests;
                LOGGER.warn((Message)new ParameterizedMessage("failure occurred while fetching cluster state for auto follow pattern [{}]", (Object)result.autoFollowPatternName), (Throwable)result.clusterStateFetchException);
                continue;
            }
            for (Map.Entry<Index, Exception> entry : result.autoFollowExecutionResults.entrySet()) {
                if (entry.getValue() != null) {
                    ++this.numberOfFailedIndicesAutoFollowed;
                    this.recentAutoFollowErrors.put(result.autoFollowPatternName + ":" + entry.getKey().getName(), (Tuple<Long, ElasticsearchException>)Tuple.tuple((Object)newStatsReceivedTimeStamp, (Object)ExceptionsHelper.convertToElastic((Exception)entry.getValue())));
                    LOGGER.warn((Message)new ParameterizedMessage("failure occurred while auto following index [{}] for auto follow pattern [{}]", (Object)entry.getKey(), (Object)result.autoFollowPatternName), (Throwable)entry.getValue());
                    continue;
                }
                ++this.numberOfSuccessfulIndicesAutoFollowed;
            }
        }
    }

    void updateAutoFollowers(ClusterState followerClusterState) {
        AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)followerClusterState.getMetaData().custom("ccr_auto_follow");
        if (autoFollowMetadata == null) {
            return;
        }
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            LOGGER.warn("skipping auto-follower coordination", (Throwable)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        CopyOnWriteHashMap autoFollowers = CopyOnWriteHashMap.copyOf(this.autoFollowers);
        Set newRemoteClusters = autoFollowMetadata.getPatterns().entrySet().stream().map(entry -> ((AutoFollowMetadata.AutoFollowPattern)entry.getValue()).getRemoteCluster()).filter(remoteCluster -> !autoFollowers.containsKey(remoteCluster)).collect(Collectors.toSet());
        HashMap<String, AutoFollower> newAutoFollowers = new HashMap<String, AutoFollower>(newRemoteClusters.size());
        for (String remoteCluster2 : newRemoteClusters) {
            AutoFollower autoFollower = new AutoFollower(remoteCluster2, this::updateStats, () -> ((ClusterService)this.clusterService).state(), this.relativeMillisTimeProvider){

                @Override
                void getRemoteClusterState(String remoteCluster, long metadataVersion, BiConsumer<ClusterStateResponse, Exception> handler) {
                    ClusterStateRequest request = new ClusterStateRequest();
                    request.clear();
                    request.metaData(true);
                    request.routingTable(true);
                    request.waitForMetaDataVersion(metadataVersion);
                    request.waitForTimeout(AutoFollowCoordinator.this.waitForMetadataTimeOut);
                    AutoFollowCoordinator.this.ccrLicenseChecker.checkRemoteClusterLicenseAndFetchClusterState(AutoFollowCoordinator.this.client, remoteCluster, request, e -> handler.accept((ClusterStateResponse)null, (Exception)e), remoteClusterStateResponse -> handler.accept((ClusterStateResponse)remoteClusterStateResponse, (Exception)null));
                }

                @Override
                void createAndFollow(Map<String, String> headers, PutFollowAction.Request request, Runnable successHandler, Consumer<Exception> failureHandler) {
                    Client followerClient = CcrLicenseChecker.wrapClient(AutoFollowCoordinator.this.client, headers);
                    followerClient.execute((Action)PutFollowAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> successHandler.run(), failureHandler));
                }

                @Override
                void updateAutoFollowMetadata(final Function<ClusterState, ClusterState> updateFunction, final Consumer<Exception> handler) {
                    AutoFollowCoordinator.this.clusterService.submitStateUpdateTask("update_auto_follow_metadata", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                        public ClusterState execute(ClusterState currentState) throws Exception {
                            return (ClusterState)updateFunction.apply(currentState);
                        }

                        public void onFailure(String source, Exception e) {
                            handler.accept(e);
                        }

                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            handler.accept(null);
                        }
                    });
                }
            };
            newAutoFollowers.put(remoteCluster2, autoFollower);
            LOGGER.info("starting auto-follower for remote cluster [{}]", (Object)remoteCluster2);
            if (this.lifecycleState() != Lifecycle.State.STARTED) continue;
            autoFollower.start();
        }
        ArrayList<String> removedRemoteClusters = new ArrayList<String>();
        for (Map.Entry entry2 : autoFollowers.entrySet()) {
            String remoteCluster3 = (String)entry2.getKey();
            AutoFollower autoFollower = (AutoFollower)entry2.getValue();
            boolean exist = autoFollowMetadata.getPatterns().values().stream().anyMatch(pattern -> pattern.getRemoteCluster().equals(remoteCluster3));
            if (!exist) {
                LOGGER.info("removing auto-follower for remote cluster [{}]", (Object)remoteCluster3);
                autoFollower.removed = true;
                removedRemoteClusters.add(remoteCluster3);
                continue;
            }
            if (!autoFollower.remoteClusterConnectionMissing) continue;
            LOGGER.info("retrying auto-follower for remote cluster [{}] after remote cluster connection was missing", (Object)remoteCluster3);
            autoFollower.remoteClusterConnectionMissing = false;
            if (this.lifecycleState() != Lifecycle.State.STARTED) continue;
            autoFollower.start();
        }
        assert (this.assertNoOtherActiveAutoFollower(newAutoFollowers));
        this.autoFollowers = autoFollowers.copyAndPutAll(newAutoFollowers).copyAndRemoveAll(removedRemoteClusters);
    }

    private boolean assertNoOtherActiveAutoFollower(Map<String, AutoFollower> newAutoFollowers) {
        for (AutoFollower newAutoFollower : newAutoFollowers.values()) {
            AutoFollower previousInstance = this.autoFollowers.get(newAutoFollower.remoteCluster);
            assert (previousInstance == null || previousInstance.removed);
        }
        return true;
    }

    Map<String, AutoFollower> getAutoFollowers() {
        return this.autoFollowers;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.localNodeMaster()) {
            this.updateAutoFollowers(event.state());
        }
    }

    static class AutoFollowResult {
        final String autoFollowPatternName;
        final Exception clusterStateFetchException;
        final Map<Index, Exception> autoFollowExecutionResults;

        AutoFollowResult(String autoFollowPatternName, List<Tuple<Index, Exception>> results) {
            this.autoFollowPatternName = autoFollowPatternName;
            HashMap<Index, Exception> autoFollowExecutionResults = new HashMap<Index, Exception>();
            for (Tuple<Index, Exception> result : results) {
                autoFollowExecutionResults.put((Index)result.v1(), (Exception)result.v2());
            }
            this.clusterStateFetchException = null;
            this.autoFollowExecutionResults = Collections.unmodifiableMap(autoFollowExecutionResults);
        }

        AutoFollowResult(String autoFollowPatternName, Exception e) {
            this.autoFollowPatternName = autoFollowPatternName;
            this.clusterStateFetchException = e;
            this.autoFollowExecutionResults = Collections.emptyMap();
        }

        AutoFollowResult(String autoFollowPatternName) {
            this(autoFollowPatternName, (Exception)null);
        }
    }

    static abstract class AutoFollower {
        private final String remoteCluster;
        private final Consumer<List<AutoFollowResult>> statsUpdater;
        private final Supplier<ClusterState> followerClusterStateSupplier;
        private final LongSupplier relativeTimeProvider;
        private volatile long lastAutoFollowTimeInMillis = -1L;
        private volatile long metadataVersion = 0L;
        private volatile boolean remoteClusterConnectionMissing = false;
        volatile boolean removed = false;
        private volatile CountDown autoFollowPatternsCountDown;
        private volatile AtomicArray<AutoFollowResult> autoFollowResults;
        private volatile boolean stop;

        AutoFollower(String remoteCluster, Consumer<List<AutoFollowResult>> statsUpdater, Supplier<ClusterState> followerClusterStateSupplier, LongSupplier relativeTimeProvider) {
            this.remoteCluster = remoteCluster;
            this.statsUpdater = statsUpdater;
            this.followerClusterStateSupplier = followerClusterStateSupplier;
            this.relativeTimeProvider = relativeTimeProvider;
        }

        void start() {
            if (this.stop) {
                LOGGER.trace("auto-follower is stopped for remote cluster [{}]", (Object)this.remoteCluster);
                return;
            }
            if (this.removed) {
                LOGGER.info("AutoFollower instance for cluster [{}] has been removed", (Object)this.remoteCluster);
                return;
            }
            this.lastAutoFollowTimeInMillis = this.relativeTimeProvider.getAsLong();
            ClusterState clusterState = this.followerClusterStateSupplier.get();
            AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)clusterState.metaData().custom("ccr_auto_follow");
            if (autoFollowMetadata == null) {
                LOGGER.info("AutoFollower for cluster [{}] has stopped, because there is no autofollow metadata", (Object)this.remoteCluster);
                return;
            }
            List patterns = autoFollowMetadata.getPatterns().entrySet().stream().filter(entry -> ((AutoFollowMetadata.AutoFollowPattern)entry.getValue()).getRemoteCluster().equals(this.remoteCluster)).map(Map.Entry::getKey).collect(Collectors.toList());
            if (patterns.isEmpty()) {
                LOGGER.info("AutoFollower for cluster [{}] has stopped, because there are no more patterns", (Object)this.remoteCluster);
                return;
            }
            this.autoFollowPatternsCountDown = new CountDown(patterns.size());
            this.autoFollowResults = new AtomicArray(patterns.size());
            this.getRemoteClusterState(this.remoteCluster, this.metadataVersion + 1L, (remoteClusterStateResponse, remoteError) -> {
                if (this.removed) {
                    LOGGER.info("AutoFollower instance for cluster [{}] has been removed", (Object)this.remoteCluster);
                    return;
                }
                if (remoteClusterStateResponse != null) {
                    assert (remoteError == null);
                    if (remoteClusterStateResponse.isWaitForTimedOut()) {
                        LOGGER.trace("auto-follow coordinator timed out getting remote cluster state from [{}]", (Object)this.remoteCluster);
                        this.start();
                        return;
                    }
                    ClusterState remoteClusterState = remoteClusterStateResponse.getState();
                    this.metadataVersion = remoteClusterState.metaData().version();
                    this.autoFollowIndices(autoFollowMetadata, clusterState, remoteClusterState, patterns);
                } else {
                    assert (remoteError != null);
                    if (remoteError instanceof NoSuchRemoteClusterException) {
                        LOGGER.info("AutoFollower for cluster [{}] has stopped, because remote connection is gone", (Object)this.remoteCluster);
                        this.remoteClusterConnectionMissing = true;
                        return;
                    }
                    for (int i = 0; i < patterns.size(); ++i) {
                        String autoFollowPatternName = (String)patterns.get(i);
                        this.finalise(i, new AutoFollowResult(autoFollowPatternName, (Exception)remoteError));
                    }
                }
            });
        }

        void stop() {
            LOGGER.trace("stopping auto-follower for remote cluster [{}]", (Object)this.remoteCluster);
            this.stop = true;
        }

        private void autoFollowIndices(AutoFollowMetadata autoFollowMetadata, ClusterState clusterState, ClusterState remoteClusterState, List<String> patterns) {
            int i = 0;
            for (String autoFollowPatternName : patterns) {
                int slot = i;
                AutoFollowMetadata.AutoFollowPattern autoFollowPattern = (AutoFollowMetadata.AutoFollowPattern)autoFollowMetadata.getPatterns().get(autoFollowPatternName);
                Map headers = (Map)autoFollowMetadata.getHeaders().get(autoFollowPatternName);
                List followedIndices = (List)autoFollowMetadata.getFollowedLeaderIndexUUIDs().get(autoFollowPatternName);
                List<Index> leaderIndicesToFollow = AutoFollower.getLeaderIndicesToFollow(autoFollowPattern, remoteClusterState, followedIndices);
                if (leaderIndicesToFollow.isEmpty()) {
                    this.finalise(slot, new AutoFollowResult(autoFollowPatternName));
                } else {
                    List<Tuple<String, AutoFollowMetadata.AutoFollowPattern>> patternsForTheSameRemoteCluster = autoFollowMetadata.getPatterns().entrySet().stream().filter(item -> !autoFollowPatternName.equals(item.getKey())).filter(item -> this.remoteCluster.equals(((AutoFollowMetadata.AutoFollowPattern)item.getValue()).getRemoteCluster())).map(item -> new Tuple((Object)((String)item.getKey()), (Object)((AutoFollowMetadata.AutoFollowPattern)item.getValue()))).collect(Collectors.toList());
                    Consumer<AutoFollowResult> resultHandler = result -> this.finalise(slot, (AutoFollowResult)result);
                    this.checkAutoFollowPattern(autoFollowPatternName, this.remoteCluster, autoFollowPattern, leaderIndicesToFollow, headers, patternsForTheSameRemoteCluster, remoteClusterState.metaData(), clusterState.metaData(), resultHandler);
                }
                ++i;
            }
            this.cleanFollowedRemoteIndices(remoteClusterState, patterns);
        }

        private void checkAutoFollowPattern(String autoFollowPattenName, String remoteCluster, AutoFollowMetadata.AutoFollowPattern autoFollowPattern, List<Index> leaderIndicesToFollow, Map<String, String> headers, List<Tuple<String, AutoFollowMetadata.AutoFollowPattern>> patternsForTheSameRemoteCluster, MetaData remoteMetadata, MetaData localMetadata, Consumer<AutoFollowResult> resultHandler) {
            CountDown leaderIndicesCountDown = new CountDown(leaderIndicesToFollow.size());
            AtomicArray results = new AtomicArray(leaderIndicesToFollow.size());
            for (int i = 0; i < leaderIndicesToFollow.size(); ++i) {
                Index indexToFollow = leaderIndicesToFollow.get(i);
                int slot = i;
                List otherMatchingPatterns = patternsForTheSameRemoteCluster.stream().filter(otherPattern -> ((AutoFollowMetadata.AutoFollowPattern)otherPattern.v2()).match(indexToFollow.getName())).map(Tuple::v1).collect(Collectors.toList());
                if (otherMatchingPatterns.size() != 0) {
                    results.set(slot, (Object)new Tuple((Object)indexToFollow, (Object)new ElasticsearchException("index to follow [" + indexToFollow.getName() + "] for pattern [" + autoFollowPattenName + "] matches with other patterns " + otherMatchingPatterns + "", new Object[0])));
                    if (!leaderIndicesCountDown.countDown()) continue;
                    resultHandler.accept(new AutoFollowResult(autoFollowPattenName, results.asList()));
                    continue;
                }
                Settings leaderIndexSettings = remoteMetadata.getIndexSafe(indexToFollow).getSettings();
                if (!((Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(leaderIndexSettings)).booleanValue()) {
                    String message = String.format(Locale.ROOT, "index [%s] cannot be followed, because soft deletes are not enabled", indexToFollow.getName());
                    LOGGER.warn(message);
                    this.updateAutoFollowMetadata(AutoFollower.recordLeaderIndexAsFollowFunction(autoFollowPattenName, indexToFollow), error -> {
                        ElasticsearchException failure = new ElasticsearchException(message, new Object[0]);
                        if (error != null) {
                            failure.addSuppressed((Throwable)error);
                        }
                        results.set(slot, (Object)new Tuple((Object)indexToFollow, (Object)failure));
                        if (leaderIndicesCountDown.countDown()) {
                            resultHandler.accept(new AutoFollowResult(autoFollowPattenName, results.asList()));
                        }
                    });
                    continue;
                }
                if (AutoFollower.leaderIndexAlreadyFollowed(autoFollowPattern, indexToFollow, localMetadata)) {
                    this.updateAutoFollowMetadata(AutoFollower.recordLeaderIndexAsFollowFunction(autoFollowPattenName, indexToFollow), error -> {
                        results.set(slot, (Object)new Tuple((Object)indexToFollow, error));
                        if (leaderIndicesCountDown.countDown()) {
                            resultHandler.accept(new AutoFollowResult(autoFollowPattenName, results.asList()));
                        }
                    });
                    continue;
                }
                this.followLeaderIndex(autoFollowPattenName, remoteCluster, indexToFollow, autoFollowPattern, headers, error -> {
                    results.set(slot, (Object)new Tuple((Object)indexToFollow, error));
                    if (leaderIndicesCountDown.countDown()) {
                        resultHandler.accept(new AutoFollowResult(autoFollowPattenName, results.asList()));
                    }
                });
            }
        }

        private static boolean leaderIndexAlreadyFollowed(AutoFollowMetadata.AutoFollowPattern autoFollowPattern, Index leaderIndex, MetaData localMetadata) {
            Map customData;
            String followIndexName = AutoFollower.getFollowerIndexName(autoFollowPattern, leaderIndex.getName());
            IndexMetaData indexMetaData = localMetadata.index(followIndexName);
            if (indexMetaData != null && (customData = indexMetaData.getCustomData("ccr")) != null) {
                String recordedLeaderIndexUUID = (String)customData.get("leader_index_uuid");
                return leaderIndex.getUUID().equals(recordedLeaderIndexUUID);
            }
            return false;
        }

        private void followLeaderIndex(String autoFollowPattenName, String remoteCluster, Index indexToFollow, AutoFollowMetadata.AutoFollowPattern pattern, Map<String, String> headers, Consumer<Exception> onResult) {
            String leaderIndexName = indexToFollow.getName();
            String followIndexName = AutoFollower.getFollowerIndexName(pattern, leaderIndexName);
            PutFollowAction.Request request = new PutFollowAction.Request();
            request.setRemoteCluster(remoteCluster);
            request.setLeaderIndex(indexToFollow.getName());
            request.setFollowerIndex(followIndexName);
            request.getParameters().setMaxReadRequestOperationCount(pattern.getMaxReadRequestOperationCount());
            request.getParameters().setMaxReadRequestSize(pattern.getMaxReadRequestSize());
            request.getParameters().setMaxOutstandingReadRequests(pattern.getMaxOutstandingReadRequests());
            request.getParameters().setMaxWriteRequestOperationCount(pattern.getMaxWriteRequestOperationCount());
            request.getParameters().setMaxWriteRequestSize(pattern.getMaxWriteRequestSize());
            request.getParameters().setMaxOutstandingWriteRequests(pattern.getMaxOutstandingWriteRequests());
            request.getParameters().setMaxWriteBufferCount(pattern.getMaxWriteBufferCount());
            request.getParameters().setMaxWriteBufferSize(pattern.getMaxWriteBufferSize());
            request.getParameters().setMaxRetryDelay(pattern.getMaxRetryDelay());
            request.getParameters().setReadPollTimeout(pattern.getReadPollTimeout());
            Runnable successHandler = () -> {
                LOGGER.info("Auto followed leader index [{}] as follow index [{}]", (Object)leaderIndexName, (Object)followIndexName);
                Function<ClusterState, ClusterState> function = AutoFollower.recordLeaderIndexAsFollowFunction(autoFollowPattenName, indexToFollow);
                this.updateAutoFollowMetadata(function, onResult);
            };
            this.createAndFollow(headers, request, successHandler, onResult);
        }

        private void finalise(int slot, AutoFollowResult result) {
            assert (this.autoFollowResults.get(slot) == null);
            this.autoFollowResults.set(slot, (Object)result);
            if (this.autoFollowPatternsCountDown.countDown()) {
                this.statsUpdater.accept(this.autoFollowResults.asList());
                this.start();
            }
        }

        static List<Index> getLeaderIndicesToFollow(AutoFollowMetadata.AutoFollowPattern autoFollowPattern, ClusterState remoteClusterState, List<String> followedIndexUUIDs) {
            ArrayList<Index> leaderIndicesToFollow = new ArrayList<Index>();
            for (IndexMetaData leaderIndexMetaData : remoteClusterState.getMetaData()) {
                IndexRoutingTable indexRoutingTable;
                if (!autoFollowPattern.match(leaderIndexMetaData.getIndex().getName()) || (indexRoutingTable = remoteClusterState.routingTable().index(leaderIndexMetaData.getIndex())) == null || !indexRoutingTable.allPrimaryShardsActive() || followedIndexUUIDs.contains(leaderIndexMetaData.getIndex().getUUID())) continue;
                leaderIndicesToFollow.add(leaderIndexMetaData.getIndex());
            }
            return leaderIndicesToFollow;
        }

        static String getFollowerIndexName(AutoFollowMetadata.AutoFollowPattern autoFollowPattern, String leaderIndexName) {
            if (autoFollowPattern.getFollowIndexPattern() != null) {
                return autoFollowPattern.getFollowIndexPattern().replace("{{leader_index}}", leaderIndexName);
            }
            return leaderIndexName;
        }

        static Function<ClusterState, ClusterState> recordLeaderIndexAsFollowFunction(String name, Index indexToFollow) {
            return currentState -> {
                AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)currentState.metaData().custom("ccr_auto_follow");
                HashMap<String, List> newFollowedIndexUUIDS = new HashMap<String, List>(currentAutoFollowMetadata.getFollowedLeaderIndexUUIDs());
                if (!newFollowedIndexUUIDS.containsKey(name)) {
                    return currentState;
                }
                newFollowedIndexUUIDS.compute(name, (key, existingUUIDs) -> {
                    assert (existingUUIDs != null);
                    ArrayList<String> newUUIDs = new ArrayList<String>((Collection<String>)existingUUIDs);
                    newUUIDs.add(indexToFollow.getUUID());
                    return Collections.unmodifiableList(newUUIDs);
                });
                AutoFollowMetadata newAutoFollowMetadata = new AutoFollowMetadata(currentAutoFollowMetadata.getPatterns(), newFollowedIndexUUIDS, currentAutoFollowMetadata.getHeaders());
                return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ccr_auto_follow", (MetaData.Custom)newAutoFollowMetadata).build()).build();
            };
        }

        void cleanFollowedRemoteIndices(ClusterState remoteClusterState, List<String> patterns) {
            this.updateAutoFollowMetadata(AutoFollower.cleanFollowedRemoteIndices(remoteClusterState.metaData(), patterns), e -> {
                if (e != null) {
                    LOGGER.warn("Error occured while cleaning followed leader indices", (Throwable)e);
                }
            });
        }

        static Function<ClusterState, ClusterState> cleanFollowedRemoteIndices(MetaData remoteMetadata, List<String> autoFollowPatternNames) {
            return currentState -> {
                AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)currentState.metaData().custom("ccr_auto_follow");
                HashMap autoFollowPatternNameToFollowedIndexUUIDs = new HashMap(currentAutoFollowMetadata.getFollowedLeaderIndexUUIDs());
                HashSet remoteIndexUUIDS = new HashSet();
                remoteMetadata.getIndices().values().forEach(value -> remoteIndexUUIDS.add(value.getIndexUUID()));
                boolean requiresCSUpdate = false;
                for (String autoFollowPatternName : autoFollowPatternNames) {
                    if (!autoFollowPatternNameToFollowedIndexUUIDs.containsKey(autoFollowPatternName)) continue;
                    ArrayList<String> followedIndexUUIDs = new ArrayList<String>((Collection)autoFollowPatternNameToFollowedIndexUUIDs.get(autoFollowPatternName));
                    boolean entriesRemoved = followedIndexUUIDs.removeIf(followedLeaderIndexUUID -> !remoteIndexUUIDS.contains(followedLeaderIndexUUID));
                    if (entriesRemoved) {
                        requiresCSUpdate = true;
                    }
                    autoFollowPatternNameToFollowedIndexUUIDs.put(autoFollowPatternName, followedIndexUUIDs);
                }
                if (requiresCSUpdate) {
                    AutoFollowMetadata newAutoFollowMetadata = new AutoFollowMetadata(currentAutoFollowMetadata.getPatterns(), autoFollowPatternNameToFollowedIndexUUIDs, currentAutoFollowMetadata.getHeaders());
                    return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ccr_auto_follow", (MetaData.Custom)newAutoFollowMetadata).build()).build();
                }
                return currentState;
            };
        }

        abstract void getRemoteClusterState(String var1, long var2, BiConsumer<ClusterStateResponse, Exception> var4);

        abstract void createAndFollow(Map<String, String> var1, PutFollowAction.Request var2, Runnable var3, Consumer<Exception> var4);

        abstract void updateAutoFollowMetadata(Function<ClusterState, ClusterState> var1, Consumer<Exception> var2);
    }
}

