/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.results;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetBucketsAction;
import org.elasticsearch.xpack.core.ml.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class RestGetBucketsAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetBucketsAction.class));

    public RestGetBucketsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/buckets/{" + Result.TIMESTAMP.getPreferredName() + "}", (RestHandler)this, RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/buckets/{" + Result.TIMESTAMP.getPreferredName() + "}", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/buckets/{" + Result.TIMESTAMP.getPreferredName() + "}", (RestHandler)this, RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/buckets/{" + Result.TIMESTAMP.getPreferredName() + "}", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/buckets", (RestHandler)this, RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/buckets", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/buckets", (RestHandler)this, RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID.getPreferredName() + "}/results/buckets", deprecationLogger);
    }

    public String getName() {
        return "ml_get_buckets_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetBucketsAction.Request request;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        String timestamp = restRequest.param(GetBucketsAction.Request.TIMESTAMP.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            request = GetBucketsAction.Request.parseRequest((String)jobId, (XContentParser)parser);
            if (!Strings.isNullOrEmpty((String)timestamp)) {
                request.setTimestamp(timestamp);
            }
        } else {
            request = new GetBucketsAction.Request(jobId);
            if (!Strings.isNullOrEmpty((String)timestamp)) {
                request.setTimestamp(timestamp);
            }
            if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
                request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
            }
            if (restRequest.hasParam(GetBucketsAction.Request.START.getPreferredName())) {
                request.setStart(restRequest.param(GetBucketsAction.Request.START.getPreferredName()));
            }
            if (restRequest.hasParam(GetBucketsAction.Request.END.getPreferredName())) {
                request.setEnd(restRequest.param(GetBucketsAction.Request.END.getPreferredName()));
            }
            if (restRequest.hasParam(GetBucketsAction.Request.ANOMALY_SCORE.getPreferredName())) {
                request.setAnomalyScore(Double.parseDouble(restRequest.param(GetBucketsAction.Request.ANOMALY_SCORE.getPreferredName(), "0.0")));
            }
            if (restRequest.hasParam(GetBucketsAction.Request.SORT.getPreferredName())) {
                request.setSort(restRequest.param(GetBucketsAction.Request.SORT.getPreferredName()));
            }
            request.setDescending(restRequest.paramAsBoolean(GetBucketsAction.Request.DESCENDING.getPreferredName(), request.isDescending()));
            request.setExpand(restRequest.paramAsBoolean(GetBucketsAction.Request.EXPAND.getPreferredName(), false));
            request.setExcludeInterim(restRequest.paramAsBoolean(GetBucketsAction.Request.EXCLUDE_INTERIM.getPreferredName(), false));
        }
        return channel -> client.execute((Action)GetBucketsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

