/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.process;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;

public class NativeStorageProvider {
    private static final Logger LOGGER = LogManager.getLogger(NativeStorageProvider.class);
    private static final String LOCAL_STORAGE_SUBFOLDER = "ml-local-data";
    private static final String LOCAL_STORAGE_TMP_FOLDER = "tmp";
    private final Environment environment;
    private final ByteSizeValue minLocalStorageAvailable;

    public NativeStorageProvider(Environment environment, ByteSizeValue minDiskSpaceOffHeap) {
        this.environment = environment;
        this.minLocalStorageAvailable = minDiskSpaceOffHeap;
    }

    public void cleanupLocalTmpStorageInCaseOfUncleanShutdown() throws IOException {
        for (Path p : this.environment.dataFiles()) {
            IOUtils.rm((Path[])new Path[]{p.resolve(LOCAL_STORAGE_SUBFOLDER).resolve(LOCAL_STORAGE_TMP_FOLDER)});
        }
    }

    public Path tryGetLocalTmpStorage(String uniqueIdentifier, ByteSizeValue requestedSize) {
        for (Path path : this.environment.dataFiles()) {
            try {
                if (this.getUsableSpace(path) < requestedSize.getBytes() + this.minLocalStorageAvailable.getBytes()) continue;
                Path tmpDirectory = path.resolve(LOCAL_STORAGE_SUBFOLDER).resolve(LOCAL_STORAGE_TMP_FOLDER).resolve(uniqueIdentifier);
                Files.createDirectories(tmpDirectory, new FileAttribute[0]);
                return tmpDirectory;
            }
            catch (IOException e) {
                LOGGER.debug("Failed to obtain information about path [{}]: {}", (Object)path, (Object)e);
            }
        }
        LOGGER.debug("Failed to find native storage for [{}], returning null", (Object)uniqueIdentifier);
        return null;
    }

    public boolean localTmpStorageHasEnoughSpace(Path path, ByteSizeValue requestedSize) {
        Path realPath = path.toAbsolutePath();
        for (Path p : this.environment.dataFiles()) {
            try {
                if (!realPath.startsWith(p.resolve(LOCAL_STORAGE_SUBFOLDER).resolve(LOCAL_STORAGE_TMP_FOLDER))) continue;
                return this.getUsableSpace(p) >= requestedSize.getBytes() + this.minLocalStorageAvailable.getBytes();
            }
            catch (IOException e) {
                LOGGER.debug("Failed to optain information about path [{}]: {}", (Object)path, (Object)e);
            }
        }
        LOGGER.debug("Not enough space left for path [{}]", (Object)path);
        return false;
    }

    public void cleanupLocalTmpStorage(Path path) throws IOException {
        Path realPath = path.toAbsolutePath();
        for (Path p : this.environment.dataFiles()) {
            if (!realPath.startsWith(p.resolve(LOCAL_STORAGE_SUBFOLDER).resolve(LOCAL_STORAGE_TMP_FOLDER))) continue;
            IOUtils.rm((Path[])new Path[]{path});
        }
    }

    public ByteSizeValue getMinLocalStorageAvailable() {
        return this.minLocalStorageAvailable;
    }

    long getUsableSpace(Path path) throws IOException {
        long freeSpaceInBytes = Environment.getFileStore((Path)path).getUsableSpace();
        if (freeSpaceInBytes < 0L) {
            freeSpaceInBytes = Long.MAX_VALUE;
        }
        return freeSpaceInBytes;
    }
}

