/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.process;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.process.NativeControllerHolder;
import org.elasticsearch.xpack.ml.process.NativeProcess;
import org.elasticsearch.xpack.ml.process.StateProcessor;
import org.elasticsearch.xpack.ml.process.logging.CppLogMessageHandler;
import org.elasticsearch.xpack.ml.process.writer.LengthEncodedWriter;

public abstract class AbstractNativeProcess
implements NativeProcess {
    private static final Logger LOGGER = LogManager.getLogger(AbstractNativeProcess.class);
    private static final Duration WAIT_FOR_KILL_TIMEOUT = Duration.ofMillis(1000L);
    private final String jobId;
    private final CppLogMessageHandler cppLogHandler;
    private final OutputStream processInStream;
    private final InputStream processOutStream;
    private final OutputStream processRestoreStream;
    private final LengthEncodedWriter recordWriter;
    private final ZonedDateTime startTime;
    private final int numberOfFields;
    private final List<Path> filesToDelete;
    private final Consumer<String> onProcessCrash;
    private volatile Future<?> logTailFuture;
    private volatile Future<?> stateProcessorFuture;
    private volatile boolean processCloseInitiated;
    private volatile boolean processKilled;
    private volatile boolean isReady;

    protected AbstractNativeProcess(String jobId, InputStream logStream, OutputStream processInStream, InputStream processOutStream, OutputStream processRestoreStream, int numberOfFields, List<Path> filesToDelete, Consumer<String> onProcessCrash) {
        this.jobId = jobId;
        this.cppLogHandler = new CppLogMessageHandler(jobId, logStream);
        this.processInStream = new BufferedOutputStream(processInStream);
        this.processOutStream = processOutStream;
        this.processRestoreStream = processRestoreStream;
        this.recordWriter = new LengthEncodedWriter(this.processInStream);
        this.startTime = ZonedDateTime.now();
        this.numberOfFields = numberOfFields;
        this.filesToDelete = filesToDelete;
        this.onProcessCrash = Objects.requireNonNull(onProcessCrash);
    }

    public abstract String getName();

    public void start(ExecutorService executorService) {
        this.logTailFuture = executorService.submit(() -> {
            block13: {
                String errors;
                try {
                    try (CppLogMessageHandler h = this.cppLogHandler;){
                        h.tailStream();
                    }
                    if (this.processCloseInitiated || this.processKilled) break block13;
                    errors = this.cppLogHandler.getErrors();
                }
                catch (IOException e) {
                    String errors2;
                    try {
                        if (!this.processKilled) {
                            LOGGER.error((Message)new ParameterizedMessage("[{}] Error tailing {} process logs", (Object)this.jobId, (Object)this.getName()), (Throwable)e);
                        }
                        if (this.processCloseInitiated || this.processKilled) break block13;
                        errors2 = this.cppLogHandler.getErrors();
                    }
                    catch (Throwable throwable) {
                        if (!this.processCloseInitiated && !this.processKilled) {
                            String errors3 = this.cppLogHandler.getErrors();
                            String fullError = String.format(Locale.ROOT, "[%s] %s process stopped unexpectedly: %s", this.jobId, this.getName(), errors3);
                            LOGGER.error(fullError);
                            this.onProcessCrash.accept(fullError);
                        }
                        throw throwable;
                    }
                    String fullError = String.format(Locale.ROOT, "[%s] %s process stopped unexpectedly: %s", this.jobId, this.getName(), errors2);
                    LOGGER.error(fullError);
                    this.onProcessCrash.accept(fullError);
                }
                String fullError = String.format(Locale.ROOT, "[%s] %s process stopped unexpectedly: %s", this.jobId, this.getName(), errors);
                LOGGER.error(fullError);
                this.onProcessCrash.accept(fullError);
            }
        });
    }

    public void start(ExecutorService executorService, StateProcessor stateProcessor, InputStream persistStream) {
        this.start(executorService);
        this.stateProcessorFuture = executorService.submit(() -> {
            block9: {
                try (InputStream in = persistStream;){
                    stateProcessor.process(in);
                    if (!this.processKilled) {
                        LOGGER.info("[{}] State output finished", (Object)this.jobId);
                    }
                }
                catch (IOException e) {
                    if (this.processKilled) break block9;
                    LOGGER.error((Message)new ParameterizedMessage("[{}] Error reading {} state output", (Object)this.jobId, (Object)this.getName()), (Throwable)e);
                }
            }
        });
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    protected void setReady() {
        this.isReady = true;
    }

    @Override
    public void writeRecord(String[] record) throws IOException {
        this.recordWriter.writeRecord(record);
    }

    @Override
    public void flushStream() throws IOException {
        this.recordWriter.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.processCloseInitiated = true;
            this.processInStream.close();
            if (this.stateProcessorFuture != null) {
                this.stateProcessorFuture.get(MachineLearningField.STATE_PERSIST_RESTORE_TIMEOUT.getMinutes(), TimeUnit.MINUTES);
            }
            if (this.logTailFuture != null) {
                this.logTailFuture.get(5L, TimeUnit.SECONDS);
            }
            if (this.cppLogHandler.seenFatalError()) {
                throw ExceptionsHelper.serverError((String)this.cppLogHandler.getErrors());
            }
            LOGGER.debug("[{}] {} process exited", (Object)this.jobId, (Object)this.getName());
        }
        catch (ExecutionException | TimeoutException e) {
            LOGGER.warn((Message)new ParameterizedMessage("[{}] Exception closing the running {} process", (Object)this.jobId, (Object)this.getName()), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.warn((Message)new ParameterizedMessage("[{}] Exception closing the running {} process", (Object)this.jobId, (Object)this.getName()), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.deleteAssociatedFiles();
        }
    }

    @Override
    public void kill() throws IOException {
        this.processKilled = true;
        try {
            NativeControllerHolder.getNativeController().killProcess(this.cppLogHandler.getPid(Duration.ZERO));
            this.cppLogHandler.waitForLogStreamClose(WAIT_FOR_KILL_TIMEOUT);
        }
        catch (TimeoutException e) {
            LOGGER.warn("[{}] Failed to get PID of {} process to kill", (Object)this.jobId, (Object)this.getName());
        }
        finally {
            try {
                this.processInStream.close();
            }
            catch (IOException iOException) {}
            try {
                this.deleteAssociatedFiles();
            }
            catch (IOException iOException) {}
        }
    }

    private synchronized void deleteAssociatedFiles() throws IOException {
        if (this.filesToDelete == null) {
            return;
        }
        for (Path fileToDelete : this.filesToDelete) {
            if (Files.deleteIfExists(fileToDelete)) {
                LOGGER.debug("[{}] Deleted file {}", (Object)this.jobId, (Object)fileToDelete.toString());
                continue;
            }
            LOGGER.warn("[{}] Failed to delete file {}", (Object)this.jobId, (Object)fileToDelete.toString());
        }
        this.filesToDelete.clear();
    }

    @Override
    public ZonedDateTime getProcessStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isProcessAlive() {
        return !this.cppLogHandler.hasLogStreamEnded();
    }

    @Override
    public boolean isProcessAliveAfterWaiting() {
        this.cppLogHandler.waitForLogStreamClose(Duration.ofMillis(45L));
        return this.isProcessAlive();
    }

    @Override
    public String readError() {
        return this.cppLogHandler.getErrors();
    }

    protected String jobId() {
        return this.jobId;
    }

    protected InputStream processOutStream() {
        return this.processOutStream;
    }

    @Nullable
    protected OutputStream processRestoreStream() {
        return this.processRestoreStream;
    }

    protected int numberOfFields() {
        return this.numberOfFields;
    }

    protected LengthEncodedWriter recordWriter() {
        return this.recordWriter;
    }

    protected boolean isProcessKilled() {
        return this.processKilled;
    }
}

