/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.metrics.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.Stats;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshotField;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.Influencer;
import org.elasticsearch.xpack.core.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.stats.CountAccumulator;
import org.elasticsearch.xpack.core.ml.stats.ForecastStats;
import org.elasticsearch.xpack.core.ml.stats.StatsAccumulator;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.ml.job.categorization.GrokPatternCreator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedBucketsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedInfluencersIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedRecordsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BatchedResultsIterator;
import org.elasticsearch.xpack.ml.job.persistence.BucketsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.CalendarQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.InfluencersQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.RecordsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.ResultsFilterBuilder;
import org.elasticsearch.xpack.ml.job.persistence.ScheduledEventsQueryBuilder;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.AutodetectParams;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;

public class JobResultsProvider {
    private static final Logger LOGGER = LogManager.getLogger(JobResultsProvider.class);
    private static final int RECORDS_SIZE_PARAM = 10000;
    public static final int BUCKETS_FOR_ESTABLISHED_MEMORY_SIZE = 20;
    private static final double ESTABLISHED_MEMORY_CV_THRESHOLD = 0.1;
    private final Client client;
    private final Settings settings;

    public JobResultsProvider(Client client, Settings settings) {
        this.client = Objects.requireNonNull(client);
        this.settings = settings;
    }

    public void checkForLeftOverDocuments(final Job job, final ActionListener<Boolean> listener) {
        SearchRequestBuilder stateDocSearch = this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{CategorizerState.documentId((String)job.getId(), (int)1), CategorizerState.v54DocumentId((String)job.getId(), (int)1)})).setIndicesOptions(IndicesOptions.strictExpand());
        SearchRequestBuilder quantilesDocSearch = this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{Quantiles.documentId((String)job.getId()), Quantiles.v54DocumentId((String)job.getId())})).setIndicesOptions(IndicesOptions.strictExpand());
        String resultsIndexName = job.getInitialResultsIndexName();
        SearchRequestBuilder resultDocSearch = this.client.prepareSearch(new String[]{resultsIndexName}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)job.getId())).setSize(1);
        final MultiSearchRequestBuilder msearch = this.client.prepareMultiSearch().add(stateDocSearch).add(resultDocSearch).add(quantilesDocSearch);
        ActionListener<MultiSearchResponse> searchResponseActionListener = new ActionListener<MultiSearchResponse>(){

            public void onResponse(MultiSearchResponse response) {
                ArrayList<SearchHit> searchHits = new ArrayList<SearchHit>();
                for (int i = 0; i < response.getResponses().length; ++i) {
                    MultiSearchResponse.Item itemResponse = response.getResponses()[i];
                    if (itemResponse.isFailure()) {
                        Exception e = itemResponse.getFailure();
                        if (e instanceof ClusterBlockException) {
                            for (ClusterBlock block : ((ClusterBlockException)e).blocks()) {
                                if (!"index closed".equals(block.description())) continue;
                                SearchRequest searchRequest = (SearchRequest)((MultiSearchRequest)msearch.request()).requests().get(i);
                                e = ExceptionsHelper.badRequestException((String)"Cannot create job [{}] as it requires closed index {}", (Object[])new Object[]{job.getId(), searchRequest.indices()});
                            }
                        }
                        listener.onFailure(e);
                        return;
                    }
                    searchHits.addAll(Arrays.asList(itemResponse.getResponse().getHits().getHits()));
                }
                if (searchHits.isEmpty()) {
                    listener.onResponse((Object)true);
                } else {
                    int quantileDocCount = 0;
                    int categorizerStateDocCount = 0;
                    int resultDocCount = 0;
                    for (SearchHit hit : searchHits) {
                        if (hit.getId().equals(Quantiles.documentId((String)job.getId())) || hit.getId().equals(Quantiles.v54DocumentId((String)job.getId()))) {
                            ++quantileDocCount;
                            continue;
                        }
                        if (hit.getId().startsWith(CategorizerState.documentPrefix((String)job.getId())) || hit.getId().startsWith(CategorizerState.v54DocumentPrefix((String)job.getId()))) {
                            ++categorizerStateDocCount;
                            continue;
                        }
                        ++resultDocCount;
                    }
                    LOGGER.warn("{} result, {} quantile state and {} categorizer state documents exist for a prior job with Id [{}]", (Object)resultDocCount, (Object)quantileDocCount, (Object)categorizerStateDocCount, (Object)job.getId());
                    listener.onFailure((Exception)ExceptionsHelper.conflictStatusException((String)("[" + resultDocCount + "] result and [" + (quantileDocCount + categorizerStateDocCount) + "] state documents exist for a prior job with Id [" + job.getId() + "]. Please create the job with a different Id"), (Object[])new Object[0]));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((MultiSearchRequest)msearch.request()), (ActionListener)searchResponseActionListener, (arg_0, arg_1) -> ((Client)this.client).multiSearch(arg_0, arg_1));
    }

    public void createJobResultIndex(Job job, ClusterState state, ActionListener<Boolean> finalListener) {
        List<String> termFields = job.getAnalysisConfig() != null ? job.getAnalysisConfig().termFields() : Collections.emptyList();
        String readAliasName = AnomalyDetectorsIndex.jobResultsAliasedName((String)job.getId());
        String writeAliasName = AnomalyDetectorsIndex.resultsWriteAlias((String)job.getId());
        String tempIndexName = job.getInitialResultsIndexName();
        if (state.getMetaData().hasAlias(tempIndexName)) {
            IndexNameExpressionResolver resolver = new IndexNameExpressionResolver();
            String[] concreteIndices = resolver.concreteIndexNames(state, IndicesOptions.lenientExpandOpen(), new String[]{tempIndexName});
            if (concreteIndices.length == 0) {
                finalListener.onFailure((Exception)ExceptionsHelper.badRequestException((String)"Cannot create job [{}] as it requires closed index {}", (Object[])new Object[]{job.getId(), tempIndexName}));
                return;
            }
            tempIndexName = concreteIndices[0];
        }
        String indexName = tempIndexName;
        ActionListener createAliasListener = ActionListener.wrap(success -> {
            IndicesAliasesRequest request = (IndicesAliasesRequest)this.client.admin().indices().prepareAliases().addAlias(indexName, readAliasName, (QueryBuilder)QueryBuilders.termQuery((String)Job.ID.getPreferredName(), (String)job.getId())).addAlias(indexName, writeAliasName).request();
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)request, (ActionListener)ActionListener.wrap(r -> finalListener.onResponse((Object)true), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).aliases(arg_0, arg_1));
        }, arg_0 -> finalListener.onFailure(arg_0));
        if (!state.getMetaData().hasIndex(indexName)) {
            LOGGER.trace("ES API CALL: create index {}", (Object)indexName);
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
            try (XContentBuilder termFieldsMapping = ElasticsearchMappings.termFieldsMapping(termFields);){
                createIndexRequest.mapping("_doc", termFieldsMapping);
            }
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)createIndexRequest, (ActionListener)ActionListener.wrap(r -> createAliasListener.onResponse((Object)r.isAcknowledged()), e -> {
                if (e instanceof ResourceAlreadyExistsException) {
                    LOGGER.info("Index already exists");
                    this.getLatestIndexMappings(indexName, (ActionListener<GetMappingsResponse>)ActionListener.wrap(response -> {
                        ImmutableOpenMap indexMappings = (ImmutableOpenMap)((ObjectObjectCursor)response.getMappings().iterator().next()).value;
                        MappingMetaData typeMappings = (MappingMetaData)((ObjectObjectCursor)indexMappings.iterator().next()).value;
                        this.addTermsAndAliases(typeMappings, indexName, termFields, (ActionListener<Boolean>)createAliasListener);
                    }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)));
                } else {
                    finalListener.onFailure(e);
                }
            }), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).create(arg_0, arg_1));
        } else {
            MappingMetaData mapping = state.metaData().index(indexName).mapping();
            this.addTermsAndAliases(mapping, indexName, termFields, (ActionListener<Boolean>)createAliasListener);
        }
    }

    private void getLatestIndexMappings(String indexName, ActionListener<GetMappingsResponse> listener) {
        GetMappingsRequest getMappingsRequest = (GetMappingsRequest)this.client.admin().indices().prepareGetMappings(new String[]{indexName}).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)getMappingsRequest, listener, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).getMappings(arg_0, arg_1));
    }

    private void addTermsAndAliases(MappingMetaData mapping, String indexName, Collection<String> termFields, ActionListener<Boolean> listener) {
        long fieldCountLimit = (Long)MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.get(this.settings);
        if (JobResultsProvider.violatedFieldCountLimit(termFields.size(), fieldCountLimit, mapping)) {
            String message = "Cannot create job in index '" + indexName + "' as the " + MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey() + " setting will be violated";
            listener.onFailure((Exception)new IllegalArgumentException(message));
        } else {
            this.updateIndexMappingWithTermFields(indexName, mapping.type(), termFields, listener);
        }
    }

    public static boolean violatedFieldCountLimit(long additionalFieldCount, long fieldCountLimit, MappingMetaData mapping) {
        long numFields = JobResultsProvider.countFields(mapping.sourceAsMap());
        return numFields + additionalFieldCount > fieldCountLimit;
    }

    public static int countFields(Map<String, Object> mapping) {
        Object propertiesNode = mapping.get("properties");
        if (propertiesNode == null || !(propertiesNode instanceof Map)) {
            return 0;
        }
        mapping = (Map)propertiesNode;
        int count = 0;
        for (Map.Entry entry : mapping.entrySet()) {
            if (entry.getValue() instanceof Map) {
                Map fieldMapping = (Map)entry.getValue();
                count += JobResultsProvider.countFields(fieldMapping);
            }
            ++count;
        }
        return count;
    }

    private void updateIndexMappingWithTermFields(String indexName, String mappingType, Collection<String> termFields, final ActionListener<Boolean> listener) {
        try (XContentBuilder termFieldsMapping = ElasticsearchMappings.resultsMapping((String)mappingType, termFields);){
            PutMappingRequest request = (PutMappingRequest)this.client.admin().indices().preparePutMapping(new String[]{indexName}).setType(mappingType).setSource(termFieldsMapping).request();
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse putMappingResponse) {
                    listener.onResponse((Object)putMappingResponse.isAcknowledged());
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putMapping(arg_0, arg_1));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    public void dataCounts(String jobId, Consumer<DataCounts> handler, Consumer<Exception> errorHandler) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        this.searchSingleResult(jobId, DataCounts.TYPE.getPreferredName(), this.createLatestDataCountsSearch(indexName, jobId), (BiFunction)DataCounts.PARSER, result -> handler.accept((DataCounts)result.result), errorHandler, () -> new DataCounts(jobId));
    }

    private SearchRequestBuilder createLatestDataCountsSearch(String indexName, String jobId) {
        return this.client.prepareSearch(new String[]{indexName}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{DataCounts.documentId((String)jobId), DataCounts.v54DocumentId((String)jobId)})).addSort(SortBuilders.fieldSort((String)DataCounts.LATEST_RECORD_TIME.getPreferredName()).order(SortOrder.DESC));
    }

    public void getAutodetectParams(Job job, Consumer<AutodetectParams> consumer, Consumer<Exception> errorHandler) {
        String jobId = job.getId();
        ActionListener getScheduledEventsListener = ActionListener.wrap(paramsBuilder -> {
            ScheduledEventsQueryBuilder scheduledEventsQueryBuilder = new ScheduledEventsQueryBuilder();
            scheduledEventsQueryBuilder.start(job.earliestValidTimestamp(paramsBuilder.getDataCounts()));
            this.scheduledEventsForJob(jobId, job.getGroups(), scheduledEventsQueryBuilder, (ActionListener<QueryPage<ScheduledEvent>>)ActionListener.wrap(events -> {
                paramsBuilder.setScheduledEvents(events.results());
                consumer.accept(paramsBuilder.build());
            }, (Consumer)errorHandler));
        }, errorHandler);
        AutodetectParams.Builder paramsBuilder2 = new AutodetectParams.Builder(job.getId());
        String resultsIndex = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        String stateIndex = AnomalyDetectorsIndex.jobStateIndexPattern();
        MultiSearchRequestBuilder msearch = this.client.prepareMultiSearch().add(this.createLatestDataCountsSearch(resultsIndex, jobId)).add(this.createLatestModelSizeStatsSearch(resultsIndex)).add(this.createDocIdSearch(resultsIndex, ModelSnapshot.documentId((String)jobId, (String)job.getModelSnapshotId()))).add(this.createDocIdSearch(stateIndex, Quantiles.documentId((String)jobId)));
        for (String filterId : job.getAnalysisConfig().extractReferencedFilters()) {
            msearch.add(this.createDocIdSearch(".ml-meta", MlFilter.documentId((String)filterId)));
        }
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((MultiSearchRequest)msearch.request()), (ActionListener)ActionListener.wrap(response -> {
            for (int i = 0; i < response.getResponses().length; ++i) {
                MultiSearchResponse.Item itemResponse = response.getResponses()[i];
                if (itemResponse.isFailure()) {
                    errorHandler.accept(itemResponse.getFailure());
                    continue;
                }
                SearchResponse searchResponse = itemResponse.getResponse();
                Object[] shardFailures = searchResponse.getShardFailures();
                int unavailableShards = searchResponse.getTotalShards() - searchResponse.getSuccessfulShards();
                if (shardFailures != null && shardFailures.length > 0) {
                    LOGGER.error("[{}] Search request returned shard failures: {}", (Object)jobId, (Object)Arrays.toString(shardFailures));
                    errorHandler.accept((Exception)new ElasticsearchException(ExceptionsHelper.shardFailuresToErrorMsg((String)jobId, (ShardSearchFailure[])shardFailures), new Object[0]));
                    continue;
                }
                if (unavailableShards > 0) {
                    errorHandler.accept((Exception)new ElasticsearchException("[" + jobId + "] Search request encountered [" + unavailableShards + "] unavailable shards", new Object[0]));
                    continue;
                }
                SearchHits hits = searchResponse.getHits();
                long hitsCount = hits.getHits().length;
                if (hitsCount == 0L) {
                    SearchRequest searchRequest = (SearchRequest)((MultiSearchRequest)msearch.request()).requests().get(i);
                    LOGGER.debug("Found 0 hits for [{}]", new Object[]{searchRequest.indices()});
                    continue;
                }
                for (SearchHit hit : hits) {
                    this.parseAutodetectParamSearchHit(jobId, paramsBuilder2, hit, errorHandler);
                }
            }
            getScheduledEventsListener.onResponse((Object)paramsBuilder2);
        }, errorHandler), (arg_0, arg_1) -> ((Client)this.client).multiSearch(arg_0, arg_1));
    }

    private SearchRequestBuilder createDocIdSearch(String index, String id) {
        return this.client.prepareSearch(new String[]{index}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{id})).setRouting(id);
    }

    private void parseAutodetectParamSearchHit(String jobId, AutodetectParams.Builder paramsBuilder, SearchHit hit, Consumer<Exception> errorHandler) {
        String hitId = hit.getId();
        if (DataCounts.documentId((String)jobId).equals(hitId)) {
            paramsBuilder.setDataCounts((DataCounts)this.parseSearchHit(hit, (BiFunction)DataCounts.PARSER, errorHandler));
        } else if (hitId.startsWith(ModelSizeStats.documentIdPrefix((String)jobId))) {
            ModelSizeStats.Builder modelSizeStats = (ModelSizeStats.Builder)this.parseSearchHit(hit, (BiFunction)ModelSizeStats.LENIENT_PARSER, errorHandler);
            paramsBuilder.setModelSizeStats(modelSizeStats == null ? null : modelSizeStats.build());
        } else if (hitId.startsWith(ModelSnapshot.documentIdPrefix((String)jobId))) {
            ModelSnapshot.Builder modelSnapshot = (ModelSnapshot.Builder)this.parseSearchHit(hit, (BiFunction)ModelSnapshot.LENIENT_PARSER, errorHandler);
            paramsBuilder.setModelSnapshot(modelSnapshot == null ? null : modelSnapshot.build());
        } else if (Quantiles.documentId((String)jobId).equals(hit.getId())) {
            paramsBuilder.setQuantiles((Quantiles)this.parseSearchHit(hit, (BiFunction)Quantiles.LENIENT_PARSER, errorHandler));
        } else if (hitId.startsWith("filter_")) {
            paramsBuilder.addFilter(((MlFilter.Builder)this.parseSearchHit(hit, (BiFunction)MlFilter.LENIENT_PARSER, errorHandler)).build());
        } else {
            errorHandler.accept(new IllegalStateException("Unexpected Id [" + hitId + "]"));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T, U> T parseSearchHit(SearchHit hit, BiFunction<XContentParser, U, T> objectParser, Consumer<Exception> errorHandler) {
        BytesReference source = hit.getSourceRef();
        try (StreamInput stream = source.streamInput();){
            XContentParser xContentParser;
            block14: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    xContentParser = objectParser.apply(parser, null);
                    if (parser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return (T)xContentParser;
        }
        catch (IOException e) {
            errorHandler.accept((Exception)new ElasticsearchParseException("failed to parse " + hit.getId(), (Throwable)e, new Object[0]));
            return null;
        }
    }

    public void bucketsViaInternalClient(String jobId, BucketsQueryBuilder query, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler) {
        this.buckets(jobId, query, handler, errorHandler, this.client);
    }

    public void buckets(String jobId, BucketsQueryBuilder query, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler, Client client) throws ResourceNotFoundException {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.source(query.build().trackTotalHits(true));
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            SearchHits hits = searchResponse.getHits();
            ArrayList<Bucket> results = new ArrayList<Bucket>();
            for (SearchHit hit : hits.getHits()) {
                BytesReference source = hit.getSourceRef();
                try (StreamInput stream = source.streamInput();
                     XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                    Bucket bucket2 = (Bucket)Bucket.LENIENT_PARSER.apply(parser, null);
                    results.add(bucket2);
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse bucket", (Throwable)e, new Object[0]);
                }
            }
            if (query.hasTimestamp() && results.isEmpty()) {
                throw QueryPage.emptyQueryPage((ParseField)Bucket.RESULTS_FIELD);
            }
            QueryPage buckets = new QueryPage(results, searchResponse.getHits().getTotalHits().value, Bucket.RESULTS_FIELD);
            if (query.isExpand()) {
                Iterator<Bucket> bucketsToExpand = buckets.results().stream().filter(bucket -> bucket.getBucketInfluencers().size() > 0).iterator();
                this.expandBuckets(jobId, query, (QueryPage<Bucket>)buckets, bucketsToExpand, handler, errorHandler, client);
            } else {
                handler.accept(buckets);
            }
        }, e -> errorHandler.accept(JobResultsProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/buckets/get"))), (arg_0, arg_1) -> ((Client)client).search(arg_0, arg_1));
    }

    private void expandBuckets(String jobId, BucketsQueryBuilder query, QueryPage<Bucket> buckets, Iterator<Bucket> bucketsToExpand, Consumer<QueryPage<Bucket>> handler, Consumer<Exception> errorHandler, Client client) {
        if (bucketsToExpand.hasNext()) {
            Consumer<Integer> c = i -> this.expandBuckets(jobId, query, buckets, bucketsToExpand, handler, errorHandler, client);
            this.expandBucket(jobId, query.isIncludeInterim(), bucketsToExpand.next(), c, errorHandler, client);
        } else {
            handler.accept(buckets);
        }
    }

    public BatchedResultsIterator<Bucket> newBatchedBucketsIterator(String jobId) {
        return new BatchedBucketsIterator(ClientHelper.clientWithOrigin((Client)this.client, (String)"ml"), jobId);
    }

    public BatchedResultsIterator<AnomalyRecord> newBatchedRecordsIterator(String jobId) {
        return new BatchedRecordsIterator(ClientHelper.clientWithOrigin((Client)this.client, (String)"ml"), jobId);
    }

    public void expandBucket(String jobId, boolean includeInterim, Bucket bucket, Consumer<Integer> consumer, Consumer<Exception> errorHandler, Client client) {
        Consumer<QueryPage<AnomalyRecord>> h = page -> {
            bucket.getRecords().addAll(page.results());
            consumer.accept(bucket.getRecords().size());
        };
        this.bucketRecords(jobId, bucket, 0, 10000, includeInterim, AnomalyRecord.PROBABILITY.getPreferredName(), false, h, errorHandler, client);
    }

    public void bucketRecords(String jobId, Bucket bucket, int from, int size, boolean includeInterim, String sortField, boolean descending, Consumer<QueryPage<AnomalyRecord>> handler, Consumer<Exception> errorHandler, Client client) {
        RecordsQueryBuilder recordsQueryBuilder = new RecordsQueryBuilder().timestamp(bucket.getTimestamp()).from(from).size(size).includeInterim(includeInterim).sortField(sortField).sortDescending(descending);
        this.records(jobId, recordsQueryBuilder, handler, errorHandler, client);
    }

    public void categoryDefinitions(String jobId, Long categoryId, boolean augment, Integer from, Integer size, Consumer<QueryPage<CategoryDefinition>> handler, Consumer<Exception> errorHandler, Client client) {
        if (categoryId != null && (from != null || size != null)) {
            throw new IllegalStateException("Both categoryId and pageParams are specified");
        }
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        LOGGER.trace("ES API CALL: search all of category definitions from index {} sort ascending {} from {} size {}", (Object)indexName, (Object)CategoryDefinition.CATEGORY_ID.getPreferredName(), (Object)from, (Object)size);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(searchRequest.indicesOptions()));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        if (categoryId != null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)CategoryDefinition.CATEGORY_ID.getPreferredName(), (Object)categoryId));
        } else if (from != null && size != null) {
            sourceBuilder.from(from.intValue()).size(size.intValue()).query((QueryBuilder)QueryBuilders.existsQuery((String)CategoryDefinition.CATEGORY_ID.getPreferredName())).sort(new FieldSortBuilder(CategoryDefinition.CATEGORY_ID.getPreferredName()).order(SortOrder.ASC));
        } else {
            throw new IllegalStateException("Both categoryId and pageParams are not specified");
        }
        sourceBuilder.trackTotalHits(true);
        searchRequest.source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            SearchHit[] hits = searchResponse.getHits().getHits();
            ArrayList<CategoryDefinition> results = new ArrayList<CategoryDefinition>(hits.length);
            for (SearchHit hit : hits) {
                BytesReference source = hit.getSourceRef();
                try (StreamInput stream = source.streamInput();
                     XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                    CategoryDefinition categoryDefinition = (CategoryDefinition)CategoryDefinition.LENIENT_PARSER.apply(parser, null);
                    if (augment) {
                        this.augmentWithGrokPattern(categoryDefinition);
                    }
                    results.add(categoryDefinition);
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse category definition", (Throwable)e, new Object[0]);
                }
            }
            QueryPage result = new QueryPage(results, searchResponse.getHits().getTotalHits().value, CategoryDefinition.RESULTS_FIELD);
            handler.accept(result);
        }, e -> errorHandler.accept(JobResultsProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/categories/get"))), (arg_0, arg_1) -> ((Client)client).search(arg_0, arg_1));
    }

    void augmentWithGrokPattern(CategoryDefinition categoryDefinition) {
        List examples = categoryDefinition.getExamples();
        String regex = categoryDefinition.getRegex();
        if (examples.isEmpty() || regex.isEmpty()) {
            categoryDefinition.setGrokPattern("");
        } else {
            categoryDefinition.setGrokPattern(GrokPatternCreator.findBestGrokMatchFromExamples(categoryDefinition.getJobId(), regex, examples));
        }
    }

    public void records(String jobId, RecordsQueryBuilder recordsQueryBuilder, Consumer<QueryPage<AnomalyRecord>> handler, Consumer<Exception> errorHandler, Client client) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        SearchSourceBuilder searchSourceBuilder = recordsQueryBuilder.build();
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(searchRequest.indicesOptions()));
        searchRequest.source(recordsQueryBuilder.build().trackTotalHits(true));
        LOGGER.trace("ES API CALL: search all of records from index {} with query {}", (Object)indexName, (Object)searchSourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            ArrayList<AnomalyRecord> results = new ArrayList<AnomalyRecord>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                BytesReference source = hit.getSourceRef();
                try (StreamInput stream = source.streamInput();
                     XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                    results.add((AnomalyRecord)AnomalyRecord.LENIENT_PARSER.apply(parser, null));
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse records", (Throwable)e, new Object[0]);
                }
            }
            QueryPage queryPage = new QueryPage(results, searchResponse.getHits().getTotalHits().value, AnomalyRecord.RESULTS_FIELD);
            handler.accept(queryPage);
        }, e -> errorHandler.accept(JobResultsProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/records/get"))), (arg_0, arg_1) -> ((Client)client).search(arg_0, arg_1));
    }

    public void influencers(String jobId, InfluencersQueryBuilder.InfluencersQuery query, Consumer<QueryPage<Influencer>> handler, Consumer<Exception> errorHandler, Client client) {
        QueryBuilder fb = new ResultsFilterBuilder().timeRange(Result.TIMESTAMP.getPreferredName(), query.getStart(), query.getEnd()).score(Influencer.INFLUENCER_SCORE.getPreferredName(), query.getInfluencerScoreFilter()).interim(query.isIncludeInterim()).build();
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        org.apache.logging.log4j.util.Supplier[] supplierArray = new org.apache.logging.log4j.util.Supplier[4];
        supplierArray[0] = () -> indexName;
        supplierArray[1] = () -> query.getSortField() != null ? " with sort " + (query.isSortDescending() ? "descending" : "ascending") + " on field " + query.getSortField() : "";
        supplierArray[2] = query::getFrom;
        supplierArray[3] = query::getSize;
        LOGGER.trace("ES API CALL: search all of influencers from index {}{}  with filter from {} size {}", supplierArray);
        BoolQueryBuilder qb = new BoolQueryBuilder().filter(fb).filter((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"influencer"}));
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(searchRequest.indicesOptions()));
        FieldSortBuilder sb = query.getSortField() == null ? SortBuilders.fieldSort((String)"_doc") : (FieldSortBuilder)new FieldSortBuilder(query.getSortField()).order(query.isSortDescending() ? SortOrder.DESC : SortOrder.ASC);
        searchRequest.source(new SearchSourceBuilder().query((QueryBuilder)qb).from(query.getFrom()).size(query.getSize()).sort((SortBuilder)sb).trackTotalHits(true));
        ClientHelper.executeAsyncWithOrigin((ThreadContext)client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            ArrayList<Influencer> influencers = new ArrayList<Influencer>();
            for (SearchHit hit : response.getHits().getHits()) {
                BytesReference source = hit.getSourceRef();
                try (StreamInput stream = source.streamInput();
                     XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                    influencers.add((Influencer)Influencer.LENIENT_PARSER.apply(parser, null));
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("failed to parse influencer", (Throwable)e, new Object[0]);
                }
            }
            QueryPage result = new QueryPage(influencers, response.getHits().getTotalHits().value, Influencer.RESULTS_FIELD);
            handler.accept(result);
        }, e -> errorHandler.accept(JobResultsProvider.mapAuthFailure(e, jobId, "cluster:monitor/xpack/ml/job/results/influencers/get"))), (arg_0, arg_1) -> ((Client)client).search(arg_0, arg_1));
    }

    public BatchedResultsIterator<Influencer> newBatchedInfluencersIterator(String jobId) {
        return new BatchedInfluencersIterator(ClientHelper.clientWithOrigin((Client)this.client, (String)"ml"), jobId);
    }

    public void getModelSnapshot(String jobId, @Nullable String modelSnapshotId, Consumer<Result<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        if (modelSnapshotId == null) {
            handler.accept(null);
            return;
        }
        String resultsIndex = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        SearchRequestBuilder search = this.createDocIdSearch(resultsIndex, ModelSnapshot.documentId((String)jobId, (String)modelSnapshotId));
        this.searchSingleResult(jobId, ModelSnapshot.TYPE.getPreferredName(), search, (BiFunction)ModelSnapshot.LENIENT_PARSER, result -> handler.accept(result.result == null ? null : new Result(result.index, (Object)((ModelSnapshot.Builder)result.result).build())), errorHandler, () -> null);
    }

    public void modelSnapshots(String jobId, int from, int size, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        this.modelSnapshots(jobId, from, size, null, true, (QueryBuilder)QueryBuilders.matchAllQuery(), handler, errorHandler);
    }

    public void modelSnapshots(String jobId, int from, int size, String startEpochMs, String endEpochMs, String sortField, boolean sortDescending, String snapshotId, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        ResultsFilterBuilder fb = new ResultsFilterBuilder();
        if (snapshotId != null && !snapshotId.isEmpty()) {
            fb.term(ModelSnapshotField.SNAPSHOT_ID.getPreferredName(), snapshotId);
        }
        QueryBuilder qb = fb.timeRange(Result.TIMESTAMP.getPreferredName(), startEpochMs, endEpochMs).build();
        this.modelSnapshots(jobId, from, size, sortField, sortDescending, qb, handler, errorHandler);
    }

    private void modelSnapshots(String jobId, int from, int size, String sortField, boolean sortDescending, QueryBuilder qb, Consumer<QueryPage<ModelSnapshot>> handler, Consumer<Exception> errorHandler) {
        if (Strings.isEmpty((CharSequence)sortField)) {
            sortField = ModelSnapshot.TIMESTAMP.getPreferredName();
        }
        BoolQueryBuilder finalQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)ModelSnapshot.SNAPSHOT_DOC_COUNT.getPreferredName())).must(qb);
        FieldSortBuilder sb = (FieldSortBuilder)new FieldSortBuilder(sortField).order(sortDescending ? SortOrder.DESC : SortOrder.ASC);
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        LOGGER.trace("ES API CALL: search all model snapshots from index {} sort ascending {} with filter after sort from {} size {}", (Object)indexName, (Object)sortField, (Object)from, (Object)size);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(searchRequest.indicesOptions()));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.sort((SortBuilder)sb);
        sourceBuilder.query((QueryBuilder)finalQuery);
        sourceBuilder.from(from);
        sourceBuilder.size(size);
        sourceBuilder.trackTotalHits(true);
        searchRequest.source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            ArrayList<ModelSnapshot> results = new ArrayList<ModelSnapshot>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                results.add(ModelSnapshot.fromJson((BytesReference)hit.getSourceRef()));
            }
            QueryPage result = new QueryPage(results, searchResponse.getHits().getTotalHits().value, ModelSnapshot.RESULTS_FIELD);
            handler.accept(result);
        }, errorHandler), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public QueryPage<ModelPlot> modelPlot(String jobId, int from, int size) {
        SearchResponse searchResponse;
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        LOGGER.trace("ES API CALL: search model plots from index {} from {} size {}", (Object)indexName, (Object)from, (Object)size);
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{indexName}).setIndicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS)).setQuery((QueryBuilder)new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"model_plot"})).setFrom(from).setSize(size).setTrackTotalHits(true).get();
        }
        ArrayList<ModelPlot> results = new ArrayList<ModelPlot>();
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            BytesReference source = hit.getSourceRef();
            try (StreamInput stream = source.streamInput();
                 XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                ModelPlot modelPlot = (ModelPlot)ModelPlot.LENIENT_PARSER.apply(parser, null);
                results.add(modelPlot);
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to parse modelPlot", (Throwable)e, new Object[0]);
            }
        }
        return new QueryPage(results, searchResponse.getHits().getTotalHits().value, ModelPlot.RESULTS_FIELD);
    }

    public void modelSizeStats(String jobId, Consumer<ModelSizeStats> handler, Consumer<Exception> errorHandler) {
        LOGGER.trace("ES API CALL: search latest {} for job {}", (Object)"model_size_stats", (Object)jobId);
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        this.searchSingleResult(jobId, "model_size_stats", this.createLatestModelSizeStatsSearch(indexName), (BiFunction)ModelSizeStats.LENIENT_PARSER, result -> handler.accept(((ModelSizeStats.Builder)result.result).build()), errorHandler, () -> new ModelSizeStats.Builder(jobId));
    }

    private <U, T> void searchSingleResult(String jobId, String resultDescription, SearchRequestBuilder search, BiFunction<XContentParser, U, T> objectParser, Consumer<Result<T>> handler, Consumer<Exception> errorHandler, Supplier<T> notFoundSupplier) {
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((SearchRequest)search.request()), (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits = response.getHits().getHits();
            if (hits.length == 0) {
                LOGGER.trace("No {} for job with id {}", (Object)resultDescription, (Object)jobId);
                handler.accept(new Result(null, notFoundSupplier.get()));
            } else if (hits.length == 1) {
                handler.accept(new Result(hits[0].getIndex(), this.parseSearchHit(hits[0], objectParser, errorHandler)));
            } else {
                errorHandler.accept(new IllegalStateException("Search for unique [" + resultDescription + "] returned [" + hits.length + "] hits even though size was 1"));
            }
        }, errorHandler), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    private SearchRequestBuilder createLatestModelSizeStatsSearch(String indexName) {
        return this.client.prepareSearch(new String[]{indexName}).setSize(1).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"model_size_stats")).addSort(SortBuilders.fieldSort((String)ModelSizeStats.LOG_TIME_FIELD.getPreferredName()).order(SortOrder.DESC));
    }

    public void getEstablishedMemoryUsage(String jobId, Date latestBucketTimestamp, ModelSizeStats latestModelSizeStats, Consumer<Long> handler, Consumer<Exception> errorHandler) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        Consumer<QueryPage<Bucket>> bucketHandler = buckets -> {
            if (buckets.results().size() == 1) {
                String searchFromTimeMs = Long.toString(((Bucket)buckets.results().get(0)).getTimestamp().getTime());
                SearchRequestBuilder search = this.client.prepareSearch(new String[]{indexName}).setSize(0).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setQuery((QueryBuilder)new BoolQueryBuilder().filter((QueryBuilder)QueryBuilders.rangeQuery((String)Result.TIMESTAMP.getPreferredName()).gte((Object)searchFromTimeMs)).filter((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"model_size_stats"))).addAggregation((AggregationBuilder)AggregationBuilders.extendedStats((String)"es").field(ModelSizeStats.MODEL_BYTES_FIELD.getPreferredName()));
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((SearchRequest)search.request()), (ActionListener)ActionListener.wrap(response -> {
                    List aggregations = response.getAggregations().asList();
                    if (aggregations.size() == 1) {
                        ExtendedStats extendedStats = (ExtendedStats)aggregations.get(0);
                        long count = extendedStats.getCount();
                        if (count <= 0L) {
                            this.handleLatestModelSizeStats(jobId, latestModelSizeStats, handler, errorHandler);
                        } else if (count == 1L) {
                            handler.accept((long)extendedStats.getAvg());
                        } else {
                            double coefficientOfVaration = extendedStats.getStdDeviation() / extendedStats.getAvg();
                            LOGGER.trace("[{}] Coefficient of variation [{}] when calculating established memory use", (Object)jobId, (Object)coefficientOfVaration);
                            if (coefficientOfVaration <= 0.1) {
                                this.handleLatestModelSizeStats(jobId, latestModelSizeStats, handler, errorHandler);
                            } else {
                                handler.accept(0L);
                            }
                        }
                    } else {
                        handler.accept(0L);
                    }
                }, (Consumer)errorHandler), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
            } else {
                LOGGER.trace("[{}] Insufficient history to calculate established memory use", (Object)jobId);
                handler.accept(0L);
            }
        };
        BucketsQueryBuilder bucketQuery = new BucketsQueryBuilder().end(latestBucketTimestamp != null ? Long.toString(latestBucketTimestamp.getTime() + 1L) : null).sortField(Result.TIMESTAMP.getPreferredName()).sortDescending(true).from(19).size(1).includeInterim(false);
        this.bucketsViaInternalClient(jobId, bucketQuery, bucketHandler, e -> {
            if (e instanceof ResourceNotFoundException) {
                handler.accept(0L);
            } else {
                errorHandler.accept((Exception)e);
            }
        });
    }

    public void scheduledEventsForJob(String jobId, List<String> jobGroups, ScheduledEventsQueryBuilder queryBuilder, ActionListener<QueryPage<ScheduledEvent>> handler) {
        ActionListener calendarsListener = ActionListener.wrap(calendars -> {
            if (calendars.results().isEmpty()) {
                handler.onResponse((Object)new QueryPage(Collections.emptyList(), 0L, ScheduledEvent.RESULTS_FIELD));
                return;
            }
            List<String> calendarIds = calendars.results().stream().map(Calendar::getId).collect(Collectors.toList());
            queryBuilder.calendarIds(calendarIds);
            this.scheduledEvents(queryBuilder, handler);
        }, arg_0 -> handler.onFailure(arg_0));
        CalendarQueryBuilder query = new CalendarQueryBuilder().jobId(jobId).jobGroups(jobGroups);
        this.calendars(query, (ActionListener<QueryPage<Calendar>>)calendarsListener);
    }

    public void scheduledEvents(ScheduledEventsQueryBuilder query, ActionListener<QueryPage<ScheduledEvent>> handler) {
        SearchRequestBuilder request = this.client.prepareSearch(new String[]{".ml-meta"}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setSource(query.build()).setTrackTotalHits(true);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)((SearchRequest)request.request()), (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits;
            ArrayList<ScheduledEvent> events = new ArrayList<ScheduledEvent>();
            for (SearchHit hit : hits = response.getHits().getHits()) {
                ScheduledEvent.Builder event = (ScheduledEvent.Builder)this.parseSearchHit(hit, (BiFunction)ScheduledEvent.LENIENT_PARSER, arg_0 -> ((ActionListener)handler).onFailure(arg_0));
                event.eventId(hit.getId());
                events.add(event.build());
            }
            handler.onResponse((Object)new QueryPage(events, response.getHits().getTotalHits().value, ScheduledEvent.RESULTS_FIELD));
        }, arg_0 -> handler.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void getForecastRequestStats(String jobId, String forecastId, Consumer<ForecastRequestStats> handler, Consumer<Exception> errorHandler) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        SearchRequestBuilder forecastSearch = this.client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{ForecastRequestStats.documentId((String)jobId, (String)forecastId)}));
        this.searchSingleResult(jobId, ForecastRequestStats.RESULTS_FIELD.getPreferredName(), forecastSearch, (BiFunction)ForecastRequestStats.LENIENT_PARSER, result -> handler.accept((ForecastRequestStats)result.result), errorHandler, () -> null);
    }

    public void getForecastStats(String jobId, Consumer<ForecastStats> handler, Consumer<Exception> errorHandler) {
        String indexName = AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId);
        TermsQueryBuilder termQuery = new TermsQueryBuilder(Result.RESULT_TYPE.getPreferredName(), new String[]{"model_forecast_request_stats"});
        TermsQueryBuilder jobQuery = new TermsQueryBuilder(Job.ID.getPreferredName(), new String[]{jobId});
        BoolQueryBuilder finalQuery = new BoolQueryBuilder().filter((QueryBuilder)termQuery).filter((QueryBuilder)jobQuery);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(searchRequest.indicesOptions()));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)finalQuery);
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.stats((String)"memory_bytes").field(ForecastRequestStats.MEMORY_USAGE.getPreferredName()));
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.stats((String)"records").field(ForecastRequestStats.PROCESSED_RECORD_COUNT.getPreferredName()));
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.stats((String)"processing_time_ms").field(ForecastRequestStats.PROCESSING_TIME_MS.getPreferredName()));
        sourceBuilder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"status").field(ForecastRequestStats.STATUS.getPreferredName()));
        sourceBuilder.size(0);
        sourceBuilder.trackTotalHits(true);
        searchRequest.source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            long totalHits = searchResponse.getHits().getTotalHits().value;
            Aggregations aggregations = searchResponse.getAggregations();
            if (totalHits == 0L || aggregations == null) {
                handler.accept(new ForecastStats());
                return;
            }
            Map aggregationsAsMap = aggregations.asMap();
            StatsAccumulator memoryStats = StatsAccumulator.fromStatsAggregation((Stats)((Stats)aggregationsAsMap.get("memory_bytes")));
            StatsAccumulator recordStats = StatsAccumulator.fromStatsAggregation((Stats)((Stats)aggregationsAsMap.get("records")));
            StatsAccumulator runtimeStats = StatsAccumulator.fromStatsAggregation((Stats)((Stats)aggregationsAsMap.get("processing_time_ms")));
            CountAccumulator statusCount = CountAccumulator.fromTermsAggregation((StringTerms)((StringTerms)aggregationsAsMap.get("status")));
            ForecastStats forecastStats = new ForecastStats(totalHits, memoryStats, recordStats, runtimeStats, statusCount);
            handler.accept(forecastStats);
        }, errorHandler), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void updateCalendar(String calendarId, Set<String> jobIdsToAdd, Set<String> jobIdsToRemove, Consumer<Calendar> handler, Consumer<Exception> errorHandler) {
        ActionListener getCalendarListener = ActionListener.wrap(calendar -> {
            HashSet currentJobs = new HashSet(calendar.getJobIds());
            for (String jobToRemove : jobIdsToRemove) {
                if (currentJobs.contains(jobToRemove)) continue;
                errorHandler.accept((Exception)ExceptionsHelper.badRequestException((String)("Cannot remove [" + jobToRemove + "] as it is not present in calendar [" + calendarId + "]"), (Object[])new Object[0]));
                return;
            }
            currentJobs.addAll(jobIdsToAdd);
            currentJobs.removeAll(jobIdsToRemove);
            Calendar updatedCalendar = new Calendar(calendar.getId(), new ArrayList(currentJobs), calendar.getDescription());
            UpdateRequest updateRequest = new UpdateRequest(".ml-meta", updatedCalendar.documentId());
            updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                updateRequest.doc(updatedCalendar.toXContent(builder, ToXContent.EMPTY_PARAMS));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to serialise calendar with id [" + updatedCalendar.getId() + "]", e);
            }
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)updateRequest, (ActionListener)ActionListener.wrap(response -> handler.accept(updatedCalendar), (Consumer)errorHandler), (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1));
        }, errorHandler);
        this.calendar(calendarId, (ActionListener<Calendar>)getCalendarListener);
    }

    public void calendars(CalendarQueryBuilder queryBuilder, ActionListener<QueryPage<Calendar>> listener) {
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{".ml-meta"}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setTrackTotalHits(true).setSource(queryBuilder.build()).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits;
            ArrayList<Calendar> calendars = new ArrayList<Calendar>();
            for (SearchHit hit : hits = response.getHits().getHits()) {
                calendars.add(((Calendar.Builder)this.parseSearchHit(hit, (BiFunction)Calendar.LENIENT_PARSER, arg_0 -> ((ActionListener)listener).onFailure(arg_0))).build());
            }
            listener.onResponse((Object)new QueryPage(calendars, response.getHits().getTotalHits().value, Calendar.RESULTS_FIELD));
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void removeJobFromCalendars(String jobId, ActionListener<Boolean> listener) {
        ActionListener updateCalandarsListener = ActionListener.wrap(r -> {
            if (r.hasFailures()) {
                listener.onResponse((Object)false);
            }
            listener.onResponse((Object)true);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener getCalendarsListener = ActionListener.wrap(r -> {
            BulkRequestBuilder bulkUpdate = this.client.prepareBulk();
            bulkUpdate.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            r.results().stream().map(c -> {
                HashSet ids = new HashSet(c.getJobIds());
                ids.remove(jobId);
                return new Calendar(c.getId(), new ArrayList(ids), c.getDescription());
            }).forEach(c -> {
                UpdateRequest updateRequest = new UpdateRequest(".ml-meta", c.documentId());
                try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                    updateRequest.doc(c.toXContent(builder, ToXContent.EMPTY_PARAMS));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to serialise calendar with id [" + c.getId() + "]", e);
                }
                bulkUpdate.add(updateRequest);
            });
            if (bulkUpdate.numberOfActions() > 0) {
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)BulkAction.INSTANCE, (ActionRequest)((BulkRequest)bulkUpdate.request()), (ActionListener)updateCalandarsListener);
            } else {
                listener.onResponse((Object)true);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        CalendarQueryBuilder query = new CalendarQueryBuilder().jobId(jobId);
        this.calendars(query, (ActionListener<QueryPage<Calendar>>)getCalendarsListener);
    }

    public void calendar(final String calendarId, final ActionListener<Calendar> listener) {
        GetRequest getRequest = new GetRequest(".ml-meta", Calendar.documentId((String)calendarId));
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getDocResponse) {
                block15: {
                    try {
                        if (getDocResponse.isExists()) {
                            BytesReference docSource = getDocResponse.getSourceAsBytesRef();
                            try (StreamInput stream = docSource.streamInput();
                                 XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                                Calendar calendar = ((Calendar.Builder)Calendar.LENIENT_PARSER.apply(parser, null)).build();
                                listener.onResponse((Object)calendar);
                                break block15;
                            }
                        }
                        this.onFailure((Exception)new ResourceNotFoundException("No calendar with id [" + calendarId + "]", new Object[0]));
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    listener.onFailure((Exception)new ResourceNotFoundException("No calendar with id [" + calendarId + "]", new Object[0]));
                } else {
                    listener.onFailure(e);
                }
            }
        }, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
    }

    private void handleLatestModelSizeStats(String jobId, ModelSizeStats latestModelSizeStats, Consumer<Long> handler, Consumer<Exception> errorHandler) {
        if (latestModelSizeStats != null) {
            handler.accept(latestModelSizeStats.getModelBytes());
        } else {
            this.modelSizeStats(jobId, modelSizeStats -> handler.accept(modelSizeStats.getModelBytes()), errorHandler);
        }
    }

    static Exception mapAuthFailure(Exception e, String jobId, String mappedActionName) {
        if (e instanceof ElasticsearchStatusException && ((ElasticsearchStatusException)e).status() == RestStatus.FORBIDDEN) {
            e = Exceptions.authorizationError((String)(e.getMessage().replaceFirst("action \\[.*?\\]", "action [" + mappedActionName + "]") + " for job [{}]"), (Object[])new Object[]{jobId});
        }
        return e;
    }
}

