/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;

public final class ExpandedIdsMatcher {
    public static String ALL = "_all";
    private final LinkedList<IdMatcher> requiredMatches = new LinkedList();

    public static String[] tokenizeExpression(String expression) {
        return Strings.tokenizeToStringArray((String)expression, (String)",");
    }

    public ExpandedIdsMatcher(String[] tokens, boolean allowNoMatchForWildcards) {
        if (Strings.isAllOrWildcard((String[])tokens)) {
            if (!allowNoMatchForWildcards) {
                this.requiredMatches.add(new WildcardMatcher("*"));
            }
            return;
        }
        if (allowNoMatchForWildcards) {
            for (String token : tokens) {
                if (Regex.isSimpleMatchPattern((String)token)) continue;
                this.requiredMatches.add(new EqualsIdMatcher(token));
            }
        } else {
            for (String token : tokens) {
                if (Regex.isSimpleMatchPattern((String)token)) {
                    this.requiredMatches.add(new WildcardMatcher(token));
                    continue;
                }
                this.requiredMatches.add(new EqualsIdMatcher(token));
            }
        }
    }

    public void filterMatchedIds(Collection<String> ids) {
        for (String id : ids) {
            Iterator itr = this.requiredMatches.iterator();
            if (!itr.hasNext()) break;
            while (itr.hasNext()) {
                if (!((IdMatcher)itr.next()).matches(id)) continue;
                itr.remove();
            }
        }
    }

    public boolean hasUnmatchedIds() {
        return !this.requiredMatches.isEmpty();
    }

    public List<String> unmatchedIds() {
        return this.requiredMatches.stream().map(IdMatcher::getId).collect(Collectors.toList());
    }

    public String unmatchedIdsString() {
        return this.requiredMatches.stream().map(IdMatcher::getId).collect(Collectors.joining(","));
    }

    private static class WildcardMatcher
    extends IdMatcher {
        WildcardMatcher(String id) {
            super(id);
        }

        @Override
        public boolean matches(String id) {
            return Regex.simpleMatch((String)this.id, (String)id);
        }
    }

    private static class EqualsIdMatcher
    extends IdMatcher {
        EqualsIdMatcher(String id) {
            super(id);
        }

        @Override
        public boolean matches(String id) {
            return this.id.equals(id);
        }
    }

    private static abstract class IdMatcher {
        protected final String id;

        IdMatcher(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public abstract boolean matches(String var1);
    }
}

