/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedJobValidator;
import org.elasticsearch.xpack.core.ml.job.config.DataDescription;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJob;
import org.elasticsearch.xpack.ml.datafeed.delayeddatacheck.DelayedDataDetector;
import org.elasticsearch.xpack.ml.datafeed.delayeddatacheck.DelayedDataDetectorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.BucketsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.notifications.Auditor;

public class DatafeedJobBuilder {
    private final Client client;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private final Auditor auditor;
    private final Supplier<Long> currentTimeSupplier;

    public DatafeedJobBuilder(Client client, Settings settings, NamedXContentRegistry xContentRegistry, Auditor auditor, Supplier<Long> currentTimeSupplier) {
        this.client = client;
        this.settings = Objects.requireNonNull(settings);
        this.xContentRegistry = Objects.requireNonNull(xContentRegistry);
        this.auditor = Objects.requireNonNull(auditor);
        this.currentTimeSupplier = Objects.requireNonNull(currentTimeSupplier);
    }

    void build(String datafeedId, ActionListener<DatafeedJob> listener) {
        JobResultsProvider jobResultsProvider = new JobResultsProvider(this.client, this.settings);
        JobConfigProvider jobConfigProvider = new JobConfigProvider(this.client, this.xContentRegistry);
        DatafeedConfigProvider datafeedConfigProvider = new DatafeedConfigProvider(this.client, this.xContentRegistry);
        this.build(datafeedId, jobResultsProvider, jobConfigProvider, datafeedConfigProvider, listener);
    }

    void build(String datafeedId, JobResultsProvider jobResultsProvider, JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider, ActionListener<DatafeedJob> listener) {
        AtomicReference jobHolder = new AtomicReference();
        AtomicReference datafeedConfigHolder = new AtomicReference();
        Consumer<Context> contextHanlder = context -> {
            TimeValue frequency = DatafeedJobBuilder.getFrequencyOrDefault((DatafeedConfig)datafeedConfigHolder.get(), (Job)jobHolder.get(), this.xContentRegistry);
            TimeValue queryDelay = ((DatafeedConfig)datafeedConfigHolder.get()).getQueryDelay();
            DelayedDataDetector delayedDataDetector = DelayedDataDetectorFactory.buildDetector((Job)jobHolder.get(), (DatafeedConfig)datafeedConfigHolder.get(), this.client, this.xContentRegistry);
            DatafeedJob datafeedJob = new DatafeedJob(((Job)jobHolder.get()).getId(), DatafeedJobBuilder.buildDataDescription((Job)jobHolder.get()), frequency.millis(), queryDelay.millis(), context.dataExtractorFactory, this.client, this.auditor, this.currentTimeSupplier, delayedDataDetector, context.latestFinalBucketEndMs, context.latestRecordTimeMs);
            listener.onResponse((Object)datafeedJob);
        };
        Context context2 = new Context();
        ActionListener dataExtractorFactoryHandler = ActionListener.wrap(dataExtractorFactory -> {
            context.dataExtractorFactory = dataExtractorFactory;
            contextHanlder.accept(context2);
        }, e -> {
            this.auditor.error(((Job)jobHolder.get()).getId(), e.getMessage());
            listener.onFailure(e);
        });
        Consumer<DataCounts> dataCountsHandler = dataCounts -> {
            if (dataCounts.getLatestRecordTimeStamp() != null) {
                context.latestRecordTimeMs = dataCounts.getLatestRecordTimeStamp().getTime();
            }
            DataExtractorFactory.create(this.client, (DatafeedConfig)datafeedConfigHolder.get(), (Job)jobHolder.get(), this.xContentRegistry, (ActionListener<DataExtractorFactory>)dataExtractorFactoryHandler);
        };
        Consumer<QueryPage> bucketsHandler = buckets -> {
            if (buckets.results().size() == 1) {
                TimeValue bucketSpan = ((Job)jobHolder.get()).getAnalysisConfig().getBucketSpan();
                context.latestFinalBucketEndMs = ((Bucket)buckets.results().get(0)).getTimestamp().getTime() + bucketSpan.millis() - 1L;
            }
            jobResultsProvider.dataCounts(((Job)jobHolder.get()).getId(), dataCountsHandler, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
        };
        Consumer<String> jobIdConsumer = jobId -> {
            BucketsQueryBuilder latestBucketQuery = new BucketsQueryBuilder().sortField(Result.TIMESTAMP.getPreferredName()).sortDescending(true).size(1).includeInterim(false);
            jobResultsProvider.bucketsViaInternalClient((String)jobId, latestBucketQuery, (Consumer<QueryPage<Bucket>>)bucketsHandler, e -> {
                if (e instanceof ResourceNotFoundException) {
                    QueryPage empty = new QueryPage(Collections.emptyList(), 0L, Bucket.RESULT_TYPE_FIELD);
                    bucketsHandler.accept(empty);
                } else {
                    listener.onFailure(e);
                }
            });
        };
        ActionListener jobConfigListener = ActionListener.wrap(jobBuilder -> {
            try {
                jobHolder.set(jobBuilder.build());
                DatafeedJobValidator.validate((DatafeedConfig)((DatafeedConfig)datafeedConfigHolder.get()), (Job)((Job)jobHolder.get()), (NamedXContentRegistry)this.xContentRegistry);
                jobIdConsumer.accept(((Job)jobHolder.get()).getId());
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener datafeedConfigListener = ActionListener.wrap(configBuilder -> {
            try {
                datafeedConfigHolder.set(configBuilder.build());
                jobConfigProvider.getJob(((DatafeedConfig)datafeedConfigHolder.get()).getJobId(), (ActionListener<Job.Builder>)jobConfigListener);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        datafeedConfigProvider.getDatafeedConfig(datafeedId, (ActionListener<DatafeedConfig.Builder>)datafeedConfigListener);
    }

    private static TimeValue getFrequencyOrDefault(DatafeedConfig datafeed, Job job, NamedXContentRegistry xContentRegistry) {
        TimeValue frequency = datafeed.getFrequency();
        if (frequency == null) {
            TimeValue bucketSpan = job.getAnalysisConfig().getBucketSpan();
            return datafeed.defaultFrequency(bucketSpan, xContentRegistry);
        }
        return frequency;
    }

    private static DataDescription buildDataDescription(Job job) {
        DataDescription.Builder dataDescription = new DataDescription.Builder();
        dataDescription.setFormat(DataDescription.DataFormat.XCONTENT);
        if (job.getDataDescription() != null) {
            dataDescription.setTimeField(job.getDataDescription().getTimeField());
        }
        dataDescription.setTimeFormat("epoch_ms");
        return dataDescription.build();
    }

    private static class Context {
        volatile long latestFinalBucketEndMs = -1L;
        volatile long latestRecordTimeMs = -1L;
        volatile DataExtractorFactory dataExtractorFactory;

        private Context() {
        }
    }
}

