/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.PostCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;

public class TransportPostCalendarEventsAction
extends HandledTransportAction<PostCalendarEventsAction.Request, PostCalendarEventsAction.Response> {
    private final Client client;
    private final JobResultsProvider jobResultsProvider;
    private final JobManager jobManager;

    @Inject
    public TransportPostCalendarEventsAction(TransportService transportService, ActionFilters actionFilters, Client client, JobResultsProvider jobResultsProvider, JobManager jobManager) {
        super("cluster:admin/xpack/ml/calendars/events/post", transportService, actionFilters, PostCalendarEventsAction.Request::new);
        this.client = client;
        this.jobResultsProvider = jobResultsProvider;
        this.jobManager = jobManager;
    }

    protected void doExecute(Task task, PostCalendarEventsAction.Request request, final ActionListener<PostCalendarEventsAction.Response> listener) {
        final List events = request.getScheduledEvents();
        ActionListener calendarListener = ActionListener.wrap(calendar -> {
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            for (ScheduledEvent event : events) {
                IndexRequest indexRequest = new IndexRequest(".ml-meta");
                try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                    indexRequest.source(event.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("include_type", "true"))));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to serialise event", e);
                }
                bulkRequestBuilder.add(indexRequest);
            }
            bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)BulkAction.INSTANCE, (ActionRequest)((BulkRequest)bulkRequestBuilder.request()), (ActionListener)new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse response) {
                    TransportPostCalendarEventsAction.this.jobManager.updateProcessOnCalendarChanged(calendar.getJobIds(), (ActionListener<Boolean>)ActionListener.wrap(r -> listener.onResponse((Object)new PostCalendarEventsAction.Response(events)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                }

                public void onFailure(Exception e) {
                    listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"Error indexing event", (Throwable)e)));
                }
            });
        }, arg_0 -> listener.onFailure(arg_0));
        this.jobResultsProvider.calendar(request.getCalendarId(), (ActionListener<Calendar>)calendarListener);
    }
}

