/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.JobTaskRequest;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;

public abstract class TransportJobTaskAction<Request extends JobTaskRequest<Request>, Response extends BaseTasksResponse>
extends TransportTasksAction<TransportOpenJobAction.JobTask, Request, Response, Response> {
    protected final AutodetectProcessManager processManager;

    TransportJobTaskAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader, Writeable.Reader<Response> responseReader, String nodeExecutor, AutodetectProcessManager processManager) {
        super(actionName, clusterService, transportService, actionFilters, requestReader, responseReader, responseReader, nodeExecutor);
        this.processManager = processManager;
    }

    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        PersistentTasksCustomMetaData tasks;
        String jobId = request.getJobId();
        PersistentTasksCustomMetaData.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetaData)(tasks = (PersistentTasksCustomMetaData)this.clusterService.state().getMetaData().custom("persistent_tasks")));
        if (jobTask == null || !jobTask.isAssigned()) {
            String message = "Cannot perform requested action because job [" + jobId + "] is not open";
            listener.onFailure((Exception)((Object)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)message, (Object[])new Object[0])));
        } else {
            request.setNodes(new String[]{jobTask.getExecutorNode()});
            super.doExecute(task, request, listener);
        }
    }

    protected Response newResponse(Request request, List<Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return TransportJobTaskAction.selectFirst(tasks, taskOperationFailures, failedNodeExceptions);
    }

    static <Response extends BaseTasksResponse> Response selectFirst(List<Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (tasks.isEmpty()) {
            if (!taskOperationFailures.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
            }
            throw new IllegalStateException("No errors or response");
        }
        if (tasks.size() > 1) {
            throw new IllegalStateException("Expected one node level response, but got [" + tasks.size() + "]");
        }
        return (Response)((BaseTasksResponse)tasks.get(0));
    }
}

