/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.HashSet;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.GetOverallBucketsAction;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.OverallBucket;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.Intervals;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.BucketsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.overallbuckets.OverallBucketsAggregator;
import org.elasticsearch.xpack.ml.job.persistence.overallbuckets.OverallBucketsCollector;
import org.elasticsearch.xpack.ml.job.persistence.overallbuckets.OverallBucketsProcessor;
import org.elasticsearch.xpack.ml.job.persistence.overallbuckets.OverallBucketsProvider;
import org.elasticsearch.xpack.ml.utils.MlIndicesUtils;

public class TransportGetOverallBucketsAction
extends HandledTransportAction<GetOverallBucketsAction.Request, GetOverallBucketsAction.Response> {
    private static final String EARLIEST_TIME = "earliest_time";
    private static final String LATEST_TIME = "latest_time";
    private final ThreadPool threadPool;
    private final Client client;
    private final ClusterService clusterService;
    private final JobManager jobManager;

    @Inject
    public TransportGetOverallBucketsAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, JobManager jobManager, Client client) {
        super("cluster:monitor/xpack/ml/job/results/overall_buckets/get", transportService, actionFilters, GetOverallBucketsAction.Request::new);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        this.jobManager = jobManager;
    }

    protected void doExecute(Task task, GetOverallBucketsAction.Request request, ActionListener<GetOverallBucketsAction.Response> listener) {
        this.jobManager.expandJobs(request.getJobId(), request.allowNoJobs(), (ActionListener<QueryPage<Job>>)ActionListener.wrap(jobPage -> {
            if (jobPage.count() == 0L) {
                listener.onResponse((Object)new GetOverallBucketsAction.Response());
                return;
            }
            this.threadPool.executor("ml_utility").execute(() -> {
                try {
                    this.getOverallBuckets(request, jobPage.results(), listener);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            });
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void getOverallBuckets(GetOverallBucketsAction.Request request, List<Job> jobs, ActionListener<GetOverallBucketsAction.Response> listener) {
        JobsContext jobsContext = JobsContext.build(jobs, request);
        ActionListener overallBucketsListener = ActionListener.wrap(overallBuckets -> listener.onResponse((Object)new GetOverallBucketsAction.Response(new QueryPage(overallBuckets, (long)overallBuckets.size(), OverallBucket.RESULTS_FIELD))), arg_0 -> listener.onFailure(arg_0));
        ActionListener chunkedBucketSearcherListener = ActionListener.wrap(searcher -> {
            if (searcher == null) {
                listener.onResponse((Object)new GetOverallBucketsAction.Response());
                return;
            }
            searcher.searchAndComputeOverallBuckets((ActionListener<List<OverallBucket>>)overallBucketsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        OverallBucketsProvider overallBucketsProvider = new OverallBucketsProvider(jobsContext.maxBucketSpan, request.getTopN(), request.getOverallScore());
        OverallBucketsProcessor overallBucketsProcessor = TransportGetOverallBucketsAction.requiresAggregation(request, jobsContext.maxBucketSpan) ? new OverallBucketsAggregator(request.getBucketSpan()) : new OverallBucketsCollector();
        this.initChunkedBucketSearcher(request, jobsContext, overallBucketsProvider, overallBucketsProcessor, (ActionListener<ChunkedBucketSearcher>)chunkedBucketSearcherListener);
    }

    private static boolean requiresAggregation(GetOverallBucketsAction.Request request, TimeValue maxBucketSpan) {
        return request.getBucketSpan() != null && !request.getBucketSpan().equals((Object)maxBucketSpan);
    }

    private static void checkValidBucketSpan(TimeValue bucketSpan, TimeValue maxBucketSpan) {
        if (bucketSpan != null && bucketSpan.compareTo(maxBucketSpan) < 0) {
            throw ExceptionsHelper.badRequestException((String)"Param [{}] must be greater or equal to the max bucket_span [{}]", (Object[])new Object[]{GetOverallBucketsAction.Request.BUCKET_SPAN, maxBucketSpan.getStringRep()});
        }
    }

    private void initChunkedBucketSearcher(GetOverallBucketsAction.Request request, JobsContext jobsContext, OverallBucketsProvider overallBucketsProvider, OverallBucketsProcessor overallBucketsProcessor, ActionListener<ChunkedBucketSearcher> listener) {
        long maxBucketSpanMillis = jobsContext.maxBucketSpan.millis();
        SearchRequest searchRequest = TransportGetOverallBucketsAction.buildSearchRequest(request.getStart(), request.getEnd(), request.isExcludeInterim(), maxBucketSpanMillis, jobsContext.indices);
        searchRequest.source().aggregation((AggregationBuilder)AggregationBuilders.min((String)EARLIEST_TIME).field(Result.TIMESTAMP.getPreferredName()));
        searchRequest.source().aggregation((AggregationBuilder)AggregationBuilders.max((String)LATEST_TIME).field(Result.TIMESTAMP.getPreferredName()));
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
            long totalHits = searchResponse.getHits().getTotalHits().value;
            if (totalHits > 0L) {
                Aggregations aggregations = searchResponse.getAggregations();
                Min min = (Min)aggregations.get(EARLIEST_TIME);
                long earliestTime = Intervals.alignToFloor((long)((long)min.getValue()), (long)maxBucketSpanMillis);
                Max max = (Max)aggregations.get(LATEST_TIME);
                long latestTime = Intervals.alignToCeil((long)((long)max.getValue() + 1L), (long)maxBucketSpanMillis);
                listener.onResponse((Object)new ChunkedBucketSearcher(jobsContext, earliestTime, latestTime, request.isExcludeInterim(), overallBucketsProvider, overallBucketsProcessor));
            } else {
                listener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    private static SearchRequest buildSearchRequest(Long start, Long end, boolean excludeInterim, long bucketSpanMillis, String[] indices) {
        String startTime = start == null ? null : String.valueOf(Intervals.alignToCeil((long)start, (long)bucketSpanMillis));
        String endTime = end == null ? null : String.valueOf(Intervals.alignToFloor((long)end, (long)bucketSpanMillis));
        SearchSourceBuilder searchSourceBuilder = new BucketsQueryBuilder().size(0).includeInterim(!excludeInterim).start(startTime).end(endTime).build();
        searchSourceBuilder.trackTotalHits(true);
        SearchRequest searchRequest = new SearchRequest(indices);
        searchRequest.indicesOptions(MlIndicesUtils.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS));
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    private static AggregationBuilder buildAggregations(long maxBucketSpanMillis, int jobCount) {
        ValuesSourceAggregationBuilder overallScoreAgg = AggregationBuilders.max((String)OverallBucket.OVERALL_SCORE.getPreferredName()).field(Bucket.ANOMALY_SCORE.getPreferredName());
        AbstractAggregationBuilder jobsAgg = ((TermsAggregationBuilder)AggregationBuilders.terms((String)Job.ID.getPreferredName()).field(Job.ID.getPreferredName())).size(jobCount).subAggregation((AggregationBuilder)overallScoreAgg);
        ValuesSourceAggregationBuilder interimAgg = AggregationBuilders.max((String)Result.IS_INTERIM.getPreferredName()).field(Result.IS_INTERIM.getPreferredName());
        return ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)Result.TIMESTAMP.getPreferredName()).field(Result.TIMESTAMP.getPreferredName())).interval(maxBucketSpanMillis).subAggregation((AggregationBuilder)jobsAgg)).subAggregation((AggregationBuilder)interimAgg);
    }

    private class ChunkedBucketSearcher {
        private static final int BUCKETS_PER_CHUNK = 1000;
        private static final int MAX_RESULT_COUNT = 10000;
        private final String[] indices;
        private final long maxBucketSpanMillis;
        private final boolean excludeInterim;
        private final long chunkMillis;
        private final long endTime;
        private volatile long curTime;
        private final AggregationBuilder aggs;
        private final OverallBucketsProvider overallBucketsProvider;
        private final OverallBucketsProcessor overallBucketsProcessor;

        ChunkedBucketSearcher(JobsContext jobsContext, long startTime, long endTime, boolean excludeInterim, OverallBucketsProvider overallBucketsProvider, OverallBucketsProcessor overallBucketsProcessor) {
            this.indices = jobsContext.indices;
            this.maxBucketSpanMillis = jobsContext.maxBucketSpan.millis();
            this.chunkMillis = 1000L * this.maxBucketSpanMillis;
            this.endTime = endTime;
            this.curTime = startTime;
            this.excludeInterim = excludeInterim;
            this.aggs = TransportGetOverallBucketsAction.buildAggregations(this.maxBucketSpanMillis, jobsContext.jobCount);
            this.overallBucketsProvider = overallBucketsProvider;
            this.overallBucketsProcessor = overallBucketsProcessor;
        }

        void searchAndComputeOverallBuckets(ActionListener<List<OverallBucket>> listener) {
            if (this.curTime >= this.endTime) {
                listener.onResponse(this.overallBucketsProcessor.finish());
                return;
            }
            ClientHelper.executeAsyncWithOrigin((ThreadContext)TransportGetOverallBucketsAction.this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)this.nextSearch(), (ActionListener)ActionListener.wrap(searchResponse -> {
                Histogram histogram = (Histogram)searchResponse.getAggregations().get(Result.TIMESTAMP.getPreferredName());
                this.overallBucketsProcessor.process(this.overallBucketsProvider.computeOverallBuckets(histogram));
                if (this.overallBucketsProcessor.size() > 10000) {
                    listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"Unable to return more than [{}] results; please use parameters [{}] and [{}] to limit the time range", (Object[])new Object[]{10000, GetOverallBucketsAction.Request.START, GetOverallBucketsAction.Request.END})));
                    return;
                }
                this.searchAndComputeOverallBuckets(listener);
            }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)TransportGetOverallBucketsAction.this.client).search(arg_0, arg_1));
        }

        SearchRequest nextSearch() {
            long curEnd = Math.min(this.curTime + this.chunkMillis, this.endTime);
            TransportGetOverallBucketsAction.this.logger.debug("Search for buckets in: [{}, {})", (Object)this.curTime, (Object)curEnd);
            SearchRequest searchRequest = TransportGetOverallBucketsAction.buildSearchRequest(this.curTime, curEnd, this.excludeInterim, this.maxBucketSpanMillis, this.indices);
            searchRequest.source().aggregation(this.aggs);
            this.curTime += this.chunkMillis;
            return searchRequest;
        }
    }

    private static class JobsContext {
        private final int jobCount;
        private final String[] indices;
        private final TimeValue maxBucketSpan;

        private JobsContext(int jobCount, String[] indices, TimeValue maxBucketSpan) {
            this.jobCount = jobCount;
            this.indices = indices;
            this.maxBucketSpan = maxBucketSpan;
        }

        private static JobsContext build(List<Job> jobs, GetOverallBucketsAction.Request request) {
            HashSet<String> indices = new HashSet<String>();
            TimeValue maxBucketSpan = TimeValue.ZERO;
            for (Job job : jobs) {
                indices.add(AnomalyDetectorsIndex.jobResultsAliasedName((String)job.getId()));
                TimeValue bucketSpan = job.getAnalysisConfig().getBucketSpan();
                if (maxBucketSpan.compareTo(bucketSpan) >= 0) continue;
                maxBucketSpan = bucketSpan;
            }
            TransportGetOverallBucketsAction.checkValidBucketSpan(request.getBucketSpan(), maxBucketSpan);
            if (request.getBucketSpan() != null && (request.getTopN() == 1 || jobs.size() <= 1)) {
                maxBucketSpan = request.getBucketSpan();
            }
            return new JobsContext(jobs.size(), indices.toArray(new String[indices.size()]), maxBucketSpan);
        }
    }
}

