note

	status: "See notice at end of class.";
	Date: "$Date: 2011-04-08 14:52:53 -0700 (Fri, 08 Apr 2011) $";
	Revision: "$Revision: 86178 $";
	Product: "Environment Converter"

class EC_DESCRIPTOR inherit

	EC_TYPES;

	EXT_INTERNAL

create -- Creation procedure

	make

feature  -- Initilization

	make
		do
			create ecd_fields.make_filled (Void, 1, 10);
			ecd_clear
		end;

feature -- Status report

	ecd_error: BOOLEAN

	ecd_message: detachable STRING

	field_separator: CHARACTER

	ecd_fields: ARRAY [detachable EC_FIELD]

	ecd_index: INTEGER
			-- Index of the current field

	ecd_min_index: INTEGER
			-- Index of the first field

	ecd_max_index: INTEGER
			-- Index of the last field

	ecd_reference_name: detachable STRING

	ecd_reference: detachable ANY

feature -- Status setting

	set_field_separator (fs: CHARACTER)
			-- Set field separator with `fs'.
		do
			field_separator := fs
		ensure
			field_separator = fs
		end;

	ecd_clear
		do
			ecd_fields.clear_all;
			ecd_index := 0;
			ecd_initialized := False;
			ecd_min_index := 32768;
			ecd_max_index := 0;
			field_separator := ';'
		end;

	set_index (i: INTEGER)
			-- Set `ecd_index' with `i'.
		do
			ecd_index := i-1
		ensure
			ecd_index = i-1
		end;

	set_field (n: STRING; type: INTEGER)
			-- Set `ecd_index'-th field with type `type' and name `n'.
		local
			f: EC_FIELD
		do
			ecd_initialized := True;
			ecd_index := ecd_index + 1;
			if ecd_index > ecd_max_index then
				ecd_max_index := ecd_index
			end;
			if ecd_index < ecd_min_index then
				ecd_min_index := ecd_index
			end;
			create f.make (type, n)
			ecd_fields.force (f, ecd_index)
		end;

	set_delimiters (ld, rd: CHARACTER)
			-- Set field value delimiters with `ld' and `rd'.
		require
			current_field_exists: ecd_fields.item (ecd_index) /= Void
		do
			check attached ecd_fields.item (ecd_index) as l_field then
				l_field.set_value_delimiters (ld, rd)
			end
		end;

	set_label_separator (ls: CHARACTER)
			-- Set label separator with `ls'.
		require
			current_field_exists: ecd_fields.item (ecd_index) /= Void
		do
			check attached ecd_fields.item (ecd_index) as l_field then
				l_field.set_label_separator (ls)
			end
		end;

	set_use_label (b: BOOLEAN)
			-- Set `use_label' with `b'.
		require
			current_field_exists: ecd_fields.item (ecd_index) /= Void
		do
			check attached ecd_fields.item (ecd_index) as l_field then
				l_field.set_use_label (b)
			end
		end;

	check_conformity (ref: ANY)
			-- Check if current desciptor conforms to `ref'.
			-- The conformity is true if and only if for each
			-- field of the current descriptor, there is a
			-- corresponding field in the Eiffel object with
			-- the same field_name and the same field_type.
		require
			reference_exists: ref /= Void
		local
			i, j, nb_fields: INTEGER;
			tmps: STRING;
			ra, da: ARRAY [BOOLEAN]  -- Referenced and Declared array
		do
			ecd_error := False;
			create tmps.make(0);
			nb_fields := field_count (ref);
			if ecd_min_index /= 1 then
				tmps.wipe_out;
				tmps.append("Type conformity error, First field `");
				check attached ecd_fields.item (ecd_min_index) as l_field then
					tmps.append(l_field.field_name);
					tmps.append("' cannot be indexed with ");
					tmps.append(ecd_min_index.out);
					tmps.append(".%N");
					set_ecd_error(tmps)
				end
			end;
			if not ecd_error and then ecd_max_index /= nb_fields then
				tmps.wipe_out;
				tmps.append("Type conformity error, Last field `");
				check attached ecd_fields.item (ecd_max_index) as l_field then
					tmps.append(l_field.field_name);
					tmps.append("' cannot be indexed with ");
					tmps.append(ecd_max_index.out);
					tmps.append(".%N");
					set_ecd_error(tmps)
				end
			end;
			create ra.make_filled (False, 1, nb_fields);
			create da.make_filled (False, 1, nb_fields);
			from
				i:=1
			until
				i > nb_fields or ecd_error
			loop
				from
					j:=1
				until
					j > nb_fields or ecd_error
				loop
					if attached ecd_fields.item (j) as l_field then
						if field_conforms (i, ref, l_field) then
							if ra.item (i) then
								tmps.wipe_out;
								tmps.append("Type conformity error, Field ");
								tmps.append(j.out);
								tmps.append(":`");
								tmps.append(l_field.field_name);
								tmps.append("' cannot be declared twice.%N");
								set_ecd_error(tmps)
							elseif da.item(j) then
								tmps.wipe_out;
								tmps.append("Type conformity fatal error: Referenced object has two identical fields%N");
								set_ecd_error(tmps)
							else
								ra.force(True,i);
								da.force(True,j);
								l_field.set_rank(i)
							end
						end
					else
						tmps.wipe_out;
						tmps.append("Type conformity error, Field ");
						tmps.append(j.out);
						tmps.append(" has not been set.%N");
						set_ecd_error(tmps)
					end
					j := j + 1
				end;
				i := i + 1
			end;
			if not ecd_error then
				from
					i := 1
				until
					i > nb_fields
				loop
					if not da.item(i) then
						tmps.append("Type conformity error, Field ");
						tmps.append(i.out);
						tmps.append(":`");
						check attached ecd_fields.item (i) as l_field then
							tmps.append(l_field.field_name)
							tmps.append("' does not match any reference field.%N");
							set_ecd_error(tmps)
						end
					end;
					i := i + 1
				end
			end;
			if not ecd_error then
				ecd_reference_name := ref.generator;
				ecd_reference := ref
			end
		end;

	make_conform (ref: ANY)
			-- Make current description conform to `ref'.
			-- (Using eiffel Standards).
		require
			reference_exists: ref /= Void
		local
			i, nb_fields: INTEGER;
			tmps:STRING
			l_f_name: like f_name
		do
			ecd_error := False;
			create tmps.make(5);
			nb_fields := field_count (ref);
			ecd_clear;
			from
				i:=1
			until
				i > nb_fields or ecd_error
			loop
				f_type := field_type (i, ref);
				l_f_name := field_name (i, ref);
				f_name := l_f_name
				inspect f_type
				when BOOLEAN_TYPE then
					set_field (l_f_name, Boolean_ttype)
				when REAL_TYPE then
					set_field (l_f_name, Real_ttype)
				when INTEGER_TYPE then
					set_field (l_f_name, Integer_ttype)
				else
					set_field (l_f_name, String_ttype);
				end;
				check attached ecd_fields.item (i) as l_field then
					l_field.set_rank(i)
				end
				i := i + 1
			end;
			if not ecd_error then
				ecd_reference_name := ref.generator;
				ecd_reference := ref
			end
		end

feature {NONE} -- Status report

	ecd_initialized: BOOLEAN;

	f_type: INTEGER;

	f_name: detachable STRING;

feature {NONE} -- Status setting

	set_ecd_error (s: STRING)
			-- Set error flag and error message with `s'.
		require
			s_not_void: s /= Void
		do
			ecd_error := True;
			ecd_message := s.twin
		end;

	field_conforms (i: INTEGER; o: ANY; f: EC_FIELD): BOOLEAN
			-- Checks for fields confomity.
			-- (names and types)
		require
			reference_object_exists: o /= Void
			f_exists: f /= Void
		local
			tmps:STRING;
			tmpb:BOOLEAN
		do
			create tmps.make(5);
			f_type := field_type (i, o);
			f_name := field_name (i, o);
			if f.field_name ~ f_name then
				inspect f.field_type
				when Boolean_ttype then
					tmpb := (f_type = BOOLEAN_TYPE)
				when Integer_ttype then
					tmpb := (f_type = INTEGER_TYPE)
				when Real_ttype then
					tmpb := (f_type = REAL_TYPE)
				when String_ttype then
					tmpb := (f_type = REFERENCE_TYPE)
				else
					tmpb := False;
					tmps.append ("Type conformity error, Unknown declared type for field `");
					tmps.append(f.field_name);
					tmps.append("'.%N");
					set_ecd_error(tmps)
				end;
				if not tmpb and not ecd_error then
					tmps.append ("Type conformity error, Invalid declared type for field `");
					tmps.append(f.field_name);
					tmps.append("'.%N");
					set_ecd_error(tmps)
				end;
				Result := tmpb
			else
				Result := False
			end
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"

end -- class EC_DESCRIPTOR
