note
	description: "Rectangle"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	author: "pascalf"
	date: "$Date: 2008-12-29 20:27:11 +0000 (Mon, 29 Dec 2008) $"
	revision: "$Revision: 76420 $"

class
	GD_RECTANGLE

inherit
	GD_COLORABLE

	GD_FIGURE

create
	make

feature -- Initialization

	make (im: GD_IMAGE;a_color_index:INTEGER; x1,y1,x2,y2: INTEGER)
		do
			image := im
			color_index := a_color_index
			upper_left_x := x1
			upper_left_y := y1
			bottom_right_x := x2
			bottom_right_y := y2
		end

feature -- Drawing

	draw_border
			-- Draw a rectangle thanks to upper_left and bottom_right coordinates. 
		do
			gdImageRectangle(image,x1,y1,x2,y2,color_index)	
		end	

feature -- Implementation

	upper_left_x, upper_left_y: INTEGER
	
	bottom_right_x, bottom_right_y: INTEGER

feature {NONE} -- Externals

	gdImageRectangle(p: POINTER; x1,y1,x2,y2: INTEGER; color_index: INTEGER)
		external
			"c"
		alias
			"gdImageRectangle"
		end

invariant
	point1_inside_the_image:image.coordinates_within_the_image(upper_left_x,upper_left_y)
	point2_inside_the_image:image.coordinates_within_the_image(bottom_right_x,bottom_right_y)
note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"


end -- class GD_RECTANGLE
