﻿note
	description: "Create and Manage flyweight objects."
	legal: "See notice at end of class."
	status: "See notice at end of class."
	author: "pascalf"
	date: "$Date: 2016-09-28 17:43:51 +0000 (Wed, 28 Sep 2016) $"
	revision: "$Revision: 99197 $"

class
	FLYWEIGHT_FACTORY

create
	make

feature -- Initialization

	make
			-- Initialize.
		do
			create list.make (20)
		end

feature -- Operations

	add (unshared: ANY; shared: ANY; key: HASHABLE)
			-- Add a flyweight to the list.
		require
			not_void: unshared /= Void and then shared /= Void and key /= Void
		local
			flyweight: FLYWEIGHT [like unshared, like shared]
		do
			create flyweight.make (unshared, shared)
			list.put (flyweight, key)
		ensure
			increment_list: list.count = old list.count + 1
		end

	remove (key: HASHABLE)
			-- Remove a flyweight from the list.
			-- Do nothing if it is not found.
		require
			not_void: key /= Void
		do
			list.remove (key)
		end

	has_item (a_flyweight: FLYWEIGHT [ANY, ANY]): BOOLEAN
			-- Return TRUE if the flyweight is managed by Current.
		require
			not_void: a_flyweight /= Void
		do
			Result := has_item (a_flyweight)
		end

	has (key: HASHABLE): BOOLEAN
			-- Return TRUE if a flyweight is managed by Current.
		require
			not_void: key /= Void
		do
			Result := has (key)
		end

	get_flyweight (key: HASHABLE): detachable FLYWEIGHT [ANY, ANY]
			-- Return flyweight corresponding to the key 'any'.
			-- Return Void if not found.
		require
			key_exists: key /= Void
		do
			Result := list.item (key)
		end

feature {NONE} -- Implementation

	list: HASH_TABLE [FLYWEIGHT [ANY, ANY], HASHABLE]
			-- List of flyweights.

invariant
	FLYWEIGHT_FACTORY_list_exists: list /= Void

note
	copyright: "Copyright (c) 1984-2016, Eiffel Software and others"
	license: "Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			Eiffel Software
			5949 Hollister Ave., Goleta, CA 93117 USA
			Telephone 805-685-1006, Fax 805-685-6869
			Website http://www.eiffel.com
			Customer support http://support.eiffel.com
		]"

end
