note
	description: "Objects that ..."
	author: "Colin LeMahieu"
	date: "$Date: 2011-11-11 17:13:16 +0000 (Fri, 11 Nov 2011) $"
	revision: "$Revision: 87787 $"
	quote: "Reader, suppose you were an idiot. And suppose you were a member of Congress. But I repeat myself. - Mark Twain"

deferred class
	AES_COMMON

inherit
	ROTATE_FACILITIES

feature
	S: SPECIAL [NATURAL_8]
			-- The S box
		once
			create result.make_filled (0, 256)
			result [0x00] := 0x63 result [0x01] := 0x7c result [0x02] := 0x77 result [0x03] := 0x7b result [0x04] := 0xf2 result [0x05] := 0x6b result [0x06] := 0x6f result [0x07] := 0xc5
			result [0x08] := 0x30 result [0x09] := 0x01 result [0x0a] := 0x67 result [0x0b] := 0x2b result [0x0c] := 0xfe result [0x0d] := 0xd7 result [0x0e] := 0xab result [0x0f] := 0x76
			result [0x10] := 0xca result [0x11] := 0x82 result [0x12] := 0xc9 result [0x13] := 0x7d result [0x14] := 0xfa result [0x15] := 0x59 result [0x16] := 0x47 result [0x17] := 0xf0
			result [0x18] := 0xad result [0x19] := 0xd4 result [0x1a] := 0xa2 result [0x1b] := 0xaf result [0x1c] := 0x9c result [0x1d] := 0xa4 result [0x1e] := 0x72 result [0x1f] := 0xc0
			result [0x20] := 0xb7 result [0x21] := 0xfd result [0x22] := 0x93 result [0x23] := 0x26 result [0x24] := 0x36 result [0x25] := 0x3f result [0x26] := 0xf7 result [0x27] := 0xcc
			result [0x28] := 0x34 result [0x29] := 0xa5 result [0x2a] := 0xe5 result [0x2b] := 0xf1 result [0x2c] := 0x71 result [0x2d] := 0xd8 result [0x2e] := 0x31 result [0x2f] := 0x15
			result [0x30] := 0x04 result [0x31] := 0xc7 result [0x32] := 0x23 result [0x33] := 0xc3 result [0x34] := 0x18 result [0x35] := 0x96 result [0x36] := 0x05 result [0x37] := 0x9a
			result [0x38] := 0x07 result [0x39] := 0x12 result [0x3a] := 0x80 result [0x3b] := 0xe2 result [0x3c] := 0xeb result [0x3d] := 0x27 result [0x3e] := 0xb2 result [0x3f] := 0x75
			result [0x40] := 0x09 result [0x41] := 0x83 result [0x42] := 0x2c result [0x43] := 0x1a result [0x44] := 0x1b result [0x45] := 0x6e result [0x46] := 0x5a result [0x47] := 0xa0
			result [0x48] := 0x52 result [0x49] := 0x3b result [0x4a] := 0xd6 result [0x4b] := 0xb3 result [0x4c] := 0x29 result [0x4d] := 0xe3 result [0x4e] := 0x2f result [0x4f] := 0x84
			result [0x50] := 0x53 result [0x51] := 0xd1 result [0x52] := 0x00 result [0x53] := 0xed result [0x54] := 0x20 result [0x55] := 0xfc result [0x56] := 0xb1 result [0x57] := 0x5b
			result [0x58] := 0x6a result [0x59] := 0xcb result [0x5a] := 0xbe result [0x5b] := 0x39 result [0x5c] := 0x4a result [0x5d] := 0x4c result [0x5e] := 0x58 result [0x5f] := 0xcf
			result [0x60] := 0xd0 result [0x61] := 0xef result [0x62] := 0xaa result [0x63] := 0xfb result [0x64] := 0x43 result [0x65] := 0x4d result [0x66] := 0x33 result [0x67] := 0x85
			result [0x68] := 0x45 result [0x69] := 0xf9 result [0x6a] := 0x02 result [0x6b] := 0x7f result [0x6c] := 0x50 result [0x6d] := 0x3c result [0x6e] := 0x9f result [0x6f] := 0xa8
			result [0x70] := 0x51 result [0x71] := 0xa3 result [0x72] := 0x40 result [0x73] := 0x8f result [0x74] := 0x92 result [0x75] := 0x9d result [0x76] := 0x38 result [0x77] := 0xf5
			result [0x78] := 0xbc result [0x79] := 0xb6 result [0x7a] := 0xda result [0x7b] := 0x21 result [0x7c] := 0x10 result [0x7d] := 0xff result [0x7e] := 0xf3 result [0x7f] := 0xd2
			result [0x80] := 0xcd result [0x81] := 0x0c result [0x82] := 0x13 result [0x83] := 0xec result [0x84] := 0x5f result [0x85] := 0x97 result [0x86] := 0x44 result [0x87] := 0x17
			result [0x88] := 0xc4 result [0x89] := 0xa7 result [0x8a] := 0x7e result [0x8b] := 0x3d result [0x8c] := 0x64 result [0x8d] := 0x5d result [0x8e] := 0x19 result [0x8f] := 0x73
			result [0x90] := 0x60 result [0x91] := 0x81 result [0x92] := 0x4f result [0x93] := 0xdc result [0x94] := 0x22 result [0x95] := 0x2a result [0x96] := 0x90 result [0x97] := 0x88
			result [0x98] := 0x46 result [0x99] := 0xee result [0x9a] := 0xb8 result [0x9b] := 0x14 result [0x9c] := 0xde result [0x9d] := 0x5e result [0x9e] := 0x0b result [0x9f] := 0xdb
			result [0xa0] := 0xe0 result [0xa1] := 0x32 result [0xa2] := 0x3a result [0xa3] := 0x0a result [0xa4] := 0x49 result [0xa5] := 0x06 result [0xa6] := 0x24 result [0xa7] := 0x5c
			result [0xa8] := 0xc2 result [0xa9] := 0xd3 result [0xaa] := 0xac result [0xab] := 0x62 result [0xac] := 0x91 result [0xad] := 0x95 result [0xae] := 0xe4 result [0xaf] := 0x79
			result [0xb0] := 0xe7 result [0xb1] := 0xc8 result [0xb2] := 0x37 result [0xb3] := 0x6d result [0xb4] := 0x8d result [0xb5] := 0xd5 result [0xb6] := 0x4e result [0xb7] := 0xa9
			result [0xb8] := 0x6c result [0xb9] := 0x56 result [0xba] := 0xf4 result [0xbb] := 0xea result [0xbc] := 0x65 result [0xbd] := 0x7a result [0xbe] := 0xae result [0xbf] := 0x08
			result [0xc0] := 0xba result [0xc1] := 0x78 result [0xc2] := 0x25 result [0xc3] := 0x2e result [0xc4] := 0x1c result [0xc5] := 0xa6 result [0xc6] := 0xb4 result [0xc7] := 0xc6
			result [0xc8] := 0xe8 result [0xc9] := 0xdd result [0xca] := 0x74 result [0xcb] := 0x1f result [0xcc] := 0x4b result [0xcd] := 0xbd result [0xce] := 0x8b result [0xcf] := 0x8a
			result [0xd0] := 0x70 result [0xd1] := 0x3e result [0xd2] := 0xb5 result [0xd3] := 0x66 result [0xd4] := 0x48 result [0xd5] := 0x03 result [0xd6] := 0xf6 result [0xd7] := 0x0e
			result [0xd8] := 0x61 result [0xd9] := 0x35 result [0xda] := 0x57 result [0xdb] := 0xb9 result [0xdc] := 0x86 result [0xdd] := 0xc1 result [0xde] := 0x1d result [0xdf] := 0x9e
			result [0xe0] := 0xe1 result [0xe1] := 0xf8 result [0xe2] := 0x98 result [0xe3] := 0x11 result [0xe4] := 0x69 result [0xe5] := 0xd9 result [0xe6] := 0x8e result [0xe7] := 0x94
			result [0xe8] := 0x9b result [0xe9] := 0x1e result [0xea] := 0x87 result [0xeb] := 0xe9 result [0xec] := 0xce result [0xed] := 0x55 result [0xee] := 0x28 result [0xef] := 0xdf
			result [0xf0] := 0x8c result [0xf1] := 0xa1 result [0xf2] := 0x89 result [0xf3] := 0x0d result [0xf4] := 0xbf result [0xf5] := 0xe6 result [0xf6] := 0x42 result [0xf7] := 0x68
			result [0xf8] := 0x41 result [0xf9] := 0x99 result [0xfa] := 0x2d result [0xfb] := 0x0f result [0xfc] := 0xb0 result [0xfd] := 0x54 result [0xfe] := 0xbb result [0xff] := 0x16
		end

	Si: SPECIAL [NATURAL_8]
			-- S inverse box
		once
			create result.make_filled (0, 256)
			result [0x00] := 0x52 result [0x01] := 0x09 result [0x02] := 0x6a result [0x03] := 0xd5 result [0x04] := 0x30 result [0x05] := 0x36 result [0x06] := 0xa5 result [0x07] := 0x38
			result [0x08] := 0xbf result [0x09] := 0x40 result [0x0a] := 0xa3 result [0x0b] := 0x9e result [0x0c] := 0x81 result [0x0d] := 0xf3 result [0x0e] := 0xd7 result [0x0f] := 0xfb
			result [0x10] := 0x7c result [0x11] := 0xe3 result [0x12] := 0x39 result [0x13] := 0x82 result [0x14] := 0x9b result [0x15] := 0x2f result [0x16] := 0xff result [0x17] := 0x87
			result [0x18] := 0x34 result [0x19] := 0x8e result [0x1a] := 0x43 result [0x1b] := 0x44 result [0x1c] := 0xc4 result [0x1d] := 0xde result [0x1e] := 0xe9 result [0x1f] := 0xcb
			result [0x20] := 0x54 result [0x21] := 0x7b result [0x22] := 0x94 result [0x23] := 0x32 result [0x24] := 0xa6 result [0x25] := 0xc2 result [0x26] := 0x23 result [0x27] := 0x3d
			result [0x28] := 0xee result [0x29] := 0x4c result [0x2a] := 0x95 result [0x2b] := 0x0b result [0x2c] := 0x42 result [0x2d] := 0xfa result [0x2e] := 0xc3 result [0x2f] := 0x4e
			result [0x30] := 0x08 result [0x31] := 0x2e result [0x32] := 0xa1 result [0x33] := 0x66 result [0x34] := 0x28 result [0x35] := 0xd9 result [0x36] := 0x24 result [0x37] := 0xb2
			result [0x38] := 0x76 result [0x39] := 0x5b result [0x3a] := 0xa2 result [0x3b] := 0x49 result [0x3c] := 0x6d result [0x3d] := 0x8b result [0x3e] := 0xd1 result [0x3f] := 0x25
			result [0x40] := 0x72 result [0x41] := 0xf8 result [0x42] := 0xf6 result [0x43] := 0x64 result [0x44] := 0x86 result [0x45] := 0x68 result [0x46] := 0x98 result [0x47] := 0x16
			result [0x48] := 0xd4 result [0x49] := 0xa4 result [0x4a] := 0x5c result [0x4b] := 0xcc result [0x4c] := 0x5d result [0x4d] := 0x65 result [0x4e] := 0xb6 result [0x4f] := 0x92
			result [0x50] := 0x6c result [0x51] := 0x70 result [0x52] := 0x48 result [0x53] := 0x50 result [0x54] := 0xfd result [0x55] := 0xed result [0x56] := 0xb9 result [0x57] := 0xda
			result [0x58] := 0x5e result [0x59] := 0x15 result [0x5a] := 0x46 result [0x5b] := 0x57 result [0x5c] := 0xa7 result [0x5d] := 0x8d result [0x5e] := 0x9d result [0x5f] := 0x84
			result [0x60] := 0x90 result [0x61] := 0xd8 result [0x62] := 0xab result [0x63] := 0x00 result [0x64] := 0x8c result [0x65] := 0xbc result [0x66] := 0xd3 result [0x67] := 0x0a
			result [0x68] := 0xf7 result [0x69] := 0xe4 result [0x6a] := 0x58 result [0x6b] := 0x05 result [0x6c] := 0xb8 result [0x6d] := 0xb3 result [0x6e] := 0x45 result [0x6f] := 0x06
			result [0x70] := 0xd0 result [0x71] := 0x2c result [0x72] := 0x1e result [0x73] := 0x8f result [0x74] := 0xca result [0x75] := 0x3f result [0x76] := 0x0f result [0x77] := 0x02
			result [0x78] := 0xc1 result [0x79] := 0xaf result [0x7a] := 0xbd result [0x7b] := 0x03 result [0x7c] := 0x01 result [0x7d] := 0x13 result [0x7e] := 0x8a result [0x7f] := 0x6b
			result [0x80] := 0x3a result [0x81] := 0x91 result [0x82] := 0x11 result [0x83] := 0x41 result [0x84] := 0x4f result [0x85] := 0x67 result [0x86] := 0xdc result [0x87] := 0xea
			result [0x88] := 0x97 result [0x89] := 0xf2 result [0x8a] := 0xcf result [0x8b] := 0xce result [0x8c] := 0xf0 result [0x8d] := 0xb4 result [0x8e] := 0xe6 result [0x8f] := 0x73
			result [0x90] := 0x96 result [0x91] := 0xac result [0x92] := 0x74 result [0x93] := 0x22 result [0x94] := 0xe7 result [0x95] := 0xad result [0x96] := 0x35 result [0x97] := 0x85
			result [0x98] := 0xe2 result [0x99] := 0xf9 result [0x9a] := 0x37 result [0x9b] := 0xe8 result [0x9c] := 0x1c result [0x9d] := 0x75 result [0x9e] := 0xdf result [0x9f] := 0x6e
			result [0xa0] := 0x47 result [0xa1] := 0xf1 result [0xa2] := 0x1a result [0xa3] := 0x71 result [0xa4] := 0x1d result [0xa5] := 0x29 result [0xa6] := 0xc5 result [0xa7] := 0x89
			result [0xa8] := 0x6f result [0xa9] := 0xb7 result [0xaa] := 0x62 result [0xab] := 0x0e result [0xac] := 0xaa result [0xad] := 0x18 result [0xae] := 0xbe result [0xaf] := 0x1b
			result [0xb0] := 0xfc result [0xb1] := 0x56 result [0xb2] := 0x3e result [0xb3] := 0x4b result [0xb4] := 0xc6 result [0xb5] := 0xd2 result [0xb6] := 0x79 result [0xb7] := 0x20
			result [0xb8] := 0x9a result [0xb9] := 0xdb result [0xba] := 0xc0 result [0xbb] := 0xfe result [0xbc] := 0x78 result [0xbd] := 0xcd result [0xbe] := 0x5a result [0xbf] := 0xf4
			result [0xc0] := 0x1f result [0xc1] := 0xdd result [0xc2] := 0xa8 result [0xc3] := 0x33 result [0xc4] := 0x88 result [0xc5] := 0x07 result [0xc6] := 0xc7 result [0xc7] := 0x31
			result [0xc8] := 0xb1 result [0xc9] := 0x12 result [0xca] := 0x10 result [0xcb] := 0x59 result [0xcc] := 0x27 result [0xcd] := 0x80 result [0xce] := 0xec result [0xcf] := 0x5f
			result [0xd0] := 0x60 result [0xd1] := 0x51 result [0xd2] := 0x7f result [0xd3] := 0xa9 result [0xd4] := 0x19 result [0xd5] := 0xb5 result [0xd6] := 0x4a result [0xd7] := 0x0d
			result [0xd8] := 0x2d result [0xd9] := 0xe5 result [0xda] := 0x7a result [0xdb] := 0x9f result [0xdc] := 0x93 result [0xdd] := 0xc9 result [0xde] := 0x9c result [0xdf] := 0xef
			result [0xe0] := 0xa0 result [0xe1] := 0xe0 result [0xe2] := 0x3b result [0xe3] := 0x4d result [0xe4] := 0xae result [0xe5] := 0x2a result [0xe6] := 0xf5 result [0xe7] := 0xb0
			result [0xe8] := 0xc8 result [0xe9] := 0xeb result [0xea] := 0xbb result [0xeb] := 0x3c result [0xec] := 0x83 result [0xed] := 0x53 result [0xee] := 0x99 result [0xef] := 0x61
			result [0xf0] := 0x17 result [0xf1] := 0x2b result [0xf2] := 0x04 result [0xf3] := 0x7e result [0xf4] := 0xba result [0xf5] := 0x77 result [0xf6] := 0xd6 result [0xf7] := 0x26
			result [0xf8] := 0xe1 result [0xf9] := 0x69 result [0xfa] := 0x14 result [0xfb] := 0x63 result [0xfc] := 0x55 result [0xfd] := 0x21 result [0xfe] := 0x0c result [0xff] := 0x7d
		end

	inv_sub_bytes (in: NATURAL_32): NATURAL_32
		do
			result := si [((in |>> 24) & 0xff).to_integer_32].to_natural_32 |<< 24
			result := result | (si [((in |>> 16) & 0xff).to_integer_32].to_natural_32 |<< 16)
			result := result | (si [((in |>> 8) & 0xff).to_integer_32].to_natural_32 |<< 8)
			result := result | (si [(in & 0xff).to_integer_32]).to_natural_32
		ensure
			(result & 0xff).to_natural_8 = si [(in & 0xff).to_integer_32]
			((result |>> 8) & 0xff).to_natural_8 = si [((in |>> 8) & 0xff).to_integer_32]
			((result |>> 16) & 0xff).to_natural_8 = si [((in |>> 16) & 0xff).to_integer_32]
			(result |>> 24).to_natural_8 = si [((in |>> 24) & 0xff).to_integer_32]
		end

	sub_bytes (in: NATURAL_32): NATURAL_32
		do
			result := s [((in |>> 24) & 0xff).to_integer_32].to_natural_32 |<< 24
			result := result | (s [((in |>> 16) & 0xff).to_integer_32].to_natural_32 |<< 16)
			result := result | (s [((in |>> 8) & 0xff).to_integer_32].to_natural_32 |<< 8)
			result := result | (s [(in & 0xff).to_integer_32])
		ensure
			(result & 0xff).to_natural_8 = s [(in & 0xff).to_integer_32]
			((result |>> 8) & 0xff).to_natural_8 = s [((in |>> 8) & 0xff).to_integer_32]
			((result |>> 16) & 0xff).to_natural_8 = s [((in |>> 16) & 0xff).to_integer_32]
			(result |>> 24).to_natural_8 = s [((in |>> 24) & 0xff).to_integer_32]
		end

	FFmulX (x: NATURAL_32): NATURAL_32
		do
			result := ((x & m2) |<< 1).bit_xor (((x & m1) |>> 7) * m3)
		end

	m1: NATURAL_32 = 0x80808080
	m2: NATURAL_32 = 0x7f7f7f7f
	m3: NATURAL_32 = 0x0000001b

feature
	s_box_inverse: BOOLEAN
		local
			counter: INTEGER
		do
			from
				counter := 0
				result := true
			until
				counter > 255 or not result
			loop
				result := si [s [counter].to_integer_32].to_integer_32 = counter
				counter := counter + 1
			end
		end

	s_box_inverse_once: BOOLEAN
			-- Is the s-box correct as long as nothing modifies it
		once
			result := s_box_inverse
		end

invariant
	s_box_inverse: s_box_inverse_once
end
