note

	description:

		"Routines for normalizing strings"

	generator: "geuc"

	library: "Gobo Eiffel String Library"
	copyright: "Copyright (c) 2005-2013, Colin Adams and others"
	license: "MIT License"
	date: "$Date: 2019-02-07 22:54:15 +0000 (Thu, 07 Feb 2019) $"
	revision: "$Revision: 102807 $"

class ST_UNICODE_V510_NORMALIZATION_ROUTINES

inherit

	ST_UNICODE_NORMALIZATION_INTERFACE


feature -- Access

	major_version: INTEGER
			-- Major version number of Unicode
		once
			Result := 5
		end

	minor_version: INTEGER
			-- Minor version number of Unicode
		once
			Result := 1
		end

	update_version: INTEGER
			-- Update version number of Unicode
		once
			Result := 0
		end

feature {NONE} -- Implementation

	all_zero_canonical_combining_class_segment: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_3: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/57/%/51/%/51/%/51/%/51/%/57/%/49/%/51/%/51/%/51/%/51/%/51/%/43/%/43/%/51/%/51/%/51/%/51/%/43/%/43/%/51/%/51/%/51/%/51/%/51/%/51/%/51/%/51/%/51/%/51/%/51/%/1/%/1/%/1/%/1/%/1/%/51/%/51/%/51/%/51/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/60/%/56/%/51/%/51/%/51/%/56/%/56/%/56/%/51/%/51/%/0/%/56/%/56/%/56/%/51/%/51/%/51/%/51/%/56/%/57/%/51/%/51/%/56/%/58/%/59/%/59/%/58/%/59/%/59/%/58/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_4: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/56/%/56/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_5: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/51/%/56/%/56/%/56/%/56/%/51/%/56/%/56/%/56/%/52/%/51/%/56/%/56/%/56/%/56/%/56/%/56/%/51/%/51/%/51/%/51/%/51/%/51/%/56/%/56/%/51/%/56/%/56/%/52/%/55/%/56/%/5/%/6/%/7/%/8/%/9/%/10/%/11/%/12/%/13/%/14/%/14/%/15/%/16/%/17/%/0/%/18/%/0/%/19/%/20/%/0/%/56/%/51/%/0/%/13/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_6: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/25/%/26/%/27/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/22/%/23/%/24/%/25/%/26/%/27/%/28/%/29/%/56/%/56/%/51/%/51/%/56/%/56/%/56/%/56/%/56/%/51/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/30/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/0/%/0/%/56/%/56/%/56/%/56/%/51/%/56/%/0/%/0/%/56/%/56/%/0/%/51/%/56/%/56/%/51/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_7: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/31/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/51/%/56/%/56/%/51/%/56/%/56/%/51/%/51/%/51/%/56/%/51/%/51/%/56/%/51/%/56/%/56/%/56/%/51/%/56/%/51/%/56/%/51/%/56/%/51/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/51/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_9: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/56/%/51/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_10: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_11: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_12: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/32/%/33/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_13: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_14: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/34/%/34/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/35/%/35/%/35/%/35/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/36/%/36/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/37/%/37/%/37/%/37/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_15: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/51/%/51/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/51/%/0/%/51/%/0/%/49/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/38/%/39/%/0/%/40/%/0/%/0/%/0/%/0/%/0/%/39/%/39/%/39/%/39/%/0/%/0/%/39/%/0/%/56/%/56/%/4/%/0/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/51/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_16: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/4/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/51/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_19: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_23: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_24: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/55/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_25: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/52/%/56/%/51/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_26: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/51/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_27: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/51/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_28: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_29: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/56/%/51/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/51/%/56/%/56/%/59/%/48/%/51/%/43/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/51/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_32: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/56/%/1/%/1/%/56/%/56/%/56/%/56/%/1/%/1/%/1/%/56/%/56/%/0/%/0/%/0/%/0/%/56/%/0/%/0/%/0/%/1/%/1/%/56/%/51/%/56/%/1/%/1/%/51/%/51/%/51/%/51/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_45: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/56/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_48: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/50/%/55/%/57/%/52/%/53/%/53/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/3/%/3/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_166: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_168: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_169: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/51/%/51/%/51/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_251: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/21/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0_segment_254: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/56/%/56/%/56/%/56/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_0: SPECIAL [ARRAY [INTEGER_8]]
			-- Generated character class array plane
		once
			create Result.make_filled (all_zero_canonical_combining_class_segment, 256)
			Result.put (all_zero_canonical_combining_class_segment, 1)
			Result.put (all_zero_canonical_combining_class_segment, 2)
			Result.put (canonical_combining_class_plane_0_segment_3, 3)
			Result.put (canonical_combining_class_plane_0_segment_4, 4)
			Result.put (canonical_combining_class_plane_0_segment_5, 5)
			Result.put (canonical_combining_class_plane_0_segment_6, 6)
			Result.put (canonical_combining_class_plane_0_segment_7, 7)
			Result.put (all_zero_canonical_combining_class_segment, 8)
			Result.put (canonical_combining_class_plane_0_segment_9, 9)
			Result.put (canonical_combining_class_plane_0_segment_10, 10)
			Result.put (canonical_combining_class_plane_0_segment_11, 11)
			Result.put (canonical_combining_class_plane_0_segment_12, 12)
			Result.put (canonical_combining_class_plane_0_segment_13, 13)
			Result.put (canonical_combining_class_plane_0_segment_14, 14)
			Result.put (canonical_combining_class_plane_0_segment_15, 15)
			Result.put (canonical_combining_class_plane_0_segment_16, 16)
			Result.put (all_zero_canonical_combining_class_segment, 17)
			Result.put (all_zero_canonical_combining_class_segment, 18)
			Result.put (canonical_combining_class_plane_0_segment_19, 19)
			Result.put (all_zero_canonical_combining_class_segment, 20)
			Result.put (all_zero_canonical_combining_class_segment, 21)
			Result.put (all_zero_canonical_combining_class_segment, 22)
			Result.put (canonical_combining_class_plane_0_segment_23, 23)
			Result.put (canonical_combining_class_plane_0_segment_24, 24)
			Result.put (canonical_combining_class_plane_0_segment_25, 25)
			Result.put (canonical_combining_class_plane_0_segment_26, 26)
			Result.put (canonical_combining_class_plane_0_segment_27, 27)
			Result.put (canonical_combining_class_plane_0_segment_28, 28)
			Result.put (canonical_combining_class_plane_0_segment_29, 29)
			Result.put (all_zero_canonical_combining_class_segment, 30)
			Result.put (all_zero_canonical_combining_class_segment, 31)
			Result.put (canonical_combining_class_plane_0_segment_32, 32)
			Result.put (all_zero_canonical_combining_class_segment, 33)
			Result.put (all_zero_canonical_combining_class_segment, 34)
			Result.put (all_zero_canonical_combining_class_segment, 35)
			Result.put (all_zero_canonical_combining_class_segment, 36)
			Result.put (all_zero_canonical_combining_class_segment, 37)
			Result.put (all_zero_canonical_combining_class_segment, 38)
			Result.put (all_zero_canonical_combining_class_segment, 39)
			Result.put (all_zero_canonical_combining_class_segment, 40)
			Result.put (all_zero_canonical_combining_class_segment, 41)
			Result.put (all_zero_canonical_combining_class_segment, 42)
			Result.put (all_zero_canonical_combining_class_segment, 43)
			Result.put (all_zero_canonical_combining_class_segment, 44)
			Result.put (canonical_combining_class_plane_0_segment_45, 45)
			Result.put (all_zero_canonical_combining_class_segment, 46)
			Result.put (all_zero_canonical_combining_class_segment, 47)
			Result.put (canonical_combining_class_plane_0_segment_48, 48)
			Result.put (all_zero_canonical_combining_class_segment, 49)
			Result.put (all_zero_canonical_combining_class_segment, 50)
			Result.put (all_zero_canonical_combining_class_segment, 51)
			Result.put (all_zero_canonical_combining_class_segment, 52)
			Result.put (all_zero_canonical_combining_class_segment, 53)
			Result.put (all_zero_canonical_combining_class_segment, 54)
			Result.put (all_zero_canonical_combining_class_segment, 55)
			Result.put (all_zero_canonical_combining_class_segment, 56)
			Result.put (all_zero_canonical_combining_class_segment, 57)
			Result.put (all_zero_canonical_combining_class_segment, 58)
			Result.put (all_zero_canonical_combining_class_segment, 59)
			Result.put (all_zero_canonical_combining_class_segment, 60)
			Result.put (all_zero_canonical_combining_class_segment, 61)
			Result.put (all_zero_canonical_combining_class_segment, 62)
			Result.put (all_zero_canonical_combining_class_segment, 63)
			Result.put (all_zero_canonical_combining_class_segment, 64)
			Result.put (all_zero_canonical_combining_class_segment, 65)
			Result.put (all_zero_canonical_combining_class_segment, 66)
			Result.put (all_zero_canonical_combining_class_segment, 67)
			Result.put (all_zero_canonical_combining_class_segment, 68)
			Result.put (all_zero_canonical_combining_class_segment, 69)
			Result.put (all_zero_canonical_combining_class_segment, 70)
			Result.put (all_zero_canonical_combining_class_segment, 71)
			Result.put (all_zero_canonical_combining_class_segment, 72)
			Result.put (all_zero_canonical_combining_class_segment, 73)
			Result.put (all_zero_canonical_combining_class_segment, 74)
			Result.put (all_zero_canonical_combining_class_segment, 75)
			Result.put (all_zero_canonical_combining_class_segment, 76)
			Result.put (all_zero_canonical_combining_class_segment, 77)
			Result.put (all_zero_canonical_combining_class_segment, 78)
			Result.put (all_zero_canonical_combining_class_segment, 79)
			Result.put (all_zero_canonical_combining_class_segment, 80)
			Result.put (all_zero_canonical_combining_class_segment, 81)
			Result.put (all_zero_canonical_combining_class_segment, 82)
			Result.put (all_zero_canonical_combining_class_segment, 83)
			Result.put (all_zero_canonical_combining_class_segment, 84)
			Result.put (all_zero_canonical_combining_class_segment, 85)
			Result.put (all_zero_canonical_combining_class_segment, 86)
			Result.put (all_zero_canonical_combining_class_segment, 87)
			Result.put (all_zero_canonical_combining_class_segment, 88)
			Result.put (all_zero_canonical_combining_class_segment, 89)
			Result.put (all_zero_canonical_combining_class_segment, 90)
			Result.put (all_zero_canonical_combining_class_segment, 91)
			Result.put (all_zero_canonical_combining_class_segment, 92)
			Result.put (all_zero_canonical_combining_class_segment, 93)
			Result.put (all_zero_canonical_combining_class_segment, 94)
			Result.put (all_zero_canonical_combining_class_segment, 95)
			Result.put (all_zero_canonical_combining_class_segment, 96)
			Result.put (all_zero_canonical_combining_class_segment, 97)
			Result.put (all_zero_canonical_combining_class_segment, 98)
			Result.put (all_zero_canonical_combining_class_segment, 99)
			Result.put (all_zero_canonical_combining_class_segment, 100)
			Result.put (all_zero_canonical_combining_class_segment, 101)
			Result.put (all_zero_canonical_combining_class_segment, 102)
			Result.put (all_zero_canonical_combining_class_segment, 103)
			Result.put (all_zero_canonical_combining_class_segment, 104)
			Result.put (all_zero_canonical_combining_class_segment, 105)
			Result.put (all_zero_canonical_combining_class_segment, 106)
			Result.put (all_zero_canonical_combining_class_segment, 107)
			Result.put (all_zero_canonical_combining_class_segment, 108)
			Result.put (all_zero_canonical_combining_class_segment, 109)
			Result.put (all_zero_canonical_combining_class_segment, 110)
			Result.put (all_zero_canonical_combining_class_segment, 111)
			Result.put (all_zero_canonical_combining_class_segment, 112)
			Result.put (all_zero_canonical_combining_class_segment, 113)
			Result.put (all_zero_canonical_combining_class_segment, 114)
			Result.put (all_zero_canonical_combining_class_segment, 115)
			Result.put (all_zero_canonical_combining_class_segment, 116)
			Result.put (all_zero_canonical_combining_class_segment, 117)
			Result.put (all_zero_canonical_combining_class_segment, 118)
			Result.put (all_zero_canonical_combining_class_segment, 119)
			Result.put (all_zero_canonical_combining_class_segment, 120)
			Result.put (all_zero_canonical_combining_class_segment, 121)
			Result.put (all_zero_canonical_combining_class_segment, 122)
			Result.put (all_zero_canonical_combining_class_segment, 123)
			Result.put (all_zero_canonical_combining_class_segment, 124)
			Result.put (all_zero_canonical_combining_class_segment, 125)
			Result.put (all_zero_canonical_combining_class_segment, 126)
			Result.put (all_zero_canonical_combining_class_segment, 127)
			Result.put (all_zero_canonical_combining_class_segment, 128)
			Result.put (all_zero_canonical_combining_class_segment, 129)
			Result.put (all_zero_canonical_combining_class_segment, 130)
			Result.put (all_zero_canonical_combining_class_segment, 131)
			Result.put (all_zero_canonical_combining_class_segment, 132)
			Result.put (all_zero_canonical_combining_class_segment, 133)
			Result.put (all_zero_canonical_combining_class_segment, 134)
			Result.put (all_zero_canonical_combining_class_segment, 135)
			Result.put (all_zero_canonical_combining_class_segment, 136)
			Result.put (all_zero_canonical_combining_class_segment, 137)
			Result.put (all_zero_canonical_combining_class_segment, 138)
			Result.put (all_zero_canonical_combining_class_segment, 139)
			Result.put (all_zero_canonical_combining_class_segment, 140)
			Result.put (all_zero_canonical_combining_class_segment, 141)
			Result.put (all_zero_canonical_combining_class_segment, 142)
			Result.put (all_zero_canonical_combining_class_segment, 143)
			Result.put (all_zero_canonical_combining_class_segment, 144)
			Result.put (all_zero_canonical_combining_class_segment, 145)
			Result.put (all_zero_canonical_combining_class_segment, 146)
			Result.put (all_zero_canonical_combining_class_segment, 147)
			Result.put (all_zero_canonical_combining_class_segment, 148)
			Result.put (all_zero_canonical_combining_class_segment, 149)
			Result.put (all_zero_canonical_combining_class_segment, 150)
			Result.put (all_zero_canonical_combining_class_segment, 151)
			Result.put (all_zero_canonical_combining_class_segment, 152)
			Result.put (all_zero_canonical_combining_class_segment, 153)
			Result.put (all_zero_canonical_combining_class_segment, 154)
			Result.put (all_zero_canonical_combining_class_segment, 155)
			Result.put (all_zero_canonical_combining_class_segment, 156)
			Result.put (all_zero_canonical_combining_class_segment, 157)
			Result.put (all_zero_canonical_combining_class_segment, 158)
			Result.put (all_zero_canonical_combining_class_segment, 159)
			Result.put (all_zero_canonical_combining_class_segment, 160)
			Result.put (all_zero_canonical_combining_class_segment, 161)
			Result.put (all_zero_canonical_combining_class_segment, 162)
			Result.put (all_zero_canonical_combining_class_segment, 163)
			Result.put (all_zero_canonical_combining_class_segment, 164)
			Result.put (all_zero_canonical_combining_class_segment, 165)
			Result.put (canonical_combining_class_plane_0_segment_166, 166)
			Result.put (all_zero_canonical_combining_class_segment, 167)
			Result.put (canonical_combining_class_plane_0_segment_168, 168)
			Result.put (canonical_combining_class_plane_0_segment_169, 169)
			Result.put (all_zero_canonical_combining_class_segment, 170)
			Result.put (all_zero_canonical_combining_class_segment, 171)
			Result.put (all_zero_canonical_combining_class_segment, 172)
			Result.put (all_zero_canonical_combining_class_segment, 173)
			Result.put (all_zero_canonical_combining_class_segment, 174)
			Result.put (all_zero_canonical_combining_class_segment, 175)
			Result.put (all_zero_canonical_combining_class_segment, 176)
			Result.put (all_zero_canonical_combining_class_segment, 177)
			Result.put (all_zero_canonical_combining_class_segment, 178)
			Result.put (all_zero_canonical_combining_class_segment, 179)
			Result.put (all_zero_canonical_combining_class_segment, 180)
			Result.put (all_zero_canonical_combining_class_segment, 181)
			Result.put (all_zero_canonical_combining_class_segment, 182)
			Result.put (all_zero_canonical_combining_class_segment, 183)
			Result.put (all_zero_canonical_combining_class_segment, 184)
			Result.put (all_zero_canonical_combining_class_segment, 185)
			Result.put (all_zero_canonical_combining_class_segment, 186)
			Result.put (all_zero_canonical_combining_class_segment, 187)
			Result.put (all_zero_canonical_combining_class_segment, 188)
			Result.put (all_zero_canonical_combining_class_segment, 189)
			Result.put (all_zero_canonical_combining_class_segment, 190)
			Result.put (all_zero_canonical_combining_class_segment, 191)
			Result.put (all_zero_canonical_combining_class_segment, 192)
			Result.put (all_zero_canonical_combining_class_segment, 193)
			Result.put (all_zero_canonical_combining_class_segment, 194)
			Result.put (all_zero_canonical_combining_class_segment, 195)
			Result.put (all_zero_canonical_combining_class_segment, 196)
			Result.put (all_zero_canonical_combining_class_segment, 197)
			Result.put (all_zero_canonical_combining_class_segment, 198)
			Result.put (all_zero_canonical_combining_class_segment, 199)
			Result.put (all_zero_canonical_combining_class_segment, 200)
			Result.put (all_zero_canonical_combining_class_segment, 201)
			Result.put (all_zero_canonical_combining_class_segment, 202)
			Result.put (all_zero_canonical_combining_class_segment, 203)
			Result.put (all_zero_canonical_combining_class_segment, 204)
			Result.put (all_zero_canonical_combining_class_segment, 205)
			Result.put (all_zero_canonical_combining_class_segment, 206)
			Result.put (all_zero_canonical_combining_class_segment, 207)
			Result.put (all_zero_canonical_combining_class_segment, 208)
			Result.put (all_zero_canonical_combining_class_segment, 209)
			Result.put (all_zero_canonical_combining_class_segment, 210)
			Result.put (all_zero_canonical_combining_class_segment, 211)
			Result.put (all_zero_canonical_combining_class_segment, 212)
			Result.put (all_zero_canonical_combining_class_segment, 213)
			Result.put (all_zero_canonical_combining_class_segment, 214)
			Result.put (all_zero_canonical_combining_class_segment, 215)
			Result.put (all_zero_canonical_combining_class_segment, 216)
			Result.put (all_zero_canonical_combining_class_segment, 217)
			Result.put (all_zero_canonical_combining_class_segment, 218)
			Result.put (all_zero_canonical_combining_class_segment, 219)
			Result.put (all_zero_canonical_combining_class_segment, 220)
			Result.put (all_zero_canonical_combining_class_segment, 221)
			Result.put (all_zero_canonical_combining_class_segment, 222)
			Result.put (all_zero_canonical_combining_class_segment, 223)
			Result.put (all_zero_canonical_combining_class_segment, 224)
			Result.put (all_zero_canonical_combining_class_segment, 225)
			Result.put (all_zero_canonical_combining_class_segment, 226)
			Result.put (all_zero_canonical_combining_class_segment, 227)
			Result.put (all_zero_canonical_combining_class_segment, 228)
			Result.put (all_zero_canonical_combining_class_segment, 229)
			Result.put (all_zero_canonical_combining_class_segment, 230)
			Result.put (all_zero_canonical_combining_class_segment, 231)
			Result.put (all_zero_canonical_combining_class_segment, 232)
			Result.put (all_zero_canonical_combining_class_segment, 233)
			Result.put (all_zero_canonical_combining_class_segment, 234)
			Result.put (all_zero_canonical_combining_class_segment, 235)
			Result.put (all_zero_canonical_combining_class_segment, 236)
			Result.put (all_zero_canonical_combining_class_segment, 237)
			Result.put (all_zero_canonical_combining_class_segment, 238)
			Result.put (all_zero_canonical_combining_class_segment, 239)
			Result.put (all_zero_canonical_combining_class_segment, 240)
			Result.put (all_zero_canonical_combining_class_segment, 241)
			Result.put (all_zero_canonical_combining_class_segment, 242)
			Result.put (all_zero_canonical_combining_class_segment, 243)
			Result.put (all_zero_canonical_combining_class_segment, 244)
			Result.put (all_zero_canonical_combining_class_segment, 245)
			Result.put (all_zero_canonical_combining_class_segment, 246)
			Result.put (all_zero_canonical_combining_class_segment, 247)
			Result.put (all_zero_canonical_combining_class_segment, 248)
			Result.put (all_zero_canonical_combining_class_segment, 249)
			Result.put (all_zero_canonical_combining_class_segment, 250)
			Result.put (canonical_combining_class_plane_0_segment_251, 251)
			Result.put (all_zero_canonical_combining_class_segment, 252)
			Result.put (all_zero_canonical_combining_class_segment, 253)
			Result.put (canonical_combining_class_plane_0_segment_254, 254)
			Result.put (all_zero_canonical_combining_class_segment, 255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	canonical_combining_class_plane_1_segment_1: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/51/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_1_segment_10: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/51/%/0/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/1/%/51/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_1_segment_209: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/49/%/49/%/1/%/1/%/1/%/0/%/0/%/0/%/54/%/49/%/49/%/49/%/49/%/49/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/51/%/51/%/51/%/51/%/51/%/51/%/51/%/51/%/0/%/0/%/56/%/56/%/56/%/56/%/56/%/51/%/51/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/56/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_1_segment_210: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/56/%/56/%/56/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	canonical_combining_class_plane_1: SPECIAL [ARRAY [INTEGER_8]]
			-- Generated character class array plane
		once
			create Result.make_filled (all_zero_canonical_combining_class_segment, 256)
			Result.put (canonical_combining_class_plane_1_segment_1, 1)
			Result.put (all_zero_canonical_combining_class_segment, 2)
			Result.put (all_zero_canonical_combining_class_segment, 3)
			Result.put (all_zero_canonical_combining_class_segment, 4)
			Result.put (all_zero_canonical_combining_class_segment, 5)
			Result.put (all_zero_canonical_combining_class_segment, 6)
			Result.put (all_zero_canonical_combining_class_segment, 7)
			Result.put (all_zero_canonical_combining_class_segment, 8)
			Result.put (all_zero_canonical_combining_class_segment, 9)
			Result.put (canonical_combining_class_plane_1_segment_10, 10)
			Result.put (all_zero_canonical_combining_class_segment, 11)
			Result.put (all_zero_canonical_combining_class_segment, 12)
			Result.put (all_zero_canonical_combining_class_segment, 13)
			Result.put (all_zero_canonical_combining_class_segment, 14)
			Result.put (all_zero_canonical_combining_class_segment, 15)
			Result.put (all_zero_canonical_combining_class_segment, 16)
			Result.put (all_zero_canonical_combining_class_segment, 17)
			Result.put (all_zero_canonical_combining_class_segment, 18)
			Result.put (all_zero_canonical_combining_class_segment, 19)
			Result.put (all_zero_canonical_combining_class_segment, 20)
			Result.put (all_zero_canonical_combining_class_segment, 21)
			Result.put (all_zero_canonical_combining_class_segment, 22)
			Result.put (all_zero_canonical_combining_class_segment, 23)
			Result.put (all_zero_canonical_combining_class_segment, 24)
			Result.put (all_zero_canonical_combining_class_segment, 25)
			Result.put (all_zero_canonical_combining_class_segment, 26)
			Result.put (all_zero_canonical_combining_class_segment, 27)
			Result.put (all_zero_canonical_combining_class_segment, 28)
			Result.put (all_zero_canonical_combining_class_segment, 29)
			Result.put (all_zero_canonical_combining_class_segment, 30)
			Result.put (all_zero_canonical_combining_class_segment, 31)
			Result.put (all_zero_canonical_combining_class_segment, 32)
			Result.put (all_zero_canonical_combining_class_segment, 33)
			Result.put (all_zero_canonical_combining_class_segment, 34)
			Result.put (all_zero_canonical_combining_class_segment, 35)
			Result.put (all_zero_canonical_combining_class_segment, 36)
			Result.put (all_zero_canonical_combining_class_segment, 37)
			Result.put (all_zero_canonical_combining_class_segment, 38)
			Result.put (all_zero_canonical_combining_class_segment, 39)
			Result.put (all_zero_canonical_combining_class_segment, 40)
			Result.put (all_zero_canonical_combining_class_segment, 41)
			Result.put (all_zero_canonical_combining_class_segment, 42)
			Result.put (all_zero_canonical_combining_class_segment, 43)
			Result.put (all_zero_canonical_combining_class_segment, 44)
			Result.put (all_zero_canonical_combining_class_segment, 45)
			Result.put (all_zero_canonical_combining_class_segment, 46)
			Result.put (all_zero_canonical_combining_class_segment, 47)
			Result.put (all_zero_canonical_combining_class_segment, 48)
			Result.put (all_zero_canonical_combining_class_segment, 49)
			Result.put (all_zero_canonical_combining_class_segment, 50)
			Result.put (all_zero_canonical_combining_class_segment, 51)
			Result.put (all_zero_canonical_combining_class_segment, 52)
			Result.put (all_zero_canonical_combining_class_segment, 53)
			Result.put (all_zero_canonical_combining_class_segment, 54)
			Result.put (all_zero_canonical_combining_class_segment, 55)
			Result.put (all_zero_canonical_combining_class_segment, 56)
			Result.put (all_zero_canonical_combining_class_segment, 57)
			Result.put (all_zero_canonical_combining_class_segment, 58)
			Result.put (all_zero_canonical_combining_class_segment, 59)
			Result.put (all_zero_canonical_combining_class_segment, 60)
			Result.put (all_zero_canonical_combining_class_segment, 61)
			Result.put (all_zero_canonical_combining_class_segment, 62)
			Result.put (all_zero_canonical_combining_class_segment, 63)
			Result.put (all_zero_canonical_combining_class_segment, 64)
			Result.put (all_zero_canonical_combining_class_segment, 65)
			Result.put (all_zero_canonical_combining_class_segment, 66)
			Result.put (all_zero_canonical_combining_class_segment, 67)
			Result.put (all_zero_canonical_combining_class_segment, 68)
			Result.put (all_zero_canonical_combining_class_segment, 69)
			Result.put (all_zero_canonical_combining_class_segment, 70)
			Result.put (all_zero_canonical_combining_class_segment, 71)
			Result.put (all_zero_canonical_combining_class_segment, 72)
			Result.put (all_zero_canonical_combining_class_segment, 73)
			Result.put (all_zero_canonical_combining_class_segment, 74)
			Result.put (all_zero_canonical_combining_class_segment, 75)
			Result.put (all_zero_canonical_combining_class_segment, 76)
			Result.put (all_zero_canonical_combining_class_segment, 77)
			Result.put (all_zero_canonical_combining_class_segment, 78)
			Result.put (all_zero_canonical_combining_class_segment, 79)
			Result.put (all_zero_canonical_combining_class_segment, 80)
			Result.put (all_zero_canonical_combining_class_segment, 81)
			Result.put (all_zero_canonical_combining_class_segment, 82)
			Result.put (all_zero_canonical_combining_class_segment, 83)
			Result.put (all_zero_canonical_combining_class_segment, 84)
			Result.put (all_zero_canonical_combining_class_segment, 85)
			Result.put (all_zero_canonical_combining_class_segment, 86)
			Result.put (all_zero_canonical_combining_class_segment, 87)
			Result.put (all_zero_canonical_combining_class_segment, 88)
			Result.put (all_zero_canonical_combining_class_segment, 89)
			Result.put (all_zero_canonical_combining_class_segment, 90)
			Result.put (all_zero_canonical_combining_class_segment, 91)
			Result.put (all_zero_canonical_combining_class_segment, 92)
			Result.put (all_zero_canonical_combining_class_segment, 93)
			Result.put (all_zero_canonical_combining_class_segment, 94)
			Result.put (all_zero_canonical_combining_class_segment, 95)
			Result.put (all_zero_canonical_combining_class_segment, 96)
			Result.put (all_zero_canonical_combining_class_segment, 97)
			Result.put (all_zero_canonical_combining_class_segment, 98)
			Result.put (all_zero_canonical_combining_class_segment, 99)
			Result.put (all_zero_canonical_combining_class_segment, 100)
			Result.put (all_zero_canonical_combining_class_segment, 101)
			Result.put (all_zero_canonical_combining_class_segment, 102)
			Result.put (all_zero_canonical_combining_class_segment, 103)
			Result.put (all_zero_canonical_combining_class_segment, 104)
			Result.put (all_zero_canonical_combining_class_segment, 105)
			Result.put (all_zero_canonical_combining_class_segment, 106)
			Result.put (all_zero_canonical_combining_class_segment, 107)
			Result.put (all_zero_canonical_combining_class_segment, 108)
			Result.put (all_zero_canonical_combining_class_segment, 109)
			Result.put (all_zero_canonical_combining_class_segment, 110)
			Result.put (all_zero_canonical_combining_class_segment, 111)
			Result.put (all_zero_canonical_combining_class_segment, 112)
			Result.put (all_zero_canonical_combining_class_segment, 113)
			Result.put (all_zero_canonical_combining_class_segment, 114)
			Result.put (all_zero_canonical_combining_class_segment, 115)
			Result.put (all_zero_canonical_combining_class_segment, 116)
			Result.put (all_zero_canonical_combining_class_segment, 117)
			Result.put (all_zero_canonical_combining_class_segment, 118)
			Result.put (all_zero_canonical_combining_class_segment, 119)
			Result.put (all_zero_canonical_combining_class_segment, 120)
			Result.put (all_zero_canonical_combining_class_segment, 121)
			Result.put (all_zero_canonical_combining_class_segment, 122)
			Result.put (all_zero_canonical_combining_class_segment, 123)
			Result.put (all_zero_canonical_combining_class_segment, 124)
			Result.put (all_zero_canonical_combining_class_segment, 125)
			Result.put (all_zero_canonical_combining_class_segment, 126)
			Result.put (all_zero_canonical_combining_class_segment, 127)
			Result.put (all_zero_canonical_combining_class_segment, 128)
			Result.put (all_zero_canonical_combining_class_segment, 129)
			Result.put (all_zero_canonical_combining_class_segment, 130)
			Result.put (all_zero_canonical_combining_class_segment, 131)
			Result.put (all_zero_canonical_combining_class_segment, 132)
			Result.put (all_zero_canonical_combining_class_segment, 133)
			Result.put (all_zero_canonical_combining_class_segment, 134)
			Result.put (all_zero_canonical_combining_class_segment, 135)
			Result.put (all_zero_canonical_combining_class_segment, 136)
			Result.put (all_zero_canonical_combining_class_segment, 137)
			Result.put (all_zero_canonical_combining_class_segment, 138)
			Result.put (all_zero_canonical_combining_class_segment, 139)
			Result.put (all_zero_canonical_combining_class_segment, 140)
			Result.put (all_zero_canonical_combining_class_segment, 141)
			Result.put (all_zero_canonical_combining_class_segment, 142)
			Result.put (all_zero_canonical_combining_class_segment, 143)
			Result.put (all_zero_canonical_combining_class_segment, 144)
			Result.put (all_zero_canonical_combining_class_segment, 145)
			Result.put (all_zero_canonical_combining_class_segment, 146)
			Result.put (all_zero_canonical_combining_class_segment, 147)
			Result.put (all_zero_canonical_combining_class_segment, 148)
			Result.put (all_zero_canonical_combining_class_segment, 149)
			Result.put (all_zero_canonical_combining_class_segment, 150)
			Result.put (all_zero_canonical_combining_class_segment, 151)
			Result.put (all_zero_canonical_combining_class_segment, 152)
			Result.put (all_zero_canonical_combining_class_segment, 153)
			Result.put (all_zero_canonical_combining_class_segment, 154)
			Result.put (all_zero_canonical_combining_class_segment, 155)
			Result.put (all_zero_canonical_combining_class_segment, 156)
			Result.put (all_zero_canonical_combining_class_segment, 157)
			Result.put (all_zero_canonical_combining_class_segment, 158)
			Result.put (all_zero_canonical_combining_class_segment, 159)
			Result.put (all_zero_canonical_combining_class_segment, 160)
			Result.put (all_zero_canonical_combining_class_segment, 161)
			Result.put (all_zero_canonical_combining_class_segment, 162)
			Result.put (all_zero_canonical_combining_class_segment, 163)
			Result.put (all_zero_canonical_combining_class_segment, 164)
			Result.put (all_zero_canonical_combining_class_segment, 165)
			Result.put (all_zero_canonical_combining_class_segment, 166)
			Result.put (all_zero_canonical_combining_class_segment, 167)
			Result.put (all_zero_canonical_combining_class_segment, 168)
			Result.put (all_zero_canonical_combining_class_segment, 169)
			Result.put (all_zero_canonical_combining_class_segment, 170)
			Result.put (all_zero_canonical_combining_class_segment, 171)
			Result.put (all_zero_canonical_combining_class_segment, 172)
			Result.put (all_zero_canonical_combining_class_segment, 173)
			Result.put (all_zero_canonical_combining_class_segment, 174)
			Result.put (all_zero_canonical_combining_class_segment, 175)
			Result.put (all_zero_canonical_combining_class_segment, 176)
			Result.put (all_zero_canonical_combining_class_segment, 177)
			Result.put (all_zero_canonical_combining_class_segment, 178)
			Result.put (all_zero_canonical_combining_class_segment, 179)
			Result.put (all_zero_canonical_combining_class_segment, 180)
			Result.put (all_zero_canonical_combining_class_segment, 181)
			Result.put (all_zero_canonical_combining_class_segment, 182)
			Result.put (all_zero_canonical_combining_class_segment, 183)
			Result.put (all_zero_canonical_combining_class_segment, 184)
			Result.put (all_zero_canonical_combining_class_segment, 185)
			Result.put (all_zero_canonical_combining_class_segment, 186)
			Result.put (all_zero_canonical_combining_class_segment, 187)
			Result.put (all_zero_canonical_combining_class_segment, 188)
			Result.put (all_zero_canonical_combining_class_segment, 189)
			Result.put (all_zero_canonical_combining_class_segment, 190)
			Result.put (all_zero_canonical_combining_class_segment, 191)
			Result.put (all_zero_canonical_combining_class_segment, 192)
			Result.put (all_zero_canonical_combining_class_segment, 193)
			Result.put (all_zero_canonical_combining_class_segment, 194)
			Result.put (all_zero_canonical_combining_class_segment, 195)
			Result.put (all_zero_canonical_combining_class_segment, 196)
			Result.put (all_zero_canonical_combining_class_segment, 197)
			Result.put (all_zero_canonical_combining_class_segment, 198)
			Result.put (all_zero_canonical_combining_class_segment, 199)
			Result.put (all_zero_canonical_combining_class_segment, 200)
			Result.put (all_zero_canonical_combining_class_segment, 201)
			Result.put (all_zero_canonical_combining_class_segment, 202)
			Result.put (all_zero_canonical_combining_class_segment, 203)
			Result.put (all_zero_canonical_combining_class_segment, 204)
			Result.put (all_zero_canonical_combining_class_segment, 205)
			Result.put (all_zero_canonical_combining_class_segment, 206)
			Result.put (all_zero_canonical_combining_class_segment, 207)
			Result.put (all_zero_canonical_combining_class_segment, 208)
			Result.put (canonical_combining_class_plane_1_segment_209, 209)
			Result.put (canonical_combining_class_plane_1_segment_210, 210)
			Result.put (all_zero_canonical_combining_class_segment, 211)
			Result.put (all_zero_canonical_combining_class_segment, 212)
			Result.put (all_zero_canonical_combining_class_segment, 213)
			Result.put (all_zero_canonical_combining_class_segment, 214)
			Result.put (all_zero_canonical_combining_class_segment, 215)
			Result.put (all_zero_canonical_combining_class_segment, 216)
			Result.put (all_zero_canonical_combining_class_segment, 217)
			Result.put (all_zero_canonical_combining_class_segment, 218)
			Result.put (all_zero_canonical_combining_class_segment, 219)
			Result.put (all_zero_canonical_combining_class_segment, 220)
			Result.put (all_zero_canonical_combining_class_segment, 221)
			Result.put (all_zero_canonical_combining_class_segment, 222)
			Result.put (all_zero_canonical_combining_class_segment, 223)
			Result.put (all_zero_canonical_combining_class_segment, 224)
			Result.put (all_zero_canonical_combining_class_segment, 225)
			Result.put (all_zero_canonical_combining_class_segment, 226)
			Result.put (all_zero_canonical_combining_class_segment, 227)
			Result.put (all_zero_canonical_combining_class_segment, 228)
			Result.put (all_zero_canonical_combining_class_segment, 229)
			Result.put (all_zero_canonical_combining_class_segment, 230)
			Result.put (all_zero_canonical_combining_class_segment, 231)
			Result.put (all_zero_canonical_combining_class_segment, 232)
			Result.put (all_zero_canonical_combining_class_segment, 233)
			Result.put (all_zero_canonical_combining_class_segment, 234)
			Result.put (all_zero_canonical_combining_class_segment, 235)
			Result.put (all_zero_canonical_combining_class_segment, 236)
			Result.put (all_zero_canonical_combining_class_segment, 237)
			Result.put (all_zero_canonical_combining_class_segment, 238)
			Result.put (all_zero_canonical_combining_class_segment, 239)
			Result.put (all_zero_canonical_combining_class_segment, 240)
			Result.put (all_zero_canonical_combining_class_segment, 241)
			Result.put (all_zero_canonical_combining_class_segment, 242)
			Result.put (all_zero_canonical_combining_class_segment, 243)
			Result.put (all_zero_canonical_combining_class_segment, 244)
			Result.put (all_zero_canonical_combining_class_segment, 245)
			Result.put (all_zero_canonical_combining_class_segment, 246)
			Result.put (all_zero_canonical_combining_class_segment, 247)
			Result.put (all_zero_canonical_combining_class_segment, 248)
			Result.put (all_zero_canonical_combining_class_segment, 249)
			Result.put (all_zero_canonical_combining_class_segment, 250)
			Result.put (all_zero_canonical_combining_class_segment, 251)
			Result.put (all_zero_canonical_combining_class_segment, 252)
			Result.put (all_zero_canonical_combining_class_segment, 253)
			Result.put (all_zero_canonical_combining_class_segment, 254)
			Result.put (all_zero_canonical_combining_class_segment, 255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	all_zero_canonical_combining_class_plane: SPECIAL [ARRAY [INTEGER_8]]
			-- Generated character class array plane
		once
			create Result.make_filled (all_zero_canonical_combining_class_segment, 256)
		ensure
			instance_free: class
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	canonical_combining_class_properties: SPECIAL [SPECIAL [ARRAY [INTEGER_8]]]
			-- Canonical combining class for each code point
		once
			create Result.make_filled (canonical_combining_class_plane_0, 17)
			Result.put (canonical_combining_class_plane_1, 1)
			Result.put (all_zero_canonical_combining_class_plane, 2)
			Result.put (all_zero_canonical_combining_class_plane, 3)
			Result.put (all_zero_canonical_combining_class_plane, 4)
			Result.put (all_zero_canonical_combining_class_plane, 5)
			Result.put (all_zero_canonical_combining_class_plane, 6)
			Result.put (all_zero_canonical_combining_class_plane, 7)
			Result.put (all_zero_canonical_combining_class_plane, 8)
			Result.put (all_zero_canonical_combining_class_plane, 9)
			Result.put (all_zero_canonical_combining_class_plane, 10)
			Result.put (all_zero_canonical_combining_class_plane, 11)
			Result.put (all_zero_canonical_combining_class_plane, 12)
			Result.put (all_zero_canonical_combining_class_plane, 13)
			Result.put (all_zero_canonical_combining_class_plane, 14)
			Result.put (all_zero_canonical_combining_class_plane, 15)
			Result.put (all_zero_canonical_combining_class_plane, 16)
		end

	decomposition_type_plane_0_segment_0: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/8/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/8/%/8/%/16/%/16/%/0/%/0/%/16/%/8/%/8/%/0/%/15/%/15/%/15/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_1: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_2: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/16/%/16/%/16/%/16/%/0/%/0/%/8/%/8/%/8/%/8/%/8/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_3: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/16/%/0/%/0/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/16/%/0/%/16/%/16/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	all_zero_decomposition_type_segment: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_5: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_6: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_14: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_15: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_16: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/8/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_29: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/8/%/8/%/8/%/0/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/0/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/0/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/8/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_30: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_31: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_32: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/16/%/16/%/16/%/16/%/16/%/2/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/0/%/0/%/0/%/16/%/16/%/0/%/16/%/16/%/0/%/0/%/0/%/0/%/16/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/8/%/8/%/0/%/0/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_33: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/16/%/16/%/1/%/16/%/0/%/16/%/16/%/16/%/0/%/16/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/16/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/0/%/0/%/8/%/16/%/8/%/0/%/1/%/0/%/0/%/0/%/1/%/0/%/0/%/0/%/1/%/1/%/0/%/1/%/1/%/1/%/0/%/1/%/1/%/16/%/16/%/16/%/16/%/1/%/0/%/16/%/1/%/1/%/1/%/1/%/1/%/0/%/0/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/15/%/15/%/15/%/15/%/15/%/15/%/15/%/15/%/15/%/15/%/15/%/15/%/15/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_34: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/0/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_36: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_42: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_44: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/9/%/8/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_45: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/8/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_46: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_47: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_48: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/11/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/0/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/0/%/0/%/10/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/10/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_49: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/0/%/0/%/0/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/8/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_50: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/0/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/14/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/0/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/14/%/14/%/14/%/14/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_51: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/14/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/14/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_167: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/8/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_251: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/16/%/16/%/16/%/16/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/16/%/6/%/5/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/6/%/5/%/3/%/4/%/6/%/5/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/6/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/6/%/5/%/3/%/4/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/3/%/4/%/3/%/4/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/3/%/6/%/5/%/3/%/6/%/5/%/3/%/4/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_252: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_253: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/5/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/3/%/5/%/3/%/3/%/3/%/3/%/3/%/3/%/5/%/3/%/5/%/5/%/3/%/3/%/5/%/5/%/3/%/3/%/5/%/3/%/5/%/3/%/5/%/5/%/3/%/5/%/5/%/3/%/5/%/3/%/5/%/5/%/3/%/5/%/3/%/3/%/5/%/5/%/5/%/3/%/5/%/5/%/5/%/5/%/5/%/3/%/5/%/5/%/5/%/5/%/5/%/3/%/5/%/5/%/3/%/5/%/3/%/3/%/3/%/5/%/3/%/3/%/3/%/3/%/0/%/0/%/3/%/3/%/3/%/3/%/5/%/5/%/3/%/5/%/5/%/5/%/5/%/3/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/3/%/3/%/5/%/5/%/3/%/5/%/3/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/3/%/3/%/3/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_254: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/0/%/0/%/10/%/10/%/16/%/16/%/16/%/16/%/16/%/16/%/16/%/13/%/13/%/13/%/0/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/13/%/0/%/13/%/13/%/13/%/13/%/0/%/0/%/0/%/0/%/6/%/4/%/6/%/0/%/6/%/0/%/6/%/4/%/6/%/4/%/6/%/4/%/6/%/4/%/6/%/4/%/6/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/3/%/4/%/6/%/5/%/6/%/5/%/3/%/4/%/6/%/5/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/3/%/4/%/6/%/5/%/6/%/5/%/6/%/5/%/3/%/4/%/6/%/5/%/6/%/5/%/6/%/5/%/6/%/5/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0_segment_255: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/0/%/0/%/0/%/12/%/12/%/12/%/12/%/12/%/12/%/0/%/0/%/12/%/12/%/12/%/12/%/12/%/12/%/0/%/0/%/12/%/12/%/12/%/12/%/12/%/12/%/0/%/0/%/12/%/12/%/12/%/0/%/0/%/0/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/0/%/12/%/12/%/12/%/12/%/12/%/12/%/12/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_0: SPECIAL [ARRAY [INTEGER_8]]
			-- Generated character class array plane
		once
			create Result.make_filled (decomposition_type_plane_0_segment_0, 256)
			Result.put (decomposition_type_plane_0_segment_1, 1)
			Result.put (decomposition_type_plane_0_segment_2, 2)
			Result.put (decomposition_type_plane_0_segment_3, 3)
			Result.put (all_zero_decomposition_type_segment, 4)
			Result.put (decomposition_type_plane_0_segment_5, 5)
			Result.put (decomposition_type_plane_0_segment_6, 6)
			Result.put (all_zero_decomposition_type_segment, 7)
			Result.put (all_zero_decomposition_type_segment, 8)
			Result.put (all_zero_decomposition_type_segment, 9)
			Result.put (all_zero_decomposition_type_segment, 10)
			Result.put (all_zero_decomposition_type_segment, 11)
			Result.put (all_zero_decomposition_type_segment, 12)
			Result.put (all_zero_decomposition_type_segment, 13)
			Result.put (decomposition_type_plane_0_segment_14, 14)
			Result.put (decomposition_type_plane_0_segment_15, 15)
			Result.put (decomposition_type_plane_0_segment_16, 16)
			Result.put (all_zero_decomposition_type_segment, 17)
			Result.put (all_zero_decomposition_type_segment, 18)
			Result.put (all_zero_decomposition_type_segment, 19)
			Result.put (all_zero_decomposition_type_segment, 20)
			Result.put (all_zero_decomposition_type_segment, 21)
			Result.put (all_zero_decomposition_type_segment, 22)
			Result.put (all_zero_decomposition_type_segment, 23)
			Result.put (all_zero_decomposition_type_segment, 24)
			Result.put (all_zero_decomposition_type_segment, 25)
			Result.put (all_zero_decomposition_type_segment, 26)
			Result.put (all_zero_decomposition_type_segment, 27)
			Result.put (all_zero_decomposition_type_segment, 28)
			Result.put (decomposition_type_plane_0_segment_29, 29)
			Result.put (decomposition_type_plane_0_segment_30, 30)
			Result.put (decomposition_type_plane_0_segment_31, 31)
			Result.put (decomposition_type_plane_0_segment_32, 32)
			Result.put (decomposition_type_plane_0_segment_33, 33)
			Result.put (decomposition_type_plane_0_segment_34, 34)
			Result.put (all_zero_decomposition_type_segment, 35)
			Result.put (decomposition_type_plane_0_segment_36, 36)
			Result.put (all_zero_decomposition_type_segment, 37)
			Result.put (all_zero_decomposition_type_segment, 38)
			Result.put (all_zero_decomposition_type_segment, 39)
			Result.put (all_zero_decomposition_type_segment, 40)
			Result.put (all_zero_decomposition_type_segment, 41)
			Result.put (decomposition_type_plane_0_segment_42, 42)
			Result.put (all_zero_decomposition_type_segment, 43)
			Result.put (decomposition_type_plane_0_segment_44, 44)
			Result.put (decomposition_type_plane_0_segment_45, 45)
			Result.put (decomposition_type_plane_0_segment_46, 46)
			Result.put (decomposition_type_plane_0_segment_47, 47)
			Result.put (decomposition_type_plane_0_segment_48, 48)
			Result.put (decomposition_type_plane_0_segment_49, 49)
			Result.put (decomposition_type_plane_0_segment_50, 50)
			Result.put (decomposition_type_plane_0_segment_51, 51)
			Result.put (all_zero_decomposition_type_segment, 52)
			Result.put (all_zero_decomposition_type_segment, 53)
			Result.put (all_zero_decomposition_type_segment, 54)
			Result.put (all_zero_decomposition_type_segment, 55)
			Result.put (all_zero_decomposition_type_segment, 56)
			Result.put (all_zero_decomposition_type_segment, 57)
			Result.put (all_zero_decomposition_type_segment, 58)
			Result.put (all_zero_decomposition_type_segment, 59)
			Result.put (all_zero_decomposition_type_segment, 60)
			Result.put (all_zero_decomposition_type_segment, 61)
			Result.put (all_zero_decomposition_type_segment, 62)
			Result.put (all_zero_decomposition_type_segment, 63)
			Result.put (all_zero_decomposition_type_segment, 64)
			Result.put (all_zero_decomposition_type_segment, 65)
			Result.put (all_zero_decomposition_type_segment, 66)
			Result.put (all_zero_decomposition_type_segment, 67)
			Result.put (all_zero_decomposition_type_segment, 68)
			Result.put (all_zero_decomposition_type_segment, 69)
			Result.put (all_zero_decomposition_type_segment, 70)
			Result.put (all_zero_decomposition_type_segment, 71)
			Result.put (all_zero_decomposition_type_segment, 72)
			Result.put (all_zero_decomposition_type_segment, 73)
			Result.put (all_zero_decomposition_type_segment, 74)
			Result.put (all_zero_decomposition_type_segment, 75)
			Result.put (all_zero_decomposition_type_segment, 76)
			Result.put (all_zero_decomposition_type_segment, 77)
			Result.put (all_zero_decomposition_type_segment, 78)
			Result.put (all_zero_decomposition_type_segment, 79)
			Result.put (all_zero_decomposition_type_segment, 80)
			Result.put (all_zero_decomposition_type_segment, 81)
			Result.put (all_zero_decomposition_type_segment, 82)
			Result.put (all_zero_decomposition_type_segment, 83)
			Result.put (all_zero_decomposition_type_segment, 84)
			Result.put (all_zero_decomposition_type_segment, 85)
			Result.put (all_zero_decomposition_type_segment, 86)
			Result.put (all_zero_decomposition_type_segment, 87)
			Result.put (all_zero_decomposition_type_segment, 88)
			Result.put (all_zero_decomposition_type_segment, 89)
			Result.put (all_zero_decomposition_type_segment, 90)
			Result.put (all_zero_decomposition_type_segment, 91)
			Result.put (all_zero_decomposition_type_segment, 92)
			Result.put (all_zero_decomposition_type_segment, 93)
			Result.put (all_zero_decomposition_type_segment, 94)
			Result.put (all_zero_decomposition_type_segment, 95)
			Result.put (all_zero_decomposition_type_segment, 96)
			Result.put (all_zero_decomposition_type_segment, 97)
			Result.put (all_zero_decomposition_type_segment, 98)
			Result.put (all_zero_decomposition_type_segment, 99)
			Result.put (all_zero_decomposition_type_segment, 100)
			Result.put (all_zero_decomposition_type_segment, 101)
			Result.put (all_zero_decomposition_type_segment, 102)
			Result.put (all_zero_decomposition_type_segment, 103)
			Result.put (all_zero_decomposition_type_segment, 104)
			Result.put (all_zero_decomposition_type_segment, 105)
			Result.put (all_zero_decomposition_type_segment, 106)
			Result.put (all_zero_decomposition_type_segment, 107)
			Result.put (all_zero_decomposition_type_segment, 108)
			Result.put (all_zero_decomposition_type_segment, 109)
			Result.put (all_zero_decomposition_type_segment, 110)
			Result.put (all_zero_decomposition_type_segment, 111)
			Result.put (all_zero_decomposition_type_segment, 112)
			Result.put (all_zero_decomposition_type_segment, 113)
			Result.put (all_zero_decomposition_type_segment, 114)
			Result.put (all_zero_decomposition_type_segment, 115)
			Result.put (all_zero_decomposition_type_segment, 116)
			Result.put (all_zero_decomposition_type_segment, 117)
			Result.put (all_zero_decomposition_type_segment, 118)
			Result.put (all_zero_decomposition_type_segment, 119)
			Result.put (all_zero_decomposition_type_segment, 120)
			Result.put (all_zero_decomposition_type_segment, 121)
			Result.put (all_zero_decomposition_type_segment, 122)
			Result.put (all_zero_decomposition_type_segment, 123)
			Result.put (all_zero_decomposition_type_segment, 124)
			Result.put (all_zero_decomposition_type_segment, 125)
			Result.put (all_zero_decomposition_type_segment, 126)
			Result.put (all_zero_decomposition_type_segment, 127)
			Result.put (all_zero_decomposition_type_segment, 128)
			Result.put (all_zero_decomposition_type_segment, 129)
			Result.put (all_zero_decomposition_type_segment, 130)
			Result.put (all_zero_decomposition_type_segment, 131)
			Result.put (all_zero_decomposition_type_segment, 132)
			Result.put (all_zero_decomposition_type_segment, 133)
			Result.put (all_zero_decomposition_type_segment, 134)
			Result.put (all_zero_decomposition_type_segment, 135)
			Result.put (all_zero_decomposition_type_segment, 136)
			Result.put (all_zero_decomposition_type_segment, 137)
			Result.put (all_zero_decomposition_type_segment, 138)
			Result.put (all_zero_decomposition_type_segment, 139)
			Result.put (all_zero_decomposition_type_segment, 140)
			Result.put (all_zero_decomposition_type_segment, 141)
			Result.put (all_zero_decomposition_type_segment, 142)
			Result.put (all_zero_decomposition_type_segment, 143)
			Result.put (all_zero_decomposition_type_segment, 144)
			Result.put (all_zero_decomposition_type_segment, 145)
			Result.put (all_zero_decomposition_type_segment, 146)
			Result.put (all_zero_decomposition_type_segment, 147)
			Result.put (all_zero_decomposition_type_segment, 148)
			Result.put (all_zero_decomposition_type_segment, 149)
			Result.put (all_zero_decomposition_type_segment, 150)
			Result.put (all_zero_decomposition_type_segment, 151)
			Result.put (all_zero_decomposition_type_segment, 152)
			Result.put (all_zero_decomposition_type_segment, 153)
			Result.put (all_zero_decomposition_type_segment, 154)
			Result.put (all_zero_decomposition_type_segment, 155)
			Result.put (all_zero_decomposition_type_segment, 156)
			Result.put (all_zero_decomposition_type_segment, 157)
			Result.put (all_zero_decomposition_type_segment, 158)
			Result.put (all_zero_decomposition_type_segment, 159)
			Result.put (all_zero_decomposition_type_segment, 160)
			Result.put (all_zero_decomposition_type_segment, 161)
			Result.put (all_zero_decomposition_type_segment, 162)
			Result.put (all_zero_decomposition_type_segment, 163)
			Result.put (all_zero_decomposition_type_segment, 164)
			Result.put (all_zero_decomposition_type_segment, 165)
			Result.put (all_zero_decomposition_type_segment, 166)
			Result.put (decomposition_type_plane_0_segment_167, 167)
			Result.put (all_zero_decomposition_type_segment, 168)
			Result.put (all_zero_decomposition_type_segment, 169)
			Result.put (all_zero_decomposition_type_segment, 170)
			Result.put (all_zero_decomposition_type_segment, 171)
			Result.put (all_zero_decomposition_type_segment, 172)
			Result.put (all_zero_decomposition_type_segment, 173)
			Result.put (all_zero_decomposition_type_segment, 174)
			Result.put (all_zero_decomposition_type_segment, 175)
			Result.put (all_zero_decomposition_type_segment, 176)
			Result.put (all_zero_decomposition_type_segment, 177)
			Result.put (all_zero_decomposition_type_segment, 178)
			Result.put (all_zero_decomposition_type_segment, 179)
			Result.put (all_zero_decomposition_type_segment, 180)
			Result.put (all_zero_decomposition_type_segment, 181)
			Result.put (all_zero_decomposition_type_segment, 182)
			Result.put (all_zero_decomposition_type_segment, 183)
			Result.put (all_zero_decomposition_type_segment, 184)
			Result.put (all_zero_decomposition_type_segment, 185)
			Result.put (all_zero_decomposition_type_segment, 186)
			Result.put (all_zero_decomposition_type_segment, 187)
			Result.put (all_zero_decomposition_type_segment, 188)
			Result.put (all_zero_decomposition_type_segment, 189)
			Result.put (all_zero_decomposition_type_segment, 190)
			Result.put (all_zero_decomposition_type_segment, 191)
			Result.put (all_zero_decomposition_type_segment, 192)
			Result.put (all_zero_decomposition_type_segment, 193)
			Result.put (all_zero_decomposition_type_segment, 194)
			Result.put (all_zero_decomposition_type_segment, 195)
			Result.put (all_zero_decomposition_type_segment, 196)
			Result.put (all_zero_decomposition_type_segment, 197)
			Result.put (all_zero_decomposition_type_segment, 198)
			Result.put (all_zero_decomposition_type_segment, 199)
			Result.put (all_zero_decomposition_type_segment, 200)
			Result.put (all_zero_decomposition_type_segment, 201)
			Result.put (all_zero_decomposition_type_segment, 202)
			Result.put (all_zero_decomposition_type_segment, 203)
			Result.put (all_zero_decomposition_type_segment, 204)
			Result.put (all_zero_decomposition_type_segment, 205)
			Result.put (all_zero_decomposition_type_segment, 206)
			Result.put (all_zero_decomposition_type_segment, 207)
			Result.put (all_zero_decomposition_type_segment, 208)
			Result.put (all_zero_decomposition_type_segment, 209)
			Result.put (all_zero_decomposition_type_segment, 210)
			Result.put (all_zero_decomposition_type_segment, 211)
			Result.put (all_zero_decomposition_type_segment, 212)
			Result.put (all_zero_decomposition_type_segment, 213)
			Result.put (all_zero_decomposition_type_segment, 214)
			Result.put (all_zero_decomposition_type_segment, 215)
			Result.put (all_zero_decomposition_type_segment, 216)
			Result.put (all_zero_decomposition_type_segment, 217)
			Result.put (all_zero_decomposition_type_segment, 218)
			Result.put (all_zero_decomposition_type_segment, 219)
			Result.put (all_zero_decomposition_type_segment, 220)
			Result.put (all_zero_decomposition_type_segment, 221)
			Result.put (all_zero_decomposition_type_segment, 222)
			Result.put (all_zero_decomposition_type_segment, 223)
			Result.put (all_zero_decomposition_type_segment, 224)
			Result.put (all_zero_decomposition_type_segment, 225)
			Result.put (all_zero_decomposition_type_segment, 226)
			Result.put (all_zero_decomposition_type_segment, 227)
			Result.put (all_zero_decomposition_type_segment, 228)
			Result.put (all_zero_decomposition_type_segment, 229)
			Result.put (all_zero_decomposition_type_segment, 230)
			Result.put (all_zero_decomposition_type_segment, 231)
			Result.put (all_zero_decomposition_type_segment, 232)
			Result.put (all_zero_decomposition_type_segment, 233)
			Result.put (all_zero_decomposition_type_segment, 234)
			Result.put (all_zero_decomposition_type_segment, 235)
			Result.put (all_zero_decomposition_type_segment, 236)
			Result.put (all_zero_decomposition_type_segment, 237)
			Result.put (all_zero_decomposition_type_segment, 238)
			Result.put (all_zero_decomposition_type_segment, 239)
			Result.put (all_zero_decomposition_type_segment, 240)
			Result.put (all_zero_decomposition_type_segment, 241)
			Result.put (all_zero_decomposition_type_segment, 242)
			Result.put (all_zero_decomposition_type_segment, 243)
			Result.put (all_zero_decomposition_type_segment, 244)
			Result.put (all_zero_decomposition_type_segment, 245)
			Result.put (all_zero_decomposition_type_segment, 246)
			Result.put (all_zero_decomposition_type_segment, 247)
			Result.put (all_zero_decomposition_type_segment, 248)
			Result.put (all_zero_decomposition_type_segment, 249)
			Result.put (all_zero_decomposition_type_segment, 250)
			Result.put (decomposition_type_plane_0_segment_251, 251)
			Result.put (decomposition_type_plane_0_segment_252, 252)
			Result.put (decomposition_type_plane_0_segment_253, 253)
			Result.put (decomposition_type_plane_0_segment_254, 254)
			Result.put (decomposition_type_plane_0_segment_255, 255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	decomposition_type_plane_1_segment_212: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/0/%/0/%/1/%/0/%/0/%/1/%/1/%/0/%/0/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_1_segment_213: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/0/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_1_segment_214: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_1_segment_215: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/")
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_type_plane_1: SPECIAL [ARRAY [INTEGER_8]]
			-- Generated character class array plane
		once
			create Result.make_filled (all_zero_decomposition_type_segment, 256)
			Result.put (all_zero_decomposition_type_segment, 1)
			Result.put (all_zero_decomposition_type_segment, 2)
			Result.put (all_zero_decomposition_type_segment, 3)
			Result.put (all_zero_decomposition_type_segment, 4)
			Result.put (all_zero_decomposition_type_segment, 5)
			Result.put (all_zero_decomposition_type_segment, 6)
			Result.put (all_zero_decomposition_type_segment, 7)
			Result.put (all_zero_decomposition_type_segment, 8)
			Result.put (all_zero_decomposition_type_segment, 9)
			Result.put (all_zero_decomposition_type_segment, 10)
			Result.put (all_zero_decomposition_type_segment, 11)
			Result.put (all_zero_decomposition_type_segment, 12)
			Result.put (all_zero_decomposition_type_segment, 13)
			Result.put (all_zero_decomposition_type_segment, 14)
			Result.put (all_zero_decomposition_type_segment, 15)
			Result.put (all_zero_decomposition_type_segment, 16)
			Result.put (all_zero_decomposition_type_segment, 17)
			Result.put (all_zero_decomposition_type_segment, 18)
			Result.put (all_zero_decomposition_type_segment, 19)
			Result.put (all_zero_decomposition_type_segment, 20)
			Result.put (all_zero_decomposition_type_segment, 21)
			Result.put (all_zero_decomposition_type_segment, 22)
			Result.put (all_zero_decomposition_type_segment, 23)
			Result.put (all_zero_decomposition_type_segment, 24)
			Result.put (all_zero_decomposition_type_segment, 25)
			Result.put (all_zero_decomposition_type_segment, 26)
			Result.put (all_zero_decomposition_type_segment, 27)
			Result.put (all_zero_decomposition_type_segment, 28)
			Result.put (all_zero_decomposition_type_segment, 29)
			Result.put (all_zero_decomposition_type_segment, 30)
			Result.put (all_zero_decomposition_type_segment, 31)
			Result.put (all_zero_decomposition_type_segment, 32)
			Result.put (all_zero_decomposition_type_segment, 33)
			Result.put (all_zero_decomposition_type_segment, 34)
			Result.put (all_zero_decomposition_type_segment, 35)
			Result.put (all_zero_decomposition_type_segment, 36)
			Result.put (all_zero_decomposition_type_segment, 37)
			Result.put (all_zero_decomposition_type_segment, 38)
			Result.put (all_zero_decomposition_type_segment, 39)
			Result.put (all_zero_decomposition_type_segment, 40)
			Result.put (all_zero_decomposition_type_segment, 41)
			Result.put (all_zero_decomposition_type_segment, 42)
			Result.put (all_zero_decomposition_type_segment, 43)
			Result.put (all_zero_decomposition_type_segment, 44)
			Result.put (all_zero_decomposition_type_segment, 45)
			Result.put (all_zero_decomposition_type_segment, 46)
			Result.put (all_zero_decomposition_type_segment, 47)
			Result.put (all_zero_decomposition_type_segment, 48)
			Result.put (all_zero_decomposition_type_segment, 49)
			Result.put (all_zero_decomposition_type_segment, 50)
			Result.put (all_zero_decomposition_type_segment, 51)
			Result.put (all_zero_decomposition_type_segment, 52)
			Result.put (all_zero_decomposition_type_segment, 53)
			Result.put (all_zero_decomposition_type_segment, 54)
			Result.put (all_zero_decomposition_type_segment, 55)
			Result.put (all_zero_decomposition_type_segment, 56)
			Result.put (all_zero_decomposition_type_segment, 57)
			Result.put (all_zero_decomposition_type_segment, 58)
			Result.put (all_zero_decomposition_type_segment, 59)
			Result.put (all_zero_decomposition_type_segment, 60)
			Result.put (all_zero_decomposition_type_segment, 61)
			Result.put (all_zero_decomposition_type_segment, 62)
			Result.put (all_zero_decomposition_type_segment, 63)
			Result.put (all_zero_decomposition_type_segment, 64)
			Result.put (all_zero_decomposition_type_segment, 65)
			Result.put (all_zero_decomposition_type_segment, 66)
			Result.put (all_zero_decomposition_type_segment, 67)
			Result.put (all_zero_decomposition_type_segment, 68)
			Result.put (all_zero_decomposition_type_segment, 69)
			Result.put (all_zero_decomposition_type_segment, 70)
			Result.put (all_zero_decomposition_type_segment, 71)
			Result.put (all_zero_decomposition_type_segment, 72)
			Result.put (all_zero_decomposition_type_segment, 73)
			Result.put (all_zero_decomposition_type_segment, 74)
			Result.put (all_zero_decomposition_type_segment, 75)
			Result.put (all_zero_decomposition_type_segment, 76)
			Result.put (all_zero_decomposition_type_segment, 77)
			Result.put (all_zero_decomposition_type_segment, 78)
			Result.put (all_zero_decomposition_type_segment, 79)
			Result.put (all_zero_decomposition_type_segment, 80)
			Result.put (all_zero_decomposition_type_segment, 81)
			Result.put (all_zero_decomposition_type_segment, 82)
			Result.put (all_zero_decomposition_type_segment, 83)
			Result.put (all_zero_decomposition_type_segment, 84)
			Result.put (all_zero_decomposition_type_segment, 85)
			Result.put (all_zero_decomposition_type_segment, 86)
			Result.put (all_zero_decomposition_type_segment, 87)
			Result.put (all_zero_decomposition_type_segment, 88)
			Result.put (all_zero_decomposition_type_segment, 89)
			Result.put (all_zero_decomposition_type_segment, 90)
			Result.put (all_zero_decomposition_type_segment, 91)
			Result.put (all_zero_decomposition_type_segment, 92)
			Result.put (all_zero_decomposition_type_segment, 93)
			Result.put (all_zero_decomposition_type_segment, 94)
			Result.put (all_zero_decomposition_type_segment, 95)
			Result.put (all_zero_decomposition_type_segment, 96)
			Result.put (all_zero_decomposition_type_segment, 97)
			Result.put (all_zero_decomposition_type_segment, 98)
			Result.put (all_zero_decomposition_type_segment, 99)
			Result.put (all_zero_decomposition_type_segment, 100)
			Result.put (all_zero_decomposition_type_segment, 101)
			Result.put (all_zero_decomposition_type_segment, 102)
			Result.put (all_zero_decomposition_type_segment, 103)
			Result.put (all_zero_decomposition_type_segment, 104)
			Result.put (all_zero_decomposition_type_segment, 105)
			Result.put (all_zero_decomposition_type_segment, 106)
			Result.put (all_zero_decomposition_type_segment, 107)
			Result.put (all_zero_decomposition_type_segment, 108)
			Result.put (all_zero_decomposition_type_segment, 109)
			Result.put (all_zero_decomposition_type_segment, 110)
			Result.put (all_zero_decomposition_type_segment, 111)
			Result.put (all_zero_decomposition_type_segment, 112)
			Result.put (all_zero_decomposition_type_segment, 113)
			Result.put (all_zero_decomposition_type_segment, 114)
			Result.put (all_zero_decomposition_type_segment, 115)
			Result.put (all_zero_decomposition_type_segment, 116)
			Result.put (all_zero_decomposition_type_segment, 117)
			Result.put (all_zero_decomposition_type_segment, 118)
			Result.put (all_zero_decomposition_type_segment, 119)
			Result.put (all_zero_decomposition_type_segment, 120)
			Result.put (all_zero_decomposition_type_segment, 121)
			Result.put (all_zero_decomposition_type_segment, 122)
			Result.put (all_zero_decomposition_type_segment, 123)
			Result.put (all_zero_decomposition_type_segment, 124)
			Result.put (all_zero_decomposition_type_segment, 125)
			Result.put (all_zero_decomposition_type_segment, 126)
			Result.put (all_zero_decomposition_type_segment, 127)
			Result.put (all_zero_decomposition_type_segment, 128)
			Result.put (all_zero_decomposition_type_segment, 129)
			Result.put (all_zero_decomposition_type_segment, 130)
			Result.put (all_zero_decomposition_type_segment, 131)
			Result.put (all_zero_decomposition_type_segment, 132)
			Result.put (all_zero_decomposition_type_segment, 133)
			Result.put (all_zero_decomposition_type_segment, 134)
			Result.put (all_zero_decomposition_type_segment, 135)
			Result.put (all_zero_decomposition_type_segment, 136)
			Result.put (all_zero_decomposition_type_segment, 137)
			Result.put (all_zero_decomposition_type_segment, 138)
			Result.put (all_zero_decomposition_type_segment, 139)
			Result.put (all_zero_decomposition_type_segment, 140)
			Result.put (all_zero_decomposition_type_segment, 141)
			Result.put (all_zero_decomposition_type_segment, 142)
			Result.put (all_zero_decomposition_type_segment, 143)
			Result.put (all_zero_decomposition_type_segment, 144)
			Result.put (all_zero_decomposition_type_segment, 145)
			Result.put (all_zero_decomposition_type_segment, 146)
			Result.put (all_zero_decomposition_type_segment, 147)
			Result.put (all_zero_decomposition_type_segment, 148)
			Result.put (all_zero_decomposition_type_segment, 149)
			Result.put (all_zero_decomposition_type_segment, 150)
			Result.put (all_zero_decomposition_type_segment, 151)
			Result.put (all_zero_decomposition_type_segment, 152)
			Result.put (all_zero_decomposition_type_segment, 153)
			Result.put (all_zero_decomposition_type_segment, 154)
			Result.put (all_zero_decomposition_type_segment, 155)
			Result.put (all_zero_decomposition_type_segment, 156)
			Result.put (all_zero_decomposition_type_segment, 157)
			Result.put (all_zero_decomposition_type_segment, 158)
			Result.put (all_zero_decomposition_type_segment, 159)
			Result.put (all_zero_decomposition_type_segment, 160)
			Result.put (all_zero_decomposition_type_segment, 161)
			Result.put (all_zero_decomposition_type_segment, 162)
			Result.put (all_zero_decomposition_type_segment, 163)
			Result.put (all_zero_decomposition_type_segment, 164)
			Result.put (all_zero_decomposition_type_segment, 165)
			Result.put (all_zero_decomposition_type_segment, 166)
			Result.put (all_zero_decomposition_type_segment, 167)
			Result.put (all_zero_decomposition_type_segment, 168)
			Result.put (all_zero_decomposition_type_segment, 169)
			Result.put (all_zero_decomposition_type_segment, 170)
			Result.put (all_zero_decomposition_type_segment, 171)
			Result.put (all_zero_decomposition_type_segment, 172)
			Result.put (all_zero_decomposition_type_segment, 173)
			Result.put (all_zero_decomposition_type_segment, 174)
			Result.put (all_zero_decomposition_type_segment, 175)
			Result.put (all_zero_decomposition_type_segment, 176)
			Result.put (all_zero_decomposition_type_segment, 177)
			Result.put (all_zero_decomposition_type_segment, 178)
			Result.put (all_zero_decomposition_type_segment, 179)
			Result.put (all_zero_decomposition_type_segment, 180)
			Result.put (all_zero_decomposition_type_segment, 181)
			Result.put (all_zero_decomposition_type_segment, 182)
			Result.put (all_zero_decomposition_type_segment, 183)
			Result.put (all_zero_decomposition_type_segment, 184)
			Result.put (all_zero_decomposition_type_segment, 185)
			Result.put (all_zero_decomposition_type_segment, 186)
			Result.put (all_zero_decomposition_type_segment, 187)
			Result.put (all_zero_decomposition_type_segment, 188)
			Result.put (all_zero_decomposition_type_segment, 189)
			Result.put (all_zero_decomposition_type_segment, 190)
			Result.put (all_zero_decomposition_type_segment, 191)
			Result.put (all_zero_decomposition_type_segment, 192)
			Result.put (all_zero_decomposition_type_segment, 193)
			Result.put (all_zero_decomposition_type_segment, 194)
			Result.put (all_zero_decomposition_type_segment, 195)
			Result.put (all_zero_decomposition_type_segment, 196)
			Result.put (all_zero_decomposition_type_segment, 197)
			Result.put (all_zero_decomposition_type_segment, 198)
			Result.put (all_zero_decomposition_type_segment, 199)
			Result.put (all_zero_decomposition_type_segment, 200)
			Result.put (all_zero_decomposition_type_segment, 201)
			Result.put (all_zero_decomposition_type_segment, 202)
			Result.put (all_zero_decomposition_type_segment, 203)
			Result.put (all_zero_decomposition_type_segment, 204)
			Result.put (all_zero_decomposition_type_segment, 205)
			Result.put (all_zero_decomposition_type_segment, 206)
			Result.put (all_zero_decomposition_type_segment, 207)
			Result.put (all_zero_decomposition_type_segment, 208)
			Result.put (all_zero_decomposition_type_segment, 209)
			Result.put (all_zero_decomposition_type_segment, 210)
			Result.put (all_zero_decomposition_type_segment, 211)
			Result.put (decomposition_type_plane_1_segment_212, 212)
			Result.put (decomposition_type_plane_1_segment_213, 213)
			Result.put (decomposition_type_plane_1_segment_214, 214)
			Result.put (decomposition_type_plane_1_segment_215, 215)
			Result.put (all_zero_decomposition_type_segment, 216)
			Result.put (all_zero_decomposition_type_segment, 217)
			Result.put (all_zero_decomposition_type_segment, 218)
			Result.put (all_zero_decomposition_type_segment, 219)
			Result.put (all_zero_decomposition_type_segment, 220)
			Result.put (all_zero_decomposition_type_segment, 221)
			Result.put (all_zero_decomposition_type_segment, 222)
			Result.put (all_zero_decomposition_type_segment, 223)
			Result.put (all_zero_decomposition_type_segment, 224)
			Result.put (all_zero_decomposition_type_segment, 225)
			Result.put (all_zero_decomposition_type_segment, 226)
			Result.put (all_zero_decomposition_type_segment, 227)
			Result.put (all_zero_decomposition_type_segment, 228)
			Result.put (all_zero_decomposition_type_segment, 229)
			Result.put (all_zero_decomposition_type_segment, 230)
			Result.put (all_zero_decomposition_type_segment, 231)
			Result.put (all_zero_decomposition_type_segment, 232)
			Result.put (all_zero_decomposition_type_segment, 233)
			Result.put (all_zero_decomposition_type_segment, 234)
			Result.put (all_zero_decomposition_type_segment, 235)
			Result.put (all_zero_decomposition_type_segment, 236)
			Result.put (all_zero_decomposition_type_segment, 237)
			Result.put (all_zero_decomposition_type_segment, 238)
			Result.put (all_zero_decomposition_type_segment, 239)
			Result.put (all_zero_decomposition_type_segment, 240)
			Result.put (all_zero_decomposition_type_segment, 241)
			Result.put (all_zero_decomposition_type_segment, 242)
			Result.put (all_zero_decomposition_type_segment, 243)
			Result.put (all_zero_decomposition_type_segment, 244)
			Result.put (all_zero_decomposition_type_segment, 245)
			Result.put (all_zero_decomposition_type_segment, 246)
			Result.put (all_zero_decomposition_type_segment, 247)
			Result.put (all_zero_decomposition_type_segment, 248)
			Result.put (all_zero_decomposition_type_segment, 249)
			Result.put (all_zero_decomposition_type_segment, 250)
			Result.put (all_zero_decomposition_type_segment, 251)
			Result.put (all_zero_decomposition_type_segment, 252)
			Result.put (all_zero_decomposition_type_segment, 253)
			Result.put (all_zero_decomposition_type_segment, 254)
			Result.put (all_zero_decomposition_type_segment, 255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	all_zero_decomposition_type_plane: SPECIAL [ARRAY [INTEGER_8]]
			-- Generated character class array plane
		once
			create Result.make_filled (all_zero_decomposition_type_segment, 256)
		ensure
			instance_free: class
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	decomposition_type_properties: SPECIAL [SPECIAL [ARRAY [INTEGER_8]]]
			-- Decomposition type for each code point
		once
			create Result.make_filled (decomposition_type_plane_0, 17)
			Result.put (decomposition_type_plane_1, 1)
			Result.put (all_zero_decomposition_type_plane, 2)
			Result.put (all_zero_decomposition_type_plane, 3)
			Result.put (all_zero_decomposition_type_plane, 4)
			Result.put (all_zero_decomposition_type_plane, 5)
			Result.put (all_zero_decomposition_type_plane, 6)
			Result.put (all_zero_decomposition_type_plane, 7)
			Result.put (all_zero_decomposition_type_plane, 8)
			Result.put (all_zero_decomposition_type_plane, 9)
			Result.put (all_zero_decomposition_type_plane, 10)
			Result.put (all_zero_decomposition_type_plane, 11)
			Result.put (all_zero_decomposition_type_plane, 12)
			Result.put (all_zero_decomposition_type_plane, 13)
			Result.put (all_zero_decomposition_type_plane, 14)
			Result.put (all_zero_decomposition_type_plane, 15)
			Result.put (all_zero_decomposition_type_plane, 16)
		end

	decomposition_mapping_plane_0_segment_0: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (32),160)
			Result.put (new_pair (32,776),168)
			Result.put (new_singleton (97),170)
			Result.put (new_pair (32,772),175)
			Result.put (new_singleton (50),178)
			Result.put (new_singleton (51),179)
			Result.put (new_pair (32,769),180)
			Result.put (new_singleton (956),181)
			Result.put (new_pair (32,807),184)
			Result.put (new_singleton (49),185)
			Result.put (new_singleton (111),186)
			Result.put (new_triple (49,8260,52),188)
			Result.put (new_triple (49,8260,50),189)
			Result.put (new_triple (51,8260,52),190)
			Result.put (new_pair (65,768),192)
			Result.put (new_pair (65,769),193)
			Result.put (new_pair (65,770),194)
			Result.put (new_pair (65,771),195)
			Result.put (new_pair (65,776),196)
			Result.put (new_pair (65,778),197)
			Result.put (new_pair (67,807),199)
			Result.put (new_pair (69,768),200)
			Result.put (new_pair (69,769),201)
			Result.put (new_pair (69,770),202)
			Result.put (new_pair (69,776),203)
			Result.put (new_pair (73,768),204)
			Result.put (new_pair (73,769),205)
			Result.put (new_pair (73,770),206)
			Result.put (new_pair (73,776),207)
			Result.put (new_pair (78,771),209)
			Result.put (new_pair (79,768),210)
			Result.put (new_pair (79,769),211)
			Result.put (new_pair (79,770),212)
			Result.put (new_pair (79,771),213)
			Result.put (new_pair (79,776),214)
			Result.put (new_pair (85,768),217)
			Result.put (new_pair (85,769),218)
			Result.put (new_pair (85,770),219)
			Result.put (new_pair (85,776),220)
			Result.put (new_pair (89,769),221)
			Result.put (new_pair (97,768),224)
			Result.put (new_pair (97,769),225)
			Result.put (new_pair (97,770),226)
			Result.put (new_pair (97,771),227)
			Result.put (new_pair (97,776),228)
			Result.put (new_pair (97,778),229)
			Result.put (new_pair (99,807),231)
			Result.put (new_pair (101,768),232)
			Result.put (new_pair (101,769),233)
			Result.put (new_pair (101,770),234)
			Result.put (new_pair (101,776),235)
			Result.put (new_pair (105,768),236)
			Result.put (new_pair (105,769),237)
			Result.put (new_pair (105,770),238)
			Result.put (new_pair (105,776),239)
			Result.put (new_pair (110,771),241)
			Result.put (new_pair (111,768),242)
			Result.put (new_pair (111,769),243)
			Result.put (new_pair (111,770),244)
			Result.put (new_pair (111,771),245)
			Result.put (new_pair (111,776),246)
			Result.put (new_pair (117,768),249)
			Result.put (new_pair (117,769),250)
			Result.put (new_pair (117,770),251)
			Result.put (new_pair (117,776),252)
			Result.put (new_pair (121,769),253)
			Result.put (new_pair (121,776),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_1: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (65,772),0)
			Result.put (new_pair (97,772),1)
			Result.put (new_pair (65,774),2)
			Result.put (new_pair (97,774),3)
			Result.put (new_pair (65,808),4)
			Result.put (new_pair (97,808),5)
			Result.put (new_pair (67,769),6)
			Result.put (new_pair (99,769),7)
			Result.put (new_pair (67,770),8)
			Result.put (new_pair (99,770),9)
			Result.put (new_pair (67,775),10)
			Result.put (new_pair (99,775),11)
			Result.put (new_pair (67,780),12)
			Result.put (new_pair (99,780),13)
			Result.put (new_pair (68,780),14)
			Result.put (new_pair (100,780),15)
			Result.put (new_pair (69,772),18)
			Result.put (new_pair (101,772),19)
			Result.put (new_pair (69,774),20)
			Result.put (new_pair (101,774),21)
			Result.put (new_pair (69,775),22)
			Result.put (new_pair (101,775),23)
			Result.put (new_pair (69,808),24)
			Result.put (new_pair (101,808),25)
			Result.put (new_pair (69,780),26)
			Result.put (new_pair (101,780),27)
			Result.put (new_pair (71,770),28)
			Result.put (new_pair (103,770),29)
			Result.put (new_pair (71,774),30)
			Result.put (new_pair (103,774),31)
			Result.put (new_pair (71,775),32)
			Result.put (new_pair (103,775),33)
			Result.put (new_pair (71,807),34)
			Result.put (new_pair (103,807),35)
			Result.put (new_pair (72,770),36)
			Result.put (new_pair (104,770),37)
			Result.put (new_pair (73,771),40)
			Result.put (new_pair (105,771),41)
			Result.put (new_pair (73,772),42)
			Result.put (new_pair (105,772),43)
			Result.put (new_pair (73,774),44)
			Result.put (new_pair (105,774),45)
			Result.put (new_pair (73,808),46)
			Result.put (new_pair (105,808),47)
			Result.put (new_pair (73,775),48)
			Result.put (new_pair (73,74),50)
			Result.put (new_pair (105,106),51)
			Result.put (new_pair (74,770),52)
			Result.put (new_pair (106,770),53)
			Result.put (new_pair (75,807),54)
			Result.put (new_pair (107,807),55)
			Result.put (new_pair (76,769),57)
			Result.put (new_pair (108,769),58)
			Result.put (new_pair (76,807),59)
			Result.put (new_pair (108,807),60)
			Result.put (new_pair (76,780),61)
			Result.put (new_pair (108,780),62)
			Result.put (new_pair (76,183),63)
			Result.put (new_pair (108,183),64)
			Result.put (new_pair (78,769),67)
			Result.put (new_pair (110,769),68)
			Result.put (new_pair (78,807),69)
			Result.put (new_pair (110,807),70)
			Result.put (new_pair (78,780),71)
			Result.put (new_pair (110,780),72)
			Result.put (new_pair (700,110),73)
			Result.put (new_pair (79,772),76)
			Result.put (new_pair (111,772),77)
			Result.put (new_pair (79,774),78)
			Result.put (new_pair (111,774),79)
			Result.put (new_pair (79,779),80)
			Result.put (new_pair (111,779),81)
			Result.put (new_pair (82,769),84)
			Result.put (new_pair (114,769),85)
			Result.put (new_pair (82,807),86)
			Result.put (new_pair (114,807),87)
			Result.put (new_pair (82,780),88)
			Result.put (new_pair (114,780),89)
			Result.put (new_pair (83,769),90)
			Result.put (new_pair (115,769),91)
			Result.put (new_pair (83,770),92)
			Result.put (new_pair (115,770),93)
			Result.put (new_pair (83,807),94)
			Result.put (new_pair (115,807),95)
			Result.put (new_pair (83,780),96)
			Result.put (new_pair (115,780),97)
			Result.put (new_pair (84,807),98)
			Result.put (new_pair (116,807),99)
			Result.put (new_pair (84,780),100)
			Result.put (new_pair (116,780),101)
			Result.put (new_pair (85,771),104)
			Result.put (new_pair (117,771),105)
			Result.put (new_pair (85,772),106)
			Result.put (new_pair (117,772),107)
			Result.put (new_pair (85,774),108)
			Result.put (new_pair (117,774),109)
			Result.put (new_pair (85,778),110)
			Result.put (new_pair (117,778),111)
			Result.put (new_pair (85,779),112)
			Result.put (new_pair (117,779),113)
			Result.put (new_pair (85,808),114)
			Result.put (new_pair (117,808),115)
			Result.put (new_pair (87,770),116)
			Result.put (new_pair (119,770),117)
			Result.put (new_pair (89,770),118)
			Result.put (new_pair (121,770),119)
			Result.put (new_pair (89,776),120)
			Result.put (new_pair (90,769),121)
			Result.put (new_pair (122,769),122)
			Result.put (new_pair (90,775),123)
			Result.put (new_pair (122,775),124)
			Result.put (new_pair (90,780),125)
			Result.put (new_pair (122,780),126)
			Result.put (new_singleton (115),127)
			Result.put (new_pair (79,795),160)
			Result.put (new_pair (111,795),161)
			Result.put (new_pair (85,795),175)
			Result.put (new_pair (117,795),176)
			Result.put (new_pair (68,381),196)
			Result.put (new_pair (68,382),197)
			Result.put (new_pair (100,382),198)
			Result.put (new_pair (76,74),199)
			Result.put (new_pair (76,106),200)
			Result.put (new_pair (108,106),201)
			Result.put (new_pair (78,74),202)
			Result.put (new_pair (78,106),203)
			Result.put (new_pair (110,106),204)
			Result.put (new_pair (65,780),205)
			Result.put (new_pair (97,780),206)
			Result.put (new_pair (73,780),207)
			Result.put (new_pair (105,780),208)
			Result.put (new_pair (79,780),209)
			Result.put (new_pair (111,780),210)
			Result.put (new_pair (85,780),211)
			Result.put (new_pair (117,780),212)
			Result.put (new_pair (220,772),213)
			Result.put (new_pair (252,772),214)
			Result.put (new_pair (220,769),215)
			Result.put (new_pair (252,769),216)
			Result.put (new_pair (220,780),217)
			Result.put (new_pair (252,780),218)
			Result.put (new_pair (220,768),219)
			Result.put (new_pair (252,768),220)
			Result.put (new_pair (196,772),222)
			Result.put (new_pair (228,772),223)
			Result.put (new_pair (550,772),224)
			Result.put (new_pair (551,772),225)
			Result.put (new_pair (198,772),226)
			Result.put (new_pair (230,772),227)
			Result.put (new_pair (71,780),230)
			Result.put (new_pair (103,780),231)
			Result.put (new_pair (75,780),232)
			Result.put (new_pair (107,780),233)
			Result.put (new_pair (79,808),234)
			Result.put (new_pair (111,808),235)
			Result.put (new_pair (490,772),236)
			Result.put (new_pair (491,772),237)
			Result.put (new_pair (439,780),238)
			Result.put (new_pair (658,780),239)
			Result.put (new_pair (106,780),240)
			Result.put (new_pair (68,90),241)
			Result.put (new_pair (68,122),242)
			Result.put (new_pair (100,122),243)
			Result.put (new_pair (71,769),244)
			Result.put (new_pair (103,769),245)
			Result.put (new_pair (78,768),248)
			Result.put (new_pair (110,768),249)
			Result.put (new_pair (197,769),250)
			Result.put (new_pair (229,769),251)
			Result.put (new_pair (198,769),252)
			Result.put (new_pair (230,769),253)
			Result.put (new_pair (216,769),254)
			Result.put (new_pair (248,769),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_2: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (65,783),0)
			Result.put (new_pair (97,783),1)
			Result.put (new_pair (65,785),2)
			Result.put (new_pair (97,785),3)
			Result.put (new_pair (69,783),4)
			Result.put (new_pair (101,783),5)
			Result.put (new_pair (69,785),6)
			Result.put (new_pair (101,785),7)
			Result.put (new_pair (73,783),8)
			Result.put (new_pair (105,783),9)
			Result.put (new_pair (73,785),10)
			Result.put (new_pair (105,785),11)
			Result.put (new_pair (79,783),12)
			Result.put (new_pair (111,783),13)
			Result.put (new_pair (79,785),14)
			Result.put (new_pair (111,785),15)
			Result.put (new_pair (82,783),16)
			Result.put (new_pair (114,783),17)
			Result.put (new_pair (82,785),18)
			Result.put (new_pair (114,785),19)
			Result.put (new_pair (85,783),20)
			Result.put (new_pair (117,783),21)
			Result.put (new_pair (85,785),22)
			Result.put (new_pair (117,785),23)
			Result.put (new_pair (83,806),24)
			Result.put (new_pair (115,806),25)
			Result.put (new_pair (84,806),26)
			Result.put (new_pair (116,806),27)
			Result.put (new_pair (72,780),30)
			Result.put (new_pair (104,780),31)
			Result.put (new_pair (65,775),38)
			Result.put (new_pair (97,775),39)
			Result.put (new_pair (69,807),40)
			Result.put (new_pair (101,807),41)
			Result.put (new_pair (214,772),42)
			Result.put (new_pair (246,772),43)
			Result.put (new_pair (213,772),44)
			Result.put (new_pair (245,772),45)
			Result.put (new_pair (79,775),46)
			Result.put (new_pair (111,775),47)
			Result.put (new_pair (558,772),48)
			Result.put (new_pair (559,772),49)
			Result.put (new_pair (89,772),50)
			Result.put (new_pair (121,772),51)
			Result.put (new_singleton (104),176)
			Result.put (new_singleton (614),177)
			Result.put (new_singleton (106),178)
			Result.put (new_singleton (114),179)
			Result.put (new_singleton (633),180)
			Result.put (new_singleton (635),181)
			Result.put (new_singleton (641),182)
			Result.put (new_singleton (119),183)
			Result.put (new_singleton (121),184)
			Result.put (new_pair (32,774),216)
			Result.put (new_pair (32,775),217)
			Result.put (new_pair (32,778),218)
			Result.put (new_pair (32,808),219)
			Result.put (new_pair (32,771),220)
			Result.put (new_pair (32,779),221)
			Result.put (new_singleton (611),224)
			Result.put (new_singleton (108),225)
			Result.put (new_singleton (115),226)
			Result.put (new_singleton (120),227)
			Result.put (new_singleton (661),228)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_3: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (768),64)
			Result.put (new_singleton (769),65)
			Result.put (new_singleton (787),67)
			Result.put (new_pair (776,769),68)
			Result.put (new_singleton (697),116)
			Result.put (new_pair (32,837),122)
			Result.put (new_singleton (59),126)
			Result.put (new_pair (32,769),132)
			Result.put (new_pair (168,769),133)
			Result.put (new_pair (913,769),134)
			Result.put (new_singleton (183),135)
			Result.put (new_pair (917,769),136)
			Result.put (new_pair (919,769),137)
			Result.put (new_pair (921,769),138)
			Result.put (new_pair (927,769),140)
			Result.put (new_pair (933,769),142)
			Result.put (new_pair (937,769),143)
			Result.put (new_pair (970,769),144)
			Result.put (new_pair (921,776),170)
			Result.put (new_pair (933,776),171)
			Result.put (new_pair (945,769),172)
			Result.put (new_pair (949,769),173)
			Result.put (new_pair (951,769),174)
			Result.put (new_pair (953,769),175)
			Result.put (new_pair (971,769),176)
			Result.put (new_pair (953,776),202)
			Result.put (new_pair (965,776),203)
			Result.put (new_pair (959,769),204)
			Result.put (new_pair (965,769),205)
			Result.put (new_pair (969,769),206)
			Result.put (new_singleton (946),208)
			Result.put (new_singleton (952),209)
			Result.put (new_singleton (933),210)
			Result.put (new_pair (978,769),211)
			Result.put (new_pair (978,776),212)
			Result.put (new_singleton (966),213)
			Result.put (new_singleton (960),214)
			Result.put (new_singleton (954),240)
			Result.put (new_singleton (961),241)
			Result.put (new_singleton (962),242)
			Result.put (new_singleton (920),244)
			Result.put (new_singleton (949),245)
			Result.put (new_singleton (931),249)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_4: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (1045,768),0)
			Result.put (new_pair (1045,776),1)
			Result.put (new_pair (1043,769),3)
			Result.put (new_pair (1030,776),7)
			Result.put (new_pair (1050,769),12)
			Result.put (new_pair (1048,768),13)
			Result.put (new_pair (1059,774),14)
			Result.put (new_pair (1048,774),25)
			Result.put (new_pair (1080,774),57)
			Result.put (new_pair (1077,768),80)
			Result.put (new_pair (1077,776),81)
			Result.put (new_pair (1075,769),83)
			Result.put (new_pair (1110,776),87)
			Result.put (new_pair (1082,769),92)
			Result.put (new_pair (1080,768),93)
			Result.put (new_pair (1091,774),94)
			Result.put (new_pair (1140,783),118)
			Result.put (new_pair (1141,783),119)
			Result.put (new_pair (1046,774),193)
			Result.put (new_pair (1078,774),194)
			Result.put (new_pair (1040,774),208)
			Result.put (new_pair (1072,774),209)
			Result.put (new_pair (1040,776),210)
			Result.put (new_pair (1072,776),211)
			Result.put (new_pair (1045,774),214)
			Result.put (new_pair (1077,774),215)
			Result.put (new_pair (1240,776),218)
			Result.put (new_pair (1241,776),219)
			Result.put (new_pair (1046,776),220)
			Result.put (new_pair (1078,776),221)
			Result.put (new_pair (1047,776),222)
			Result.put (new_pair (1079,776),223)
			Result.put (new_pair (1048,772),226)
			Result.put (new_pair (1080,772),227)
			Result.put (new_pair (1048,776),228)
			Result.put (new_pair (1080,776),229)
			Result.put (new_pair (1054,776),230)
			Result.put (new_pair (1086,776),231)
			Result.put (new_pair (1256,776),234)
			Result.put (new_pair (1257,776),235)
			Result.put (new_pair (1069,776),236)
			Result.put (new_pair (1101,776),237)
			Result.put (new_pair (1059,772),238)
			Result.put (new_pair (1091,772),239)
			Result.put (new_pair (1059,776),240)
			Result.put (new_pair (1091,776),241)
			Result.put (new_pair (1059,779),242)
			Result.put (new_pair (1091,779),243)
			Result.put (new_pair (1063,776),244)
			Result.put (new_pair (1095,776),245)
			Result.put (new_pair (1067,776),248)
			Result.put (new_pair (1099,776),249)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_5: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (1381,1410),135)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_6: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (1575,1619),34)
			Result.put (new_pair (1575,1620),35)
			Result.put (new_pair (1608,1620),36)
			Result.put (new_pair (1575,1621),37)
			Result.put (new_pair (1610,1620),38)
			Result.put (new_pair (1575,1652),117)
			Result.put (new_pair (1608,1652),118)
			Result.put (new_pair (1735,1652),119)
			Result.put (new_pair (1610,1652),120)
			Result.put (new_pair (1749,1620),192)
			Result.put (new_pair (1729,1620),194)
			Result.put (new_pair (1746,1620),211)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	all_empty_decomposition_mapping_segment: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_9: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (2344,2364),41)
			Result.put (new_pair (2352,2364),49)
			Result.put (new_pair (2355,2364),52)
			Result.put (new_pair (2325,2364),88)
			Result.put (new_pair (2326,2364),89)
			Result.put (new_pair (2327,2364),90)
			Result.put (new_pair (2332,2364),91)
			Result.put (new_pair (2337,2364),92)
			Result.put (new_pair (2338,2364),93)
			Result.put (new_pair (2347,2364),94)
			Result.put (new_pair (2351,2364),95)
			Result.put (new_pair (2503,2494),203)
			Result.put (new_pair (2503,2519),204)
			Result.put (new_pair (2465,2492),220)
			Result.put (new_pair (2466,2492),221)
			Result.put (new_pair (2479,2492),223)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_10: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (2610,2620),51)
			Result.put (new_pair (2616,2620),54)
			Result.put (new_pair (2582,2620),89)
			Result.put (new_pair (2583,2620),90)
			Result.put (new_pair (2588,2620),91)
			Result.put (new_pair (2603,2620),94)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_11: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (2887,2902),72)
			Result.put (new_pair (2887,2878),75)
			Result.put (new_pair (2887,2903),76)
			Result.put (new_pair (2849,2876),92)
			Result.put (new_pair (2850,2876),93)
			Result.put (new_pair (2962,3031),148)
			Result.put (new_pair (3014,3006),202)
			Result.put (new_pair (3015,3006),203)
			Result.put (new_pair (3014,3031),204)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_12: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (3142,3158),72)
			Result.put (new_pair (3263,3285),192)
			Result.put (new_pair (3270,3285),199)
			Result.put (new_pair (3270,3286),200)
			Result.put (new_pair (3270,3266),202)
			Result.put (new_pair (3274,3285),203)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_13: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (3398,3390),74)
			Result.put (new_pair (3399,3390),75)
			Result.put (new_pair (3398,3415),76)
			Result.put (new_pair (3545,3530),218)
			Result.put (new_pair (3545,3535),220)
			Result.put (new_pair (3548,3530),221)
			Result.put (new_pair (3545,3551),222)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_14: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (3661,3634),51)
			Result.put (new_pair (3789,3762),179)
			Result.put (new_pair (3755,3737),220)
			Result.put (new_pair (3755,3745),221)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_15: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (3851),12)
			Result.put (new_pair (3906,4023),67)
			Result.put (new_pair (3916,4023),77)
			Result.put (new_pair (3921,4023),82)
			Result.put (new_pair (3926,4023),87)
			Result.put (new_pair (3931,4023),92)
			Result.put (new_pair (3904,4021),105)
			Result.put (new_pair (3953,3954),115)
			Result.put (new_pair (3953,3956),117)
			Result.put (new_pair (4018,3968),118)
			Result.put (new_pair (4018,3969),119)
			Result.put (new_pair (4019,3968),120)
			Result.put (new_pair (4019,3969),121)
			Result.put (new_pair (3953,3968),129)
			Result.put (new_pair (3986,4023),147)
			Result.put (new_pair (3996,4023),157)
			Result.put (new_pair (4001,4023),162)
			Result.put (new_pair (4006,4023),167)
			Result.put (new_pair (4011,4023),172)
			Result.put (new_pair (3984,4021),185)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_16: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (4133,4142),38)
			Result.put (new_singleton (4316),252)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_27: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (6917,6965),6)
			Result.put (new_pair (6919,6965),8)
			Result.put (new_pair (6921,6965),10)
			Result.put (new_pair (6923,6965),12)
			Result.put (new_pair (6925,6965),14)
			Result.put (new_pair (6929,6965),18)
			Result.put (new_pair (6970,6965),59)
			Result.put (new_pair (6972,6965),61)
			Result.put (new_pair (6974,6965),64)
			Result.put (new_pair (6975,6965),65)
			Result.put (new_pair (6978,6965),67)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_29: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (65),44)
			Result.put (new_singleton (198),45)
			Result.put (new_singleton (66),46)
			Result.put (new_singleton (68),48)
			Result.put (new_singleton (69),49)
			Result.put (new_singleton (398),50)
			Result.put (new_singleton (71),51)
			Result.put (new_singleton (72),52)
			Result.put (new_singleton (73),53)
			Result.put (new_singleton (74),54)
			Result.put (new_singleton (75),55)
			Result.put (new_singleton (76),56)
			Result.put (new_singleton (77),57)
			Result.put (new_singleton (78),58)
			Result.put (new_singleton (79),60)
			Result.put (new_singleton (546),61)
			Result.put (new_singleton (80),62)
			Result.put (new_singleton (82),63)
			Result.put (new_singleton (84),64)
			Result.put (new_singleton (85),65)
			Result.put (new_singleton (87),66)
			Result.put (new_singleton (97),67)
			Result.put (new_singleton (592),68)
			Result.put (new_singleton (593),69)
			Result.put (new_singleton (7426),70)
			Result.put (new_singleton (98),71)
			Result.put (new_singleton (100),72)
			Result.put (new_singleton (101),73)
			Result.put (new_singleton (601),74)
			Result.put (new_singleton (603),75)
			Result.put (new_singleton (604),76)
			Result.put (new_singleton (103),77)
			Result.put (new_singleton (107),79)
			Result.put (new_singleton (109),80)
			Result.put (new_singleton (331),81)
			Result.put (new_singleton (111),82)
			Result.put (new_singleton (596),83)
			Result.put (new_singleton (7446),84)
			Result.put (new_singleton (7447),85)
			Result.put (new_singleton (112),86)
			Result.put (new_singleton (116),87)
			Result.put (new_singleton (117),88)
			Result.put (new_singleton (7453),89)
			Result.put (new_singleton (623),90)
			Result.put (new_singleton (118),91)
			Result.put (new_singleton (7461),92)
			Result.put (new_singleton (946),93)
			Result.put (new_singleton (947),94)
			Result.put (new_singleton (948),95)
			Result.put (new_singleton (966),96)
			Result.put (new_singleton (967),97)
			Result.put (new_singleton (105),98)
			Result.put (new_singleton (114),99)
			Result.put (new_singleton (117),100)
			Result.put (new_singleton (118),101)
			Result.put (new_singleton (946),102)
			Result.put (new_singleton (947),103)
			Result.put (new_singleton (961),104)
			Result.put (new_singleton (966),105)
			Result.put (new_singleton (967),106)
			Result.put (new_singleton (1085),120)
			Result.put (new_singleton (594),155)
			Result.put (new_singleton (99),156)
			Result.put (new_singleton (597),157)
			Result.put (new_singleton (240),158)
			Result.put (new_singleton (604),159)
			Result.put (new_singleton (102),160)
			Result.put (new_singleton (607),161)
			Result.put (new_singleton (609),162)
			Result.put (new_singleton (613),163)
			Result.put (new_singleton (616),164)
			Result.put (new_singleton (617),165)
			Result.put (new_singleton (618),166)
			Result.put (new_singleton (7547),167)
			Result.put (new_singleton (669),168)
			Result.put (new_singleton (621),169)
			Result.put (new_singleton (7557),170)
			Result.put (new_singleton (671),171)
			Result.put (new_singleton (625),172)
			Result.put (new_singleton (624),173)
			Result.put (new_singleton (626),174)
			Result.put (new_singleton (627),175)
			Result.put (new_singleton (628),176)
			Result.put (new_singleton (629),177)
			Result.put (new_singleton (632),178)
			Result.put (new_singleton (642),179)
			Result.put (new_singleton (643),180)
			Result.put (new_singleton (427),181)
			Result.put (new_singleton (649),182)
			Result.put (new_singleton (650),183)
			Result.put (new_singleton (7452),184)
			Result.put (new_singleton (651),185)
			Result.put (new_singleton (652),186)
			Result.put (new_singleton (122),187)
			Result.put (new_singleton (656),188)
			Result.put (new_singleton (657),189)
			Result.put (new_singleton (658),190)
			Result.put (new_singleton (952),191)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_30: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (65,805),0)
			Result.put (new_pair (97,805),1)
			Result.put (new_pair (66,775),2)
			Result.put (new_pair (98,775),3)
			Result.put (new_pair (66,803),4)
			Result.put (new_pair (98,803),5)
			Result.put (new_pair (66,817),6)
			Result.put (new_pair (98,817),7)
			Result.put (new_pair (199,769),8)
			Result.put (new_pair (231,769),9)
			Result.put (new_pair (68,775),10)
			Result.put (new_pair (100,775),11)
			Result.put (new_pair (68,803),12)
			Result.put (new_pair (100,803),13)
			Result.put (new_pair (68,817),14)
			Result.put (new_pair (100,817),15)
			Result.put (new_pair (68,807),16)
			Result.put (new_pair (100,807),17)
			Result.put (new_pair (68,813),18)
			Result.put (new_pair (100,813),19)
			Result.put (new_pair (274,768),20)
			Result.put (new_pair (275,768),21)
			Result.put (new_pair (274,769),22)
			Result.put (new_pair (275,769),23)
			Result.put (new_pair (69,813),24)
			Result.put (new_pair (101,813),25)
			Result.put (new_pair (69,816),26)
			Result.put (new_pair (101,816),27)
			Result.put (new_pair (552,774),28)
			Result.put (new_pair (553,774),29)
			Result.put (new_pair (70,775),30)
			Result.put (new_pair (102,775),31)
			Result.put (new_pair (71,772),32)
			Result.put (new_pair (103,772),33)
			Result.put (new_pair (72,775),34)
			Result.put (new_pair (104,775),35)
			Result.put (new_pair (72,803),36)
			Result.put (new_pair (104,803),37)
			Result.put (new_pair (72,776),38)
			Result.put (new_pair (104,776),39)
			Result.put (new_pair (72,807),40)
			Result.put (new_pair (104,807),41)
			Result.put (new_pair (72,814),42)
			Result.put (new_pair (104,814),43)
			Result.put (new_pair (73,816),44)
			Result.put (new_pair (105,816),45)
			Result.put (new_pair (207,769),46)
			Result.put (new_pair (239,769),47)
			Result.put (new_pair (75,769),48)
			Result.put (new_pair (107,769),49)
			Result.put (new_pair (75,803),50)
			Result.put (new_pair (107,803),51)
			Result.put (new_pair (75,817),52)
			Result.put (new_pair (107,817),53)
			Result.put (new_pair (76,803),54)
			Result.put (new_pair (108,803),55)
			Result.put (new_pair (7734,772),56)
			Result.put (new_pair (7735,772),57)
			Result.put (new_pair (76,817),58)
			Result.put (new_pair (108,817),59)
			Result.put (new_pair (76,813),60)
			Result.put (new_pair (108,813),61)
			Result.put (new_pair (77,769),62)
			Result.put (new_pair (109,769),63)
			Result.put (new_pair (77,775),64)
			Result.put (new_pair (109,775),65)
			Result.put (new_pair (77,803),66)
			Result.put (new_pair (109,803),67)
			Result.put (new_pair (78,775),68)
			Result.put (new_pair (110,775),69)
			Result.put (new_pair (78,803),70)
			Result.put (new_pair (110,803),71)
			Result.put (new_pair (78,817),72)
			Result.put (new_pair (110,817),73)
			Result.put (new_pair (78,813),74)
			Result.put (new_pair (110,813),75)
			Result.put (new_pair (213,769),76)
			Result.put (new_pair (245,769),77)
			Result.put (new_pair (213,776),78)
			Result.put (new_pair (245,776),79)
			Result.put (new_pair (332,768),80)
			Result.put (new_pair (333,768),81)
			Result.put (new_pair (332,769),82)
			Result.put (new_pair (333,769),83)
			Result.put (new_pair (80,769),84)
			Result.put (new_pair (112,769),85)
			Result.put (new_pair (80,775),86)
			Result.put (new_pair (112,775),87)
			Result.put (new_pair (82,775),88)
			Result.put (new_pair (114,775),89)
			Result.put (new_pair (82,803),90)
			Result.put (new_pair (114,803),91)
			Result.put (new_pair (7770,772),92)
			Result.put (new_pair (7771,772),93)
			Result.put (new_pair (82,817),94)
			Result.put (new_pair (114,817),95)
			Result.put (new_pair (83,775),96)
			Result.put (new_pair (115,775),97)
			Result.put (new_pair (83,803),98)
			Result.put (new_pair (115,803),99)
			Result.put (new_pair (346,775),100)
			Result.put (new_pair (347,775),101)
			Result.put (new_pair (352,775),102)
			Result.put (new_pair (353,775),103)
			Result.put (new_pair (7778,775),104)
			Result.put (new_pair (7779,775),105)
			Result.put (new_pair (84,775),106)
			Result.put (new_pair (116,775),107)
			Result.put (new_pair (84,803),108)
			Result.put (new_pair (116,803),109)
			Result.put (new_pair (84,817),110)
			Result.put (new_pair (116,817),111)
			Result.put (new_pair (84,813),112)
			Result.put (new_pair (116,813),113)
			Result.put (new_pair (85,804),114)
			Result.put (new_pair (117,804),115)
			Result.put (new_pair (85,816),116)
			Result.put (new_pair (117,816),117)
			Result.put (new_pair (85,813),118)
			Result.put (new_pair (117,813),119)
			Result.put (new_pair (360,769),120)
			Result.put (new_pair (361,769),121)
			Result.put (new_pair (362,776),122)
			Result.put (new_pair (363,776),123)
			Result.put (new_pair (86,771),124)
			Result.put (new_pair (118,771),125)
			Result.put (new_pair (86,803),126)
			Result.put (new_pair (118,803),127)
			Result.put (new_pair (87,768),128)
			Result.put (new_pair (119,768),129)
			Result.put (new_pair (87,769),130)
			Result.put (new_pair (119,769),131)
			Result.put (new_pair (87,776),132)
			Result.put (new_pair (119,776),133)
			Result.put (new_pair (87,775),134)
			Result.put (new_pair (119,775),135)
			Result.put (new_pair (87,803),136)
			Result.put (new_pair (119,803),137)
			Result.put (new_pair (88,775),138)
			Result.put (new_pair (120,775),139)
			Result.put (new_pair (88,776),140)
			Result.put (new_pair (120,776),141)
			Result.put (new_pair (89,775),142)
			Result.put (new_pair (121,775),143)
			Result.put (new_pair (90,770),144)
			Result.put (new_pair (122,770),145)
			Result.put (new_pair (90,803),146)
			Result.put (new_pair (122,803),147)
			Result.put (new_pair (90,817),148)
			Result.put (new_pair (122,817),149)
			Result.put (new_pair (104,817),150)
			Result.put (new_pair (116,776),151)
			Result.put (new_pair (119,778),152)
			Result.put (new_pair (121,778),153)
			Result.put (new_pair (97,702),154)
			Result.put (new_pair (383,775),155)
			Result.put (new_pair (65,803),160)
			Result.put (new_pair (97,803),161)
			Result.put (new_pair (65,777),162)
			Result.put (new_pair (97,777),163)
			Result.put (new_pair (194,769),164)
			Result.put (new_pair (226,769),165)
			Result.put (new_pair (194,768),166)
			Result.put (new_pair (226,768),167)
			Result.put (new_pair (194,777),168)
			Result.put (new_pair (226,777),169)
			Result.put (new_pair (194,771),170)
			Result.put (new_pair (226,771),171)
			Result.put (new_pair (7840,770),172)
			Result.put (new_pair (7841,770),173)
			Result.put (new_pair (258,769),174)
			Result.put (new_pair (259,769),175)
			Result.put (new_pair (258,768),176)
			Result.put (new_pair (259,768),177)
			Result.put (new_pair (258,777),178)
			Result.put (new_pair (259,777),179)
			Result.put (new_pair (258,771),180)
			Result.put (new_pair (259,771),181)
			Result.put (new_pair (7840,774),182)
			Result.put (new_pair (7841,774),183)
			Result.put (new_pair (69,803),184)
			Result.put (new_pair (101,803),185)
			Result.put (new_pair (69,777),186)
			Result.put (new_pair (101,777),187)
			Result.put (new_pair (69,771),188)
			Result.put (new_pair (101,771),189)
			Result.put (new_pair (202,769),190)
			Result.put (new_pair (234,769),191)
			Result.put (new_pair (202,768),192)
			Result.put (new_pair (234,768),193)
			Result.put (new_pair (202,777),194)
			Result.put (new_pair (234,777),195)
			Result.put (new_pair (202,771),196)
			Result.put (new_pair (234,771),197)
			Result.put (new_pair (7864,770),198)
			Result.put (new_pair (7865,770),199)
			Result.put (new_pair (73,777),200)
			Result.put (new_pair (105,777),201)
			Result.put (new_pair (73,803),202)
			Result.put (new_pair (105,803),203)
			Result.put (new_pair (79,803),204)
			Result.put (new_pair (111,803),205)
			Result.put (new_pair (79,777),206)
			Result.put (new_pair (111,777),207)
			Result.put (new_pair (212,769),208)
			Result.put (new_pair (244,769),209)
			Result.put (new_pair (212,768),210)
			Result.put (new_pair (244,768),211)
			Result.put (new_pair (212,777),212)
			Result.put (new_pair (244,777),213)
			Result.put (new_pair (212,771),214)
			Result.put (new_pair (244,771),215)
			Result.put (new_pair (7884,770),216)
			Result.put (new_pair (7885,770),217)
			Result.put (new_pair (416,769),218)
			Result.put (new_pair (417,769),219)
			Result.put (new_pair (416,768),220)
			Result.put (new_pair (417,768),221)
			Result.put (new_pair (416,777),222)
			Result.put (new_pair (417,777),223)
			Result.put (new_pair (416,771),224)
			Result.put (new_pair (417,771),225)
			Result.put (new_pair (416,803),226)
			Result.put (new_pair (417,803),227)
			Result.put (new_pair (85,803),228)
			Result.put (new_pair (117,803),229)
			Result.put (new_pair (85,777),230)
			Result.put (new_pair (117,777),231)
			Result.put (new_pair (431,769),232)
			Result.put (new_pair (432,769),233)
			Result.put (new_pair (431,768),234)
			Result.put (new_pair (432,768),235)
			Result.put (new_pair (431,777),236)
			Result.put (new_pair (432,777),237)
			Result.put (new_pair (431,771),238)
			Result.put (new_pair (432,771),239)
			Result.put (new_pair (431,803),240)
			Result.put (new_pair (432,803),241)
			Result.put (new_pair (89,768),242)
			Result.put (new_pair (121,768),243)
			Result.put (new_pair (89,803),244)
			Result.put (new_pair (121,803),245)
			Result.put (new_pair (89,777),246)
			Result.put (new_pair (121,777),247)
			Result.put (new_pair (89,771),248)
			Result.put (new_pair (121,771),249)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_31: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (945,787),0)
			Result.put (new_pair (945,788),1)
			Result.put (new_pair (7936,768),2)
			Result.put (new_pair (7937,768),3)
			Result.put (new_pair (7936,769),4)
			Result.put (new_pair (7937,769),5)
			Result.put (new_pair (7936,834),6)
			Result.put (new_pair (7937,834),7)
			Result.put (new_pair (913,787),8)
			Result.put (new_pair (913,788),9)
			Result.put (new_pair (7944,768),10)
			Result.put (new_pair (7945,768),11)
			Result.put (new_pair (7944,769),12)
			Result.put (new_pair (7945,769),13)
			Result.put (new_pair (7944,834),14)
			Result.put (new_pair (7945,834),15)
			Result.put (new_pair (949,787),16)
			Result.put (new_pair (949,788),17)
			Result.put (new_pair (7952,768),18)
			Result.put (new_pair (7953,768),19)
			Result.put (new_pair (7952,769),20)
			Result.put (new_pair (7953,769),21)
			Result.put (new_pair (917,787),24)
			Result.put (new_pair (917,788),25)
			Result.put (new_pair (7960,768),26)
			Result.put (new_pair (7961,768),27)
			Result.put (new_pair (7960,769),28)
			Result.put (new_pair (7961,769),29)
			Result.put (new_pair (951,787),32)
			Result.put (new_pair (951,788),33)
			Result.put (new_pair (7968,768),34)
			Result.put (new_pair (7969,768),35)
			Result.put (new_pair (7968,769),36)
			Result.put (new_pair (7969,769),37)
			Result.put (new_pair (7968,834),38)
			Result.put (new_pair (7969,834),39)
			Result.put (new_pair (919,787),40)
			Result.put (new_pair (919,788),41)
			Result.put (new_pair (7976,768),42)
			Result.put (new_pair (7977,768),43)
			Result.put (new_pair (7976,769),44)
			Result.put (new_pair (7977,769),45)
			Result.put (new_pair (7976,834),46)
			Result.put (new_pair (7977,834),47)
			Result.put (new_pair (953,787),48)
			Result.put (new_pair (953,788),49)
			Result.put (new_pair (7984,768),50)
			Result.put (new_pair (7985,768),51)
			Result.put (new_pair (7984,769),52)
			Result.put (new_pair (7985,769),53)
			Result.put (new_pair (7984,834),54)
			Result.put (new_pair (7985,834),55)
			Result.put (new_pair (921,787),56)
			Result.put (new_pair (921,788),57)
			Result.put (new_pair (7992,768),58)
			Result.put (new_pair (7993,768),59)
			Result.put (new_pair (7992,769),60)
			Result.put (new_pair (7993,769),61)
			Result.put (new_pair (7992,834),62)
			Result.put (new_pair (7993,834),63)
			Result.put (new_pair (959,787),64)
			Result.put (new_pair (959,788),65)
			Result.put (new_pair (8000,768),66)
			Result.put (new_pair (8001,768),67)
			Result.put (new_pair (8000,769),68)
			Result.put (new_pair (8001,769),69)
			Result.put (new_pair (927,787),72)
			Result.put (new_pair (927,788),73)
			Result.put (new_pair (8008,768),74)
			Result.put (new_pair (8009,768),75)
			Result.put (new_pair (8008,769),76)
			Result.put (new_pair (8009,769),77)
			Result.put (new_pair (965,787),80)
			Result.put (new_pair (965,788),81)
			Result.put (new_pair (8016,768),82)
			Result.put (new_pair (8017,768),83)
			Result.put (new_pair (8016,769),84)
			Result.put (new_pair (8017,769),85)
			Result.put (new_pair (8016,834),86)
			Result.put (new_pair (8017,834),87)
			Result.put (new_pair (933,788),89)
			Result.put (new_pair (8025,768),91)
			Result.put (new_pair (8025,769),93)
			Result.put (new_pair (8025,834),95)
			Result.put (new_pair (969,787),96)
			Result.put (new_pair (969,788),97)
			Result.put (new_pair (8032,768),98)
			Result.put (new_pair (8033,768),99)
			Result.put (new_pair (8032,769),100)
			Result.put (new_pair (8033,769),101)
			Result.put (new_pair (8032,834),102)
			Result.put (new_pair (8033,834),103)
			Result.put (new_pair (937,787),104)
			Result.put (new_pair (937,788),105)
			Result.put (new_pair (8040,768),106)
			Result.put (new_pair (8041,768),107)
			Result.put (new_pair (8040,769),108)
			Result.put (new_pair (8041,769),109)
			Result.put (new_pair (8040,834),110)
			Result.put (new_pair (8041,834),111)
			Result.put (new_pair (945,768),112)
			Result.put (new_singleton (940),113)
			Result.put (new_pair (949,768),114)
			Result.put (new_singleton (941),115)
			Result.put (new_pair (951,768),116)
			Result.put (new_singleton (942),117)
			Result.put (new_pair (953,768),118)
			Result.put (new_singleton (943),119)
			Result.put (new_pair (959,768),120)
			Result.put (new_singleton (972),121)
			Result.put (new_pair (965,768),122)
			Result.put (new_singleton (973),123)
			Result.put (new_pair (969,768),124)
			Result.put (new_singleton (974),125)
			Result.put (new_pair (7936,837),128)
			Result.put (new_pair (7937,837),129)
			Result.put (new_pair (7938,837),130)
			Result.put (new_pair (7939,837),131)
			Result.put (new_pair (7940,837),132)
			Result.put (new_pair (7941,837),133)
			Result.put (new_pair (7942,837),134)
			Result.put (new_pair (7943,837),135)
			Result.put (new_pair (7944,837),136)
			Result.put (new_pair (7945,837),137)
			Result.put (new_pair (7946,837),138)
			Result.put (new_pair (7947,837),139)
			Result.put (new_pair (7948,837),140)
			Result.put (new_pair (7949,837),141)
			Result.put (new_pair (7950,837),142)
			Result.put (new_pair (7951,837),143)
			Result.put (new_pair (7968,837),144)
			Result.put (new_pair (7969,837),145)
			Result.put (new_pair (7970,837),146)
			Result.put (new_pair (7971,837),147)
			Result.put (new_pair (7972,837),148)
			Result.put (new_pair (7973,837),149)
			Result.put (new_pair (7974,837),150)
			Result.put (new_pair (7975,837),151)
			Result.put (new_pair (7976,837),152)
			Result.put (new_pair (7977,837),153)
			Result.put (new_pair (7978,837),154)
			Result.put (new_pair (7979,837),155)
			Result.put (new_pair (7980,837),156)
			Result.put (new_pair (7981,837),157)
			Result.put (new_pair (7982,837),158)
			Result.put (new_pair (7983,837),159)
			Result.put (new_pair (8032,837),160)
			Result.put (new_pair (8033,837),161)
			Result.put (new_pair (8034,837),162)
			Result.put (new_pair (8035,837),163)
			Result.put (new_pair (8036,837),164)
			Result.put (new_pair (8037,837),165)
			Result.put (new_pair (8038,837),166)
			Result.put (new_pair (8039,837),167)
			Result.put (new_pair (8040,837),168)
			Result.put (new_pair (8041,837),169)
			Result.put (new_pair (8042,837),170)
			Result.put (new_pair (8043,837),171)
			Result.put (new_pair (8044,837),172)
			Result.put (new_pair (8045,837),173)
			Result.put (new_pair (8046,837),174)
			Result.put (new_pair (8047,837),175)
			Result.put (new_pair (945,774),176)
			Result.put (new_pair (945,772),177)
			Result.put (new_pair (8048,837),178)
			Result.put (new_pair (945,837),179)
			Result.put (new_pair (940,837),180)
			Result.put (new_pair (945,834),182)
			Result.put (new_pair (8118,837),183)
			Result.put (new_pair (913,774),184)
			Result.put (new_pair (913,772),185)
			Result.put (new_pair (913,768),186)
			Result.put (new_singleton (902),187)
			Result.put (new_pair (913,837),188)
			Result.put (new_pair (32,787),189)
			Result.put (new_singleton (953),190)
			Result.put (new_pair (32,787),191)
			Result.put (new_pair (32,834),192)
			Result.put (new_pair (168,834),193)
			Result.put (new_pair (8052,837),194)
			Result.put (new_pair (951,837),195)
			Result.put (new_pair (942,837),196)
			Result.put (new_pair (951,834),198)
			Result.put (new_pair (8134,837),199)
			Result.put (new_pair (917,768),200)
			Result.put (new_singleton (904),201)
			Result.put (new_pair (919,768),202)
			Result.put (new_singleton (905),203)
			Result.put (new_pair (919,837),204)
			Result.put (new_pair (8127,768),205)
			Result.put (new_pair (8127,769),206)
			Result.put (new_pair (8127,834),207)
			Result.put (new_pair (953,774),208)
			Result.put (new_pair (953,772),209)
			Result.put (new_pair (970,768),210)
			Result.put (new_singleton (912),211)
			Result.put (new_pair (953,834),214)
			Result.put (new_pair (970,834),215)
			Result.put (new_pair (921,774),216)
			Result.put (new_pair (921,772),217)
			Result.put (new_pair (921,768),218)
			Result.put (new_singleton (906),219)
			Result.put (new_pair (8190,768),221)
			Result.put (new_pair (8190,769),222)
			Result.put (new_pair (8190,834),223)
			Result.put (new_pair (965,774),224)
			Result.put (new_pair (965,772),225)
			Result.put (new_pair (971,768),226)
			Result.put (new_singleton (944),227)
			Result.put (new_pair (961,787),228)
			Result.put (new_pair (961,788),229)
			Result.put (new_pair (965,834),230)
			Result.put (new_pair (971,834),231)
			Result.put (new_pair (933,774),232)
			Result.put (new_pair (933,772),233)
			Result.put (new_pair (933,768),234)
			Result.put (new_singleton (910),235)
			Result.put (new_pair (929,788),236)
			Result.put (new_pair (168,768),237)
			Result.put (new_singleton (901),238)
			Result.put (new_singleton (96),239)
			Result.put (new_pair (8060,837),242)
			Result.put (new_pair (969,837),243)
			Result.put (new_pair (974,837),244)
			Result.put (new_pair (969,834),246)
			Result.put (new_pair (8182,837),247)
			Result.put (new_pair (927,768),248)
			Result.put (new_singleton (908),249)
			Result.put (new_pair (937,768),250)
			Result.put (new_singleton (911),251)
			Result.put (new_pair (937,837),252)
			Result.put (new_singleton (180),253)
			Result.put (new_pair (32,788),254)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_32: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (8194),0)
			Result.put (new_singleton (8195),1)
			Result.put (new_singleton (32),2)
			Result.put (new_singleton (32),3)
			Result.put (new_singleton (32),4)
			Result.put (new_singleton (32),5)
			Result.put (new_singleton (32),6)
			Result.put (new_singleton (32),7)
			Result.put (new_singleton (32),8)
			Result.put (new_singleton (32),9)
			Result.put (new_singleton (32),10)
			Result.put (new_singleton (8208),17)
			Result.put (new_pair (32,819),23)
			Result.put (new_singleton (46),36)
			Result.put (new_pair (46,46),37)
			Result.put (new_triple (46,46,46),38)
			Result.put (new_singleton (32),47)
			Result.put (new_pair (8242,8242),51)
			Result.put (new_triple (8242,8242,8242),52)
			Result.put (new_pair (8245,8245),54)
			Result.put (new_triple (8245,8245,8245),55)
			Result.put (new_pair (33,33),60)
			Result.put (new_pair (32,773),62)
			Result.put (new_pair (63,63),71)
			Result.put (new_pair (63,33),72)
			Result.put (new_pair (33,63),73)
			Result.put (new_quadruple (8242,8242,8242,8242),87)
			Result.put (new_singleton (32),95)
			Result.put (new_singleton (48),112)
			Result.put (new_singleton (105),113)
			Result.put (new_singleton (52),116)
			Result.put (new_singleton (53),117)
			Result.put (new_singleton (54),118)
			Result.put (new_singleton (55),119)
			Result.put (new_singleton (56),120)
			Result.put (new_singleton (57),121)
			Result.put (new_singleton (43),122)
			Result.put (new_singleton (8722),123)
			Result.put (new_singleton (61),124)
			Result.put (new_singleton (40),125)
			Result.put (new_singleton (41),126)
			Result.put (new_singleton (110),127)
			Result.put (new_singleton (48),128)
			Result.put (new_singleton (49),129)
			Result.put (new_singleton (50),130)
			Result.put (new_singleton (51),131)
			Result.put (new_singleton (52),132)
			Result.put (new_singleton (53),133)
			Result.put (new_singleton (54),134)
			Result.put (new_singleton (55),135)
			Result.put (new_singleton (56),136)
			Result.put (new_singleton (57),137)
			Result.put (new_singleton (43),138)
			Result.put (new_singleton (8722),139)
			Result.put (new_singleton (61),140)
			Result.put (new_singleton (40),141)
			Result.put (new_singleton (41),142)
			Result.put (new_singleton (97),144)
			Result.put (new_singleton (101),145)
			Result.put (new_singleton (111),146)
			Result.put (new_singleton (120),147)
			Result.put (new_singleton (601),148)
			Result.put (new_pair (82,115),168)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_33: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (97,47,99),0)
			Result.put (new_triple (97,47,115),1)
			Result.put (new_singleton (67),2)
			Result.put (new_pair (176,67),3)
			Result.put (new_triple (99,47,111),5)
			Result.put (new_triple (99,47,117),6)
			Result.put (new_singleton (400),7)
			Result.put (new_pair (176,70),9)
			Result.put (new_singleton (103),10)
			Result.put (new_singleton (72),11)
			Result.put (new_singleton (72),12)
			Result.put (new_singleton (72),13)
			Result.put (new_singleton (104),14)
			Result.put (new_singleton (295),15)
			Result.put (new_singleton (73),16)
			Result.put (new_singleton (73),17)
			Result.put (new_singleton (76),18)
			Result.put (new_singleton (108),19)
			Result.put (new_singleton (78),21)
			Result.put (new_pair (78,111),22)
			Result.put (new_singleton (80),25)
			Result.put (new_singleton (81),26)
			Result.put (new_singleton (82),27)
			Result.put (new_singleton (82),28)
			Result.put (new_singleton (82),29)
			Result.put (new_pair (83,77),32)
			Result.put (new_triple (84,69,76),33)
			Result.put (new_pair (84,77),34)
			Result.put (new_singleton (90),36)
			Result.put (new_singleton (937),38)
			Result.put (new_singleton (90),40)
			Result.put (new_singleton (75),42)
			Result.put (new_singleton (197),43)
			Result.put (new_singleton (66),44)
			Result.put (new_singleton (67),45)
			Result.put (new_singleton (101),47)
			Result.put (new_singleton (69),48)
			Result.put (new_singleton (70),49)
			Result.put (new_singleton (77),51)
			Result.put (new_singleton (111),52)
			Result.put (new_singleton (1488),53)
			Result.put (new_singleton (1489),54)
			Result.put (new_singleton (1490),55)
			Result.put (new_singleton (1491),56)
			Result.put (new_singleton (105),57)
			Result.put (new_triple (70,65,88),59)
			Result.put (new_singleton (960),60)
			Result.put (new_singleton (947),61)
			Result.put (new_singleton (915),62)
			Result.put (new_singleton (928),63)
			Result.put (new_singleton (8721),64)
			Result.put (new_singleton (68),69)
			Result.put (new_singleton (100),70)
			Result.put (new_singleton (101),71)
			Result.put (new_singleton (105),72)
			Result.put (new_singleton (106),73)
			Result.put (new_triple (49,8260,51),83)
			Result.put (new_triple (50,8260,51),84)
			Result.put (new_triple (49,8260,53),85)
			Result.put (new_triple (50,8260,53),86)
			Result.put (new_triple (51,8260,53),87)
			Result.put (new_triple (52,8260,53),88)
			Result.put (new_triple (49,8260,54),89)
			Result.put (new_triple (53,8260,54),90)
			Result.put (new_triple (49,8260,56),91)
			Result.put (new_triple (51,8260,56),92)
			Result.put (new_triple (53,8260,56),93)
			Result.put (new_triple (55,8260,56),94)
			Result.put (new_pair (49,8260),95)
			Result.put (new_singleton (73),96)
			Result.put (new_pair (73,73),97)
			Result.put (new_triple (73,73,73),98)
			Result.put (new_pair (73,86),99)
			Result.put (new_singleton (86),100)
			Result.put (new_pair (86,73),101)
			Result.put (new_triple (86,73,73),102)
			Result.put (new_quadruple (86,73,73,73),103)
			Result.put (new_pair (73,88),104)
			Result.put (new_singleton (88),105)
			Result.put (new_pair (88,73),106)
			Result.put (new_triple (88,73,73),107)
			Result.put (new_singleton (76),108)
			Result.put (new_singleton (67),109)
			Result.put (new_singleton (68),110)
			Result.put (new_singleton (77),111)
			Result.put (new_singleton (105),112)
			Result.put (new_pair (105,105),113)
			Result.put (new_triple (105,105,105),114)
			Result.put (new_pair (105,118),115)
			Result.put (new_singleton (118),116)
			Result.put (new_pair (118,105),117)
			Result.put (new_triple (118,105,105),118)
			Result.put (new_quadruple (118,105,105,105),119)
			Result.put (new_pair (105,120),120)
			Result.put (new_singleton (120),121)
			Result.put (new_pair (120,105),122)
			Result.put (new_triple (120,105,105),123)
			Result.put (new_singleton (108),124)
			Result.put (new_singleton (99),125)
			Result.put (new_singleton (100),126)
			Result.put (new_singleton (109),127)
			Result.put (new_pair (8592,824),154)
			Result.put (new_pair (8594,824),155)
			Result.put (new_pair (8596,824),174)
			Result.put (new_pair (8656,824),205)
			Result.put (new_pair (8660,824),206)
			Result.put (new_pair (8658,824),207)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_34: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (8707,824),4)
			Result.put (new_pair (8712,824),9)
			Result.put (new_pair (8715,824),12)
			Result.put (new_pair (8739,824),36)
			Result.put (new_pair (8741,824),38)
			Result.put (new_pair (8747,8747),44)
			Result.put (new_triple (8747,8747,8747),45)
			Result.put (new_pair (8750,8750),47)
			Result.put (new_triple (8750,8750,8750),48)
			Result.put (new_pair (8764,824),65)
			Result.put (new_pair (8771,824),68)
			Result.put (new_pair (8773,824),71)
			Result.put (new_pair (8776,824),73)
			Result.put (new_pair (61,824),96)
			Result.put (new_pair (8801,824),98)
			Result.put (new_pair (8781,824),109)
			Result.put (new_pair (60,824),110)
			Result.put (new_pair (62,824),111)
			Result.put (new_pair (8804,824),112)
			Result.put (new_pair (8805,824),113)
			Result.put (new_pair (8818,824),116)
			Result.put (new_pair (8819,824),117)
			Result.put (new_pair (8822,824),120)
			Result.put (new_pair (8823,824),121)
			Result.put (new_pair (8826,824),128)
			Result.put (new_pair (8827,824),129)
			Result.put (new_pair (8834,824),132)
			Result.put (new_pair (8835,824),133)
			Result.put (new_pair (8838,824),136)
			Result.put (new_pair (8839,824),137)
			Result.put (new_pair (8866,824),172)
			Result.put (new_pair (8872,824),173)
			Result.put (new_pair (8873,824),174)
			Result.put (new_pair (8875,824),175)
			Result.put (new_pair (8828,824),224)
			Result.put (new_pair (8829,824),225)
			Result.put (new_pair (8849,824),226)
			Result.put (new_pair (8850,824),227)
			Result.put (new_pair (8882,824),234)
			Result.put (new_pair (8883,824),235)
			Result.put (new_pair (8884,824),236)
			Result.put (new_pair (8885,824),237)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_35: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (12296),41)
			Result.put (new_singleton (12297),42)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_36: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (49),96)
			Result.put (new_singleton (50),97)
			Result.put (new_singleton (51),98)
			Result.put (new_singleton (52),99)
			Result.put (new_singleton (53),100)
			Result.put (new_singleton (54),101)
			Result.put (new_singleton (55),102)
			Result.put (new_singleton (56),103)
			Result.put (new_singleton (57),104)
			Result.put (new_pair (49,48),105)
			Result.put (new_pair (49,49),106)
			Result.put (new_pair (49,50),107)
			Result.put (new_pair (49,51),108)
			Result.put (new_pair (49,52),109)
			Result.put (new_pair (49,53),110)
			Result.put (new_pair (49,54),111)
			Result.put (new_pair (49,55),112)
			Result.put (new_pair (49,56),113)
			Result.put (new_pair (49,57),114)
			Result.put (new_pair (50,48),115)
			Result.put (new_triple (40,49,41),116)
			Result.put (new_triple (40,50,41),117)
			Result.put (new_triple (40,51,41),118)
			Result.put (new_triple (40,52,41),119)
			Result.put (new_triple (40,53,41),120)
			Result.put (new_triple (40,54,41),121)
			Result.put (new_triple (40,55,41),122)
			Result.put (new_triple (40,56,41),123)
			Result.put (new_triple (40,57,41),124)
			Result.put (new_quadruple (40,49,48,41),125)
			Result.put (new_quadruple (40,49,49,41),126)
			Result.put (new_quadruple (40,49,50,41),127)
			Result.put (new_quadruple (40,49,51,41),128)
			Result.put (new_quadruple (40,49,52,41),129)
			Result.put (new_quadruple (40,49,53,41),130)
			Result.put (new_quadruple (40,49,54,41),131)
			Result.put (new_quadruple (40,49,55,41),132)
			Result.put (new_quadruple (40,49,56,41),133)
			Result.put (new_quadruple (40,49,57,41),134)
			Result.put (new_quadruple (40,50,48,41),135)
			Result.put (new_pair (49,46),136)
			Result.put (new_pair (50,46),137)
			Result.put (new_pair (51,46),138)
			Result.put (new_pair (52,46),139)
			Result.put (new_pair (53,46),140)
			Result.put (new_pair (54,46),141)
			Result.put (new_pair (55,46),142)
			Result.put (new_pair (56,46),143)
			Result.put (new_pair (57,46),144)
			Result.put (new_triple (49,48,46),145)
			Result.put (new_triple (49,49,46),146)
			Result.put (new_triple (49,50,46),147)
			Result.put (new_triple (49,51,46),148)
			Result.put (new_triple (49,52,46),149)
			Result.put (new_triple (49,53,46),150)
			Result.put (new_triple (49,54,46),151)
			Result.put (new_triple (49,55,46),152)
			Result.put (new_triple (49,56,46),153)
			Result.put (new_triple (49,57,46),154)
			Result.put (new_triple (50,48,46),155)
			Result.put (new_triple (40,97,41),156)
			Result.put (new_triple (40,98,41),157)
			Result.put (new_triple (40,99,41),158)
			Result.put (new_triple (40,100,41),159)
			Result.put (new_triple (40,101,41),160)
			Result.put (new_triple (40,102,41),161)
			Result.put (new_triple (40,103,41),162)
			Result.put (new_triple (40,104,41),163)
			Result.put (new_triple (40,105,41),164)
			Result.put (new_triple (40,106,41),165)
			Result.put (new_triple (40,107,41),166)
			Result.put (new_triple (40,108,41),167)
			Result.put (new_triple (40,109,41),168)
			Result.put (new_triple (40,110,41),169)
			Result.put (new_triple (40,111,41),170)
			Result.put (new_triple (40,112,41),171)
			Result.put (new_triple (40,113,41),172)
			Result.put (new_triple (40,114,41),173)
			Result.put (new_triple (40,115,41),174)
			Result.put (new_triple (40,116,41),175)
			Result.put (new_triple (40,117,41),176)
			Result.put (new_triple (40,118,41),177)
			Result.put (new_triple (40,119,41),178)
			Result.put (new_triple (40,120,41),179)
			Result.put (new_triple (40,121,41),180)
			Result.put (new_triple (40,122,41),181)
			Result.put (new_singleton (65),182)
			Result.put (new_singleton (66),183)
			Result.put (new_singleton (67),184)
			Result.put (new_singleton (68),185)
			Result.put (new_singleton (69),186)
			Result.put (new_singleton (70),187)
			Result.put (new_singleton (71),188)
			Result.put (new_singleton (72),189)
			Result.put (new_singleton (73),190)
			Result.put (new_singleton (74),191)
			Result.put (new_singleton (75),192)
			Result.put (new_singleton (76),193)
			Result.put (new_singleton (77),194)
			Result.put (new_singleton (78),195)
			Result.put (new_singleton (79),196)
			Result.put (new_singleton (80),197)
			Result.put (new_singleton (81),198)
			Result.put (new_singleton (82),199)
			Result.put (new_singleton (83),200)
			Result.put (new_singleton (84),201)
			Result.put (new_singleton (85),202)
			Result.put (new_singleton (86),203)
			Result.put (new_singleton (87),204)
			Result.put (new_singleton (88),205)
			Result.put (new_singleton (89),206)
			Result.put (new_singleton (90),207)
			Result.put (new_singleton (97),208)
			Result.put (new_singleton (98),209)
			Result.put (new_singleton (99),210)
			Result.put (new_singleton (100),211)
			Result.put (new_singleton (101),212)
			Result.put (new_singleton (102),213)
			Result.put (new_singleton (103),214)
			Result.put (new_singleton (104),215)
			Result.put (new_singleton (105),216)
			Result.put (new_singleton (106),217)
			Result.put (new_singleton (107),218)
			Result.put (new_singleton (108),219)
			Result.put (new_singleton (109),220)
			Result.put (new_singleton (110),221)
			Result.put (new_singleton (111),222)
			Result.put (new_singleton (112),223)
			Result.put (new_singleton (113),224)
			Result.put (new_singleton (114),225)
			Result.put (new_singleton (115),226)
			Result.put (new_singleton (116),227)
			Result.put (new_singleton (117),228)
			Result.put (new_singleton (118),229)
			Result.put (new_singleton (119),230)
			Result.put (new_singleton (120),231)
			Result.put (new_singleton (121),232)
			Result.put (new_singleton (122),233)
			Result.put (new_singleton (48),234)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_42: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_quadruple (8747,8747,8747,8747),12)
			Result.put (new_triple (58,58,61),116)
			Result.put (new_pair (61,61),117)
			Result.put (new_triple (61,61,61),118)
			Result.put (new_pair (10973,824),220)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_44: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (106),124)
			Result.put (new_singleton (86),125)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_45: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (11617),111)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_46: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (27597),159)
			Result.put (new_singleton (40863),243)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_47: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (19968),0)
			Result.put (new_singleton (20008),1)
			Result.put (new_singleton (20022),2)
			Result.put (new_singleton (20031),3)
			Result.put (new_singleton (20057),4)
			Result.put (new_singleton (20101),5)
			Result.put (new_singleton (20108),6)
			Result.put (new_singleton (20128),7)
			Result.put (new_singleton (20154),8)
			Result.put (new_singleton (20799),9)
			Result.put (new_singleton (20837),10)
			Result.put (new_singleton (20843),11)
			Result.put (new_singleton (20866),12)
			Result.put (new_singleton (20886),13)
			Result.put (new_singleton (20907),14)
			Result.put (new_singleton (20960),15)
			Result.put (new_singleton (20981),16)
			Result.put (new_singleton (20992),17)
			Result.put (new_singleton (21147),18)
			Result.put (new_singleton (21241),19)
			Result.put (new_singleton (21269),20)
			Result.put (new_singleton (21274),21)
			Result.put (new_singleton (21304),22)
			Result.put (new_singleton (21313),23)
			Result.put (new_singleton (21340),24)
			Result.put (new_singleton (21353),25)
			Result.put (new_singleton (21378),26)
			Result.put (new_singleton (21430),27)
			Result.put (new_singleton (21448),28)
			Result.put (new_singleton (21475),29)
			Result.put (new_singleton (22231),30)
			Result.put (new_singleton (22303),31)
			Result.put (new_singleton (22763),32)
			Result.put (new_singleton (22786),33)
			Result.put (new_singleton (22794),34)
			Result.put (new_singleton (22805),35)
			Result.put (new_singleton (22823),36)
			Result.put (new_singleton (22899),37)
			Result.put (new_singleton (23376),38)
			Result.put (new_singleton (23424),39)
			Result.put (new_singleton (23544),40)
			Result.put (new_singleton (23567),41)
			Result.put (new_singleton (23586),42)
			Result.put (new_singleton (23608),43)
			Result.put (new_singleton (23662),44)
			Result.put (new_singleton (23665),45)
			Result.put (new_singleton (24027),46)
			Result.put (new_singleton (24037),47)
			Result.put (new_singleton (24049),48)
			Result.put (new_singleton (24062),49)
			Result.put (new_singleton (24178),50)
			Result.put (new_singleton (24186),51)
			Result.put (new_singleton (24191),52)
			Result.put (new_singleton (24308),53)
			Result.put (new_singleton (24318),54)
			Result.put (new_singleton (24331),55)
			Result.put (new_singleton (24339),56)
			Result.put (new_singleton (24400),57)
			Result.put (new_singleton (24417),58)
			Result.put (new_singleton (24435),59)
			Result.put (new_singleton (24515),60)
			Result.put (new_singleton (25096),61)
			Result.put (new_singleton (25142),62)
			Result.put (new_singleton (25163),63)
			Result.put (new_singleton (25903),64)
			Result.put (new_singleton (25908),65)
			Result.put (new_singleton (25991),66)
			Result.put (new_singleton (26007),67)
			Result.put (new_singleton (26020),68)
			Result.put (new_singleton (26041),69)
			Result.put (new_singleton (26080),70)
			Result.put (new_singleton (26085),71)
			Result.put (new_singleton (26352),72)
			Result.put (new_singleton (26376),73)
			Result.put (new_singleton (26408),74)
			Result.put (new_singleton (27424),75)
			Result.put (new_singleton (27490),76)
			Result.put (new_singleton (27513),77)
			Result.put (new_singleton (27571),78)
			Result.put (new_singleton (27595),79)
			Result.put (new_singleton (27604),80)
			Result.put (new_singleton (27611),81)
			Result.put (new_singleton (27663),82)
			Result.put (new_singleton (27668),83)
			Result.put (new_singleton (27700),84)
			Result.put (new_singleton (28779),85)
			Result.put (new_singleton (29226),86)
			Result.put (new_singleton (29238),87)
			Result.put (new_singleton (29243),88)
			Result.put (new_singleton (29247),89)
			Result.put (new_singleton (29255),90)
			Result.put (new_singleton (29273),91)
			Result.put (new_singleton (29275),92)
			Result.put (new_singleton (29356),93)
			Result.put (new_singleton (29572),94)
			Result.put (new_singleton (29577),95)
			Result.put (new_singleton (29916),96)
			Result.put (new_singleton (29926),97)
			Result.put (new_singleton (29976),98)
			Result.put (new_singleton (29983),99)
			Result.put (new_singleton (29992),100)
			Result.put (new_singleton (30000),101)
			Result.put (new_singleton (30091),102)
			Result.put (new_singleton (30098),103)
			Result.put (new_singleton (30326),104)
			Result.put (new_singleton (30333),105)
			Result.put (new_singleton (30382),106)
			Result.put (new_singleton (30399),107)
			Result.put (new_singleton (30446),108)
			Result.put (new_singleton (30683),109)
			Result.put (new_singleton (30690),110)
			Result.put (new_singleton (30707),111)
			Result.put (new_singleton (31034),112)
			Result.put (new_singleton (31160),113)
			Result.put (new_singleton (31166),114)
			Result.put (new_singleton (31348),115)
			Result.put (new_singleton (31435),116)
			Result.put (new_singleton (31481),117)
			Result.put (new_singleton (31859),118)
			Result.put (new_singleton (31992),119)
			Result.put (new_singleton (32566),120)
			Result.put (new_singleton (32593),121)
			Result.put (new_singleton (32650),122)
			Result.put (new_singleton (32701),123)
			Result.put (new_singleton (32769),124)
			Result.put (new_singleton (32780),125)
			Result.put (new_singleton (32786),126)
			Result.put (new_singleton (32819),127)
			Result.put (new_singleton (32895),128)
			Result.put (new_singleton (32905),129)
			Result.put (new_singleton (33251),130)
			Result.put (new_singleton (33258),131)
			Result.put (new_singleton (33267),132)
			Result.put (new_singleton (33276),133)
			Result.put (new_singleton (33292),134)
			Result.put (new_singleton (33307),135)
			Result.put (new_singleton (33311),136)
			Result.put (new_singleton (33390),137)
			Result.put (new_singleton (33394),138)
			Result.put (new_singleton (33400),139)
			Result.put (new_singleton (34381),140)
			Result.put (new_singleton (34411),141)
			Result.put (new_singleton (34880),142)
			Result.put (new_singleton (34892),143)
			Result.put (new_singleton (34915),144)
			Result.put (new_singleton (35198),145)
			Result.put (new_singleton (35211),146)
			Result.put (new_singleton (35282),147)
			Result.put (new_singleton (35328),148)
			Result.put (new_singleton (35895),149)
			Result.put (new_singleton (35910),150)
			Result.put (new_singleton (35925),151)
			Result.put (new_singleton (35960),152)
			Result.put (new_singleton (35997),153)
			Result.put (new_singleton (36196),154)
			Result.put (new_singleton (36208),155)
			Result.put (new_singleton (36275),156)
			Result.put (new_singleton (36523),157)
			Result.put (new_singleton (36554),158)
			Result.put (new_singleton (36763),159)
			Result.put (new_singleton (36784),160)
			Result.put (new_singleton (36789),161)
			Result.put (new_singleton (37009),162)
			Result.put (new_singleton (37193),163)
			Result.put (new_singleton (37318),164)
			Result.put (new_singleton (37324),165)
			Result.put (new_singleton (37329),166)
			Result.put (new_singleton (38263),167)
			Result.put (new_singleton (38272),168)
			Result.put (new_singleton (38428),169)
			Result.put (new_singleton (38582),170)
			Result.put (new_singleton (38585),171)
			Result.put (new_singleton (38632),172)
			Result.put (new_singleton (38737),173)
			Result.put (new_singleton (38750),174)
			Result.put (new_singleton (38754),175)
			Result.put (new_singleton (38761),176)
			Result.put (new_singleton (38859),177)
			Result.put (new_singleton (38893),178)
			Result.put (new_singleton (38899),179)
			Result.put (new_singleton (38913),180)
			Result.put (new_singleton (39080),181)
			Result.put (new_singleton (39131),182)
			Result.put (new_singleton (39135),183)
			Result.put (new_singleton (39318),184)
			Result.put (new_singleton (39321),185)
			Result.put (new_singleton (39340),186)
			Result.put (new_singleton (39592),187)
			Result.put (new_singleton (39640),188)
			Result.put (new_singleton (39647),189)
			Result.put (new_singleton (39717),190)
			Result.put (new_singleton (39727),191)
			Result.put (new_singleton (39730),192)
			Result.put (new_singleton (39740),193)
			Result.put (new_singleton (39770),194)
			Result.put (new_singleton (40165),195)
			Result.put (new_singleton (40565),196)
			Result.put (new_singleton (40575),197)
			Result.put (new_singleton (40613),198)
			Result.put (new_singleton (40635),199)
			Result.put (new_singleton (40643),200)
			Result.put (new_singleton (40653),201)
			Result.put (new_singleton (40657),202)
			Result.put (new_singleton (40697),203)
			Result.put (new_singleton (40701),204)
			Result.put (new_singleton (40718),205)
			Result.put (new_singleton (40723),206)
			Result.put (new_singleton (40736),207)
			Result.put (new_singleton (40763),208)
			Result.put (new_singleton (40778),209)
			Result.put (new_singleton (40786),210)
			Result.put (new_singleton (40845),211)
			Result.put (new_singleton (40860),212)
			Result.put (new_singleton (40864),213)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_48: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (32),0)
			Result.put (new_singleton (12306),54)
			Result.put (new_singleton (21313),56)
			Result.put (new_singleton (21316),57)
			Result.put (new_singleton (21317),58)
			Result.put (new_pair (12363,12441),76)
			Result.put (new_pair (12365,12441),78)
			Result.put (new_pair (12367,12441),80)
			Result.put (new_pair (12369,12441),82)
			Result.put (new_pair (12371,12441),84)
			Result.put (new_pair (12373,12441),86)
			Result.put (new_pair (12375,12441),88)
			Result.put (new_pair (12377,12441),90)
			Result.put (new_pair (12379,12441),92)
			Result.put (new_pair (12381,12441),94)
			Result.put (new_pair (12383,12441),96)
			Result.put (new_pair (12385,12441),98)
			Result.put (new_pair (12388,12441),101)
			Result.put (new_pair (12390,12441),103)
			Result.put (new_pair (12392,12441),105)
			Result.put (new_pair (12399,12441),112)
			Result.put (new_pair (12399,12442),113)
			Result.put (new_pair (12402,12441),115)
			Result.put (new_pair (12402,12442),116)
			Result.put (new_pair (12405,12441),118)
			Result.put (new_pair (12405,12442),119)
			Result.put (new_pair (12408,12441),121)
			Result.put (new_pair (12408,12442),122)
			Result.put (new_pair (12411,12441),124)
			Result.put (new_pair (12411,12442),125)
			Result.put (new_pair (12358,12441),148)
			Result.put (new_pair (32,12441),155)
			Result.put (new_pair (32,12442),156)
			Result.put (new_pair (12445,12441),158)
			Result.put (new_pair (12424,12426),159)
			Result.put (new_pair (12459,12441),172)
			Result.put (new_pair (12461,12441),174)
			Result.put (new_pair (12463,12441),176)
			Result.put (new_pair (12465,12441),178)
			Result.put (new_pair (12467,12441),180)
			Result.put (new_pair (12469,12441),182)
			Result.put (new_pair (12471,12441),184)
			Result.put (new_pair (12473,12441),186)
			Result.put (new_pair (12475,12441),188)
			Result.put (new_pair (12477,12441),190)
			Result.put (new_pair (12479,12441),192)
			Result.put (new_pair (12481,12441),194)
			Result.put (new_pair (12484,12441),197)
			Result.put (new_pair (12486,12441),199)
			Result.put (new_pair (12488,12441),201)
			Result.put (new_pair (12495,12441),208)
			Result.put (new_pair (12495,12442),209)
			Result.put (new_pair (12498,12441),211)
			Result.put (new_pair (12498,12442),212)
			Result.put (new_pair (12501,12441),214)
			Result.put (new_pair (12501,12442),215)
			Result.put (new_pair (12504,12441),217)
			Result.put (new_pair (12504,12442),218)
			Result.put (new_pair (12507,12441),220)
			Result.put (new_pair (12507,12442),221)
			Result.put (new_pair (12454,12441),244)
			Result.put (new_pair (12527,12441),247)
			Result.put (new_pair (12528,12441),248)
			Result.put (new_pair (12529,12441),249)
			Result.put (new_pair (12530,12441),250)
			Result.put (new_pair (12541,12441),254)
			Result.put (new_pair (12467,12488),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_49: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (4352),49)
			Result.put (new_singleton (4353),50)
			Result.put (new_singleton (4522),51)
			Result.put (new_singleton (4354),52)
			Result.put (new_singleton (4524),53)
			Result.put (new_singleton (4525),54)
			Result.put (new_singleton (4355),55)
			Result.put (new_singleton (4356),56)
			Result.put (new_singleton (4357),57)
			Result.put (new_singleton (4528),58)
			Result.put (new_singleton (4529),59)
			Result.put (new_singleton (4530),60)
			Result.put (new_singleton (4531),61)
			Result.put (new_singleton (4532),62)
			Result.put (new_singleton (4533),63)
			Result.put (new_singleton (4378),64)
			Result.put (new_singleton (4358),65)
			Result.put (new_singleton (4359),66)
			Result.put (new_singleton (4360),67)
			Result.put (new_singleton (4385),68)
			Result.put (new_singleton (4361),69)
			Result.put (new_singleton (4362),70)
			Result.put (new_singleton (4363),71)
			Result.put (new_singleton (4364),72)
			Result.put (new_singleton (4365),73)
			Result.put (new_singleton (4366),74)
			Result.put (new_singleton (4367),75)
			Result.put (new_singleton (4368),76)
			Result.put (new_singleton (4369),77)
			Result.put (new_singleton (4370),78)
			Result.put (new_singleton (4449),79)
			Result.put (new_singleton (4450),80)
			Result.put (new_singleton (4451),81)
			Result.put (new_singleton (4452),82)
			Result.put (new_singleton (4453),83)
			Result.put (new_singleton (4454),84)
			Result.put (new_singleton (4455),85)
			Result.put (new_singleton (4456),86)
			Result.put (new_singleton (4457),87)
			Result.put (new_singleton (4458),88)
			Result.put (new_singleton (4459),89)
			Result.put (new_singleton (4460),90)
			Result.put (new_singleton (4461),91)
			Result.put (new_singleton (4462),92)
			Result.put (new_singleton (4463),93)
			Result.put (new_singleton (4464),94)
			Result.put (new_singleton (4465),95)
			Result.put (new_singleton (4466),96)
			Result.put (new_singleton (4467),97)
			Result.put (new_singleton (4468),98)
			Result.put (new_singleton (4469),99)
			Result.put (new_singleton (4448),100)
			Result.put (new_singleton (4372),101)
			Result.put (new_singleton (4373),102)
			Result.put (new_singleton (4551),103)
			Result.put (new_singleton (4552),104)
			Result.put (new_singleton (4556),105)
			Result.put (new_singleton (4558),106)
			Result.put (new_singleton (4563),107)
			Result.put (new_singleton (4567),108)
			Result.put (new_singleton (4569),109)
			Result.put (new_singleton (4380),110)
			Result.put (new_singleton (4573),111)
			Result.put (new_singleton (4575),112)
			Result.put (new_singleton (4381),113)
			Result.put (new_singleton (4382),114)
			Result.put (new_singleton (4384),115)
			Result.put (new_singleton (4386),116)
			Result.put (new_singleton (4387),117)
			Result.put (new_singleton (4391),118)
			Result.put (new_singleton (4393),119)
			Result.put (new_singleton (4395),120)
			Result.put (new_singleton (4396),121)
			Result.put (new_singleton (4397),122)
			Result.put (new_singleton (4398),123)
			Result.put (new_singleton (4399),124)
			Result.put (new_singleton (4402),125)
			Result.put (new_singleton (4406),126)
			Result.put (new_singleton (4416),127)
			Result.put (new_singleton (4423),128)
			Result.put (new_singleton (4428),129)
			Result.put (new_singleton (4593),130)
			Result.put (new_singleton (4594),131)
			Result.put (new_singleton (4439),132)
			Result.put (new_singleton (4440),133)
			Result.put (new_singleton (4441),134)
			Result.put (new_singleton (4484),135)
			Result.put (new_singleton (4485),136)
			Result.put (new_singleton (4488),137)
			Result.put (new_singleton (4497),138)
			Result.put (new_singleton (4498),139)
			Result.put (new_singleton (4500),140)
			Result.put (new_singleton (4510),141)
			Result.put (new_singleton (4513),142)
			Result.put (new_singleton (19968),146)
			Result.put (new_singleton (20108),147)
			Result.put (new_singleton (19977),148)
			Result.put (new_singleton (22235),149)
			Result.put (new_singleton (19978),150)
			Result.put (new_singleton (20013),151)
			Result.put (new_singleton (19979),152)
			Result.put (new_singleton (30002),153)
			Result.put (new_singleton (20057),154)
			Result.put (new_singleton (19993),155)
			Result.put (new_singleton (19969),156)
			Result.put (new_singleton (22825),157)
			Result.put (new_singleton (22320),158)
			Result.put (new_singleton (20154),159)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_50: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (40,4352,41),0)
			Result.put (new_triple (40,4354,41),1)
			Result.put (new_triple (40,4355,41),2)
			Result.put (new_triple (40,4357,41),3)
			Result.put (new_triple (40,4358,41),4)
			Result.put (new_triple (40,4359,41),5)
			Result.put (new_triple (40,4361,41),6)
			Result.put (new_triple (40,4363,41),7)
			Result.put (new_triple (40,4364,41),8)
			Result.put (new_triple (40,4366,41),9)
			Result.put (new_triple (40,4367,41),10)
			Result.put (new_triple (40,4368,41),11)
			Result.put (new_triple (40,4369,41),12)
			Result.put (new_triple (40,4370,41),13)
			Result.put (new_quadruple (40,4352,4449,41),14)
			Result.put (new_quadruple (40,4354,4449,41),15)
			Result.put (new_quadruple (40,4355,4449,41),16)
			Result.put (new_quadruple (40,4357,4449,41),17)
			Result.put (new_quadruple (40,4358,4449,41),18)
			Result.put (new_quadruple (40,4359,4449,41),19)
			Result.put (new_quadruple (40,4361,4449,41),20)
			Result.put (new_quadruple (40,4363,4449,41),21)
			Result.put (new_quadruple (40,4364,4449,41),22)
			Result.put (new_quadruple (40,4366,4449,41),23)
			Result.put (new_quadruple (40,4367,4449,41),24)
			Result.put (new_quadruple (40,4368,4449,41),25)
			Result.put (new_quadruple (40,4369,4449,41),26)
			Result.put (new_quadruple (40,4370,4449,41),27)
			Result.put (new_quadruple (40,4364,4462,41),28)
			Result.put (new_heptuple (40,4363,4457,4364,4453,4523,41),29)
			Result.put (new_sextuple (40,4363,4457,4370,4462,41),30)
			Result.put (new_triple (40,19968,41),32)
			Result.put (new_triple (40,20108,41),33)
			Result.put (new_triple (40,19977,41),34)
			Result.put (new_triple (40,22235,41),35)
			Result.put (new_triple (40,20116,41),36)
			Result.put (new_triple (40,20845,41),37)
			Result.put (new_triple (40,19971,41),38)
			Result.put (new_triple (40,20843,41),39)
			Result.put (new_triple (40,20061,41),40)
			Result.put (new_triple (40,21313,41),41)
			Result.put (new_triple (40,26376,41),42)
			Result.put (new_triple (40,28779,41),43)
			Result.put (new_triple (40,27700,41),44)
			Result.put (new_triple (40,26408,41),45)
			Result.put (new_triple (40,37329,41),46)
			Result.put (new_triple (40,22303,41),47)
			Result.put (new_triple (40,26085,41),48)
			Result.put (new_triple (40,26666,41),49)
			Result.put (new_triple (40,26377,41),50)
			Result.put (new_triple (40,31038,41),51)
			Result.put (new_triple (40,21517,41),52)
			Result.put (new_triple (40,29305,41),53)
			Result.put (new_triple (40,36001,41),54)
			Result.put (new_triple (40,31069,41),55)
			Result.put (new_triple (40,21172,41),56)
			Result.put (new_triple (40,20195,41),57)
			Result.put (new_triple (40,21628,41),58)
			Result.put (new_triple (40,23398,41),59)
			Result.put (new_triple (40,30435,41),60)
			Result.put (new_triple (40,20225,41),61)
			Result.put (new_triple (40,36039,41),62)
			Result.put (new_triple (40,21332,41),63)
			Result.put (new_triple (40,31085,41),64)
			Result.put (new_triple (40,20241,41),65)
			Result.put (new_triple (40,33258,41),66)
			Result.put (new_triple (40,33267,41),67)
			Result.put (new_triple (80,84,69),80)
			Result.put (new_pair (50,49),81)
			Result.put (new_pair (50,50),82)
			Result.put (new_pair (50,51),83)
			Result.put (new_pair (50,52),84)
			Result.put (new_pair (50,53),85)
			Result.put (new_pair (50,54),86)
			Result.put (new_pair (50,55),87)
			Result.put (new_pair (50,56),88)
			Result.put (new_pair (50,57),89)
			Result.put (new_pair (51,48),90)
			Result.put (new_pair (51,49),91)
			Result.put (new_pair (51,50),92)
			Result.put (new_pair (51,51),93)
			Result.put (new_pair (51,52),94)
			Result.put (new_pair (51,53),95)
			Result.put (new_singleton (4352),96)
			Result.put (new_singleton (4354),97)
			Result.put (new_singleton (4355),98)
			Result.put (new_singleton (4357),99)
			Result.put (new_singleton (4358),100)
			Result.put (new_singleton (4359),101)
			Result.put (new_singleton (4361),102)
			Result.put (new_singleton (4363),103)
			Result.put (new_singleton (4364),104)
			Result.put (new_singleton (4366),105)
			Result.put (new_singleton (4367),106)
			Result.put (new_singleton (4368),107)
			Result.put (new_singleton (4369),108)
			Result.put (new_singleton (4370),109)
			Result.put (new_pair (4352,4449),110)
			Result.put (new_pair (4354,4449),111)
			Result.put (new_pair (4355,4449),112)
			Result.put (new_pair (4357,4449),113)
			Result.put (new_pair (4358,4449),114)
			Result.put (new_pair (4359,4449),115)
			Result.put (new_pair (4361,4449),116)
			Result.put (new_pair (4363,4449),117)
			Result.put (new_pair (4364,4449),118)
			Result.put (new_pair (4366,4449),119)
			Result.put (new_pair (4367,4449),120)
			Result.put (new_pair (4368,4449),121)
			Result.put (new_pair (4369,4449),122)
			Result.put (new_pair (4370,4449),123)
			Result.put (new_quintuple (4366,4449,4535,4352,4457),124)
			Result.put (new_quadruple (4364,4462,4363,4468),125)
			Result.put (new_pair (4363,4462),126)
			Result.put (new_singleton (19968),128)
			Result.put (new_singleton (20108),129)
			Result.put (new_singleton (19977),130)
			Result.put (new_singleton (22235),131)
			Result.put (new_singleton (20116),132)
			Result.put (new_singleton (20845),133)
			Result.put (new_singleton (19971),134)
			Result.put (new_singleton (20843),135)
			Result.put (new_singleton (20061),136)
			Result.put (new_singleton (21313),137)
			Result.put (new_singleton (26376),138)
			Result.put (new_singleton (28779),139)
			Result.put (new_singleton (27700),140)
			Result.put (new_singleton (26408),141)
			Result.put (new_singleton (37329),142)
			Result.put (new_singleton (22303),143)
			Result.put (new_singleton (26085),144)
			Result.put (new_singleton (26666),145)
			Result.put (new_singleton (26377),146)
			Result.put (new_singleton (31038),147)
			Result.put (new_singleton (21517),148)
			Result.put (new_singleton (29305),149)
			Result.put (new_singleton (36001),150)
			Result.put (new_singleton (31069),151)
			Result.put (new_singleton (21172),152)
			Result.put (new_singleton (31192),153)
			Result.put (new_singleton (30007),154)
			Result.put (new_singleton (22899),155)
			Result.put (new_singleton (36969),156)
			Result.put (new_singleton (20778),157)
			Result.put (new_singleton (21360),158)
			Result.put (new_singleton (27880),159)
			Result.put (new_singleton (38917),160)
			Result.put (new_singleton (20241),161)
			Result.put (new_singleton (20889),162)
			Result.put (new_singleton (27491),163)
			Result.put (new_singleton (19978),164)
			Result.put (new_singleton (20013),165)
			Result.put (new_singleton (19979),166)
			Result.put (new_singleton (24038),167)
			Result.put (new_singleton (21491),168)
			Result.put (new_singleton (21307),169)
			Result.put (new_singleton (23447),170)
			Result.put (new_singleton (23398),171)
			Result.put (new_singleton (30435),172)
			Result.put (new_singleton (20225),173)
			Result.put (new_singleton (36039),174)
			Result.put (new_singleton (21332),175)
			Result.put (new_singleton (22812),176)
			Result.put (new_pair (51,54),177)
			Result.put (new_pair (51,55),178)
			Result.put (new_pair (51,56),179)
			Result.put (new_pair (51,57),180)
			Result.put (new_pair (52,48),181)
			Result.put (new_pair (52,49),182)
			Result.put (new_pair (52,50),183)
			Result.put (new_pair (52,51),184)
			Result.put (new_pair (52,52),185)
			Result.put (new_pair (52,53),186)
			Result.put (new_pair (52,54),187)
			Result.put (new_pair (52,55),188)
			Result.put (new_pair (52,56),189)
			Result.put (new_pair (52,57),190)
			Result.put (new_pair (53,48),191)
			Result.put (new_pair (49,26376),192)
			Result.put (new_pair (50,26376),193)
			Result.put (new_pair (51,26376),194)
			Result.put (new_pair (52,26376),195)
			Result.put (new_pair (53,26376),196)
			Result.put (new_pair (54,26376),197)
			Result.put (new_pair (55,26376),198)
			Result.put (new_pair (56,26376),199)
			Result.put (new_pair (57,26376),200)
			Result.put (new_triple (49,48,26376),201)
			Result.put (new_triple (49,49,26376),202)
			Result.put (new_triple (49,50,26376),203)
			Result.put (new_pair (72,103),204)
			Result.put (new_triple (101,114,103),205)
			Result.put (new_pair (101,86),206)
			Result.put (new_triple (76,84,68),207)
			Result.put (new_singleton (12450),208)
			Result.put (new_singleton (12452),209)
			Result.put (new_singleton (12454),210)
			Result.put (new_singleton (12456),211)
			Result.put (new_singleton (12458),212)
			Result.put (new_singleton (12459),213)
			Result.put (new_singleton (12461),214)
			Result.put (new_singleton (12463),215)
			Result.put (new_singleton (12465),216)
			Result.put (new_singleton (12467),217)
			Result.put (new_singleton (12469),218)
			Result.put (new_singleton (12471),219)
			Result.put (new_singleton (12473),220)
			Result.put (new_singleton (12475),221)
			Result.put (new_singleton (12477),222)
			Result.put (new_singleton (12479),223)
			Result.put (new_singleton (12481),224)
			Result.put (new_singleton (12484),225)
			Result.put (new_singleton (12486),226)
			Result.put (new_singleton (12488),227)
			Result.put (new_singleton (12490),228)
			Result.put (new_singleton (12491),229)
			Result.put (new_singleton (12492),230)
			Result.put (new_singleton (12493),231)
			Result.put (new_singleton (12494),232)
			Result.put (new_singleton (12495),233)
			Result.put (new_singleton (12498),234)
			Result.put (new_singleton (12501),235)
			Result.put (new_singleton (12504),236)
			Result.put (new_singleton (12507),237)
			Result.put (new_singleton (12510),238)
			Result.put (new_singleton (12511),239)
			Result.put (new_singleton (12512),240)
			Result.put (new_singleton (12513),241)
			Result.put (new_singleton (12514),242)
			Result.put (new_singleton (12516),243)
			Result.put (new_singleton (12518),244)
			Result.put (new_singleton (12520),245)
			Result.put (new_singleton (12521),246)
			Result.put (new_singleton (12522),247)
			Result.put (new_singleton (12523),248)
			Result.put (new_singleton (12524),249)
			Result.put (new_singleton (12525),250)
			Result.put (new_singleton (12527),251)
			Result.put (new_singleton (12528),252)
			Result.put (new_singleton (12529),253)
			Result.put (new_singleton (12530),254)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_51: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_quadruple (12450,12497,12540,12488),0)
			Result.put (new_quadruple (12450,12523,12501,12449),1)
			Result.put (new_quadruple (12450,12531,12506,12450),2)
			Result.put (new_triple (12450,12540,12523),3)
			Result.put (new_quadruple (12452,12491,12531,12464),4)
			Result.put (new_triple (12452,12531,12481),5)
			Result.put (new_triple (12454,12457,12531),6)
			Result.put (new_quintuple (12456,12473,12463,12540,12489),7)
			Result.put (new_quadruple (12456,12540,12459,12540),8)
			Result.put (new_triple (12458,12531,12473),9)
			Result.put (new_triple (12458,12540,12512),10)
			Result.put (new_triple (12459,12452,12522),11)
			Result.put (new_quadruple (12459,12521,12483,12488),12)
			Result.put (new_quadruple (12459,12525,12522,12540),13)
			Result.put (new_triple (12460,12525,12531),14)
			Result.put (new_triple (12460,12531,12510),15)
			Result.put (new_pair (12462,12460),16)
			Result.put (new_triple (12462,12491,12540),17)
			Result.put (new_quadruple (12461,12517,12522,12540),18)
			Result.put (new_quadruple (12462,12523,12480,12540),19)
			Result.put (new_pair (12461,12525),20)
			Result.put (new_quintuple (12461,12525,12464,12521,12512),21)
			Result.put (new_sextuple (12461,12525,12513,12540,12488,12523),22)
			Result.put (new_quintuple (12461,12525,12527,12483,12488),23)
			Result.put (new_triple (12464,12521,12512),24)
			Result.put (new_quintuple (12464,12521,12512,12488,12531),25)
			Result.put (new_quintuple (12463,12523,12476,12452,12525),26)
			Result.put (new_quadruple (12463,12525,12540,12493),27)
			Result.put (new_triple (12465,12540,12473),28)
			Result.put (new_triple (12467,12523,12490),29)
			Result.put (new_triple (12467,12540,12509),30)
			Result.put (new_quadruple (12469,12452,12463,12523),31)
			Result.put (new_quintuple (12469,12531,12481,12540,12512),32)
			Result.put (new_quadruple (12471,12522,12531,12464),33)
			Result.put (new_triple (12475,12531,12481),34)
			Result.put (new_triple (12475,12531,12488),35)
			Result.put (new_triple (12480,12540,12473),36)
			Result.put (new_pair (12487,12471),37)
			Result.put (new_pair (12489,12523),38)
			Result.put (new_pair (12488,12531),39)
			Result.put (new_pair (12490,12494),40)
			Result.put (new_triple (12494,12483,12488),41)
			Result.put (new_triple (12495,12452,12484),42)
			Result.put (new_quintuple (12497,12540,12475,12531,12488),43)
			Result.put (new_triple (12497,12540,12484),44)
			Result.put (new_quadruple (12496,12540,12524,12523),45)
			Result.put (new_quintuple (12500,12450,12473,12488,12523),46)
			Result.put (new_triple (12500,12463,12523),47)
			Result.put (new_pair (12500,12467),48)
			Result.put (new_pair (12499,12523),49)
			Result.put (new_quintuple (12501,12449,12521,12483,12489),50)
			Result.put (new_quadruple (12501,12451,12540,12488),51)
			Result.put (new_quintuple (12502,12483,12471,12455,12523),52)
			Result.put (new_triple (12501,12521,12531),53)
			Result.put (new_quintuple (12504,12463,12479,12540,12523),54)
			Result.put (new_pair (12506,12477),55)
			Result.put (new_triple (12506,12491,12498),56)
			Result.put (new_triple (12504,12523,12484),57)
			Result.put (new_triple (12506,12531,12473),58)
			Result.put (new_triple (12506,12540,12472),59)
			Result.put (new_triple (12505,12540,12479),60)
			Result.put (new_quadruple (12509,12452,12531,12488),61)
			Result.put (new_triple (12508,12523,12488),62)
			Result.put (new_pair (12507,12531),63)
			Result.put (new_triple (12509,12531,12489),64)
			Result.put (new_triple (12507,12540,12523),65)
			Result.put (new_triple (12507,12540,12531),66)
			Result.put (new_quadruple (12510,12452,12463,12525),67)
			Result.put (new_triple (12510,12452,12523),68)
			Result.put (new_triple (12510,12483,12495),69)
			Result.put (new_triple (12510,12523,12463),70)
			Result.put (new_quintuple (12510,12531,12471,12519,12531),71)
			Result.put (new_quadruple (12511,12463,12525,12531),72)
			Result.put (new_pair (12511,12522),73)
			Result.put (new_quintuple (12511,12522,12496,12540,12523),74)
			Result.put (new_pair (12513,12460),75)
			Result.put (new_quadruple (12513,12460,12488,12531),76)
			Result.put (new_quadruple (12513,12540,12488,12523),77)
			Result.put (new_triple (12516,12540,12489),78)
			Result.put (new_triple (12516,12540,12523),79)
			Result.put (new_triple (12518,12450,12531),80)
			Result.put (new_quadruple (12522,12483,12488,12523),81)
			Result.put (new_pair (12522,12521),82)
			Result.put (new_triple (12523,12500,12540),83)
			Result.put (new_quadruple (12523,12540,12502,12523),84)
			Result.put (new_pair (12524,12512),85)
			Result.put (new_quintuple (12524,12531,12488,12466,12531),86)
			Result.put (new_triple (12527,12483,12488),87)
			Result.put (new_pair (48,28857),88)
			Result.put (new_pair (49,28857),89)
			Result.put (new_pair (50,28857),90)
			Result.put (new_pair (51,28857),91)
			Result.put (new_pair (52,28857),92)
			Result.put (new_pair (53,28857),93)
			Result.put (new_pair (54,28857),94)
			Result.put (new_pair (55,28857),95)
			Result.put (new_pair (56,28857),96)
			Result.put (new_pair (57,28857),97)
			Result.put (new_triple (49,48,28857),98)
			Result.put (new_triple (49,49,28857),99)
			Result.put (new_triple (49,50,28857),100)
			Result.put (new_triple (49,51,28857),101)
			Result.put (new_triple (49,52,28857),102)
			Result.put (new_triple (49,53,28857),103)
			Result.put (new_triple (49,54,28857),104)
			Result.put (new_triple (49,55,28857),105)
			Result.put (new_triple (49,56,28857),106)
			Result.put (new_triple (49,57,28857),107)
			Result.put (new_triple (50,48,28857),108)
			Result.put (new_triple (50,49,28857),109)
			Result.put (new_triple (50,50,28857),110)
			Result.put (new_triple (50,51,28857),111)
			Result.put (new_triple (50,52,28857),112)
			Result.put (new_triple (104,80,97),113)
			Result.put (new_pair (100,97),114)
			Result.put (new_pair (65,85),115)
			Result.put (new_triple (98,97,114),116)
			Result.put (new_pair (111,86),117)
			Result.put (new_pair (112,99),118)
			Result.put (new_pair (100,109),119)
			Result.put (new_triple (100,109,178),120)
			Result.put (new_triple (100,109,179),121)
			Result.put (new_pair (73,85),122)
			Result.put (new_pair (24179,25104),123)
			Result.put (new_pair (26157,21644),124)
			Result.put (new_pair (22823,27491),125)
			Result.put (new_pair (26126,27835),126)
			Result.put (new_quadruple (26666,24335,20250,31038),127)
			Result.put (new_pair (112,65),128)
			Result.put (new_pair (110,65),129)
			Result.put (new_pair (956,65),130)
			Result.put (new_pair (109,65),131)
			Result.put (new_pair (107,65),132)
			Result.put (new_pair (75,66),133)
			Result.put (new_pair (77,66),134)
			Result.put (new_pair (71,66),135)
			Result.put (new_triple (99,97,108),136)
			Result.put (new_quadruple (107,99,97,108),137)
			Result.put (new_pair (112,70),138)
			Result.put (new_pair (110,70),139)
			Result.put (new_pair (956,70),140)
			Result.put (new_pair (956,103),141)
			Result.put (new_pair (109,103),142)
			Result.put (new_pair (107,103),143)
			Result.put (new_pair (72,122),144)
			Result.put (new_triple (107,72,122),145)
			Result.put (new_triple (77,72,122),146)
			Result.put (new_triple (71,72,122),147)
			Result.put (new_triple (84,72,122),148)
			Result.put (new_pair (956,8467),149)
			Result.put (new_pair (109,8467),150)
			Result.put (new_pair (100,8467),151)
			Result.put (new_pair (107,8467),152)
			Result.put (new_pair (102,109),153)
			Result.put (new_pair (110,109),154)
			Result.put (new_pair (956,109),155)
			Result.put (new_pair (109,109),156)
			Result.put (new_pair (99,109),157)
			Result.put (new_pair (107,109),158)
			Result.put (new_triple (109,109,178),159)
			Result.put (new_triple (99,109,178),160)
			Result.put (new_pair (109,178),161)
			Result.put (new_triple (107,109,178),162)
			Result.put (new_triple (109,109,179),163)
			Result.put (new_triple (99,109,179),164)
			Result.put (new_pair (109,179),165)
			Result.put (new_triple (107,109,179),166)
			Result.put (new_triple (109,8725,115),167)
			Result.put (new_quadruple (109,8725,115,178),168)
			Result.put (new_pair (80,97),169)
			Result.put (new_triple (107,80,97),170)
			Result.put (new_triple (77,80,97),171)
			Result.put (new_triple (71,80,97),172)
			Result.put (new_triple (114,97,100),173)
			Result.put (new_quintuple (114,97,100,8725,115),174)
			Result.put (new_sextuple (114,97,100,8725,115,178),175)
			Result.put (new_pair (112,115),176)
			Result.put (new_pair (110,115),177)
			Result.put (new_pair (956,115),178)
			Result.put (new_pair (109,115),179)
			Result.put (new_pair (112,86),180)
			Result.put (new_pair (110,86),181)
			Result.put (new_pair (956,86),182)
			Result.put (new_pair (109,86),183)
			Result.put (new_pair (107,86),184)
			Result.put (new_pair (77,86),185)
			Result.put (new_pair (112,87),186)
			Result.put (new_pair (110,87),187)
			Result.put (new_pair (956,87),188)
			Result.put (new_pair (109,87),189)
			Result.put (new_pair (107,87),190)
			Result.put (new_pair (77,87),191)
			Result.put (new_pair (107,937),192)
			Result.put (new_pair (77,937),193)
			Result.put (new_quadruple (97,46,109,46),194)
			Result.put (new_pair (66,113),195)
			Result.put (new_pair (99,99),196)
			Result.put (new_pair (99,100),197)
			Result.put (new_quadruple (67,8725,107,103),198)
			Result.put (new_triple (67,111,46),199)
			Result.put (new_pair (100,66),200)
			Result.put (new_pair (71,121),201)
			Result.put (new_pair (104,97),202)
			Result.put (new_pair (72,80),203)
			Result.put (new_pair (105,110),204)
			Result.put (new_pair (75,75),205)
			Result.put (new_pair (75,77),206)
			Result.put (new_pair (107,116),207)
			Result.put (new_pair (108,109),208)
			Result.put (new_pair (108,110),209)
			Result.put (new_triple (108,111,103),210)
			Result.put (new_pair (108,120),211)
			Result.put (new_pair (109,98),212)
			Result.put (new_triple (109,105,108),213)
			Result.put (new_triple (109,111,108),214)
			Result.put (new_pair (80,72),215)
			Result.put (new_quadruple (112,46,109,46),216)
			Result.put (new_triple (80,80,77),217)
			Result.put (new_pair (80,82),218)
			Result.put (new_pair (115,114),219)
			Result.put (new_pair (83,118),220)
			Result.put (new_pair (87,98),221)
			Result.put (new_triple (86,8725,109),222)
			Result.put (new_triple (65,8725,109),223)
			Result.put (new_pair (49,26085),224)
			Result.put (new_pair (50,26085),225)
			Result.put (new_pair (51,26085),226)
			Result.put (new_pair (52,26085),227)
			Result.put (new_pair (53,26085),228)
			Result.put (new_pair (54,26085),229)
			Result.put (new_pair (55,26085),230)
			Result.put (new_pair (56,26085),231)
			Result.put (new_pair (57,26085),232)
			Result.put (new_triple (49,48,26085),233)
			Result.put (new_triple (49,49,26085),234)
			Result.put (new_triple (49,50,26085),235)
			Result.put (new_triple (49,51,26085),236)
			Result.put (new_triple (49,52,26085),237)
			Result.put (new_triple (49,53,26085),238)
			Result.put (new_triple (49,54,26085),239)
			Result.put (new_triple (49,55,26085),240)
			Result.put (new_triple (49,56,26085),241)
			Result.put (new_triple (49,57,26085),242)
			Result.put (new_triple (50,48,26085),243)
			Result.put (new_triple (50,49,26085),244)
			Result.put (new_triple (50,50,26085),245)
			Result.put (new_triple (50,51,26085),246)
			Result.put (new_triple (50,52,26085),247)
			Result.put (new_triple (50,53,26085),248)
			Result.put (new_triple (50,54,26085),249)
			Result.put (new_triple (50,55,26085),250)
			Result.put (new_triple (50,56,26085),251)
			Result.put (new_triple (50,57,26085),252)
			Result.put (new_triple (51,48,26085),253)
			Result.put (new_triple (51,49,26085),254)
			Result.put (new_triple (103,97,108),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_167: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (42863),112)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_172: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (4352,4449),0)
			Result.put (new_triple (4352,4449,4520),1)
			Result.put (new_triple (4352,4449,4521),2)
			Result.put (new_triple (4352,4449,4522),3)
			Result.put (new_triple (4352,4449,4523),4)
			Result.put (new_triple (4352,4449,4524),5)
			Result.put (new_triple (4352,4449,4525),6)
			Result.put (new_triple (4352,4449,4526),7)
			Result.put (new_triple (4352,4449,4527),8)
			Result.put (new_triple (4352,4449,4528),9)
			Result.put (new_triple (4352,4449,4529),10)
			Result.put (new_triple (4352,4449,4530),11)
			Result.put (new_triple (4352,4449,4531),12)
			Result.put (new_triple (4352,4449,4532),13)
			Result.put (new_triple (4352,4449,4533),14)
			Result.put (new_triple (4352,4449,4534),15)
			Result.put (new_triple (4352,4449,4535),16)
			Result.put (new_triple (4352,4449,4536),17)
			Result.put (new_triple (4352,4449,4537),18)
			Result.put (new_triple (4352,4449,4538),19)
			Result.put (new_triple (4352,4449,4539),20)
			Result.put (new_triple (4352,4449,4540),21)
			Result.put (new_triple (4352,4449,4541),22)
			Result.put (new_triple (4352,4449,4542),23)
			Result.put (new_triple (4352,4449,4543),24)
			Result.put (new_triple (4352,4449,4544),25)
			Result.put (new_triple (4352,4449,4545),26)
			Result.put (new_triple (4352,4449,4546),27)
			Result.put (new_pair (4352,4450),28)
			Result.put (new_triple (4352,4450,4520),29)
			Result.put (new_triple (4352,4450,4521),30)
			Result.put (new_triple (4352,4450,4522),31)
			Result.put (new_triple (4352,4450,4523),32)
			Result.put (new_triple (4352,4450,4524),33)
			Result.put (new_triple (4352,4450,4525),34)
			Result.put (new_triple (4352,4450,4526),35)
			Result.put (new_triple (4352,4450,4527),36)
			Result.put (new_triple (4352,4450,4528),37)
			Result.put (new_triple (4352,4450,4529),38)
			Result.put (new_triple (4352,4450,4530),39)
			Result.put (new_triple (4352,4450,4531),40)
			Result.put (new_triple (4352,4450,4532),41)
			Result.put (new_triple (4352,4450,4533),42)
			Result.put (new_triple (4352,4450,4534),43)
			Result.put (new_triple (4352,4450,4535),44)
			Result.put (new_triple (4352,4450,4536),45)
			Result.put (new_triple (4352,4450,4537),46)
			Result.put (new_triple (4352,4450,4538),47)
			Result.put (new_triple (4352,4450,4539),48)
			Result.put (new_triple (4352,4450,4540),49)
			Result.put (new_triple (4352,4450,4541),50)
			Result.put (new_triple (4352,4450,4542),51)
			Result.put (new_triple (4352,4450,4543),52)
			Result.put (new_triple (4352,4450,4544),53)
			Result.put (new_triple (4352,4450,4545),54)
			Result.put (new_triple (4352,4450,4546),55)
			Result.put (new_pair (4352,4451),56)
			Result.put (new_triple (4352,4451,4520),57)
			Result.put (new_triple (4352,4451,4521),58)
			Result.put (new_triple (4352,4451,4522),59)
			Result.put (new_triple (4352,4451,4523),60)
			Result.put (new_triple (4352,4451,4524),61)
			Result.put (new_triple (4352,4451,4525),62)
			Result.put (new_triple (4352,4451,4526),63)
			Result.put (new_triple (4352,4451,4527),64)
			Result.put (new_triple (4352,4451,4528),65)
			Result.put (new_triple (4352,4451,4529),66)
			Result.put (new_triple (4352,4451,4530),67)
			Result.put (new_triple (4352,4451,4531),68)
			Result.put (new_triple (4352,4451,4532),69)
			Result.put (new_triple (4352,4451,4533),70)
			Result.put (new_triple (4352,4451,4534),71)
			Result.put (new_triple (4352,4451,4535),72)
			Result.put (new_triple (4352,4451,4536),73)
			Result.put (new_triple (4352,4451,4537),74)
			Result.put (new_triple (4352,4451,4538),75)
			Result.put (new_triple (4352,4451,4539),76)
			Result.put (new_triple (4352,4451,4540),77)
			Result.put (new_triple (4352,4451,4541),78)
			Result.put (new_triple (4352,4451,4542),79)
			Result.put (new_triple (4352,4451,4543),80)
			Result.put (new_triple (4352,4451,4544),81)
			Result.put (new_triple (4352,4451,4545),82)
			Result.put (new_triple (4352,4451,4546),83)
			Result.put (new_pair (4352,4452),84)
			Result.put (new_triple (4352,4452,4520),85)
			Result.put (new_triple (4352,4452,4521),86)
			Result.put (new_triple (4352,4452,4522),87)
			Result.put (new_triple (4352,4452,4523),88)
			Result.put (new_triple (4352,4452,4524),89)
			Result.put (new_triple (4352,4452,4525),90)
			Result.put (new_triple (4352,4452,4526),91)
			Result.put (new_triple (4352,4452,4527),92)
			Result.put (new_triple (4352,4452,4528),93)
			Result.put (new_triple (4352,4452,4529),94)
			Result.put (new_triple (4352,4452,4530),95)
			Result.put (new_triple (4352,4452,4531),96)
			Result.put (new_triple (4352,4452,4532),97)
			Result.put (new_triple (4352,4452,4533),98)
			Result.put (new_triple (4352,4452,4534),99)
			Result.put (new_triple (4352,4452,4535),100)
			Result.put (new_triple (4352,4452,4536),101)
			Result.put (new_triple (4352,4452,4537),102)
			Result.put (new_triple (4352,4452,4538),103)
			Result.put (new_triple (4352,4452,4539),104)
			Result.put (new_triple (4352,4452,4540),105)
			Result.put (new_triple (4352,4452,4541),106)
			Result.put (new_triple (4352,4452,4542),107)
			Result.put (new_triple (4352,4452,4543),108)
			Result.put (new_triple (4352,4452,4544),109)
			Result.put (new_triple (4352,4452,4545),110)
			Result.put (new_triple (4352,4452,4546),111)
			Result.put (new_pair (4352,4453),112)
			Result.put (new_triple (4352,4453,4520),113)
			Result.put (new_triple (4352,4453,4521),114)
			Result.put (new_triple (4352,4453,4522),115)
			Result.put (new_triple (4352,4453,4523),116)
			Result.put (new_triple (4352,4453,4524),117)
			Result.put (new_triple (4352,4453,4525),118)
			Result.put (new_triple (4352,4453,4526),119)
			Result.put (new_triple (4352,4453,4527),120)
			Result.put (new_triple (4352,4453,4528),121)
			Result.put (new_triple (4352,4453,4529),122)
			Result.put (new_triple (4352,4453,4530),123)
			Result.put (new_triple (4352,4453,4531),124)
			Result.put (new_triple (4352,4453,4532),125)
			Result.put (new_triple (4352,4453,4533),126)
			Result.put (new_triple (4352,4453,4534),127)
			Result.put (new_triple (4352,4453,4535),128)
			Result.put (new_triple (4352,4453,4536),129)
			Result.put (new_triple (4352,4453,4537),130)
			Result.put (new_triple (4352,4453,4538),131)
			Result.put (new_triple (4352,4453,4539),132)
			Result.put (new_triple (4352,4453,4540),133)
			Result.put (new_triple (4352,4453,4541),134)
			Result.put (new_triple (4352,4453,4542),135)
			Result.put (new_triple (4352,4453,4543),136)
			Result.put (new_triple (4352,4453,4544),137)
			Result.put (new_triple (4352,4453,4545),138)
			Result.put (new_triple (4352,4453,4546),139)
			Result.put (new_pair (4352,4454),140)
			Result.put (new_triple (4352,4454,4520),141)
			Result.put (new_triple (4352,4454,4521),142)
			Result.put (new_triple (4352,4454,4522),143)
			Result.put (new_triple (4352,4454,4523),144)
			Result.put (new_triple (4352,4454,4524),145)
			Result.put (new_triple (4352,4454,4525),146)
			Result.put (new_triple (4352,4454,4526),147)
			Result.put (new_triple (4352,4454,4527),148)
			Result.put (new_triple (4352,4454,4528),149)
			Result.put (new_triple (4352,4454,4529),150)
			Result.put (new_triple (4352,4454,4530),151)
			Result.put (new_triple (4352,4454,4531),152)
			Result.put (new_triple (4352,4454,4532),153)
			Result.put (new_triple (4352,4454,4533),154)
			Result.put (new_triple (4352,4454,4534),155)
			Result.put (new_triple (4352,4454,4535),156)
			Result.put (new_triple (4352,4454,4536),157)
			Result.put (new_triple (4352,4454,4537),158)
			Result.put (new_triple (4352,4454,4538),159)
			Result.put (new_triple (4352,4454,4539),160)
			Result.put (new_triple (4352,4454,4540),161)
			Result.put (new_triple (4352,4454,4541),162)
			Result.put (new_triple (4352,4454,4542),163)
			Result.put (new_triple (4352,4454,4543),164)
			Result.put (new_triple (4352,4454,4544),165)
			Result.put (new_triple (4352,4454,4545),166)
			Result.put (new_triple (4352,4454,4546),167)
			Result.put (new_pair (4352,4455),168)
			Result.put (new_triple (4352,4455,4520),169)
			Result.put (new_triple (4352,4455,4521),170)
			Result.put (new_triple (4352,4455,4522),171)
			Result.put (new_triple (4352,4455,4523),172)
			Result.put (new_triple (4352,4455,4524),173)
			Result.put (new_triple (4352,4455,4525),174)
			Result.put (new_triple (4352,4455,4526),175)
			Result.put (new_triple (4352,4455,4527),176)
			Result.put (new_triple (4352,4455,4528),177)
			Result.put (new_triple (4352,4455,4529),178)
			Result.put (new_triple (4352,4455,4530),179)
			Result.put (new_triple (4352,4455,4531),180)
			Result.put (new_triple (4352,4455,4532),181)
			Result.put (new_triple (4352,4455,4533),182)
			Result.put (new_triple (4352,4455,4534),183)
			Result.put (new_triple (4352,4455,4535),184)
			Result.put (new_triple (4352,4455,4536),185)
			Result.put (new_triple (4352,4455,4537),186)
			Result.put (new_triple (4352,4455,4538),187)
			Result.put (new_triple (4352,4455,4539),188)
			Result.put (new_triple (4352,4455,4540),189)
			Result.put (new_triple (4352,4455,4541),190)
			Result.put (new_triple (4352,4455,4542),191)
			Result.put (new_triple (4352,4455,4543),192)
			Result.put (new_triple (4352,4455,4544),193)
			Result.put (new_triple (4352,4455,4545),194)
			Result.put (new_triple (4352,4455,4546),195)
			Result.put (new_pair (4352,4456),196)
			Result.put (new_triple (4352,4456,4520),197)
			Result.put (new_triple (4352,4456,4521),198)
			Result.put (new_triple (4352,4456,4522),199)
			Result.put (new_triple (4352,4456,4523),200)
			Result.put (new_triple (4352,4456,4524),201)
			Result.put (new_triple (4352,4456,4525),202)
			Result.put (new_triple (4352,4456,4526),203)
			Result.put (new_triple (4352,4456,4527),204)
			Result.put (new_triple (4352,4456,4528),205)
			Result.put (new_triple (4352,4456,4529),206)
			Result.put (new_triple (4352,4456,4530),207)
			Result.put (new_triple (4352,4456,4531),208)
			Result.put (new_triple (4352,4456,4532),209)
			Result.put (new_triple (4352,4456,4533),210)
			Result.put (new_triple (4352,4456,4534),211)
			Result.put (new_triple (4352,4456,4535),212)
			Result.put (new_triple (4352,4456,4536),213)
			Result.put (new_triple (4352,4456,4537),214)
			Result.put (new_triple (4352,4456,4538),215)
			Result.put (new_triple (4352,4456,4539),216)
			Result.put (new_triple (4352,4456,4540),217)
			Result.put (new_triple (4352,4456,4541),218)
			Result.put (new_triple (4352,4456,4542),219)
			Result.put (new_triple (4352,4456,4543),220)
			Result.put (new_triple (4352,4456,4544),221)
			Result.put (new_triple (4352,4456,4545),222)
			Result.put (new_triple (4352,4456,4546),223)
			Result.put (new_pair (4352,4457),224)
			Result.put (new_triple (4352,4457,4520),225)
			Result.put (new_triple (4352,4457,4521),226)
			Result.put (new_triple (4352,4457,4522),227)
			Result.put (new_triple (4352,4457,4523),228)
			Result.put (new_triple (4352,4457,4524),229)
			Result.put (new_triple (4352,4457,4525),230)
			Result.put (new_triple (4352,4457,4526),231)
			Result.put (new_triple (4352,4457,4527),232)
			Result.put (new_triple (4352,4457,4528),233)
			Result.put (new_triple (4352,4457,4529),234)
			Result.put (new_triple (4352,4457,4530),235)
			Result.put (new_triple (4352,4457,4531),236)
			Result.put (new_triple (4352,4457,4532),237)
			Result.put (new_triple (4352,4457,4533),238)
			Result.put (new_triple (4352,4457,4534),239)
			Result.put (new_triple (4352,4457,4535),240)
			Result.put (new_triple (4352,4457,4536),241)
			Result.put (new_triple (4352,4457,4537),242)
			Result.put (new_triple (4352,4457,4538),243)
			Result.put (new_triple (4352,4457,4539),244)
			Result.put (new_triple (4352,4457,4540),245)
			Result.put (new_triple (4352,4457,4541),246)
			Result.put (new_triple (4352,4457,4542),247)
			Result.put (new_triple (4352,4457,4543),248)
			Result.put (new_triple (4352,4457,4544),249)
			Result.put (new_triple (4352,4457,4545),250)
			Result.put (new_triple (4352,4457,4546),251)
			Result.put (new_pair (4352,4458),252)
			Result.put (new_triple (4352,4458,4520),253)
			Result.put (new_triple (4352,4458,4521),254)
			Result.put (new_triple (4352,4458,4522),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_173: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4352,4458,4523),0)
			Result.put (new_triple (4352,4458,4524),1)
			Result.put (new_triple (4352,4458,4525),2)
			Result.put (new_triple (4352,4458,4526),3)
			Result.put (new_triple (4352,4458,4527),4)
			Result.put (new_triple (4352,4458,4528),5)
			Result.put (new_triple (4352,4458,4529),6)
			Result.put (new_triple (4352,4458,4530),7)
			Result.put (new_triple (4352,4458,4531),8)
			Result.put (new_triple (4352,4458,4532),9)
			Result.put (new_triple (4352,4458,4533),10)
			Result.put (new_triple (4352,4458,4534),11)
			Result.put (new_triple (4352,4458,4535),12)
			Result.put (new_triple (4352,4458,4536),13)
			Result.put (new_triple (4352,4458,4537),14)
			Result.put (new_triple (4352,4458,4538),15)
			Result.put (new_triple (4352,4458,4539),16)
			Result.put (new_triple (4352,4458,4540),17)
			Result.put (new_triple (4352,4458,4541),18)
			Result.put (new_triple (4352,4458,4542),19)
			Result.put (new_triple (4352,4458,4543),20)
			Result.put (new_triple (4352,4458,4544),21)
			Result.put (new_triple (4352,4458,4545),22)
			Result.put (new_triple (4352,4458,4546),23)
			Result.put (new_pair (4352,4459),24)
			Result.put (new_triple (4352,4459,4520),25)
			Result.put (new_triple (4352,4459,4521),26)
			Result.put (new_triple (4352,4459,4522),27)
			Result.put (new_triple (4352,4459,4523),28)
			Result.put (new_triple (4352,4459,4524),29)
			Result.put (new_triple (4352,4459,4525),30)
			Result.put (new_triple (4352,4459,4526),31)
			Result.put (new_triple (4352,4459,4527),32)
			Result.put (new_triple (4352,4459,4528),33)
			Result.put (new_triple (4352,4459,4529),34)
			Result.put (new_triple (4352,4459,4530),35)
			Result.put (new_triple (4352,4459,4531),36)
			Result.put (new_triple (4352,4459,4532),37)
			Result.put (new_triple (4352,4459,4533),38)
			Result.put (new_triple (4352,4459,4534),39)
			Result.put (new_triple (4352,4459,4535),40)
			Result.put (new_triple (4352,4459,4536),41)
			Result.put (new_triple (4352,4459,4537),42)
			Result.put (new_triple (4352,4459,4538),43)
			Result.put (new_triple (4352,4459,4539),44)
			Result.put (new_triple (4352,4459,4540),45)
			Result.put (new_triple (4352,4459,4541),46)
			Result.put (new_triple (4352,4459,4542),47)
			Result.put (new_triple (4352,4459,4543),48)
			Result.put (new_triple (4352,4459,4544),49)
			Result.put (new_triple (4352,4459,4545),50)
			Result.put (new_triple (4352,4459,4546),51)
			Result.put (new_pair (4352,4460),52)
			Result.put (new_triple (4352,4460,4520),53)
			Result.put (new_triple (4352,4460,4521),54)
			Result.put (new_triple (4352,4460,4522),55)
			Result.put (new_triple (4352,4460,4523),56)
			Result.put (new_triple (4352,4460,4524),57)
			Result.put (new_triple (4352,4460,4525),58)
			Result.put (new_triple (4352,4460,4526),59)
			Result.put (new_triple (4352,4460,4527),60)
			Result.put (new_triple (4352,4460,4528),61)
			Result.put (new_triple (4352,4460,4529),62)
			Result.put (new_triple (4352,4460,4530),63)
			Result.put (new_triple (4352,4460,4531),64)
			Result.put (new_triple (4352,4460,4532),65)
			Result.put (new_triple (4352,4460,4533),66)
			Result.put (new_triple (4352,4460,4534),67)
			Result.put (new_triple (4352,4460,4535),68)
			Result.put (new_triple (4352,4460,4536),69)
			Result.put (new_triple (4352,4460,4537),70)
			Result.put (new_triple (4352,4460,4538),71)
			Result.put (new_triple (4352,4460,4539),72)
			Result.put (new_triple (4352,4460,4540),73)
			Result.put (new_triple (4352,4460,4541),74)
			Result.put (new_triple (4352,4460,4542),75)
			Result.put (new_triple (4352,4460,4543),76)
			Result.put (new_triple (4352,4460,4544),77)
			Result.put (new_triple (4352,4460,4545),78)
			Result.put (new_triple (4352,4460,4546),79)
			Result.put (new_pair (4352,4461),80)
			Result.put (new_triple (4352,4461,4520),81)
			Result.put (new_triple (4352,4461,4521),82)
			Result.put (new_triple (4352,4461,4522),83)
			Result.put (new_triple (4352,4461,4523),84)
			Result.put (new_triple (4352,4461,4524),85)
			Result.put (new_triple (4352,4461,4525),86)
			Result.put (new_triple (4352,4461,4526),87)
			Result.put (new_triple (4352,4461,4527),88)
			Result.put (new_triple (4352,4461,4528),89)
			Result.put (new_triple (4352,4461,4529),90)
			Result.put (new_triple (4352,4461,4530),91)
			Result.put (new_triple (4352,4461,4531),92)
			Result.put (new_triple (4352,4461,4532),93)
			Result.put (new_triple (4352,4461,4533),94)
			Result.put (new_triple (4352,4461,4534),95)
			Result.put (new_triple (4352,4461,4535),96)
			Result.put (new_triple (4352,4461,4536),97)
			Result.put (new_triple (4352,4461,4537),98)
			Result.put (new_triple (4352,4461,4538),99)
			Result.put (new_triple (4352,4461,4539),100)
			Result.put (new_triple (4352,4461,4540),101)
			Result.put (new_triple (4352,4461,4541),102)
			Result.put (new_triple (4352,4461,4542),103)
			Result.put (new_triple (4352,4461,4543),104)
			Result.put (new_triple (4352,4461,4544),105)
			Result.put (new_triple (4352,4461,4545),106)
			Result.put (new_triple (4352,4461,4546),107)
			Result.put (new_pair (4352,4462),108)
			Result.put (new_triple (4352,4462,4520),109)
			Result.put (new_triple (4352,4462,4521),110)
			Result.put (new_triple (4352,4462,4522),111)
			Result.put (new_triple (4352,4462,4523),112)
			Result.put (new_triple (4352,4462,4524),113)
			Result.put (new_triple (4352,4462,4525),114)
			Result.put (new_triple (4352,4462,4526),115)
			Result.put (new_triple (4352,4462,4527),116)
			Result.put (new_triple (4352,4462,4528),117)
			Result.put (new_triple (4352,4462,4529),118)
			Result.put (new_triple (4352,4462,4530),119)
			Result.put (new_triple (4352,4462,4531),120)
			Result.put (new_triple (4352,4462,4532),121)
			Result.put (new_triple (4352,4462,4533),122)
			Result.put (new_triple (4352,4462,4534),123)
			Result.put (new_triple (4352,4462,4535),124)
			Result.put (new_triple (4352,4462,4536),125)
			Result.put (new_triple (4352,4462,4537),126)
			Result.put (new_triple (4352,4462,4538),127)
			Result.put (new_triple (4352,4462,4539),128)
			Result.put (new_triple (4352,4462,4540),129)
			Result.put (new_triple (4352,4462,4541),130)
			Result.put (new_triple (4352,4462,4542),131)
			Result.put (new_triple (4352,4462,4543),132)
			Result.put (new_triple (4352,4462,4544),133)
			Result.put (new_triple (4352,4462,4545),134)
			Result.put (new_triple (4352,4462,4546),135)
			Result.put (new_pair (4352,4463),136)
			Result.put (new_triple (4352,4463,4520),137)
			Result.put (new_triple (4352,4463,4521),138)
			Result.put (new_triple (4352,4463,4522),139)
			Result.put (new_triple (4352,4463,4523),140)
			Result.put (new_triple (4352,4463,4524),141)
			Result.put (new_triple (4352,4463,4525),142)
			Result.put (new_triple (4352,4463,4526),143)
			Result.put (new_triple (4352,4463,4527),144)
			Result.put (new_triple (4352,4463,4528),145)
			Result.put (new_triple (4352,4463,4529),146)
			Result.put (new_triple (4352,4463,4530),147)
			Result.put (new_triple (4352,4463,4531),148)
			Result.put (new_triple (4352,4463,4532),149)
			Result.put (new_triple (4352,4463,4533),150)
			Result.put (new_triple (4352,4463,4534),151)
			Result.put (new_triple (4352,4463,4535),152)
			Result.put (new_triple (4352,4463,4536),153)
			Result.put (new_triple (4352,4463,4537),154)
			Result.put (new_triple (4352,4463,4538),155)
			Result.put (new_triple (4352,4463,4539),156)
			Result.put (new_triple (4352,4463,4540),157)
			Result.put (new_triple (4352,4463,4541),158)
			Result.put (new_triple (4352,4463,4542),159)
			Result.put (new_triple (4352,4463,4543),160)
			Result.put (new_triple (4352,4463,4544),161)
			Result.put (new_triple (4352,4463,4545),162)
			Result.put (new_triple (4352,4463,4546),163)
			Result.put (new_pair (4352,4464),164)
			Result.put (new_triple (4352,4464,4520),165)
			Result.put (new_triple (4352,4464,4521),166)
			Result.put (new_triple (4352,4464,4522),167)
			Result.put (new_triple (4352,4464,4523),168)
			Result.put (new_triple (4352,4464,4524),169)
			Result.put (new_triple (4352,4464,4525),170)
			Result.put (new_triple (4352,4464,4526),171)
			Result.put (new_triple (4352,4464,4527),172)
			Result.put (new_triple (4352,4464,4528),173)
			Result.put (new_triple (4352,4464,4529),174)
			Result.put (new_triple (4352,4464,4530),175)
			Result.put (new_triple (4352,4464,4531),176)
			Result.put (new_triple (4352,4464,4532),177)
			Result.put (new_triple (4352,4464,4533),178)
			Result.put (new_triple (4352,4464,4534),179)
			Result.put (new_triple (4352,4464,4535),180)
			Result.put (new_triple (4352,4464,4536),181)
			Result.put (new_triple (4352,4464,4537),182)
			Result.put (new_triple (4352,4464,4538),183)
			Result.put (new_triple (4352,4464,4539),184)
			Result.put (new_triple (4352,4464,4540),185)
			Result.put (new_triple (4352,4464,4541),186)
			Result.put (new_triple (4352,4464,4542),187)
			Result.put (new_triple (4352,4464,4543),188)
			Result.put (new_triple (4352,4464,4544),189)
			Result.put (new_triple (4352,4464,4545),190)
			Result.put (new_triple (4352,4464,4546),191)
			Result.put (new_pair (4352,4465),192)
			Result.put (new_triple (4352,4465,4520),193)
			Result.put (new_triple (4352,4465,4521),194)
			Result.put (new_triple (4352,4465,4522),195)
			Result.put (new_triple (4352,4465,4523),196)
			Result.put (new_triple (4352,4465,4524),197)
			Result.put (new_triple (4352,4465,4525),198)
			Result.put (new_triple (4352,4465,4526),199)
			Result.put (new_triple (4352,4465,4527),200)
			Result.put (new_triple (4352,4465,4528),201)
			Result.put (new_triple (4352,4465,4529),202)
			Result.put (new_triple (4352,4465,4530),203)
			Result.put (new_triple (4352,4465,4531),204)
			Result.put (new_triple (4352,4465,4532),205)
			Result.put (new_triple (4352,4465,4533),206)
			Result.put (new_triple (4352,4465,4534),207)
			Result.put (new_triple (4352,4465,4535),208)
			Result.put (new_triple (4352,4465,4536),209)
			Result.put (new_triple (4352,4465,4537),210)
			Result.put (new_triple (4352,4465,4538),211)
			Result.put (new_triple (4352,4465,4539),212)
			Result.put (new_triple (4352,4465,4540),213)
			Result.put (new_triple (4352,4465,4541),214)
			Result.put (new_triple (4352,4465,4542),215)
			Result.put (new_triple (4352,4465,4543),216)
			Result.put (new_triple (4352,4465,4544),217)
			Result.put (new_triple (4352,4465,4545),218)
			Result.put (new_triple (4352,4465,4546),219)
			Result.put (new_pair (4352,4466),220)
			Result.put (new_triple (4352,4466,4520),221)
			Result.put (new_triple (4352,4466,4521),222)
			Result.put (new_triple (4352,4466,4522),223)
			Result.put (new_triple (4352,4466,4523),224)
			Result.put (new_triple (4352,4466,4524),225)
			Result.put (new_triple (4352,4466,4525),226)
			Result.put (new_triple (4352,4466,4526),227)
			Result.put (new_triple (4352,4466,4527),228)
			Result.put (new_triple (4352,4466,4528),229)
			Result.put (new_triple (4352,4466,4529),230)
			Result.put (new_triple (4352,4466,4530),231)
			Result.put (new_triple (4352,4466,4531),232)
			Result.put (new_triple (4352,4466,4532),233)
			Result.put (new_triple (4352,4466,4533),234)
			Result.put (new_triple (4352,4466,4534),235)
			Result.put (new_triple (4352,4466,4535),236)
			Result.put (new_triple (4352,4466,4536),237)
			Result.put (new_triple (4352,4466,4537),238)
			Result.put (new_triple (4352,4466,4538),239)
			Result.put (new_triple (4352,4466,4539),240)
			Result.put (new_triple (4352,4466,4540),241)
			Result.put (new_triple (4352,4466,4541),242)
			Result.put (new_triple (4352,4466,4542),243)
			Result.put (new_triple (4352,4466,4543),244)
			Result.put (new_triple (4352,4466,4544),245)
			Result.put (new_triple (4352,4466,4545),246)
			Result.put (new_triple (4352,4466,4546),247)
			Result.put (new_pair (4352,4467),248)
			Result.put (new_triple (4352,4467,4520),249)
			Result.put (new_triple (4352,4467,4521),250)
			Result.put (new_triple (4352,4467,4522),251)
			Result.put (new_triple (4352,4467,4523),252)
			Result.put (new_triple (4352,4467,4524),253)
			Result.put (new_triple (4352,4467,4525),254)
			Result.put (new_triple (4352,4467,4526),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_174: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4352,4467,4527),0)
			Result.put (new_triple (4352,4467,4528),1)
			Result.put (new_triple (4352,4467,4529),2)
			Result.put (new_triple (4352,4467,4530),3)
			Result.put (new_triple (4352,4467,4531),4)
			Result.put (new_triple (4352,4467,4532),5)
			Result.put (new_triple (4352,4467,4533),6)
			Result.put (new_triple (4352,4467,4534),7)
			Result.put (new_triple (4352,4467,4535),8)
			Result.put (new_triple (4352,4467,4536),9)
			Result.put (new_triple (4352,4467,4537),10)
			Result.put (new_triple (4352,4467,4538),11)
			Result.put (new_triple (4352,4467,4539),12)
			Result.put (new_triple (4352,4467,4540),13)
			Result.put (new_triple (4352,4467,4541),14)
			Result.put (new_triple (4352,4467,4542),15)
			Result.put (new_triple (4352,4467,4543),16)
			Result.put (new_triple (4352,4467,4544),17)
			Result.put (new_triple (4352,4467,4545),18)
			Result.put (new_triple (4352,4467,4546),19)
			Result.put (new_pair (4352,4468),20)
			Result.put (new_triple (4352,4468,4520),21)
			Result.put (new_triple (4352,4468,4521),22)
			Result.put (new_triple (4352,4468,4522),23)
			Result.put (new_triple (4352,4468,4523),24)
			Result.put (new_triple (4352,4468,4524),25)
			Result.put (new_triple (4352,4468,4525),26)
			Result.put (new_triple (4352,4468,4526),27)
			Result.put (new_triple (4352,4468,4527),28)
			Result.put (new_triple (4352,4468,4528),29)
			Result.put (new_triple (4352,4468,4529),30)
			Result.put (new_triple (4352,4468,4530),31)
			Result.put (new_triple (4352,4468,4531),32)
			Result.put (new_triple (4352,4468,4532),33)
			Result.put (new_triple (4352,4468,4533),34)
			Result.put (new_triple (4352,4468,4534),35)
			Result.put (new_triple (4352,4468,4535),36)
			Result.put (new_triple (4352,4468,4536),37)
			Result.put (new_triple (4352,4468,4537),38)
			Result.put (new_triple (4352,4468,4538),39)
			Result.put (new_triple (4352,4468,4539),40)
			Result.put (new_triple (4352,4468,4540),41)
			Result.put (new_triple (4352,4468,4541),42)
			Result.put (new_triple (4352,4468,4542),43)
			Result.put (new_triple (4352,4468,4543),44)
			Result.put (new_triple (4352,4468,4544),45)
			Result.put (new_triple (4352,4468,4545),46)
			Result.put (new_triple (4352,4468,4546),47)
			Result.put (new_pair (4352,4469),48)
			Result.put (new_triple (4352,4469,4520),49)
			Result.put (new_triple (4352,4469,4521),50)
			Result.put (new_triple (4352,4469,4522),51)
			Result.put (new_triple (4352,4469,4523),52)
			Result.put (new_triple (4352,4469,4524),53)
			Result.put (new_triple (4352,4469,4525),54)
			Result.put (new_triple (4352,4469,4526),55)
			Result.put (new_triple (4352,4469,4527),56)
			Result.put (new_triple (4352,4469,4528),57)
			Result.put (new_triple (4352,4469,4529),58)
			Result.put (new_triple (4352,4469,4530),59)
			Result.put (new_triple (4352,4469,4531),60)
			Result.put (new_triple (4352,4469,4532),61)
			Result.put (new_triple (4352,4469,4533),62)
			Result.put (new_triple (4352,4469,4534),63)
			Result.put (new_triple (4352,4469,4535),64)
			Result.put (new_triple (4352,4469,4536),65)
			Result.put (new_triple (4352,4469,4537),66)
			Result.put (new_triple (4352,4469,4538),67)
			Result.put (new_triple (4352,4469,4539),68)
			Result.put (new_triple (4352,4469,4540),69)
			Result.put (new_triple (4352,4469,4541),70)
			Result.put (new_triple (4352,4469,4542),71)
			Result.put (new_triple (4352,4469,4543),72)
			Result.put (new_triple (4352,4469,4544),73)
			Result.put (new_triple (4352,4469,4545),74)
			Result.put (new_triple (4352,4469,4546),75)
			Result.put (new_pair (4353,4449),76)
			Result.put (new_triple (4353,4449,4520),77)
			Result.put (new_triple (4353,4449,4521),78)
			Result.put (new_triple (4353,4449,4522),79)
			Result.put (new_triple (4353,4449,4523),80)
			Result.put (new_triple (4353,4449,4524),81)
			Result.put (new_triple (4353,4449,4525),82)
			Result.put (new_triple (4353,4449,4526),83)
			Result.put (new_triple (4353,4449,4527),84)
			Result.put (new_triple (4353,4449,4528),85)
			Result.put (new_triple (4353,4449,4529),86)
			Result.put (new_triple (4353,4449,4530),87)
			Result.put (new_triple (4353,4449,4531),88)
			Result.put (new_triple (4353,4449,4532),89)
			Result.put (new_triple (4353,4449,4533),90)
			Result.put (new_triple (4353,4449,4534),91)
			Result.put (new_triple (4353,4449,4535),92)
			Result.put (new_triple (4353,4449,4536),93)
			Result.put (new_triple (4353,4449,4537),94)
			Result.put (new_triple (4353,4449,4538),95)
			Result.put (new_triple (4353,4449,4539),96)
			Result.put (new_triple (4353,4449,4540),97)
			Result.put (new_triple (4353,4449,4541),98)
			Result.put (new_triple (4353,4449,4542),99)
			Result.put (new_triple (4353,4449,4543),100)
			Result.put (new_triple (4353,4449,4544),101)
			Result.put (new_triple (4353,4449,4545),102)
			Result.put (new_triple (4353,4449,4546),103)
			Result.put (new_pair (4353,4450),104)
			Result.put (new_triple (4353,4450,4520),105)
			Result.put (new_triple (4353,4450,4521),106)
			Result.put (new_triple (4353,4450,4522),107)
			Result.put (new_triple (4353,4450,4523),108)
			Result.put (new_triple (4353,4450,4524),109)
			Result.put (new_triple (4353,4450,4525),110)
			Result.put (new_triple (4353,4450,4526),111)
			Result.put (new_triple (4353,4450,4527),112)
			Result.put (new_triple (4353,4450,4528),113)
			Result.put (new_triple (4353,4450,4529),114)
			Result.put (new_triple (4353,4450,4530),115)
			Result.put (new_triple (4353,4450,4531),116)
			Result.put (new_triple (4353,4450,4532),117)
			Result.put (new_triple (4353,4450,4533),118)
			Result.put (new_triple (4353,4450,4534),119)
			Result.put (new_triple (4353,4450,4535),120)
			Result.put (new_triple (4353,4450,4536),121)
			Result.put (new_triple (4353,4450,4537),122)
			Result.put (new_triple (4353,4450,4538),123)
			Result.put (new_triple (4353,4450,4539),124)
			Result.put (new_triple (4353,4450,4540),125)
			Result.put (new_triple (4353,4450,4541),126)
			Result.put (new_triple (4353,4450,4542),127)
			Result.put (new_triple (4353,4450,4543),128)
			Result.put (new_triple (4353,4450,4544),129)
			Result.put (new_triple (4353,4450,4545),130)
			Result.put (new_triple (4353,4450,4546),131)
			Result.put (new_pair (4353,4451),132)
			Result.put (new_triple (4353,4451,4520),133)
			Result.put (new_triple (4353,4451,4521),134)
			Result.put (new_triple (4353,4451,4522),135)
			Result.put (new_triple (4353,4451,4523),136)
			Result.put (new_triple (4353,4451,4524),137)
			Result.put (new_triple (4353,4451,4525),138)
			Result.put (new_triple (4353,4451,4526),139)
			Result.put (new_triple (4353,4451,4527),140)
			Result.put (new_triple (4353,4451,4528),141)
			Result.put (new_triple (4353,4451,4529),142)
			Result.put (new_triple (4353,4451,4530),143)
			Result.put (new_triple (4353,4451,4531),144)
			Result.put (new_triple (4353,4451,4532),145)
			Result.put (new_triple (4353,4451,4533),146)
			Result.put (new_triple (4353,4451,4534),147)
			Result.put (new_triple (4353,4451,4535),148)
			Result.put (new_triple (4353,4451,4536),149)
			Result.put (new_triple (4353,4451,4537),150)
			Result.put (new_triple (4353,4451,4538),151)
			Result.put (new_triple (4353,4451,4539),152)
			Result.put (new_triple (4353,4451,4540),153)
			Result.put (new_triple (4353,4451,4541),154)
			Result.put (new_triple (4353,4451,4542),155)
			Result.put (new_triple (4353,4451,4543),156)
			Result.put (new_triple (4353,4451,4544),157)
			Result.put (new_triple (4353,4451,4545),158)
			Result.put (new_triple (4353,4451,4546),159)
			Result.put (new_pair (4353,4452),160)
			Result.put (new_triple (4353,4452,4520),161)
			Result.put (new_triple (4353,4452,4521),162)
			Result.put (new_triple (4353,4452,4522),163)
			Result.put (new_triple (4353,4452,4523),164)
			Result.put (new_triple (4353,4452,4524),165)
			Result.put (new_triple (4353,4452,4525),166)
			Result.put (new_triple (4353,4452,4526),167)
			Result.put (new_triple (4353,4452,4527),168)
			Result.put (new_triple (4353,4452,4528),169)
			Result.put (new_triple (4353,4452,4529),170)
			Result.put (new_triple (4353,4452,4530),171)
			Result.put (new_triple (4353,4452,4531),172)
			Result.put (new_triple (4353,4452,4532),173)
			Result.put (new_triple (4353,4452,4533),174)
			Result.put (new_triple (4353,4452,4534),175)
			Result.put (new_triple (4353,4452,4535),176)
			Result.put (new_triple (4353,4452,4536),177)
			Result.put (new_triple (4353,4452,4537),178)
			Result.put (new_triple (4353,4452,4538),179)
			Result.put (new_triple (4353,4452,4539),180)
			Result.put (new_triple (4353,4452,4540),181)
			Result.put (new_triple (4353,4452,4541),182)
			Result.put (new_triple (4353,4452,4542),183)
			Result.put (new_triple (4353,4452,4543),184)
			Result.put (new_triple (4353,4452,4544),185)
			Result.put (new_triple (4353,4452,4545),186)
			Result.put (new_triple (4353,4452,4546),187)
			Result.put (new_pair (4353,4453),188)
			Result.put (new_triple (4353,4453,4520),189)
			Result.put (new_triple (4353,4453,4521),190)
			Result.put (new_triple (4353,4453,4522),191)
			Result.put (new_triple (4353,4453,4523),192)
			Result.put (new_triple (4353,4453,4524),193)
			Result.put (new_triple (4353,4453,4525),194)
			Result.put (new_triple (4353,4453,4526),195)
			Result.put (new_triple (4353,4453,4527),196)
			Result.put (new_triple (4353,4453,4528),197)
			Result.put (new_triple (4353,4453,4529),198)
			Result.put (new_triple (4353,4453,4530),199)
			Result.put (new_triple (4353,4453,4531),200)
			Result.put (new_triple (4353,4453,4532),201)
			Result.put (new_triple (4353,4453,4533),202)
			Result.put (new_triple (4353,4453,4534),203)
			Result.put (new_triple (4353,4453,4535),204)
			Result.put (new_triple (4353,4453,4536),205)
			Result.put (new_triple (4353,4453,4537),206)
			Result.put (new_triple (4353,4453,4538),207)
			Result.put (new_triple (4353,4453,4539),208)
			Result.put (new_triple (4353,4453,4540),209)
			Result.put (new_triple (4353,4453,4541),210)
			Result.put (new_triple (4353,4453,4542),211)
			Result.put (new_triple (4353,4453,4543),212)
			Result.put (new_triple (4353,4453,4544),213)
			Result.put (new_triple (4353,4453,4545),214)
			Result.put (new_triple (4353,4453,4546),215)
			Result.put (new_pair (4353,4454),216)
			Result.put (new_triple (4353,4454,4520),217)
			Result.put (new_triple (4353,4454,4521),218)
			Result.put (new_triple (4353,4454,4522),219)
			Result.put (new_triple (4353,4454,4523),220)
			Result.put (new_triple (4353,4454,4524),221)
			Result.put (new_triple (4353,4454,4525),222)
			Result.put (new_triple (4353,4454,4526),223)
			Result.put (new_triple (4353,4454,4527),224)
			Result.put (new_triple (4353,4454,4528),225)
			Result.put (new_triple (4353,4454,4529),226)
			Result.put (new_triple (4353,4454,4530),227)
			Result.put (new_triple (4353,4454,4531),228)
			Result.put (new_triple (4353,4454,4532),229)
			Result.put (new_triple (4353,4454,4533),230)
			Result.put (new_triple (4353,4454,4534),231)
			Result.put (new_triple (4353,4454,4535),232)
			Result.put (new_triple (4353,4454,4536),233)
			Result.put (new_triple (4353,4454,4537),234)
			Result.put (new_triple (4353,4454,4538),235)
			Result.put (new_triple (4353,4454,4539),236)
			Result.put (new_triple (4353,4454,4540),237)
			Result.put (new_triple (4353,4454,4541),238)
			Result.put (new_triple (4353,4454,4542),239)
			Result.put (new_triple (4353,4454,4543),240)
			Result.put (new_triple (4353,4454,4544),241)
			Result.put (new_triple (4353,4454,4545),242)
			Result.put (new_triple (4353,4454,4546),243)
			Result.put (new_pair (4353,4455),244)
			Result.put (new_triple (4353,4455,4520),245)
			Result.put (new_triple (4353,4455,4521),246)
			Result.put (new_triple (4353,4455,4522),247)
			Result.put (new_triple (4353,4455,4523),248)
			Result.put (new_triple (4353,4455,4524),249)
			Result.put (new_triple (4353,4455,4525),250)
			Result.put (new_triple (4353,4455,4526),251)
			Result.put (new_triple (4353,4455,4527),252)
			Result.put (new_triple (4353,4455,4528),253)
			Result.put (new_triple (4353,4455,4529),254)
			Result.put (new_triple (4353,4455,4530),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_175: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4353,4455,4531),0)
			Result.put (new_triple (4353,4455,4532),1)
			Result.put (new_triple (4353,4455,4533),2)
			Result.put (new_triple (4353,4455,4534),3)
			Result.put (new_triple (4353,4455,4535),4)
			Result.put (new_triple (4353,4455,4536),5)
			Result.put (new_triple (4353,4455,4537),6)
			Result.put (new_triple (4353,4455,4538),7)
			Result.put (new_triple (4353,4455,4539),8)
			Result.put (new_triple (4353,4455,4540),9)
			Result.put (new_triple (4353,4455,4541),10)
			Result.put (new_triple (4353,4455,4542),11)
			Result.put (new_triple (4353,4455,4543),12)
			Result.put (new_triple (4353,4455,4544),13)
			Result.put (new_triple (4353,4455,4545),14)
			Result.put (new_triple (4353,4455,4546),15)
			Result.put (new_pair (4353,4456),16)
			Result.put (new_triple (4353,4456,4520),17)
			Result.put (new_triple (4353,4456,4521),18)
			Result.put (new_triple (4353,4456,4522),19)
			Result.put (new_triple (4353,4456,4523),20)
			Result.put (new_triple (4353,4456,4524),21)
			Result.put (new_triple (4353,4456,4525),22)
			Result.put (new_triple (4353,4456,4526),23)
			Result.put (new_triple (4353,4456,4527),24)
			Result.put (new_triple (4353,4456,4528),25)
			Result.put (new_triple (4353,4456,4529),26)
			Result.put (new_triple (4353,4456,4530),27)
			Result.put (new_triple (4353,4456,4531),28)
			Result.put (new_triple (4353,4456,4532),29)
			Result.put (new_triple (4353,4456,4533),30)
			Result.put (new_triple (4353,4456,4534),31)
			Result.put (new_triple (4353,4456,4535),32)
			Result.put (new_triple (4353,4456,4536),33)
			Result.put (new_triple (4353,4456,4537),34)
			Result.put (new_triple (4353,4456,4538),35)
			Result.put (new_triple (4353,4456,4539),36)
			Result.put (new_triple (4353,4456,4540),37)
			Result.put (new_triple (4353,4456,4541),38)
			Result.put (new_triple (4353,4456,4542),39)
			Result.put (new_triple (4353,4456,4543),40)
			Result.put (new_triple (4353,4456,4544),41)
			Result.put (new_triple (4353,4456,4545),42)
			Result.put (new_triple (4353,4456,4546),43)
			Result.put (new_pair (4353,4457),44)
			Result.put (new_triple (4353,4457,4520),45)
			Result.put (new_triple (4353,4457,4521),46)
			Result.put (new_triple (4353,4457,4522),47)
			Result.put (new_triple (4353,4457,4523),48)
			Result.put (new_triple (4353,4457,4524),49)
			Result.put (new_triple (4353,4457,4525),50)
			Result.put (new_triple (4353,4457,4526),51)
			Result.put (new_triple (4353,4457,4527),52)
			Result.put (new_triple (4353,4457,4528),53)
			Result.put (new_triple (4353,4457,4529),54)
			Result.put (new_triple (4353,4457,4530),55)
			Result.put (new_triple (4353,4457,4531),56)
			Result.put (new_triple (4353,4457,4532),57)
			Result.put (new_triple (4353,4457,4533),58)
			Result.put (new_triple (4353,4457,4534),59)
			Result.put (new_triple (4353,4457,4535),60)
			Result.put (new_triple (4353,4457,4536),61)
			Result.put (new_triple (4353,4457,4537),62)
			Result.put (new_triple (4353,4457,4538),63)
			Result.put (new_triple (4353,4457,4539),64)
			Result.put (new_triple (4353,4457,4540),65)
			Result.put (new_triple (4353,4457,4541),66)
			Result.put (new_triple (4353,4457,4542),67)
			Result.put (new_triple (4353,4457,4543),68)
			Result.put (new_triple (4353,4457,4544),69)
			Result.put (new_triple (4353,4457,4545),70)
			Result.put (new_triple (4353,4457,4546),71)
			Result.put (new_pair (4353,4458),72)
			Result.put (new_triple (4353,4458,4520),73)
			Result.put (new_triple (4353,4458,4521),74)
			Result.put (new_triple (4353,4458,4522),75)
			Result.put (new_triple (4353,4458,4523),76)
			Result.put (new_triple (4353,4458,4524),77)
			Result.put (new_triple (4353,4458,4525),78)
			Result.put (new_triple (4353,4458,4526),79)
			Result.put (new_triple (4353,4458,4527),80)
			Result.put (new_triple (4353,4458,4528),81)
			Result.put (new_triple (4353,4458,4529),82)
			Result.put (new_triple (4353,4458,4530),83)
			Result.put (new_triple (4353,4458,4531),84)
			Result.put (new_triple (4353,4458,4532),85)
			Result.put (new_triple (4353,4458,4533),86)
			Result.put (new_triple (4353,4458,4534),87)
			Result.put (new_triple (4353,4458,4535),88)
			Result.put (new_triple (4353,4458,4536),89)
			Result.put (new_triple (4353,4458,4537),90)
			Result.put (new_triple (4353,4458,4538),91)
			Result.put (new_triple (4353,4458,4539),92)
			Result.put (new_triple (4353,4458,4540),93)
			Result.put (new_triple (4353,4458,4541),94)
			Result.put (new_triple (4353,4458,4542),95)
			Result.put (new_triple (4353,4458,4543),96)
			Result.put (new_triple (4353,4458,4544),97)
			Result.put (new_triple (4353,4458,4545),98)
			Result.put (new_triple (4353,4458,4546),99)
			Result.put (new_pair (4353,4459),100)
			Result.put (new_triple (4353,4459,4520),101)
			Result.put (new_triple (4353,4459,4521),102)
			Result.put (new_triple (4353,4459,4522),103)
			Result.put (new_triple (4353,4459,4523),104)
			Result.put (new_triple (4353,4459,4524),105)
			Result.put (new_triple (4353,4459,4525),106)
			Result.put (new_triple (4353,4459,4526),107)
			Result.put (new_triple (4353,4459,4527),108)
			Result.put (new_triple (4353,4459,4528),109)
			Result.put (new_triple (4353,4459,4529),110)
			Result.put (new_triple (4353,4459,4530),111)
			Result.put (new_triple (4353,4459,4531),112)
			Result.put (new_triple (4353,4459,4532),113)
			Result.put (new_triple (4353,4459,4533),114)
			Result.put (new_triple (4353,4459,4534),115)
			Result.put (new_triple (4353,4459,4535),116)
			Result.put (new_triple (4353,4459,4536),117)
			Result.put (new_triple (4353,4459,4537),118)
			Result.put (new_triple (4353,4459,4538),119)
			Result.put (new_triple (4353,4459,4539),120)
			Result.put (new_triple (4353,4459,4540),121)
			Result.put (new_triple (4353,4459,4541),122)
			Result.put (new_triple (4353,4459,4542),123)
			Result.put (new_triple (4353,4459,4543),124)
			Result.put (new_triple (4353,4459,4544),125)
			Result.put (new_triple (4353,4459,4545),126)
			Result.put (new_triple (4353,4459,4546),127)
			Result.put (new_pair (4353,4460),128)
			Result.put (new_triple (4353,4460,4520),129)
			Result.put (new_triple (4353,4460,4521),130)
			Result.put (new_triple (4353,4460,4522),131)
			Result.put (new_triple (4353,4460,4523),132)
			Result.put (new_triple (4353,4460,4524),133)
			Result.put (new_triple (4353,4460,4525),134)
			Result.put (new_triple (4353,4460,4526),135)
			Result.put (new_triple (4353,4460,4527),136)
			Result.put (new_triple (4353,4460,4528),137)
			Result.put (new_triple (4353,4460,4529),138)
			Result.put (new_triple (4353,4460,4530),139)
			Result.put (new_triple (4353,4460,4531),140)
			Result.put (new_triple (4353,4460,4532),141)
			Result.put (new_triple (4353,4460,4533),142)
			Result.put (new_triple (4353,4460,4534),143)
			Result.put (new_triple (4353,4460,4535),144)
			Result.put (new_triple (4353,4460,4536),145)
			Result.put (new_triple (4353,4460,4537),146)
			Result.put (new_triple (4353,4460,4538),147)
			Result.put (new_triple (4353,4460,4539),148)
			Result.put (new_triple (4353,4460,4540),149)
			Result.put (new_triple (4353,4460,4541),150)
			Result.put (new_triple (4353,4460,4542),151)
			Result.put (new_triple (4353,4460,4543),152)
			Result.put (new_triple (4353,4460,4544),153)
			Result.put (new_triple (4353,4460,4545),154)
			Result.put (new_triple (4353,4460,4546),155)
			Result.put (new_pair (4353,4461),156)
			Result.put (new_triple (4353,4461,4520),157)
			Result.put (new_triple (4353,4461,4521),158)
			Result.put (new_triple (4353,4461,4522),159)
			Result.put (new_triple (4353,4461,4523),160)
			Result.put (new_triple (4353,4461,4524),161)
			Result.put (new_triple (4353,4461,4525),162)
			Result.put (new_triple (4353,4461,4526),163)
			Result.put (new_triple (4353,4461,4527),164)
			Result.put (new_triple (4353,4461,4528),165)
			Result.put (new_triple (4353,4461,4529),166)
			Result.put (new_triple (4353,4461,4530),167)
			Result.put (new_triple (4353,4461,4531),168)
			Result.put (new_triple (4353,4461,4532),169)
			Result.put (new_triple (4353,4461,4533),170)
			Result.put (new_triple (4353,4461,4534),171)
			Result.put (new_triple (4353,4461,4535),172)
			Result.put (new_triple (4353,4461,4536),173)
			Result.put (new_triple (4353,4461,4537),174)
			Result.put (new_triple (4353,4461,4538),175)
			Result.put (new_triple (4353,4461,4539),176)
			Result.put (new_triple (4353,4461,4540),177)
			Result.put (new_triple (4353,4461,4541),178)
			Result.put (new_triple (4353,4461,4542),179)
			Result.put (new_triple (4353,4461,4543),180)
			Result.put (new_triple (4353,4461,4544),181)
			Result.put (new_triple (4353,4461,4545),182)
			Result.put (new_triple (4353,4461,4546),183)
			Result.put (new_pair (4353,4462),184)
			Result.put (new_triple (4353,4462,4520),185)
			Result.put (new_triple (4353,4462,4521),186)
			Result.put (new_triple (4353,4462,4522),187)
			Result.put (new_triple (4353,4462,4523),188)
			Result.put (new_triple (4353,4462,4524),189)
			Result.put (new_triple (4353,4462,4525),190)
			Result.put (new_triple (4353,4462,4526),191)
			Result.put (new_triple (4353,4462,4527),192)
			Result.put (new_triple (4353,4462,4528),193)
			Result.put (new_triple (4353,4462,4529),194)
			Result.put (new_triple (4353,4462,4530),195)
			Result.put (new_triple (4353,4462,4531),196)
			Result.put (new_triple (4353,4462,4532),197)
			Result.put (new_triple (4353,4462,4533),198)
			Result.put (new_triple (4353,4462,4534),199)
			Result.put (new_triple (4353,4462,4535),200)
			Result.put (new_triple (4353,4462,4536),201)
			Result.put (new_triple (4353,4462,4537),202)
			Result.put (new_triple (4353,4462,4538),203)
			Result.put (new_triple (4353,4462,4539),204)
			Result.put (new_triple (4353,4462,4540),205)
			Result.put (new_triple (4353,4462,4541),206)
			Result.put (new_triple (4353,4462,4542),207)
			Result.put (new_triple (4353,4462,4543),208)
			Result.put (new_triple (4353,4462,4544),209)
			Result.put (new_triple (4353,4462,4545),210)
			Result.put (new_triple (4353,4462,4546),211)
			Result.put (new_pair (4353,4463),212)
			Result.put (new_triple (4353,4463,4520),213)
			Result.put (new_triple (4353,4463,4521),214)
			Result.put (new_triple (4353,4463,4522),215)
			Result.put (new_triple (4353,4463,4523),216)
			Result.put (new_triple (4353,4463,4524),217)
			Result.put (new_triple (4353,4463,4525),218)
			Result.put (new_triple (4353,4463,4526),219)
			Result.put (new_triple (4353,4463,4527),220)
			Result.put (new_triple (4353,4463,4528),221)
			Result.put (new_triple (4353,4463,4529),222)
			Result.put (new_triple (4353,4463,4530),223)
			Result.put (new_triple (4353,4463,4531),224)
			Result.put (new_triple (4353,4463,4532),225)
			Result.put (new_triple (4353,4463,4533),226)
			Result.put (new_triple (4353,4463,4534),227)
			Result.put (new_triple (4353,4463,4535),228)
			Result.put (new_triple (4353,4463,4536),229)
			Result.put (new_triple (4353,4463,4537),230)
			Result.put (new_triple (4353,4463,4538),231)
			Result.put (new_triple (4353,4463,4539),232)
			Result.put (new_triple (4353,4463,4540),233)
			Result.put (new_triple (4353,4463,4541),234)
			Result.put (new_triple (4353,4463,4542),235)
			Result.put (new_triple (4353,4463,4543),236)
			Result.put (new_triple (4353,4463,4544),237)
			Result.put (new_triple (4353,4463,4545),238)
			Result.put (new_triple (4353,4463,4546),239)
			Result.put (new_pair (4353,4464),240)
			Result.put (new_triple (4353,4464,4520),241)
			Result.put (new_triple (4353,4464,4521),242)
			Result.put (new_triple (4353,4464,4522),243)
			Result.put (new_triple (4353,4464,4523),244)
			Result.put (new_triple (4353,4464,4524),245)
			Result.put (new_triple (4353,4464,4525),246)
			Result.put (new_triple (4353,4464,4526),247)
			Result.put (new_triple (4353,4464,4527),248)
			Result.put (new_triple (4353,4464,4528),249)
			Result.put (new_triple (4353,4464,4529),250)
			Result.put (new_triple (4353,4464,4530),251)
			Result.put (new_triple (4353,4464,4531),252)
			Result.put (new_triple (4353,4464,4532),253)
			Result.put (new_triple (4353,4464,4533),254)
			Result.put (new_triple (4353,4464,4534),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_176: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4353,4464,4535),0)
			Result.put (new_triple (4353,4464,4536),1)
			Result.put (new_triple (4353,4464,4537),2)
			Result.put (new_triple (4353,4464,4538),3)
			Result.put (new_triple (4353,4464,4539),4)
			Result.put (new_triple (4353,4464,4540),5)
			Result.put (new_triple (4353,4464,4541),6)
			Result.put (new_triple (4353,4464,4542),7)
			Result.put (new_triple (4353,4464,4543),8)
			Result.put (new_triple (4353,4464,4544),9)
			Result.put (new_triple (4353,4464,4545),10)
			Result.put (new_triple (4353,4464,4546),11)
			Result.put (new_pair (4353,4465),12)
			Result.put (new_triple (4353,4465,4520),13)
			Result.put (new_triple (4353,4465,4521),14)
			Result.put (new_triple (4353,4465,4522),15)
			Result.put (new_triple (4353,4465,4523),16)
			Result.put (new_triple (4353,4465,4524),17)
			Result.put (new_triple (4353,4465,4525),18)
			Result.put (new_triple (4353,4465,4526),19)
			Result.put (new_triple (4353,4465,4527),20)
			Result.put (new_triple (4353,4465,4528),21)
			Result.put (new_triple (4353,4465,4529),22)
			Result.put (new_triple (4353,4465,4530),23)
			Result.put (new_triple (4353,4465,4531),24)
			Result.put (new_triple (4353,4465,4532),25)
			Result.put (new_triple (4353,4465,4533),26)
			Result.put (new_triple (4353,4465,4534),27)
			Result.put (new_triple (4353,4465,4535),28)
			Result.put (new_triple (4353,4465,4536),29)
			Result.put (new_triple (4353,4465,4537),30)
			Result.put (new_triple (4353,4465,4538),31)
			Result.put (new_triple (4353,4465,4539),32)
			Result.put (new_triple (4353,4465,4540),33)
			Result.put (new_triple (4353,4465,4541),34)
			Result.put (new_triple (4353,4465,4542),35)
			Result.put (new_triple (4353,4465,4543),36)
			Result.put (new_triple (4353,4465,4544),37)
			Result.put (new_triple (4353,4465,4545),38)
			Result.put (new_triple (4353,4465,4546),39)
			Result.put (new_pair (4353,4466),40)
			Result.put (new_triple (4353,4466,4520),41)
			Result.put (new_triple (4353,4466,4521),42)
			Result.put (new_triple (4353,4466,4522),43)
			Result.put (new_triple (4353,4466,4523),44)
			Result.put (new_triple (4353,4466,4524),45)
			Result.put (new_triple (4353,4466,4525),46)
			Result.put (new_triple (4353,4466,4526),47)
			Result.put (new_triple (4353,4466,4527),48)
			Result.put (new_triple (4353,4466,4528),49)
			Result.put (new_triple (4353,4466,4529),50)
			Result.put (new_triple (4353,4466,4530),51)
			Result.put (new_triple (4353,4466,4531),52)
			Result.put (new_triple (4353,4466,4532),53)
			Result.put (new_triple (4353,4466,4533),54)
			Result.put (new_triple (4353,4466,4534),55)
			Result.put (new_triple (4353,4466,4535),56)
			Result.put (new_triple (4353,4466,4536),57)
			Result.put (new_triple (4353,4466,4537),58)
			Result.put (new_triple (4353,4466,4538),59)
			Result.put (new_triple (4353,4466,4539),60)
			Result.put (new_triple (4353,4466,4540),61)
			Result.put (new_triple (4353,4466,4541),62)
			Result.put (new_triple (4353,4466,4542),63)
			Result.put (new_triple (4353,4466,4543),64)
			Result.put (new_triple (4353,4466,4544),65)
			Result.put (new_triple (4353,4466,4545),66)
			Result.put (new_triple (4353,4466,4546),67)
			Result.put (new_pair (4353,4467),68)
			Result.put (new_triple (4353,4467,4520),69)
			Result.put (new_triple (4353,4467,4521),70)
			Result.put (new_triple (4353,4467,4522),71)
			Result.put (new_triple (4353,4467,4523),72)
			Result.put (new_triple (4353,4467,4524),73)
			Result.put (new_triple (4353,4467,4525),74)
			Result.put (new_triple (4353,4467,4526),75)
			Result.put (new_triple (4353,4467,4527),76)
			Result.put (new_triple (4353,4467,4528),77)
			Result.put (new_triple (4353,4467,4529),78)
			Result.put (new_triple (4353,4467,4530),79)
			Result.put (new_triple (4353,4467,4531),80)
			Result.put (new_triple (4353,4467,4532),81)
			Result.put (new_triple (4353,4467,4533),82)
			Result.put (new_triple (4353,4467,4534),83)
			Result.put (new_triple (4353,4467,4535),84)
			Result.put (new_triple (4353,4467,4536),85)
			Result.put (new_triple (4353,4467,4537),86)
			Result.put (new_triple (4353,4467,4538),87)
			Result.put (new_triple (4353,4467,4539),88)
			Result.put (new_triple (4353,4467,4540),89)
			Result.put (new_triple (4353,4467,4541),90)
			Result.put (new_triple (4353,4467,4542),91)
			Result.put (new_triple (4353,4467,4543),92)
			Result.put (new_triple (4353,4467,4544),93)
			Result.put (new_triple (4353,4467,4545),94)
			Result.put (new_triple (4353,4467,4546),95)
			Result.put (new_pair (4353,4468),96)
			Result.put (new_triple (4353,4468,4520),97)
			Result.put (new_triple (4353,4468,4521),98)
			Result.put (new_triple (4353,4468,4522),99)
			Result.put (new_triple (4353,4468,4523),100)
			Result.put (new_triple (4353,4468,4524),101)
			Result.put (new_triple (4353,4468,4525),102)
			Result.put (new_triple (4353,4468,4526),103)
			Result.put (new_triple (4353,4468,4527),104)
			Result.put (new_triple (4353,4468,4528),105)
			Result.put (new_triple (4353,4468,4529),106)
			Result.put (new_triple (4353,4468,4530),107)
			Result.put (new_triple (4353,4468,4531),108)
			Result.put (new_triple (4353,4468,4532),109)
			Result.put (new_triple (4353,4468,4533),110)
			Result.put (new_triple (4353,4468,4534),111)
			Result.put (new_triple (4353,4468,4535),112)
			Result.put (new_triple (4353,4468,4536),113)
			Result.put (new_triple (4353,4468,4537),114)
			Result.put (new_triple (4353,4468,4538),115)
			Result.put (new_triple (4353,4468,4539),116)
			Result.put (new_triple (4353,4468,4540),117)
			Result.put (new_triple (4353,4468,4541),118)
			Result.put (new_triple (4353,4468,4542),119)
			Result.put (new_triple (4353,4468,4543),120)
			Result.put (new_triple (4353,4468,4544),121)
			Result.put (new_triple (4353,4468,4545),122)
			Result.put (new_triple (4353,4468,4546),123)
			Result.put (new_pair (4353,4469),124)
			Result.put (new_triple (4353,4469,4520),125)
			Result.put (new_triple (4353,4469,4521),126)
			Result.put (new_triple (4353,4469,4522),127)
			Result.put (new_triple (4353,4469,4523),128)
			Result.put (new_triple (4353,4469,4524),129)
			Result.put (new_triple (4353,4469,4525),130)
			Result.put (new_triple (4353,4469,4526),131)
			Result.put (new_triple (4353,4469,4527),132)
			Result.put (new_triple (4353,4469,4528),133)
			Result.put (new_triple (4353,4469,4529),134)
			Result.put (new_triple (4353,4469,4530),135)
			Result.put (new_triple (4353,4469,4531),136)
			Result.put (new_triple (4353,4469,4532),137)
			Result.put (new_triple (4353,4469,4533),138)
			Result.put (new_triple (4353,4469,4534),139)
			Result.put (new_triple (4353,4469,4535),140)
			Result.put (new_triple (4353,4469,4536),141)
			Result.put (new_triple (4353,4469,4537),142)
			Result.put (new_triple (4353,4469,4538),143)
			Result.put (new_triple (4353,4469,4539),144)
			Result.put (new_triple (4353,4469,4540),145)
			Result.put (new_triple (4353,4469,4541),146)
			Result.put (new_triple (4353,4469,4542),147)
			Result.put (new_triple (4353,4469,4543),148)
			Result.put (new_triple (4353,4469,4544),149)
			Result.put (new_triple (4353,4469,4545),150)
			Result.put (new_triple (4353,4469,4546),151)
			Result.put (new_pair (4354,4449),152)
			Result.put (new_triple (4354,4449,4520),153)
			Result.put (new_triple (4354,4449,4521),154)
			Result.put (new_triple (4354,4449,4522),155)
			Result.put (new_triple (4354,4449,4523),156)
			Result.put (new_triple (4354,4449,4524),157)
			Result.put (new_triple (4354,4449,4525),158)
			Result.put (new_triple (4354,4449,4526),159)
			Result.put (new_triple (4354,4449,4527),160)
			Result.put (new_triple (4354,4449,4528),161)
			Result.put (new_triple (4354,4449,4529),162)
			Result.put (new_triple (4354,4449,4530),163)
			Result.put (new_triple (4354,4449,4531),164)
			Result.put (new_triple (4354,4449,4532),165)
			Result.put (new_triple (4354,4449,4533),166)
			Result.put (new_triple (4354,4449,4534),167)
			Result.put (new_triple (4354,4449,4535),168)
			Result.put (new_triple (4354,4449,4536),169)
			Result.put (new_triple (4354,4449,4537),170)
			Result.put (new_triple (4354,4449,4538),171)
			Result.put (new_triple (4354,4449,4539),172)
			Result.put (new_triple (4354,4449,4540),173)
			Result.put (new_triple (4354,4449,4541),174)
			Result.put (new_triple (4354,4449,4542),175)
			Result.put (new_triple (4354,4449,4543),176)
			Result.put (new_triple (4354,4449,4544),177)
			Result.put (new_triple (4354,4449,4545),178)
			Result.put (new_triple (4354,4449,4546),179)
			Result.put (new_pair (4354,4450),180)
			Result.put (new_triple (4354,4450,4520),181)
			Result.put (new_triple (4354,4450,4521),182)
			Result.put (new_triple (4354,4450,4522),183)
			Result.put (new_triple (4354,4450,4523),184)
			Result.put (new_triple (4354,4450,4524),185)
			Result.put (new_triple (4354,4450,4525),186)
			Result.put (new_triple (4354,4450,4526),187)
			Result.put (new_triple (4354,4450,4527),188)
			Result.put (new_triple (4354,4450,4528),189)
			Result.put (new_triple (4354,4450,4529),190)
			Result.put (new_triple (4354,4450,4530),191)
			Result.put (new_triple (4354,4450,4531),192)
			Result.put (new_triple (4354,4450,4532),193)
			Result.put (new_triple (4354,4450,4533),194)
			Result.put (new_triple (4354,4450,4534),195)
			Result.put (new_triple (4354,4450,4535),196)
			Result.put (new_triple (4354,4450,4536),197)
			Result.put (new_triple (4354,4450,4537),198)
			Result.put (new_triple (4354,4450,4538),199)
			Result.put (new_triple (4354,4450,4539),200)
			Result.put (new_triple (4354,4450,4540),201)
			Result.put (new_triple (4354,4450,4541),202)
			Result.put (new_triple (4354,4450,4542),203)
			Result.put (new_triple (4354,4450,4543),204)
			Result.put (new_triple (4354,4450,4544),205)
			Result.put (new_triple (4354,4450,4545),206)
			Result.put (new_triple (4354,4450,4546),207)
			Result.put (new_pair (4354,4451),208)
			Result.put (new_triple (4354,4451,4520),209)
			Result.put (new_triple (4354,4451,4521),210)
			Result.put (new_triple (4354,4451,4522),211)
			Result.put (new_triple (4354,4451,4523),212)
			Result.put (new_triple (4354,4451,4524),213)
			Result.put (new_triple (4354,4451,4525),214)
			Result.put (new_triple (4354,4451,4526),215)
			Result.put (new_triple (4354,4451,4527),216)
			Result.put (new_triple (4354,4451,4528),217)
			Result.put (new_triple (4354,4451,4529),218)
			Result.put (new_triple (4354,4451,4530),219)
			Result.put (new_triple (4354,4451,4531),220)
			Result.put (new_triple (4354,4451,4532),221)
			Result.put (new_triple (4354,4451,4533),222)
			Result.put (new_triple (4354,4451,4534),223)
			Result.put (new_triple (4354,4451,4535),224)
			Result.put (new_triple (4354,4451,4536),225)
			Result.put (new_triple (4354,4451,4537),226)
			Result.put (new_triple (4354,4451,4538),227)
			Result.put (new_triple (4354,4451,4539),228)
			Result.put (new_triple (4354,4451,4540),229)
			Result.put (new_triple (4354,4451,4541),230)
			Result.put (new_triple (4354,4451,4542),231)
			Result.put (new_triple (4354,4451,4543),232)
			Result.put (new_triple (4354,4451,4544),233)
			Result.put (new_triple (4354,4451,4545),234)
			Result.put (new_triple (4354,4451,4546),235)
			Result.put (new_pair (4354,4452),236)
			Result.put (new_triple (4354,4452,4520),237)
			Result.put (new_triple (4354,4452,4521),238)
			Result.put (new_triple (4354,4452,4522),239)
			Result.put (new_triple (4354,4452,4523),240)
			Result.put (new_triple (4354,4452,4524),241)
			Result.put (new_triple (4354,4452,4525),242)
			Result.put (new_triple (4354,4452,4526),243)
			Result.put (new_triple (4354,4452,4527),244)
			Result.put (new_triple (4354,4452,4528),245)
			Result.put (new_triple (4354,4452,4529),246)
			Result.put (new_triple (4354,4452,4530),247)
			Result.put (new_triple (4354,4452,4531),248)
			Result.put (new_triple (4354,4452,4532),249)
			Result.put (new_triple (4354,4452,4533),250)
			Result.put (new_triple (4354,4452,4534),251)
			Result.put (new_triple (4354,4452,4535),252)
			Result.put (new_triple (4354,4452,4536),253)
			Result.put (new_triple (4354,4452,4537),254)
			Result.put (new_triple (4354,4452,4538),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_177: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4354,4452,4539),0)
			Result.put (new_triple (4354,4452,4540),1)
			Result.put (new_triple (4354,4452,4541),2)
			Result.put (new_triple (4354,4452,4542),3)
			Result.put (new_triple (4354,4452,4543),4)
			Result.put (new_triple (4354,4452,4544),5)
			Result.put (new_triple (4354,4452,4545),6)
			Result.put (new_triple (4354,4452,4546),7)
			Result.put (new_pair (4354,4453),8)
			Result.put (new_triple (4354,4453,4520),9)
			Result.put (new_triple (4354,4453,4521),10)
			Result.put (new_triple (4354,4453,4522),11)
			Result.put (new_triple (4354,4453,4523),12)
			Result.put (new_triple (4354,4453,4524),13)
			Result.put (new_triple (4354,4453,4525),14)
			Result.put (new_triple (4354,4453,4526),15)
			Result.put (new_triple (4354,4453,4527),16)
			Result.put (new_triple (4354,4453,4528),17)
			Result.put (new_triple (4354,4453,4529),18)
			Result.put (new_triple (4354,4453,4530),19)
			Result.put (new_triple (4354,4453,4531),20)
			Result.put (new_triple (4354,4453,4532),21)
			Result.put (new_triple (4354,4453,4533),22)
			Result.put (new_triple (4354,4453,4534),23)
			Result.put (new_triple (4354,4453,4535),24)
			Result.put (new_triple (4354,4453,4536),25)
			Result.put (new_triple (4354,4453,4537),26)
			Result.put (new_triple (4354,4453,4538),27)
			Result.put (new_triple (4354,4453,4539),28)
			Result.put (new_triple (4354,4453,4540),29)
			Result.put (new_triple (4354,4453,4541),30)
			Result.put (new_triple (4354,4453,4542),31)
			Result.put (new_triple (4354,4453,4543),32)
			Result.put (new_triple (4354,4453,4544),33)
			Result.put (new_triple (4354,4453,4545),34)
			Result.put (new_triple (4354,4453,4546),35)
			Result.put (new_pair (4354,4454),36)
			Result.put (new_triple (4354,4454,4520),37)
			Result.put (new_triple (4354,4454,4521),38)
			Result.put (new_triple (4354,4454,4522),39)
			Result.put (new_triple (4354,4454,4523),40)
			Result.put (new_triple (4354,4454,4524),41)
			Result.put (new_triple (4354,4454,4525),42)
			Result.put (new_triple (4354,4454,4526),43)
			Result.put (new_triple (4354,4454,4527),44)
			Result.put (new_triple (4354,4454,4528),45)
			Result.put (new_triple (4354,4454,4529),46)
			Result.put (new_triple (4354,4454,4530),47)
			Result.put (new_triple (4354,4454,4531),48)
			Result.put (new_triple (4354,4454,4532),49)
			Result.put (new_triple (4354,4454,4533),50)
			Result.put (new_triple (4354,4454,4534),51)
			Result.put (new_triple (4354,4454,4535),52)
			Result.put (new_triple (4354,4454,4536),53)
			Result.put (new_triple (4354,4454,4537),54)
			Result.put (new_triple (4354,4454,4538),55)
			Result.put (new_triple (4354,4454,4539),56)
			Result.put (new_triple (4354,4454,4540),57)
			Result.put (new_triple (4354,4454,4541),58)
			Result.put (new_triple (4354,4454,4542),59)
			Result.put (new_triple (4354,4454,4543),60)
			Result.put (new_triple (4354,4454,4544),61)
			Result.put (new_triple (4354,4454,4545),62)
			Result.put (new_triple (4354,4454,4546),63)
			Result.put (new_pair (4354,4455),64)
			Result.put (new_triple (4354,4455,4520),65)
			Result.put (new_triple (4354,4455,4521),66)
			Result.put (new_triple (4354,4455,4522),67)
			Result.put (new_triple (4354,4455,4523),68)
			Result.put (new_triple (4354,4455,4524),69)
			Result.put (new_triple (4354,4455,4525),70)
			Result.put (new_triple (4354,4455,4526),71)
			Result.put (new_triple (4354,4455,4527),72)
			Result.put (new_triple (4354,4455,4528),73)
			Result.put (new_triple (4354,4455,4529),74)
			Result.put (new_triple (4354,4455,4530),75)
			Result.put (new_triple (4354,4455,4531),76)
			Result.put (new_triple (4354,4455,4532),77)
			Result.put (new_triple (4354,4455,4533),78)
			Result.put (new_triple (4354,4455,4534),79)
			Result.put (new_triple (4354,4455,4535),80)
			Result.put (new_triple (4354,4455,4536),81)
			Result.put (new_triple (4354,4455,4537),82)
			Result.put (new_triple (4354,4455,4538),83)
			Result.put (new_triple (4354,4455,4539),84)
			Result.put (new_triple (4354,4455,4540),85)
			Result.put (new_triple (4354,4455,4541),86)
			Result.put (new_triple (4354,4455,4542),87)
			Result.put (new_triple (4354,4455,4543),88)
			Result.put (new_triple (4354,4455,4544),89)
			Result.put (new_triple (4354,4455,4545),90)
			Result.put (new_triple (4354,4455,4546),91)
			Result.put (new_pair (4354,4456),92)
			Result.put (new_triple (4354,4456,4520),93)
			Result.put (new_triple (4354,4456,4521),94)
			Result.put (new_triple (4354,4456,4522),95)
			Result.put (new_triple (4354,4456,4523),96)
			Result.put (new_triple (4354,4456,4524),97)
			Result.put (new_triple (4354,4456,4525),98)
			Result.put (new_triple (4354,4456,4526),99)
			Result.put (new_triple (4354,4456,4527),100)
			Result.put (new_triple (4354,4456,4528),101)
			Result.put (new_triple (4354,4456,4529),102)
			Result.put (new_triple (4354,4456,4530),103)
			Result.put (new_triple (4354,4456,4531),104)
			Result.put (new_triple (4354,4456,4532),105)
			Result.put (new_triple (4354,4456,4533),106)
			Result.put (new_triple (4354,4456,4534),107)
			Result.put (new_triple (4354,4456,4535),108)
			Result.put (new_triple (4354,4456,4536),109)
			Result.put (new_triple (4354,4456,4537),110)
			Result.put (new_triple (4354,4456,4538),111)
			Result.put (new_triple (4354,4456,4539),112)
			Result.put (new_triple (4354,4456,4540),113)
			Result.put (new_triple (4354,4456,4541),114)
			Result.put (new_triple (4354,4456,4542),115)
			Result.put (new_triple (4354,4456,4543),116)
			Result.put (new_triple (4354,4456,4544),117)
			Result.put (new_triple (4354,4456,4545),118)
			Result.put (new_triple (4354,4456,4546),119)
			Result.put (new_pair (4354,4457),120)
			Result.put (new_triple (4354,4457,4520),121)
			Result.put (new_triple (4354,4457,4521),122)
			Result.put (new_triple (4354,4457,4522),123)
			Result.put (new_triple (4354,4457,4523),124)
			Result.put (new_triple (4354,4457,4524),125)
			Result.put (new_triple (4354,4457,4525),126)
			Result.put (new_triple (4354,4457,4526),127)
			Result.put (new_triple (4354,4457,4527),128)
			Result.put (new_triple (4354,4457,4528),129)
			Result.put (new_triple (4354,4457,4529),130)
			Result.put (new_triple (4354,4457,4530),131)
			Result.put (new_triple (4354,4457,4531),132)
			Result.put (new_triple (4354,4457,4532),133)
			Result.put (new_triple (4354,4457,4533),134)
			Result.put (new_triple (4354,4457,4534),135)
			Result.put (new_triple (4354,4457,4535),136)
			Result.put (new_triple (4354,4457,4536),137)
			Result.put (new_triple (4354,4457,4537),138)
			Result.put (new_triple (4354,4457,4538),139)
			Result.put (new_triple (4354,4457,4539),140)
			Result.put (new_triple (4354,4457,4540),141)
			Result.put (new_triple (4354,4457,4541),142)
			Result.put (new_triple (4354,4457,4542),143)
			Result.put (new_triple (4354,4457,4543),144)
			Result.put (new_triple (4354,4457,4544),145)
			Result.put (new_triple (4354,4457,4545),146)
			Result.put (new_triple (4354,4457,4546),147)
			Result.put (new_pair (4354,4458),148)
			Result.put (new_triple (4354,4458,4520),149)
			Result.put (new_triple (4354,4458,4521),150)
			Result.put (new_triple (4354,4458,4522),151)
			Result.put (new_triple (4354,4458,4523),152)
			Result.put (new_triple (4354,4458,4524),153)
			Result.put (new_triple (4354,4458,4525),154)
			Result.put (new_triple (4354,4458,4526),155)
			Result.put (new_triple (4354,4458,4527),156)
			Result.put (new_triple (4354,4458,4528),157)
			Result.put (new_triple (4354,4458,4529),158)
			Result.put (new_triple (4354,4458,4530),159)
			Result.put (new_triple (4354,4458,4531),160)
			Result.put (new_triple (4354,4458,4532),161)
			Result.put (new_triple (4354,4458,4533),162)
			Result.put (new_triple (4354,4458,4534),163)
			Result.put (new_triple (4354,4458,4535),164)
			Result.put (new_triple (4354,4458,4536),165)
			Result.put (new_triple (4354,4458,4537),166)
			Result.put (new_triple (4354,4458,4538),167)
			Result.put (new_triple (4354,4458,4539),168)
			Result.put (new_triple (4354,4458,4540),169)
			Result.put (new_triple (4354,4458,4541),170)
			Result.put (new_triple (4354,4458,4542),171)
			Result.put (new_triple (4354,4458,4543),172)
			Result.put (new_triple (4354,4458,4544),173)
			Result.put (new_triple (4354,4458,4545),174)
			Result.put (new_triple (4354,4458,4546),175)
			Result.put (new_pair (4354,4459),176)
			Result.put (new_triple (4354,4459,4520),177)
			Result.put (new_triple (4354,4459,4521),178)
			Result.put (new_triple (4354,4459,4522),179)
			Result.put (new_triple (4354,4459,4523),180)
			Result.put (new_triple (4354,4459,4524),181)
			Result.put (new_triple (4354,4459,4525),182)
			Result.put (new_triple (4354,4459,4526),183)
			Result.put (new_triple (4354,4459,4527),184)
			Result.put (new_triple (4354,4459,4528),185)
			Result.put (new_triple (4354,4459,4529),186)
			Result.put (new_triple (4354,4459,4530),187)
			Result.put (new_triple (4354,4459,4531),188)
			Result.put (new_triple (4354,4459,4532),189)
			Result.put (new_triple (4354,4459,4533),190)
			Result.put (new_triple (4354,4459,4534),191)
			Result.put (new_triple (4354,4459,4535),192)
			Result.put (new_triple (4354,4459,4536),193)
			Result.put (new_triple (4354,4459,4537),194)
			Result.put (new_triple (4354,4459,4538),195)
			Result.put (new_triple (4354,4459,4539),196)
			Result.put (new_triple (4354,4459,4540),197)
			Result.put (new_triple (4354,4459,4541),198)
			Result.put (new_triple (4354,4459,4542),199)
			Result.put (new_triple (4354,4459,4543),200)
			Result.put (new_triple (4354,4459,4544),201)
			Result.put (new_triple (4354,4459,4545),202)
			Result.put (new_triple (4354,4459,4546),203)
			Result.put (new_pair (4354,4460),204)
			Result.put (new_triple (4354,4460,4520),205)
			Result.put (new_triple (4354,4460,4521),206)
			Result.put (new_triple (4354,4460,4522),207)
			Result.put (new_triple (4354,4460,4523),208)
			Result.put (new_triple (4354,4460,4524),209)
			Result.put (new_triple (4354,4460,4525),210)
			Result.put (new_triple (4354,4460,4526),211)
			Result.put (new_triple (4354,4460,4527),212)
			Result.put (new_triple (4354,4460,4528),213)
			Result.put (new_triple (4354,4460,4529),214)
			Result.put (new_triple (4354,4460,4530),215)
			Result.put (new_triple (4354,4460,4531),216)
			Result.put (new_triple (4354,4460,4532),217)
			Result.put (new_triple (4354,4460,4533),218)
			Result.put (new_triple (4354,4460,4534),219)
			Result.put (new_triple (4354,4460,4535),220)
			Result.put (new_triple (4354,4460,4536),221)
			Result.put (new_triple (4354,4460,4537),222)
			Result.put (new_triple (4354,4460,4538),223)
			Result.put (new_triple (4354,4460,4539),224)
			Result.put (new_triple (4354,4460,4540),225)
			Result.put (new_triple (4354,4460,4541),226)
			Result.put (new_triple (4354,4460,4542),227)
			Result.put (new_triple (4354,4460,4543),228)
			Result.put (new_triple (4354,4460,4544),229)
			Result.put (new_triple (4354,4460,4545),230)
			Result.put (new_triple (4354,4460,4546),231)
			Result.put (new_pair (4354,4461),232)
			Result.put (new_triple (4354,4461,4520),233)
			Result.put (new_triple (4354,4461,4521),234)
			Result.put (new_triple (4354,4461,4522),235)
			Result.put (new_triple (4354,4461,4523),236)
			Result.put (new_triple (4354,4461,4524),237)
			Result.put (new_triple (4354,4461,4525),238)
			Result.put (new_triple (4354,4461,4526),239)
			Result.put (new_triple (4354,4461,4527),240)
			Result.put (new_triple (4354,4461,4528),241)
			Result.put (new_triple (4354,4461,4529),242)
			Result.put (new_triple (4354,4461,4530),243)
			Result.put (new_triple (4354,4461,4531),244)
			Result.put (new_triple (4354,4461,4532),245)
			Result.put (new_triple (4354,4461,4533),246)
			Result.put (new_triple (4354,4461,4534),247)
			Result.put (new_triple (4354,4461,4535),248)
			Result.put (new_triple (4354,4461,4536),249)
			Result.put (new_triple (4354,4461,4537),250)
			Result.put (new_triple (4354,4461,4538),251)
			Result.put (new_triple (4354,4461,4539),252)
			Result.put (new_triple (4354,4461,4540),253)
			Result.put (new_triple (4354,4461,4541),254)
			Result.put (new_triple (4354,4461,4542),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_178: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4354,4461,4543),0)
			Result.put (new_triple (4354,4461,4544),1)
			Result.put (new_triple (4354,4461,4545),2)
			Result.put (new_triple (4354,4461,4546),3)
			Result.put (new_pair (4354,4462),4)
			Result.put (new_triple (4354,4462,4520),5)
			Result.put (new_triple (4354,4462,4521),6)
			Result.put (new_triple (4354,4462,4522),7)
			Result.put (new_triple (4354,4462,4523),8)
			Result.put (new_triple (4354,4462,4524),9)
			Result.put (new_triple (4354,4462,4525),10)
			Result.put (new_triple (4354,4462,4526),11)
			Result.put (new_triple (4354,4462,4527),12)
			Result.put (new_triple (4354,4462,4528),13)
			Result.put (new_triple (4354,4462,4529),14)
			Result.put (new_triple (4354,4462,4530),15)
			Result.put (new_triple (4354,4462,4531),16)
			Result.put (new_triple (4354,4462,4532),17)
			Result.put (new_triple (4354,4462,4533),18)
			Result.put (new_triple (4354,4462,4534),19)
			Result.put (new_triple (4354,4462,4535),20)
			Result.put (new_triple (4354,4462,4536),21)
			Result.put (new_triple (4354,4462,4537),22)
			Result.put (new_triple (4354,4462,4538),23)
			Result.put (new_triple (4354,4462,4539),24)
			Result.put (new_triple (4354,4462,4540),25)
			Result.put (new_triple (4354,4462,4541),26)
			Result.put (new_triple (4354,4462,4542),27)
			Result.put (new_triple (4354,4462,4543),28)
			Result.put (new_triple (4354,4462,4544),29)
			Result.put (new_triple (4354,4462,4545),30)
			Result.put (new_triple (4354,4462,4546),31)
			Result.put (new_pair (4354,4463),32)
			Result.put (new_triple (4354,4463,4520),33)
			Result.put (new_triple (4354,4463,4521),34)
			Result.put (new_triple (4354,4463,4522),35)
			Result.put (new_triple (4354,4463,4523),36)
			Result.put (new_triple (4354,4463,4524),37)
			Result.put (new_triple (4354,4463,4525),38)
			Result.put (new_triple (4354,4463,4526),39)
			Result.put (new_triple (4354,4463,4527),40)
			Result.put (new_triple (4354,4463,4528),41)
			Result.put (new_triple (4354,4463,4529),42)
			Result.put (new_triple (4354,4463,4530),43)
			Result.put (new_triple (4354,4463,4531),44)
			Result.put (new_triple (4354,4463,4532),45)
			Result.put (new_triple (4354,4463,4533),46)
			Result.put (new_triple (4354,4463,4534),47)
			Result.put (new_triple (4354,4463,4535),48)
			Result.put (new_triple (4354,4463,4536),49)
			Result.put (new_triple (4354,4463,4537),50)
			Result.put (new_triple (4354,4463,4538),51)
			Result.put (new_triple (4354,4463,4539),52)
			Result.put (new_triple (4354,4463,4540),53)
			Result.put (new_triple (4354,4463,4541),54)
			Result.put (new_triple (4354,4463,4542),55)
			Result.put (new_triple (4354,4463,4543),56)
			Result.put (new_triple (4354,4463,4544),57)
			Result.put (new_triple (4354,4463,4545),58)
			Result.put (new_triple (4354,4463,4546),59)
			Result.put (new_pair (4354,4464),60)
			Result.put (new_triple (4354,4464,4520),61)
			Result.put (new_triple (4354,4464,4521),62)
			Result.put (new_triple (4354,4464,4522),63)
			Result.put (new_triple (4354,4464,4523),64)
			Result.put (new_triple (4354,4464,4524),65)
			Result.put (new_triple (4354,4464,4525),66)
			Result.put (new_triple (4354,4464,4526),67)
			Result.put (new_triple (4354,4464,4527),68)
			Result.put (new_triple (4354,4464,4528),69)
			Result.put (new_triple (4354,4464,4529),70)
			Result.put (new_triple (4354,4464,4530),71)
			Result.put (new_triple (4354,4464,4531),72)
			Result.put (new_triple (4354,4464,4532),73)
			Result.put (new_triple (4354,4464,4533),74)
			Result.put (new_triple (4354,4464,4534),75)
			Result.put (new_triple (4354,4464,4535),76)
			Result.put (new_triple (4354,4464,4536),77)
			Result.put (new_triple (4354,4464,4537),78)
			Result.put (new_triple (4354,4464,4538),79)
			Result.put (new_triple (4354,4464,4539),80)
			Result.put (new_triple (4354,4464,4540),81)
			Result.put (new_triple (4354,4464,4541),82)
			Result.put (new_triple (4354,4464,4542),83)
			Result.put (new_triple (4354,4464,4543),84)
			Result.put (new_triple (4354,4464,4544),85)
			Result.put (new_triple (4354,4464,4545),86)
			Result.put (new_triple (4354,4464,4546),87)
			Result.put (new_pair (4354,4465),88)
			Result.put (new_triple (4354,4465,4520),89)
			Result.put (new_triple (4354,4465,4521),90)
			Result.put (new_triple (4354,4465,4522),91)
			Result.put (new_triple (4354,4465,4523),92)
			Result.put (new_triple (4354,4465,4524),93)
			Result.put (new_triple (4354,4465,4525),94)
			Result.put (new_triple (4354,4465,4526),95)
			Result.put (new_triple (4354,4465,4527),96)
			Result.put (new_triple (4354,4465,4528),97)
			Result.put (new_triple (4354,4465,4529),98)
			Result.put (new_triple (4354,4465,4530),99)
			Result.put (new_triple (4354,4465,4531),100)
			Result.put (new_triple (4354,4465,4532),101)
			Result.put (new_triple (4354,4465,4533),102)
			Result.put (new_triple (4354,4465,4534),103)
			Result.put (new_triple (4354,4465,4535),104)
			Result.put (new_triple (4354,4465,4536),105)
			Result.put (new_triple (4354,4465,4537),106)
			Result.put (new_triple (4354,4465,4538),107)
			Result.put (new_triple (4354,4465,4539),108)
			Result.put (new_triple (4354,4465,4540),109)
			Result.put (new_triple (4354,4465,4541),110)
			Result.put (new_triple (4354,4465,4542),111)
			Result.put (new_triple (4354,4465,4543),112)
			Result.put (new_triple (4354,4465,4544),113)
			Result.put (new_triple (4354,4465,4545),114)
			Result.put (new_triple (4354,4465,4546),115)
			Result.put (new_pair (4354,4466),116)
			Result.put (new_triple (4354,4466,4520),117)
			Result.put (new_triple (4354,4466,4521),118)
			Result.put (new_triple (4354,4466,4522),119)
			Result.put (new_triple (4354,4466,4523),120)
			Result.put (new_triple (4354,4466,4524),121)
			Result.put (new_triple (4354,4466,4525),122)
			Result.put (new_triple (4354,4466,4526),123)
			Result.put (new_triple (4354,4466,4527),124)
			Result.put (new_triple (4354,4466,4528),125)
			Result.put (new_triple (4354,4466,4529),126)
			Result.put (new_triple (4354,4466,4530),127)
			Result.put (new_triple (4354,4466,4531),128)
			Result.put (new_triple (4354,4466,4532),129)
			Result.put (new_triple (4354,4466,4533),130)
			Result.put (new_triple (4354,4466,4534),131)
			Result.put (new_triple (4354,4466,4535),132)
			Result.put (new_triple (4354,4466,4536),133)
			Result.put (new_triple (4354,4466,4537),134)
			Result.put (new_triple (4354,4466,4538),135)
			Result.put (new_triple (4354,4466,4539),136)
			Result.put (new_triple (4354,4466,4540),137)
			Result.put (new_triple (4354,4466,4541),138)
			Result.put (new_triple (4354,4466,4542),139)
			Result.put (new_triple (4354,4466,4543),140)
			Result.put (new_triple (4354,4466,4544),141)
			Result.put (new_triple (4354,4466,4545),142)
			Result.put (new_triple (4354,4466,4546),143)
			Result.put (new_pair (4354,4467),144)
			Result.put (new_triple (4354,4467,4520),145)
			Result.put (new_triple (4354,4467,4521),146)
			Result.put (new_triple (4354,4467,4522),147)
			Result.put (new_triple (4354,4467,4523),148)
			Result.put (new_triple (4354,4467,4524),149)
			Result.put (new_triple (4354,4467,4525),150)
			Result.put (new_triple (4354,4467,4526),151)
			Result.put (new_triple (4354,4467,4527),152)
			Result.put (new_triple (4354,4467,4528),153)
			Result.put (new_triple (4354,4467,4529),154)
			Result.put (new_triple (4354,4467,4530),155)
			Result.put (new_triple (4354,4467,4531),156)
			Result.put (new_triple (4354,4467,4532),157)
			Result.put (new_triple (4354,4467,4533),158)
			Result.put (new_triple (4354,4467,4534),159)
			Result.put (new_triple (4354,4467,4535),160)
			Result.put (new_triple (4354,4467,4536),161)
			Result.put (new_triple (4354,4467,4537),162)
			Result.put (new_triple (4354,4467,4538),163)
			Result.put (new_triple (4354,4467,4539),164)
			Result.put (new_triple (4354,4467,4540),165)
			Result.put (new_triple (4354,4467,4541),166)
			Result.put (new_triple (4354,4467,4542),167)
			Result.put (new_triple (4354,4467,4543),168)
			Result.put (new_triple (4354,4467,4544),169)
			Result.put (new_triple (4354,4467,4545),170)
			Result.put (new_triple (4354,4467,4546),171)
			Result.put (new_pair (4354,4468),172)
			Result.put (new_triple (4354,4468,4520),173)
			Result.put (new_triple (4354,4468,4521),174)
			Result.put (new_triple (4354,4468,4522),175)
			Result.put (new_triple (4354,4468,4523),176)
			Result.put (new_triple (4354,4468,4524),177)
			Result.put (new_triple (4354,4468,4525),178)
			Result.put (new_triple (4354,4468,4526),179)
			Result.put (new_triple (4354,4468,4527),180)
			Result.put (new_triple (4354,4468,4528),181)
			Result.put (new_triple (4354,4468,4529),182)
			Result.put (new_triple (4354,4468,4530),183)
			Result.put (new_triple (4354,4468,4531),184)
			Result.put (new_triple (4354,4468,4532),185)
			Result.put (new_triple (4354,4468,4533),186)
			Result.put (new_triple (4354,4468,4534),187)
			Result.put (new_triple (4354,4468,4535),188)
			Result.put (new_triple (4354,4468,4536),189)
			Result.put (new_triple (4354,4468,4537),190)
			Result.put (new_triple (4354,4468,4538),191)
			Result.put (new_triple (4354,4468,4539),192)
			Result.put (new_triple (4354,4468,4540),193)
			Result.put (new_triple (4354,4468,4541),194)
			Result.put (new_triple (4354,4468,4542),195)
			Result.put (new_triple (4354,4468,4543),196)
			Result.put (new_triple (4354,4468,4544),197)
			Result.put (new_triple (4354,4468,4545),198)
			Result.put (new_triple (4354,4468,4546),199)
			Result.put (new_pair (4354,4469),200)
			Result.put (new_triple (4354,4469,4520),201)
			Result.put (new_triple (4354,4469,4521),202)
			Result.put (new_triple (4354,4469,4522),203)
			Result.put (new_triple (4354,4469,4523),204)
			Result.put (new_triple (4354,4469,4524),205)
			Result.put (new_triple (4354,4469,4525),206)
			Result.put (new_triple (4354,4469,4526),207)
			Result.put (new_triple (4354,4469,4527),208)
			Result.put (new_triple (4354,4469,4528),209)
			Result.put (new_triple (4354,4469,4529),210)
			Result.put (new_triple (4354,4469,4530),211)
			Result.put (new_triple (4354,4469,4531),212)
			Result.put (new_triple (4354,4469,4532),213)
			Result.put (new_triple (4354,4469,4533),214)
			Result.put (new_triple (4354,4469,4534),215)
			Result.put (new_triple (4354,4469,4535),216)
			Result.put (new_triple (4354,4469,4536),217)
			Result.put (new_triple (4354,4469,4537),218)
			Result.put (new_triple (4354,4469,4538),219)
			Result.put (new_triple (4354,4469,4539),220)
			Result.put (new_triple (4354,4469,4540),221)
			Result.put (new_triple (4354,4469,4541),222)
			Result.put (new_triple (4354,4469,4542),223)
			Result.put (new_triple (4354,4469,4543),224)
			Result.put (new_triple (4354,4469,4544),225)
			Result.put (new_triple (4354,4469,4545),226)
			Result.put (new_triple (4354,4469,4546),227)
			Result.put (new_pair (4355,4449),228)
			Result.put (new_triple (4355,4449,4520),229)
			Result.put (new_triple (4355,4449,4521),230)
			Result.put (new_triple (4355,4449,4522),231)
			Result.put (new_triple (4355,4449,4523),232)
			Result.put (new_triple (4355,4449,4524),233)
			Result.put (new_triple (4355,4449,4525),234)
			Result.put (new_triple (4355,4449,4526),235)
			Result.put (new_triple (4355,4449,4527),236)
			Result.put (new_triple (4355,4449,4528),237)
			Result.put (new_triple (4355,4449,4529),238)
			Result.put (new_triple (4355,4449,4530),239)
			Result.put (new_triple (4355,4449,4531),240)
			Result.put (new_triple (4355,4449,4532),241)
			Result.put (new_triple (4355,4449,4533),242)
			Result.put (new_triple (4355,4449,4534),243)
			Result.put (new_triple (4355,4449,4535),244)
			Result.put (new_triple (4355,4449,4536),245)
			Result.put (new_triple (4355,4449,4537),246)
			Result.put (new_triple (4355,4449,4538),247)
			Result.put (new_triple (4355,4449,4539),248)
			Result.put (new_triple (4355,4449,4540),249)
			Result.put (new_triple (4355,4449,4541),250)
			Result.put (new_triple (4355,4449,4542),251)
			Result.put (new_triple (4355,4449,4543),252)
			Result.put (new_triple (4355,4449,4544),253)
			Result.put (new_triple (4355,4449,4545),254)
			Result.put (new_triple (4355,4449,4546),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_179: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (4355,4450),0)
			Result.put (new_triple (4355,4450,4520),1)
			Result.put (new_triple (4355,4450,4521),2)
			Result.put (new_triple (4355,4450,4522),3)
			Result.put (new_triple (4355,4450,4523),4)
			Result.put (new_triple (4355,4450,4524),5)
			Result.put (new_triple (4355,4450,4525),6)
			Result.put (new_triple (4355,4450,4526),7)
			Result.put (new_triple (4355,4450,4527),8)
			Result.put (new_triple (4355,4450,4528),9)
			Result.put (new_triple (4355,4450,4529),10)
			Result.put (new_triple (4355,4450,4530),11)
			Result.put (new_triple (4355,4450,4531),12)
			Result.put (new_triple (4355,4450,4532),13)
			Result.put (new_triple (4355,4450,4533),14)
			Result.put (new_triple (4355,4450,4534),15)
			Result.put (new_triple (4355,4450,4535),16)
			Result.put (new_triple (4355,4450,4536),17)
			Result.put (new_triple (4355,4450,4537),18)
			Result.put (new_triple (4355,4450,4538),19)
			Result.put (new_triple (4355,4450,4539),20)
			Result.put (new_triple (4355,4450,4540),21)
			Result.put (new_triple (4355,4450,4541),22)
			Result.put (new_triple (4355,4450,4542),23)
			Result.put (new_triple (4355,4450,4543),24)
			Result.put (new_triple (4355,4450,4544),25)
			Result.put (new_triple (4355,4450,4545),26)
			Result.put (new_triple (4355,4450,4546),27)
			Result.put (new_pair (4355,4451),28)
			Result.put (new_triple (4355,4451,4520),29)
			Result.put (new_triple (4355,4451,4521),30)
			Result.put (new_triple (4355,4451,4522),31)
			Result.put (new_triple (4355,4451,4523),32)
			Result.put (new_triple (4355,4451,4524),33)
			Result.put (new_triple (4355,4451,4525),34)
			Result.put (new_triple (4355,4451,4526),35)
			Result.put (new_triple (4355,4451,4527),36)
			Result.put (new_triple (4355,4451,4528),37)
			Result.put (new_triple (4355,4451,4529),38)
			Result.put (new_triple (4355,4451,4530),39)
			Result.put (new_triple (4355,4451,4531),40)
			Result.put (new_triple (4355,4451,4532),41)
			Result.put (new_triple (4355,4451,4533),42)
			Result.put (new_triple (4355,4451,4534),43)
			Result.put (new_triple (4355,4451,4535),44)
			Result.put (new_triple (4355,4451,4536),45)
			Result.put (new_triple (4355,4451,4537),46)
			Result.put (new_triple (4355,4451,4538),47)
			Result.put (new_triple (4355,4451,4539),48)
			Result.put (new_triple (4355,4451,4540),49)
			Result.put (new_triple (4355,4451,4541),50)
			Result.put (new_triple (4355,4451,4542),51)
			Result.put (new_triple (4355,4451,4543),52)
			Result.put (new_triple (4355,4451,4544),53)
			Result.put (new_triple (4355,4451,4545),54)
			Result.put (new_triple (4355,4451,4546),55)
			Result.put (new_pair (4355,4452),56)
			Result.put (new_triple (4355,4452,4520),57)
			Result.put (new_triple (4355,4452,4521),58)
			Result.put (new_triple (4355,4452,4522),59)
			Result.put (new_triple (4355,4452,4523),60)
			Result.put (new_triple (4355,4452,4524),61)
			Result.put (new_triple (4355,4452,4525),62)
			Result.put (new_triple (4355,4452,4526),63)
			Result.put (new_triple (4355,4452,4527),64)
			Result.put (new_triple (4355,4452,4528),65)
			Result.put (new_triple (4355,4452,4529),66)
			Result.put (new_triple (4355,4452,4530),67)
			Result.put (new_triple (4355,4452,4531),68)
			Result.put (new_triple (4355,4452,4532),69)
			Result.put (new_triple (4355,4452,4533),70)
			Result.put (new_triple (4355,4452,4534),71)
			Result.put (new_triple (4355,4452,4535),72)
			Result.put (new_triple (4355,4452,4536),73)
			Result.put (new_triple (4355,4452,4537),74)
			Result.put (new_triple (4355,4452,4538),75)
			Result.put (new_triple (4355,4452,4539),76)
			Result.put (new_triple (4355,4452,4540),77)
			Result.put (new_triple (4355,4452,4541),78)
			Result.put (new_triple (4355,4452,4542),79)
			Result.put (new_triple (4355,4452,4543),80)
			Result.put (new_triple (4355,4452,4544),81)
			Result.put (new_triple (4355,4452,4545),82)
			Result.put (new_triple (4355,4452,4546),83)
			Result.put (new_pair (4355,4453),84)
			Result.put (new_triple (4355,4453,4520),85)
			Result.put (new_triple (4355,4453,4521),86)
			Result.put (new_triple (4355,4453,4522),87)
			Result.put (new_triple (4355,4453,4523),88)
			Result.put (new_triple (4355,4453,4524),89)
			Result.put (new_triple (4355,4453,4525),90)
			Result.put (new_triple (4355,4453,4526),91)
			Result.put (new_triple (4355,4453,4527),92)
			Result.put (new_triple (4355,4453,4528),93)
			Result.put (new_triple (4355,4453,4529),94)
			Result.put (new_triple (4355,4453,4530),95)
			Result.put (new_triple (4355,4453,4531),96)
			Result.put (new_triple (4355,4453,4532),97)
			Result.put (new_triple (4355,4453,4533),98)
			Result.put (new_triple (4355,4453,4534),99)
			Result.put (new_triple (4355,4453,4535),100)
			Result.put (new_triple (4355,4453,4536),101)
			Result.put (new_triple (4355,4453,4537),102)
			Result.put (new_triple (4355,4453,4538),103)
			Result.put (new_triple (4355,4453,4539),104)
			Result.put (new_triple (4355,4453,4540),105)
			Result.put (new_triple (4355,4453,4541),106)
			Result.put (new_triple (4355,4453,4542),107)
			Result.put (new_triple (4355,4453,4543),108)
			Result.put (new_triple (4355,4453,4544),109)
			Result.put (new_triple (4355,4453,4545),110)
			Result.put (new_triple (4355,4453,4546),111)
			Result.put (new_pair (4355,4454),112)
			Result.put (new_triple (4355,4454,4520),113)
			Result.put (new_triple (4355,4454,4521),114)
			Result.put (new_triple (4355,4454,4522),115)
			Result.put (new_triple (4355,4454,4523),116)
			Result.put (new_triple (4355,4454,4524),117)
			Result.put (new_triple (4355,4454,4525),118)
			Result.put (new_triple (4355,4454,4526),119)
			Result.put (new_triple (4355,4454,4527),120)
			Result.put (new_triple (4355,4454,4528),121)
			Result.put (new_triple (4355,4454,4529),122)
			Result.put (new_triple (4355,4454,4530),123)
			Result.put (new_triple (4355,4454,4531),124)
			Result.put (new_triple (4355,4454,4532),125)
			Result.put (new_triple (4355,4454,4533),126)
			Result.put (new_triple (4355,4454,4534),127)
			Result.put (new_triple (4355,4454,4535),128)
			Result.put (new_triple (4355,4454,4536),129)
			Result.put (new_triple (4355,4454,4537),130)
			Result.put (new_triple (4355,4454,4538),131)
			Result.put (new_triple (4355,4454,4539),132)
			Result.put (new_triple (4355,4454,4540),133)
			Result.put (new_triple (4355,4454,4541),134)
			Result.put (new_triple (4355,4454,4542),135)
			Result.put (new_triple (4355,4454,4543),136)
			Result.put (new_triple (4355,4454,4544),137)
			Result.put (new_triple (4355,4454,4545),138)
			Result.put (new_triple (4355,4454,4546),139)
			Result.put (new_pair (4355,4455),140)
			Result.put (new_triple (4355,4455,4520),141)
			Result.put (new_triple (4355,4455,4521),142)
			Result.put (new_triple (4355,4455,4522),143)
			Result.put (new_triple (4355,4455,4523),144)
			Result.put (new_triple (4355,4455,4524),145)
			Result.put (new_triple (4355,4455,4525),146)
			Result.put (new_triple (4355,4455,4526),147)
			Result.put (new_triple (4355,4455,4527),148)
			Result.put (new_triple (4355,4455,4528),149)
			Result.put (new_triple (4355,4455,4529),150)
			Result.put (new_triple (4355,4455,4530),151)
			Result.put (new_triple (4355,4455,4531),152)
			Result.put (new_triple (4355,4455,4532),153)
			Result.put (new_triple (4355,4455,4533),154)
			Result.put (new_triple (4355,4455,4534),155)
			Result.put (new_triple (4355,4455,4535),156)
			Result.put (new_triple (4355,4455,4536),157)
			Result.put (new_triple (4355,4455,4537),158)
			Result.put (new_triple (4355,4455,4538),159)
			Result.put (new_triple (4355,4455,4539),160)
			Result.put (new_triple (4355,4455,4540),161)
			Result.put (new_triple (4355,4455,4541),162)
			Result.put (new_triple (4355,4455,4542),163)
			Result.put (new_triple (4355,4455,4543),164)
			Result.put (new_triple (4355,4455,4544),165)
			Result.put (new_triple (4355,4455,4545),166)
			Result.put (new_triple (4355,4455,4546),167)
			Result.put (new_pair (4355,4456),168)
			Result.put (new_triple (4355,4456,4520),169)
			Result.put (new_triple (4355,4456,4521),170)
			Result.put (new_triple (4355,4456,4522),171)
			Result.put (new_triple (4355,4456,4523),172)
			Result.put (new_triple (4355,4456,4524),173)
			Result.put (new_triple (4355,4456,4525),174)
			Result.put (new_triple (4355,4456,4526),175)
			Result.put (new_triple (4355,4456,4527),176)
			Result.put (new_triple (4355,4456,4528),177)
			Result.put (new_triple (4355,4456,4529),178)
			Result.put (new_triple (4355,4456,4530),179)
			Result.put (new_triple (4355,4456,4531),180)
			Result.put (new_triple (4355,4456,4532),181)
			Result.put (new_triple (4355,4456,4533),182)
			Result.put (new_triple (4355,4456,4534),183)
			Result.put (new_triple (4355,4456,4535),184)
			Result.put (new_triple (4355,4456,4536),185)
			Result.put (new_triple (4355,4456,4537),186)
			Result.put (new_triple (4355,4456,4538),187)
			Result.put (new_triple (4355,4456,4539),188)
			Result.put (new_triple (4355,4456,4540),189)
			Result.put (new_triple (4355,4456,4541),190)
			Result.put (new_triple (4355,4456,4542),191)
			Result.put (new_triple (4355,4456,4543),192)
			Result.put (new_triple (4355,4456,4544),193)
			Result.put (new_triple (4355,4456,4545),194)
			Result.put (new_triple (4355,4456,4546),195)
			Result.put (new_pair (4355,4457),196)
			Result.put (new_triple (4355,4457,4520),197)
			Result.put (new_triple (4355,4457,4521),198)
			Result.put (new_triple (4355,4457,4522),199)
			Result.put (new_triple (4355,4457,4523),200)
			Result.put (new_triple (4355,4457,4524),201)
			Result.put (new_triple (4355,4457,4525),202)
			Result.put (new_triple (4355,4457,4526),203)
			Result.put (new_triple (4355,4457,4527),204)
			Result.put (new_triple (4355,4457,4528),205)
			Result.put (new_triple (4355,4457,4529),206)
			Result.put (new_triple (4355,4457,4530),207)
			Result.put (new_triple (4355,4457,4531),208)
			Result.put (new_triple (4355,4457,4532),209)
			Result.put (new_triple (4355,4457,4533),210)
			Result.put (new_triple (4355,4457,4534),211)
			Result.put (new_triple (4355,4457,4535),212)
			Result.put (new_triple (4355,4457,4536),213)
			Result.put (new_triple (4355,4457,4537),214)
			Result.put (new_triple (4355,4457,4538),215)
			Result.put (new_triple (4355,4457,4539),216)
			Result.put (new_triple (4355,4457,4540),217)
			Result.put (new_triple (4355,4457,4541),218)
			Result.put (new_triple (4355,4457,4542),219)
			Result.put (new_triple (4355,4457,4543),220)
			Result.put (new_triple (4355,4457,4544),221)
			Result.put (new_triple (4355,4457,4545),222)
			Result.put (new_triple (4355,4457,4546),223)
			Result.put (new_pair (4355,4458),224)
			Result.put (new_triple (4355,4458,4520),225)
			Result.put (new_triple (4355,4458,4521),226)
			Result.put (new_triple (4355,4458,4522),227)
			Result.put (new_triple (4355,4458,4523),228)
			Result.put (new_triple (4355,4458,4524),229)
			Result.put (new_triple (4355,4458,4525),230)
			Result.put (new_triple (4355,4458,4526),231)
			Result.put (new_triple (4355,4458,4527),232)
			Result.put (new_triple (4355,4458,4528),233)
			Result.put (new_triple (4355,4458,4529),234)
			Result.put (new_triple (4355,4458,4530),235)
			Result.put (new_triple (4355,4458,4531),236)
			Result.put (new_triple (4355,4458,4532),237)
			Result.put (new_triple (4355,4458,4533),238)
			Result.put (new_triple (4355,4458,4534),239)
			Result.put (new_triple (4355,4458,4535),240)
			Result.put (new_triple (4355,4458,4536),241)
			Result.put (new_triple (4355,4458,4537),242)
			Result.put (new_triple (4355,4458,4538),243)
			Result.put (new_triple (4355,4458,4539),244)
			Result.put (new_triple (4355,4458,4540),245)
			Result.put (new_triple (4355,4458,4541),246)
			Result.put (new_triple (4355,4458,4542),247)
			Result.put (new_triple (4355,4458,4543),248)
			Result.put (new_triple (4355,4458,4544),249)
			Result.put (new_triple (4355,4458,4545),250)
			Result.put (new_triple (4355,4458,4546),251)
			Result.put (new_pair (4355,4459),252)
			Result.put (new_triple (4355,4459,4520),253)
			Result.put (new_triple (4355,4459,4521),254)
			Result.put (new_triple (4355,4459,4522),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_180: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4355,4459,4523),0)
			Result.put (new_triple (4355,4459,4524),1)
			Result.put (new_triple (4355,4459,4525),2)
			Result.put (new_triple (4355,4459,4526),3)
			Result.put (new_triple (4355,4459,4527),4)
			Result.put (new_triple (4355,4459,4528),5)
			Result.put (new_triple (4355,4459,4529),6)
			Result.put (new_triple (4355,4459,4530),7)
			Result.put (new_triple (4355,4459,4531),8)
			Result.put (new_triple (4355,4459,4532),9)
			Result.put (new_triple (4355,4459,4533),10)
			Result.put (new_triple (4355,4459,4534),11)
			Result.put (new_triple (4355,4459,4535),12)
			Result.put (new_triple (4355,4459,4536),13)
			Result.put (new_triple (4355,4459,4537),14)
			Result.put (new_triple (4355,4459,4538),15)
			Result.put (new_triple (4355,4459,4539),16)
			Result.put (new_triple (4355,4459,4540),17)
			Result.put (new_triple (4355,4459,4541),18)
			Result.put (new_triple (4355,4459,4542),19)
			Result.put (new_triple (4355,4459,4543),20)
			Result.put (new_triple (4355,4459,4544),21)
			Result.put (new_triple (4355,4459,4545),22)
			Result.put (new_triple (4355,4459,4546),23)
			Result.put (new_pair (4355,4460),24)
			Result.put (new_triple (4355,4460,4520),25)
			Result.put (new_triple (4355,4460,4521),26)
			Result.put (new_triple (4355,4460,4522),27)
			Result.put (new_triple (4355,4460,4523),28)
			Result.put (new_triple (4355,4460,4524),29)
			Result.put (new_triple (4355,4460,4525),30)
			Result.put (new_triple (4355,4460,4526),31)
			Result.put (new_triple (4355,4460,4527),32)
			Result.put (new_triple (4355,4460,4528),33)
			Result.put (new_triple (4355,4460,4529),34)
			Result.put (new_triple (4355,4460,4530),35)
			Result.put (new_triple (4355,4460,4531),36)
			Result.put (new_triple (4355,4460,4532),37)
			Result.put (new_triple (4355,4460,4533),38)
			Result.put (new_triple (4355,4460,4534),39)
			Result.put (new_triple (4355,4460,4535),40)
			Result.put (new_triple (4355,4460,4536),41)
			Result.put (new_triple (4355,4460,4537),42)
			Result.put (new_triple (4355,4460,4538),43)
			Result.put (new_triple (4355,4460,4539),44)
			Result.put (new_triple (4355,4460,4540),45)
			Result.put (new_triple (4355,4460,4541),46)
			Result.put (new_triple (4355,4460,4542),47)
			Result.put (new_triple (4355,4460,4543),48)
			Result.put (new_triple (4355,4460,4544),49)
			Result.put (new_triple (4355,4460,4545),50)
			Result.put (new_triple (4355,4460,4546),51)
			Result.put (new_pair (4355,4461),52)
			Result.put (new_triple (4355,4461,4520),53)
			Result.put (new_triple (4355,4461,4521),54)
			Result.put (new_triple (4355,4461,4522),55)
			Result.put (new_triple (4355,4461,4523),56)
			Result.put (new_triple (4355,4461,4524),57)
			Result.put (new_triple (4355,4461,4525),58)
			Result.put (new_triple (4355,4461,4526),59)
			Result.put (new_triple (4355,4461,4527),60)
			Result.put (new_triple (4355,4461,4528),61)
			Result.put (new_triple (4355,4461,4529),62)
			Result.put (new_triple (4355,4461,4530),63)
			Result.put (new_triple (4355,4461,4531),64)
			Result.put (new_triple (4355,4461,4532),65)
			Result.put (new_triple (4355,4461,4533),66)
			Result.put (new_triple (4355,4461,4534),67)
			Result.put (new_triple (4355,4461,4535),68)
			Result.put (new_triple (4355,4461,4536),69)
			Result.put (new_triple (4355,4461,4537),70)
			Result.put (new_triple (4355,4461,4538),71)
			Result.put (new_triple (4355,4461,4539),72)
			Result.put (new_triple (4355,4461,4540),73)
			Result.put (new_triple (4355,4461,4541),74)
			Result.put (new_triple (4355,4461,4542),75)
			Result.put (new_triple (4355,4461,4543),76)
			Result.put (new_triple (4355,4461,4544),77)
			Result.put (new_triple (4355,4461,4545),78)
			Result.put (new_triple (4355,4461,4546),79)
			Result.put (new_pair (4355,4462),80)
			Result.put (new_triple (4355,4462,4520),81)
			Result.put (new_triple (4355,4462,4521),82)
			Result.put (new_triple (4355,4462,4522),83)
			Result.put (new_triple (4355,4462,4523),84)
			Result.put (new_triple (4355,4462,4524),85)
			Result.put (new_triple (4355,4462,4525),86)
			Result.put (new_triple (4355,4462,4526),87)
			Result.put (new_triple (4355,4462,4527),88)
			Result.put (new_triple (4355,4462,4528),89)
			Result.put (new_triple (4355,4462,4529),90)
			Result.put (new_triple (4355,4462,4530),91)
			Result.put (new_triple (4355,4462,4531),92)
			Result.put (new_triple (4355,4462,4532),93)
			Result.put (new_triple (4355,4462,4533),94)
			Result.put (new_triple (4355,4462,4534),95)
			Result.put (new_triple (4355,4462,4535),96)
			Result.put (new_triple (4355,4462,4536),97)
			Result.put (new_triple (4355,4462,4537),98)
			Result.put (new_triple (4355,4462,4538),99)
			Result.put (new_triple (4355,4462,4539),100)
			Result.put (new_triple (4355,4462,4540),101)
			Result.put (new_triple (4355,4462,4541),102)
			Result.put (new_triple (4355,4462,4542),103)
			Result.put (new_triple (4355,4462,4543),104)
			Result.put (new_triple (4355,4462,4544),105)
			Result.put (new_triple (4355,4462,4545),106)
			Result.put (new_triple (4355,4462,4546),107)
			Result.put (new_pair (4355,4463),108)
			Result.put (new_triple (4355,4463,4520),109)
			Result.put (new_triple (4355,4463,4521),110)
			Result.put (new_triple (4355,4463,4522),111)
			Result.put (new_triple (4355,4463,4523),112)
			Result.put (new_triple (4355,4463,4524),113)
			Result.put (new_triple (4355,4463,4525),114)
			Result.put (new_triple (4355,4463,4526),115)
			Result.put (new_triple (4355,4463,4527),116)
			Result.put (new_triple (4355,4463,4528),117)
			Result.put (new_triple (4355,4463,4529),118)
			Result.put (new_triple (4355,4463,4530),119)
			Result.put (new_triple (4355,4463,4531),120)
			Result.put (new_triple (4355,4463,4532),121)
			Result.put (new_triple (4355,4463,4533),122)
			Result.put (new_triple (4355,4463,4534),123)
			Result.put (new_triple (4355,4463,4535),124)
			Result.put (new_triple (4355,4463,4536),125)
			Result.put (new_triple (4355,4463,4537),126)
			Result.put (new_triple (4355,4463,4538),127)
			Result.put (new_triple (4355,4463,4539),128)
			Result.put (new_triple (4355,4463,4540),129)
			Result.put (new_triple (4355,4463,4541),130)
			Result.put (new_triple (4355,4463,4542),131)
			Result.put (new_triple (4355,4463,4543),132)
			Result.put (new_triple (4355,4463,4544),133)
			Result.put (new_triple (4355,4463,4545),134)
			Result.put (new_triple (4355,4463,4546),135)
			Result.put (new_pair (4355,4464),136)
			Result.put (new_triple (4355,4464,4520),137)
			Result.put (new_triple (4355,4464,4521),138)
			Result.put (new_triple (4355,4464,4522),139)
			Result.put (new_triple (4355,4464,4523),140)
			Result.put (new_triple (4355,4464,4524),141)
			Result.put (new_triple (4355,4464,4525),142)
			Result.put (new_triple (4355,4464,4526),143)
			Result.put (new_triple (4355,4464,4527),144)
			Result.put (new_triple (4355,4464,4528),145)
			Result.put (new_triple (4355,4464,4529),146)
			Result.put (new_triple (4355,4464,4530),147)
			Result.put (new_triple (4355,4464,4531),148)
			Result.put (new_triple (4355,4464,4532),149)
			Result.put (new_triple (4355,4464,4533),150)
			Result.put (new_triple (4355,4464,4534),151)
			Result.put (new_triple (4355,4464,4535),152)
			Result.put (new_triple (4355,4464,4536),153)
			Result.put (new_triple (4355,4464,4537),154)
			Result.put (new_triple (4355,4464,4538),155)
			Result.put (new_triple (4355,4464,4539),156)
			Result.put (new_triple (4355,4464,4540),157)
			Result.put (new_triple (4355,4464,4541),158)
			Result.put (new_triple (4355,4464,4542),159)
			Result.put (new_triple (4355,4464,4543),160)
			Result.put (new_triple (4355,4464,4544),161)
			Result.put (new_triple (4355,4464,4545),162)
			Result.put (new_triple (4355,4464,4546),163)
			Result.put (new_pair (4355,4465),164)
			Result.put (new_triple (4355,4465,4520),165)
			Result.put (new_triple (4355,4465,4521),166)
			Result.put (new_triple (4355,4465,4522),167)
			Result.put (new_triple (4355,4465,4523),168)
			Result.put (new_triple (4355,4465,4524),169)
			Result.put (new_triple (4355,4465,4525),170)
			Result.put (new_triple (4355,4465,4526),171)
			Result.put (new_triple (4355,4465,4527),172)
			Result.put (new_triple (4355,4465,4528),173)
			Result.put (new_triple (4355,4465,4529),174)
			Result.put (new_triple (4355,4465,4530),175)
			Result.put (new_triple (4355,4465,4531),176)
			Result.put (new_triple (4355,4465,4532),177)
			Result.put (new_triple (4355,4465,4533),178)
			Result.put (new_triple (4355,4465,4534),179)
			Result.put (new_triple (4355,4465,4535),180)
			Result.put (new_triple (4355,4465,4536),181)
			Result.put (new_triple (4355,4465,4537),182)
			Result.put (new_triple (4355,4465,4538),183)
			Result.put (new_triple (4355,4465,4539),184)
			Result.put (new_triple (4355,4465,4540),185)
			Result.put (new_triple (4355,4465,4541),186)
			Result.put (new_triple (4355,4465,4542),187)
			Result.put (new_triple (4355,4465,4543),188)
			Result.put (new_triple (4355,4465,4544),189)
			Result.put (new_triple (4355,4465,4545),190)
			Result.put (new_triple (4355,4465,4546),191)
			Result.put (new_pair (4355,4466),192)
			Result.put (new_triple (4355,4466,4520),193)
			Result.put (new_triple (4355,4466,4521),194)
			Result.put (new_triple (4355,4466,4522),195)
			Result.put (new_triple (4355,4466,4523),196)
			Result.put (new_triple (4355,4466,4524),197)
			Result.put (new_triple (4355,4466,4525),198)
			Result.put (new_triple (4355,4466,4526),199)
			Result.put (new_triple (4355,4466,4527),200)
			Result.put (new_triple (4355,4466,4528),201)
			Result.put (new_triple (4355,4466,4529),202)
			Result.put (new_triple (4355,4466,4530),203)
			Result.put (new_triple (4355,4466,4531),204)
			Result.put (new_triple (4355,4466,4532),205)
			Result.put (new_triple (4355,4466,4533),206)
			Result.put (new_triple (4355,4466,4534),207)
			Result.put (new_triple (4355,4466,4535),208)
			Result.put (new_triple (4355,4466,4536),209)
			Result.put (new_triple (4355,4466,4537),210)
			Result.put (new_triple (4355,4466,4538),211)
			Result.put (new_triple (4355,4466,4539),212)
			Result.put (new_triple (4355,4466,4540),213)
			Result.put (new_triple (4355,4466,4541),214)
			Result.put (new_triple (4355,4466,4542),215)
			Result.put (new_triple (4355,4466,4543),216)
			Result.put (new_triple (4355,4466,4544),217)
			Result.put (new_triple (4355,4466,4545),218)
			Result.put (new_triple (4355,4466,4546),219)
			Result.put (new_pair (4355,4467),220)
			Result.put (new_triple (4355,4467,4520),221)
			Result.put (new_triple (4355,4467,4521),222)
			Result.put (new_triple (4355,4467,4522),223)
			Result.put (new_triple (4355,4467,4523),224)
			Result.put (new_triple (4355,4467,4524),225)
			Result.put (new_triple (4355,4467,4525),226)
			Result.put (new_triple (4355,4467,4526),227)
			Result.put (new_triple (4355,4467,4527),228)
			Result.put (new_triple (4355,4467,4528),229)
			Result.put (new_triple (4355,4467,4529),230)
			Result.put (new_triple (4355,4467,4530),231)
			Result.put (new_triple (4355,4467,4531),232)
			Result.put (new_triple (4355,4467,4532),233)
			Result.put (new_triple (4355,4467,4533),234)
			Result.put (new_triple (4355,4467,4534),235)
			Result.put (new_triple (4355,4467,4535),236)
			Result.put (new_triple (4355,4467,4536),237)
			Result.put (new_triple (4355,4467,4537),238)
			Result.put (new_triple (4355,4467,4538),239)
			Result.put (new_triple (4355,4467,4539),240)
			Result.put (new_triple (4355,4467,4540),241)
			Result.put (new_triple (4355,4467,4541),242)
			Result.put (new_triple (4355,4467,4542),243)
			Result.put (new_triple (4355,4467,4543),244)
			Result.put (new_triple (4355,4467,4544),245)
			Result.put (new_triple (4355,4467,4545),246)
			Result.put (new_triple (4355,4467,4546),247)
			Result.put (new_pair (4355,4468),248)
			Result.put (new_triple (4355,4468,4520),249)
			Result.put (new_triple (4355,4468,4521),250)
			Result.put (new_triple (4355,4468,4522),251)
			Result.put (new_triple (4355,4468,4523),252)
			Result.put (new_triple (4355,4468,4524),253)
			Result.put (new_triple (4355,4468,4525),254)
			Result.put (new_triple (4355,4468,4526),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_181: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4355,4468,4527),0)
			Result.put (new_triple (4355,4468,4528),1)
			Result.put (new_triple (4355,4468,4529),2)
			Result.put (new_triple (4355,4468,4530),3)
			Result.put (new_triple (4355,4468,4531),4)
			Result.put (new_triple (4355,4468,4532),5)
			Result.put (new_triple (4355,4468,4533),6)
			Result.put (new_triple (4355,4468,4534),7)
			Result.put (new_triple (4355,4468,4535),8)
			Result.put (new_triple (4355,4468,4536),9)
			Result.put (new_triple (4355,4468,4537),10)
			Result.put (new_triple (4355,4468,4538),11)
			Result.put (new_triple (4355,4468,4539),12)
			Result.put (new_triple (4355,4468,4540),13)
			Result.put (new_triple (4355,4468,4541),14)
			Result.put (new_triple (4355,4468,4542),15)
			Result.put (new_triple (4355,4468,4543),16)
			Result.put (new_triple (4355,4468,4544),17)
			Result.put (new_triple (4355,4468,4545),18)
			Result.put (new_triple (4355,4468,4546),19)
			Result.put (new_pair (4355,4469),20)
			Result.put (new_triple (4355,4469,4520),21)
			Result.put (new_triple (4355,4469,4521),22)
			Result.put (new_triple (4355,4469,4522),23)
			Result.put (new_triple (4355,4469,4523),24)
			Result.put (new_triple (4355,4469,4524),25)
			Result.put (new_triple (4355,4469,4525),26)
			Result.put (new_triple (4355,4469,4526),27)
			Result.put (new_triple (4355,4469,4527),28)
			Result.put (new_triple (4355,4469,4528),29)
			Result.put (new_triple (4355,4469,4529),30)
			Result.put (new_triple (4355,4469,4530),31)
			Result.put (new_triple (4355,4469,4531),32)
			Result.put (new_triple (4355,4469,4532),33)
			Result.put (new_triple (4355,4469,4533),34)
			Result.put (new_triple (4355,4469,4534),35)
			Result.put (new_triple (4355,4469,4535),36)
			Result.put (new_triple (4355,4469,4536),37)
			Result.put (new_triple (4355,4469,4537),38)
			Result.put (new_triple (4355,4469,4538),39)
			Result.put (new_triple (4355,4469,4539),40)
			Result.put (new_triple (4355,4469,4540),41)
			Result.put (new_triple (4355,4469,4541),42)
			Result.put (new_triple (4355,4469,4542),43)
			Result.put (new_triple (4355,4469,4543),44)
			Result.put (new_triple (4355,4469,4544),45)
			Result.put (new_triple (4355,4469,4545),46)
			Result.put (new_triple (4355,4469,4546),47)
			Result.put (new_pair (4356,4449),48)
			Result.put (new_triple (4356,4449,4520),49)
			Result.put (new_triple (4356,4449,4521),50)
			Result.put (new_triple (4356,4449,4522),51)
			Result.put (new_triple (4356,4449,4523),52)
			Result.put (new_triple (4356,4449,4524),53)
			Result.put (new_triple (4356,4449,4525),54)
			Result.put (new_triple (4356,4449,4526),55)
			Result.put (new_triple (4356,4449,4527),56)
			Result.put (new_triple (4356,4449,4528),57)
			Result.put (new_triple (4356,4449,4529),58)
			Result.put (new_triple (4356,4449,4530),59)
			Result.put (new_triple (4356,4449,4531),60)
			Result.put (new_triple (4356,4449,4532),61)
			Result.put (new_triple (4356,4449,4533),62)
			Result.put (new_triple (4356,4449,4534),63)
			Result.put (new_triple (4356,4449,4535),64)
			Result.put (new_triple (4356,4449,4536),65)
			Result.put (new_triple (4356,4449,4537),66)
			Result.put (new_triple (4356,4449,4538),67)
			Result.put (new_triple (4356,4449,4539),68)
			Result.put (new_triple (4356,4449,4540),69)
			Result.put (new_triple (4356,4449,4541),70)
			Result.put (new_triple (4356,4449,4542),71)
			Result.put (new_triple (4356,4449,4543),72)
			Result.put (new_triple (4356,4449,4544),73)
			Result.put (new_triple (4356,4449,4545),74)
			Result.put (new_triple (4356,4449,4546),75)
			Result.put (new_pair (4356,4450),76)
			Result.put (new_triple (4356,4450,4520),77)
			Result.put (new_triple (4356,4450,4521),78)
			Result.put (new_triple (4356,4450,4522),79)
			Result.put (new_triple (4356,4450,4523),80)
			Result.put (new_triple (4356,4450,4524),81)
			Result.put (new_triple (4356,4450,4525),82)
			Result.put (new_triple (4356,4450,4526),83)
			Result.put (new_triple (4356,4450,4527),84)
			Result.put (new_triple (4356,4450,4528),85)
			Result.put (new_triple (4356,4450,4529),86)
			Result.put (new_triple (4356,4450,4530),87)
			Result.put (new_triple (4356,4450,4531),88)
			Result.put (new_triple (4356,4450,4532),89)
			Result.put (new_triple (4356,4450,4533),90)
			Result.put (new_triple (4356,4450,4534),91)
			Result.put (new_triple (4356,4450,4535),92)
			Result.put (new_triple (4356,4450,4536),93)
			Result.put (new_triple (4356,4450,4537),94)
			Result.put (new_triple (4356,4450,4538),95)
			Result.put (new_triple (4356,4450,4539),96)
			Result.put (new_triple (4356,4450,4540),97)
			Result.put (new_triple (4356,4450,4541),98)
			Result.put (new_triple (4356,4450,4542),99)
			Result.put (new_triple (4356,4450,4543),100)
			Result.put (new_triple (4356,4450,4544),101)
			Result.put (new_triple (4356,4450,4545),102)
			Result.put (new_triple (4356,4450,4546),103)
			Result.put (new_pair (4356,4451),104)
			Result.put (new_triple (4356,4451,4520),105)
			Result.put (new_triple (4356,4451,4521),106)
			Result.put (new_triple (4356,4451,4522),107)
			Result.put (new_triple (4356,4451,4523),108)
			Result.put (new_triple (4356,4451,4524),109)
			Result.put (new_triple (4356,4451,4525),110)
			Result.put (new_triple (4356,4451,4526),111)
			Result.put (new_triple (4356,4451,4527),112)
			Result.put (new_triple (4356,4451,4528),113)
			Result.put (new_triple (4356,4451,4529),114)
			Result.put (new_triple (4356,4451,4530),115)
			Result.put (new_triple (4356,4451,4531),116)
			Result.put (new_triple (4356,4451,4532),117)
			Result.put (new_triple (4356,4451,4533),118)
			Result.put (new_triple (4356,4451,4534),119)
			Result.put (new_triple (4356,4451,4535),120)
			Result.put (new_triple (4356,4451,4536),121)
			Result.put (new_triple (4356,4451,4537),122)
			Result.put (new_triple (4356,4451,4538),123)
			Result.put (new_triple (4356,4451,4539),124)
			Result.put (new_triple (4356,4451,4540),125)
			Result.put (new_triple (4356,4451,4541),126)
			Result.put (new_triple (4356,4451,4542),127)
			Result.put (new_triple (4356,4451,4543),128)
			Result.put (new_triple (4356,4451,4544),129)
			Result.put (new_triple (4356,4451,4545),130)
			Result.put (new_triple (4356,4451,4546),131)
			Result.put (new_pair (4356,4452),132)
			Result.put (new_triple (4356,4452,4520),133)
			Result.put (new_triple (4356,4452,4521),134)
			Result.put (new_triple (4356,4452,4522),135)
			Result.put (new_triple (4356,4452,4523),136)
			Result.put (new_triple (4356,4452,4524),137)
			Result.put (new_triple (4356,4452,4525),138)
			Result.put (new_triple (4356,4452,4526),139)
			Result.put (new_triple (4356,4452,4527),140)
			Result.put (new_triple (4356,4452,4528),141)
			Result.put (new_triple (4356,4452,4529),142)
			Result.put (new_triple (4356,4452,4530),143)
			Result.put (new_triple (4356,4452,4531),144)
			Result.put (new_triple (4356,4452,4532),145)
			Result.put (new_triple (4356,4452,4533),146)
			Result.put (new_triple (4356,4452,4534),147)
			Result.put (new_triple (4356,4452,4535),148)
			Result.put (new_triple (4356,4452,4536),149)
			Result.put (new_triple (4356,4452,4537),150)
			Result.put (new_triple (4356,4452,4538),151)
			Result.put (new_triple (4356,4452,4539),152)
			Result.put (new_triple (4356,4452,4540),153)
			Result.put (new_triple (4356,4452,4541),154)
			Result.put (new_triple (4356,4452,4542),155)
			Result.put (new_triple (4356,4452,4543),156)
			Result.put (new_triple (4356,4452,4544),157)
			Result.put (new_triple (4356,4452,4545),158)
			Result.put (new_triple (4356,4452,4546),159)
			Result.put (new_pair (4356,4453),160)
			Result.put (new_triple (4356,4453,4520),161)
			Result.put (new_triple (4356,4453,4521),162)
			Result.put (new_triple (4356,4453,4522),163)
			Result.put (new_triple (4356,4453,4523),164)
			Result.put (new_triple (4356,4453,4524),165)
			Result.put (new_triple (4356,4453,4525),166)
			Result.put (new_triple (4356,4453,4526),167)
			Result.put (new_triple (4356,4453,4527),168)
			Result.put (new_triple (4356,4453,4528),169)
			Result.put (new_triple (4356,4453,4529),170)
			Result.put (new_triple (4356,4453,4530),171)
			Result.put (new_triple (4356,4453,4531),172)
			Result.put (new_triple (4356,4453,4532),173)
			Result.put (new_triple (4356,4453,4533),174)
			Result.put (new_triple (4356,4453,4534),175)
			Result.put (new_triple (4356,4453,4535),176)
			Result.put (new_triple (4356,4453,4536),177)
			Result.put (new_triple (4356,4453,4537),178)
			Result.put (new_triple (4356,4453,4538),179)
			Result.put (new_triple (4356,4453,4539),180)
			Result.put (new_triple (4356,4453,4540),181)
			Result.put (new_triple (4356,4453,4541),182)
			Result.put (new_triple (4356,4453,4542),183)
			Result.put (new_triple (4356,4453,4543),184)
			Result.put (new_triple (4356,4453,4544),185)
			Result.put (new_triple (4356,4453,4545),186)
			Result.put (new_triple (4356,4453,4546),187)
			Result.put (new_pair (4356,4454),188)
			Result.put (new_triple (4356,4454,4520),189)
			Result.put (new_triple (4356,4454,4521),190)
			Result.put (new_triple (4356,4454,4522),191)
			Result.put (new_triple (4356,4454,4523),192)
			Result.put (new_triple (4356,4454,4524),193)
			Result.put (new_triple (4356,4454,4525),194)
			Result.put (new_triple (4356,4454,4526),195)
			Result.put (new_triple (4356,4454,4527),196)
			Result.put (new_triple (4356,4454,4528),197)
			Result.put (new_triple (4356,4454,4529),198)
			Result.put (new_triple (4356,4454,4530),199)
			Result.put (new_triple (4356,4454,4531),200)
			Result.put (new_triple (4356,4454,4532),201)
			Result.put (new_triple (4356,4454,4533),202)
			Result.put (new_triple (4356,4454,4534),203)
			Result.put (new_triple (4356,4454,4535),204)
			Result.put (new_triple (4356,4454,4536),205)
			Result.put (new_triple (4356,4454,4537),206)
			Result.put (new_triple (4356,4454,4538),207)
			Result.put (new_triple (4356,4454,4539),208)
			Result.put (new_triple (4356,4454,4540),209)
			Result.put (new_triple (4356,4454,4541),210)
			Result.put (new_triple (4356,4454,4542),211)
			Result.put (new_triple (4356,4454,4543),212)
			Result.put (new_triple (4356,4454,4544),213)
			Result.put (new_triple (4356,4454,4545),214)
			Result.put (new_triple (4356,4454,4546),215)
			Result.put (new_pair (4356,4455),216)
			Result.put (new_triple (4356,4455,4520),217)
			Result.put (new_triple (4356,4455,4521),218)
			Result.put (new_triple (4356,4455,4522),219)
			Result.put (new_triple (4356,4455,4523),220)
			Result.put (new_triple (4356,4455,4524),221)
			Result.put (new_triple (4356,4455,4525),222)
			Result.put (new_triple (4356,4455,4526),223)
			Result.put (new_triple (4356,4455,4527),224)
			Result.put (new_triple (4356,4455,4528),225)
			Result.put (new_triple (4356,4455,4529),226)
			Result.put (new_triple (4356,4455,4530),227)
			Result.put (new_triple (4356,4455,4531),228)
			Result.put (new_triple (4356,4455,4532),229)
			Result.put (new_triple (4356,4455,4533),230)
			Result.put (new_triple (4356,4455,4534),231)
			Result.put (new_triple (4356,4455,4535),232)
			Result.put (new_triple (4356,4455,4536),233)
			Result.put (new_triple (4356,4455,4537),234)
			Result.put (new_triple (4356,4455,4538),235)
			Result.put (new_triple (4356,4455,4539),236)
			Result.put (new_triple (4356,4455,4540),237)
			Result.put (new_triple (4356,4455,4541),238)
			Result.put (new_triple (4356,4455,4542),239)
			Result.put (new_triple (4356,4455,4543),240)
			Result.put (new_triple (4356,4455,4544),241)
			Result.put (new_triple (4356,4455,4545),242)
			Result.put (new_triple (4356,4455,4546),243)
			Result.put (new_pair (4356,4456),244)
			Result.put (new_triple (4356,4456,4520),245)
			Result.put (new_triple (4356,4456,4521),246)
			Result.put (new_triple (4356,4456,4522),247)
			Result.put (new_triple (4356,4456,4523),248)
			Result.put (new_triple (4356,4456,4524),249)
			Result.put (new_triple (4356,4456,4525),250)
			Result.put (new_triple (4356,4456,4526),251)
			Result.put (new_triple (4356,4456,4527),252)
			Result.put (new_triple (4356,4456,4528),253)
			Result.put (new_triple (4356,4456,4529),254)
			Result.put (new_triple (4356,4456,4530),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_182: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4356,4456,4531),0)
			Result.put (new_triple (4356,4456,4532),1)
			Result.put (new_triple (4356,4456,4533),2)
			Result.put (new_triple (4356,4456,4534),3)
			Result.put (new_triple (4356,4456,4535),4)
			Result.put (new_triple (4356,4456,4536),5)
			Result.put (new_triple (4356,4456,4537),6)
			Result.put (new_triple (4356,4456,4538),7)
			Result.put (new_triple (4356,4456,4539),8)
			Result.put (new_triple (4356,4456,4540),9)
			Result.put (new_triple (4356,4456,4541),10)
			Result.put (new_triple (4356,4456,4542),11)
			Result.put (new_triple (4356,4456,4543),12)
			Result.put (new_triple (4356,4456,4544),13)
			Result.put (new_triple (4356,4456,4545),14)
			Result.put (new_triple (4356,4456,4546),15)
			Result.put (new_pair (4356,4457),16)
			Result.put (new_triple (4356,4457,4520),17)
			Result.put (new_triple (4356,4457,4521),18)
			Result.put (new_triple (4356,4457,4522),19)
			Result.put (new_triple (4356,4457,4523),20)
			Result.put (new_triple (4356,4457,4524),21)
			Result.put (new_triple (4356,4457,4525),22)
			Result.put (new_triple (4356,4457,4526),23)
			Result.put (new_triple (4356,4457,4527),24)
			Result.put (new_triple (4356,4457,4528),25)
			Result.put (new_triple (4356,4457,4529),26)
			Result.put (new_triple (4356,4457,4530),27)
			Result.put (new_triple (4356,4457,4531),28)
			Result.put (new_triple (4356,4457,4532),29)
			Result.put (new_triple (4356,4457,4533),30)
			Result.put (new_triple (4356,4457,4534),31)
			Result.put (new_triple (4356,4457,4535),32)
			Result.put (new_triple (4356,4457,4536),33)
			Result.put (new_triple (4356,4457,4537),34)
			Result.put (new_triple (4356,4457,4538),35)
			Result.put (new_triple (4356,4457,4539),36)
			Result.put (new_triple (4356,4457,4540),37)
			Result.put (new_triple (4356,4457,4541),38)
			Result.put (new_triple (4356,4457,4542),39)
			Result.put (new_triple (4356,4457,4543),40)
			Result.put (new_triple (4356,4457,4544),41)
			Result.put (new_triple (4356,4457,4545),42)
			Result.put (new_triple (4356,4457,4546),43)
			Result.put (new_pair (4356,4458),44)
			Result.put (new_triple (4356,4458,4520),45)
			Result.put (new_triple (4356,4458,4521),46)
			Result.put (new_triple (4356,4458,4522),47)
			Result.put (new_triple (4356,4458,4523),48)
			Result.put (new_triple (4356,4458,4524),49)
			Result.put (new_triple (4356,4458,4525),50)
			Result.put (new_triple (4356,4458,4526),51)
			Result.put (new_triple (4356,4458,4527),52)
			Result.put (new_triple (4356,4458,4528),53)
			Result.put (new_triple (4356,4458,4529),54)
			Result.put (new_triple (4356,4458,4530),55)
			Result.put (new_triple (4356,4458,4531),56)
			Result.put (new_triple (4356,4458,4532),57)
			Result.put (new_triple (4356,4458,4533),58)
			Result.put (new_triple (4356,4458,4534),59)
			Result.put (new_triple (4356,4458,4535),60)
			Result.put (new_triple (4356,4458,4536),61)
			Result.put (new_triple (4356,4458,4537),62)
			Result.put (new_triple (4356,4458,4538),63)
			Result.put (new_triple (4356,4458,4539),64)
			Result.put (new_triple (4356,4458,4540),65)
			Result.put (new_triple (4356,4458,4541),66)
			Result.put (new_triple (4356,4458,4542),67)
			Result.put (new_triple (4356,4458,4543),68)
			Result.put (new_triple (4356,4458,4544),69)
			Result.put (new_triple (4356,4458,4545),70)
			Result.put (new_triple (4356,4458,4546),71)
			Result.put (new_pair (4356,4459),72)
			Result.put (new_triple (4356,4459,4520),73)
			Result.put (new_triple (4356,4459,4521),74)
			Result.put (new_triple (4356,4459,4522),75)
			Result.put (new_triple (4356,4459,4523),76)
			Result.put (new_triple (4356,4459,4524),77)
			Result.put (new_triple (4356,4459,4525),78)
			Result.put (new_triple (4356,4459,4526),79)
			Result.put (new_triple (4356,4459,4527),80)
			Result.put (new_triple (4356,4459,4528),81)
			Result.put (new_triple (4356,4459,4529),82)
			Result.put (new_triple (4356,4459,4530),83)
			Result.put (new_triple (4356,4459,4531),84)
			Result.put (new_triple (4356,4459,4532),85)
			Result.put (new_triple (4356,4459,4533),86)
			Result.put (new_triple (4356,4459,4534),87)
			Result.put (new_triple (4356,4459,4535),88)
			Result.put (new_triple (4356,4459,4536),89)
			Result.put (new_triple (4356,4459,4537),90)
			Result.put (new_triple (4356,4459,4538),91)
			Result.put (new_triple (4356,4459,4539),92)
			Result.put (new_triple (4356,4459,4540),93)
			Result.put (new_triple (4356,4459,4541),94)
			Result.put (new_triple (4356,4459,4542),95)
			Result.put (new_triple (4356,4459,4543),96)
			Result.put (new_triple (4356,4459,4544),97)
			Result.put (new_triple (4356,4459,4545),98)
			Result.put (new_triple (4356,4459,4546),99)
			Result.put (new_pair (4356,4460),100)
			Result.put (new_triple (4356,4460,4520),101)
			Result.put (new_triple (4356,4460,4521),102)
			Result.put (new_triple (4356,4460,4522),103)
			Result.put (new_triple (4356,4460,4523),104)
			Result.put (new_triple (4356,4460,4524),105)
			Result.put (new_triple (4356,4460,4525),106)
			Result.put (new_triple (4356,4460,4526),107)
			Result.put (new_triple (4356,4460,4527),108)
			Result.put (new_triple (4356,4460,4528),109)
			Result.put (new_triple (4356,4460,4529),110)
			Result.put (new_triple (4356,4460,4530),111)
			Result.put (new_triple (4356,4460,4531),112)
			Result.put (new_triple (4356,4460,4532),113)
			Result.put (new_triple (4356,4460,4533),114)
			Result.put (new_triple (4356,4460,4534),115)
			Result.put (new_triple (4356,4460,4535),116)
			Result.put (new_triple (4356,4460,4536),117)
			Result.put (new_triple (4356,4460,4537),118)
			Result.put (new_triple (4356,4460,4538),119)
			Result.put (new_triple (4356,4460,4539),120)
			Result.put (new_triple (4356,4460,4540),121)
			Result.put (new_triple (4356,4460,4541),122)
			Result.put (new_triple (4356,4460,4542),123)
			Result.put (new_triple (4356,4460,4543),124)
			Result.put (new_triple (4356,4460,4544),125)
			Result.put (new_triple (4356,4460,4545),126)
			Result.put (new_triple (4356,4460,4546),127)
			Result.put (new_pair (4356,4461),128)
			Result.put (new_triple (4356,4461,4520),129)
			Result.put (new_triple (4356,4461,4521),130)
			Result.put (new_triple (4356,4461,4522),131)
			Result.put (new_triple (4356,4461,4523),132)
			Result.put (new_triple (4356,4461,4524),133)
			Result.put (new_triple (4356,4461,4525),134)
			Result.put (new_triple (4356,4461,4526),135)
			Result.put (new_triple (4356,4461,4527),136)
			Result.put (new_triple (4356,4461,4528),137)
			Result.put (new_triple (4356,4461,4529),138)
			Result.put (new_triple (4356,4461,4530),139)
			Result.put (new_triple (4356,4461,4531),140)
			Result.put (new_triple (4356,4461,4532),141)
			Result.put (new_triple (4356,4461,4533),142)
			Result.put (new_triple (4356,4461,4534),143)
			Result.put (new_triple (4356,4461,4535),144)
			Result.put (new_triple (4356,4461,4536),145)
			Result.put (new_triple (4356,4461,4537),146)
			Result.put (new_triple (4356,4461,4538),147)
			Result.put (new_triple (4356,4461,4539),148)
			Result.put (new_triple (4356,4461,4540),149)
			Result.put (new_triple (4356,4461,4541),150)
			Result.put (new_triple (4356,4461,4542),151)
			Result.put (new_triple (4356,4461,4543),152)
			Result.put (new_triple (4356,4461,4544),153)
			Result.put (new_triple (4356,4461,4545),154)
			Result.put (new_triple (4356,4461,4546),155)
			Result.put (new_pair (4356,4462),156)
			Result.put (new_triple (4356,4462,4520),157)
			Result.put (new_triple (4356,4462,4521),158)
			Result.put (new_triple (4356,4462,4522),159)
			Result.put (new_triple (4356,4462,4523),160)
			Result.put (new_triple (4356,4462,4524),161)
			Result.put (new_triple (4356,4462,4525),162)
			Result.put (new_triple (4356,4462,4526),163)
			Result.put (new_triple (4356,4462,4527),164)
			Result.put (new_triple (4356,4462,4528),165)
			Result.put (new_triple (4356,4462,4529),166)
			Result.put (new_triple (4356,4462,4530),167)
			Result.put (new_triple (4356,4462,4531),168)
			Result.put (new_triple (4356,4462,4532),169)
			Result.put (new_triple (4356,4462,4533),170)
			Result.put (new_triple (4356,4462,4534),171)
			Result.put (new_triple (4356,4462,4535),172)
			Result.put (new_triple (4356,4462,4536),173)
			Result.put (new_triple (4356,4462,4537),174)
			Result.put (new_triple (4356,4462,4538),175)
			Result.put (new_triple (4356,4462,4539),176)
			Result.put (new_triple (4356,4462,4540),177)
			Result.put (new_triple (4356,4462,4541),178)
			Result.put (new_triple (4356,4462,4542),179)
			Result.put (new_triple (4356,4462,4543),180)
			Result.put (new_triple (4356,4462,4544),181)
			Result.put (new_triple (4356,4462,4545),182)
			Result.put (new_triple (4356,4462,4546),183)
			Result.put (new_pair (4356,4463),184)
			Result.put (new_triple (4356,4463,4520),185)
			Result.put (new_triple (4356,4463,4521),186)
			Result.put (new_triple (4356,4463,4522),187)
			Result.put (new_triple (4356,4463,4523),188)
			Result.put (new_triple (4356,4463,4524),189)
			Result.put (new_triple (4356,4463,4525),190)
			Result.put (new_triple (4356,4463,4526),191)
			Result.put (new_triple (4356,4463,4527),192)
			Result.put (new_triple (4356,4463,4528),193)
			Result.put (new_triple (4356,4463,4529),194)
			Result.put (new_triple (4356,4463,4530),195)
			Result.put (new_triple (4356,4463,4531),196)
			Result.put (new_triple (4356,4463,4532),197)
			Result.put (new_triple (4356,4463,4533),198)
			Result.put (new_triple (4356,4463,4534),199)
			Result.put (new_triple (4356,4463,4535),200)
			Result.put (new_triple (4356,4463,4536),201)
			Result.put (new_triple (4356,4463,4537),202)
			Result.put (new_triple (4356,4463,4538),203)
			Result.put (new_triple (4356,4463,4539),204)
			Result.put (new_triple (4356,4463,4540),205)
			Result.put (new_triple (4356,4463,4541),206)
			Result.put (new_triple (4356,4463,4542),207)
			Result.put (new_triple (4356,4463,4543),208)
			Result.put (new_triple (4356,4463,4544),209)
			Result.put (new_triple (4356,4463,4545),210)
			Result.put (new_triple (4356,4463,4546),211)
			Result.put (new_pair (4356,4464),212)
			Result.put (new_triple (4356,4464,4520),213)
			Result.put (new_triple (4356,4464,4521),214)
			Result.put (new_triple (4356,4464,4522),215)
			Result.put (new_triple (4356,4464,4523),216)
			Result.put (new_triple (4356,4464,4524),217)
			Result.put (new_triple (4356,4464,4525),218)
			Result.put (new_triple (4356,4464,4526),219)
			Result.put (new_triple (4356,4464,4527),220)
			Result.put (new_triple (4356,4464,4528),221)
			Result.put (new_triple (4356,4464,4529),222)
			Result.put (new_triple (4356,4464,4530),223)
			Result.put (new_triple (4356,4464,4531),224)
			Result.put (new_triple (4356,4464,4532),225)
			Result.put (new_triple (4356,4464,4533),226)
			Result.put (new_triple (4356,4464,4534),227)
			Result.put (new_triple (4356,4464,4535),228)
			Result.put (new_triple (4356,4464,4536),229)
			Result.put (new_triple (4356,4464,4537),230)
			Result.put (new_triple (4356,4464,4538),231)
			Result.put (new_triple (4356,4464,4539),232)
			Result.put (new_triple (4356,4464,4540),233)
			Result.put (new_triple (4356,4464,4541),234)
			Result.put (new_triple (4356,4464,4542),235)
			Result.put (new_triple (4356,4464,4543),236)
			Result.put (new_triple (4356,4464,4544),237)
			Result.put (new_triple (4356,4464,4545),238)
			Result.put (new_triple (4356,4464,4546),239)
			Result.put (new_pair (4356,4465),240)
			Result.put (new_triple (4356,4465,4520),241)
			Result.put (new_triple (4356,4465,4521),242)
			Result.put (new_triple (4356,4465,4522),243)
			Result.put (new_triple (4356,4465,4523),244)
			Result.put (new_triple (4356,4465,4524),245)
			Result.put (new_triple (4356,4465,4525),246)
			Result.put (new_triple (4356,4465,4526),247)
			Result.put (new_triple (4356,4465,4527),248)
			Result.put (new_triple (4356,4465,4528),249)
			Result.put (new_triple (4356,4465,4529),250)
			Result.put (new_triple (4356,4465,4530),251)
			Result.put (new_triple (4356,4465,4531),252)
			Result.put (new_triple (4356,4465,4532),253)
			Result.put (new_triple (4356,4465,4533),254)
			Result.put (new_triple (4356,4465,4534),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_183: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4356,4465,4535),0)
			Result.put (new_triple (4356,4465,4536),1)
			Result.put (new_triple (4356,4465,4537),2)
			Result.put (new_triple (4356,4465,4538),3)
			Result.put (new_triple (4356,4465,4539),4)
			Result.put (new_triple (4356,4465,4540),5)
			Result.put (new_triple (4356,4465,4541),6)
			Result.put (new_triple (4356,4465,4542),7)
			Result.put (new_triple (4356,4465,4543),8)
			Result.put (new_triple (4356,4465,4544),9)
			Result.put (new_triple (4356,4465,4545),10)
			Result.put (new_triple (4356,4465,4546),11)
			Result.put (new_pair (4356,4466),12)
			Result.put (new_triple (4356,4466,4520),13)
			Result.put (new_triple (4356,4466,4521),14)
			Result.put (new_triple (4356,4466,4522),15)
			Result.put (new_triple (4356,4466,4523),16)
			Result.put (new_triple (4356,4466,4524),17)
			Result.put (new_triple (4356,4466,4525),18)
			Result.put (new_triple (4356,4466,4526),19)
			Result.put (new_triple (4356,4466,4527),20)
			Result.put (new_triple (4356,4466,4528),21)
			Result.put (new_triple (4356,4466,4529),22)
			Result.put (new_triple (4356,4466,4530),23)
			Result.put (new_triple (4356,4466,4531),24)
			Result.put (new_triple (4356,4466,4532),25)
			Result.put (new_triple (4356,4466,4533),26)
			Result.put (new_triple (4356,4466,4534),27)
			Result.put (new_triple (4356,4466,4535),28)
			Result.put (new_triple (4356,4466,4536),29)
			Result.put (new_triple (4356,4466,4537),30)
			Result.put (new_triple (4356,4466,4538),31)
			Result.put (new_triple (4356,4466,4539),32)
			Result.put (new_triple (4356,4466,4540),33)
			Result.put (new_triple (4356,4466,4541),34)
			Result.put (new_triple (4356,4466,4542),35)
			Result.put (new_triple (4356,4466,4543),36)
			Result.put (new_triple (4356,4466,4544),37)
			Result.put (new_triple (4356,4466,4545),38)
			Result.put (new_triple (4356,4466,4546),39)
			Result.put (new_pair (4356,4467),40)
			Result.put (new_triple (4356,4467,4520),41)
			Result.put (new_triple (4356,4467,4521),42)
			Result.put (new_triple (4356,4467,4522),43)
			Result.put (new_triple (4356,4467,4523),44)
			Result.put (new_triple (4356,4467,4524),45)
			Result.put (new_triple (4356,4467,4525),46)
			Result.put (new_triple (4356,4467,4526),47)
			Result.put (new_triple (4356,4467,4527),48)
			Result.put (new_triple (4356,4467,4528),49)
			Result.put (new_triple (4356,4467,4529),50)
			Result.put (new_triple (4356,4467,4530),51)
			Result.put (new_triple (4356,4467,4531),52)
			Result.put (new_triple (4356,4467,4532),53)
			Result.put (new_triple (4356,4467,4533),54)
			Result.put (new_triple (4356,4467,4534),55)
			Result.put (new_triple (4356,4467,4535),56)
			Result.put (new_triple (4356,4467,4536),57)
			Result.put (new_triple (4356,4467,4537),58)
			Result.put (new_triple (4356,4467,4538),59)
			Result.put (new_triple (4356,4467,4539),60)
			Result.put (new_triple (4356,4467,4540),61)
			Result.put (new_triple (4356,4467,4541),62)
			Result.put (new_triple (4356,4467,4542),63)
			Result.put (new_triple (4356,4467,4543),64)
			Result.put (new_triple (4356,4467,4544),65)
			Result.put (new_triple (4356,4467,4545),66)
			Result.put (new_triple (4356,4467,4546),67)
			Result.put (new_pair (4356,4468),68)
			Result.put (new_triple (4356,4468,4520),69)
			Result.put (new_triple (4356,4468,4521),70)
			Result.put (new_triple (4356,4468,4522),71)
			Result.put (new_triple (4356,4468,4523),72)
			Result.put (new_triple (4356,4468,4524),73)
			Result.put (new_triple (4356,4468,4525),74)
			Result.put (new_triple (4356,4468,4526),75)
			Result.put (new_triple (4356,4468,4527),76)
			Result.put (new_triple (4356,4468,4528),77)
			Result.put (new_triple (4356,4468,4529),78)
			Result.put (new_triple (4356,4468,4530),79)
			Result.put (new_triple (4356,4468,4531),80)
			Result.put (new_triple (4356,4468,4532),81)
			Result.put (new_triple (4356,4468,4533),82)
			Result.put (new_triple (4356,4468,4534),83)
			Result.put (new_triple (4356,4468,4535),84)
			Result.put (new_triple (4356,4468,4536),85)
			Result.put (new_triple (4356,4468,4537),86)
			Result.put (new_triple (4356,4468,4538),87)
			Result.put (new_triple (4356,4468,4539),88)
			Result.put (new_triple (4356,4468,4540),89)
			Result.put (new_triple (4356,4468,4541),90)
			Result.put (new_triple (4356,4468,4542),91)
			Result.put (new_triple (4356,4468,4543),92)
			Result.put (new_triple (4356,4468,4544),93)
			Result.put (new_triple (4356,4468,4545),94)
			Result.put (new_triple (4356,4468,4546),95)
			Result.put (new_pair (4356,4469),96)
			Result.put (new_triple (4356,4469,4520),97)
			Result.put (new_triple (4356,4469,4521),98)
			Result.put (new_triple (4356,4469,4522),99)
			Result.put (new_triple (4356,4469,4523),100)
			Result.put (new_triple (4356,4469,4524),101)
			Result.put (new_triple (4356,4469,4525),102)
			Result.put (new_triple (4356,4469,4526),103)
			Result.put (new_triple (4356,4469,4527),104)
			Result.put (new_triple (4356,4469,4528),105)
			Result.put (new_triple (4356,4469,4529),106)
			Result.put (new_triple (4356,4469,4530),107)
			Result.put (new_triple (4356,4469,4531),108)
			Result.put (new_triple (4356,4469,4532),109)
			Result.put (new_triple (4356,4469,4533),110)
			Result.put (new_triple (4356,4469,4534),111)
			Result.put (new_triple (4356,4469,4535),112)
			Result.put (new_triple (4356,4469,4536),113)
			Result.put (new_triple (4356,4469,4537),114)
			Result.put (new_triple (4356,4469,4538),115)
			Result.put (new_triple (4356,4469,4539),116)
			Result.put (new_triple (4356,4469,4540),117)
			Result.put (new_triple (4356,4469,4541),118)
			Result.put (new_triple (4356,4469,4542),119)
			Result.put (new_triple (4356,4469,4543),120)
			Result.put (new_triple (4356,4469,4544),121)
			Result.put (new_triple (4356,4469,4545),122)
			Result.put (new_triple (4356,4469,4546),123)
			Result.put (new_pair (4357,4449),124)
			Result.put (new_triple (4357,4449,4520),125)
			Result.put (new_triple (4357,4449,4521),126)
			Result.put (new_triple (4357,4449,4522),127)
			Result.put (new_triple (4357,4449,4523),128)
			Result.put (new_triple (4357,4449,4524),129)
			Result.put (new_triple (4357,4449,4525),130)
			Result.put (new_triple (4357,4449,4526),131)
			Result.put (new_triple (4357,4449,4527),132)
			Result.put (new_triple (4357,4449,4528),133)
			Result.put (new_triple (4357,4449,4529),134)
			Result.put (new_triple (4357,4449,4530),135)
			Result.put (new_triple (4357,4449,4531),136)
			Result.put (new_triple (4357,4449,4532),137)
			Result.put (new_triple (4357,4449,4533),138)
			Result.put (new_triple (4357,4449,4534),139)
			Result.put (new_triple (4357,4449,4535),140)
			Result.put (new_triple (4357,4449,4536),141)
			Result.put (new_triple (4357,4449,4537),142)
			Result.put (new_triple (4357,4449,4538),143)
			Result.put (new_triple (4357,4449,4539),144)
			Result.put (new_triple (4357,4449,4540),145)
			Result.put (new_triple (4357,4449,4541),146)
			Result.put (new_triple (4357,4449,4542),147)
			Result.put (new_triple (4357,4449,4543),148)
			Result.put (new_triple (4357,4449,4544),149)
			Result.put (new_triple (4357,4449,4545),150)
			Result.put (new_triple (4357,4449,4546),151)
			Result.put (new_pair (4357,4450),152)
			Result.put (new_triple (4357,4450,4520),153)
			Result.put (new_triple (4357,4450,4521),154)
			Result.put (new_triple (4357,4450,4522),155)
			Result.put (new_triple (4357,4450,4523),156)
			Result.put (new_triple (4357,4450,4524),157)
			Result.put (new_triple (4357,4450,4525),158)
			Result.put (new_triple (4357,4450,4526),159)
			Result.put (new_triple (4357,4450,4527),160)
			Result.put (new_triple (4357,4450,4528),161)
			Result.put (new_triple (4357,4450,4529),162)
			Result.put (new_triple (4357,4450,4530),163)
			Result.put (new_triple (4357,4450,4531),164)
			Result.put (new_triple (4357,4450,4532),165)
			Result.put (new_triple (4357,4450,4533),166)
			Result.put (new_triple (4357,4450,4534),167)
			Result.put (new_triple (4357,4450,4535),168)
			Result.put (new_triple (4357,4450,4536),169)
			Result.put (new_triple (4357,4450,4537),170)
			Result.put (new_triple (4357,4450,4538),171)
			Result.put (new_triple (4357,4450,4539),172)
			Result.put (new_triple (4357,4450,4540),173)
			Result.put (new_triple (4357,4450,4541),174)
			Result.put (new_triple (4357,4450,4542),175)
			Result.put (new_triple (4357,4450,4543),176)
			Result.put (new_triple (4357,4450,4544),177)
			Result.put (new_triple (4357,4450,4545),178)
			Result.put (new_triple (4357,4450,4546),179)
			Result.put (new_pair (4357,4451),180)
			Result.put (new_triple (4357,4451,4520),181)
			Result.put (new_triple (4357,4451,4521),182)
			Result.put (new_triple (4357,4451,4522),183)
			Result.put (new_triple (4357,4451,4523),184)
			Result.put (new_triple (4357,4451,4524),185)
			Result.put (new_triple (4357,4451,4525),186)
			Result.put (new_triple (4357,4451,4526),187)
			Result.put (new_triple (4357,4451,4527),188)
			Result.put (new_triple (4357,4451,4528),189)
			Result.put (new_triple (4357,4451,4529),190)
			Result.put (new_triple (4357,4451,4530),191)
			Result.put (new_triple (4357,4451,4531),192)
			Result.put (new_triple (4357,4451,4532),193)
			Result.put (new_triple (4357,4451,4533),194)
			Result.put (new_triple (4357,4451,4534),195)
			Result.put (new_triple (4357,4451,4535),196)
			Result.put (new_triple (4357,4451,4536),197)
			Result.put (new_triple (4357,4451,4537),198)
			Result.put (new_triple (4357,4451,4538),199)
			Result.put (new_triple (4357,4451,4539),200)
			Result.put (new_triple (4357,4451,4540),201)
			Result.put (new_triple (4357,4451,4541),202)
			Result.put (new_triple (4357,4451,4542),203)
			Result.put (new_triple (4357,4451,4543),204)
			Result.put (new_triple (4357,4451,4544),205)
			Result.put (new_triple (4357,4451,4545),206)
			Result.put (new_triple (4357,4451,4546),207)
			Result.put (new_pair (4357,4452),208)
			Result.put (new_triple (4357,4452,4520),209)
			Result.put (new_triple (4357,4452,4521),210)
			Result.put (new_triple (4357,4452,4522),211)
			Result.put (new_triple (4357,4452,4523),212)
			Result.put (new_triple (4357,4452,4524),213)
			Result.put (new_triple (4357,4452,4525),214)
			Result.put (new_triple (4357,4452,4526),215)
			Result.put (new_triple (4357,4452,4527),216)
			Result.put (new_triple (4357,4452,4528),217)
			Result.put (new_triple (4357,4452,4529),218)
			Result.put (new_triple (4357,4452,4530),219)
			Result.put (new_triple (4357,4452,4531),220)
			Result.put (new_triple (4357,4452,4532),221)
			Result.put (new_triple (4357,4452,4533),222)
			Result.put (new_triple (4357,4452,4534),223)
			Result.put (new_triple (4357,4452,4535),224)
			Result.put (new_triple (4357,4452,4536),225)
			Result.put (new_triple (4357,4452,4537),226)
			Result.put (new_triple (4357,4452,4538),227)
			Result.put (new_triple (4357,4452,4539),228)
			Result.put (new_triple (4357,4452,4540),229)
			Result.put (new_triple (4357,4452,4541),230)
			Result.put (new_triple (4357,4452,4542),231)
			Result.put (new_triple (4357,4452,4543),232)
			Result.put (new_triple (4357,4452,4544),233)
			Result.put (new_triple (4357,4452,4545),234)
			Result.put (new_triple (4357,4452,4546),235)
			Result.put (new_pair (4357,4453),236)
			Result.put (new_triple (4357,4453,4520),237)
			Result.put (new_triple (4357,4453,4521),238)
			Result.put (new_triple (4357,4453,4522),239)
			Result.put (new_triple (4357,4453,4523),240)
			Result.put (new_triple (4357,4453,4524),241)
			Result.put (new_triple (4357,4453,4525),242)
			Result.put (new_triple (4357,4453,4526),243)
			Result.put (new_triple (4357,4453,4527),244)
			Result.put (new_triple (4357,4453,4528),245)
			Result.put (new_triple (4357,4453,4529),246)
			Result.put (new_triple (4357,4453,4530),247)
			Result.put (new_triple (4357,4453,4531),248)
			Result.put (new_triple (4357,4453,4532),249)
			Result.put (new_triple (4357,4453,4533),250)
			Result.put (new_triple (4357,4453,4534),251)
			Result.put (new_triple (4357,4453,4535),252)
			Result.put (new_triple (4357,4453,4536),253)
			Result.put (new_triple (4357,4453,4537),254)
			Result.put (new_triple (4357,4453,4538),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_184: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4357,4453,4539),0)
			Result.put (new_triple (4357,4453,4540),1)
			Result.put (new_triple (4357,4453,4541),2)
			Result.put (new_triple (4357,4453,4542),3)
			Result.put (new_triple (4357,4453,4543),4)
			Result.put (new_triple (4357,4453,4544),5)
			Result.put (new_triple (4357,4453,4545),6)
			Result.put (new_triple (4357,4453,4546),7)
			Result.put (new_pair (4357,4454),8)
			Result.put (new_triple (4357,4454,4520),9)
			Result.put (new_triple (4357,4454,4521),10)
			Result.put (new_triple (4357,4454,4522),11)
			Result.put (new_triple (4357,4454,4523),12)
			Result.put (new_triple (4357,4454,4524),13)
			Result.put (new_triple (4357,4454,4525),14)
			Result.put (new_triple (4357,4454,4526),15)
			Result.put (new_triple (4357,4454,4527),16)
			Result.put (new_triple (4357,4454,4528),17)
			Result.put (new_triple (4357,4454,4529),18)
			Result.put (new_triple (4357,4454,4530),19)
			Result.put (new_triple (4357,4454,4531),20)
			Result.put (new_triple (4357,4454,4532),21)
			Result.put (new_triple (4357,4454,4533),22)
			Result.put (new_triple (4357,4454,4534),23)
			Result.put (new_triple (4357,4454,4535),24)
			Result.put (new_triple (4357,4454,4536),25)
			Result.put (new_triple (4357,4454,4537),26)
			Result.put (new_triple (4357,4454,4538),27)
			Result.put (new_triple (4357,4454,4539),28)
			Result.put (new_triple (4357,4454,4540),29)
			Result.put (new_triple (4357,4454,4541),30)
			Result.put (new_triple (4357,4454,4542),31)
			Result.put (new_triple (4357,4454,4543),32)
			Result.put (new_triple (4357,4454,4544),33)
			Result.put (new_triple (4357,4454,4545),34)
			Result.put (new_triple (4357,4454,4546),35)
			Result.put (new_pair (4357,4455),36)
			Result.put (new_triple (4357,4455,4520),37)
			Result.put (new_triple (4357,4455,4521),38)
			Result.put (new_triple (4357,4455,4522),39)
			Result.put (new_triple (4357,4455,4523),40)
			Result.put (new_triple (4357,4455,4524),41)
			Result.put (new_triple (4357,4455,4525),42)
			Result.put (new_triple (4357,4455,4526),43)
			Result.put (new_triple (4357,4455,4527),44)
			Result.put (new_triple (4357,4455,4528),45)
			Result.put (new_triple (4357,4455,4529),46)
			Result.put (new_triple (4357,4455,4530),47)
			Result.put (new_triple (4357,4455,4531),48)
			Result.put (new_triple (4357,4455,4532),49)
			Result.put (new_triple (4357,4455,4533),50)
			Result.put (new_triple (4357,4455,4534),51)
			Result.put (new_triple (4357,4455,4535),52)
			Result.put (new_triple (4357,4455,4536),53)
			Result.put (new_triple (4357,4455,4537),54)
			Result.put (new_triple (4357,4455,4538),55)
			Result.put (new_triple (4357,4455,4539),56)
			Result.put (new_triple (4357,4455,4540),57)
			Result.put (new_triple (4357,4455,4541),58)
			Result.put (new_triple (4357,4455,4542),59)
			Result.put (new_triple (4357,4455,4543),60)
			Result.put (new_triple (4357,4455,4544),61)
			Result.put (new_triple (4357,4455,4545),62)
			Result.put (new_triple (4357,4455,4546),63)
			Result.put (new_pair (4357,4456),64)
			Result.put (new_triple (4357,4456,4520),65)
			Result.put (new_triple (4357,4456,4521),66)
			Result.put (new_triple (4357,4456,4522),67)
			Result.put (new_triple (4357,4456,4523),68)
			Result.put (new_triple (4357,4456,4524),69)
			Result.put (new_triple (4357,4456,4525),70)
			Result.put (new_triple (4357,4456,4526),71)
			Result.put (new_triple (4357,4456,4527),72)
			Result.put (new_triple (4357,4456,4528),73)
			Result.put (new_triple (4357,4456,4529),74)
			Result.put (new_triple (4357,4456,4530),75)
			Result.put (new_triple (4357,4456,4531),76)
			Result.put (new_triple (4357,4456,4532),77)
			Result.put (new_triple (4357,4456,4533),78)
			Result.put (new_triple (4357,4456,4534),79)
			Result.put (new_triple (4357,4456,4535),80)
			Result.put (new_triple (4357,4456,4536),81)
			Result.put (new_triple (4357,4456,4537),82)
			Result.put (new_triple (4357,4456,4538),83)
			Result.put (new_triple (4357,4456,4539),84)
			Result.put (new_triple (4357,4456,4540),85)
			Result.put (new_triple (4357,4456,4541),86)
			Result.put (new_triple (4357,4456,4542),87)
			Result.put (new_triple (4357,4456,4543),88)
			Result.put (new_triple (4357,4456,4544),89)
			Result.put (new_triple (4357,4456,4545),90)
			Result.put (new_triple (4357,4456,4546),91)
			Result.put (new_pair (4357,4457),92)
			Result.put (new_triple (4357,4457,4520),93)
			Result.put (new_triple (4357,4457,4521),94)
			Result.put (new_triple (4357,4457,4522),95)
			Result.put (new_triple (4357,4457,4523),96)
			Result.put (new_triple (4357,4457,4524),97)
			Result.put (new_triple (4357,4457,4525),98)
			Result.put (new_triple (4357,4457,4526),99)
			Result.put (new_triple (4357,4457,4527),100)
			Result.put (new_triple (4357,4457,4528),101)
			Result.put (new_triple (4357,4457,4529),102)
			Result.put (new_triple (4357,4457,4530),103)
			Result.put (new_triple (4357,4457,4531),104)
			Result.put (new_triple (4357,4457,4532),105)
			Result.put (new_triple (4357,4457,4533),106)
			Result.put (new_triple (4357,4457,4534),107)
			Result.put (new_triple (4357,4457,4535),108)
			Result.put (new_triple (4357,4457,4536),109)
			Result.put (new_triple (4357,4457,4537),110)
			Result.put (new_triple (4357,4457,4538),111)
			Result.put (new_triple (4357,4457,4539),112)
			Result.put (new_triple (4357,4457,4540),113)
			Result.put (new_triple (4357,4457,4541),114)
			Result.put (new_triple (4357,4457,4542),115)
			Result.put (new_triple (4357,4457,4543),116)
			Result.put (new_triple (4357,4457,4544),117)
			Result.put (new_triple (4357,4457,4545),118)
			Result.put (new_triple (4357,4457,4546),119)
			Result.put (new_pair (4357,4458),120)
			Result.put (new_triple (4357,4458,4520),121)
			Result.put (new_triple (4357,4458,4521),122)
			Result.put (new_triple (4357,4458,4522),123)
			Result.put (new_triple (4357,4458,4523),124)
			Result.put (new_triple (4357,4458,4524),125)
			Result.put (new_triple (4357,4458,4525),126)
			Result.put (new_triple (4357,4458,4526),127)
			Result.put (new_triple (4357,4458,4527),128)
			Result.put (new_triple (4357,4458,4528),129)
			Result.put (new_triple (4357,4458,4529),130)
			Result.put (new_triple (4357,4458,4530),131)
			Result.put (new_triple (4357,4458,4531),132)
			Result.put (new_triple (4357,4458,4532),133)
			Result.put (new_triple (4357,4458,4533),134)
			Result.put (new_triple (4357,4458,4534),135)
			Result.put (new_triple (4357,4458,4535),136)
			Result.put (new_triple (4357,4458,4536),137)
			Result.put (new_triple (4357,4458,4537),138)
			Result.put (new_triple (4357,4458,4538),139)
			Result.put (new_triple (4357,4458,4539),140)
			Result.put (new_triple (4357,4458,4540),141)
			Result.put (new_triple (4357,4458,4541),142)
			Result.put (new_triple (4357,4458,4542),143)
			Result.put (new_triple (4357,4458,4543),144)
			Result.put (new_triple (4357,4458,4544),145)
			Result.put (new_triple (4357,4458,4545),146)
			Result.put (new_triple (4357,4458,4546),147)
			Result.put (new_pair (4357,4459),148)
			Result.put (new_triple (4357,4459,4520),149)
			Result.put (new_triple (4357,4459,4521),150)
			Result.put (new_triple (4357,4459,4522),151)
			Result.put (new_triple (4357,4459,4523),152)
			Result.put (new_triple (4357,4459,4524),153)
			Result.put (new_triple (4357,4459,4525),154)
			Result.put (new_triple (4357,4459,4526),155)
			Result.put (new_triple (4357,4459,4527),156)
			Result.put (new_triple (4357,4459,4528),157)
			Result.put (new_triple (4357,4459,4529),158)
			Result.put (new_triple (4357,4459,4530),159)
			Result.put (new_triple (4357,4459,4531),160)
			Result.put (new_triple (4357,4459,4532),161)
			Result.put (new_triple (4357,4459,4533),162)
			Result.put (new_triple (4357,4459,4534),163)
			Result.put (new_triple (4357,4459,4535),164)
			Result.put (new_triple (4357,4459,4536),165)
			Result.put (new_triple (4357,4459,4537),166)
			Result.put (new_triple (4357,4459,4538),167)
			Result.put (new_triple (4357,4459,4539),168)
			Result.put (new_triple (4357,4459,4540),169)
			Result.put (new_triple (4357,4459,4541),170)
			Result.put (new_triple (4357,4459,4542),171)
			Result.put (new_triple (4357,4459,4543),172)
			Result.put (new_triple (4357,4459,4544),173)
			Result.put (new_triple (4357,4459,4545),174)
			Result.put (new_triple (4357,4459,4546),175)
			Result.put (new_pair (4357,4460),176)
			Result.put (new_triple (4357,4460,4520),177)
			Result.put (new_triple (4357,4460,4521),178)
			Result.put (new_triple (4357,4460,4522),179)
			Result.put (new_triple (4357,4460,4523),180)
			Result.put (new_triple (4357,4460,4524),181)
			Result.put (new_triple (4357,4460,4525),182)
			Result.put (new_triple (4357,4460,4526),183)
			Result.put (new_triple (4357,4460,4527),184)
			Result.put (new_triple (4357,4460,4528),185)
			Result.put (new_triple (4357,4460,4529),186)
			Result.put (new_triple (4357,4460,4530),187)
			Result.put (new_triple (4357,4460,4531),188)
			Result.put (new_triple (4357,4460,4532),189)
			Result.put (new_triple (4357,4460,4533),190)
			Result.put (new_triple (4357,4460,4534),191)
			Result.put (new_triple (4357,4460,4535),192)
			Result.put (new_triple (4357,4460,4536),193)
			Result.put (new_triple (4357,4460,4537),194)
			Result.put (new_triple (4357,4460,4538),195)
			Result.put (new_triple (4357,4460,4539),196)
			Result.put (new_triple (4357,4460,4540),197)
			Result.put (new_triple (4357,4460,4541),198)
			Result.put (new_triple (4357,4460,4542),199)
			Result.put (new_triple (4357,4460,4543),200)
			Result.put (new_triple (4357,4460,4544),201)
			Result.put (new_triple (4357,4460,4545),202)
			Result.put (new_triple (4357,4460,4546),203)
			Result.put (new_pair (4357,4461),204)
			Result.put (new_triple (4357,4461,4520),205)
			Result.put (new_triple (4357,4461,4521),206)
			Result.put (new_triple (4357,4461,4522),207)
			Result.put (new_triple (4357,4461,4523),208)
			Result.put (new_triple (4357,4461,4524),209)
			Result.put (new_triple (4357,4461,4525),210)
			Result.put (new_triple (4357,4461,4526),211)
			Result.put (new_triple (4357,4461,4527),212)
			Result.put (new_triple (4357,4461,4528),213)
			Result.put (new_triple (4357,4461,4529),214)
			Result.put (new_triple (4357,4461,4530),215)
			Result.put (new_triple (4357,4461,4531),216)
			Result.put (new_triple (4357,4461,4532),217)
			Result.put (new_triple (4357,4461,4533),218)
			Result.put (new_triple (4357,4461,4534),219)
			Result.put (new_triple (4357,4461,4535),220)
			Result.put (new_triple (4357,4461,4536),221)
			Result.put (new_triple (4357,4461,4537),222)
			Result.put (new_triple (4357,4461,4538),223)
			Result.put (new_triple (4357,4461,4539),224)
			Result.put (new_triple (4357,4461,4540),225)
			Result.put (new_triple (4357,4461,4541),226)
			Result.put (new_triple (4357,4461,4542),227)
			Result.put (new_triple (4357,4461,4543),228)
			Result.put (new_triple (4357,4461,4544),229)
			Result.put (new_triple (4357,4461,4545),230)
			Result.put (new_triple (4357,4461,4546),231)
			Result.put (new_pair (4357,4462),232)
			Result.put (new_triple (4357,4462,4520),233)
			Result.put (new_triple (4357,4462,4521),234)
			Result.put (new_triple (4357,4462,4522),235)
			Result.put (new_triple (4357,4462,4523),236)
			Result.put (new_triple (4357,4462,4524),237)
			Result.put (new_triple (4357,4462,4525),238)
			Result.put (new_triple (4357,4462,4526),239)
			Result.put (new_triple (4357,4462,4527),240)
			Result.put (new_triple (4357,4462,4528),241)
			Result.put (new_triple (4357,4462,4529),242)
			Result.put (new_triple (4357,4462,4530),243)
			Result.put (new_triple (4357,4462,4531),244)
			Result.put (new_triple (4357,4462,4532),245)
			Result.put (new_triple (4357,4462,4533),246)
			Result.put (new_triple (4357,4462,4534),247)
			Result.put (new_triple (4357,4462,4535),248)
			Result.put (new_triple (4357,4462,4536),249)
			Result.put (new_triple (4357,4462,4537),250)
			Result.put (new_triple (4357,4462,4538),251)
			Result.put (new_triple (4357,4462,4539),252)
			Result.put (new_triple (4357,4462,4540),253)
			Result.put (new_triple (4357,4462,4541),254)
			Result.put (new_triple (4357,4462,4542),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_185: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4357,4462,4543),0)
			Result.put (new_triple (4357,4462,4544),1)
			Result.put (new_triple (4357,4462,4545),2)
			Result.put (new_triple (4357,4462,4546),3)
			Result.put (new_pair (4357,4463),4)
			Result.put (new_triple (4357,4463,4520),5)
			Result.put (new_triple (4357,4463,4521),6)
			Result.put (new_triple (4357,4463,4522),7)
			Result.put (new_triple (4357,4463,4523),8)
			Result.put (new_triple (4357,4463,4524),9)
			Result.put (new_triple (4357,4463,4525),10)
			Result.put (new_triple (4357,4463,4526),11)
			Result.put (new_triple (4357,4463,4527),12)
			Result.put (new_triple (4357,4463,4528),13)
			Result.put (new_triple (4357,4463,4529),14)
			Result.put (new_triple (4357,4463,4530),15)
			Result.put (new_triple (4357,4463,4531),16)
			Result.put (new_triple (4357,4463,4532),17)
			Result.put (new_triple (4357,4463,4533),18)
			Result.put (new_triple (4357,4463,4534),19)
			Result.put (new_triple (4357,4463,4535),20)
			Result.put (new_triple (4357,4463,4536),21)
			Result.put (new_triple (4357,4463,4537),22)
			Result.put (new_triple (4357,4463,4538),23)
			Result.put (new_triple (4357,4463,4539),24)
			Result.put (new_triple (4357,4463,4540),25)
			Result.put (new_triple (4357,4463,4541),26)
			Result.put (new_triple (4357,4463,4542),27)
			Result.put (new_triple (4357,4463,4543),28)
			Result.put (new_triple (4357,4463,4544),29)
			Result.put (new_triple (4357,4463,4545),30)
			Result.put (new_triple (4357,4463,4546),31)
			Result.put (new_pair (4357,4464),32)
			Result.put (new_triple (4357,4464,4520),33)
			Result.put (new_triple (4357,4464,4521),34)
			Result.put (new_triple (4357,4464,4522),35)
			Result.put (new_triple (4357,4464,4523),36)
			Result.put (new_triple (4357,4464,4524),37)
			Result.put (new_triple (4357,4464,4525),38)
			Result.put (new_triple (4357,4464,4526),39)
			Result.put (new_triple (4357,4464,4527),40)
			Result.put (new_triple (4357,4464,4528),41)
			Result.put (new_triple (4357,4464,4529),42)
			Result.put (new_triple (4357,4464,4530),43)
			Result.put (new_triple (4357,4464,4531),44)
			Result.put (new_triple (4357,4464,4532),45)
			Result.put (new_triple (4357,4464,4533),46)
			Result.put (new_triple (4357,4464,4534),47)
			Result.put (new_triple (4357,4464,4535),48)
			Result.put (new_triple (4357,4464,4536),49)
			Result.put (new_triple (4357,4464,4537),50)
			Result.put (new_triple (4357,4464,4538),51)
			Result.put (new_triple (4357,4464,4539),52)
			Result.put (new_triple (4357,4464,4540),53)
			Result.put (new_triple (4357,4464,4541),54)
			Result.put (new_triple (4357,4464,4542),55)
			Result.put (new_triple (4357,4464,4543),56)
			Result.put (new_triple (4357,4464,4544),57)
			Result.put (new_triple (4357,4464,4545),58)
			Result.put (new_triple (4357,4464,4546),59)
			Result.put (new_pair (4357,4465),60)
			Result.put (new_triple (4357,4465,4520),61)
			Result.put (new_triple (4357,4465,4521),62)
			Result.put (new_triple (4357,4465,4522),63)
			Result.put (new_triple (4357,4465,4523),64)
			Result.put (new_triple (4357,4465,4524),65)
			Result.put (new_triple (4357,4465,4525),66)
			Result.put (new_triple (4357,4465,4526),67)
			Result.put (new_triple (4357,4465,4527),68)
			Result.put (new_triple (4357,4465,4528),69)
			Result.put (new_triple (4357,4465,4529),70)
			Result.put (new_triple (4357,4465,4530),71)
			Result.put (new_triple (4357,4465,4531),72)
			Result.put (new_triple (4357,4465,4532),73)
			Result.put (new_triple (4357,4465,4533),74)
			Result.put (new_triple (4357,4465,4534),75)
			Result.put (new_triple (4357,4465,4535),76)
			Result.put (new_triple (4357,4465,4536),77)
			Result.put (new_triple (4357,4465,4537),78)
			Result.put (new_triple (4357,4465,4538),79)
			Result.put (new_triple (4357,4465,4539),80)
			Result.put (new_triple (4357,4465,4540),81)
			Result.put (new_triple (4357,4465,4541),82)
			Result.put (new_triple (4357,4465,4542),83)
			Result.put (new_triple (4357,4465,4543),84)
			Result.put (new_triple (4357,4465,4544),85)
			Result.put (new_triple (4357,4465,4545),86)
			Result.put (new_triple (4357,4465,4546),87)
			Result.put (new_pair (4357,4466),88)
			Result.put (new_triple (4357,4466,4520),89)
			Result.put (new_triple (4357,4466,4521),90)
			Result.put (new_triple (4357,4466,4522),91)
			Result.put (new_triple (4357,4466,4523),92)
			Result.put (new_triple (4357,4466,4524),93)
			Result.put (new_triple (4357,4466,4525),94)
			Result.put (new_triple (4357,4466,4526),95)
			Result.put (new_triple (4357,4466,4527),96)
			Result.put (new_triple (4357,4466,4528),97)
			Result.put (new_triple (4357,4466,4529),98)
			Result.put (new_triple (4357,4466,4530),99)
			Result.put (new_triple (4357,4466,4531),100)
			Result.put (new_triple (4357,4466,4532),101)
			Result.put (new_triple (4357,4466,4533),102)
			Result.put (new_triple (4357,4466,4534),103)
			Result.put (new_triple (4357,4466,4535),104)
			Result.put (new_triple (4357,4466,4536),105)
			Result.put (new_triple (4357,4466,4537),106)
			Result.put (new_triple (4357,4466,4538),107)
			Result.put (new_triple (4357,4466,4539),108)
			Result.put (new_triple (4357,4466,4540),109)
			Result.put (new_triple (4357,4466,4541),110)
			Result.put (new_triple (4357,4466,4542),111)
			Result.put (new_triple (4357,4466,4543),112)
			Result.put (new_triple (4357,4466,4544),113)
			Result.put (new_triple (4357,4466,4545),114)
			Result.put (new_triple (4357,4466,4546),115)
			Result.put (new_pair (4357,4467),116)
			Result.put (new_triple (4357,4467,4520),117)
			Result.put (new_triple (4357,4467,4521),118)
			Result.put (new_triple (4357,4467,4522),119)
			Result.put (new_triple (4357,4467,4523),120)
			Result.put (new_triple (4357,4467,4524),121)
			Result.put (new_triple (4357,4467,4525),122)
			Result.put (new_triple (4357,4467,4526),123)
			Result.put (new_triple (4357,4467,4527),124)
			Result.put (new_triple (4357,4467,4528),125)
			Result.put (new_triple (4357,4467,4529),126)
			Result.put (new_triple (4357,4467,4530),127)
			Result.put (new_triple (4357,4467,4531),128)
			Result.put (new_triple (4357,4467,4532),129)
			Result.put (new_triple (4357,4467,4533),130)
			Result.put (new_triple (4357,4467,4534),131)
			Result.put (new_triple (4357,4467,4535),132)
			Result.put (new_triple (4357,4467,4536),133)
			Result.put (new_triple (4357,4467,4537),134)
			Result.put (new_triple (4357,4467,4538),135)
			Result.put (new_triple (4357,4467,4539),136)
			Result.put (new_triple (4357,4467,4540),137)
			Result.put (new_triple (4357,4467,4541),138)
			Result.put (new_triple (4357,4467,4542),139)
			Result.put (new_triple (4357,4467,4543),140)
			Result.put (new_triple (4357,4467,4544),141)
			Result.put (new_triple (4357,4467,4545),142)
			Result.put (new_triple (4357,4467,4546),143)
			Result.put (new_pair (4357,4468),144)
			Result.put (new_triple (4357,4468,4520),145)
			Result.put (new_triple (4357,4468,4521),146)
			Result.put (new_triple (4357,4468,4522),147)
			Result.put (new_triple (4357,4468,4523),148)
			Result.put (new_triple (4357,4468,4524),149)
			Result.put (new_triple (4357,4468,4525),150)
			Result.put (new_triple (4357,4468,4526),151)
			Result.put (new_triple (4357,4468,4527),152)
			Result.put (new_triple (4357,4468,4528),153)
			Result.put (new_triple (4357,4468,4529),154)
			Result.put (new_triple (4357,4468,4530),155)
			Result.put (new_triple (4357,4468,4531),156)
			Result.put (new_triple (4357,4468,4532),157)
			Result.put (new_triple (4357,4468,4533),158)
			Result.put (new_triple (4357,4468,4534),159)
			Result.put (new_triple (4357,4468,4535),160)
			Result.put (new_triple (4357,4468,4536),161)
			Result.put (new_triple (4357,4468,4537),162)
			Result.put (new_triple (4357,4468,4538),163)
			Result.put (new_triple (4357,4468,4539),164)
			Result.put (new_triple (4357,4468,4540),165)
			Result.put (new_triple (4357,4468,4541),166)
			Result.put (new_triple (4357,4468,4542),167)
			Result.put (new_triple (4357,4468,4543),168)
			Result.put (new_triple (4357,4468,4544),169)
			Result.put (new_triple (4357,4468,4545),170)
			Result.put (new_triple (4357,4468,4546),171)
			Result.put (new_pair (4357,4469),172)
			Result.put (new_triple (4357,4469,4520),173)
			Result.put (new_triple (4357,4469,4521),174)
			Result.put (new_triple (4357,4469,4522),175)
			Result.put (new_triple (4357,4469,4523),176)
			Result.put (new_triple (4357,4469,4524),177)
			Result.put (new_triple (4357,4469,4525),178)
			Result.put (new_triple (4357,4469,4526),179)
			Result.put (new_triple (4357,4469,4527),180)
			Result.put (new_triple (4357,4469,4528),181)
			Result.put (new_triple (4357,4469,4529),182)
			Result.put (new_triple (4357,4469,4530),183)
			Result.put (new_triple (4357,4469,4531),184)
			Result.put (new_triple (4357,4469,4532),185)
			Result.put (new_triple (4357,4469,4533),186)
			Result.put (new_triple (4357,4469,4534),187)
			Result.put (new_triple (4357,4469,4535),188)
			Result.put (new_triple (4357,4469,4536),189)
			Result.put (new_triple (4357,4469,4537),190)
			Result.put (new_triple (4357,4469,4538),191)
			Result.put (new_triple (4357,4469,4539),192)
			Result.put (new_triple (4357,4469,4540),193)
			Result.put (new_triple (4357,4469,4541),194)
			Result.put (new_triple (4357,4469,4542),195)
			Result.put (new_triple (4357,4469,4543),196)
			Result.put (new_triple (4357,4469,4544),197)
			Result.put (new_triple (4357,4469,4545),198)
			Result.put (new_triple (4357,4469,4546),199)
			Result.put (new_pair (4358,4449),200)
			Result.put (new_triple (4358,4449,4520),201)
			Result.put (new_triple (4358,4449,4521),202)
			Result.put (new_triple (4358,4449,4522),203)
			Result.put (new_triple (4358,4449,4523),204)
			Result.put (new_triple (4358,4449,4524),205)
			Result.put (new_triple (4358,4449,4525),206)
			Result.put (new_triple (4358,4449,4526),207)
			Result.put (new_triple (4358,4449,4527),208)
			Result.put (new_triple (4358,4449,4528),209)
			Result.put (new_triple (4358,4449,4529),210)
			Result.put (new_triple (4358,4449,4530),211)
			Result.put (new_triple (4358,4449,4531),212)
			Result.put (new_triple (4358,4449,4532),213)
			Result.put (new_triple (4358,4449,4533),214)
			Result.put (new_triple (4358,4449,4534),215)
			Result.put (new_triple (4358,4449,4535),216)
			Result.put (new_triple (4358,4449,4536),217)
			Result.put (new_triple (4358,4449,4537),218)
			Result.put (new_triple (4358,4449,4538),219)
			Result.put (new_triple (4358,4449,4539),220)
			Result.put (new_triple (4358,4449,4540),221)
			Result.put (new_triple (4358,4449,4541),222)
			Result.put (new_triple (4358,4449,4542),223)
			Result.put (new_triple (4358,4449,4543),224)
			Result.put (new_triple (4358,4449,4544),225)
			Result.put (new_triple (4358,4449,4545),226)
			Result.put (new_triple (4358,4449,4546),227)
			Result.put (new_pair (4358,4450),228)
			Result.put (new_triple (4358,4450,4520),229)
			Result.put (new_triple (4358,4450,4521),230)
			Result.put (new_triple (4358,4450,4522),231)
			Result.put (new_triple (4358,4450,4523),232)
			Result.put (new_triple (4358,4450,4524),233)
			Result.put (new_triple (4358,4450,4525),234)
			Result.put (new_triple (4358,4450,4526),235)
			Result.put (new_triple (4358,4450,4527),236)
			Result.put (new_triple (4358,4450,4528),237)
			Result.put (new_triple (4358,4450,4529),238)
			Result.put (new_triple (4358,4450,4530),239)
			Result.put (new_triple (4358,4450,4531),240)
			Result.put (new_triple (4358,4450,4532),241)
			Result.put (new_triple (4358,4450,4533),242)
			Result.put (new_triple (4358,4450,4534),243)
			Result.put (new_triple (4358,4450,4535),244)
			Result.put (new_triple (4358,4450,4536),245)
			Result.put (new_triple (4358,4450,4537),246)
			Result.put (new_triple (4358,4450,4538),247)
			Result.put (new_triple (4358,4450,4539),248)
			Result.put (new_triple (4358,4450,4540),249)
			Result.put (new_triple (4358,4450,4541),250)
			Result.put (new_triple (4358,4450,4542),251)
			Result.put (new_triple (4358,4450,4543),252)
			Result.put (new_triple (4358,4450,4544),253)
			Result.put (new_triple (4358,4450,4545),254)
			Result.put (new_triple (4358,4450,4546),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_186: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (4358,4451),0)
			Result.put (new_triple (4358,4451,4520),1)
			Result.put (new_triple (4358,4451,4521),2)
			Result.put (new_triple (4358,4451,4522),3)
			Result.put (new_triple (4358,4451,4523),4)
			Result.put (new_triple (4358,4451,4524),5)
			Result.put (new_triple (4358,4451,4525),6)
			Result.put (new_triple (4358,4451,4526),7)
			Result.put (new_triple (4358,4451,4527),8)
			Result.put (new_triple (4358,4451,4528),9)
			Result.put (new_triple (4358,4451,4529),10)
			Result.put (new_triple (4358,4451,4530),11)
			Result.put (new_triple (4358,4451,4531),12)
			Result.put (new_triple (4358,4451,4532),13)
			Result.put (new_triple (4358,4451,4533),14)
			Result.put (new_triple (4358,4451,4534),15)
			Result.put (new_triple (4358,4451,4535),16)
			Result.put (new_triple (4358,4451,4536),17)
			Result.put (new_triple (4358,4451,4537),18)
			Result.put (new_triple (4358,4451,4538),19)
			Result.put (new_triple (4358,4451,4539),20)
			Result.put (new_triple (4358,4451,4540),21)
			Result.put (new_triple (4358,4451,4541),22)
			Result.put (new_triple (4358,4451,4542),23)
			Result.put (new_triple (4358,4451,4543),24)
			Result.put (new_triple (4358,4451,4544),25)
			Result.put (new_triple (4358,4451,4545),26)
			Result.put (new_triple (4358,4451,4546),27)
			Result.put (new_pair (4358,4452),28)
			Result.put (new_triple (4358,4452,4520),29)
			Result.put (new_triple (4358,4452,4521),30)
			Result.put (new_triple (4358,4452,4522),31)
			Result.put (new_triple (4358,4452,4523),32)
			Result.put (new_triple (4358,4452,4524),33)
			Result.put (new_triple (4358,4452,4525),34)
			Result.put (new_triple (4358,4452,4526),35)
			Result.put (new_triple (4358,4452,4527),36)
			Result.put (new_triple (4358,4452,4528),37)
			Result.put (new_triple (4358,4452,4529),38)
			Result.put (new_triple (4358,4452,4530),39)
			Result.put (new_triple (4358,4452,4531),40)
			Result.put (new_triple (4358,4452,4532),41)
			Result.put (new_triple (4358,4452,4533),42)
			Result.put (new_triple (4358,4452,4534),43)
			Result.put (new_triple (4358,4452,4535),44)
			Result.put (new_triple (4358,4452,4536),45)
			Result.put (new_triple (4358,4452,4537),46)
			Result.put (new_triple (4358,4452,4538),47)
			Result.put (new_triple (4358,4452,4539),48)
			Result.put (new_triple (4358,4452,4540),49)
			Result.put (new_triple (4358,4452,4541),50)
			Result.put (new_triple (4358,4452,4542),51)
			Result.put (new_triple (4358,4452,4543),52)
			Result.put (new_triple (4358,4452,4544),53)
			Result.put (new_triple (4358,4452,4545),54)
			Result.put (new_triple (4358,4452,4546),55)
			Result.put (new_pair (4358,4453),56)
			Result.put (new_triple (4358,4453,4520),57)
			Result.put (new_triple (4358,4453,4521),58)
			Result.put (new_triple (4358,4453,4522),59)
			Result.put (new_triple (4358,4453,4523),60)
			Result.put (new_triple (4358,4453,4524),61)
			Result.put (new_triple (4358,4453,4525),62)
			Result.put (new_triple (4358,4453,4526),63)
			Result.put (new_triple (4358,4453,4527),64)
			Result.put (new_triple (4358,4453,4528),65)
			Result.put (new_triple (4358,4453,4529),66)
			Result.put (new_triple (4358,4453,4530),67)
			Result.put (new_triple (4358,4453,4531),68)
			Result.put (new_triple (4358,4453,4532),69)
			Result.put (new_triple (4358,4453,4533),70)
			Result.put (new_triple (4358,4453,4534),71)
			Result.put (new_triple (4358,4453,4535),72)
			Result.put (new_triple (4358,4453,4536),73)
			Result.put (new_triple (4358,4453,4537),74)
			Result.put (new_triple (4358,4453,4538),75)
			Result.put (new_triple (4358,4453,4539),76)
			Result.put (new_triple (4358,4453,4540),77)
			Result.put (new_triple (4358,4453,4541),78)
			Result.put (new_triple (4358,4453,4542),79)
			Result.put (new_triple (4358,4453,4543),80)
			Result.put (new_triple (4358,4453,4544),81)
			Result.put (new_triple (4358,4453,4545),82)
			Result.put (new_triple (4358,4453,4546),83)
			Result.put (new_pair (4358,4454),84)
			Result.put (new_triple (4358,4454,4520),85)
			Result.put (new_triple (4358,4454,4521),86)
			Result.put (new_triple (4358,4454,4522),87)
			Result.put (new_triple (4358,4454,4523),88)
			Result.put (new_triple (4358,4454,4524),89)
			Result.put (new_triple (4358,4454,4525),90)
			Result.put (new_triple (4358,4454,4526),91)
			Result.put (new_triple (4358,4454,4527),92)
			Result.put (new_triple (4358,4454,4528),93)
			Result.put (new_triple (4358,4454,4529),94)
			Result.put (new_triple (4358,4454,4530),95)
			Result.put (new_triple (4358,4454,4531),96)
			Result.put (new_triple (4358,4454,4532),97)
			Result.put (new_triple (4358,4454,4533),98)
			Result.put (new_triple (4358,4454,4534),99)
			Result.put (new_triple (4358,4454,4535),100)
			Result.put (new_triple (4358,4454,4536),101)
			Result.put (new_triple (4358,4454,4537),102)
			Result.put (new_triple (4358,4454,4538),103)
			Result.put (new_triple (4358,4454,4539),104)
			Result.put (new_triple (4358,4454,4540),105)
			Result.put (new_triple (4358,4454,4541),106)
			Result.put (new_triple (4358,4454,4542),107)
			Result.put (new_triple (4358,4454,4543),108)
			Result.put (new_triple (4358,4454,4544),109)
			Result.put (new_triple (4358,4454,4545),110)
			Result.put (new_triple (4358,4454,4546),111)
			Result.put (new_pair (4358,4455),112)
			Result.put (new_triple (4358,4455,4520),113)
			Result.put (new_triple (4358,4455,4521),114)
			Result.put (new_triple (4358,4455,4522),115)
			Result.put (new_triple (4358,4455,4523),116)
			Result.put (new_triple (4358,4455,4524),117)
			Result.put (new_triple (4358,4455,4525),118)
			Result.put (new_triple (4358,4455,4526),119)
			Result.put (new_triple (4358,4455,4527),120)
			Result.put (new_triple (4358,4455,4528),121)
			Result.put (new_triple (4358,4455,4529),122)
			Result.put (new_triple (4358,4455,4530),123)
			Result.put (new_triple (4358,4455,4531),124)
			Result.put (new_triple (4358,4455,4532),125)
			Result.put (new_triple (4358,4455,4533),126)
			Result.put (new_triple (4358,4455,4534),127)
			Result.put (new_triple (4358,4455,4535),128)
			Result.put (new_triple (4358,4455,4536),129)
			Result.put (new_triple (4358,4455,4537),130)
			Result.put (new_triple (4358,4455,4538),131)
			Result.put (new_triple (4358,4455,4539),132)
			Result.put (new_triple (4358,4455,4540),133)
			Result.put (new_triple (4358,4455,4541),134)
			Result.put (new_triple (4358,4455,4542),135)
			Result.put (new_triple (4358,4455,4543),136)
			Result.put (new_triple (4358,4455,4544),137)
			Result.put (new_triple (4358,4455,4545),138)
			Result.put (new_triple (4358,4455,4546),139)
			Result.put (new_pair (4358,4456),140)
			Result.put (new_triple (4358,4456,4520),141)
			Result.put (new_triple (4358,4456,4521),142)
			Result.put (new_triple (4358,4456,4522),143)
			Result.put (new_triple (4358,4456,4523),144)
			Result.put (new_triple (4358,4456,4524),145)
			Result.put (new_triple (4358,4456,4525),146)
			Result.put (new_triple (4358,4456,4526),147)
			Result.put (new_triple (4358,4456,4527),148)
			Result.put (new_triple (4358,4456,4528),149)
			Result.put (new_triple (4358,4456,4529),150)
			Result.put (new_triple (4358,4456,4530),151)
			Result.put (new_triple (4358,4456,4531),152)
			Result.put (new_triple (4358,4456,4532),153)
			Result.put (new_triple (4358,4456,4533),154)
			Result.put (new_triple (4358,4456,4534),155)
			Result.put (new_triple (4358,4456,4535),156)
			Result.put (new_triple (4358,4456,4536),157)
			Result.put (new_triple (4358,4456,4537),158)
			Result.put (new_triple (4358,4456,4538),159)
			Result.put (new_triple (4358,4456,4539),160)
			Result.put (new_triple (4358,4456,4540),161)
			Result.put (new_triple (4358,4456,4541),162)
			Result.put (new_triple (4358,4456,4542),163)
			Result.put (new_triple (4358,4456,4543),164)
			Result.put (new_triple (4358,4456,4544),165)
			Result.put (new_triple (4358,4456,4545),166)
			Result.put (new_triple (4358,4456,4546),167)
			Result.put (new_pair (4358,4457),168)
			Result.put (new_triple (4358,4457,4520),169)
			Result.put (new_triple (4358,4457,4521),170)
			Result.put (new_triple (4358,4457,4522),171)
			Result.put (new_triple (4358,4457,4523),172)
			Result.put (new_triple (4358,4457,4524),173)
			Result.put (new_triple (4358,4457,4525),174)
			Result.put (new_triple (4358,4457,4526),175)
			Result.put (new_triple (4358,4457,4527),176)
			Result.put (new_triple (4358,4457,4528),177)
			Result.put (new_triple (4358,4457,4529),178)
			Result.put (new_triple (4358,4457,4530),179)
			Result.put (new_triple (4358,4457,4531),180)
			Result.put (new_triple (4358,4457,4532),181)
			Result.put (new_triple (4358,4457,4533),182)
			Result.put (new_triple (4358,4457,4534),183)
			Result.put (new_triple (4358,4457,4535),184)
			Result.put (new_triple (4358,4457,4536),185)
			Result.put (new_triple (4358,4457,4537),186)
			Result.put (new_triple (4358,4457,4538),187)
			Result.put (new_triple (4358,4457,4539),188)
			Result.put (new_triple (4358,4457,4540),189)
			Result.put (new_triple (4358,4457,4541),190)
			Result.put (new_triple (4358,4457,4542),191)
			Result.put (new_triple (4358,4457,4543),192)
			Result.put (new_triple (4358,4457,4544),193)
			Result.put (new_triple (4358,4457,4545),194)
			Result.put (new_triple (4358,4457,4546),195)
			Result.put (new_pair (4358,4458),196)
			Result.put (new_triple (4358,4458,4520),197)
			Result.put (new_triple (4358,4458,4521),198)
			Result.put (new_triple (4358,4458,4522),199)
			Result.put (new_triple (4358,4458,4523),200)
			Result.put (new_triple (4358,4458,4524),201)
			Result.put (new_triple (4358,4458,4525),202)
			Result.put (new_triple (4358,4458,4526),203)
			Result.put (new_triple (4358,4458,4527),204)
			Result.put (new_triple (4358,4458,4528),205)
			Result.put (new_triple (4358,4458,4529),206)
			Result.put (new_triple (4358,4458,4530),207)
			Result.put (new_triple (4358,4458,4531),208)
			Result.put (new_triple (4358,4458,4532),209)
			Result.put (new_triple (4358,4458,4533),210)
			Result.put (new_triple (4358,4458,4534),211)
			Result.put (new_triple (4358,4458,4535),212)
			Result.put (new_triple (4358,4458,4536),213)
			Result.put (new_triple (4358,4458,4537),214)
			Result.put (new_triple (4358,4458,4538),215)
			Result.put (new_triple (4358,4458,4539),216)
			Result.put (new_triple (4358,4458,4540),217)
			Result.put (new_triple (4358,4458,4541),218)
			Result.put (new_triple (4358,4458,4542),219)
			Result.put (new_triple (4358,4458,4543),220)
			Result.put (new_triple (4358,4458,4544),221)
			Result.put (new_triple (4358,4458,4545),222)
			Result.put (new_triple (4358,4458,4546),223)
			Result.put (new_pair (4358,4459),224)
			Result.put (new_triple (4358,4459,4520),225)
			Result.put (new_triple (4358,4459,4521),226)
			Result.put (new_triple (4358,4459,4522),227)
			Result.put (new_triple (4358,4459,4523),228)
			Result.put (new_triple (4358,4459,4524),229)
			Result.put (new_triple (4358,4459,4525),230)
			Result.put (new_triple (4358,4459,4526),231)
			Result.put (new_triple (4358,4459,4527),232)
			Result.put (new_triple (4358,4459,4528),233)
			Result.put (new_triple (4358,4459,4529),234)
			Result.put (new_triple (4358,4459,4530),235)
			Result.put (new_triple (4358,4459,4531),236)
			Result.put (new_triple (4358,4459,4532),237)
			Result.put (new_triple (4358,4459,4533),238)
			Result.put (new_triple (4358,4459,4534),239)
			Result.put (new_triple (4358,4459,4535),240)
			Result.put (new_triple (4358,4459,4536),241)
			Result.put (new_triple (4358,4459,4537),242)
			Result.put (new_triple (4358,4459,4538),243)
			Result.put (new_triple (4358,4459,4539),244)
			Result.put (new_triple (4358,4459,4540),245)
			Result.put (new_triple (4358,4459,4541),246)
			Result.put (new_triple (4358,4459,4542),247)
			Result.put (new_triple (4358,4459,4543),248)
			Result.put (new_triple (4358,4459,4544),249)
			Result.put (new_triple (4358,4459,4545),250)
			Result.put (new_triple (4358,4459,4546),251)
			Result.put (new_pair (4358,4460),252)
			Result.put (new_triple (4358,4460,4520),253)
			Result.put (new_triple (4358,4460,4521),254)
			Result.put (new_triple (4358,4460,4522),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_187: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4358,4460,4523),0)
			Result.put (new_triple (4358,4460,4524),1)
			Result.put (new_triple (4358,4460,4525),2)
			Result.put (new_triple (4358,4460,4526),3)
			Result.put (new_triple (4358,4460,4527),4)
			Result.put (new_triple (4358,4460,4528),5)
			Result.put (new_triple (4358,4460,4529),6)
			Result.put (new_triple (4358,4460,4530),7)
			Result.put (new_triple (4358,4460,4531),8)
			Result.put (new_triple (4358,4460,4532),9)
			Result.put (new_triple (4358,4460,4533),10)
			Result.put (new_triple (4358,4460,4534),11)
			Result.put (new_triple (4358,4460,4535),12)
			Result.put (new_triple (4358,4460,4536),13)
			Result.put (new_triple (4358,4460,4537),14)
			Result.put (new_triple (4358,4460,4538),15)
			Result.put (new_triple (4358,4460,4539),16)
			Result.put (new_triple (4358,4460,4540),17)
			Result.put (new_triple (4358,4460,4541),18)
			Result.put (new_triple (4358,4460,4542),19)
			Result.put (new_triple (4358,4460,4543),20)
			Result.put (new_triple (4358,4460,4544),21)
			Result.put (new_triple (4358,4460,4545),22)
			Result.put (new_triple (4358,4460,4546),23)
			Result.put (new_pair (4358,4461),24)
			Result.put (new_triple (4358,4461,4520),25)
			Result.put (new_triple (4358,4461,4521),26)
			Result.put (new_triple (4358,4461,4522),27)
			Result.put (new_triple (4358,4461,4523),28)
			Result.put (new_triple (4358,4461,4524),29)
			Result.put (new_triple (4358,4461,4525),30)
			Result.put (new_triple (4358,4461,4526),31)
			Result.put (new_triple (4358,4461,4527),32)
			Result.put (new_triple (4358,4461,4528),33)
			Result.put (new_triple (4358,4461,4529),34)
			Result.put (new_triple (4358,4461,4530),35)
			Result.put (new_triple (4358,4461,4531),36)
			Result.put (new_triple (4358,4461,4532),37)
			Result.put (new_triple (4358,4461,4533),38)
			Result.put (new_triple (4358,4461,4534),39)
			Result.put (new_triple (4358,4461,4535),40)
			Result.put (new_triple (4358,4461,4536),41)
			Result.put (new_triple (4358,4461,4537),42)
			Result.put (new_triple (4358,4461,4538),43)
			Result.put (new_triple (4358,4461,4539),44)
			Result.put (new_triple (4358,4461,4540),45)
			Result.put (new_triple (4358,4461,4541),46)
			Result.put (new_triple (4358,4461,4542),47)
			Result.put (new_triple (4358,4461,4543),48)
			Result.put (new_triple (4358,4461,4544),49)
			Result.put (new_triple (4358,4461,4545),50)
			Result.put (new_triple (4358,4461,4546),51)
			Result.put (new_pair (4358,4462),52)
			Result.put (new_triple (4358,4462,4520),53)
			Result.put (new_triple (4358,4462,4521),54)
			Result.put (new_triple (4358,4462,4522),55)
			Result.put (new_triple (4358,4462,4523),56)
			Result.put (new_triple (4358,4462,4524),57)
			Result.put (new_triple (4358,4462,4525),58)
			Result.put (new_triple (4358,4462,4526),59)
			Result.put (new_triple (4358,4462,4527),60)
			Result.put (new_triple (4358,4462,4528),61)
			Result.put (new_triple (4358,4462,4529),62)
			Result.put (new_triple (4358,4462,4530),63)
			Result.put (new_triple (4358,4462,4531),64)
			Result.put (new_triple (4358,4462,4532),65)
			Result.put (new_triple (4358,4462,4533),66)
			Result.put (new_triple (4358,4462,4534),67)
			Result.put (new_triple (4358,4462,4535),68)
			Result.put (new_triple (4358,4462,4536),69)
			Result.put (new_triple (4358,4462,4537),70)
			Result.put (new_triple (4358,4462,4538),71)
			Result.put (new_triple (4358,4462,4539),72)
			Result.put (new_triple (4358,4462,4540),73)
			Result.put (new_triple (4358,4462,4541),74)
			Result.put (new_triple (4358,4462,4542),75)
			Result.put (new_triple (4358,4462,4543),76)
			Result.put (new_triple (4358,4462,4544),77)
			Result.put (new_triple (4358,4462,4545),78)
			Result.put (new_triple (4358,4462,4546),79)
			Result.put (new_pair (4358,4463),80)
			Result.put (new_triple (4358,4463,4520),81)
			Result.put (new_triple (4358,4463,4521),82)
			Result.put (new_triple (4358,4463,4522),83)
			Result.put (new_triple (4358,4463,4523),84)
			Result.put (new_triple (4358,4463,4524),85)
			Result.put (new_triple (4358,4463,4525),86)
			Result.put (new_triple (4358,4463,4526),87)
			Result.put (new_triple (4358,4463,4527),88)
			Result.put (new_triple (4358,4463,4528),89)
			Result.put (new_triple (4358,4463,4529),90)
			Result.put (new_triple (4358,4463,4530),91)
			Result.put (new_triple (4358,4463,4531),92)
			Result.put (new_triple (4358,4463,4532),93)
			Result.put (new_triple (4358,4463,4533),94)
			Result.put (new_triple (4358,4463,4534),95)
			Result.put (new_triple (4358,4463,4535),96)
			Result.put (new_triple (4358,4463,4536),97)
			Result.put (new_triple (4358,4463,4537),98)
			Result.put (new_triple (4358,4463,4538),99)
			Result.put (new_triple (4358,4463,4539),100)
			Result.put (new_triple (4358,4463,4540),101)
			Result.put (new_triple (4358,4463,4541),102)
			Result.put (new_triple (4358,4463,4542),103)
			Result.put (new_triple (4358,4463,4543),104)
			Result.put (new_triple (4358,4463,4544),105)
			Result.put (new_triple (4358,4463,4545),106)
			Result.put (new_triple (4358,4463,4546),107)
			Result.put (new_pair (4358,4464),108)
			Result.put (new_triple (4358,4464,4520),109)
			Result.put (new_triple (4358,4464,4521),110)
			Result.put (new_triple (4358,4464,4522),111)
			Result.put (new_triple (4358,4464,4523),112)
			Result.put (new_triple (4358,4464,4524),113)
			Result.put (new_triple (4358,4464,4525),114)
			Result.put (new_triple (4358,4464,4526),115)
			Result.put (new_triple (4358,4464,4527),116)
			Result.put (new_triple (4358,4464,4528),117)
			Result.put (new_triple (4358,4464,4529),118)
			Result.put (new_triple (4358,4464,4530),119)
			Result.put (new_triple (4358,4464,4531),120)
			Result.put (new_triple (4358,4464,4532),121)
			Result.put (new_triple (4358,4464,4533),122)
			Result.put (new_triple (4358,4464,4534),123)
			Result.put (new_triple (4358,4464,4535),124)
			Result.put (new_triple (4358,4464,4536),125)
			Result.put (new_triple (4358,4464,4537),126)
			Result.put (new_triple (4358,4464,4538),127)
			Result.put (new_triple (4358,4464,4539),128)
			Result.put (new_triple (4358,4464,4540),129)
			Result.put (new_triple (4358,4464,4541),130)
			Result.put (new_triple (4358,4464,4542),131)
			Result.put (new_triple (4358,4464,4543),132)
			Result.put (new_triple (4358,4464,4544),133)
			Result.put (new_triple (4358,4464,4545),134)
			Result.put (new_triple (4358,4464,4546),135)
			Result.put (new_pair (4358,4465),136)
			Result.put (new_triple (4358,4465,4520),137)
			Result.put (new_triple (4358,4465,4521),138)
			Result.put (new_triple (4358,4465,4522),139)
			Result.put (new_triple (4358,4465,4523),140)
			Result.put (new_triple (4358,4465,4524),141)
			Result.put (new_triple (4358,4465,4525),142)
			Result.put (new_triple (4358,4465,4526),143)
			Result.put (new_triple (4358,4465,4527),144)
			Result.put (new_triple (4358,4465,4528),145)
			Result.put (new_triple (4358,4465,4529),146)
			Result.put (new_triple (4358,4465,4530),147)
			Result.put (new_triple (4358,4465,4531),148)
			Result.put (new_triple (4358,4465,4532),149)
			Result.put (new_triple (4358,4465,4533),150)
			Result.put (new_triple (4358,4465,4534),151)
			Result.put (new_triple (4358,4465,4535),152)
			Result.put (new_triple (4358,4465,4536),153)
			Result.put (new_triple (4358,4465,4537),154)
			Result.put (new_triple (4358,4465,4538),155)
			Result.put (new_triple (4358,4465,4539),156)
			Result.put (new_triple (4358,4465,4540),157)
			Result.put (new_triple (4358,4465,4541),158)
			Result.put (new_triple (4358,4465,4542),159)
			Result.put (new_triple (4358,4465,4543),160)
			Result.put (new_triple (4358,4465,4544),161)
			Result.put (new_triple (4358,4465,4545),162)
			Result.put (new_triple (4358,4465,4546),163)
			Result.put (new_pair (4358,4466),164)
			Result.put (new_triple (4358,4466,4520),165)
			Result.put (new_triple (4358,4466,4521),166)
			Result.put (new_triple (4358,4466,4522),167)
			Result.put (new_triple (4358,4466,4523),168)
			Result.put (new_triple (4358,4466,4524),169)
			Result.put (new_triple (4358,4466,4525),170)
			Result.put (new_triple (4358,4466,4526),171)
			Result.put (new_triple (4358,4466,4527),172)
			Result.put (new_triple (4358,4466,4528),173)
			Result.put (new_triple (4358,4466,4529),174)
			Result.put (new_triple (4358,4466,4530),175)
			Result.put (new_triple (4358,4466,4531),176)
			Result.put (new_triple (4358,4466,4532),177)
			Result.put (new_triple (4358,4466,4533),178)
			Result.put (new_triple (4358,4466,4534),179)
			Result.put (new_triple (4358,4466,4535),180)
			Result.put (new_triple (4358,4466,4536),181)
			Result.put (new_triple (4358,4466,4537),182)
			Result.put (new_triple (4358,4466,4538),183)
			Result.put (new_triple (4358,4466,4539),184)
			Result.put (new_triple (4358,4466,4540),185)
			Result.put (new_triple (4358,4466,4541),186)
			Result.put (new_triple (4358,4466,4542),187)
			Result.put (new_triple (4358,4466,4543),188)
			Result.put (new_triple (4358,4466,4544),189)
			Result.put (new_triple (4358,4466,4545),190)
			Result.put (new_triple (4358,4466,4546),191)
			Result.put (new_pair (4358,4467),192)
			Result.put (new_triple (4358,4467,4520),193)
			Result.put (new_triple (4358,4467,4521),194)
			Result.put (new_triple (4358,4467,4522),195)
			Result.put (new_triple (4358,4467,4523),196)
			Result.put (new_triple (4358,4467,4524),197)
			Result.put (new_triple (4358,4467,4525),198)
			Result.put (new_triple (4358,4467,4526),199)
			Result.put (new_triple (4358,4467,4527),200)
			Result.put (new_triple (4358,4467,4528),201)
			Result.put (new_triple (4358,4467,4529),202)
			Result.put (new_triple (4358,4467,4530),203)
			Result.put (new_triple (4358,4467,4531),204)
			Result.put (new_triple (4358,4467,4532),205)
			Result.put (new_triple (4358,4467,4533),206)
			Result.put (new_triple (4358,4467,4534),207)
			Result.put (new_triple (4358,4467,4535),208)
			Result.put (new_triple (4358,4467,4536),209)
			Result.put (new_triple (4358,4467,4537),210)
			Result.put (new_triple (4358,4467,4538),211)
			Result.put (new_triple (4358,4467,4539),212)
			Result.put (new_triple (4358,4467,4540),213)
			Result.put (new_triple (4358,4467,4541),214)
			Result.put (new_triple (4358,4467,4542),215)
			Result.put (new_triple (4358,4467,4543),216)
			Result.put (new_triple (4358,4467,4544),217)
			Result.put (new_triple (4358,4467,4545),218)
			Result.put (new_triple (4358,4467,4546),219)
			Result.put (new_pair (4358,4468),220)
			Result.put (new_triple (4358,4468,4520),221)
			Result.put (new_triple (4358,4468,4521),222)
			Result.put (new_triple (4358,4468,4522),223)
			Result.put (new_triple (4358,4468,4523),224)
			Result.put (new_triple (4358,4468,4524),225)
			Result.put (new_triple (4358,4468,4525),226)
			Result.put (new_triple (4358,4468,4526),227)
			Result.put (new_triple (4358,4468,4527),228)
			Result.put (new_triple (4358,4468,4528),229)
			Result.put (new_triple (4358,4468,4529),230)
			Result.put (new_triple (4358,4468,4530),231)
			Result.put (new_triple (4358,4468,4531),232)
			Result.put (new_triple (4358,4468,4532),233)
			Result.put (new_triple (4358,4468,4533),234)
			Result.put (new_triple (4358,4468,4534),235)
			Result.put (new_triple (4358,4468,4535),236)
			Result.put (new_triple (4358,4468,4536),237)
			Result.put (new_triple (4358,4468,4537),238)
			Result.put (new_triple (4358,4468,4538),239)
			Result.put (new_triple (4358,4468,4539),240)
			Result.put (new_triple (4358,4468,4540),241)
			Result.put (new_triple (4358,4468,4541),242)
			Result.put (new_triple (4358,4468,4542),243)
			Result.put (new_triple (4358,4468,4543),244)
			Result.put (new_triple (4358,4468,4544),245)
			Result.put (new_triple (4358,4468,4545),246)
			Result.put (new_triple (4358,4468,4546),247)
			Result.put (new_pair (4358,4469),248)
			Result.put (new_triple (4358,4469,4520),249)
			Result.put (new_triple (4358,4469,4521),250)
			Result.put (new_triple (4358,4469,4522),251)
			Result.put (new_triple (4358,4469,4523),252)
			Result.put (new_triple (4358,4469,4524),253)
			Result.put (new_triple (4358,4469,4525),254)
			Result.put (new_triple (4358,4469,4526),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_188: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4358,4469,4527),0)
			Result.put (new_triple (4358,4469,4528),1)
			Result.put (new_triple (4358,4469,4529),2)
			Result.put (new_triple (4358,4469,4530),3)
			Result.put (new_triple (4358,4469,4531),4)
			Result.put (new_triple (4358,4469,4532),5)
			Result.put (new_triple (4358,4469,4533),6)
			Result.put (new_triple (4358,4469,4534),7)
			Result.put (new_triple (4358,4469,4535),8)
			Result.put (new_triple (4358,4469,4536),9)
			Result.put (new_triple (4358,4469,4537),10)
			Result.put (new_triple (4358,4469,4538),11)
			Result.put (new_triple (4358,4469,4539),12)
			Result.put (new_triple (4358,4469,4540),13)
			Result.put (new_triple (4358,4469,4541),14)
			Result.put (new_triple (4358,4469,4542),15)
			Result.put (new_triple (4358,4469,4543),16)
			Result.put (new_triple (4358,4469,4544),17)
			Result.put (new_triple (4358,4469,4545),18)
			Result.put (new_triple (4358,4469,4546),19)
			Result.put (new_pair (4359,4449),20)
			Result.put (new_triple (4359,4449,4520),21)
			Result.put (new_triple (4359,4449,4521),22)
			Result.put (new_triple (4359,4449,4522),23)
			Result.put (new_triple (4359,4449,4523),24)
			Result.put (new_triple (4359,4449,4524),25)
			Result.put (new_triple (4359,4449,4525),26)
			Result.put (new_triple (4359,4449,4526),27)
			Result.put (new_triple (4359,4449,4527),28)
			Result.put (new_triple (4359,4449,4528),29)
			Result.put (new_triple (4359,4449,4529),30)
			Result.put (new_triple (4359,4449,4530),31)
			Result.put (new_triple (4359,4449,4531),32)
			Result.put (new_triple (4359,4449,4532),33)
			Result.put (new_triple (4359,4449,4533),34)
			Result.put (new_triple (4359,4449,4534),35)
			Result.put (new_triple (4359,4449,4535),36)
			Result.put (new_triple (4359,4449,4536),37)
			Result.put (new_triple (4359,4449,4537),38)
			Result.put (new_triple (4359,4449,4538),39)
			Result.put (new_triple (4359,4449,4539),40)
			Result.put (new_triple (4359,4449,4540),41)
			Result.put (new_triple (4359,4449,4541),42)
			Result.put (new_triple (4359,4449,4542),43)
			Result.put (new_triple (4359,4449,4543),44)
			Result.put (new_triple (4359,4449,4544),45)
			Result.put (new_triple (4359,4449,4545),46)
			Result.put (new_triple (4359,4449,4546),47)
			Result.put (new_pair (4359,4450),48)
			Result.put (new_triple (4359,4450,4520),49)
			Result.put (new_triple (4359,4450,4521),50)
			Result.put (new_triple (4359,4450,4522),51)
			Result.put (new_triple (4359,4450,4523),52)
			Result.put (new_triple (4359,4450,4524),53)
			Result.put (new_triple (4359,4450,4525),54)
			Result.put (new_triple (4359,4450,4526),55)
			Result.put (new_triple (4359,4450,4527),56)
			Result.put (new_triple (4359,4450,4528),57)
			Result.put (new_triple (4359,4450,4529),58)
			Result.put (new_triple (4359,4450,4530),59)
			Result.put (new_triple (4359,4450,4531),60)
			Result.put (new_triple (4359,4450,4532),61)
			Result.put (new_triple (4359,4450,4533),62)
			Result.put (new_triple (4359,4450,4534),63)
			Result.put (new_triple (4359,4450,4535),64)
			Result.put (new_triple (4359,4450,4536),65)
			Result.put (new_triple (4359,4450,4537),66)
			Result.put (new_triple (4359,4450,4538),67)
			Result.put (new_triple (4359,4450,4539),68)
			Result.put (new_triple (4359,4450,4540),69)
			Result.put (new_triple (4359,4450,4541),70)
			Result.put (new_triple (4359,4450,4542),71)
			Result.put (new_triple (4359,4450,4543),72)
			Result.put (new_triple (4359,4450,4544),73)
			Result.put (new_triple (4359,4450,4545),74)
			Result.put (new_triple (4359,4450,4546),75)
			Result.put (new_pair (4359,4451),76)
			Result.put (new_triple (4359,4451,4520),77)
			Result.put (new_triple (4359,4451,4521),78)
			Result.put (new_triple (4359,4451,4522),79)
			Result.put (new_triple (4359,4451,4523),80)
			Result.put (new_triple (4359,4451,4524),81)
			Result.put (new_triple (4359,4451,4525),82)
			Result.put (new_triple (4359,4451,4526),83)
			Result.put (new_triple (4359,4451,4527),84)
			Result.put (new_triple (4359,4451,4528),85)
			Result.put (new_triple (4359,4451,4529),86)
			Result.put (new_triple (4359,4451,4530),87)
			Result.put (new_triple (4359,4451,4531),88)
			Result.put (new_triple (4359,4451,4532),89)
			Result.put (new_triple (4359,4451,4533),90)
			Result.put (new_triple (4359,4451,4534),91)
			Result.put (new_triple (4359,4451,4535),92)
			Result.put (new_triple (4359,4451,4536),93)
			Result.put (new_triple (4359,4451,4537),94)
			Result.put (new_triple (4359,4451,4538),95)
			Result.put (new_triple (4359,4451,4539),96)
			Result.put (new_triple (4359,4451,4540),97)
			Result.put (new_triple (4359,4451,4541),98)
			Result.put (new_triple (4359,4451,4542),99)
			Result.put (new_triple (4359,4451,4543),100)
			Result.put (new_triple (4359,4451,4544),101)
			Result.put (new_triple (4359,4451,4545),102)
			Result.put (new_triple (4359,4451,4546),103)
			Result.put (new_pair (4359,4452),104)
			Result.put (new_triple (4359,4452,4520),105)
			Result.put (new_triple (4359,4452,4521),106)
			Result.put (new_triple (4359,4452,4522),107)
			Result.put (new_triple (4359,4452,4523),108)
			Result.put (new_triple (4359,4452,4524),109)
			Result.put (new_triple (4359,4452,4525),110)
			Result.put (new_triple (4359,4452,4526),111)
			Result.put (new_triple (4359,4452,4527),112)
			Result.put (new_triple (4359,4452,4528),113)
			Result.put (new_triple (4359,4452,4529),114)
			Result.put (new_triple (4359,4452,4530),115)
			Result.put (new_triple (4359,4452,4531),116)
			Result.put (new_triple (4359,4452,4532),117)
			Result.put (new_triple (4359,4452,4533),118)
			Result.put (new_triple (4359,4452,4534),119)
			Result.put (new_triple (4359,4452,4535),120)
			Result.put (new_triple (4359,4452,4536),121)
			Result.put (new_triple (4359,4452,4537),122)
			Result.put (new_triple (4359,4452,4538),123)
			Result.put (new_triple (4359,4452,4539),124)
			Result.put (new_triple (4359,4452,4540),125)
			Result.put (new_triple (4359,4452,4541),126)
			Result.put (new_triple (4359,4452,4542),127)
			Result.put (new_triple (4359,4452,4543),128)
			Result.put (new_triple (4359,4452,4544),129)
			Result.put (new_triple (4359,4452,4545),130)
			Result.put (new_triple (4359,4452,4546),131)
			Result.put (new_pair (4359,4453),132)
			Result.put (new_triple (4359,4453,4520),133)
			Result.put (new_triple (4359,4453,4521),134)
			Result.put (new_triple (4359,4453,4522),135)
			Result.put (new_triple (4359,4453,4523),136)
			Result.put (new_triple (4359,4453,4524),137)
			Result.put (new_triple (4359,4453,4525),138)
			Result.put (new_triple (4359,4453,4526),139)
			Result.put (new_triple (4359,4453,4527),140)
			Result.put (new_triple (4359,4453,4528),141)
			Result.put (new_triple (4359,4453,4529),142)
			Result.put (new_triple (4359,4453,4530),143)
			Result.put (new_triple (4359,4453,4531),144)
			Result.put (new_triple (4359,4453,4532),145)
			Result.put (new_triple (4359,4453,4533),146)
			Result.put (new_triple (4359,4453,4534),147)
			Result.put (new_triple (4359,4453,4535),148)
			Result.put (new_triple (4359,4453,4536),149)
			Result.put (new_triple (4359,4453,4537),150)
			Result.put (new_triple (4359,4453,4538),151)
			Result.put (new_triple (4359,4453,4539),152)
			Result.put (new_triple (4359,4453,4540),153)
			Result.put (new_triple (4359,4453,4541),154)
			Result.put (new_triple (4359,4453,4542),155)
			Result.put (new_triple (4359,4453,4543),156)
			Result.put (new_triple (4359,4453,4544),157)
			Result.put (new_triple (4359,4453,4545),158)
			Result.put (new_triple (4359,4453,4546),159)
			Result.put (new_pair (4359,4454),160)
			Result.put (new_triple (4359,4454,4520),161)
			Result.put (new_triple (4359,4454,4521),162)
			Result.put (new_triple (4359,4454,4522),163)
			Result.put (new_triple (4359,4454,4523),164)
			Result.put (new_triple (4359,4454,4524),165)
			Result.put (new_triple (4359,4454,4525),166)
			Result.put (new_triple (4359,4454,4526),167)
			Result.put (new_triple (4359,4454,4527),168)
			Result.put (new_triple (4359,4454,4528),169)
			Result.put (new_triple (4359,4454,4529),170)
			Result.put (new_triple (4359,4454,4530),171)
			Result.put (new_triple (4359,4454,4531),172)
			Result.put (new_triple (4359,4454,4532),173)
			Result.put (new_triple (4359,4454,4533),174)
			Result.put (new_triple (4359,4454,4534),175)
			Result.put (new_triple (4359,4454,4535),176)
			Result.put (new_triple (4359,4454,4536),177)
			Result.put (new_triple (4359,4454,4537),178)
			Result.put (new_triple (4359,4454,4538),179)
			Result.put (new_triple (4359,4454,4539),180)
			Result.put (new_triple (4359,4454,4540),181)
			Result.put (new_triple (4359,4454,4541),182)
			Result.put (new_triple (4359,4454,4542),183)
			Result.put (new_triple (4359,4454,4543),184)
			Result.put (new_triple (4359,4454,4544),185)
			Result.put (new_triple (4359,4454,4545),186)
			Result.put (new_triple (4359,4454,4546),187)
			Result.put (new_pair (4359,4455),188)
			Result.put (new_triple (4359,4455,4520),189)
			Result.put (new_triple (4359,4455,4521),190)
			Result.put (new_triple (4359,4455,4522),191)
			Result.put (new_triple (4359,4455,4523),192)
			Result.put (new_triple (4359,4455,4524),193)
			Result.put (new_triple (4359,4455,4525),194)
			Result.put (new_triple (4359,4455,4526),195)
			Result.put (new_triple (4359,4455,4527),196)
			Result.put (new_triple (4359,4455,4528),197)
			Result.put (new_triple (4359,4455,4529),198)
			Result.put (new_triple (4359,4455,4530),199)
			Result.put (new_triple (4359,4455,4531),200)
			Result.put (new_triple (4359,4455,4532),201)
			Result.put (new_triple (4359,4455,4533),202)
			Result.put (new_triple (4359,4455,4534),203)
			Result.put (new_triple (4359,4455,4535),204)
			Result.put (new_triple (4359,4455,4536),205)
			Result.put (new_triple (4359,4455,4537),206)
			Result.put (new_triple (4359,4455,4538),207)
			Result.put (new_triple (4359,4455,4539),208)
			Result.put (new_triple (4359,4455,4540),209)
			Result.put (new_triple (4359,4455,4541),210)
			Result.put (new_triple (4359,4455,4542),211)
			Result.put (new_triple (4359,4455,4543),212)
			Result.put (new_triple (4359,4455,4544),213)
			Result.put (new_triple (4359,4455,4545),214)
			Result.put (new_triple (4359,4455,4546),215)
			Result.put (new_pair (4359,4456),216)
			Result.put (new_triple (4359,4456,4520),217)
			Result.put (new_triple (4359,4456,4521),218)
			Result.put (new_triple (4359,4456,4522),219)
			Result.put (new_triple (4359,4456,4523),220)
			Result.put (new_triple (4359,4456,4524),221)
			Result.put (new_triple (4359,4456,4525),222)
			Result.put (new_triple (4359,4456,4526),223)
			Result.put (new_triple (4359,4456,4527),224)
			Result.put (new_triple (4359,4456,4528),225)
			Result.put (new_triple (4359,4456,4529),226)
			Result.put (new_triple (4359,4456,4530),227)
			Result.put (new_triple (4359,4456,4531),228)
			Result.put (new_triple (4359,4456,4532),229)
			Result.put (new_triple (4359,4456,4533),230)
			Result.put (new_triple (4359,4456,4534),231)
			Result.put (new_triple (4359,4456,4535),232)
			Result.put (new_triple (4359,4456,4536),233)
			Result.put (new_triple (4359,4456,4537),234)
			Result.put (new_triple (4359,4456,4538),235)
			Result.put (new_triple (4359,4456,4539),236)
			Result.put (new_triple (4359,4456,4540),237)
			Result.put (new_triple (4359,4456,4541),238)
			Result.put (new_triple (4359,4456,4542),239)
			Result.put (new_triple (4359,4456,4543),240)
			Result.put (new_triple (4359,4456,4544),241)
			Result.put (new_triple (4359,4456,4545),242)
			Result.put (new_triple (4359,4456,4546),243)
			Result.put (new_pair (4359,4457),244)
			Result.put (new_triple (4359,4457,4520),245)
			Result.put (new_triple (4359,4457,4521),246)
			Result.put (new_triple (4359,4457,4522),247)
			Result.put (new_triple (4359,4457,4523),248)
			Result.put (new_triple (4359,4457,4524),249)
			Result.put (new_triple (4359,4457,4525),250)
			Result.put (new_triple (4359,4457,4526),251)
			Result.put (new_triple (4359,4457,4527),252)
			Result.put (new_triple (4359,4457,4528),253)
			Result.put (new_triple (4359,4457,4529),254)
			Result.put (new_triple (4359,4457,4530),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_189: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4359,4457,4531),0)
			Result.put (new_triple (4359,4457,4532),1)
			Result.put (new_triple (4359,4457,4533),2)
			Result.put (new_triple (4359,4457,4534),3)
			Result.put (new_triple (4359,4457,4535),4)
			Result.put (new_triple (4359,4457,4536),5)
			Result.put (new_triple (4359,4457,4537),6)
			Result.put (new_triple (4359,4457,4538),7)
			Result.put (new_triple (4359,4457,4539),8)
			Result.put (new_triple (4359,4457,4540),9)
			Result.put (new_triple (4359,4457,4541),10)
			Result.put (new_triple (4359,4457,4542),11)
			Result.put (new_triple (4359,4457,4543),12)
			Result.put (new_triple (4359,4457,4544),13)
			Result.put (new_triple (4359,4457,4545),14)
			Result.put (new_triple (4359,4457,4546),15)
			Result.put (new_pair (4359,4458),16)
			Result.put (new_triple (4359,4458,4520),17)
			Result.put (new_triple (4359,4458,4521),18)
			Result.put (new_triple (4359,4458,4522),19)
			Result.put (new_triple (4359,4458,4523),20)
			Result.put (new_triple (4359,4458,4524),21)
			Result.put (new_triple (4359,4458,4525),22)
			Result.put (new_triple (4359,4458,4526),23)
			Result.put (new_triple (4359,4458,4527),24)
			Result.put (new_triple (4359,4458,4528),25)
			Result.put (new_triple (4359,4458,4529),26)
			Result.put (new_triple (4359,4458,4530),27)
			Result.put (new_triple (4359,4458,4531),28)
			Result.put (new_triple (4359,4458,4532),29)
			Result.put (new_triple (4359,4458,4533),30)
			Result.put (new_triple (4359,4458,4534),31)
			Result.put (new_triple (4359,4458,4535),32)
			Result.put (new_triple (4359,4458,4536),33)
			Result.put (new_triple (4359,4458,4537),34)
			Result.put (new_triple (4359,4458,4538),35)
			Result.put (new_triple (4359,4458,4539),36)
			Result.put (new_triple (4359,4458,4540),37)
			Result.put (new_triple (4359,4458,4541),38)
			Result.put (new_triple (4359,4458,4542),39)
			Result.put (new_triple (4359,4458,4543),40)
			Result.put (new_triple (4359,4458,4544),41)
			Result.put (new_triple (4359,4458,4545),42)
			Result.put (new_triple (4359,4458,4546),43)
			Result.put (new_pair (4359,4459),44)
			Result.put (new_triple (4359,4459,4520),45)
			Result.put (new_triple (4359,4459,4521),46)
			Result.put (new_triple (4359,4459,4522),47)
			Result.put (new_triple (4359,4459,4523),48)
			Result.put (new_triple (4359,4459,4524),49)
			Result.put (new_triple (4359,4459,4525),50)
			Result.put (new_triple (4359,4459,4526),51)
			Result.put (new_triple (4359,4459,4527),52)
			Result.put (new_triple (4359,4459,4528),53)
			Result.put (new_triple (4359,4459,4529),54)
			Result.put (new_triple (4359,4459,4530),55)
			Result.put (new_triple (4359,4459,4531),56)
			Result.put (new_triple (4359,4459,4532),57)
			Result.put (new_triple (4359,4459,4533),58)
			Result.put (new_triple (4359,4459,4534),59)
			Result.put (new_triple (4359,4459,4535),60)
			Result.put (new_triple (4359,4459,4536),61)
			Result.put (new_triple (4359,4459,4537),62)
			Result.put (new_triple (4359,4459,4538),63)
			Result.put (new_triple (4359,4459,4539),64)
			Result.put (new_triple (4359,4459,4540),65)
			Result.put (new_triple (4359,4459,4541),66)
			Result.put (new_triple (4359,4459,4542),67)
			Result.put (new_triple (4359,4459,4543),68)
			Result.put (new_triple (4359,4459,4544),69)
			Result.put (new_triple (4359,4459,4545),70)
			Result.put (new_triple (4359,4459,4546),71)
			Result.put (new_pair (4359,4460),72)
			Result.put (new_triple (4359,4460,4520),73)
			Result.put (new_triple (4359,4460,4521),74)
			Result.put (new_triple (4359,4460,4522),75)
			Result.put (new_triple (4359,4460,4523),76)
			Result.put (new_triple (4359,4460,4524),77)
			Result.put (new_triple (4359,4460,4525),78)
			Result.put (new_triple (4359,4460,4526),79)
			Result.put (new_triple (4359,4460,4527),80)
			Result.put (new_triple (4359,4460,4528),81)
			Result.put (new_triple (4359,4460,4529),82)
			Result.put (new_triple (4359,4460,4530),83)
			Result.put (new_triple (4359,4460,4531),84)
			Result.put (new_triple (4359,4460,4532),85)
			Result.put (new_triple (4359,4460,4533),86)
			Result.put (new_triple (4359,4460,4534),87)
			Result.put (new_triple (4359,4460,4535),88)
			Result.put (new_triple (4359,4460,4536),89)
			Result.put (new_triple (4359,4460,4537),90)
			Result.put (new_triple (4359,4460,4538),91)
			Result.put (new_triple (4359,4460,4539),92)
			Result.put (new_triple (4359,4460,4540),93)
			Result.put (new_triple (4359,4460,4541),94)
			Result.put (new_triple (4359,4460,4542),95)
			Result.put (new_triple (4359,4460,4543),96)
			Result.put (new_triple (4359,4460,4544),97)
			Result.put (new_triple (4359,4460,4545),98)
			Result.put (new_triple (4359,4460,4546),99)
			Result.put (new_pair (4359,4461),100)
			Result.put (new_triple (4359,4461,4520),101)
			Result.put (new_triple (4359,4461,4521),102)
			Result.put (new_triple (4359,4461,4522),103)
			Result.put (new_triple (4359,4461,4523),104)
			Result.put (new_triple (4359,4461,4524),105)
			Result.put (new_triple (4359,4461,4525),106)
			Result.put (new_triple (4359,4461,4526),107)
			Result.put (new_triple (4359,4461,4527),108)
			Result.put (new_triple (4359,4461,4528),109)
			Result.put (new_triple (4359,4461,4529),110)
			Result.put (new_triple (4359,4461,4530),111)
			Result.put (new_triple (4359,4461,4531),112)
			Result.put (new_triple (4359,4461,4532),113)
			Result.put (new_triple (4359,4461,4533),114)
			Result.put (new_triple (4359,4461,4534),115)
			Result.put (new_triple (4359,4461,4535),116)
			Result.put (new_triple (4359,4461,4536),117)
			Result.put (new_triple (4359,4461,4537),118)
			Result.put (new_triple (4359,4461,4538),119)
			Result.put (new_triple (4359,4461,4539),120)
			Result.put (new_triple (4359,4461,4540),121)
			Result.put (new_triple (4359,4461,4541),122)
			Result.put (new_triple (4359,4461,4542),123)
			Result.put (new_triple (4359,4461,4543),124)
			Result.put (new_triple (4359,4461,4544),125)
			Result.put (new_triple (4359,4461,4545),126)
			Result.put (new_triple (4359,4461,4546),127)
			Result.put (new_pair (4359,4462),128)
			Result.put (new_triple (4359,4462,4520),129)
			Result.put (new_triple (4359,4462,4521),130)
			Result.put (new_triple (4359,4462,4522),131)
			Result.put (new_triple (4359,4462,4523),132)
			Result.put (new_triple (4359,4462,4524),133)
			Result.put (new_triple (4359,4462,4525),134)
			Result.put (new_triple (4359,4462,4526),135)
			Result.put (new_triple (4359,4462,4527),136)
			Result.put (new_triple (4359,4462,4528),137)
			Result.put (new_triple (4359,4462,4529),138)
			Result.put (new_triple (4359,4462,4530),139)
			Result.put (new_triple (4359,4462,4531),140)
			Result.put (new_triple (4359,4462,4532),141)
			Result.put (new_triple (4359,4462,4533),142)
			Result.put (new_triple (4359,4462,4534),143)
			Result.put (new_triple (4359,4462,4535),144)
			Result.put (new_triple (4359,4462,4536),145)
			Result.put (new_triple (4359,4462,4537),146)
			Result.put (new_triple (4359,4462,4538),147)
			Result.put (new_triple (4359,4462,4539),148)
			Result.put (new_triple (4359,4462,4540),149)
			Result.put (new_triple (4359,4462,4541),150)
			Result.put (new_triple (4359,4462,4542),151)
			Result.put (new_triple (4359,4462,4543),152)
			Result.put (new_triple (4359,4462,4544),153)
			Result.put (new_triple (4359,4462,4545),154)
			Result.put (new_triple (4359,4462,4546),155)
			Result.put (new_pair (4359,4463),156)
			Result.put (new_triple (4359,4463,4520),157)
			Result.put (new_triple (4359,4463,4521),158)
			Result.put (new_triple (4359,4463,4522),159)
			Result.put (new_triple (4359,4463,4523),160)
			Result.put (new_triple (4359,4463,4524),161)
			Result.put (new_triple (4359,4463,4525),162)
			Result.put (new_triple (4359,4463,4526),163)
			Result.put (new_triple (4359,4463,4527),164)
			Result.put (new_triple (4359,4463,4528),165)
			Result.put (new_triple (4359,4463,4529),166)
			Result.put (new_triple (4359,4463,4530),167)
			Result.put (new_triple (4359,4463,4531),168)
			Result.put (new_triple (4359,4463,4532),169)
			Result.put (new_triple (4359,4463,4533),170)
			Result.put (new_triple (4359,4463,4534),171)
			Result.put (new_triple (4359,4463,4535),172)
			Result.put (new_triple (4359,4463,4536),173)
			Result.put (new_triple (4359,4463,4537),174)
			Result.put (new_triple (4359,4463,4538),175)
			Result.put (new_triple (4359,4463,4539),176)
			Result.put (new_triple (4359,4463,4540),177)
			Result.put (new_triple (4359,4463,4541),178)
			Result.put (new_triple (4359,4463,4542),179)
			Result.put (new_triple (4359,4463,4543),180)
			Result.put (new_triple (4359,4463,4544),181)
			Result.put (new_triple (4359,4463,4545),182)
			Result.put (new_triple (4359,4463,4546),183)
			Result.put (new_pair (4359,4464),184)
			Result.put (new_triple (4359,4464,4520),185)
			Result.put (new_triple (4359,4464,4521),186)
			Result.put (new_triple (4359,4464,4522),187)
			Result.put (new_triple (4359,4464,4523),188)
			Result.put (new_triple (4359,4464,4524),189)
			Result.put (new_triple (4359,4464,4525),190)
			Result.put (new_triple (4359,4464,4526),191)
			Result.put (new_triple (4359,4464,4527),192)
			Result.put (new_triple (4359,4464,4528),193)
			Result.put (new_triple (4359,4464,4529),194)
			Result.put (new_triple (4359,4464,4530),195)
			Result.put (new_triple (4359,4464,4531),196)
			Result.put (new_triple (4359,4464,4532),197)
			Result.put (new_triple (4359,4464,4533),198)
			Result.put (new_triple (4359,4464,4534),199)
			Result.put (new_triple (4359,4464,4535),200)
			Result.put (new_triple (4359,4464,4536),201)
			Result.put (new_triple (4359,4464,4537),202)
			Result.put (new_triple (4359,4464,4538),203)
			Result.put (new_triple (4359,4464,4539),204)
			Result.put (new_triple (4359,4464,4540),205)
			Result.put (new_triple (4359,4464,4541),206)
			Result.put (new_triple (4359,4464,4542),207)
			Result.put (new_triple (4359,4464,4543),208)
			Result.put (new_triple (4359,4464,4544),209)
			Result.put (new_triple (4359,4464,4545),210)
			Result.put (new_triple (4359,4464,4546),211)
			Result.put (new_pair (4359,4465),212)
			Result.put (new_triple (4359,4465,4520),213)
			Result.put (new_triple (4359,4465,4521),214)
			Result.put (new_triple (4359,4465,4522),215)
			Result.put (new_triple (4359,4465,4523),216)
			Result.put (new_triple (4359,4465,4524),217)
			Result.put (new_triple (4359,4465,4525),218)
			Result.put (new_triple (4359,4465,4526),219)
			Result.put (new_triple (4359,4465,4527),220)
			Result.put (new_triple (4359,4465,4528),221)
			Result.put (new_triple (4359,4465,4529),222)
			Result.put (new_triple (4359,4465,4530),223)
			Result.put (new_triple (4359,4465,4531),224)
			Result.put (new_triple (4359,4465,4532),225)
			Result.put (new_triple (4359,4465,4533),226)
			Result.put (new_triple (4359,4465,4534),227)
			Result.put (new_triple (4359,4465,4535),228)
			Result.put (new_triple (4359,4465,4536),229)
			Result.put (new_triple (4359,4465,4537),230)
			Result.put (new_triple (4359,4465,4538),231)
			Result.put (new_triple (4359,4465,4539),232)
			Result.put (new_triple (4359,4465,4540),233)
			Result.put (new_triple (4359,4465,4541),234)
			Result.put (new_triple (4359,4465,4542),235)
			Result.put (new_triple (4359,4465,4543),236)
			Result.put (new_triple (4359,4465,4544),237)
			Result.put (new_triple (4359,4465,4545),238)
			Result.put (new_triple (4359,4465,4546),239)
			Result.put (new_pair (4359,4466),240)
			Result.put (new_triple (4359,4466,4520),241)
			Result.put (new_triple (4359,4466,4521),242)
			Result.put (new_triple (4359,4466,4522),243)
			Result.put (new_triple (4359,4466,4523),244)
			Result.put (new_triple (4359,4466,4524),245)
			Result.put (new_triple (4359,4466,4525),246)
			Result.put (new_triple (4359,4466,4526),247)
			Result.put (new_triple (4359,4466,4527),248)
			Result.put (new_triple (4359,4466,4528),249)
			Result.put (new_triple (4359,4466,4529),250)
			Result.put (new_triple (4359,4466,4530),251)
			Result.put (new_triple (4359,4466,4531),252)
			Result.put (new_triple (4359,4466,4532),253)
			Result.put (new_triple (4359,4466,4533),254)
			Result.put (new_triple (4359,4466,4534),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_190: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4359,4466,4535),0)
			Result.put (new_triple (4359,4466,4536),1)
			Result.put (new_triple (4359,4466,4537),2)
			Result.put (new_triple (4359,4466,4538),3)
			Result.put (new_triple (4359,4466,4539),4)
			Result.put (new_triple (4359,4466,4540),5)
			Result.put (new_triple (4359,4466,4541),6)
			Result.put (new_triple (4359,4466,4542),7)
			Result.put (new_triple (4359,4466,4543),8)
			Result.put (new_triple (4359,4466,4544),9)
			Result.put (new_triple (4359,4466,4545),10)
			Result.put (new_triple (4359,4466,4546),11)
			Result.put (new_pair (4359,4467),12)
			Result.put (new_triple (4359,4467,4520),13)
			Result.put (new_triple (4359,4467,4521),14)
			Result.put (new_triple (4359,4467,4522),15)
			Result.put (new_triple (4359,4467,4523),16)
			Result.put (new_triple (4359,4467,4524),17)
			Result.put (new_triple (4359,4467,4525),18)
			Result.put (new_triple (4359,4467,4526),19)
			Result.put (new_triple (4359,4467,4527),20)
			Result.put (new_triple (4359,4467,4528),21)
			Result.put (new_triple (4359,4467,4529),22)
			Result.put (new_triple (4359,4467,4530),23)
			Result.put (new_triple (4359,4467,4531),24)
			Result.put (new_triple (4359,4467,4532),25)
			Result.put (new_triple (4359,4467,4533),26)
			Result.put (new_triple (4359,4467,4534),27)
			Result.put (new_triple (4359,4467,4535),28)
			Result.put (new_triple (4359,4467,4536),29)
			Result.put (new_triple (4359,4467,4537),30)
			Result.put (new_triple (4359,4467,4538),31)
			Result.put (new_triple (4359,4467,4539),32)
			Result.put (new_triple (4359,4467,4540),33)
			Result.put (new_triple (4359,4467,4541),34)
			Result.put (new_triple (4359,4467,4542),35)
			Result.put (new_triple (4359,4467,4543),36)
			Result.put (new_triple (4359,4467,4544),37)
			Result.put (new_triple (4359,4467,4545),38)
			Result.put (new_triple (4359,4467,4546),39)
			Result.put (new_pair (4359,4468),40)
			Result.put (new_triple (4359,4468,4520),41)
			Result.put (new_triple (4359,4468,4521),42)
			Result.put (new_triple (4359,4468,4522),43)
			Result.put (new_triple (4359,4468,4523),44)
			Result.put (new_triple (4359,4468,4524),45)
			Result.put (new_triple (4359,4468,4525),46)
			Result.put (new_triple (4359,4468,4526),47)
			Result.put (new_triple (4359,4468,4527),48)
			Result.put (new_triple (4359,4468,4528),49)
			Result.put (new_triple (4359,4468,4529),50)
			Result.put (new_triple (4359,4468,4530),51)
			Result.put (new_triple (4359,4468,4531),52)
			Result.put (new_triple (4359,4468,4532),53)
			Result.put (new_triple (4359,4468,4533),54)
			Result.put (new_triple (4359,4468,4534),55)
			Result.put (new_triple (4359,4468,4535),56)
			Result.put (new_triple (4359,4468,4536),57)
			Result.put (new_triple (4359,4468,4537),58)
			Result.put (new_triple (4359,4468,4538),59)
			Result.put (new_triple (4359,4468,4539),60)
			Result.put (new_triple (4359,4468,4540),61)
			Result.put (new_triple (4359,4468,4541),62)
			Result.put (new_triple (4359,4468,4542),63)
			Result.put (new_triple (4359,4468,4543),64)
			Result.put (new_triple (4359,4468,4544),65)
			Result.put (new_triple (4359,4468,4545),66)
			Result.put (new_triple (4359,4468,4546),67)
			Result.put (new_pair (4359,4469),68)
			Result.put (new_triple (4359,4469,4520),69)
			Result.put (new_triple (4359,4469,4521),70)
			Result.put (new_triple (4359,4469,4522),71)
			Result.put (new_triple (4359,4469,4523),72)
			Result.put (new_triple (4359,4469,4524),73)
			Result.put (new_triple (4359,4469,4525),74)
			Result.put (new_triple (4359,4469,4526),75)
			Result.put (new_triple (4359,4469,4527),76)
			Result.put (new_triple (4359,4469,4528),77)
			Result.put (new_triple (4359,4469,4529),78)
			Result.put (new_triple (4359,4469,4530),79)
			Result.put (new_triple (4359,4469,4531),80)
			Result.put (new_triple (4359,4469,4532),81)
			Result.put (new_triple (4359,4469,4533),82)
			Result.put (new_triple (4359,4469,4534),83)
			Result.put (new_triple (4359,4469,4535),84)
			Result.put (new_triple (4359,4469,4536),85)
			Result.put (new_triple (4359,4469,4537),86)
			Result.put (new_triple (4359,4469,4538),87)
			Result.put (new_triple (4359,4469,4539),88)
			Result.put (new_triple (4359,4469,4540),89)
			Result.put (new_triple (4359,4469,4541),90)
			Result.put (new_triple (4359,4469,4542),91)
			Result.put (new_triple (4359,4469,4543),92)
			Result.put (new_triple (4359,4469,4544),93)
			Result.put (new_triple (4359,4469,4545),94)
			Result.put (new_triple (4359,4469,4546),95)
			Result.put (new_pair (4360,4449),96)
			Result.put (new_triple (4360,4449,4520),97)
			Result.put (new_triple (4360,4449,4521),98)
			Result.put (new_triple (4360,4449,4522),99)
			Result.put (new_triple (4360,4449,4523),100)
			Result.put (new_triple (4360,4449,4524),101)
			Result.put (new_triple (4360,4449,4525),102)
			Result.put (new_triple (4360,4449,4526),103)
			Result.put (new_triple (4360,4449,4527),104)
			Result.put (new_triple (4360,4449,4528),105)
			Result.put (new_triple (4360,4449,4529),106)
			Result.put (new_triple (4360,4449,4530),107)
			Result.put (new_triple (4360,4449,4531),108)
			Result.put (new_triple (4360,4449,4532),109)
			Result.put (new_triple (4360,4449,4533),110)
			Result.put (new_triple (4360,4449,4534),111)
			Result.put (new_triple (4360,4449,4535),112)
			Result.put (new_triple (4360,4449,4536),113)
			Result.put (new_triple (4360,4449,4537),114)
			Result.put (new_triple (4360,4449,4538),115)
			Result.put (new_triple (4360,4449,4539),116)
			Result.put (new_triple (4360,4449,4540),117)
			Result.put (new_triple (4360,4449,4541),118)
			Result.put (new_triple (4360,4449,4542),119)
			Result.put (new_triple (4360,4449,4543),120)
			Result.put (new_triple (4360,4449,4544),121)
			Result.put (new_triple (4360,4449,4545),122)
			Result.put (new_triple (4360,4449,4546),123)
			Result.put (new_pair (4360,4450),124)
			Result.put (new_triple (4360,4450,4520),125)
			Result.put (new_triple (4360,4450,4521),126)
			Result.put (new_triple (4360,4450,4522),127)
			Result.put (new_triple (4360,4450,4523),128)
			Result.put (new_triple (4360,4450,4524),129)
			Result.put (new_triple (4360,4450,4525),130)
			Result.put (new_triple (4360,4450,4526),131)
			Result.put (new_triple (4360,4450,4527),132)
			Result.put (new_triple (4360,4450,4528),133)
			Result.put (new_triple (4360,4450,4529),134)
			Result.put (new_triple (4360,4450,4530),135)
			Result.put (new_triple (4360,4450,4531),136)
			Result.put (new_triple (4360,4450,4532),137)
			Result.put (new_triple (4360,4450,4533),138)
			Result.put (new_triple (4360,4450,4534),139)
			Result.put (new_triple (4360,4450,4535),140)
			Result.put (new_triple (4360,4450,4536),141)
			Result.put (new_triple (4360,4450,4537),142)
			Result.put (new_triple (4360,4450,4538),143)
			Result.put (new_triple (4360,4450,4539),144)
			Result.put (new_triple (4360,4450,4540),145)
			Result.put (new_triple (4360,4450,4541),146)
			Result.put (new_triple (4360,4450,4542),147)
			Result.put (new_triple (4360,4450,4543),148)
			Result.put (new_triple (4360,4450,4544),149)
			Result.put (new_triple (4360,4450,4545),150)
			Result.put (new_triple (4360,4450,4546),151)
			Result.put (new_pair (4360,4451),152)
			Result.put (new_triple (4360,4451,4520),153)
			Result.put (new_triple (4360,4451,4521),154)
			Result.put (new_triple (4360,4451,4522),155)
			Result.put (new_triple (4360,4451,4523),156)
			Result.put (new_triple (4360,4451,4524),157)
			Result.put (new_triple (4360,4451,4525),158)
			Result.put (new_triple (4360,4451,4526),159)
			Result.put (new_triple (4360,4451,4527),160)
			Result.put (new_triple (4360,4451,4528),161)
			Result.put (new_triple (4360,4451,4529),162)
			Result.put (new_triple (4360,4451,4530),163)
			Result.put (new_triple (4360,4451,4531),164)
			Result.put (new_triple (4360,4451,4532),165)
			Result.put (new_triple (4360,4451,4533),166)
			Result.put (new_triple (4360,4451,4534),167)
			Result.put (new_triple (4360,4451,4535),168)
			Result.put (new_triple (4360,4451,4536),169)
			Result.put (new_triple (4360,4451,4537),170)
			Result.put (new_triple (4360,4451,4538),171)
			Result.put (new_triple (4360,4451,4539),172)
			Result.put (new_triple (4360,4451,4540),173)
			Result.put (new_triple (4360,4451,4541),174)
			Result.put (new_triple (4360,4451,4542),175)
			Result.put (new_triple (4360,4451,4543),176)
			Result.put (new_triple (4360,4451,4544),177)
			Result.put (new_triple (4360,4451,4545),178)
			Result.put (new_triple (4360,4451,4546),179)
			Result.put (new_pair (4360,4452),180)
			Result.put (new_triple (4360,4452,4520),181)
			Result.put (new_triple (4360,4452,4521),182)
			Result.put (new_triple (4360,4452,4522),183)
			Result.put (new_triple (4360,4452,4523),184)
			Result.put (new_triple (4360,4452,4524),185)
			Result.put (new_triple (4360,4452,4525),186)
			Result.put (new_triple (4360,4452,4526),187)
			Result.put (new_triple (4360,4452,4527),188)
			Result.put (new_triple (4360,4452,4528),189)
			Result.put (new_triple (4360,4452,4529),190)
			Result.put (new_triple (4360,4452,4530),191)
			Result.put (new_triple (4360,4452,4531),192)
			Result.put (new_triple (4360,4452,4532),193)
			Result.put (new_triple (4360,4452,4533),194)
			Result.put (new_triple (4360,4452,4534),195)
			Result.put (new_triple (4360,4452,4535),196)
			Result.put (new_triple (4360,4452,4536),197)
			Result.put (new_triple (4360,4452,4537),198)
			Result.put (new_triple (4360,4452,4538),199)
			Result.put (new_triple (4360,4452,4539),200)
			Result.put (new_triple (4360,4452,4540),201)
			Result.put (new_triple (4360,4452,4541),202)
			Result.put (new_triple (4360,4452,4542),203)
			Result.put (new_triple (4360,4452,4543),204)
			Result.put (new_triple (4360,4452,4544),205)
			Result.put (new_triple (4360,4452,4545),206)
			Result.put (new_triple (4360,4452,4546),207)
			Result.put (new_pair (4360,4453),208)
			Result.put (new_triple (4360,4453,4520),209)
			Result.put (new_triple (4360,4453,4521),210)
			Result.put (new_triple (4360,4453,4522),211)
			Result.put (new_triple (4360,4453,4523),212)
			Result.put (new_triple (4360,4453,4524),213)
			Result.put (new_triple (4360,4453,4525),214)
			Result.put (new_triple (4360,4453,4526),215)
			Result.put (new_triple (4360,4453,4527),216)
			Result.put (new_triple (4360,4453,4528),217)
			Result.put (new_triple (4360,4453,4529),218)
			Result.put (new_triple (4360,4453,4530),219)
			Result.put (new_triple (4360,4453,4531),220)
			Result.put (new_triple (4360,4453,4532),221)
			Result.put (new_triple (4360,4453,4533),222)
			Result.put (new_triple (4360,4453,4534),223)
			Result.put (new_triple (4360,4453,4535),224)
			Result.put (new_triple (4360,4453,4536),225)
			Result.put (new_triple (4360,4453,4537),226)
			Result.put (new_triple (4360,4453,4538),227)
			Result.put (new_triple (4360,4453,4539),228)
			Result.put (new_triple (4360,4453,4540),229)
			Result.put (new_triple (4360,4453,4541),230)
			Result.put (new_triple (4360,4453,4542),231)
			Result.put (new_triple (4360,4453,4543),232)
			Result.put (new_triple (4360,4453,4544),233)
			Result.put (new_triple (4360,4453,4545),234)
			Result.put (new_triple (4360,4453,4546),235)
			Result.put (new_pair (4360,4454),236)
			Result.put (new_triple (4360,4454,4520),237)
			Result.put (new_triple (4360,4454,4521),238)
			Result.put (new_triple (4360,4454,4522),239)
			Result.put (new_triple (4360,4454,4523),240)
			Result.put (new_triple (4360,4454,4524),241)
			Result.put (new_triple (4360,4454,4525),242)
			Result.put (new_triple (4360,4454,4526),243)
			Result.put (new_triple (4360,4454,4527),244)
			Result.put (new_triple (4360,4454,4528),245)
			Result.put (new_triple (4360,4454,4529),246)
			Result.put (new_triple (4360,4454,4530),247)
			Result.put (new_triple (4360,4454,4531),248)
			Result.put (new_triple (4360,4454,4532),249)
			Result.put (new_triple (4360,4454,4533),250)
			Result.put (new_triple (4360,4454,4534),251)
			Result.put (new_triple (4360,4454,4535),252)
			Result.put (new_triple (4360,4454,4536),253)
			Result.put (new_triple (4360,4454,4537),254)
			Result.put (new_triple (4360,4454,4538),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_191: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4360,4454,4539),0)
			Result.put (new_triple (4360,4454,4540),1)
			Result.put (new_triple (4360,4454,4541),2)
			Result.put (new_triple (4360,4454,4542),3)
			Result.put (new_triple (4360,4454,4543),4)
			Result.put (new_triple (4360,4454,4544),5)
			Result.put (new_triple (4360,4454,4545),6)
			Result.put (new_triple (4360,4454,4546),7)
			Result.put (new_pair (4360,4455),8)
			Result.put (new_triple (4360,4455,4520),9)
			Result.put (new_triple (4360,4455,4521),10)
			Result.put (new_triple (4360,4455,4522),11)
			Result.put (new_triple (4360,4455,4523),12)
			Result.put (new_triple (4360,4455,4524),13)
			Result.put (new_triple (4360,4455,4525),14)
			Result.put (new_triple (4360,4455,4526),15)
			Result.put (new_triple (4360,4455,4527),16)
			Result.put (new_triple (4360,4455,4528),17)
			Result.put (new_triple (4360,4455,4529),18)
			Result.put (new_triple (4360,4455,4530),19)
			Result.put (new_triple (4360,4455,4531),20)
			Result.put (new_triple (4360,4455,4532),21)
			Result.put (new_triple (4360,4455,4533),22)
			Result.put (new_triple (4360,4455,4534),23)
			Result.put (new_triple (4360,4455,4535),24)
			Result.put (new_triple (4360,4455,4536),25)
			Result.put (new_triple (4360,4455,4537),26)
			Result.put (new_triple (4360,4455,4538),27)
			Result.put (new_triple (4360,4455,4539),28)
			Result.put (new_triple (4360,4455,4540),29)
			Result.put (new_triple (4360,4455,4541),30)
			Result.put (new_triple (4360,4455,4542),31)
			Result.put (new_triple (4360,4455,4543),32)
			Result.put (new_triple (4360,4455,4544),33)
			Result.put (new_triple (4360,4455,4545),34)
			Result.put (new_triple (4360,4455,4546),35)
			Result.put (new_pair (4360,4456),36)
			Result.put (new_triple (4360,4456,4520),37)
			Result.put (new_triple (4360,4456,4521),38)
			Result.put (new_triple (4360,4456,4522),39)
			Result.put (new_triple (4360,4456,4523),40)
			Result.put (new_triple (4360,4456,4524),41)
			Result.put (new_triple (4360,4456,4525),42)
			Result.put (new_triple (4360,4456,4526),43)
			Result.put (new_triple (4360,4456,4527),44)
			Result.put (new_triple (4360,4456,4528),45)
			Result.put (new_triple (4360,4456,4529),46)
			Result.put (new_triple (4360,4456,4530),47)
			Result.put (new_triple (4360,4456,4531),48)
			Result.put (new_triple (4360,4456,4532),49)
			Result.put (new_triple (4360,4456,4533),50)
			Result.put (new_triple (4360,4456,4534),51)
			Result.put (new_triple (4360,4456,4535),52)
			Result.put (new_triple (4360,4456,4536),53)
			Result.put (new_triple (4360,4456,4537),54)
			Result.put (new_triple (4360,4456,4538),55)
			Result.put (new_triple (4360,4456,4539),56)
			Result.put (new_triple (4360,4456,4540),57)
			Result.put (new_triple (4360,4456,4541),58)
			Result.put (new_triple (4360,4456,4542),59)
			Result.put (new_triple (4360,4456,4543),60)
			Result.put (new_triple (4360,4456,4544),61)
			Result.put (new_triple (4360,4456,4545),62)
			Result.put (new_triple (4360,4456,4546),63)
			Result.put (new_pair (4360,4457),64)
			Result.put (new_triple (4360,4457,4520),65)
			Result.put (new_triple (4360,4457,4521),66)
			Result.put (new_triple (4360,4457,4522),67)
			Result.put (new_triple (4360,4457,4523),68)
			Result.put (new_triple (4360,4457,4524),69)
			Result.put (new_triple (4360,4457,4525),70)
			Result.put (new_triple (4360,4457,4526),71)
			Result.put (new_triple (4360,4457,4527),72)
			Result.put (new_triple (4360,4457,4528),73)
			Result.put (new_triple (4360,4457,4529),74)
			Result.put (new_triple (4360,4457,4530),75)
			Result.put (new_triple (4360,4457,4531),76)
			Result.put (new_triple (4360,4457,4532),77)
			Result.put (new_triple (4360,4457,4533),78)
			Result.put (new_triple (4360,4457,4534),79)
			Result.put (new_triple (4360,4457,4535),80)
			Result.put (new_triple (4360,4457,4536),81)
			Result.put (new_triple (4360,4457,4537),82)
			Result.put (new_triple (4360,4457,4538),83)
			Result.put (new_triple (4360,4457,4539),84)
			Result.put (new_triple (4360,4457,4540),85)
			Result.put (new_triple (4360,4457,4541),86)
			Result.put (new_triple (4360,4457,4542),87)
			Result.put (new_triple (4360,4457,4543),88)
			Result.put (new_triple (4360,4457,4544),89)
			Result.put (new_triple (4360,4457,4545),90)
			Result.put (new_triple (4360,4457,4546),91)
			Result.put (new_pair (4360,4458),92)
			Result.put (new_triple (4360,4458,4520),93)
			Result.put (new_triple (4360,4458,4521),94)
			Result.put (new_triple (4360,4458,4522),95)
			Result.put (new_triple (4360,4458,4523),96)
			Result.put (new_triple (4360,4458,4524),97)
			Result.put (new_triple (4360,4458,4525),98)
			Result.put (new_triple (4360,4458,4526),99)
			Result.put (new_triple (4360,4458,4527),100)
			Result.put (new_triple (4360,4458,4528),101)
			Result.put (new_triple (4360,4458,4529),102)
			Result.put (new_triple (4360,4458,4530),103)
			Result.put (new_triple (4360,4458,4531),104)
			Result.put (new_triple (4360,4458,4532),105)
			Result.put (new_triple (4360,4458,4533),106)
			Result.put (new_triple (4360,4458,4534),107)
			Result.put (new_triple (4360,4458,4535),108)
			Result.put (new_triple (4360,4458,4536),109)
			Result.put (new_triple (4360,4458,4537),110)
			Result.put (new_triple (4360,4458,4538),111)
			Result.put (new_triple (4360,4458,4539),112)
			Result.put (new_triple (4360,4458,4540),113)
			Result.put (new_triple (4360,4458,4541),114)
			Result.put (new_triple (4360,4458,4542),115)
			Result.put (new_triple (4360,4458,4543),116)
			Result.put (new_triple (4360,4458,4544),117)
			Result.put (new_triple (4360,4458,4545),118)
			Result.put (new_triple (4360,4458,4546),119)
			Result.put (new_pair (4360,4459),120)
			Result.put (new_triple (4360,4459,4520),121)
			Result.put (new_triple (4360,4459,4521),122)
			Result.put (new_triple (4360,4459,4522),123)
			Result.put (new_triple (4360,4459,4523),124)
			Result.put (new_triple (4360,4459,4524),125)
			Result.put (new_triple (4360,4459,4525),126)
			Result.put (new_triple (4360,4459,4526),127)
			Result.put (new_triple (4360,4459,4527),128)
			Result.put (new_triple (4360,4459,4528),129)
			Result.put (new_triple (4360,4459,4529),130)
			Result.put (new_triple (4360,4459,4530),131)
			Result.put (new_triple (4360,4459,4531),132)
			Result.put (new_triple (4360,4459,4532),133)
			Result.put (new_triple (4360,4459,4533),134)
			Result.put (new_triple (4360,4459,4534),135)
			Result.put (new_triple (4360,4459,4535),136)
			Result.put (new_triple (4360,4459,4536),137)
			Result.put (new_triple (4360,4459,4537),138)
			Result.put (new_triple (4360,4459,4538),139)
			Result.put (new_triple (4360,4459,4539),140)
			Result.put (new_triple (4360,4459,4540),141)
			Result.put (new_triple (4360,4459,4541),142)
			Result.put (new_triple (4360,4459,4542),143)
			Result.put (new_triple (4360,4459,4543),144)
			Result.put (new_triple (4360,4459,4544),145)
			Result.put (new_triple (4360,4459,4545),146)
			Result.put (new_triple (4360,4459,4546),147)
			Result.put (new_pair (4360,4460),148)
			Result.put (new_triple (4360,4460,4520),149)
			Result.put (new_triple (4360,4460,4521),150)
			Result.put (new_triple (4360,4460,4522),151)
			Result.put (new_triple (4360,4460,4523),152)
			Result.put (new_triple (4360,4460,4524),153)
			Result.put (new_triple (4360,4460,4525),154)
			Result.put (new_triple (4360,4460,4526),155)
			Result.put (new_triple (4360,4460,4527),156)
			Result.put (new_triple (4360,4460,4528),157)
			Result.put (new_triple (4360,4460,4529),158)
			Result.put (new_triple (4360,4460,4530),159)
			Result.put (new_triple (4360,4460,4531),160)
			Result.put (new_triple (4360,4460,4532),161)
			Result.put (new_triple (4360,4460,4533),162)
			Result.put (new_triple (4360,4460,4534),163)
			Result.put (new_triple (4360,4460,4535),164)
			Result.put (new_triple (4360,4460,4536),165)
			Result.put (new_triple (4360,4460,4537),166)
			Result.put (new_triple (4360,4460,4538),167)
			Result.put (new_triple (4360,4460,4539),168)
			Result.put (new_triple (4360,4460,4540),169)
			Result.put (new_triple (4360,4460,4541),170)
			Result.put (new_triple (4360,4460,4542),171)
			Result.put (new_triple (4360,4460,4543),172)
			Result.put (new_triple (4360,4460,4544),173)
			Result.put (new_triple (4360,4460,4545),174)
			Result.put (new_triple (4360,4460,4546),175)
			Result.put (new_pair (4360,4461),176)
			Result.put (new_triple (4360,4461,4520),177)
			Result.put (new_triple (4360,4461,4521),178)
			Result.put (new_triple (4360,4461,4522),179)
			Result.put (new_triple (4360,4461,4523),180)
			Result.put (new_triple (4360,4461,4524),181)
			Result.put (new_triple (4360,4461,4525),182)
			Result.put (new_triple (4360,4461,4526),183)
			Result.put (new_triple (4360,4461,4527),184)
			Result.put (new_triple (4360,4461,4528),185)
			Result.put (new_triple (4360,4461,4529),186)
			Result.put (new_triple (4360,4461,4530),187)
			Result.put (new_triple (4360,4461,4531),188)
			Result.put (new_triple (4360,4461,4532),189)
			Result.put (new_triple (4360,4461,4533),190)
			Result.put (new_triple (4360,4461,4534),191)
			Result.put (new_triple (4360,4461,4535),192)
			Result.put (new_triple (4360,4461,4536),193)
			Result.put (new_triple (4360,4461,4537),194)
			Result.put (new_triple (4360,4461,4538),195)
			Result.put (new_triple (4360,4461,4539),196)
			Result.put (new_triple (4360,4461,4540),197)
			Result.put (new_triple (4360,4461,4541),198)
			Result.put (new_triple (4360,4461,4542),199)
			Result.put (new_triple (4360,4461,4543),200)
			Result.put (new_triple (4360,4461,4544),201)
			Result.put (new_triple (4360,4461,4545),202)
			Result.put (new_triple (4360,4461,4546),203)
			Result.put (new_pair (4360,4462),204)
			Result.put (new_triple (4360,4462,4520),205)
			Result.put (new_triple (4360,4462,4521),206)
			Result.put (new_triple (4360,4462,4522),207)
			Result.put (new_triple (4360,4462,4523),208)
			Result.put (new_triple (4360,4462,4524),209)
			Result.put (new_triple (4360,4462,4525),210)
			Result.put (new_triple (4360,4462,4526),211)
			Result.put (new_triple (4360,4462,4527),212)
			Result.put (new_triple (4360,4462,4528),213)
			Result.put (new_triple (4360,4462,4529),214)
			Result.put (new_triple (4360,4462,4530),215)
			Result.put (new_triple (4360,4462,4531),216)
			Result.put (new_triple (4360,4462,4532),217)
			Result.put (new_triple (4360,4462,4533),218)
			Result.put (new_triple (4360,4462,4534),219)
			Result.put (new_triple (4360,4462,4535),220)
			Result.put (new_triple (4360,4462,4536),221)
			Result.put (new_triple (4360,4462,4537),222)
			Result.put (new_triple (4360,4462,4538),223)
			Result.put (new_triple (4360,4462,4539),224)
			Result.put (new_triple (4360,4462,4540),225)
			Result.put (new_triple (4360,4462,4541),226)
			Result.put (new_triple (4360,4462,4542),227)
			Result.put (new_triple (4360,4462,4543),228)
			Result.put (new_triple (4360,4462,4544),229)
			Result.put (new_triple (4360,4462,4545),230)
			Result.put (new_triple (4360,4462,4546),231)
			Result.put (new_pair (4360,4463),232)
			Result.put (new_triple (4360,4463,4520),233)
			Result.put (new_triple (4360,4463,4521),234)
			Result.put (new_triple (4360,4463,4522),235)
			Result.put (new_triple (4360,4463,4523),236)
			Result.put (new_triple (4360,4463,4524),237)
			Result.put (new_triple (4360,4463,4525),238)
			Result.put (new_triple (4360,4463,4526),239)
			Result.put (new_triple (4360,4463,4527),240)
			Result.put (new_triple (4360,4463,4528),241)
			Result.put (new_triple (4360,4463,4529),242)
			Result.put (new_triple (4360,4463,4530),243)
			Result.put (new_triple (4360,4463,4531),244)
			Result.put (new_triple (4360,4463,4532),245)
			Result.put (new_triple (4360,4463,4533),246)
			Result.put (new_triple (4360,4463,4534),247)
			Result.put (new_triple (4360,4463,4535),248)
			Result.put (new_triple (4360,4463,4536),249)
			Result.put (new_triple (4360,4463,4537),250)
			Result.put (new_triple (4360,4463,4538),251)
			Result.put (new_triple (4360,4463,4539),252)
			Result.put (new_triple (4360,4463,4540),253)
			Result.put (new_triple (4360,4463,4541),254)
			Result.put (new_triple (4360,4463,4542),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_192: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4360,4463,4543),0)
			Result.put (new_triple (4360,4463,4544),1)
			Result.put (new_triple (4360,4463,4545),2)
			Result.put (new_triple (4360,4463,4546),3)
			Result.put (new_pair (4360,4464),4)
			Result.put (new_triple (4360,4464,4520),5)
			Result.put (new_triple (4360,4464,4521),6)
			Result.put (new_triple (4360,4464,4522),7)
			Result.put (new_triple (4360,4464,4523),8)
			Result.put (new_triple (4360,4464,4524),9)
			Result.put (new_triple (4360,4464,4525),10)
			Result.put (new_triple (4360,4464,4526),11)
			Result.put (new_triple (4360,4464,4527),12)
			Result.put (new_triple (4360,4464,4528),13)
			Result.put (new_triple (4360,4464,4529),14)
			Result.put (new_triple (4360,4464,4530),15)
			Result.put (new_triple (4360,4464,4531),16)
			Result.put (new_triple (4360,4464,4532),17)
			Result.put (new_triple (4360,4464,4533),18)
			Result.put (new_triple (4360,4464,4534),19)
			Result.put (new_triple (4360,4464,4535),20)
			Result.put (new_triple (4360,4464,4536),21)
			Result.put (new_triple (4360,4464,4537),22)
			Result.put (new_triple (4360,4464,4538),23)
			Result.put (new_triple (4360,4464,4539),24)
			Result.put (new_triple (4360,4464,4540),25)
			Result.put (new_triple (4360,4464,4541),26)
			Result.put (new_triple (4360,4464,4542),27)
			Result.put (new_triple (4360,4464,4543),28)
			Result.put (new_triple (4360,4464,4544),29)
			Result.put (new_triple (4360,4464,4545),30)
			Result.put (new_triple (4360,4464,4546),31)
			Result.put (new_pair (4360,4465),32)
			Result.put (new_triple (4360,4465,4520),33)
			Result.put (new_triple (4360,4465,4521),34)
			Result.put (new_triple (4360,4465,4522),35)
			Result.put (new_triple (4360,4465,4523),36)
			Result.put (new_triple (4360,4465,4524),37)
			Result.put (new_triple (4360,4465,4525),38)
			Result.put (new_triple (4360,4465,4526),39)
			Result.put (new_triple (4360,4465,4527),40)
			Result.put (new_triple (4360,4465,4528),41)
			Result.put (new_triple (4360,4465,4529),42)
			Result.put (new_triple (4360,4465,4530),43)
			Result.put (new_triple (4360,4465,4531),44)
			Result.put (new_triple (4360,4465,4532),45)
			Result.put (new_triple (4360,4465,4533),46)
			Result.put (new_triple (4360,4465,4534),47)
			Result.put (new_triple (4360,4465,4535),48)
			Result.put (new_triple (4360,4465,4536),49)
			Result.put (new_triple (4360,4465,4537),50)
			Result.put (new_triple (4360,4465,4538),51)
			Result.put (new_triple (4360,4465,4539),52)
			Result.put (new_triple (4360,4465,4540),53)
			Result.put (new_triple (4360,4465,4541),54)
			Result.put (new_triple (4360,4465,4542),55)
			Result.put (new_triple (4360,4465,4543),56)
			Result.put (new_triple (4360,4465,4544),57)
			Result.put (new_triple (4360,4465,4545),58)
			Result.put (new_triple (4360,4465,4546),59)
			Result.put (new_pair (4360,4466),60)
			Result.put (new_triple (4360,4466,4520),61)
			Result.put (new_triple (4360,4466,4521),62)
			Result.put (new_triple (4360,4466,4522),63)
			Result.put (new_triple (4360,4466,4523),64)
			Result.put (new_triple (4360,4466,4524),65)
			Result.put (new_triple (4360,4466,4525),66)
			Result.put (new_triple (4360,4466,4526),67)
			Result.put (new_triple (4360,4466,4527),68)
			Result.put (new_triple (4360,4466,4528),69)
			Result.put (new_triple (4360,4466,4529),70)
			Result.put (new_triple (4360,4466,4530),71)
			Result.put (new_triple (4360,4466,4531),72)
			Result.put (new_triple (4360,4466,4532),73)
			Result.put (new_triple (4360,4466,4533),74)
			Result.put (new_triple (4360,4466,4534),75)
			Result.put (new_triple (4360,4466,4535),76)
			Result.put (new_triple (4360,4466,4536),77)
			Result.put (new_triple (4360,4466,4537),78)
			Result.put (new_triple (4360,4466,4538),79)
			Result.put (new_triple (4360,4466,4539),80)
			Result.put (new_triple (4360,4466,4540),81)
			Result.put (new_triple (4360,4466,4541),82)
			Result.put (new_triple (4360,4466,4542),83)
			Result.put (new_triple (4360,4466,4543),84)
			Result.put (new_triple (4360,4466,4544),85)
			Result.put (new_triple (4360,4466,4545),86)
			Result.put (new_triple (4360,4466,4546),87)
			Result.put (new_pair (4360,4467),88)
			Result.put (new_triple (4360,4467,4520),89)
			Result.put (new_triple (4360,4467,4521),90)
			Result.put (new_triple (4360,4467,4522),91)
			Result.put (new_triple (4360,4467,4523),92)
			Result.put (new_triple (4360,4467,4524),93)
			Result.put (new_triple (4360,4467,4525),94)
			Result.put (new_triple (4360,4467,4526),95)
			Result.put (new_triple (4360,4467,4527),96)
			Result.put (new_triple (4360,4467,4528),97)
			Result.put (new_triple (4360,4467,4529),98)
			Result.put (new_triple (4360,4467,4530),99)
			Result.put (new_triple (4360,4467,4531),100)
			Result.put (new_triple (4360,4467,4532),101)
			Result.put (new_triple (4360,4467,4533),102)
			Result.put (new_triple (4360,4467,4534),103)
			Result.put (new_triple (4360,4467,4535),104)
			Result.put (new_triple (4360,4467,4536),105)
			Result.put (new_triple (4360,4467,4537),106)
			Result.put (new_triple (4360,4467,4538),107)
			Result.put (new_triple (4360,4467,4539),108)
			Result.put (new_triple (4360,4467,4540),109)
			Result.put (new_triple (4360,4467,4541),110)
			Result.put (new_triple (4360,4467,4542),111)
			Result.put (new_triple (4360,4467,4543),112)
			Result.put (new_triple (4360,4467,4544),113)
			Result.put (new_triple (4360,4467,4545),114)
			Result.put (new_triple (4360,4467,4546),115)
			Result.put (new_pair (4360,4468),116)
			Result.put (new_triple (4360,4468,4520),117)
			Result.put (new_triple (4360,4468,4521),118)
			Result.put (new_triple (4360,4468,4522),119)
			Result.put (new_triple (4360,4468,4523),120)
			Result.put (new_triple (4360,4468,4524),121)
			Result.put (new_triple (4360,4468,4525),122)
			Result.put (new_triple (4360,4468,4526),123)
			Result.put (new_triple (4360,4468,4527),124)
			Result.put (new_triple (4360,4468,4528),125)
			Result.put (new_triple (4360,4468,4529),126)
			Result.put (new_triple (4360,4468,4530),127)
			Result.put (new_triple (4360,4468,4531),128)
			Result.put (new_triple (4360,4468,4532),129)
			Result.put (new_triple (4360,4468,4533),130)
			Result.put (new_triple (4360,4468,4534),131)
			Result.put (new_triple (4360,4468,4535),132)
			Result.put (new_triple (4360,4468,4536),133)
			Result.put (new_triple (4360,4468,4537),134)
			Result.put (new_triple (4360,4468,4538),135)
			Result.put (new_triple (4360,4468,4539),136)
			Result.put (new_triple (4360,4468,4540),137)
			Result.put (new_triple (4360,4468,4541),138)
			Result.put (new_triple (4360,4468,4542),139)
			Result.put (new_triple (4360,4468,4543),140)
			Result.put (new_triple (4360,4468,4544),141)
			Result.put (new_triple (4360,4468,4545),142)
			Result.put (new_triple (4360,4468,4546),143)
			Result.put (new_pair (4360,4469),144)
			Result.put (new_triple (4360,4469,4520),145)
			Result.put (new_triple (4360,4469,4521),146)
			Result.put (new_triple (4360,4469,4522),147)
			Result.put (new_triple (4360,4469,4523),148)
			Result.put (new_triple (4360,4469,4524),149)
			Result.put (new_triple (4360,4469,4525),150)
			Result.put (new_triple (4360,4469,4526),151)
			Result.put (new_triple (4360,4469,4527),152)
			Result.put (new_triple (4360,4469,4528),153)
			Result.put (new_triple (4360,4469,4529),154)
			Result.put (new_triple (4360,4469,4530),155)
			Result.put (new_triple (4360,4469,4531),156)
			Result.put (new_triple (4360,4469,4532),157)
			Result.put (new_triple (4360,4469,4533),158)
			Result.put (new_triple (4360,4469,4534),159)
			Result.put (new_triple (4360,4469,4535),160)
			Result.put (new_triple (4360,4469,4536),161)
			Result.put (new_triple (4360,4469,4537),162)
			Result.put (new_triple (4360,4469,4538),163)
			Result.put (new_triple (4360,4469,4539),164)
			Result.put (new_triple (4360,4469,4540),165)
			Result.put (new_triple (4360,4469,4541),166)
			Result.put (new_triple (4360,4469,4542),167)
			Result.put (new_triple (4360,4469,4543),168)
			Result.put (new_triple (4360,4469,4544),169)
			Result.put (new_triple (4360,4469,4545),170)
			Result.put (new_triple (4360,4469,4546),171)
			Result.put (new_pair (4361,4449),172)
			Result.put (new_triple (4361,4449,4520),173)
			Result.put (new_triple (4361,4449,4521),174)
			Result.put (new_triple (4361,4449,4522),175)
			Result.put (new_triple (4361,4449,4523),176)
			Result.put (new_triple (4361,4449,4524),177)
			Result.put (new_triple (4361,4449,4525),178)
			Result.put (new_triple (4361,4449,4526),179)
			Result.put (new_triple (4361,4449,4527),180)
			Result.put (new_triple (4361,4449,4528),181)
			Result.put (new_triple (4361,4449,4529),182)
			Result.put (new_triple (4361,4449,4530),183)
			Result.put (new_triple (4361,4449,4531),184)
			Result.put (new_triple (4361,4449,4532),185)
			Result.put (new_triple (4361,4449,4533),186)
			Result.put (new_triple (4361,4449,4534),187)
			Result.put (new_triple (4361,4449,4535),188)
			Result.put (new_triple (4361,4449,4536),189)
			Result.put (new_triple (4361,4449,4537),190)
			Result.put (new_triple (4361,4449,4538),191)
			Result.put (new_triple (4361,4449,4539),192)
			Result.put (new_triple (4361,4449,4540),193)
			Result.put (new_triple (4361,4449,4541),194)
			Result.put (new_triple (4361,4449,4542),195)
			Result.put (new_triple (4361,4449,4543),196)
			Result.put (new_triple (4361,4449,4544),197)
			Result.put (new_triple (4361,4449,4545),198)
			Result.put (new_triple (4361,4449,4546),199)
			Result.put (new_pair (4361,4450),200)
			Result.put (new_triple (4361,4450,4520),201)
			Result.put (new_triple (4361,4450,4521),202)
			Result.put (new_triple (4361,4450,4522),203)
			Result.put (new_triple (4361,4450,4523),204)
			Result.put (new_triple (4361,4450,4524),205)
			Result.put (new_triple (4361,4450,4525),206)
			Result.put (new_triple (4361,4450,4526),207)
			Result.put (new_triple (4361,4450,4527),208)
			Result.put (new_triple (4361,4450,4528),209)
			Result.put (new_triple (4361,4450,4529),210)
			Result.put (new_triple (4361,4450,4530),211)
			Result.put (new_triple (4361,4450,4531),212)
			Result.put (new_triple (4361,4450,4532),213)
			Result.put (new_triple (4361,4450,4533),214)
			Result.put (new_triple (4361,4450,4534),215)
			Result.put (new_triple (4361,4450,4535),216)
			Result.put (new_triple (4361,4450,4536),217)
			Result.put (new_triple (4361,4450,4537),218)
			Result.put (new_triple (4361,4450,4538),219)
			Result.put (new_triple (4361,4450,4539),220)
			Result.put (new_triple (4361,4450,4540),221)
			Result.put (new_triple (4361,4450,4541),222)
			Result.put (new_triple (4361,4450,4542),223)
			Result.put (new_triple (4361,4450,4543),224)
			Result.put (new_triple (4361,4450,4544),225)
			Result.put (new_triple (4361,4450,4545),226)
			Result.put (new_triple (4361,4450,4546),227)
			Result.put (new_pair (4361,4451),228)
			Result.put (new_triple (4361,4451,4520),229)
			Result.put (new_triple (4361,4451,4521),230)
			Result.put (new_triple (4361,4451,4522),231)
			Result.put (new_triple (4361,4451,4523),232)
			Result.put (new_triple (4361,4451,4524),233)
			Result.put (new_triple (4361,4451,4525),234)
			Result.put (new_triple (4361,4451,4526),235)
			Result.put (new_triple (4361,4451,4527),236)
			Result.put (new_triple (4361,4451,4528),237)
			Result.put (new_triple (4361,4451,4529),238)
			Result.put (new_triple (4361,4451,4530),239)
			Result.put (new_triple (4361,4451,4531),240)
			Result.put (new_triple (4361,4451,4532),241)
			Result.put (new_triple (4361,4451,4533),242)
			Result.put (new_triple (4361,4451,4534),243)
			Result.put (new_triple (4361,4451,4535),244)
			Result.put (new_triple (4361,4451,4536),245)
			Result.put (new_triple (4361,4451,4537),246)
			Result.put (new_triple (4361,4451,4538),247)
			Result.put (new_triple (4361,4451,4539),248)
			Result.put (new_triple (4361,4451,4540),249)
			Result.put (new_triple (4361,4451,4541),250)
			Result.put (new_triple (4361,4451,4542),251)
			Result.put (new_triple (4361,4451,4543),252)
			Result.put (new_triple (4361,4451,4544),253)
			Result.put (new_triple (4361,4451,4545),254)
			Result.put (new_triple (4361,4451,4546),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_193: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (4361,4452),0)
			Result.put (new_triple (4361,4452,4520),1)
			Result.put (new_triple (4361,4452,4521),2)
			Result.put (new_triple (4361,4452,4522),3)
			Result.put (new_triple (4361,4452,4523),4)
			Result.put (new_triple (4361,4452,4524),5)
			Result.put (new_triple (4361,4452,4525),6)
			Result.put (new_triple (4361,4452,4526),7)
			Result.put (new_triple (4361,4452,4527),8)
			Result.put (new_triple (4361,4452,4528),9)
			Result.put (new_triple (4361,4452,4529),10)
			Result.put (new_triple (4361,4452,4530),11)
			Result.put (new_triple (4361,4452,4531),12)
			Result.put (new_triple (4361,4452,4532),13)
			Result.put (new_triple (4361,4452,4533),14)
			Result.put (new_triple (4361,4452,4534),15)
			Result.put (new_triple (4361,4452,4535),16)
			Result.put (new_triple (4361,4452,4536),17)
			Result.put (new_triple (4361,4452,4537),18)
			Result.put (new_triple (4361,4452,4538),19)
			Result.put (new_triple (4361,4452,4539),20)
			Result.put (new_triple (4361,4452,4540),21)
			Result.put (new_triple (4361,4452,4541),22)
			Result.put (new_triple (4361,4452,4542),23)
			Result.put (new_triple (4361,4452,4543),24)
			Result.put (new_triple (4361,4452,4544),25)
			Result.put (new_triple (4361,4452,4545),26)
			Result.put (new_triple (4361,4452,4546),27)
			Result.put (new_pair (4361,4453),28)
			Result.put (new_triple (4361,4453,4520),29)
			Result.put (new_triple (4361,4453,4521),30)
			Result.put (new_triple (4361,4453,4522),31)
			Result.put (new_triple (4361,4453,4523),32)
			Result.put (new_triple (4361,4453,4524),33)
			Result.put (new_triple (4361,4453,4525),34)
			Result.put (new_triple (4361,4453,4526),35)
			Result.put (new_triple (4361,4453,4527),36)
			Result.put (new_triple (4361,4453,4528),37)
			Result.put (new_triple (4361,4453,4529),38)
			Result.put (new_triple (4361,4453,4530),39)
			Result.put (new_triple (4361,4453,4531),40)
			Result.put (new_triple (4361,4453,4532),41)
			Result.put (new_triple (4361,4453,4533),42)
			Result.put (new_triple (4361,4453,4534),43)
			Result.put (new_triple (4361,4453,4535),44)
			Result.put (new_triple (4361,4453,4536),45)
			Result.put (new_triple (4361,4453,4537),46)
			Result.put (new_triple (4361,4453,4538),47)
			Result.put (new_triple (4361,4453,4539),48)
			Result.put (new_triple (4361,4453,4540),49)
			Result.put (new_triple (4361,4453,4541),50)
			Result.put (new_triple (4361,4453,4542),51)
			Result.put (new_triple (4361,4453,4543),52)
			Result.put (new_triple (4361,4453,4544),53)
			Result.put (new_triple (4361,4453,4545),54)
			Result.put (new_triple (4361,4453,4546),55)
			Result.put (new_pair (4361,4454),56)
			Result.put (new_triple (4361,4454,4520),57)
			Result.put (new_triple (4361,4454,4521),58)
			Result.put (new_triple (4361,4454,4522),59)
			Result.put (new_triple (4361,4454,4523),60)
			Result.put (new_triple (4361,4454,4524),61)
			Result.put (new_triple (4361,4454,4525),62)
			Result.put (new_triple (4361,4454,4526),63)
			Result.put (new_triple (4361,4454,4527),64)
			Result.put (new_triple (4361,4454,4528),65)
			Result.put (new_triple (4361,4454,4529),66)
			Result.put (new_triple (4361,4454,4530),67)
			Result.put (new_triple (4361,4454,4531),68)
			Result.put (new_triple (4361,4454,4532),69)
			Result.put (new_triple (4361,4454,4533),70)
			Result.put (new_triple (4361,4454,4534),71)
			Result.put (new_triple (4361,4454,4535),72)
			Result.put (new_triple (4361,4454,4536),73)
			Result.put (new_triple (4361,4454,4537),74)
			Result.put (new_triple (4361,4454,4538),75)
			Result.put (new_triple (4361,4454,4539),76)
			Result.put (new_triple (4361,4454,4540),77)
			Result.put (new_triple (4361,4454,4541),78)
			Result.put (new_triple (4361,4454,4542),79)
			Result.put (new_triple (4361,4454,4543),80)
			Result.put (new_triple (4361,4454,4544),81)
			Result.put (new_triple (4361,4454,4545),82)
			Result.put (new_triple (4361,4454,4546),83)
			Result.put (new_pair (4361,4455),84)
			Result.put (new_triple (4361,4455,4520),85)
			Result.put (new_triple (4361,4455,4521),86)
			Result.put (new_triple (4361,4455,4522),87)
			Result.put (new_triple (4361,4455,4523),88)
			Result.put (new_triple (4361,4455,4524),89)
			Result.put (new_triple (4361,4455,4525),90)
			Result.put (new_triple (4361,4455,4526),91)
			Result.put (new_triple (4361,4455,4527),92)
			Result.put (new_triple (4361,4455,4528),93)
			Result.put (new_triple (4361,4455,4529),94)
			Result.put (new_triple (4361,4455,4530),95)
			Result.put (new_triple (4361,4455,4531),96)
			Result.put (new_triple (4361,4455,4532),97)
			Result.put (new_triple (4361,4455,4533),98)
			Result.put (new_triple (4361,4455,4534),99)
			Result.put (new_triple (4361,4455,4535),100)
			Result.put (new_triple (4361,4455,4536),101)
			Result.put (new_triple (4361,4455,4537),102)
			Result.put (new_triple (4361,4455,4538),103)
			Result.put (new_triple (4361,4455,4539),104)
			Result.put (new_triple (4361,4455,4540),105)
			Result.put (new_triple (4361,4455,4541),106)
			Result.put (new_triple (4361,4455,4542),107)
			Result.put (new_triple (4361,4455,4543),108)
			Result.put (new_triple (4361,4455,4544),109)
			Result.put (new_triple (4361,4455,4545),110)
			Result.put (new_triple (4361,4455,4546),111)
			Result.put (new_pair (4361,4456),112)
			Result.put (new_triple (4361,4456,4520),113)
			Result.put (new_triple (4361,4456,4521),114)
			Result.put (new_triple (4361,4456,4522),115)
			Result.put (new_triple (4361,4456,4523),116)
			Result.put (new_triple (4361,4456,4524),117)
			Result.put (new_triple (4361,4456,4525),118)
			Result.put (new_triple (4361,4456,4526),119)
			Result.put (new_triple (4361,4456,4527),120)
			Result.put (new_triple (4361,4456,4528),121)
			Result.put (new_triple (4361,4456,4529),122)
			Result.put (new_triple (4361,4456,4530),123)
			Result.put (new_triple (4361,4456,4531),124)
			Result.put (new_triple (4361,4456,4532),125)
			Result.put (new_triple (4361,4456,4533),126)
			Result.put (new_triple (4361,4456,4534),127)
			Result.put (new_triple (4361,4456,4535),128)
			Result.put (new_triple (4361,4456,4536),129)
			Result.put (new_triple (4361,4456,4537),130)
			Result.put (new_triple (4361,4456,4538),131)
			Result.put (new_triple (4361,4456,4539),132)
			Result.put (new_triple (4361,4456,4540),133)
			Result.put (new_triple (4361,4456,4541),134)
			Result.put (new_triple (4361,4456,4542),135)
			Result.put (new_triple (4361,4456,4543),136)
			Result.put (new_triple (4361,4456,4544),137)
			Result.put (new_triple (4361,4456,4545),138)
			Result.put (new_triple (4361,4456,4546),139)
			Result.put (new_pair (4361,4457),140)
			Result.put (new_triple (4361,4457,4520),141)
			Result.put (new_triple (4361,4457,4521),142)
			Result.put (new_triple (4361,4457,4522),143)
			Result.put (new_triple (4361,4457,4523),144)
			Result.put (new_triple (4361,4457,4524),145)
			Result.put (new_triple (4361,4457,4525),146)
			Result.put (new_triple (4361,4457,4526),147)
			Result.put (new_triple (4361,4457,4527),148)
			Result.put (new_triple (4361,4457,4528),149)
			Result.put (new_triple (4361,4457,4529),150)
			Result.put (new_triple (4361,4457,4530),151)
			Result.put (new_triple (4361,4457,4531),152)
			Result.put (new_triple (4361,4457,4532),153)
			Result.put (new_triple (4361,4457,4533),154)
			Result.put (new_triple (4361,4457,4534),155)
			Result.put (new_triple (4361,4457,4535),156)
			Result.put (new_triple (4361,4457,4536),157)
			Result.put (new_triple (4361,4457,4537),158)
			Result.put (new_triple (4361,4457,4538),159)
			Result.put (new_triple (4361,4457,4539),160)
			Result.put (new_triple (4361,4457,4540),161)
			Result.put (new_triple (4361,4457,4541),162)
			Result.put (new_triple (4361,4457,4542),163)
			Result.put (new_triple (4361,4457,4543),164)
			Result.put (new_triple (4361,4457,4544),165)
			Result.put (new_triple (4361,4457,4545),166)
			Result.put (new_triple (4361,4457,4546),167)
			Result.put (new_pair (4361,4458),168)
			Result.put (new_triple (4361,4458,4520),169)
			Result.put (new_triple (4361,4458,4521),170)
			Result.put (new_triple (4361,4458,4522),171)
			Result.put (new_triple (4361,4458,4523),172)
			Result.put (new_triple (4361,4458,4524),173)
			Result.put (new_triple (4361,4458,4525),174)
			Result.put (new_triple (4361,4458,4526),175)
			Result.put (new_triple (4361,4458,4527),176)
			Result.put (new_triple (4361,4458,4528),177)
			Result.put (new_triple (4361,4458,4529),178)
			Result.put (new_triple (4361,4458,4530),179)
			Result.put (new_triple (4361,4458,4531),180)
			Result.put (new_triple (4361,4458,4532),181)
			Result.put (new_triple (4361,4458,4533),182)
			Result.put (new_triple (4361,4458,4534),183)
			Result.put (new_triple (4361,4458,4535),184)
			Result.put (new_triple (4361,4458,4536),185)
			Result.put (new_triple (4361,4458,4537),186)
			Result.put (new_triple (4361,4458,4538),187)
			Result.put (new_triple (4361,4458,4539),188)
			Result.put (new_triple (4361,4458,4540),189)
			Result.put (new_triple (4361,4458,4541),190)
			Result.put (new_triple (4361,4458,4542),191)
			Result.put (new_triple (4361,4458,4543),192)
			Result.put (new_triple (4361,4458,4544),193)
			Result.put (new_triple (4361,4458,4545),194)
			Result.put (new_triple (4361,4458,4546),195)
			Result.put (new_pair (4361,4459),196)
			Result.put (new_triple (4361,4459,4520),197)
			Result.put (new_triple (4361,4459,4521),198)
			Result.put (new_triple (4361,4459,4522),199)
			Result.put (new_triple (4361,4459,4523),200)
			Result.put (new_triple (4361,4459,4524),201)
			Result.put (new_triple (4361,4459,4525),202)
			Result.put (new_triple (4361,4459,4526),203)
			Result.put (new_triple (4361,4459,4527),204)
			Result.put (new_triple (4361,4459,4528),205)
			Result.put (new_triple (4361,4459,4529),206)
			Result.put (new_triple (4361,4459,4530),207)
			Result.put (new_triple (4361,4459,4531),208)
			Result.put (new_triple (4361,4459,4532),209)
			Result.put (new_triple (4361,4459,4533),210)
			Result.put (new_triple (4361,4459,4534),211)
			Result.put (new_triple (4361,4459,4535),212)
			Result.put (new_triple (4361,4459,4536),213)
			Result.put (new_triple (4361,4459,4537),214)
			Result.put (new_triple (4361,4459,4538),215)
			Result.put (new_triple (4361,4459,4539),216)
			Result.put (new_triple (4361,4459,4540),217)
			Result.put (new_triple (4361,4459,4541),218)
			Result.put (new_triple (4361,4459,4542),219)
			Result.put (new_triple (4361,4459,4543),220)
			Result.put (new_triple (4361,4459,4544),221)
			Result.put (new_triple (4361,4459,4545),222)
			Result.put (new_triple (4361,4459,4546),223)
			Result.put (new_pair (4361,4460),224)
			Result.put (new_triple (4361,4460,4520),225)
			Result.put (new_triple (4361,4460,4521),226)
			Result.put (new_triple (4361,4460,4522),227)
			Result.put (new_triple (4361,4460,4523),228)
			Result.put (new_triple (4361,4460,4524),229)
			Result.put (new_triple (4361,4460,4525),230)
			Result.put (new_triple (4361,4460,4526),231)
			Result.put (new_triple (4361,4460,4527),232)
			Result.put (new_triple (4361,4460,4528),233)
			Result.put (new_triple (4361,4460,4529),234)
			Result.put (new_triple (4361,4460,4530),235)
			Result.put (new_triple (4361,4460,4531),236)
			Result.put (new_triple (4361,4460,4532),237)
			Result.put (new_triple (4361,4460,4533),238)
			Result.put (new_triple (4361,4460,4534),239)
			Result.put (new_triple (4361,4460,4535),240)
			Result.put (new_triple (4361,4460,4536),241)
			Result.put (new_triple (4361,4460,4537),242)
			Result.put (new_triple (4361,4460,4538),243)
			Result.put (new_triple (4361,4460,4539),244)
			Result.put (new_triple (4361,4460,4540),245)
			Result.put (new_triple (4361,4460,4541),246)
			Result.put (new_triple (4361,4460,4542),247)
			Result.put (new_triple (4361,4460,4543),248)
			Result.put (new_triple (4361,4460,4544),249)
			Result.put (new_triple (4361,4460,4545),250)
			Result.put (new_triple (4361,4460,4546),251)
			Result.put (new_pair (4361,4461),252)
			Result.put (new_triple (4361,4461,4520),253)
			Result.put (new_triple (4361,4461,4521),254)
			Result.put (new_triple (4361,4461,4522),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_194: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4361,4461,4523),0)
			Result.put (new_triple (4361,4461,4524),1)
			Result.put (new_triple (4361,4461,4525),2)
			Result.put (new_triple (4361,4461,4526),3)
			Result.put (new_triple (4361,4461,4527),4)
			Result.put (new_triple (4361,4461,4528),5)
			Result.put (new_triple (4361,4461,4529),6)
			Result.put (new_triple (4361,4461,4530),7)
			Result.put (new_triple (4361,4461,4531),8)
			Result.put (new_triple (4361,4461,4532),9)
			Result.put (new_triple (4361,4461,4533),10)
			Result.put (new_triple (4361,4461,4534),11)
			Result.put (new_triple (4361,4461,4535),12)
			Result.put (new_triple (4361,4461,4536),13)
			Result.put (new_triple (4361,4461,4537),14)
			Result.put (new_triple (4361,4461,4538),15)
			Result.put (new_triple (4361,4461,4539),16)
			Result.put (new_triple (4361,4461,4540),17)
			Result.put (new_triple (4361,4461,4541),18)
			Result.put (new_triple (4361,4461,4542),19)
			Result.put (new_triple (4361,4461,4543),20)
			Result.put (new_triple (4361,4461,4544),21)
			Result.put (new_triple (4361,4461,4545),22)
			Result.put (new_triple (4361,4461,4546),23)
			Result.put (new_pair (4361,4462),24)
			Result.put (new_triple (4361,4462,4520),25)
			Result.put (new_triple (4361,4462,4521),26)
			Result.put (new_triple (4361,4462,4522),27)
			Result.put (new_triple (4361,4462,4523),28)
			Result.put (new_triple (4361,4462,4524),29)
			Result.put (new_triple (4361,4462,4525),30)
			Result.put (new_triple (4361,4462,4526),31)
			Result.put (new_triple (4361,4462,4527),32)
			Result.put (new_triple (4361,4462,4528),33)
			Result.put (new_triple (4361,4462,4529),34)
			Result.put (new_triple (4361,4462,4530),35)
			Result.put (new_triple (4361,4462,4531),36)
			Result.put (new_triple (4361,4462,4532),37)
			Result.put (new_triple (4361,4462,4533),38)
			Result.put (new_triple (4361,4462,4534),39)
			Result.put (new_triple (4361,4462,4535),40)
			Result.put (new_triple (4361,4462,4536),41)
			Result.put (new_triple (4361,4462,4537),42)
			Result.put (new_triple (4361,4462,4538),43)
			Result.put (new_triple (4361,4462,4539),44)
			Result.put (new_triple (4361,4462,4540),45)
			Result.put (new_triple (4361,4462,4541),46)
			Result.put (new_triple (4361,4462,4542),47)
			Result.put (new_triple (4361,4462,4543),48)
			Result.put (new_triple (4361,4462,4544),49)
			Result.put (new_triple (4361,4462,4545),50)
			Result.put (new_triple (4361,4462,4546),51)
			Result.put (new_pair (4361,4463),52)
			Result.put (new_triple (4361,4463,4520),53)
			Result.put (new_triple (4361,4463,4521),54)
			Result.put (new_triple (4361,4463,4522),55)
			Result.put (new_triple (4361,4463,4523),56)
			Result.put (new_triple (4361,4463,4524),57)
			Result.put (new_triple (4361,4463,4525),58)
			Result.put (new_triple (4361,4463,4526),59)
			Result.put (new_triple (4361,4463,4527),60)
			Result.put (new_triple (4361,4463,4528),61)
			Result.put (new_triple (4361,4463,4529),62)
			Result.put (new_triple (4361,4463,4530),63)
			Result.put (new_triple (4361,4463,4531),64)
			Result.put (new_triple (4361,4463,4532),65)
			Result.put (new_triple (4361,4463,4533),66)
			Result.put (new_triple (4361,4463,4534),67)
			Result.put (new_triple (4361,4463,4535),68)
			Result.put (new_triple (4361,4463,4536),69)
			Result.put (new_triple (4361,4463,4537),70)
			Result.put (new_triple (4361,4463,4538),71)
			Result.put (new_triple (4361,4463,4539),72)
			Result.put (new_triple (4361,4463,4540),73)
			Result.put (new_triple (4361,4463,4541),74)
			Result.put (new_triple (4361,4463,4542),75)
			Result.put (new_triple (4361,4463,4543),76)
			Result.put (new_triple (4361,4463,4544),77)
			Result.put (new_triple (4361,4463,4545),78)
			Result.put (new_triple (4361,4463,4546),79)
			Result.put (new_pair (4361,4464),80)
			Result.put (new_triple (4361,4464,4520),81)
			Result.put (new_triple (4361,4464,4521),82)
			Result.put (new_triple (4361,4464,4522),83)
			Result.put (new_triple (4361,4464,4523),84)
			Result.put (new_triple (4361,4464,4524),85)
			Result.put (new_triple (4361,4464,4525),86)
			Result.put (new_triple (4361,4464,4526),87)
			Result.put (new_triple (4361,4464,4527),88)
			Result.put (new_triple (4361,4464,4528),89)
			Result.put (new_triple (4361,4464,4529),90)
			Result.put (new_triple (4361,4464,4530),91)
			Result.put (new_triple (4361,4464,4531),92)
			Result.put (new_triple (4361,4464,4532),93)
			Result.put (new_triple (4361,4464,4533),94)
			Result.put (new_triple (4361,4464,4534),95)
			Result.put (new_triple (4361,4464,4535),96)
			Result.put (new_triple (4361,4464,4536),97)
			Result.put (new_triple (4361,4464,4537),98)
			Result.put (new_triple (4361,4464,4538),99)
			Result.put (new_triple (4361,4464,4539),100)
			Result.put (new_triple (4361,4464,4540),101)
			Result.put (new_triple (4361,4464,4541),102)
			Result.put (new_triple (4361,4464,4542),103)
			Result.put (new_triple (4361,4464,4543),104)
			Result.put (new_triple (4361,4464,4544),105)
			Result.put (new_triple (4361,4464,4545),106)
			Result.put (new_triple (4361,4464,4546),107)
			Result.put (new_pair (4361,4465),108)
			Result.put (new_triple (4361,4465,4520),109)
			Result.put (new_triple (4361,4465,4521),110)
			Result.put (new_triple (4361,4465,4522),111)
			Result.put (new_triple (4361,4465,4523),112)
			Result.put (new_triple (4361,4465,4524),113)
			Result.put (new_triple (4361,4465,4525),114)
			Result.put (new_triple (4361,4465,4526),115)
			Result.put (new_triple (4361,4465,4527),116)
			Result.put (new_triple (4361,4465,4528),117)
			Result.put (new_triple (4361,4465,4529),118)
			Result.put (new_triple (4361,4465,4530),119)
			Result.put (new_triple (4361,4465,4531),120)
			Result.put (new_triple (4361,4465,4532),121)
			Result.put (new_triple (4361,4465,4533),122)
			Result.put (new_triple (4361,4465,4534),123)
			Result.put (new_triple (4361,4465,4535),124)
			Result.put (new_triple (4361,4465,4536),125)
			Result.put (new_triple (4361,4465,4537),126)
			Result.put (new_triple (4361,4465,4538),127)
			Result.put (new_triple (4361,4465,4539),128)
			Result.put (new_triple (4361,4465,4540),129)
			Result.put (new_triple (4361,4465,4541),130)
			Result.put (new_triple (4361,4465,4542),131)
			Result.put (new_triple (4361,4465,4543),132)
			Result.put (new_triple (4361,4465,4544),133)
			Result.put (new_triple (4361,4465,4545),134)
			Result.put (new_triple (4361,4465,4546),135)
			Result.put (new_pair (4361,4466),136)
			Result.put (new_triple (4361,4466,4520),137)
			Result.put (new_triple (4361,4466,4521),138)
			Result.put (new_triple (4361,4466,4522),139)
			Result.put (new_triple (4361,4466,4523),140)
			Result.put (new_triple (4361,4466,4524),141)
			Result.put (new_triple (4361,4466,4525),142)
			Result.put (new_triple (4361,4466,4526),143)
			Result.put (new_triple (4361,4466,4527),144)
			Result.put (new_triple (4361,4466,4528),145)
			Result.put (new_triple (4361,4466,4529),146)
			Result.put (new_triple (4361,4466,4530),147)
			Result.put (new_triple (4361,4466,4531),148)
			Result.put (new_triple (4361,4466,4532),149)
			Result.put (new_triple (4361,4466,4533),150)
			Result.put (new_triple (4361,4466,4534),151)
			Result.put (new_triple (4361,4466,4535),152)
			Result.put (new_triple (4361,4466,4536),153)
			Result.put (new_triple (4361,4466,4537),154)
			Result.put (new_triple (4361,4466,4538),155)
			Result.put (new_triple (4361,4466,4539),156)
			Result.put (new_triple (4361,4466,4540),157)
			Result.put (new_triple (4361,4466,4541),158)
			Result.put (new_triple (4361,4466,4542),159)
			Result.put (new_triple (4361,4466,4543),160)
			Result.put (new_triple (4361,4466,4544),161)
			Result.put (new_triple (4361,4466,4545),162)
			Result.put (new_triple (4361,4466,4546),163)
			Result.put (new_pair (4361,4467),164)
			Result.put (new_triple (4361,4467,4520),165)
			Result.put (new_triple (4361,4467,4521),166)
			Result.put (new_triple (4361,4467,4522),167)
			Result.put (new_triple (4361,4467,4523),168)
			Result.put (new_triple (4361,4467,4524),169)
			Result.put (new_triple (4361,4467,4525),170)
			Result.put (new_triple (4361,4467,4526),171)
			Result.put (new_triple (4361,4467,4527),172)
			Result.put (new_triple (4361,4467,4528),173)
			Result.put (new_triple (4361,4467,4529),174)
			Result.put (new_triple (4361,4467,4530),175)
			Result.put (new_triple (4361,4467,4531),176)
			Result.put (new_triple (4361,4467,4532),177)
			Result.put (new_triple (4361,4467,4533),178)
			Result.put (new_triple (4361,4467,4534),179)
			Result.put (new_triple (4361,4467,4535),180)
			Result.put (new_triple (4361,4467,4536),181)
			Result.put (new_triple (4361,4467,4537),182)
			Result.put (new_triple (4361,4467,4538),183)
			Result.put (new_triple (4361,4467,4539),184)
			Result.put (new_triple (4361,4467,4540),185)
			Result.put (new_triple (4361,4467,4541),186)
			Result.put (new_triple (4361,4467,4542),187)
			Result.put (new_triple (4361,4467,4543),188)
			Result.put (new_triple (4361,4467,4544),189)
			Result.put (new_triple (4361,4467,4545),190)
			Result.put (new_triple (4361,4467,4546),191)
			Result.put (new_pair (4361,4468),192)
			Result.put (new_triple (4361,4468,4520),193)
			Result.put (new_triple (4361,4468,4521),194)
			Result.put (new_triple (4361,4468,4522),195)
			Result.put (new_triple (4361,4468,4523),196)
			Result.put (new_triple (4361,4468,4524),197)
			Result.put (new_triple (4361,4468,4525),198)
			Result.put (new_triple (4361,4468,4526),199)
			Result.put (new_triple (4361,4468,4527),200)
			Result.put (new_triple (4361,4468,4528),201)
			Result.put (new_triple (4361,4468,4529),202)
			Result.put (new_triple (4361,4468,4530),203)
			Result.put (new_triple (4361,4468,4531),204)
			Result.put (new_triple (4361,4468,4532),205)
			Result.put (new_triple (4361,4468,4533),206)
			Result.put (new_triple (4361,4468,4534),207)
			Result.put (new_triple (4361,4468,4535),208)
			Result.put (new_triple (4361,4468,4536),209)
			Result.put (new_triple (4361,4468,4537),210)
			Result.put (new_triple (4361,4468,4538),211)
			Result.put (new_triple (4361,4468,4539),212)
			Result.put (new_triple (4361,4468,4540),213)
			Result.put (new_triple (4361,4468,4541),214)
			Result.put (new_triple (4361,4468,4542),215)
			Result.put (new_triple (4361,4468,4543),216)
			Result.put (new_triple (4361,4468,4544),217)
			Result.put (new_triple (4361,4468,4545),218)
			Result.put (new_triple (4361,4468,4546),219)
			Result.put (new_pair (4361,4469),220)
			Result.put (new_triple (4361,4469,4520),221)
			Result.put (new_triple (4361,4469,4521),222)
			Result.put (new_triple (4361,4469,4522),223)
			Result.put (new_triple (4361,4469,4523),224)
			Result.put (new_triple (4361,4469,4524),225)
			Result.put (new_triple (4361,4469,4525),226)
			Result.put (new_triple (4361,4469,4526),227)
			Result.put (new_triple (4361,4469,4527),228)
			Result.put (new_triple (4361,4469,4528),229)
			Result.put (new_triple (4361,4469,4529),230)
			Result.put (new_triple (4361,4469,4530),231)
			Result.put (new_triple (4361,4469,4531),232)
			Result.put (new_triple (4361,4469,4532),233)
			Result.put (new_triple (4361,4469,4533),234)
			Result.put (new_triple (4361,4469,4534),235)
			Result.put (new_triple (4361,4469,4535),236)
			Result.put (new_triple (4361,4469,4536),237)
			Result.put (new_triple (4361,4469,4537),238)
			Result.put (new_triple (4361,4469,4538),239)
			Result.put (new_triple (4361,4469,4539),240)
			Result.put (new_triple (4361,4469,4540),241)
			Result.put (new_triple (4361,4469,4541),242)
			Result.put (new_triple (4361,4469,4542),243)
			Result.put (new_triple (4361,4469,4543),244)
			Result.put (new_triple (4361,4469,4544),245)
			Result.put (new_triple (4361,4469,4545),246)
			Result.put (new_triple (4361,4469,4546),247)
			Result.put (new_pair (4362,4449),248)
			Result.put (new_triple (4362,4449,4520),249)
			Result.put (new_triple (4362,4449,4521),250)
			Result.put (new_triple (4362,4449,4522),251)
			Result.put (new_triple (4362,4449,4523),252)
			Result.put (new_triple (4362,4449,4524),253)
			Result.put (new_triple (4362,4449,4525),254)
			Result.put (new_triple (4362,4449,4526),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_195: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4362,4449,4527),0)
			Result.put (new_triple (4362,4449,4528),1)
			Result.put (new_triple (4362,4449,4529),2)
			Result.put (new_triple (4362,4449,4530),3)
			Result.put (new_triple (4362,4449,4531),4)
			Result.put (new_triple (4362,4449,4532),5)
			Result.put (new_triple (4362,4449,4533),6)
			Result.put (new_triple (4362,4449,4534),7)
			Result.put (new_triple (4362,4449,4535),8)
			Result.put (new_triple (4362,4449,4536),9)
			Result.put (new_triple (4362,4449,4537),10)
			Result.put (new_triple (4362,4449,4538),11)
			Result.put (new_triple (4362,4449,4539),12)
			Result.put (new_triple (4362,4449,4540),13)
			Result.put (new_triple (4362,4449,4541),14)
			Result.put (new_triple (4362,4449,4542),15)
			Result.put (new_triple (4362,4449,4543),16)
			Result.put (new_triple (4362,4449,4544),17)
			Result.put (new_triple (4362,4449,4545),18)
			Result.put (new_triple (4362,4449,4546),19)
			Result.put (new_pair (4362,4450),20)
			Result.put (new_triple (4362,4450,4520),21)
			Result.put (new_triple (4362,4450,4521),22)
			Result.put (new_triple (4362,4450,4522),23)
			Result.put (new_triple (4362,4450,4523),24)
			Result.put (new_triple (4362,4450,4524),25)
			Result.put (new_triple (4362,4450,4525),26)
			Result.put (new_triple (4362,4450,4526),27)
			Result.put (new_triple (4362,4450,4527),28)
			Result.put (new_triple (4362,4450,4528),29)
			Result.put (new_triple (4362,4450,4529),30)
			Result.put (new_triple (4362,4450,4530),31)
			Result.put (new_triple (4362,4450,4531),32)
			Result.put (new_triple (4362,4450,4532),33)
			Result.put (new_triple (4362,4450,4533),34)
			Result.put (new_triple (4362,4450,4534),35)
			Result.put (new_triple (4362,4450,4535),36)
			Result.put (new_triple (4362,4450,4536),37)
			Result.put (new_triple (4362,4450,4537),38)
			Result.put (new_triple (4362,4450,4538),39)
			Result.put (new_triple (4362,4450,4539),40)
			Result.put (new_triple (4362,4450,4540),41)
			Result.put (new_triple (4362,4450,4541),42)
			Result.put (new_triple (4362,4450,4542),43)
			Result.put (new_triple (4362,4450,4543),44)
			Result.put (new_triple (4362,4450,4544),45)
			Result.put (new_triple (4362,4450,4545),46)
			Result.put (new_triple (4362,4450,4546),47)
			Result.put (new_pair (4362,4451),48)
			Result.put (new_triple (4362,4451,4520),49)
			Result.put (new_triple (4362,4451,4521),50)
			Result.put (new_triple (4362,4451,4522),51)
			Result.put (new_triple (4362,4451,4523),52)
			Result.put (new_triple (4362,4451,4524),53)
			Result.put (new_triple (4362,4451,4525),54)
			Result.put (new_triple (4362,4451,4526),55)
			Result.put (new_triple (4362,4451,4527),56)
			Result.put (new_triple (4362,4451,4528),57)
			Result.put (new_triple (4362,4451,4529),58)
			Result.put (new_triple (4362,4451,4530),59)
			Result.put (new_triple (4362,4451,4531),60)
			Result.put (new_triple (4362,4451,4532),61)
			Result.put (new_triple (4362,4451,4533),62)
			Result.put (new_triple (4362,4451,4534),63)
			Result.put (new_triple (4362,4451,4535),64)
			Result.put (new_triple (4362,4451,4536),65)
			Result.put (new_triple (4362,4451,4537),66)
			Result.put (new_triple (4362,4451,4538),67)
			Result.put (new_triple (4362,4451,4539),68)
			Result.put (new_triple (4362,4451,4540),69)
			Result.put (new_triple (4362,4451,4541),70)
			Result.put (new_triple (4362,4451,4542),71)
			Result.put (new_triple (4362,4451,4543),72)
			Result.put (new_triple (4362,4451,4544),73)
			Result.put (new_triple (4362,4451,4545),74)
			Result.put (new_triple (4362,4451,4546),75)
			Result.put (new_pair (4362,4452),76)
			Result.put (new_triple (4362,4452,4520),77)
			Result.put (new_triple (4362,4452,4521),78)
			Result.put (new_triple (4362,4452,4522),79)
			Result.put (new_triple (4362,4452,4523),80)
			Result.put (new_triple (4362,4452,4524),81)
			Result.put (new_triple (4362,4452,4525),82)
			Result.put (new_triple (4362,4452,4526),83)
			Result.put (new_triple (4362,4452,4527),84)
			Result.put (new_triple (4362,4452,4528),85)
			Result.put (new_triple (4362,4452,4529),86)
			Result.put (new_triple (4362,4452,4530),87)
			Result.put (new_triple (4362,4452,4531),88)
			Result.put (new_triple (4362,4452,4532),89)
			Result.put (new_triple (4362,4452,4533),90)
			Result.put (new_triple (4362,4452,4534),91)
			Result.put (new_triple (4362,4452,4535),92)
			Result.put (new_triple (4362,4452,4536),93)
			Result.put (new_triple (4362,4452,4537),94)
			Result.put (new_triple (4362,4452,4538),95)
			Result.put (new_triple (4362,4452,4539),96)
			Result.put (new_triple (4362,4452,4540),97)
			Result.put (new_triple (4362,4452,4541),98)
			Result.put (new_triple (4362,4452,4542),99)
			Result.put (new_triple (4362,4452,4543),100)
			Result.put (new_triple (4362,4452,4544),101)
			Result.put (new_triple (4362,4452,4545),102)
			Result.put (new_triple (4362,4452,4546),103)
			Result.put (new_pair (4362,4453),104)
			Result.put (new_triple (4362,4453,4520),105)
			Result.put (new_triple (4362,4453,4521),106)
			Result.put (new_triple (4362,4453,4522),107)
			Result.put (new_triple (4362,4453,4523),108)
			Result.put (new_triple (4362,4453,4524),109)
			Result.put (new_triple (4362,4453,4525),110)
			Result.put (new_triple (4362,4453,4526),111)
			Result.put (new_triple (4362,4453,4527),112)
			Result.put (new_triple (4362,4453,4528),113)
			Result.put (new_triple (4362,4453,4529),114)
			Result.put (new_triple (4362,4453,4530),115)
			Result.put (new_triple (4362,4453,4531),116)
			Result.put (new_triple (4362,4453,4532),117)
			Result.put (new_triple (4362,4453,4533),118)
			Result.put (new_triple (4362,4453,4534),119)
			Result.put (new_triple (4362,4453,4535),120)
			Result.put (new_triple (4362,4453,4536),121)
			Result.put (new_triple (4362,4453,4537),122)
			Result.put (new_triple (4362,4453,4538),123)
			Result.put (new_triple (4362,4453,4539),124)
			Result.put (new_triple (4362,4453,4540),125)
			Result.put (new_triple (4362,4453,4541),126)
			Result.put (new_triple (4362,4453,4542),127)
			Result.put (new_triple (4362,4453,4543),128)
			Result.put (new_triple (4362,4453,4544),129)
			Result.put (new_triple (4362,4453,4545),130)
			Result.put (new_triple (4362,4453,4546),131)
			Result.put (new_pair (4362,4454),132)
			Result.put (new_triple (4362,4454,4520),133)
			Result.put (new_triple (4362,4454,4521),134)
			Result.put (new_triple (4362,4454,4522),135)
			Result.put (new_triple (4362,4454,4523),136)
			Result.put (new_triple (4362,4454,4524),137)
			Result.put (new_triple (4362,4454,4525),138)
			Result.put (new_triple (4362,4454,4526),139)
			Result.put (new_triple (4362,4454,4527),140)
			Result.put (new_triple (4362,4454,4528),141)
			Result.put (new_triple (4362,4454,4529),142)
			Result.put (new_triple (4362,4454,4530),143)
			Result.put (new_triple (4362,4454,4531),144)
			Result.put (new_triple (4362,4454,4532),145)
			Result.put (new_triple (4362,4454,4533),146)
			Result.put (new_triple (4362,4454,4534),147)
			Result.put (new_triple (4362,4454,4535),148)
			Result.put (new_triple (4362,4454,4536),149)
			Result.put (new_triple (4362,4454,4537),150)
			Result.put (new_triple (4362,4454,4538),151)
			Result.put (new_triple (4362,4454,4539),152)
			Result.put (new_triple (4362,4454,4540),153)
			Result.put (new_triple (4362,4454,4541),154)
			Result.put (new_triple (4362,4454,4542),155)
			Result.put (new_triple (4362,4454,4543),156)
			Result.put (new_triple (4362,4454,4544),157)
			Result.put (new_triple (4362,4454,4545),158)
			Result.put (new_triple (4362,4454,4546),159)
			Result.put (new_pair (4362,4455),160)
			Result.put (new_triple (4362,4455,4520),161)
			Result.put (new_triple (4362,4455,4521),162)
			Result.put (new_triple (4362,4455,4522),163)
			Result.put (new_triple (4362,4455,4523),164)
			Result.put (new_triple (4362,4455,4524),165)
			Result.put (new_triple (4362,4455,4525),166)
			Result.put (new_triple (4362,4455,4526),167)
			Result.put (new_triple (4362,4455,4527),168)
			Result.put (new_triple (4362,4455,4528),169)
			Result.put (new_triple (4362,4455,4529),170)
			Result.put (new_triple (4362,4455,4530),171)
			Result.put (new_triple (4362,4455,4531),172)
			Result.put (new_triple (4362,4455,4532),173)
			Result.put (new_triple (4362,4455,4533),174)
			Result.put (new_triple (4362,4455,4534),175)
			Result.put (new_triple (4362,4455,4535),176)
			Result.put (new_triple (4362,4455,4536),177)
			Result.put (new_triple (4362,4455,4537),178)
			Result.put (new_triple (4362,4455,4538),179)
			Result.put (new_triple (4362,4455,4539),180)
			Result.put (new_triple (4362,4455,4540),181)
			Result.put (new_triple (4362,4455,4541),182)
			Result.put (new_triple (4362,4455,4542),183)
			Result.put (new_triple (4362,4455,4543),184)
			Result.put (new_triple (4362,4455,4544),185)
			Result.put (new_triple (4362,4455,4545),186)
			Result.put (new_triple (4362,4455,4546),187)
			Result.put (new_pair (4362,4456),188)
			Result.put (new_triple (4362,4456,4520),189)
			Result.put (new_triple (4362,4456,4521),190)
			Result.put (new_triple (4362,4456,4522),191)
			Result.put (new_triple (4362,4456,4523),192)
			Result.put (new_triple (4362,4456,4524),193)
			Result.put (new_triple (4362,4456,4525),194)
			Result.put (new_triple (4362,4456,4526),195)
			Result.put (new_triple (4362,4456,4527),196)
			Result.put (new_triple (4362,4456,4528),197)
			Result.put (new_triple (4362,4456,4529),198)
			Result.put (new_triple (4362,4456,4530),199)
			Result.put (new_triple (4362,4456,4531),200)
			Result.put (new_triple (4362,4456,4532),201)
			Result.put (new_triple (4362,4456,4533),202)
			Result.put (new_triple (4362,4456,4534),203)
			Result.put (new_triple (4362,4456,4535),204)
			Result.put (new_triple (4362,4456,4536),205)
			Result.put (new_triple (4362,4456,4537),206)
			Result.put (new_triple (4362,4456,4538),207)
			Result.put (new_triple (4362,4456,4539),208)
			Result.put (new_triple (4362,4456,4540),209)
			Result.put (new_triple (4362,4456,4541),210)
			Result.put (new_triple (4362,4456,4542),211)
			Result.put (new_triple (4362,4456,4543),212)
			Result.put (new_triple (4362,4456,4544),213)
			Result.put (new_triple (4362,4456,4545),214)
			Result.put (new_triple (4362,4456,4546),215)
			Result.put (new_pair (4362,4457),216)
			Result.put (new_triple (4362,4457,4520),217)
			Result.put (new_triple (4362,4457,4521),218)
			Result.put (new_triple (4362,4457,4522),219)
			Result.put (new_triple (4362,4457,4523),220)
			Result.put (new_triple (4362,4457,4524),221)
			Result.put (new_triple (4362,4457,4525),222)
			Result.put (new_triple (4362,4457,4526),223)
			Result.put (new_triple (4362,4457,4527),224)
			Result.put (new_triple (4362,4457,4528),225)
			Result.put (new_triple (4362,4457,4529),226)
			Result.put (new_triple (4362,4457,4530),227)
			Result.put (new_triple (4362,4457,4531),228)
			Result.put (new_triple (4362,4457,4532),229)
			Result.put (new_triple (4362,4457,4533),230)
			Result.put (new_triple (4362,4457,4534),231)
			Result.put (new_triple (4362,4457,4535),232)
			Result.put (new_triple (4362,4457,4536),233)
			Result.put (new_triple (4362,4457,4537),234)
			Result.put (new_triple (4362,4457,4538),235)
			Result.put (new_triple (4362,4457,4539),236)
			Result.put (new_triple (4362,4457,4540),237)
			Result.put (new_triple (4362,4457,4541),238)
			Result.put (new_triple (4362,4457,4542),239)
			Result.put (new_triple (4362,4457,4543),240)
			Result.put (new_triple (4362,4457,4544),241)
			Result.put (new_triple (4362,4457,4545),242)
			Result.put (new_triple (4362,4457,4546),243)
			Result.put (new_pair (4362,4458),244)
			Result.put (new_triple (4362,4458,4520),245)
			Result.put (new_triple (4362,4458,4521),246)
			Result.put (new_triple (4362,4458,4522),247)
			Result.put (new_triple (4362,4458,4523),248)
			Result.put (new_triple (4362,4458,4524),249)
			Result.put (new_triple (4362,4458,4525),250)
			Result.put (new_triple (4362,4458,4526),251)
			Result.put (new_triple (4362,4458,4527),252)
			Result.put (new_triple (4362,4458,4528),253)
			Result.put (new_triple (4362,4458,4529),254)
			Result.put (new_triple (4362,4458,4530),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_196: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4362,4458,4531),0)
			Result.put (new_triple (4362,4458,4532),1)
			Result.put (new_triple (4362,4458,4533),2)
			Result.put (new_triple (4362,4458,4534),3)
			Result.put (new_triple (4362,4458,4535),4)
			Result.put (new_triple (4362,4458,4536),5)
			Result.put (new_triple (4362,4458,4537),6)
			Result.put (new_triple (4362,4458,4538),7)
			Result.put (new_triple (4362,4458,4539),8)
			Result.put (new_triple (4362,4458,4540),9)
			Result.put (new_triple (4362,4458,4541),10)
			Result.put (new_triple (4362,4458,4542),11)
			Result.put (new_triple (4362,4458,4543),12)
			Result.put (new_triple (4362,4458,4544),13)
			Result.put (new_triple (4362,4458,4545),14)
			Result.put (new_triple (4362,4458,4546),15)
			Result.put (new_pair (4362,4459),16)
			Result.put (new_triple (4362,4459,4520),17)
			Result.put (new_triple (4362,4459,4521),18)
			Result.put (new_triple (4362,4459,4522),19)
			Result.put (new_triple (4362,4459,4523),20)
			Result.put (new_triple (4362,4459,4524),21)
			Result.put (new_triple (4362,4459,4525),22)
			Result.put (new_triple (4362,4459,4526),23)
			Result.put (new_triple (4362,4459,4527),24)
			Result.put (new_triple (4362,4459,4528),25)
			Result.put (new_triple (4362,4459,4529),26)
			Result.put (new_triple (4362,4459,4530),27)
			Result.put (new_triple (4362,4459,4531),28)
			Result.put (new_triple (4362,4459,4532),29)
			Result.put (new_triple (4362,4459,4533),30)
			Result.put (new_triple (4362,4459,4534),31)
			Result.put (new_triple (4362,4459,4535),32)
			Result.put (new_triple (4362,4459,4536),33)
			Result.put (new_triple (4362,4459,4537),34)
			Result.put (new_triple (4362,4459,4538),35)
			Result.put (new_triple (4362,4459,4539),36)
			Result.put (new_triple (4362,4459,4540),37)
			Result.put (new_triple (4362,4459,4541),38)
			Result.put (new_triple (4362,4459,4542),39)
			Result.put (new_triple (4362,4459,4543),40)
			Result.put (new_triple (4362,4459,4544),41)
			Result.put (new_triple (4362,4459,4545),42)
			Result.put (new_triple (4362,4459,4546),43)
			Result.put (new_pair (4362,4460),44)
			Result.put (new_triple (4362,4460,4520),45)
			Result.put (new_triple (4362,4460,4521),46)
			Result.put (new_triple (4362,4460,4522),47)
			Result.put (new_triple (4362,4460,4523),48)
			Result.put (new_triple (4362,4460,4524),49)
			Result.put (new_triple (4362,4460,4525),50)
			Result.put (new_triple (4362,4460,4526),51)
			Result.put (new_triple (4362,4460,4527),52)
			Result.put (new_triple (4362,4460,4528),53)
			Result.put (new_triple (4362,4460,4529),54)
			Result.put (new_triple (4362,4460,4530),55)
			Result.put (new_triple (4362,4460,4531),56)
			Result.put (new_triple (4362,4460,4532),57)
			Result.put (new_triple (4362,4460,4533),58)
			Result.put (new_triple (4362,4460,4534),59)
			Result.put (new_triple (4362,4460,4535),60)
			Result.put (new_triple (4362,4460,4536),61)
			Result.put (new_triple (4362,4460,4537),62)
			Result.put (new_triple (4362,4460,4538),63)
			Result.put (new_triple (4362,4460,4539),64)
			Result.put (new_triple (4362,4460,4540),65)
			Result.put (new_triple (4362,4460,4541),66)
			Result.put (new_triple (4362,4460,4542),67)
			Result.put (new_triple (4362,4460,4543),68)
			Result.put (new_triple (4362,4460,4544),69)
			Result.put (new_triple (4362,4460,4545),70)
			Result.put (new_triple (4362,4460,4546),71)
			Result.put (new_pair (4362,4461),72)
			Result.put (new_triple (4362,4461,4520),73)
			Result.put (new_triple (4362,4461,4521),74)
			Result.put (new_triple (4362,4461,4522),75)
			Result.put (new_triple (4362,4461,4523),76)
			Result.put (new_triple (4362,4461,4524),77)
			Result.put (new_triple (4362,4461,4525),78)
			Result.put (new_triple (4362,4461,4526),79)
			Result.put (new_triple (4362,4461,4527),80)
			Result.put (new_triple (4362,4461,4528),81)
			Result.put (new_triple (4362,4461,4529),82)
			Result.put (new_triple (4362,4461,4530),83)
			Result.put (new_triple (4362,4461,4531),84)
			Result.put (new_triple (4362,4461,4532),85)
			Result.put (new_triple (4362,4461,4533),86)
			Result.put (new_triple (4362,4461,4534),87)
			Result.put (new_triple (4362,4461,4535),88)
			Result.put (new_triple (4362,4461,4536),89)
			Result.put (new_triple (4362,4461,4537),90)
			Result.put (new_triple (4362,4461,4538),91)
			Result.put (new_triple (4362,4461,4539),92)
			Result.put (new_triple (4362,4461,4540),93)
			Result.put (new_triple (4362,4461,4541),94)
			Result.put (new_triple (4362,4461,4542),95)
			Result.put (new_triple (4362,4461,4543),96)
			Result.put (new_triple (4362,4461,4544),97)
			Result.put (new_triple (4362,4461,4545),98)
			Result.put (new_triple (4362,4461,4546),99)
			Result.put (new_pair (4362,4462),100)
			Result.put (new_triple (4362,4462,4520),101)
			Result.put (new_triple (4362,4462,4521),102)
			Result.put (new_triple (4362,4462,4522),103)
			Result.put (new_triple (4362,4462,4523),104)
			Result.put (new_triple (4362,4462,4524),105)
			Result.put (new_triple (4362,4462,4525),106)
			Result.put (new_triple (4362,4462,4526),107)
			Result.put (new_triple (4362,4462,4527),108)
			Result.put (new_triple (4362,4462,4528),109)
			Result.put (new_triple (4362,4462,4529),110)
			Result.put (new_triple (4362,4462,4530),111)
			Result.put (new_triple (4362,4462,4531),112)
			Result.put (new_triple (4362,4462,4532),113)
			Result.put (new_triple (4362,4462,4533),114)
			Result.put (new_triple (4362,4462,4534),115)
			Result.put (new_triple (4362,4462,4535),116)
			Result.put (new_triple (4362,4462,4536),117)
			Result.put (new_triple (4362,4462,4537),118)
			Result.put (new_triple (4362,4462,4538),119)
			Result.put (new_triple (4362,4462,4539),120)
			Result.put (new_triple (4362,4462,4540),121)
			Result.put (new_triple (4362,4462,4541),122)
			Result.put (new_triple (4362,4462,4542),123)
			Result.put (new_triple (4362,4462,4543),124)
			Result.put (new_triple (4362,4462,4544),125)
			Result.put (new_triple (4362,4462,4545),126)
			Result.put (new_triple (4362,4462,4546),127)
			Result.put (new_pair (4362,4463),128)
			Result.put (new_triple (4362,4463,4520),129)
			Result.put (new_triple (4362,4463,4521),130)
			Result.put (new_triple (4362,4463,4522),131)
			Result.put (new_triple (4362,4463,4523),132)
			Result.put (new_triple (4362,4463,4524),133)
			Result.put (new_triple (4362,4463,4525),134)
			Result.put (new_triple (4362,4463,4526),135)
			Result.put (new_triple (4362,4463,4527),136)
			Result.put (new_triple (4362,4463,4528),137)
			Result.put (new_triple (4362,4463,4529),138)
			Result.put (new_triple (4362,4463,4530),139)
			Result.put (new_triple (4362,4463,4531),140)
			Result.put (new_triple (4362,4463,4532),141)
			Result.put (new_triple (4362,4463,4533),142)
			Result.put (new_triple (4362,4463,4534),143)
			Result.put (new_triple (4362,4463,4535),144)
			Result.put (new_triple (4362,4463,4536),145)
			Result.put (new_triple (4362,4463,4537),146)
			Result.put (new_triple (4362,4463,4538),147)
			Result.put (new_triple (4362,4463,4539),148)
			Result.put (new_triple (4362,4463,4540),149)
			Result.put (new_triple (4362,4463,4541),150)
			Result.put (new_triple (4362,4463,4542),151)
			Result.put (new_triple (4362,4463,4543),152)
			Result.put (new_triple (4362,4463,4544),153)
			Result.put (new_triple (4362,4463,4545),154)
			Result.put (new_triple (4362,4463,4546),155)
			Result.put (new_pair (4362,4464),156)
			Result.put (new_triple (4362,4464,4520),157)
			Result.put (new_triple (4362,4464,4521),158)
			Result.put (new_triple (4362,4464,4522),159)
			Result.put (new_triple (4362,4464,4523),160)
			Result.put (new_triple (4362,4464,4524),161)
			Result.put (new_triple (4362,4464,4525),162)
			Result.put (new_triple (4362,4464,4526),163)
			Result.put (new_triple (4362,4464,4527),164)
			Result.put (new_triple (4362,4464,4528),165)
			Result.put (new_triple (4362,4464,4529),166)
			Result.put (new_triple (4362,4464,4530),167)
			Result.put (new_triple (4362,4464,4531),168)
			Result.put (new_triple (4362,4464,4532),169)
			Result.put (new_triple (4362,4464,4533),170)
			Result.put (new_triple (4362,4464,4534),171)
			Result.put (new_triple (4362,4464,4535),172)
			Result.put (new_triple (4362,4464,4536),173)
			Result.put (new_triple (4362,4464,4537),174)
			Result.put (new_triple (4362,4464,4538),175)
			Result.put (new_triple (4362,4464,4539),176)
			Result.put (new_triple (4362,4464,4540),177)
			Result.put (new_triple (4362,4464,4541),178)
			Result.put (new_triple (4362,4464,4542),179)
			Result.put (new_triple (4362,4464,4543),180)
			Result.put (new_triple (4362,4464,4544),181)
			Result.put (new_triple (4362,4464,4545),182)
			Result.put (new_triple (4362,4464,4546),183)
			Result.put (new_pair (4362,4465),184)
			Result.put (new_triple (4362,4465,4520),185)
			Result.put (new_triple (4362,4465,4521),186)
			Result.put (new_triple (4362,4465,4522),187)
			Result.put (new_triple (4362,4465,4523),188)
			Result.put (new_triple (4362,4465,4524),189)
			Result.put (new_triple (4362,4465,4525),190)
			Result.put (new_triple (4362,4465,4526),191)
			Result.put (new_triple (4362,4465,4527),192)
			Result.put (new_triple (4362,4465,4528),193)
			Result.put (new_triple (4362,4465,4529),194)
			Result.put (new_triple (4362,4465,4530),195)
			Result.put (new_triple (4362,4465,4531),196)
			Result.put (new_triple (4362,4465,4532),197)
			Result.put (new_triple (4362,4465,4533),198)
			Result.put (new_triple (4362,4465,4534),199)
			Result.put (new_triple (4362,4465,4535),200)
			Result.put (new_triple (4362,4465,4536),201)
			Result.put (new_triple (4362,4465,4537),202)
			Result.put (new_triple (4362,4465,4538),203)
			Result.put (new_triple (4362,4465,4539),204)
			Result.put (new_triple (4362,4465,4540),205)
			Result.put (new_triple (4362,4465,4541),206)
			Result.put (new_triple (4362,4465,4542),207)
			Result.put (new_triple (4362,4465,4543),208)
			Result.put (new_triple (4362,4465,4544),209)
			Result.put (new_triple (4362,4465,4545),210)
			Result.put (new_triple (4362,4465,4546),211)
			Result.put (new_pair (4362,4466),212)
			Result.put (new_triple (4362,4466,4520),213)
			Result.put (new_triple (4362,4466,4521),214)
			Result.put (new_triple (4362,4466,4522),215)
			Result.put (new_triple (4362,4466,4523),216)
			Result.put (new_triple (4362,4466,4524),217)
			Result.put (new_triple (4362,4466,4525),218)
			Result.put (new_triple (4362,4466,4526),219)
			Result.put (new_triple (4362,4466,4527),220)
			Result.put (new_triple (4362,4466,4528),221)
			Result.put (new_triple (4362,4466,4529),222)
			Result.put (new_triple (4362,4466,4530),223)
			Result.put (new_triple (4362,4466,4531),224)
			Result.put (new_triple (4362,4466,4532),225)
			Result.put (new_triple (4362,4466,4533),226)
			Result.put (new_triple (4362,4466,4534),227)
			Result.put (new_triple (4362,4466,4535),228)
			Result.put (new_triple (4362,4466,4536),229)
			Result.put (new_triple (4362,4466,4537),230)
			Result.put (new_triple (4362,4466,4538),231)
			Result.put (new_triple (4362,4466,4539),232)
			Result.put (new_triple (4362,4466,4540),233)
			Result.put (new_triple (4362,4466,4541),234)
			Result.put (new_triple (4362,4466,4542),235)
			Result.put (new_triple (4362,4466,4543),236)
			Result.put (new_triple (4362,4466,4544),237)
			Result.put (new_triple (4362,4466,4545),238)
			Result.put (new_triple (4362,4466,4546),239)
			Result.put (new_pair (4362,4467),240)
			Result.put (new_triple (4362,4467,4520),241)
			Result.put (new_triple (4362,4467,4521),242)
			Result.put (new_triple (4362,4467,4522),243)
			Result.put (new_triple (4362,4467,4523),244)
			Result.put (new_triple (4362,4467,4524),245)
			Result.put (new_triple (4362,4467,4525),246)
			Result.put (new_triple (4362,4467,4526),247)
			Result.put (new_triple (4362,4467,4527),248)
			Result.put (new_triple (4362,4467,4528),249)
			Result.put (new_triple (4362,4467,4529),250)
			Result.put (new_triple (4362,4467,4530),251)
			Result.put (new_triple (4362,4467,4531),252)
			Result.put (new_triple (4362,4467,4532),253)
			Result.put (new_triple (4362,4467,4533),254)
			Result.put (new_triple (4362,4467,4534),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_197: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4362,4467,4535),0)
			Result.put (new_triple (4362,4467,4536),1)
			Result.put (new_triple (4362,4467,4537),2)
			Result.put (new_triple (4362,4467,4538),3)
			Result.put (new_triple (4362,4467,4539),4)
			Result.put (new_triple (4362,4467,4540),5)
			Result.put (new_triple (4362,4467,4541),6)
			Result.put (new_triple (4362,4467,4542),7)
			Result.put (new_triple (4362,4467,4543),8)
			Result.put (new_triple (4362,4467,4544),9)
			Result.put (new_triple (4362,4467,4545),10)
			Result.put (new_triple (4362,4467,4546),11)
			Result.put (new_pair (4362,4468),12)
			Result.put (new_triple (4362,4468,4520),13)
			Result.put (new_triple (4362,4468,4521),14)
			Result.put (new_triple (4362,4468,4522),15)
			Result.put (new_triple (4362,4468,4523),16)
			Result.put (new_triple (4362,4468,4524),17)
			Result.put (new_triple (4362,4468,4525),18)
			Result.put (new_triple (4362,4468,4526),19)
			Result.put (new_triple (4362,4468,4527),20)
			Result.put (new_triple (4362,4468,4528),21)
			Result.put (new_triple (4362,4468,4529),22)
			Result.put (new_triple (4362,4468,4530),23)
			Result.put (new_triple (4362,4468,4531),24)
			Result.put (new_triple (4362,4468,4532),25)
			Result.put (new_triple (4362,4468,4533),26)
			Result.put (new_triple (4362,4468,4534),27)
			Result.put (new_triple (4362,4468,4535),28)
			Result.put (new_triple (4362,4468,4536),29)
			Result.put (new_triple (4362,4468,4537),30)
			Result.put (new_triple (4362,4468,4538),31)
			Result.put (new_triple (4362,4468,4539),32)
			Result.put (new_triple (4362,4468,4540),33)
			Result.put (new_triple (4362,4468,4541),34)
			Result.put (new_triple (4362,4468,4542),35)
			Result.put (new_triple (4362,4468,4543),36)
			Result.put (new_triple (4362,4468,4544),37)
			Result.put (new_triple (4362,4468,4545),38)
			Result.put (new_triple (4362,4468,4546),39)
			Result.put (new_pair (4362,4469),40)
			Result.put (new_triple (4362,4469,4520),41)
			Result.put (new_triple (4362,4469,4521),42)
			Result.put (new_triple (4362,4469,4522),43)
			Result.put (new_triple (4362,4469,4523),44)
			Result.put (new_triple (4362,4469,4524),45)
			Result.put (new_triple (4362,4469,4525),46)
			Result.put (new_triple (4362,4469,4526),47)
			Result.put (new_triple (4362,4469,4527),48)
			Result.put (new_triple (4362,4469,4528),49)
			Result.put (new_triple (4362,4469,4529),50)
			Result.put (new_triple (4362,4469,4530),51)
			Result.put (new_triple (4362,4469,4531),52)
			Result.put (new_triple (4362,4469,4532),53)
			Result.put (new_triple (4362,4469,4533),54)
			Result.put (new_triple (4362,4469,4534),55)
			Result.put (new_triple (4362,4469,4535),56)
			Result.put (new_triple (4362,4469,4536),57)
			Result.put (new_triple (4362,4469,4537),58)
			Result.put (new_triple (4362,4469,4538),59)
			Result.put (new_triple (4362,4469,4539),60)
			Result.put (new_triple (4362,4469,4540),61)
			Result.put (new_triple (4362,4469,4541),62)
			Result.put (new_triple (4362,4469,4542),63)
			Result.put (new_triple (4362,4469,4543),64)
			Result.put (new_triple (4362,4469,4544),65)
			Result.put (new_triple (4362,4469,4545),66)
			Result.put (new_triple (4362,4469,4546),67)
			Result.put (new_pair (4363,4449),68)
			Result.put (new_triple (4363,4449,4520),69)
			Result.put (new_triple (4363,4449,4521),70)
			Result.put (new_triple (4363,4449,4522),71)
			Result.put (new_triple (4363,4449,4523),72)
			Result.put (new_triple (4363,4449,4524),73)
			Result.put (new_triple (4363,4449,4525),74)
			Result.put (new_triple (4363,4449,4526),75)
			Result.put (new_triple (4363,4449,4527),76)
			Result.put (new_triple (4363,4449,4528),77)
			Result.put (new_triple (4363,4449,4529),78)
			Result.put (new_triple (4363,4449,4530),79)
			Result.put (new_triple (4363,4449,4531),80)
			Result.put (new_triple (4363,4449,4532),81)
			Result.put (new_triple (4363,4449,4533),82)
			Result.put (new_triple (4363,4449,4534),83)
			Result.put (new_triple (4363,4449,4535),84)
			Result.put (new_triple (4363,4449,4536),85)
			Result.put (new_triple (4363,4449,4537),86)
			Result.put (new_triple (4363,4449,4538),87)
			Result.put (new_triple (4363,4449,4539),88)
			Result.put (new_triple (4363,4449,4540),89)
			Result.put (new_triple (4363,4449,4541),90)
			Result.put (new_triple (4363,4449,4542),91)
			Result.put (new_triple (4363,4449,4543),92)
			Result.put (new_triple (4363,4449,4544),93)
			Result.put (new_triple (4363,4449,4545),94)
			Result.put (new_triple (4363,4449,4546),95)
			Result.put (new_pair (4363,4450),96)
			Result.put (new_triple (4363,4450,4520),97)
			Result.put (new_triple (4363,4450,4521),98)
			Result.put (new_triple (4363,4450,4522),99)
			Result.put (new_triple (4363,4450,4523),100)
			Result.put (new_triple (4363,4450,4524),101)
			Result.put (new_triple (4363,4450,4525),102)
			Result.put (new_triple (4363,4450,4526),103)
			Result.put (new_triple (4363,4450,4527),104)
			Result.put (new_triple (4363,4450,4528),105)
			Result.put (new_triple (4363,4450,4529),106)
			Result.put (new_triple (4363,4450,4530),107)
			Result.put (new_triple (4363,4450,4531),108)
			Result.put (new_triple (4363,4450,4532),109)
			Result.put (new_triple (4363,4450,4533),110)
			Result.put (new_triple (4363,4450,4534),111)
			Result.put (new_triple (4363,4450,4535),112)
			Result.put (new_triple (4363,4450,4536),113)
			Result.put (new_triple (4363,4450,4537),114)
			Result.put (new_triple (4363,4450,4538),115)
			Result.put (new_triple (4363,4450,4539),116)
			Result.put (new_triple (4363,4450,4540),117)
			Result.put (new_triple (4363,4450,4541),118)
			Result.put (new_triple (4363,4450,4542),119)
			Result.put (new_triple (4363,4450,4543),120)
			Result.put (new_triple (4363,4450,4544),121)
			Result.put (new_triple (4363,4450,4545),122)
			Result.put (new_triple (4363,4450,4546),123)
			Result.put (new_pair (4363,4451),124)
			Result.put (new_triple (4363,4451,4520),125)
			Result.put (new_triple (4363,4451,4521),126)
			Result.put (new_triple (4363,4451,4522),127)
			Result.put (new_triple (4363,4451,4523),128)
			Result.put (new_triple (4363,4451,4524),129)
			Result.put (new_triple (4363,4451,4525),130)
			Result.put (new_triple (4363,4451,4526),131)
			Result.put (new_triple (4363,4451,4527),132)
			Result.put (new_triple (4363,4451,4528),133)
			Result.put (new_triple (4363,4451,4529),134)
			Result.put (new_triple (4363,4451,4530),135)
			Result.put (new_triple (4363,4451,4531),136)
			Result.put (new_triple (4363,4451,4532),137)
			Result.put (new_triple (4363,4451,4533),138)
			Result.put (new_triple (4363,4451,4534),139)
			Result.put (new_triple (4363,4451,4535),140)
			Result.put (new_triple (4363,4451,4536),141)
			Result.put (new_triple (4363,4451,4537),142)
			Result.put (new_triple (4363,4451,4538),143)
			Result.put (new_triple (4363,4451,4539),144)
			Result.put (new_triple (4363,4451,4540),145)
			Result.put (new_triple (4363,4451,4541),146)
			Result.put (new_triple (4363,4451,4542),147)
			Result.put (new_triple (4363,4451,4543),148)
			Result.put (new_triple (4363,4451,4544),149)
			Result.put (new_triple (4363,4451,4545),150)
			Result.put (new_triple (4363,4451,4546),151)
			Result.put (new_pair (4363,4452),152)
			Result.put (new_triple (4363,4452,4520),153)
			Result.put (new_triple (4363,4452,4521),154)
			Result.put (new_triple (4363,4452,4522),155)
			Result.put (new_triple (4363,4452,4523),156)
			Result.put (new_triple (4363,4452,4524),157)
			Result.put (new_triple (4363,4452,4525),158)
			Result.put (new_triple (4363,4452,4526),159)
			Result.put (new_triple (4363,4452,4527),160)
			Result.put (new_triple (4363,4452,4528),161)
			Result.put (new_triple (4363,4452,4529),162)
			Result.put (new_triple (4363,4452,4530),163)
			Result.put (new_triple (4363,4452,4531),164)
			Result.put (new_triple (4363,4452,4532),165)
			Result.put (new_triple (4363,4452,4533),166)
			Result.put (new_triple (4363,4452,4534),167)
			Result.put (new_triple (4363,4452,4535),168)
			Result.put (new_triple (4363,4452,4536),169)
			Result.put (new_triple (4363,4452,4537),170)
			Result.put (new_triple (4363,4452,4538),171)
			Result.put (new_triple (4363,4452,4539),172)
			Result.put (new_triple (4363,4452,4540),173)
			Result.put (new_triple (4363,4452,4541),174)
			Result.put (new_triple (4363,4452,4542),175)
			Result.put (new_triple (4363,4452,4543),176)
			Result.put (new_triple (4363,4452,4544),177)
			Result.put (new_triple (4363,4452,4545),178)
			Result.put (new_triple (4363,4452,4546),179)
			Result.put (new_pair (4363,4453),180)
			Result.put (new_triple (4363,4453,4520),181)
			Result.put (new_triple (4363,4453,4521),182)
			Result.put (new_triple (4363,4453,4522),183)
			Result.put (new_triple (4363,4453,4523),184)
			Result.put (new_triple (4363,4453,4524),185)
			Result.put (new_triple (4363,4453,4525),186)
			Result.put (new_triple (4363,4453,4526),187)
			Result.put (new_triple (4363,4453,4527),188)
			Result.put (new_triple (4363,4453,4528),189)
			Result.put (new_triple (4363,4453,4529),190)
			Result.put (new_triple (4363,4453,4530),191)
			Result.put (new_triple (4363,4453,4531),192)
			Result.put (new_triple (4363,4453,4532),193)
			Result.put (new_triple (4363,4453,4533),194)
			Result.put (new_triple (4363,4453,4534),195)
			Result.put (new_triple (4363,4453,4535),196)
			Result.put (new_triple (4363,4453,4536),197)
			Result.put (new_triple (4363,4453,4537),198)
			Result.put (new_triple (4363,4453,4538),199)
			Result.put (new_triple (4363,4453,4539),200)
			Result.put (new_triple (4363,4453,4540),201)
			Result.put (new_triple (4363,4453,4541),202)
			Result.put (new_triple (4363,4453,4542),203)
			Result.put (new_triple (4363,4453,4543),204)
			Result.put (new_triple (4363,4453,4544),205)
			Result.put (new_triple (4363,4453,4545),206)
			Result.put (new_triple (4363,4453,4546),207)
			Result.put (new_pair (4363,4454),208)
			Result.put (new_triple (4363,4454,4520),209)
			Result.put (new_triple (4363,4454,4521),210)
			Result.put (new_triple (4363,4454,4522),211)
			Result.put (new_triple (4363,4454,4523),212)
			Result.put (new_triple (4363,4454,4524),213)
			Result.put (new_triple (4363,4454,4525),214)
			Result.put (new_triple (4363,4454,4526),215)
			Result.put (new_triple (4363,4454,4527),216)
			Result.put (new_triple (4363,4454,4528),217)
			Result.put (new_triple (4363,4454,4529),218)
			Result.put (new_triple (4363,4454,4530),219)
			Result.put (new_triple (4363,4454,4531),220)
			Result.put (new_triple (4363,4454,4532),221)
			Result.put (new_triple (4363,4454,4533),222)
			Result.put (new_triple (4363,4454,4534),223)
			Result.put (new_triple (4363,4454,4535),224)
			Result.put (new_triple (4363,4454,4536),225)
			Result.put (new_triple (4363,4454,4537),226)
			Result.put (new_triple (4363,4454,4538),227)
			Result.put (new_triple (4363,4454,4539),228)
			Result.put (new_triple (4363,4454,4540),229)
			Result.put (new_triple (4363,4454,4541),230)
			Result.put (new_triple (4363,4454,4542),231)
			Result.put (new_triple (4363,4454,4543),232)
			Result.put (new_triple (4363,4454,4544),233)
			Result.put (new_triple (4363,4454,4545),234)
			Result.put (new_triple (4363,4454,4546),235)
			Result.put (new_pair (4363,4455),236)
			Result.put (new_triple (4363,4455,4520),237)
			Result.put (new_triple (4363,4455,4521),238)
			Result.put (new_triple (4363,4455,4522),239)
			Result.put (new_triple (4363,4455,4523),240)
			Result.put (new_triple (4363,4455,4524),241)
			Result.put (new_triple (4363,4455,4525),242)
			Result.put (new_triple (4363,4455,4526),243)
			Result.put (new_triple (4363,4455,4527),244)
			Result.put (new_triple (4363,4455,4528),245)
			Result.put (new_triple (4363,4455,4529),246)
			Result.put (new_triple (4363,4455,4530),247)
			Result.put (new_triple (4363,4455,4531),248)
			Result.put (new_triple (4363,4455,4532),249)
			Result.put (new_triple (4363,4455,4533),250)
			Result.put (new_triple (4363,4455,4534),251)
			Result.put (new_triple (4363,4455,4535),252)
			Result.put (new_triple (4363,4455,4536),253)
			Result.put (new_triple (4363,4455,4537),254)
			Result.put (new_triple (4363,4455,4538),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_198: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4363,4455,4539),0)
			Result.put (new_triple (4363,4455,4540),1)
			Result.put (new_triple (4363,4455,4541),2)
			Result.put (new_triple (4363,4455,4542),3)
			Result.put (new_triple (4363,4455,4543),4)
			Result.put (new_triple (4363,4455,4544),5)
			Result.put (new_triple (4363,4455,4545),6)
			Result.put (new_triple (4363,4455,4546),7)
			Result.put (new_pair (4363,4456),8)
			Result.put (new_triple (4363,4456,4520),9)
			Result.put (new_triple (4363,4456,4521),10)
			Result.put (new_triple (4363,4456,4522),11)
			Result.put (new_triple (4363,4456,4523),12)
			Result.put (new_triple (4363,4456,4524),13)
			Result.put (new_triple (4363,4456,4525),14)
			Result.put (new_triple (4363,4456,4526),15)
			Result.put (new_triple (4363,4456,4527),16)
			Result.put (new_triple (4363,4456,4528),17)
			Result.put (new_triple (4363,4456,4529),18)
			Result.put (new_triple (4363,4456,4530),19)
			Result.put (new_triple (4363,4456,4531),20)
			Result.put (new_triple (4363,4456,4532),21)
			Result.put (new_triple (4363,4456,4533),22)
			Result.put (new_triple (4363,4456,4534),23)
			Result.put (new_triple (4363,4456,4535),24)
			Result.put (new_triple (4363,4456,4536),25)
			Result.put (new_triple (4363,4456,4537),26)
			Result.put (new_triple (4363,4456,4538),27)
			Result.put (new_triple (4363,4456,4539),28)
			Result.put (new_triple (4363,4456,4540),29)
			Result.put (new_triple (4363,4456,4541),30)
			Result.put (new_triple (4363,4456,4542),31)
			Result.put (new_triple (4363,4456,4543),32)
			Result.put (new_triple (4363,4456,4544),33)
			Result.put (new_triple (4363,4456,4545),34)
			Result.put (new_triple (4363,4456,4546),35)
			Result.put (new_pair (4363,4457),36)
			Result.put (new_triple (4363,4457,4520),37)
			Result.put (new_triple (4363,4457,4521),38)
			Result.put (new_triple (4363,4457,4522),39)
			Result.put (new_triple (4363,4457,4523),40)
			Result.put (new_triple (4363,4457,4524),41)
			Result.put (new_triple (4363,4457,4525),42)
			Result.put (new_triple (4363,4457,4526),43)
			Result.put (new_triple (4363,4457,4527),44)
			Result.put (new_triple (4363,4457,4528),45)
			Result.put (new_triple (4363,4457,4529),46)
			Result.put (new_triple (4363,4457,4530),47)
			Result.put (new_triple (4363,4457,4531),48)
			Result.put (new_triple (4363,4457,4532),49)
			Result.put (new_triple (4363,4457,4533),50)
			Result.put (new_triple (4363,4457,4534),51)
			Result.put (new_triple (4363,4457,4535),52)
			Result.put (new_triple (4363,4457,4536),53)
			Result.put (new_triple (4363,4457,4537),54)
			Result.put (new_triple (4363,4457,4538),55)
			Result.put (new_triple (4363,4457,4539),56)
			Result.put (new_triple (4363,4457,4540),57)
			Result.put (new_triple (4363,4457,4541),58)
			Result.put (new_triple (4363,4457,4542),59)
			Result.put (new_triple (4363,4457,4543),60)
			Result.put (new_triple (4363,4457,4544),61)
			Result.put (new_triple (4363,4457,4545),62)
			Result.put (new_triple (4363,4457,4546),63)
			Result.put (new_pair (4363,4458),64)
			Result.put (new_triple (4363,4458,4520),65)
			Result.put (new_triple (4363,4458,4521),66)
			Result.put (new_triple (4363,4458,4522),67)
			Result.put (new_triple (4363,4458,4523),68)
			Result.put (new_triple (4363,4458,4524),69)
			Result.put (new_triple (4363,4458,4525),70)
			Result.put (new_triple (4363,4458,4526),71)
			Result.put (new_triple (4363,4458,4527),72)
			Result.put (new_triple (4363,4458,4528),73)
			Result.put (new_triple (4363,4458,4529),74)
			Result.put (new_triple (4363,4458,4530),75)
			Result.put (new_triple (4363,4458,4531),76)
			Result.put (new_triple (4363,4458,4532),77)
			Result.put (new_triple (4363,4458,4533),78)
			Result.put (new_triple (4363,4458,4534),79)
			Result.put (new_triple (4363,4458,4535),80)
			Result.put (new_triple (4363,4458,4536),81)
			Result.put (new_triple (4363,4458,4537),82)
			Result.put (new_triple (4363,4458,4538),83)
			Result.put (new_triple (4363,4458,4539),84)
			Result.put (new_triple (4363,4458,4540),85)
			Result.put (new_triple (4363,4458,4541),86)
			Result.put (new_triple (4363,4458,4542),87)
			Result.put (new_triple (4363,4458,4543),88)
			Result.put (new_triple (4363,4458,4544),89)
			Result.put (new_triple (4363,4458,4545),90)
			Result.put (new_triple (4363,4458,4546),91)
			Result.put (new_pair (4363,4459),92)
			Result.put (new_triple (4363,4459,4520),93)
			Result.put (new_triple (4363,4459,4521),94)
			Result.put (new_triple (4363,4459,4522),95)
			Result.put (new_triple (4363,4459,4523),96)
			Result.put (new_triple (4363,4459,4524),97)
			Result.put (new_triple (4363,4459,4525),98)
			Result.put (new_triple (4363,4459,4526),99)
			Result.put (new_triple (4363,4459,4527),100)
			Result.put (new_triple (4363,4459,4528),101)
			Result.put (new_triple (4363,4459,4529),102)
			Result.put (new_triple (4363,4459,4530),103)
			Result.put (new_triple (4363,4459,4531),104)
			Result.put (new_triple (4363,4459,4532),105)
			Result.put (new_triple (4363,4459,4533),106)
			Result.put (new_triple (4363,4459,4534),107)
			Result.put (new_triple (4363,4459,4535),108)
			Result.put (new_triple (4363,4459,4536),109)
			Result.put (new_triple (4363,4459,4537),110)
			Result.put (new_triple (4363,4459,4538),111)
			Result.put (new_triple (4363,4459,4539),112)
			Result.put (new_triple (4363,4459,4540),113)
			Result.put (new_triple (4363,4459,4541),114)
			Result.put (new_triple (4363,4459,4542),115)
			Result.put (new_triple (4363,4459,4543),116)
			Result.put (new_triple (4363,4459,4544),117)
			Result.put (new_triple (4363,4459,4545),118)
			Result.put (new_triple (4363,4459,4546),119)
			Result.put (new_pair (4363,4460),120)
			Result.put (new_triple (4363,4460,4520),121)
			Result.put (new_triple (4363,4460,4521),122)
			Result.put (new_triple (4363,4460,4522),123)
			Result.put (new_triple (4363,4460,4523),124)
			Result.put (new_triple (4363,4460,4524),125)
			Result.put (new_triple (4363,4460,4525),126)
			Result.put (new_triple (4363,4460,4526),127)
			Result.put (new_triple (4363,4460,4527),128)
			Result.put (new_triple (4363,4460,4528),129)
			Result.put (new_triple (4363,4460,4529),130)
			Result.put (new_triple (4363,4460,4530),131)
			Result.put (new_triple (4363,4460,4531),132)
			Result.put (new_triple (4363,4460,4532),133)
			Result.put (new_triple (4363,4460,4533),134)
			Result.put (new_triple (4363,4460,4534),135)
			Result.put (new_triple (4363,4460,4535),136)
			Result.put (new_triple (4363,4460,4536),137)
			Result.put (new_triple (4363,4460,4537),138)
			Result.put (new_triple (4363,4460,4538),139)
			Result.put (new_triple (4363,4460,4539),140)
			Result.put (new_triple (4363,4460,4540),141)
			Result.put (new_triple (4363,4460,4541),142)
			Result.put (new_triple (4363,4460,4542),143)
			Result.put (new_triple (4363,4460,4543),144)
			Result.put (new_triple (4363,4460,4544),145)
			Result.put (new_triple (4363,4460,4545),146)
			Result.put (new_triple (4363,4460,4546),147)
			Result.put (new_pair (4363,4461),148)
			Result.put (new_triple (4363,4461,4520),149)
			Result.put (new_triple (4363,4461,4521),150)
			Result.put (new_triple (4363,4461,4522),151)
			Result.put (new_triple (4363,4461,4523),152)
			Result.put (new_triple (4363,4461,4524),153)
			Result.put (new_triple (4363,4461,4525),154)
			Result.put (new_triple (4363,4461,4526),155)
			Result.put (new_triple (4363,4461,4527),156)
			Result.put (new_triple (4363,4461,4528),157)
			Result.put (new_triple (4363,4461,4529),158)
			Result.put (new_triple (4363,4461,4530),159)
			Result.put (new_triple (4363,4461,4531),160)
			Result.put (new_triple (4363,4461,4532),161)
			Result.put (new_triple (4363,4461,4533),162)
			Result.put (new_triple (4363,4461,4534),163)
			Result.put (new_triple (4363,4461,4535),164)
			Result.put (new_triple (4363,4461,4536),165)
			Result.put (new_triple (4363,4461,4537),166)
			Result.put (new_triple (4363,4461,4538),167)
			Result.put (new_triple (4363,4461,4539),168)
			Result.put (new_triple (4363,4461,4540),169)
			Result.put (new_triple (4363,4461,4541),170)
			Result.put (new_triple (4363,4461,4542),171)
			Result.put (new_triple (4363,4461,4543),172)
			Result.put (new_triple (4363,4461,4544),173)
			Result.put (new_triple (4363,4461,4545),174)
			Result.put (new_triple (4363,4461,4546),175)
			Result.put (new_pair (4363,4462),176)
			Result.put (new_triple (4363,4462,4520),177)
			Result.put (new_triple (4363,4462,4521),178)
			Result.put (new_triple (4363,4462,4522),179)
			Result.put (new_triple (4363,4462,4523),180)
			Result.put (new_triple (4363,4462,4524),181)
			Result.put (new_triple (4363,4462,4525),182)
			Result.put (new_triple (4363,4462,4526),183)
			Result.put (new_triple (4363,4462,4527),184)
			Result.put (new_triple (4363,4462,4528),185)
			Result.put (new_triple (4363,4462,4529),186)
			Result.put (new_triple (4363,4462,4530),187)
			Result.put (new_triple (4363,4462,4531),188)
			Result.put (new_triple (4363,4462,4532),189)
			Result.put (new_triple (4363,4462,4533),190)
			Result.put (new_triple (4363,4462,4534),191)
			Result.put (new_triple (4363,4462,4535),192)
			Result.put (new_triple (4363,4462,4536),193)
			Result.put (new_triple (4363,4462,4537),194)
			Result.put (new_triple (4363,4462,4538),195)
			Result.put (new_triple (4363,4462,4539),196)
			Result.put (new_triple (4363,4462,4540),197)
			Result.put (new_triple (4363,4462,4541),198)
			Result.put (new_triple (4363,4462,4542),199)
			Result.put (new_triple (4363,4462,4543),200)
			Result.put (new_triple (4363,4462,4544),201)
			Result.put (new_triple (4363,4462,4545),202)
			Result.put (new_triple (4363,4462,4546),203)
			Result.put (new_pair (4363,4463),204)
			Result.put (new_triple (4363,4463,4520),205)
			Result.put (new_triple (4363,4463,4521),206)
			Result.put (new_triple (4363,4463,4522),207)
			Result.put (new_triple (4363,4463,4523),208)
			Result.put (new_triple (4363,4463,4524),209)
			Result.put (new_triple (4363,4463,4525),210)
			Result.put (new_triple (4363,4463,4526),211)
			Result.put (new_triple (4363,4463,4527),212)
			Result.put (new_triple (4363,4463,4528),213)
			Result.put (new_triple (4363,4463,4529),214)
			Result.put (new_triple (4363,4463,4530),215)
			Result.put (new_triple (4363,4463,4531),216)
			Result.put (new_triple (4363,4463,4532),217)
			Result.put (new_triple (4363,4463,4533),218)
			Result.put (new_triple (4363,4463,4534),219)
			Result.put (new_triple (4363,4463,4535),220)
			Result.put (new_triple (4363,4463,4536),221)
			Result.put (new_triple (4363,4463,4537),222)
			Result.put (new_triple (4363,4463,4538),223)
			Result.put (new_triple (4363,4463,4539),224)
			Result.put (new_triple (4363,4463,4540),225)
			Result.put (new_triple (4363,4463,4541),226)
			Result.put (new_triple (4363,4463,4542),227)
			Result.put (new_triple (4363,4463,4543),228)
			Result.put (new_triple (4363,4463,4544),229)
			Result.put (new_triple (4363,4463,4545),230)
			Result.put (new_triple (4363,4463,4546),231)
			Result.put (new_pair (4363,4464),232)
			Result.put (new_triple (4363,4464,4520),233)
			Result.put (new_triple (4363,4464,4521),234)
			Result.put (new_triple (4363,4464,4522),235)
			Result.put (new_triple (4363,4464,4523),236)
			Result.put (new_triple (4363,4464,4524),237)
			Result.put (new_triple (4363,4464,4525),238)
			Result.put (new_triple (4363,4464,4526),239)
			Result.put (new_triple (4363,4464,4527),240)
			Result.put (new_triple (4363,4464,4528),241)
			Result.put (new_triple (4363,4464,4529),242)
			Result.put (new_triple (4363,4464,4530),243)
			Result.put (new_triple (4363,4464,4531),244)
			Result.put (new_triple (4363,4464,4532),245)
			Result.put (new_triple (4363,4464,4533),246)
			Result.put (new_triple (4363,4464,4534),247)
			Result.put (new_triple (4363,4464,4535),248)
			Result.put (new_triple (4363,4464,4536),249)
			Result.put (new_triple (4363,4464,4537),250)
			Result.put (new_triple (4363,4464,4538),251)
			Result.put (new_triple (4363,4464,4539),252)
			Result.put (new_triple (4363,4464,4540),253)
			Result.put (new_triple (4363,4464,4541),254)
			Result.put (new_triple (4363,4464,4542),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_199: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4363,4464,4543),0)
			Result.put (new_triple (4363,4464,4544),1)
			Result.put (new_triple (4363,4464,4545),2)
			Result.put (new_triple (4363,4464,4546),3)
			Result.put (new_pair (4363,4465),4)
			Result.put (new_triple (4363,4465,4520),5)
			Result.put (new_triple (4363,4465,4521),6)
			Result.put (new_triple (4363,4465,4522),7)
			Result.put (new_triple (4363,4465,4523),8)
			Result.put (new_triple (4363,4465,4524),9)
			Result.put (new_triple (4363,4465,4525),10)
			Result.put (new_triple (4363,4465,4526),11)
			Result.put (new_triple (4363,4465,4527),12)
			Result.put (new_triple (4363,4465,4528),13)
			Result.put (new_triple (4363,4465,4529),14)
			Result.put (new_triple (4363,4465,4530),15)
			Result.put (new_triple (4363,4465,4531),16)
			Result.put (new_triple (4363,4465,4532),17)
			Result.put (new_triple (4363,4465,4533),18)
			Result.put (new_triple (4363,4465,4534),19)
			Result.put (new_triple (4363,4465,4535),20)
			Result.put (new_triple (4363,4465,4536),21)
			Result.put (new_triple (4363,4465,4537),22)
			Result.put (new_triple (4363,4465,4538),23)
			Result.put (new_triple (4363,4465,4539),24)
			Result.put (new_triple (4363,4465,4540),25)
			Result.put (new_triple (4363,4465,4541),26)
			Result.put (new_triple (4363,4465,4542),27)
			Result.put (new_triple (4363,4465,4543),28)
			Result.put (new_triple (4363,4465,4544),29)
			Result.put (new_triple (4363,4465,4545),30)
			Result.put (new_triple (4363,4465,4546),31)
			Result.put (new_pair (4363,4466),32)
			Result.put (new_triple (4363,4466,4520),33)
			Result.put (new_triple (4363,4466,4521),34)
			Result.put (new_triple (4363,4466,4522),35)
			Result.put (new_triple (4363,4466,4523),36)
			Result.put (new_triple (4363,4466,4524),37)
			Result.put (new_triple (4363,4466,4525),38)
			Result.put (new_triple (4363,4466,4526),39)
			Result.put (new_triple (4363,4466,4527),40)
			Result.put (new_triple (4363,4466,4528),41)
			Result.put (new_triple (4363,4466,4529),42)
			Result.put (new_triple (4363,4466,4530),43)
			Result.put (new_triple (4363,4466,4531),44)
			Result.put (new_triple (4363,4466,4532),45)
			Result.put (new_triple (4363,4466,4533),46)
			Result.put (new_triple (4363,4466,4534),47)
			Result.put (new_triple (4363,4466,4535),48)
			Result.put (new_triple (4363,4466,4536),49)
			Result.put (new_triple (4363,4466,4537),50)
			Result.put (new_triple (4363,4466,4538),51)
			Result.put (new_triple (4363,4466,4539),52)
			Result.put (new_triple (4363,4466,4540),53)
			Result.put (new_triple (4363,4466,4541),54)
			Result.put (new_triple (4363,4466,4542),55)
			Result.put (new_triple (4363,4466,4543),56)
			Result.put (new_triple (4363,4466,4544),57)
			Result.put (new_triple (4363,4466,4545),58)
			Result.put (new_triple (4363,4466,4546),59)
			Result.put (new_pair (4363,4467),60)
			Result.put (new_triple (4363,4467,4520),61)
			Result.put (new_triple (4363,4467,4521),62)
			Result.put (new_triple (4363,4467,4522),63)
			Result.put (new_triple (4363,4467,4523),64)
			Result.put (new_triple (4363,4467,4524),65)
			Result.put (new_triple (4363,4467,4525),66)
			Result.put (new_triple (4363,4467,4526),67)
			Result.put (new_triple (4363,4467,4527),68)
			Result.put (new_triple (4363,4467,4528),69)
			Result.put (new_triple (4363,4467,4529),70)
			Result.put (new_triple (4363,4467,4530),71)
			Result.put (new_triple (4363,4467,4531),72)
			Result.put (new_triple (4363,4467,4532),73)
			Result.put (new_triple (4363,4467,4533),74)
			Result.put (new_triple (4363,4467,4534),75)
			Result.put (new_triple (4363,4467,4535),76)
			Result.put (new_triple (4363,4467,4536),77)
			Result.put (new_triple (4363,4467,4537),78)
			Result.put (new_triple (4363,4467,4538),79)
			Result.put (new_triple (4363,4467,4539),80)
			Result.put (new_triple (4363,4467,4540),81)
			Result.put (new_triple (4363,4467,4541),82)
			Result.put (new_triple (4363,4467,4542),83)
			Result.put (new_triple (4363,4467,4543),84)
			Result.put (new_triple (4363,4467,4544),85)
			Result.put (new_triple (4363,4467,4545),86)
			Result.put (new_triple (4363,4467,4546),87)
			Result.put (new_pair (4363,4468),88)
			Result.put (new_triple (4363,4468,4520),89)
			Result.put (new_triple (4363,4468,4521),90)
			Result.put (new_triple (4363,4468,4522),91)
			Result.put (new_triple (4363,4468,4523),92)
			Result.put (new_triple (4363,4468,4524),93)
			Result.put (new_triple (4363,4468,4525),94)
			Result.put (new_triple (4363,4468,4526),95)
			Result.put (new_triple (4363,4468,4527),96)
			Result.put (new_triple (4363,4468,4528),97)
			Result.put (new_triple (4363,4468,4529),98)
			Result.put (new_triple (4363,4468,4530),99)
			Result.put (new_triple (4363,4468,4531),100)
			Result.put (new_triple (4363,4468,4532),101)
			Result.put (new_triple (4363,4468,4533),102)
			Result.put (new_triple (4363,4468,4534),103)
			Result.put (new_triple (4363,4468,4535),104)
			Result.put (new_triple (4363,4468,4536),105)
			Result.put (new_triple (4363,4468,4537),106)
			Result.put (new_triple (4363,4468,4538),107)
			Result.put (new_triple (4363,4468,4539),108)
			Result.put (new_triple (4363,4468,4540),109)
			Result.put (new_triple (4363,4468,4541),110)
			Result.put (new_triple (4363,4468,4542),111)
			Result.put (new_triple (4363,4468,4543),112)
			Result.put (new_triple (4363,4468,4544),113)
			Result.put (new_triple (4363,4468,4545),114)
			Result.put (new_triple (4363,4468,4546),115)
			Result.put (new_pair (4363,4469),116)
			Result.put (new_triple (4363,4469,4520),117)
			Result.put (new_triple (4363,4469,4521),118)
			Result.put (new_triple (4363,4469,4522),119)
			Result.put (new_triple (4363,4469,4523),120)
			Result.put (new_triple (4363,4469,4524),121)
			Result.put (new_triple (4363,4469,4525),122)
			Result.put (new_triple (4363,4469,4526),123)
			Result.put (new_triple (4363,4469,4527),124)
			Result.put (new_triple (4363,4469,4528),125)
			Result.put (new_triple (4363,4469,4529),126)
			Result.put (new_triple (4363,4469,4530),127)
			Result.put (new_triple (4363,4469,4531),128)
			Result.put (new_triple (4363,4469,4532),129)
			Result.put (new_triple (4363,4469,4533),130)
			Result.put (new_triple (4363,4469,4534),131)
			Result.put (new_triple (4363,4469,4535),132)
			Result.put (new_triple (4363,4469,4536),133)
			Result.put (new_triple (4363,4469,4537),134)
			Result.put (new_triple (4363,4469,4538),135)
			Result.put (new_triple (4363,4469,4539),136)
			Result.put (new_triple (4363,4469,4540),137)
			Result.put (new_triple (4363,4469,4541),138)
			Result.put (new_triple (4363,4469,4542),139)
			Result.put (new_triple (4363,4469,4543),140)
			Result.put (new_triple (4363,4469,4544),141)
			Result.put (new_triple (4363,4469,4545),142)
			Result.put (new_triple (4363,4469,4546),143)
			Result.put (new_pair (4364,4449),144)
			Result.put (new_triple (4364,4449,4520),145)
			Result.put (new_triple (4364,4449,4521),146)
			Result.put (new_triple (4364,4449,4522),147)
			Result.put (new_triple (4364,4449,4523),148)
			Result.put (new_triple (4364,4449,4524),149)
			Result.put (new_triple (4364,4449,4525),150)
			Result.put (new_triple (4364,4449,4526),151)
			Result.put (new_triple (4364,4449,4527),152)
			Result.put (new_triple (4364,4449,4528),153)
			Result.put (new_triple (4364,4449,4529),154)
			Result.put (new_triple (4364,4449,4530),155)
			Result.put (new_triple (4364,4449,4531),156)
			Result.put (new_triple (4364,4449,4532),157)
			Result.put (new_triple (4364,4449,4533),158)
			Result.put (new_triple (4364,4449,4534),159)
			Result.put (new_triple (4364,4449,4535),160)
			Result.put (new_triple (4364,4449,4536),161)
			Result.put (new_triple (4364,4449,4537),162)
			Result.put (new_triple (4364,4449,4538),163)
			Result.put (new_triple (4364,4449,4539),164)
			Result.put (new_triple (4364,4449,4540),165)
			Result.put (new_triple (4364,4449,4541),166)
			Result.put (new_triple (4364,4449,4542),167)
			Result.put (new_triple (4364,4449,4543),168)
			Result.put (new_triple (4364,4449,4544),169)
			Result.put (new_triple (4364,4449,4545),170)
			Result.put (new_triple (4364,4449,4546),171)
			Result.put (new_pair (4364,4450),172)
			Result.put (new_triple (4364,4450,4520),173)
			Result.put (new_triple (4364,4450,4521),174)
			Result.put (new_triple (4364,4450,4522),175)
			Result.put (new_triple (4364,4450,4523),176)
			Result.put (new_triple (4364,4450,4524),177)
			Result.put (new_triple (4364,4450,4525),178)
			Result.put (new_triple (4364,4450,4526),179)
			Result.put (new_triple (4364,4450,4527),180)
			Result.put (new_triple (4364,4450,4528),181)
			Result.put (new_triple (4364,4450,4529),182)
			Result.put (new_triple (4364,4450,4530),183)
			Result.put (new_triple (4364,4450,4531),184)
			Result.put (new_triple (4364,4450,4532),185)
			Result.put (new_triple (4364,4450,4533),186)
			Result.put (new_triple (4364,4450,4534),187)
			Result.put (new_triple (4364,4450,4535),188)
			Result.put (new_triple (4364,4450,4536),189)
			Result.put (new_triple (4364,4450,4537),190)
			Result.put (new_triple (4364,4450,4538),191)
			Result.put (new_triple (4364,4450,4539),192)
			Result.put (new_triple (4364,4450,4540),193)
			Result.put (new_triple (4364,4450,4541),194)
			Result.put (new_triple (4364,4450,4542),195)
			Result.put (new_triple (4364,4450,4543),196)
			Result.put (new_triple (4364,4450,4544),197)
			Result.put (new_triple (4364,4450,4545),198)
			Result.put (new_triple (4364,4450,4546),199)
			Result.put (new_pair (4364,4451),200)
			Result.put (new_triple (4364,4451,4520),201)
			Result.put (new_triple (4364,4451,4521),202)
			Result.put (new_triple (4364,4451,4522),203)
			Result.put (new_triple (4364,4451,4523),204)
			Result.put (new_triple (4364,4451,4524),205)
			Result.put (new_triple (4364,4451,4525),206)
			Result.put (new_triple (4364,4451,4526),207)
			Result.put (new_triple (4364,4451,4527),208)
			Result.put (new_triple (4364,4451,4528),209)
			Result.put (new_triple (4364,4451,4529),210)
			Result.put (new_triple (4364,4451,4530),211)
			Result.put (new_triple (4364,4451,4531),212)
			Result.put (new_triple (4364,4451,4532),213)
			Result.put (new_triple (4364,4451,4533),214)
			Result.put (new_triple (4364,4451,4534),215)
			Result.put (new_triple (4364,4451,4535),216)
			Result.put (new_triple (4364,4451,4536),217)
			Result.put (new_triple (4364,4451,4537),218)
			Result.put (new_triple (4364,4451,4538),219)
			Result.put (new_triple (4364,4451,4539),220)
			Result.put (new_triple (4364,4451,4540),221)
			Result.put (new_triple (4364,4451,4541),222)
			Result.put (new_triple (4364,4451,4542),223)
			Result.put (new_triple (4364,4451,4543),224)
			Result.put (new_triple (4364,4451,4544),225)
			Result.put (new_triple (4364,4451,4545),226)
			Result.put (new_triple (4364,4451,4546),227)
			Result.put (new_pair (4364,4452),228)
			Result.put (new_triple (4364,4452,4520),229)
			Result.put (new_triple (4364,4452,4521),230)
			Result.put (new_triple (4364,4452,4522),231)
			Result.put (new_triple (4364,4452,4523),232)
			Result.put (new_triple (4364,4452,4524),233)
			Result.put (new_triple (4364,4452,4525),234)
			Result.put (new_triple (4364,4452,4526),235)
			Result.put (new_triple (4364,4452,4527),236)
			Result.put (new_triple (4364,4452,4528),237)
			Result.put (new_triple (4364,4452,4529),238)
			Result.put (new_triple (4364,4452,4530),239)
			Result.put (new_triple (4364,4452,4531),240)
			Result.put (new_triple (4364,4452,4532),241)
			Result.put (new_triple (4364,4452,4533),242)
			Result.put (new_triple (4364,4452,4534),243)
			Result.put (new_triple (4364,4452,4535),244)
			Result.put (new_triple (4364,4452,4536),245)
			Result.put (new_triple (4364,4452,4537),246)
			Result.put (new_triple (4364,4452,4538),247)
			Result.put (new_triple (4364,4452,4539),248)
			Result.put (new_triple (4364,4452,4540),249)
			Result.put (new_triple (4364,4452,4541),250)
			Result.put (new_triple (4364,4452,4542),251)
			Result.put (new_triple (4364,4452,4543),252)
			Result.put (new_triple (4364,4452,4544),253)
			Result.put (new_triple (4364,4452,4545),254)
			Result.put (new_triple (4364,4452,4546),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_200: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (4364,4453),0)
			Result.put (new_triple (4364,4453,4520),1)
			Result.put (new_triple (4364,4453,4521),2)
			Result.put (new_triple (4364,4453,4522),3)
			Result.put (new_triple (4364,4453,4523),4)
			Result.put (new_triple (4364,4453,4524),5)
			Result.put (new_triple (4364,4453,4525),6)
			Result.put (new_triple (4364,4453,4526),7)
			Result.put (new_triple (4364,4453,4527),8)
			Result.put (new_triple (4364,4453,4528),9)
			Result.put (new_triple (4364,4453,4529),10)
			Result.put (new_triple (4364,4453,4530),11)
			Result.put (new_triple (4364,4453,4531),12)
			Result.put (new_triple (4364,4453,4532),13)
			Result.put (new_triple (4364,4453,4533),14)
			Result.put (new_triple (4364,4453,4534),15)
			Result.put (new_triple (4364,4453,4535),16)
			Result.put (new_triple (4364,4453,4536),17)
			Result.put (new_triple (4364,4453,4537),18)
			Result.put (new_triple (4364,4453,4538),19)
			Result.put (new_triple (4364,4453,4539),20)
			Result.put (new_triple (4364,4453,4540),21)
			Result.put (new_triple (4364,4453,4541),22)
			Result.put (new_triple (4364,4453,4542),23)
			Result.put (new_triple (4364,4453,4543),24)
			Result.put (new_triple (4364,4453,4544),25)
			Result.put (new_triple (4364,4453,4545),26)
			Result.put (new_triple (4364,4453,4546),27)
			Result.put (new_pair (4364,4454),28)
			Result.put (new_triple (4364,4454,4520),29)
			Result.put (new_triple (4364,4454,4521),30)
			Result.put (new_triple (4364,4454,4522),31)
			Result.put (new_triple (4364,4454,4523),32)
			Result.put (new_triple (4364,4454,4524),33)
			Result.put (new_triple (4364,4454,4525),34)
			Result.put (new_triple (4364,4454,4526),35)
			Result.put (new_triple (4364,4454,4527),36)
			Result.put (new_triple (4364,4454,4528),37)
			Result.put (new_triple (4364,4454,4529),38)
			Result.put (new_triple (4364,4454,4530),39)
			Result.put (new_triple (4364,4454,4531),40)
			Result.put (new_triple (4364,4454,4532),41)
			Result.put (new_triple (4364,4454,4533),42)
			Result.put (new_triple (4364,4454,4534),43)
			Result.put (new_triple (4364,4454,4535),44)
			Result.put (new_triple (4364,4454,4536),45)
			Result.put (new_triple (4364,4454,4537),46)
			Result.put (new_triple (4364,4454,4538),47)
			Result.put (new_triple (4364,4454,4539),48)
			Result.put (new_triple (4364,4454,4540),49)
			Result.put (new_triple (4364,4454,4541),50)
			Result.put (new_triple (4364,4454,4542),51)
			Result.put (new_triple (4364,4454,4543),52)
			Result.put (new_triple (4364,4454,4544),53)
			Result.put (new_triple (4364,4454,4545),54)
			Result.put (new_triple (4364,4454,4546),55)
			Result.put (new_pair (4364,4455),56)
			Result.put (new_triple (4364,4455,4520),57)
			Result.put (new_triple (4364,4455,4521),58)
			Result.put (new_triple (4364,4455,4522),59)
			Result.put (new_triple (4364,4455,4523),60)
			Result.put (new_triple (4364,4455,4524),61)
			Result.put (new_triple (4364,4455,4525),62)
			Result.put (new_triple (4364,4455,4526),63)
			Result.put (new_triple (4364,4455,4527),64)
			Result.put (new_triple (4364,4455,4528),65)
			Result.put (new_triple (4364,4455,4529),66)
			Result.put (new_triple (4364,4455,4530),67)
			Result.put (new_triple (4364,4455,4531),68)
			Result.put (new_triple (4364,4455,4532),69)
			Result.put (new_triple (4364,4455,4533),70)
			Result.put (new_triple (4364,4455,4534),71)
			Result.put (new_triple (4364,4455,4535),72)
			Result.put (new_triple (4364,4455,4536),73)
			Result.put (new_triple (4364,4455,4537),74)
			Result.put (new_triple (4364,4455,4538),75)
			Result.put (new_triple (4364,4455,4539),76)
			Result.put (new_triple (4364,4455,4540),77)
			Result.put (new_triple (4364,4455,4541),78)
			Result.put (new_triple (4364,4455,4542),79)
			Result.put (new_triple (4364,4455,4543),80)
			Result.put (new_triple (4364,4455,4544),81)
			Result.put (new_triple (4364,4455,4545),82)
			Result.put (new_triple (4364,4455,4546),83)
			Result.put (new_pair (4364,4456),84)
			Result.put (new_triple (4364,4456,4520),85)
			Result.put (new_triple (4364,4456,4521),86)
			Result.put (new_triple (4364,4456,4522),87)
			Result.put (new_triple (4364,4456,4523),88)
			Result.put (new_triple (4364,4456,4524),89)
			Result.put (new_triple (4364,4456,4525),90)
			Result.put (new_triple (4364,4456,4526),91)
			Result.put (new_triple (4364,4456,4527),92)
			Result.put (new_triple (4364,4456,4528),93)
			Result.put (new_triple (4364,4456,4529),94)
			Result.put (new_triple (4364,4456,4530),95)
			Result.put (new_triple (4364,4456,4531),96)
			Result.put (new_triple (4364,4456,4532),97)
			Result.put (new_triple (4364,4456,4533),98)
			Result.put (new_triple (4364,4456,4534),99)
			Result.put (new_triple (4364,4456,4535),100)
			Result.put (new_triple (4364,4456,4536),101)
			Result.put (new_triple (4364,4456,4537),102)
			Result.put (new_triple (4364,4456,4538),103)
			Result.put (new_triple (4364,4456,4539),104)
			Result.put (new_triple (4364,4456,4540),105)
			Result.put (new_triple (4364,4456,4541),106)
			Result.put (new_triple (4364,4456,4542),107)
			Result.put (new_triple (4364,4456,4543),108)
			Result.put (new_triple (4364,4456,4544),109)
			Result.put (new_triple (4364,4456,4545),110)
			Result.put (new_triple (4364,4456,4546),111)
			Result.put (new_pair (4364,4457),112)
			Result.put (new_triple (4364,4457,4520),113)
			Result.put (new_triple (4364,4457,4521),114)
			Result.put (new_triple (4364,4457,4522),115)
			Result.put (new_triple (4364,4457,4523),116)
			Result.put (new_triple (4364,4457,4524),117)
			Result.put (new_triple (4364,4457,4525),118)
			Result.put (new_triple (4364,4457,4526),119)
			Result.put (new_triple (4364,4457,4527),120)
			Result.put (new_triple (4364,4457,4528),121)
			Result.put (new_triple (4364,4457,4529),122)
			Result.put (new_triple (4364,4457,4530),123)
			Result.put (new_triple (4364,4457,4531),124)
			Result.put (new_triple (4364,4457,4532),125)
			Result.put (new_triple (4364,4457,4533),126)
			Result.put (new_triple (4364,4457,4534),127)
			Result.put (new_triple (4364,4457,4535),128)
			Result.put (new_triple (4364,4457,4536),129)
			Result.put (new_triple (4364,4457,4537),130)
			Result.put (new_triple (4364,4457,4538),131)
			Result.put (new_triple (4364,4457,4539),132)
			Result.put (new_triple (4364,4457,4540),133)
			Result.put (new_triple (4364,4457,4541),134)
			Result.put (new_triple (4364,4457,4542),135)
			Result.put (new_triple (4364,4457,4543),136)
			Result.put (new_triple (4364,4457,4544),137)
			Result.put (new_triple (4364,4457,4545),138)
			Result.put (new_triple (4364,4457,4546),139)
			Result.put (new_pair (4364,4458),140)
			Result.put (new_triple (4364,4458,4520),141)
			Result.put (new_triple (4364,4458,4521),142)
			Result.put (new_triple (4364,4458,4522),143)
			Result.put (new_triple (4364,4458,4523),144)
			Result.put (new_triple (4364,4458,4524),145)
			Result.put (new_triple (4364,4458,4525),146)
			Result.put (new_triple (4364,4458,4526),147)
			Result.put (new_triple (4364,4458,4527),148)
			Result.put (new_triple (4364,4458,4528),149)
			Result.put (new_triple (4364,4458,4529),150)
			Result.put (new_triple (4364,4458,4530),151)
			Result.put (new_triple (4364,4458,4531),152)
			Result.put (new_triple (4364,4458,4532),153)
			Result.put (new_triple (4364,4458,4533),154)
			Result.put (new_triple (4364,4458,4534),155)
			Result.put (new_triple (4364,4458,4535),156)
			Result.put (new_triple (4364,4458,4536),157)
			Result.put (new_triple (4364,4458,4537),158)
			Result.put (new_triple (4364,4458,4538),159)
			Result.put (new_triple (4364,4458,4539),160)
			Result.put (new_triple (4364,4458,4540),161)
			Result.put (new_triple (4364,4458,4541),162)
			Result.put (new_triple (4364,4458,4542),163)
			Result.put (new_triple (4364,4458,4543),164)
			Result.put (new_triple (4364,4458,4544),165)
			Result.put (new_triple (4364,4458,4545),166)
			Result.put (new_triple (4364,4458,4546),167)
			Result.put (new_pair (4364,4459),168)
			Result.put (new_triple (4364,4459,4520),169)
			Result.put (new_triple (4364,4459,4521),170)
			Result.put (new_triple (4364,4459,4522),171)
			Result.put (new_triple (4364,4459,4523),172)
			Result.put (new_triple (4364,4459,4524),173)
			Result.put (new_triple (4364,4459,4525),174)
			Result.put (new_triple (4364,4459,4526),175)
			Result.put (new_triple (4364,4459,4527),176)
			Result.put (new_triple (4364,4459,4528),177)
			Result.put (new_triple (4364,4459,4529),178)
			Result.put (new_triple (4364,4459,4530),179)
			Result.put (new_triple (4364,4459,4531),180)
			Result.put (new_triple (4364,4459,4532),181)
			Result.put (new_triple (4364,4459,4533),182)
			Result.put (new_triple (4364,4459,4534),183)
			Result.put (new_triple (4364,4459,4535),184)
			Result.put (new_triple (4364,4459,4536),185)
			Result.put (new_triple (4364,4459,4537),186)
			Result.put (new_triple (4364,4459,4538),187)
			Result.put (new_triple (4364,4459,4539),188)
			Result.put (new_triple (4364,4459,4540),189)
			Result.put (new_triple (4364,4459,4541),190)
			Result.put (new_triple (4364,4459,4542),191)
			Result.put (new_triple (4364,4459,4543),192)
			Result.put (new_triple (4364,4459,4544),193)
			Result.put (new_triple (4364,4459,4545),194)
			Result.put (new_triple (4364,4459,4546),195)
			Result.put (new_pair (4364,4460),196)
			Result.put (new_triple (4364,4460,4520),197)
			Result.put (new_triple (4364,4460,4521),198)
			Result.put (new_triple (4364,4460,4522),199)
			Result.put (new_triple (4364,4460,4523),200)
			Result.put (new_triple (4364,4460,4524),201)
			Result.put (new_triple (4364,4460,4525),202)
			Result.put (new_triple (4364,4460,4526),203)
			Result.put (new_triple (4364,4460,4527),204)
			Result.put (new_triple (4364,4460,4528),205)
			Result.put (new_triple (4364,4460,4529),206)
			Result.put (new_triple (4364,4460,4530),207)
			Result.put (new_triple (4364,4460,4531),208)
			Result.put (new_triple (4364,4460,4532),209)
			Result.put (new_triple (4364,4460,4533),210)
			Result.put (new_triple (4364,4460,4534),211)
			Result.put (new_triple (4364,4460,4535),212)
			Result.put (new_triple (4364,4460,4536),213)
			Result.put (new_triple (4364,4460,4537),214)
			Result.put (new_triple (4364,4460,4538),215)
			Result.put (new_triple (4364,4460,4539),216)
			Result.put (new_triple (4364,4460,4540),217)
			Result.put (new_triple (4364,4460,4541),218)
			Result.put (new_triple (4364,4460,4542),219)
			Result.put (new_triple (4364,4460,4543),220)
			Result.put (new_triple (4364,4460,4544),221)
			Result.put (new_triple (4364,4460,4545),222)
			Result.put (new_triple (4364,4460,4546),223)
			Result.put (new_pair (4364,4461),224)
			Result.put (new_triple (4364,4461,4520),225)
			Result.put (new_triple (4364,4461,4521),226)
			Result.put (new_triple (4364,4461,4522),227)
			Result.put (new_triple (4364,4461,4523),228)
			Result.put (new_triple (4364,4461,4524),229)
			Result.put (new_triple (4364,4461,4525),230)
			Result.put (new_triple (4364,4461,4526),231)
			Result.put (new_triple (4364,4461,4527),232)
			Result.put (new_triple (4364,4461,4528),233)
			Result.put (new_triple (4364,4461,4529),234)
			Result.put (new_triple (4364,4461,4530),235)
			Result.put (new_triple (4364,4461,4531),236)
			Result.put (new_triple (4364,4461,4532),237)
			Result.put (new_triple (4364,4461,4533),238)
			Result.put (new_triple (4364,4461,4534),239)
			Result.put (new_triple (4364,4461,4535),240)
			Result.put (new_triple (4364,4461,4536),241)
			Result.put (new_triple (4364,4461,4537),242)
			Result.put (new_triple (4364,4461,4538),243)
			Result.put (new_triple (4364,4461,4539),244)
			Result.put (new_triple (4364,4461,4540),245)
			Result.put (new_triple (4364,4461,4541),246)
			Result.put (new_triple (4364,4461,4542),247)
			Result.put (new_triple (4364,4461,4543),248)
			Result.put (new_triple (4364,4461,4544),249)
			Result.put (new_triple (4364,4461,4545),250)
			Result.put (new_triple (4364,4461,4546),251)
			Result.put (new_pair (4364,4462),252)
			Result.put (new_triple (4364,4462,4520),253)
			Result.put (new_triple (4364,4462,4521),254)
			Result.put (new_triple (4364,4462,4522),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_201: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4364,4462,4523),0)
			Result.put (new_triple (4364,4462,4524),1)
			Result.put (new_triple (4364,4462,4525),2)
			Result.put (new_triple (4364,4462,4526),3)
			Result.put (new_triple (4364,4462,4527),4)
			Result.put (new_triple (4364,4462,4528),5)
			Result.put (new_triple (4364,4462,4529),6)
			Result.put (new_triple (4364,4462,4530),7)
			Result.put (new_triple (4364,4462,4531),8)
			Result.put (new_triple (4364,4462,4532),9)
			Result.put (new_triple (4364,4462,4533),10)
			Result.put (new_triple (4364,4462,4534),11)
			Result.put (new_triple (4364,4462,4535),12)
			Result.put (new_triple (4364,4462,4536),13)
			Result.put (new_triple (4364,4462,4537),14)
			Result.put (new_triple (4364,4462,4538),15)
			Result.put (new_triple (4364,4462,4539),16)
			Result.put (new_triple (4364,4462,4540),17)
			Result.put (new_triple (4364,4462,4541),18)
			Result.put (new_triple (4364,4462,4542),19)
			Result.put (new_triple (4364,4462,4543),20)
			Result.put (new_triple (4364,4462,4544),21)
			Result.put (new_triple (4364,4462,4545),22)
			Result.put (new_triple (4364,4462,4546),23)
			Result.put (new_pair (4364,4463),24)
			Result.put (new_triple (4364,4463,4520),25)
			Result.put (new_triple (4364,4463,4521),26)
			Result.put (new_triple (4364,4463,4522),27)
			Result.put (new_triple (4364,4463,4523),28)
			Result.put (new_triple (4364,4463,4524),29)
			Result.put (new_triple (4364,4463,4525),30)
			Result.put (new_triple (4364,4463,4526),31)
			Result.put (new_triple (4364,4463,4527),32)
			Result.put (new_triple (4364,4463,4528),33)
			Result.put (new_triple (4364,4463,4529),34)
			Result.put (new_triple (4364,4463,4530),35)
			Result.put (new_triple (4364,4463,4531),36)
			Result.put (new_triple (4364,4463,4532),37)
			Result.put (new_triple (4364,4463,4533),38)
			Result.put (new_triple (4364,4463,4534),39)
			Result.put (new_triple (4364,4463,4535),40)
			Result.put (new_triple (4364,4463,4536),41)
			Result.put (new_triple (4364,4463,4537),42)
			Result.put (new_triple (4364,4463,4538),43)
			Result.put (new_triple (4364,4463,4539),44)
			Result.put (new_triple (4364,4463,4540),45)
			Result.put (new_triple (4364,4463,4541),46)
			Result.put (new_triple (4364,4463,4542),47)
			Result.put (new_triple (4364,4463,4543),48)
			Result.put (new_triple (4364,4463,4544),49)
			Result.put (new_triple (4364,4463,4545),50)
			Result.put (new_triple (4364,4463,4546),51)
			Result.put (new_pair (4364,4464),52)
			Result.put (new_triple (4364,4464,4520),53)
			Result.put (new_triple (4364,4464,4521),54)
			Result.put (new_triple (4364,4464,4522),55)
			Result.put (new_triple (4364,4464,4523),56)
			Result.put (new_triple (4364,4464,4524),57)
			Result.put (new_triple (4364,4464,4525),58)
			Result.put (new_triple (4364,4464,4526),59)
			Result.put (new_triple (4364,4464,4527),60)
			Result.put (new_triple (4364,4464,4528),61)
			Result.put (new_triple (4364,4464,4529),62)
			Result.put (new_triple (4364,4464,4530),63)
			Result.put (new_triple (4364,4464,4531),64)
			Result.put (new_triple (4364,4464,4532),65)
			Result.put (new_triple (4364,4464,4533),66)
			Result.put (new_triple (4364,4464,4534),67)
			Result.put (new_triple (4364,4464,4535),68)
			Result.put (new_triple (4364,4464,4536),69)
			Result.put (new_triple (4364,4464,4537),70)
			Result.put (new_triple (4364,4464,4538),71)
			Result.put (new_triple (4364,4464,4539),72)
			Result.put (new_triple (4364,4464,4540),73)
			Result.put (new_triple (4364,4464,4541),74)
			Result.put (new_triple (4364,4464,4542),75)
			Result.put (new_triple (4364,4464,4543),76)
			Result.put (new_triple (4364,4464,4544),77)
			Result.put (new_triple (4364,4464,4545),78)
			Result.put (new_triple (4364,4464,4546),79)
			Result.put (new_pair (4364,4465),80)
			Result.put (new_triple (4364,4465,4520),81)
			Result.put (new_triple (4364,4465,4521),82)
			Result.put (new_triple (4364,4465,4522),83)
			Result.put (new_triple (4364,4465,4523),84)
			Result.put (new_triple (4364,4465,4524),85)
			Result.put (new_triple (4364,4465,4525),86)
			Result.put (new_triple (4364,4465,4526),87)
			Result.put (new_triple (4364,4465,4527),88)
			Result.put (new_triple (4364,4465,4528),89)
			Result.put (new_triple (4364,4465,4529),90)
			Result.put (new_triple (4364,4465,4530),91)
			Result.put (new_triple (4364,4465,4531),92)
			Result.put (new_triple (4364,4465,4532),93)
			Result.put (new_triple (4364,4465,4533),94)
			Result.put (new_triple (4364,4465,4534),95)
			Result.put (new_triple (4364,4465,4535),96)
			Result.put (new_triple (4364,4465,4536),97)
			Result.put (new_triple (4364,4465,4537),98)
			Result.put (new_triple (4364,4465,4538),99)
			Result.put (new_triple (4364,4465,4539),100)
			Result.put (new_triple (4364,4465,4540),101)
			Result.put (new_triple (4364,4465,4541),102)
			Result.put (new_triple (4364,4465,4542),103)
			Result.put (new_triple (4364,4465,4543),104)
			Result.put (new_triple (4364,4465,4544),105)
			Result.put (new_triple (4364,4465,4545),106)
			Result.put (new_triple (4364,4465,4546),107)
			Result.put (new_pair (4364,4466),108)
			Result.put (new_triple (4364,4466,4520),109)
			Result.put (new_triple (4364,4466,4521),110)
			Result.put (new_triple (4364,4466,4522),111)
			Result.put (new_triple (4364,4466,4523),112)
			Result.put (new_triple (4364,4466,4524),113)
			Result.put (new_triple (4364,4466,4525),114)
			Result.put (new_triple (4364,4466,4526),115)
			Result.put (new_triple (4364,4466,4527),116)
			Result.put (new_triple (4364,4466,4528),117)
			Result.put (new_triple (4364,4466,4529),118)
			Result.put (new_triple (4364,4466,4530),119)
			Result.put (new_triple (4364,4466,4531),120)
			Result.put (new_triple (4364,4466,4532),121)
			Result.put (new_triple (4364,4466,4533),122)
			Result.put (new_triple (4364,4466,4534),123)
			Result.put (new_triple (4364,4466,4535),124)
			Result.put (new_triple (4364,4466,4536),125)
			Result.put (new_triple (4364,4466,4537),126)
			Result.put (new_triple (4364,4466,4538),127)
			Result.put (new_triple (4364,4466,4539),128)
			Result.put (new_triple (4364,4466,4540),129)
			Result.put (new_triple (4364,4466,4541),130)
			Result.put (new_triple (4364,4466,4542),131)
			Result.put (new_triple (4364,4466,4543),132)
			Result.put (new_triple (4364,4466,4544),133)
			Result.put (new_triple (4364,4466,4545),134)
			Result.put (new_triple (4364,4466,4546),135)
			Result.put (new_pair (4364,4467),136)
			Result.put (new_triple (4364,4467,4520),137)
			Result.put (new_triple (4364,4467,4521),138)
			Result.put (new_triple (4364,4467,4522),139)
			Result.put (new_triple (4364,4467,4523),140)
			Result.put (new_triple (4364,4467,4524),141)
			Result.put (new_triple (4364,4467,4525),142)
			Result.put (new_triple (4364,4467,4526),143)
			Result.put (new_triple (4364,4467,4527),144)
			Result.put (new_triple (4364,4467,4528),145)
			Result.put (new_triple (4364,4467,4529),146)
			Result.put (new_triple (4364,4467,4530),147)
			Result.put (new_triple (4364,4467,4531),148)
			Result.put (new_triple (4364,4467,4532),149)
			Result.put (new_triple (4364,4467,4533),150)
			Result.put (new_triple (4364,4467,4534),151)
			Result.put (new_triple (4364,4467,4535),152)
			Result.put (new_triple (4364,4467,4536),153)
			Result.put (new_triple (4364,4467,4537),154)
			Result.put (new_triple (4364,4467,4538),155)
			Result.put (new_triple (4364,4467,4539),156)
			Result.put (new_triple (4364,4467,4540),157)
			Result.put (new_triple (4364,4467,4541),158)
			Result.put (new_triple (4364,4467,4542),159)
			Result.put (new_triple (4364,4467,4543),160)
			Result.put (new_triple (4364,4467,4544),161)
			Result.put (new_triple (4364,4467,4545),162)
			Result.put (new_triple (4364,4467,4546),163)
			Result.put (new_pair (4364,4468),164)
			Result.put (new_triple (4364,4468,4520),165)
			Result.put (new_triple (4364,4468,4521),166)
			Result.put (new_triple (4364,4468,4522),167)
			Result.put (new_triple (4364,4468,4523),168)
			Result.put (new_triple (4364,4468,4524),169)
			Result.put (new_triple (4364,4468,4525),170)
			Result.put (new_triple (4364,4468,4526),171)
			Result.put (new_triple (4364,4468,4527),172)
			Result.put (new_triple (4364,4468,4528),173)
			Result.put (new_triple (4364,4468,4529),174)
			Result.put (new_triple (4364,4468,4530),175)
			Result.put (new_triple (4364,4468,4531),176)
			Result.put (new_triple (4364,4468,4532),177)
			Result.put (new_triple (4364,4468,4533),178)
			Result.put (new_triple (4364,4468,4534),179)
			Result.put (new_triple (4364,4468,4535),180)
			Result.put (new_triple (4364,4468,4536),181)
			Result.put (new_triple (4364,4468,4537),182)
			Result.put (new_triple (4364,4468,4538),183)
			Result.put (new_triple (4364,4468,4539),184)
			Result.put (new_triple (4364,4468,4540),185)
			Result.put (new_triple (4364,4468,4541),186)
			Result.put (new_triple (4364,4468,4542),187)
			Result.put (new_triple (4364,4468,4543),188)
			Result.put (new_triple (4364,4468,4544),189)
			Result.put (new_triple (4364,4468,4545),190)
			Result.put (new_triple (4364,4468,4546),191)
			Result.put (new_pair (4364,4469),192)
			Result.put (new_triple (4364,4469,4520),193)
			Result.put (new_triple (4364,4469,4521),194)
			Result.put (new_triple (4364,4469,4522),195)
			Result.put (new_triple (4364,4469,4523),196)
			Result.put (new_triple (4364,4469,4524),197)
			Result.put (new_triple (4364,4469,4525),198)
			Result.put (new_triple (4364,4469,4526),199)
			Result.put (new_triple (4364,4469,4527),200)
			Result.put (new_triple (4364,4469,4528),201)
			Result.put (new_triple (4364,4469,4529),202)
			Result.put (new_triple (4364,4469,4530),203)
			Result.put (new_triple (4364,4469,4531),204)
			Result.put (new_triple (4364,4469,4532),205)
			Result.put (new_triple (4364,4469,4533),206)
			Result.put (new_triple (4364,4469,4534),207)
			Result.put (new_triple (4364,4469,4535),208)
			Result.put (new_triple (4364,4469,4536),209)
			Result.put (new_triple (4364,4469,4537),210)
			Result.put (new_triple (4364,4469,4538),211)
			Result.put (new_triple (4364,4469,4539),212)
			Result.put (new_triple (4364,4469,4540),213)
			Result.put (new_triple (4364,4469,4541),214)
			Result.put (new_triple (4364,4469,4542),215)
			Result.put (new_triple (4364,4469,4543),216)
			Result.put (new_triple (4364,4469,4544),217)
			Result.put (new_triple (4364,4469,4545),218)
			Result.put (new_triple (4364,4469,4546),219)
			Result.put (new_pair (4365,4449),220)
			Result.put (new_triple (4365,4449,4520),221)
			Result.put (new_triple (4365,4449,4521),222)
			Result.put (new_triple (4365,4449,4522),223)
			Result.put (new_triple (4365,4449,4523),224)
			Result.put (new_triple (4365,4449,4524),225)
			Result.put (new_triple (4365,4449,4525),226)
			Result.put (new_triple (4365,4449,4526),227)
			Result.put (new_triple (4365,4449,4527),228)
			Result.put (new_triple (4365,4449,4528),229)
			Result.put (new_triple (4365,4449,4529),230)
			Result.put (new_triple (4365,4449,4530),231)
			Result.put (new_triple (4365,4449,4531),232)
			Result.put (new_triple (4365,4449,4532),233)
			Result.put (new_triple (4365,4449,4533),234)
			Result.put (new_triple (4365,4449,4534),235)
			Result.put (new_triple (4365,4449,4535),236)
			Result.put (new_triple (4365,4449,4536),237)
			Result.put (new_triple (4365,4449,4537),238)
			Result.put (new_triple (4365,4449,4538),239)
			Result.put (new_triple (4365,4449,4539),240)
			Result.put (new_triple (4365,4449,4540),241)
			Result.put (new_triple (4365,4449,4541),242)
			Result.put (new_triple (4365,4449,4542),243)
			Result.put (new_triple (4365,4449,4543),244)
			Result.put (new_triple (4365,4449,4544),245)
			Result.put (new_triple (4365,4449,4545),246)
			Result.put (new_triple (4365,4449,4546),247)
			Result.put (new_pair (4365,4450),248)
			Result.put (new_triple (4365,4450,4520),249)
			Result.put (new_triple (4365,4450,4521),250)
			Result.put (new_triple (4365,4450,4522),251)
			Result.put (new_triple (4365,4450,4523),252)
			Result.put (new_triple (4365,4450,4524),253)
			Result.put (new_triple (4365,4450,4525),254)
			Result.put (new_triple (4365,4450,4526),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_202: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4365,4450,4527),0)
			Result.put (new_triple (4365,4450,4528),1)
			Result.put (new_triple (4365,4450,4529),2)
			Result.put (new_triple (4365,4450,4530),3)
			Result.put (new_triple (4365,4450,4531),4)
			Result.put (new_triple (4365,4450,4532),5)
			Result.put (new_triple (4365,4450,4533),6)
			Result.put (new_triple (4365,4450,4534),7)
			Result.put (new_triple (4365,4450,4535),8)
			Result.put (new_triple (4365,4450,4536),9)
			Result.put (new_triple (4365,4450,4537),10)
			Result.put (new_triple (4365,4450,4538),11)
			Result.put (new_triple (4365,4450,4539),12)
			Result.put (new_triple (4365,4450,4540),13)
			Result.put (new_triple (4365,4450,4541),14)
			Result.put (new_triple (4365,4450,4542),15)
			Result.put (new_triple (4365,4450,4543),16)
			Result.put (new_triple (4365,4450,4544),17)
			Result.put (new_triple (4365,4450,4545),18)
			Result.put (new_triple (4365,4450,4546),19)
			Result.put (new_pair (4365,4451),20)
			Result.put (new_triple (4365,4451,4520),21)
			Result.put (new_triple (4365,4451,4521),22)
			Result.put (new_triple (4365,4451,4522),23)
			Result.put (new_triple (4365,4451,4523),24)
			Result.put (new_triple (4365,4451,4524),25)
			Result.put (new_triple (4365,4451,4525),26)
			Result.put (new_triple (4365,4451,4526),27)
			Result.put (new_triple (4365,4451,4527),28)
			Result.put (new_triple (4365,4451,4528),29)
			Result.put (new_triple (4365,4451,4529),30)
			Result.put (new_triple (4365,4451,4530),31)
			Result.put (new_triple (4365,4451,4531),32)
			Result.put (new_triple (4365,4451,4532),33)
			Result.put (new_triple (4365,4451,4533),34)
			Result.put (new_triple (4365,4451,4534),35)
			Result.put (new_triple (4365,4451,4535),36)
			Result.put (new_triple (4365,4451,4536),37)
			Result.put (new_triple (4365,4451,4537),38)
			Result.put (new_triple (4365,4451,4538),39)
			Result.put (new_triple (4365,4451,4539),40)
			Result.put (new_triple (4365,4451,4540),41)
			Result.put (new_triple (4365,4451,4541),42)
			Result.put (new_triple (4365,4451,4542),43)
			Result.put (new_triple (4365,4451,4543),44)
			Result.put (new_triple (4365,4451,4544),45)
			Result.put (new_triple (4365,4451,4545),46)
			Result.put (new_triple (4365,4451,4546),47)
			Result.put (new_pair (4365,4452),48)
			Result.put (new_triple (4365,4452,4520),49)
			Result.put (new_triple (4365,4452,4521),50)
			Result.put (new_triple (4365,4452,4522),51)
			Result.put (new_triple (4365,4452,4523),52)
			Result.put (new_triple (4365,4452,4524),53)
			Result.put (new_triple (4365,4452,4525),54)
			Result.put (new_triple (4365,4452,4526),55)
			Result.put (new_triple (4365,4452,4527),56)
			Result.put (new_triple (4365,4452,4528),57)
			Result.put (new_triple (4365,4452,4529),58)
			Result.put (new_triple (4365,4452,4530),59)
			Result.put (new_triple (4365,4452,4531),60)
			Result.put (new_triple (4365,4452,4532),61)
			Result.put (new_triple (4365,4452,4533),62)
			Result.put (new_triple (4365,4452,4534),63)
			Result.put (new_triple (4365,4452,4535),64)
			Result.put (new_triple (4365,4452,4536),65)
			Result.put (new_triple (4365,4452,4537),66)
			Result.put (new_triple (4365,4452,4538),67)
			Result.put (new_triple (4365,4452,4539),68)
			Result.put (new_triple (4365,4452,4540),69)
			Result.put (new_triple (4365,4452,4541),70)
			Result.put (new_triple (4365,4452,4542),71)
			Result.put (new_triple (4365,4452,4543),72)
			Result.put (new_triple (4365,4452,4544),73)
			Result.put (new_triple (4365,4452,4545),74)
			Result.put (new_triple (4365,4452,4546),75)
			Result.put (new_pair (4365,4453),76)
			Result.put (new_triple (4365,4453,4520),77)
			Result.put (new_triple (4365,4453,4521),78)
			Result.put (new_triple (4365,4453,4522),79)
			Result.put (new_triple (4365,4453,4523),80)
			Result.put (new_triple (4365,4453,4524),81)
			Result.put (new_triple (4365,4453,4525),82)
			Result.put (new_triple (4365,4453,4526),83)
			Result.put (new_triple (4365,4453,4527),84)
			Result.put (new_triple (4365,4453,4528),85)
			Result.put (new_triple (4365,4453,4529),86)
			Result.put (new_triple (4365,4453,4530),87)
			Result.put (new_triple (4365,4453,4531),88)
			Result.put (new_triple (4365,4453,4532),89)
			Result.put (new_triple (4365,4453,4533),90)
			Result.put (new_triple (4365,4453,4534),91)
			Result.put (new_triple (4365,4453,4535),92)
			Result.put (new_triple (4365,4453,4536),93)
			Result.put (new_triple (4365,4453,4537),94)
			Result.put (new_triple (4365,4453,4538),95)
			Result.put (new_triple (4365,4453,4539),96)
			Result.put (new_triple (4365,4453,4540),97)
			Result.put (new_triple (4365,4453,4541),98)
			Result.put (new_triple (4365,4453,4542),99)
			Result.put (new_triple (4365,4453,4543),100)
			Result.put (new_triple (4365,4453,4544),101)
			Result.put (new_triple (4365,4453,4545),102)
			Result.put (new_triple (4365,4453,4546),103)
			Result.put (new_pair (4365,4454),104)
			Result.put (new_triple (4365,4454,4520),105)
			Result.put (new_triple (4365,4454,4521),106)
			Result.put (new_triple (4365,4454,4522),107)
			Result.put (new_triple (4365,4454,4523),108)
			Result.put (new_triple (4365,4454,4524),109)
			Result.put (new_triple (4365,4454,4525),110)
			Result.put (new_triple (4365,4454,4526),111)
			Result.put (new_triple (4365,4454,4527),112)
			Result.put (new_triple (4365,4454,4528),113)
			Result.put (new_triple (4365,4454,4529),114)
			Result.put (new_triple (4365,4454,4530),115)
			Result.put (new_triple (4365,4454,4531),116)
			Result.put (new_triple (4365,4454,4532),117)
			Result.put (new_triple (4365,4454,4533),118)
			Result.put (new_triple (4365,4454,4534),119)
			Result.put (new_triple (4365,4454,4535),120)
			Result.put (new_triple (4365,4454,4536),121)
			Result.put (new_triple (4365,4454,4537),122)
			Result.put (new_triple (4365,4454,4538),123)
			Result.put (new_triple (4365,4454,4539),124)
			Result.put (new_triple (4365,4454,4540),125)
			Result.put (new_triple (4365,4454,4541),126)
			Result.put (new_triple (4365,4454,4542),127)
			Result.put (new_triple (4365,4454,4543),128)
			Result.put (new_triple (4365,4454,4544),129)
			Result.put (new_triple (4365,4454,4545),130)
			Result.put (new_triple (4365,4454,4546),131)
			Result.put (new_pair (4365,4455),132)
			Result.put (new_triple (4365,4455,4520),133)
			Result.put (new_triple (4365,4455,4521),134)
			Result.put (new_triple (4365,4455,4522),135)
			Result.put (new_triple (4365,4455,4523),136)
			Result.put (new_triple (4365,4455,4524),137)
			Result.put (new_triple (4365,4455,4525),138)
			Result.put (new_triple (4365,4455,4526),139)
			Result.put (new_triple (4365,4455,4527),140)
			Result.put (new_triple (4365,4455,4528),141)
			Result.put (new_triple (4365,4455,4529),142)
			Result.put (new_triple (4365,4455,4530),143)
			Result.put (new_triple (4365,4455,4531),144)
			Result.put (new_triple (4365,4455,4532),145)
			Result.put (new_triple (4365,4455,4533),146)
			Result.put (new_triple (4365,4455,4534),147)
			Result.put (new_triple (4365,4455,4535),148)
			Result.put (new_triple (4365,4455,4536),149)
			Result.put (new_triple (4365,4455,4537),150)
			Result.put (new_triple (4365,4455,4538),151)
			Result.put (new_triple (4365,4455,4539),152)
			Result.put (new_triple (4365,4455,4540),153)
			Result.put (new_triple (4365,4455,4541),154)
			Result.put (new_triple (4365,4455,4542),155)
			Result.put (new_triple (4365,4455,4543),156)
			Result.put (new_triple (4365,4455,4544),157)
			Result.put (new_triple (4365,4455,4545),158)
			Result.put (new_triple (4365,4455,4546),159)
			Result.put (new_pair (4365,4456),160)
			Result.put (new_triple (4365,4456,4520),161)
			Result.put (new_triple (4365,4456,4521),162)
			Result.put (new_triple (4365,4456,4522),163)
			Result.put (new_triple (4365,4456,4523),164)
			Result.put (new_triple (4365,4456,4524),165)
			Result.put (new_triple (4365,4456,4525),166)
			Result.put (new_triple (4365,4456,4526),167)
			Result.put (new_triple (4365,4456,4527),168)
			Result.put (new_triple (4365,4456,4528),169)
			Result.put (new_triple (4365,4456,4529),170)
			Result.put (new_triple (4365,4456,4530),171)
			Result.put (new_triple (4365,4456,4531),172)
			Result.put (new_triple (4365,4456,4532),173)
			Result.put (new_triple (4365,4456,4533),174)
			Result.put (new_triple (4365,4456,4534),175)
			Result.put (new_triple (4365,4456,4535),176)
			Result.put (new_triple (4365,4456,4536),177)
			Result.put (new_triple (4365,4456,4537),178)
			Result.put (new_triple (4365,4456,4538),179)
			Result.put (new_triple (4365,4456,4539),180)
			Result.put (new_triple (4365,4456,4540),181)
			Result.put (new_triple (4365,4456,4541),182)
			Result.put (new_triple (4365,4456,4542),183)
			Result.put (new_triple (4365,4456,4543),184)
			Result.put (new_triple (4365,4456,4544),185)
			Result.put (new_triple (4365,4456,4545),186)
			Result.put (new_triple (4365,4456,4546),187)
			Result.put (new_pair (4365,4457),188)
			Result.put (new_triple (4365,4457,4520),189)
			Result.put (new_triple (4365,4457,4521),190)
			Result.put (new_triple (4365,4457,4522),191)
			Result.put (new_triple (4365,4457,4523),192)
			Result.put (new_triple (4365,4457,4524),193)
			Result.put (new_triple (4365,4457,4525),194)
			Result.put (new_triple (4365,4457,4526),195)
			Result.put (new_triple (4365,4457,4527),196)
			Result.put (new_triple (4365,4457,4528),197)
			Result.put (new_triple (4365,4457,4529),198)
			Result.put (new_triple (4365,4457,4530),199)
			Result.put (new_triple (4365,4457,4531),200)
			Result.put (new_triple (4365,4457,4532),201)
			Result.put (new_triple (4365,4457,4533),202)
			Result.put (new_triple (4365,4457,4534),203)
			Result.put (new_triple (4365,4457,4535),204)
			Result.put (new_triple (4365,4457,4536),205)
			Result.put (new_triple (4365,4457,4537),206)
			Result.put (new_triple (4365,4457,4538),207)
			Result.put (new_triple (4365,4457,4539),208)
			Result.put (new_triple (4365,4457,4540),209)
			Result.put (new_triple (4365,4457,4541),210)
			Result.put (new_triple (4365,4457,4542),211)
			Result.put (new_triple (4365,4457,4543),212)
			Result.put (new_triple (4365,4457,4544),213)
			Result.put (new_triple (4365,4457,4545),214)
			Result.put (new_triple (4365,4457,4546),215)
			Result.put (new_pair (4365,4458),216)
			Result.put (new_triple (4365,4458,4520),217)
			Result.put (new_triple (4365,4458,4521),218)
			Result.put (new_triple (4365,4458,4522),219)
			Result.put (new_triple (4365,4458,4523),220)
			Result.put (new_triple (4365,4458,4524),221)
			Result.put (new_triple (4365,4458,4525),222)
			Result.put (new_triple (4365,4458,4526),223)
			Result.put (new_triple (4365,4458,4527),224)
			Result.put (new_triple (4365,4458,4528),225)
			Result.put (new_triple (4365,4458,4529),226)
			Result.put (new_triple (4365,4458,4530),227)
			Result.put (new_triple (4365,4458,4531),228)
			Result.put (new_triple (4365,4458,4532),229)
			Result.put (new_triple (4365,4458,4533),230)
			Result.put (new_triple (4365,4458,4534),231)
			Result.put (new_triple (4365,4458,4535),232)
			Result.put (new_triple (4365,4458,4536),233)
			Result.put (new_triple (4365,4458,4537),234)
			Result.put (new_triple (4365,4458,4538),235)
			Result.put (new_triple (4365,4458,4539),236)
			Result.put (new_triple (4365,4458,4540),237)
			Result.put (new_triple (4365,4458,4541),238)
			Result.put (new_triple (4365,4458,4542),239)
			Result.put (new_triple (4365,4458,4543),240)
			Result.put (new_triple (4365,4458,4544),241)
			Result.put (new_triple (4365,4458,4545),242)
			Result.put (new_triple (4365,4458,4546),243)
			Result.put (new_pair (4365,4459),244)
			Result.put (new_triple (4365,4459,4520),245)
			Result.put (new_triple (4365,4459,4521),246)
			Result.put (new_triple (4365,4459,4522),247)
			Result.put (new_triple (4365,4459,4523),248)
			Result.put (new_triple (4365,4459,4524),249)
			Result.put (new_triple (4365,4459,4525),250)
			Result.put (new_triple (4365,4459,4526),251)
			Result.put (new_triple (4365,4459,4527),252)
			Result.put (new_triple (4365,4459,4528),253)
			Result.put (new_triple (4365,4459,4529),254)
			Result.put (new_triple (4365,4459,4530),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_203: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4365,4459,4531),0)
			Result.put (new_triple (4365,4459,4532),1)
			Result.put (new_triple (4365,4459,4533),2)
			Result.put (new_triple (4365,4459,4534),3)
			Result.put (new_triple (4365,4459,4535),4)
			Result.put (new_triple (4365,4459,4536),5)
			Result.put (new_triple (4365,4459,4537),6)
			Result.put (new_triple (4365,4459,4538),7)
			Result.put (new_triple (4365,4459,4539),8)
			Result.put (new_triple (4365,4459,4540),9)
			Result.put (new_triple (4365,4459,4541),10)
			Result.put (new_triple (4365,4459,4542),11)
			Result.put (new_triple (4365,4459,4543),12)
			Result.put (new_triple (4365,4459,4544),13)
			Result.put (new_triple (4365,4459,4545),14)
			Result.put (new_triple (4365,4459,4546),15)
			Result.put (new_pair (4365,4460),16)
			Result.put (new_triple (4365,4460,4520),17)
			Result.put (new_triple (4365,4460,4521),18)
			Result.put (new_triple (4365,4460,4522),19)
			Result.put (new_triple (4365,4460,4523),20)
			Result.put (new_triple (4365,4460,4524),21)
			Result.put (new_triple (4365,4460,4525),22)
			Result.put (new_triple (4365,4460,4526),23)
			Result.put (new_triple (4365,4460,4527),24)
			Result.put (new_triple (4365,4460,4528),25)
			Result.put (new_triple (4365,4460,4529),26)
			Result.put (new_triple (4365,4460,4530),27)
			Result.put (new_triple (4365,4460,4531),28)
			Result.put (new_triple (4365,4460,4532),29)
			Result.put (new_triple (4365,4460,4533),30)
			Result.put (new_triple (4365,4460,4534),31)
			Result.put (new_triple (4365,4460,4535),32)
			Result.put (new_triple (4365,4460,4536),33)
			Result.put (new_triple (4365,4460,4537),34)
			Result.put (new_triple (4365,4460,4538),35)
			Result.put (new_triple (4365,4460,4539),36)
			Result.put (new_triple (4365,4460,4540),37)
			Result.put (new_triple (4365,4460,4541),38)
			Result.put (new_triple (4365,4460,4542),39)
			Result.put (new_triple (4365,4460,4543),40)
			Result.put (new_triple (4365,4460,4544),41)
			Result.put (new_triple (4365,4460,4545),42)
			Result.put (new_triple (4365,4460,4546),43)
			Result.put (new_pair (4365,4461),44)
			Result.put (new_triple (4365,4461,4520),45)
			Result.put (new_triple (4365,4461,4521),46)
			Result.put (new_triple (4365,4461,4522),47)
			Result.put (new_triple (4365,4461,4523),48)
			Result.put (new_triple (4365,4461,4524),49)
			Result.put (new_triple (4365,4461,4525),50)
			Result.put (new_triple (4365,4461,4526),51)
			Result.put (new_triple (4365,4461,4527),52)
			Result.put (new_triple (4365,4461,4528),53)
			Result.put (new_triple (4365,4461,4529),54)
			Result.put (new_triple (4365,4461,4530),55)
			Result.put (new_triple (4365,4461,4531),56)
			Result.put (new_triple (4365,4461,4532),57)
			Result.put (new_triple (4365,4461,4533),58)
			Result.put (new_triple (4365,4461,4534),59)
			Result.put (new_triple (4365,4461,4535),60)
			Result.put (new_triple (4365,4461,4536),61)
			Result.put (new_triple (4365,4461,4537),62)
			Result.put (new_triple (4365,4461,4538),63)
			Result.put (new_triple (4365,4461,4539),64)
			Result.put (new_triple (4365,4461,4540),65)
			Result.put (new_triple (4365,4461,4541),66)
			Result.put (new_triple (4365,4461,4542),67)
			Result.put (new_triple (4365,4461,4543),68)
			Result.put (new_triple (4365,4461,4544),69)
			Result.put (new_triple (4365,4461,4545),70)
			Result.put (new_triple (4365,4461,4546),71)
			Result.put (new_pair (4365,4462),72)
			Result.put (new_triple (4365,4462,4520),73)
			Result.put (new_triple (4365,4462,4521),74)
			Result.put (new_triple (4365,4462,4522),75)
			Result.put (new_triple (4365,4462,4523),76)
			Result.put (new_triple (4365,4462,4524),77)
			Result.put (new_triple (4365,4462,4525),78)
			Result.put (new_triple (4365,4462,4526),79)
			Result.put (new_triple (4365,4462,4527),80)
			Result.put (new_triple (4365,4462,4528),81)
			Result.put (new_triple (4365,4462,4529),82)
			Result.put (new_triple (4365,4462,4530),83)
			Result.put (new_triple (4365,4462,4531),84)
			Result.put (new_triple (4365,4462,4532),85)
			Result.put (new_triple (4365,4462,4533),86)
			Result.put (new_triple (4365,4462,4534),87)
			Result.put (new_triple (4365,4462,4535),88)
			Result.put (new_triple (4365,4462,4536),89)
			Result.put (new_triple (4365,4462,4537),90)
			Result.put (new_triple (4365,4462,4538),91)
			Result.put (new_triple (4365,4462,4539),92)
			Result.put (new_triple (4365,4462,4540),93)
			Result.put (new_triple (4365,4462,4541),94)
			Result.put (new_triple (4365,4462,4542),95)
			Result.put (new_triple (4365,4462,4543),96)
			Result.put (new_triple (4365,4462,4544),97)
			Result.put (new_triple (4365,4462,4545),98)
			Result.put (new_triple (4365,4462,4546),99)
			Result.put (new_pair (4365,4463),100)
			Result.put (new_triple (4365,4463,4520),101)
			Result.put (new_triple (4365,4463,4521),102)
			Result.put (new_triple (4365,4463,4522),103)
			Result.put (new_triple (4365,4463,4523),104)
			Result.put (new_triple (4365,4463,4524),105)
			Result.put (new_triple (4365,4463,4525),106)
			Result.put (new_triple (4365,4463,4526),107)
			Result.put (new_triple (4365,4463,4527),108)
			Result.put (new_triple (4365,4463,4528),109)
			Result.put (new_triple (4365,4463,4529),110)
			Result.put (new_triple (4365,4463,4530),111)
			Result.put (new_triple (4365,4463,4531),112)
			Result.put (new_triple (4365,4463,4532),113)
			Result.put (new_triple (4365,4463,4533),114)
			Result.put (new_triple (4365,4463,4534),115)
			Result.put (new_triple (4365,4463,4535),116)
			Result.put (new_triple (4365,4463,4536),117)
			Result.put (new_triple (4365,4463,4537),118)
			Result.put (new_triple (4365,4463,4538),119)
			Result.put (new_triple (4365,4463,4539),120)
			Result.put (new_triple (4365,4463,4540),121)
			Result.put (new_triple (4365,4463,4541),122)
			Result.put (new_triple (4365,4463,4542),123)
			Result.put (new_triple (4365,4463,4543),124)
			Result.put (new_triple (4365,4463,4544),125)
			Result.put (new_triple (4365,4463,4545),126)
			Result.put (new_triple (4365,4463,4546),127)
			Result.put (new_pair (4365,4464),128)
			Result.put (new_triple (4365,4464,4520),129)
			Result.put (new_triple (4365,4464,4521),130)
			Result.put (new_triple (4365,4464,4522),131)
			Result.put (new_triple (4365,4464,4523),132)
			Result.put (new_triple (4365,4464,4524),133)
			Result.put (new_triple (4365,4464,4525),134)
			Result.put (new_triple (4365,4464,4526),135)
			Result.put (new_triple (4365,4464,4527),136)
			Result.put (new_triple (4365,4464,4528),137)
			Result.put (new_triple (4365,4464,4529),138)
			Result.put (new_triple (4365,4464,4530),139)
			Result.put (new_triple (4365,4464,4531),140)
			Result.put (new_triple (4365,4464,4532),141)
			Result.put (new_triple (4365,4464,4533),142)
			Result.put (new_triple (4365,4464,4534),143)
			Result.put (new_triple (4365,4464,4535),144)
			Result.put (new_triple (4365,4464,4536),145)
			Result.put (new_triple (4365,4464,4537),146)
			Result.put (new_triple (4365,4464,4538),147)
			Result.put (new_triple (4365,4464,4539),148)
			Result.put (new_triple (4365,4464,4540),149)
			Result.put (new_triple (4365,4464,4541),150)
			Result.put (new_triple (4365,4464,4542),151)
			Result.put (new_triple (4365,4464,4543),152)
			Result.put (new_triple (4365,4464,4544),153)
			Result.put (new_triple (4365,4464,4545),154)
			Result.put (new_triple (4365,4464,4546),155)
			Result.put (new_pair (4365,4465),156)
			Result.put (new_triple (4365,4465,4520),157)
			Result.put (new_triple (4365,4465,4521),158)
			Result.put (new_triple (4365,4465,4522),159)
			Result.put (new_triple (4365,4465,4523),160)
			Result.put (new_triple (4365,4465,4524),161)
			Result.put (new_triple (4365,4465,4525),162)
			Result.put (new_triple (4365,4465,4526),163)
			Result.put (new_triple (4365,4465,4527),164)
			Result.put (new_triple (4365,4465,4528),165)
			Result.put (new_triple (4365,4465,4529),166)
			Result.put (new_triple (4365,4465,4530),167)
			Result.put (new_triple (4365,4465,4531),168)
			Result.put (new_triple (4365,4465,4532),169)
			Result.put (new_triple (4365,4465,4533),170)
			Result.put (new_triple (4365,4465,4534),171)
			Result.put (new_triple (4365,4465,4535),172)
			Result.put (new_triple (4365,4465,4536),173)
			Result.put (new_triple (4365,4465,4537),174)
			Result.put (new_triple (4365,4465,4538),175)
			Result.put (new_triple (4365,4465,4539),176)
			Result.put (new_triple (4365,4465,4540),177)
			Result.put (new_triple (4365,4465,4541),178)
			Result.put (new_triple (4365,4465,4542),179)
			Result.put (new_triple (4365,4465,4543),180)
			Result.put (new_triple (4365,4465,4544),181)
			Result.put (new_triple (4365,4465,4545),182)
			Result.put (new_triple (4365,4465,4546),183)
			Result.put (new_pair (4365,4466),184)
			Result.put (new_triple (4365,4466,4520),185)
			Result.put (new_triple (4365,4466,4521),186)
			Result.put (new_triple (4365,4466,4522),187)
			Result.put (new_triple (4365,4466,4523),188)
			Result.put (new_triple (4365,4466,4524),189)
			Result.put (new_triple (4365,4466,4525),190)
			Result.put (new_triple (4365,4466,4526),191)
			Result.put (new_triple (4365,4466,4527),192)
			Result.put (new_triple (4365,4466,4528),193)
			Result.put (new_triple (4365,4466,4529),194)
			Result.put (new_triple (4365,4466,4530),195)
			Result.put (new_triple (4365,4466,4531),196)
			Result.put (new_triple (4365,4466,4532),197)
			Result.put (new_triple (4365,4466,4533),198)
			Result.put (new_triple (4365,4466,4534),199)
			Result.put (new_triple (4365,4466,4535),200)
			Result.put (new_triple (4365,4466,4536),201)
			Result.put (new_triple (4365,4466,4537),202)
			Result.put (new_triple (4365,4466,4538),203)
			Result.put (new_triple (4365,4466,4539),204)
			Result.put (new_triple (4365,4466,4540),205)
			Result.put (new_triple (4365,4466,4541),206)
			Result.put (new_triple (4365,4466,4542),207)
			Result.put (new_triple (4365,4466,4543),208)
			Result.put (new_triple (4365,4466,4544),209)
			Result.put (new_triple (4365,4466,4545),210)
			Result.put (new_triple (4365,4466,4546),211)
			Result.put (new_pair (4365,4467),212)
			Result.put (new_triple (4365,4467,4520),213)
			Result.put (new_triple (4365,4467,4521),214)
			Result.put (new_triple (4365,4467,4522),215)
			Result.put (new_triple (4365,4467,4523),216)
			Result.put (new_triple (4365,4467,4524),217)
			Result.put (new_triple (4365,4467,4525),218)
			Result.put (new_triple (4365,4467,4526),219)
			Result.put (new_triple (4365,4467,4527),220)
			Result.put (new_triple (4365,4467,4528),221)
			Result.put (new_triple (4365,4467,4529),222)
			Result.put (new_triple (4365,4467,4530),223)
			Result.put (new_triple (4365,4467,4531),224)
			Result.put (new_triple (4365,4467,4532),225)
			Result.put (new_triple (4365,4467,4533),226)
			Result.put (new_triple (4365,4467,4534),227)
			Result.put (new_triple (4365,4467,4535),228)
			Result.put (new_triple (4365,4467,4536),229)
			Result.put (new_triple (4365,4467,4537),230)
			Result.put (new_triple (4365,4467,4538),231)
			Result.put (new_triple (4365,4467,4539),232)
			Result.put (new_triple (4365,4467,4540),233)
			Result.put (new_triple (4365,4467,4541),234)
			Result.put (new_triple (4365,4467,4542),235)
			Result.put (new_triple (4365,4467,4543),236)
			Result.put (new_triple (4365,4467,4544),237)
			Result.put (new_triple (4365,4467,4545),238)
			Result.put (new_triple (4365,4467,4546),239)
			Result.put (new_pair (4365,4468),240)
			Result.put (new_triple (4365,4468,4520),241)
			Result.put (new_triple (4365,4468,4521),242)
			Result.put (new_triple (4365,4468,4522),243)
			Result.put (new_triple (4365,4468,4523),244)
			Result.put (new_triple (4365,4468,4524),245)
			Result.put (new_triple (4365,4468,4525),246)
			Result.put (new_triple (4365,4468,4526),247)
			Result.put (new_triple (4365,4468,4527),248)
			Result.put (new_triple (4365,4468,4528),249)
			Result.put (new_triple (4365,4468,4529),250)
			Result.put (new_triple (4365,4468,4530),251)
			Result.put (new_triple (4365,4468,4531),252)
			Result.put (new_triple (4365,4468,4532),253)
			Result.put (new_triple (4365,4468,4533),254)
			Result.put (new_triple (4365,4468,4534),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_204: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4365,4468,4535),0)
			Result.put (new_triple (4365,4468,4536),1)
			Result.put (new_triple (4365,4468,4537),2)
			Result.put (new_triple (4365,4468,4538),3)
			Result.put (new_triple (4365,4468,4539),4)
			Result.put (new_triple (4365,4468,4540),5)
			Result.put (new_triple (4365,4468,4541),6)
			Result.put (new_triple (4365,4468,4542),7)
			Result.put (new_triple (4365,4468,4543),8)
			Result.put (new_triple (4365,4468,4544),9)
			Result.put (new_triple (4365,4468,4545),10)
			Result.put (new_triple (4365,4468,4546),11)
			Result.put (new_pair (4365,4469),12)
			Result.put (new_triple (4365,4469,4520),13)
			Result.put (new_triple (4365,4469,4521),14)
			Result.put (new_triple (4365,4469,4522),15)
			Result.put (new_triple (4365,4469,4523),16)
			Result.put (new_triple (4365,4469,4524),17)
			Result.put (new_triple (4365,4469,4525),18)
			Result.put (new_triple (4365,4469,4526),19)
			Result.put (new_triple (4365,4469,4527),20)
			Result.put (new_triple (4365,4469,4528),21)
			Result.put (new_triple (4365,4469,4529),22)
			Result.put (new_triple (4365,4469,4530),23)
			Result.put (new_triple (4365,4469,4531),24)
			Result.put (new_triple (4365,4469,4532),25)
			Result.put (new_triple (4365,4469,4533),26)
			Result.put (new_triple (4365,4469,4534),27)
			Result.put (new_triple (4365,4469,4535),28)
			Result.put (new_triple (4365,4469,4536),29)
			Result.put (new_triple (4365,4469,4537),30)
			Result.put (new_triple (4365,4469,4538),31)
			Result.put (new_triple (4365,4469,4539),32)
			Result.put (new_triple (4365,4469,4540),33)
			Result.put (new_triple (4365,4469,4541),34)
			Result.put (new_triple (4365,4469,4542),35)
			Result.put (new_triple (4365,4469,4543),36)
			Result.put (new_triple (4365,4469,4544),37)
			Result.put (new_triple (4365,4469,4545),38)
			Result.put (new_triple (4365,4469,4546),39)
			Result.put (new_pair (4366,4449),40)
			Result.put (new_triple (4366,4449,4520),41)
			Result.put (new_triple (4366,4449,4521),42)
			Result.put (new_triple (4366,4449,4522),43)
			Result.put (new_triple (4366,4449,4523),44)
			Result.put (new_triple (4366,4449,4524),45)
			Result.put (new_triple (4366,4449,4525),46)
			Result.put (new_triple (4366,4449,4526),47)
			Result.put (new_triple (4366,4449,4527),48)
			Result.put (new_triple (4366,4449,4528),49)
			Result.put (new_triple (4366,4449,4529),50)
			Result.put (new_triple (4366,4449,4530),51)
			Result.put (new_triple (4366,4449,4531),52)
			Result.put (new_triple (4366,4449,4532),53)
			Result.put (new_triple (4366,4449,4533),54)
			Result.put (new_triple (4366,4449,4534),55)
			Result.put (new_triple (4366,4449,4535),56)
			Result.put (new_triple (4366,4449,4536),57)
			Result.put (new_triple (4366,4449,4537),58)
			Result.put (new_triple (4366,4449,4538),59)
			Result.put (new_triple (4366,4449,4539),60)
			Result.put (new_triple (4366,4449,4540),61)
			Result.put (new_triple (4366,4449,4541),62)
			Result.put (new_triple (4366,4449,4542),63)
			Result.put (new_triple (4366,4449,4543),64)
			Result.put (new_triple (4366,4449,4544),65)
			Result.put (new_triple (4366,4449,4545),66)
			Result.put (new_triple (4366,4449,4546),67)
			Result.put (new_pair (4366,4450),68)
			Result.put (new_triple (4366,4450,4520),69)
			Result.put (new_triple (4366,4450,4521),70)
			Result.put (new_triple (4366,4450,4522),71)
			Result.put (new_triple (4366,4450,4523),72)
			Result.put (new_triple (4366,4450,4524),73)
			Result.put (new_triple (4366,4450,4525),74)
			Result.put (new_triple (4366,4450,4526),75)
			Result.put (new_triple (4366,4450,4527),76)
			Result.put (new_triple (4366,4450,4528),77)
			Result.put (new_triple (4366,4450,4529),78)
			Result.put (new_triple (4366,4450,4530),79)
			Result.put (new_triple (4366,4450,4531),80)
			Result.put (new_triple (4366,4450,4532),81)
			Result.put (new_triple (4366,4450,4533),82)
			Result.put (new_triple (4366,4450,4534),83)
			Result.put (new_triple (4366,4450,4535),84)
			Result.put (new_triple (4366,4450,4536),85)
			Result.put (new_triple (4366,4450,4537),86)
			Result.put (new_triple (4366,4450,4538),87)
			Result.put (new_triple (4366,4450,4539),88)
			Result.put (new_triple (4366,4450,4540),89)
			Result.put (new_triple (4366,4450,4541),90)
			Result.put (new_triple (4366,4450,4542),91)
			Result.put (new_triple (4366,4450,4543),92)
			Result.put (new_triple (4366,4450,4544),93)
			Result.put (new_triple (4366,4450,4545),94)
			Result.put (new_triple (4366,4450,4546),95)
			Result.put (new_pair (4366,4451),96)
			Result.put (new_triple (4366,4451,4520),97)
			Result.put (new_triple (4366,4451,4521),98)
			Result.put (new_triple (4366,4451,4522),99)
			Result.put (new_triple (4366,4451,4523),100)
			Result.put (new_triple (4366,4451,4524),101)
			Result.put (new_triple (4366,4451,4525),102)
			Result.put (new_triple (4366,4451,4526),103)
			Result.put (new_triple (4366,4451,4527),104)
			Result.put (new_triple (4366,4451,4528),105)
			Result.put (new_triple (4366,4451,4529),106)
			Result.put (new_triple (4366,4451,4530),107)
			Result.put (new_triple (4366,4451,4531),108)
			Result.put (new_triple (4366,4451,4532),109)
			Result.put (new_triple (4366,4451,4533),110)
			Result.put (new_triple (4366,4451,4534),111)
			Result.put (new_triple (4366,4451,4535),112)
			Result.put (new_triple (4366,4451,4536),113)
			Result.put (new_triple (4366,4451,4537),114)
			Result.put (new_triple (4366,4451,4538),115)
			Result.put (new_triple (4366,4451,4539),116)
			Result.put (new_triple (4366,4451,4540),117)
			Result.put (new_triple (4366,4451,4541),118)
			Result.put (new_triple (4366,4451,4542),119)
			Result.put (new_triple (4366,4451,4543),120)
			Result.put (new_triple (4366,4451,4544),121)
			Result.put (new_triple (4366,4451,4545),122)
			Result.put (new_triple (4366,4451,4546),123)
			Result.put (new_pair (4366,4452),124)
			Result.put (new_triple (4366,4452,4520),125)
			Result.put (new_triple (4366,4452,4521),126)
			Result.put (new_triple (4366,4452,4522),127)
			Result.put (new_triple (4366,4452,4523),128)
			Result.put (new_triple (4366,4452,4524),129)
			Result.put (new_triple (4366,4452,4525),130)
			Result.put (new_triple (4366,4452,4526),131)
			Result.put (new_triple (4366,4452,4527),132)
			Result.put (new_triple (4366,4452,4528),133)
			Result.put (new_triple (4366,4452,4529),134)
			Result.put (new_triple (4366,4452,4530),135)
			Result.put (new_triple (4366,4452,4531),136)
			Result.put (new_triple (4366,4452,4532),137)
			Result.put (new_triple (4366,4452,4533),138)
			Result.put (new_triple (4366,4452,4534),139)
			Result.put (new_triple (4366,4452,4535),140)
			Result.put (new_triple (4366,4452,4536),141)
			Result.put (new_triple (4366,4452,4537),142)
			Result.put (new_triple (4366,4452,4538),143)
			Result.put (new_triple (4366,4452,4539),144)
			Result.put (new_triple (4366,4452,4540),145)
			Result.put (new_triple (4366,4452,4541),146)
			Result.put (new_triple (4366,4452,4542),147)
			Result.put (new_triple (4366,4452,4543),148)
			Result.put (new_triple (4366,4452,4544),149)
			Result.put (new_triple (4366,4452,4545),150)
			Result.put (new_triple (4366,4452,4546),151)
			Result.put (new_pair (4366,4453),152)
			Result.put (new_triple (4366,4453,4520),153)
			Result.put (new_triple (4366,4453,4521),154)
			Result.put (new_triple (4366,4453,4522),155)
			Result.put (new_triple (4366,4453,4523),156)
			Result.put (new_triple (4366,4453,4524),157)
			Result.put (new_triple (4366,4453,4525),158)
			Result.put (new_triple (4366,4453,4526),159)
			Result.put (new_triple (4366,4453,4527),160)
			Result.put (new_triple (4366,4453,4528),161)
			Result.put (new_triple (4366,4453,4529),162)
			Result.put (new_triple (4366,4453,4530),163)
			Result.put (new_triple (4366,4453,4531),164)
			Result.put (new_triple (4366,4453,4532),165)
			Result.put (new_triple (4366,4453,4533),166)
			Result.put (new_triple (4366,4453,4534),167)
			Result.put (new_triple (4366,4453,4535),168)
			Result.put (new_triple (4366,4453,4536),169)
			Result.put (new_triple (4366,4453,4537),170)
			Result.put (new_triple (4366,4453,4538),171)
			Result.put (new_triple (4366,4453,4539),172)
			Result.put (new_triple (4366,4453,4540),173)
			Result.put (new_triple (4366,4453,4541),174)
			Result.put (new_triple (4366,4453,4542),175)
			Result.put (new_triple (4366,4453,4543),176)
			Result.put (new_triple (4366,4453,4544),177)
			Result.put (new_triple (4366,4453,4545),178)
			Result.put (new_triple (4366,4453,4546),179)
			Result.put (new_pair (4366,4454),180)
			Result.put (new_triple (4366,4454,4520),181)
			Result.put (new_triple (4366,4454,4521),182)
			Result.put (new_triple (4366,4454,4522),183)
			Result.put (new_triple (4366,4454,4523),184)
			Result.put (new_triple (4366,4454,4524),185)
			Result.put (new_triple (4366,4454,4525),186)
			Result.put (new_triple (4366,4454,4526),187)
			Result.put (new_triple (4366,4454,4527),188)
			Result.put (new_triple (4366,4454,4528),189)
			Result.put (new_triple (4366,4454,4529),190)
			Result.put (new_triple (4366,4454,4530),191)
			Result.put (new_triple (4366,4454,4531),192)
			Result.put (new_triple (4366,4454,4532),193)
			Result.put (new_triple (4366,4454,4533),194)
			Result.put (new_triple (4366,4454,4534),195)
			Result.put (new_triple (4366,4454,4535),196)
			Result.put (new_triple (4366,4454,4536),197)
			Result.put (new_triple (4366,4454,4537),198)
			Result.put (new_triple (4366,4454,4538),199)
			Result.put (new_triple (4366,4454,4539),200)
			Result.put (new_triple (4366,4454,4540),201)
			Result.put (new_triple (4366,4454,4541),202)
			Result.put (new_triple (4366,4454,4542),203)
			Result.put (new_triple (4366,4454,4543),204)
			Result.put (new_triple (4366,4454,4544),205)
			Result.put (new_triple (4366,4454,4545),206)
			Result.put (new_triple (4366,4454,4546),207)
			Result.put (new_pair (4366,4455),208)
			Result.put (new_triple (4366,4455,4520),209)
			Result.put (new_triple (4366,4455,4521),210)
			Result.put (new_triple (4366,4455,4522),211)
			Result.put (new_triple (4366,4455,4523),212)
			Result.put (new_triple (4366,4455,4524),213)
			Result.put (new_triple (4366,4455,4525),214)
			Result.put (new_triple (4366,4455,4526),215)
			Result.put (new_triple (4366,4455,4527),216)
			Result.put (new_triple (4366,4455,4528),217)
			Result.put (new_triple (4366,4455,4529),218)
			Result.put (new_triple (4366,4455,4530),219)
			Result.put (new_triple (4366,4455,4531),220)
			Result.put (new_triple (4366,4455,4532),221)
			Result.put (new_triple (4366,4455,4533),222)
			Result.put (new_triple (4366,4455,4534),223)
			Result.put (new_triple (4366,4455,4535),224)
			Result.put (new_triple (4366,4455,4536),225)
			Result.put (new_triple (4366,4455,4537),226)
			Result.put (new_triple (4366,4455,4538),227)
			Result.put (new_triple (4366,4455,4539),228)
			Result.put (new_triple (4366,4455,4540),229)
			Result.put (new_triple (4366,4455,4541),230)
			Result.put (new_triple (4366,4455,4542),231)
			Result.put (new_triple (4366,4455,4543),232)
			Result.put (new_triple (4366,4455,4544),233)
			Result.put (new_triple (4366,4455,4545),234)
			Result.put (new_triple (4366,4455,4546),235)
			Result.put (new_pair (4366,4456),236)
			Result.put (new_triple (4366,4456,4520),237)
			Result.put (new_triple (4366,4456,4521),238)
			Result.put (new_triple (4366,4456,4522),239)
			Result.put (new_triple (4366,4456,4523),240)
			Result.put (new_triple (4366,4456,4524),241)
			Result.put (new_triple (4366,4456,4525),242)
			Result.put (new_triple (4366,4456,4526),243)
			Result.put (new_triple (4366,4456,4527),244)
			Result.put (new_triple (4366,4456,4528),245)
			Result.put (new_triple (4366,4456,4529),246)
			Result.put (new_triple (4366,4456,4530),247)
			Result.put (new_triple (4366,4456,4531),248)
			Result.put (new_triple (4366,4456,4532),249)
			Result.put (new_triple (4366,4456,4533),250)
			Result.put (new_triple (4366,4456,4534),251)
			Result.put (new_triple (4366,4456,4535),252)
			Result.put (new_triple (4366,4456,4536),253)
			Result.put (new_triple (4366,4456,4537),254)
			Result.put (new_triple (4366,4456,4538),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_205: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4366,4456,4539),0)
			Result.put (new_triple (4366,4456,4540),1)
			Result.put (new_triple (4366,4456,4541),2)
			Result.put (new_triple (4366,4456,4542),3)
			Result.put (new_triple (4366,4456,4543),4)
			Result.put (new_triple (4366,4456,4544),5)
			Result.put (new_triple (4366,4456,4545),6)
			Result.put (new_triple (4366,4456,4546),7)
			Result.put (new_pair (4366,4457),8)
			Result.put (new_triple (4366,4457,4520),9)
			Result.put (new_triple (4366,4457,4521),10)
			Result.put (new_triple (4366,4457,4522),11)
			Result.put (new_triple (4366,4457,4523),12)
			Result.put (new_triple (4366,4457,4524),13)
			Result.put (new_triple (4366,4457,4525),14)
			Result.put (new_triple (4366,4457,4526),15)
			Result.put (new_triple (4366,4457,4527),16)
			Result.put (new_triple (4366,4457,4528),17)
			Result.put (new_triple (4366,4457,4529),18)
			Result.put (new_triple (4366,4457,4530),19)
			Result.put (new_triple (4366,4457,4531),20)
			Result.put (new_triple (4366,4457,4532),21)
			Result.put (new_triple (4366,4457,4533),22)
			Result.put (new_triple (4366,4457,4534),23)
			Result.put (new_triple (4366,4457,4535),24)
			Result.put (new_triple (4366,4457,4536),25)
			Result.put (new_triple (4366,4457,4537),26)
			Result.put (new_triple (4366,4457,4538),27)
			Result.put (new_triple (4366,4457,4539),28)
			Result.put (new_triple (4366,4457,4540),29)
			Result.put (new_triple (4366,4457,4541),30)
			Result.put (new_triple (4366,4457,4542),31)
			Result.put (new_triple (4366,4457,4543),32)
			Result.put (new_triple (4366,4457,4544),33)
			Result.put (new_triple (4366,4457,4545),34)
			Result.put (new_triple (4366,4457,4546),35)
			Result.put (new_pair (4366,4458),36)
			Result.put (new_triple (4366,4458,4520),37)
			Result.put (new_triple (4366,4458,4521),38)
			Result.put (new_triple (4366,4458,4522),39)
			Result.put (new_triple (4366,4458,4523),40)
			Result.put (new_triple (4366,4458,4524),41)
			Result.put (new_triple (4366,4458,4525),42)
			Result.put (new_triple (4366,4458,4526),43)
			Result.put (new_triple (4366,4458,4527),44)
			Result.put (new_triple (4366,4458,4528),45)
			Result.put (new_triple (4366,4458,4529),46)
			Result.put (new_triple (4366,4458,4530),47)
			Result.put (new_triple (4366,4458,4531),48)
			Result.put (new_triple (4366,4458,4532),49)
			Result.put (new_triple (4366,4458,4533),50)
			Result.put (new_triple (4366,4458,4534),51)
			Result.put (new_triple (4366,4458,4535),52)
			Result.put (new_triple (4366,4458,4536),53)
			Result.put (new_triple (4366,4458,4537),54)
			Result.put (new_triple (4366,4458,4538),55)
			Result.put (new_triple (4366,4458,4539),56)
			Result.put (new_triple (4366,4458,4540),57)
			Result.put (new_triple (4366,4458,4541),58)
			Result.put (new_triple (4366,4458,4542),59)
			Result.put (new_triple (4366,4458,4543),60)
			Result.put (new_triple (4366,4458,4544),61)
			Result.put (new_triple (4366,4458,4545),62)
			Result.put (new_triple (4366,4458,4546),63)
			Result.put (new_pair (4366,4459),64)
			Result.put (new_triple (4366,4459,4520),65)
			Result.put (new_triple (4366,4459,4521),66)
			Result.put (new_triple (4366,4459,4522),67)
			Result.put (new_triple (4366,4459,4523),68)
			Result.put (new_triple (4366,4459,4524),69)
			Result.put (new_triple (4366,4459,4525),70)
			Result.put (new_triple (4366,4459,4526),71)
			Result.put (new_triple (4366,4459,4527),72)
			Result.put (new_triple (4366,4459,4528),73)
			Result.put (new_triple (4366,4459,4529),74)
			Result.put (new_triple (4366,4459,4530),75)
			Result.put (new_triple (4366,4459,4531),76)
			Result.put (new_triple (4366,4459,4532),77)
			Result.put (new_triple (4366,4459,4533),78)
			Result.put (new_triple (4366,4459,4534),79)
			Result.put (new_triple (4366,4459,4535),80)
			Result.put (new_triple (4366,4459,4536),81)
			Result.put (new_triple (4366,4459,4537),82)
			Result.put (new_triple (4366,4459,4538),83)
			Result.put (new_triple (4366,4459,4539),84)
			Result.put (new_triple (4366,4459,4540),85)
			Result.put (new_triple (4366,4459,4541),86)
			Result.put (new_triple (4366,4459,4542),87)
			Result.put (new_triple (4366,4459,4543),88)
			Result.put (new_triple (4366,4459,4544),89)
			Result.put (new_triple (4366,4459,4545),90)
			Result.put (new_triple (4366,4459,4546),91)
			Result.put (new_pair (4366,4460),92)
			Result.put (new_triple (4366,4460,4520),93)
			Result.put (new_triple (4366,4460,4521),94)
			Result.put (new_triple (4366,4460,4522),95)
			Result.put (new_triple (4366,4460,4523),96)
			Result.put (new_triple (4366,4460,4524),97)
			Result.put (new_triple (4366,4460,4525),98)
			Result.put (new_triple (4366,4460,4526),99)
			Result.put (new_triple (4366,4460,4527),100)
			Result.put (new_triple (4366,4460,4528),101)
			Result.put (new_triple (4366,4460,4529),102)
			Result.put (new_triple (4366,4460,4530),103)
			Result.put (new_triple (4366,4460,4531),104)
			Result.put (new_triple (4366,4460,4532),105)
			Result.put (new_triple (4366,4460,4533),106)
			Result.put (new_triple (4366,4460,4534),107)
			Result.put (new_triple (4366,4460,4535),108)
			Result.put (new_triple (4366,4460,4536),109)
			Result.put (new_triple (4366,4460,4537),110)
			Result.put (new_triple (4366,4460,4538),111)
			Result.put (new_triple (4366,4460,4539),112)
			Result.put (new_triple (4366,4460,4540),113)
			Result.put (new_triple (4366,4460,4541),114)
			Result.put (new_triple (4366,4460,4542),115)
			Result.put (new_triple (4366,4460,4543),116)
			Result.put (new_triple (4366,4460,4544),117)
			Result.put (new_triple (4366,4460,4545),118)
			Result.put (new_triple (4366,4460,4546),119)
			Result.put (new_pair (4366,4461),120)
			Result.put (new_triple (4366,4461,4520),121)
			Result.put (new_triple (4366,4461,4521),122)
			Result.put (new_triple (4366,4461,4522),123)
			Result.put (new_triple (4366,4461,4523),124)
			Result.put (new_triple (4366,4461,4524),125)
			Result.put (new_triple (4366,4461,4525),126)
			Result.put (new_triple (4366,4461,4526),127)
			Result.put (new_triple (4366,4461,4527),128)
			Result.put (new_triple (4366,4461,4528),129)
			Result.put (new_triple (4366,4461,4529),130)
			Result.put (new_triple (4366,4461,4530),131)
			Result.put (new_triple (4366,4461,4531),132)
			Result.put (new_triple (4366,4461,4532),133)
			Result.put (new_triple (4366,4461,4533),134)
			Result.put (new_triple (4366,4461,4534),135)
			Result.put (new_triple (4366,4461,4535),136)
			Result.put (new_triple (4366,4461,4536),137)
			Result.put (new_triple (4366,4461,4537),138)
			Result.put (new_triple (4366,4461,4538),139)
			Result.put (new_triple (4366,4461,4539),140)
			Result.put (new_triple (4366,4461,4540),141)
			Result.put (new_triple (4366,4461,4541),142)
			Result.put (new_triple (4366,4461,4542),143)
			Result.put (new_triple (4366,4461,4543),144)
			Result.put (new_triple (4366,4461,4544),145)
			Result.put (new_triple (4366,4461,4545),146)
			Result.put (new_triple (4366,4461,4546),147)
			Result.put (new_pair (4366,4462),148)
			Result.put (new_triple (4366,4462,4520),149)
			Result.put (new_triple (4366,4462,4521),150)
			Result.put (new_triple (4366,4462,4522),151)
			Result.put (new_triple (4366,4462,4523),152)
			Result.put (new_triple (4366,4462,4524),153)
			Result.put (new_triple (4366,4462,4525),154)
			Result.put (new_triple (4366,4462,4526),155)
			Result.put (new_triple (4366,4462,4527),156)
			Result.put (new_triple (4366,4462,4528),157)
			Result.put (new_triple (4366,4462,4529),158)
			Result.put (new_triple (4366,4462,4530),159)
			Result.put (new_triple (4366,4462,4531),160)
			Result.put (new_triple (4366,4462,4532),161)
			Result.put (new_triple (4366,4462,4533),162)
			Result.put (new_triple (4366,4462,4534),163)
			Result.put (new_triple (4366,4462,4535),164)
			Result.put (new_triple (4366,4462,4536),165)
			Result.put (new_triple (4366,4462,4537),166)
			Result.put (new_triple (4366,4462,4538),167)
			Result.put (new_triple (4366,4462,4539),168)
			Result.put (new_triple (4366,4462,4540),169)
			Result.put (new_triple (4366,4462,4541),170)
			Result.put (new_triple (4366,4462,4542),171)
			Result.put (new_triple (4366,4462,4543),172)
			Result.put (new_triple (4366,4462,4544),173)
			Result.put (new_triple (4366,4462,4545),174)
			Result.put (new_triple (4366,4462,4546),175)
			Result.put (new_pair (4366,4463),176)
			Result.put (new_triple (4366,4463,4520),177)
			Result.put (new_triple (4366,4463,4521),178)
			Result.put (new_triple (4366,4463,4522),179)
			Result.put (new_triple (4366,4463,4523),180)
			Result.put (new_triple (4366,4463,4524),181)
			Result.put (new_triple (4366,4463,4525),182)
			Result.put (new_triple (4366,4463,4526),183)
			Result.put (new_triple (4366,4463,4527),184)
			Result.put (new_triple (4366,4463,4528),185)
			Result.put (new_triple (4366,4463,4529),186)
			Result.put (new_triple (4366,4463,4530),187)
			Result.put (new_triple (4366,4463,4531),188)
			Result.put (new_triple (4366,4463,4532),189)
			Result.put (new_triple (4366,4463,4533),190)
			Result.put (new_triple (4366,4463,4534),191)
			Result.put (new_triple (4366,4463,4535),192)
			Result.put (new_triple (4366,4463,4536),193)
			Result.put (new_triple (4366,4463,4537),194)
			Result.put (new_triple (4366,4463,4538),195)
			Result.put (new_triple (4366,4463,4539),196)
			Result.put (new_triple (4366,4463,4540),197)
			Result.put (new_triple (4366,4463,4541),198)
			Result.put (new_triple (4366,4463,4542),199)
			Result.put (new_triple (4366,4463,4543),200)
			Result.put (new_triple (4366,4463,4544),201)
			Result.put (new_triple (4366,4463,4545),202)
			Result.put (new_triple (4366,4463,4546),203)
			Result.put (new_pair (4366,4464),204)
			Result.put (new_triple (4366,4464,4520),205)
			Result.put (new_triple (4366,4464,4521),206)
			Result.put (new_triple (4366,4464,4522),207)
			Result.put (new_triple (4366,4464,4523),208)
			Result.put (new_triple (4366,4464,4524),209)
			Result.put (new_triple (4366,4464,4525),210)
			Result.put (new_triple (4366,4464,4526),211)
			Result.put (new_triple (4366,4464,4527),212)
			Result.put (new_triple (4366,4464,4528),213)
			Result.put (new_triple (4366,4464,4529),214)
			Result.put (new_triple (4366,4464,4530),215)
			Result.put (new_triple (4366,4464,4531),216)
			Result.put (new_triple (4366,4464,4532),217)
			Result.put (new_triple (4366,4464,4533),218)
			Result.put (new_triple (4366,4464,4534),219)
			Result.put (new_triple (4366,4464,4535),220)
			Result.put (new_triple (4366,4464,4536),221)
			Result.put (new_triple (4366,4464,4537),222)
			Result.put (new_triple (4366,4464,4538),223)
			Result.put (new_triple (4366,4464,4539),224)
			Result.put (new_triple (4366,4464,4540),225)
			Result.put (new_triple (4366,4464,4541),226)
			Result.put (new_triple (4366,4464,4542),227)
			Result.put (new_triple (4366,4464,4543),228)
			Result.put (new_triple (4366,4464,4544),229)
			Result.put (new_triple (4366,4464,4545),230)
			Result.put (new_triple (4366,4464,4546),231)
			Result.put (new_pair (4366,4465),232)
			Result.put (new_triple (4366,4465,4520),233)
			Result.put (new_triple (4366,4465,4521),234)
			Result.put (new_triple (4366,4465,4522),235)
			Result.put (new_triple (4366,4465,4523),236)
			Result.put (new_triple (4366,4465,4524),237)
			Result.put (new_triple (4366,4465,4525),238)
			Result.put (new_triple (4366,4465,4526),239)
			Result.put (new_triple (4366,4465,4527),240)
			Result.put (new_triple (4366,4465,4528),241)
			Result.put (new_triple (4366,4465,4529),242)
			Result.put (new_triple (4366,4465,4530),243)
			Result.put (new_triple (4366,4465,4531),244)
			Result.put (new_triple (4366,4465,4532),245)
			Result.put (new_triple (4366,4465,4533),246)
			Result.put (new_triple (4366,4465,4534),247)
			Result.put (new_triple (4366,4465,4535),248)
			Result.put (new_triple (4366,4465,4536),249)
			Result.put (new_triple (4366,4465,4537),250)
			Result.put (new_triple (4366,4465,4538),251)
			Result.put (new_triple (4366,4465,4539),252)
			Result.put (new_triple (4366,4465,4540),253)
			Result.put (new_triple (4366,4465,4541),254)
			Result.put (new_triple (4366,4465,4542),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_206: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4366,4465,4543),0)
			Result.put (new_triple (4366,4465,4544),1)
			Result.put (new_triple (4366,4465,4545),2)
			Result.put (new_triple (4366,4465,4546),3)
			Result.put (new_pair (4366,4466),4)
			Result.put (new_triple (4366,4466,4520),5)
			Result.put (new_triple (4366,4466,4521),6)
			Result.put (new_triple (4366,4466,4522),7)
			Result.put (new_triple (4366,4466,4523),8)
			Result.put (new_triple (4366,4466,4524),9)
			Result.put (new_triple (4366,4466,4525),10)
			Result.put (new_triple (4366,4466,4526),11)
			Result.put (new_triple (4366,4466,4527),12)
			Result.put (new_triple (4366,4466,4528),13)
			Result.put (new_triple (4366,4466,4529),14)
			Result.put (new_triple (4366,4466,4530),15)
			Result.put (new_triple (4366,4466,4531),16)
			Result.put (new_triple (4366,4466,4532),17)
			Result.put (new_triple (4366,4466,4533),18)
			Result.put (new_triple (4366,4466,4534),19)
			Result.put (new_triple (4366,4466,4535),20)
			Result.put (new_triple (4366,4466,4536),21)
			Result.put (new_triple (4366,4466,4537),22)
			Result.put (new_triple (4366,4466,4538),23)
			Result.put (new_triple (4366,4466,4539),24)
			Result.put (new_triple (4366,4466,4540),25)
			Result.put (new_triple (4366,4466,4541),26)
			Result.put (new_triple (4366,4466,4542),27)
			Result.put (new_triple (4366,4466,4543),28)
			Result.put (new_triple (4366,4466,4544),29)
			Result.put (new_triple (4366,4466,4545),30)
			Result.put (new_triple (4366,4466,4546),31)
			Result.put (new_pair (4366,4467),32)
			Result.put (new_triple (4366,4467,4520),33)
			Result.put (new_triple (4366,4467,4521),34)
			Result.put (new_triple (4366,4467,4522),35)
			Result.put (new_triple (4366,4467,4523),36)
			Result.put (new_triple (4366,4467,4524),37)
			Result.put (new_triple (4366,4467,4525),38)
			Result.put (new_triple (4366,4467,4526),39)
			Result.put (new_triple (4366,4467,4527),40)
			Result.put (new_triple (4366,4467,4528),41)
			Result.put (new_triple (4366,4467,4529),42)
			Result.put (new_triple (4366,4467,4530),43)
			Result.put (new_triple (4366,4467,4531),44)
			Result.put (new_triple (4366,4467,4532),45)
			Result.put (new_triple (4366,4467,4533),46)
			Result.put (new_triple (4366,4467,4534),47)
			Result.put (new_triple (4366,4467,4535),48)
			Result.put (new_triple (4366,4467,4536),49)
			Result.put (new_triple (4366,4467,4537),50)
			Result.put (new_triple (4366,4467,4538),51)
			Result.put (new_triple (4366,4467,4539),52)
			Result.put (new_triple (4366,4467,4540),53)
			Result.put (new_triple (4366,4467,4541),54)
			Result.put (new_triple (4366,4467,4542),55)
			Result.put (new_triple (4366,4467,4543),56)
			Result.put (new_triple (4366,4467,4544),57)
			Result.put (new_triple (4366,4467,4545),58)
			Result.put (new_triple (4366,4467,4546),59)
			Result.put (new_pair (4366,4468),60)
			Result.put (new_triple (4366,4468,4520),61)
			Result.put (new_triple (4366,4468,4521),62)
			Result.put (new_triple (4366,4468,4522),63)
			Result.put (new_triple (4366,4468,4523),64)
			Result.put (new_triple (4366,4468,4524),65)
			Result.put (new_triple (4366,4468,4525),66)
			Result.put (new_triple (4366,4468,4526),67)
			Result.put (new_triple (4366,4468,4527),68)
			Result.put (new_triple (4366,4468,4528),69)
			Result.put (new_triple (4366,4468,4529),70)
			Result.put (new_triple (4366,4468,4530),71)
			Result.put (new_triple (4366,4468,4531),72)
			Result.put (new_triple (4366,4468,4532),73)
			Result.put (new_triple (4366,4468,4533),74)
			Result.put (new_triple (4366,4468,4534),75)
			Result.put (new_triple (4366,4468,4535),76)
			Result.put (new_triple (4366,4468,4536),77)
			Result.put (new_triple (4366,4468,4537),78)
			Result.put (new_triple (4366,4468,4538),79)
			Result.put (new_triple (4366,4468,4539),80)
			Result.put (new_triple (4366,4468,4540),81)
			Result.put (new_triple (4366,4468,4541),82)
			Result.put (new_triple (4366,4468,4542),83)
			Result.put (new_triple (4366,4468,4543),84)
			Result.put (new_triple (4366,4468,4544),85)
			Result.put (new_triple (4366,4468,4545),86)
			Result.put (new_triple (4366,4468,4546),87)
			Result.put (new_pair (4366,4469),88)
			Result.put (new_triple (4366,4469,4520),89)
			Result.put (new_triple (4366,4469,4521),90)
			Result.put (new_triple (4366,4469,4522),91)
			Result.put (new_triple (4366,4469,4523),92)
			Result.put (new_triple (4366,4469,4524),93)
			Result.put (new_triple (4366,4469,4525),94)
			Result.put (new_triple (4366,4469,4526),95)
			Result.put (new_triple (4366,4469,4527),96)
			Result.put (new_triple (4366,4469,4528),97)
			Result.put (new_triple (4366,4469,4529),98)
			Result.put (new_triple (4366,4469,4530),99)
			Result.put (new_triple (4366,4469,4531),100)
			Result.put (new_triple (4366,4469,4532),101)
			Result.put (new_triple (4366,4469,4533),102)
			Result.put (new_triple (4366,4469,4534),103)
			Result.put (new_triple (4366,4469,4535),104)
			Result.put (new_triple (4366,4469,4536),105)
			Result.put (new_triple (4366,4469,4537),106)
			Result.put (new_triple (4366,4469,4538),107)
			Result.put (new_triple (4366,4469,4539),108)
			Result.put (new_triple (4366,4469,4540),109)
			Result.put (new_triple (4366,4469,4541),110)
			Result.put (new_triple (4366,4469,4542),111)
			Result.put (new_triple (4366,4469,4543),112)
			Result.put (new_triple (4366,4469,4544),113)
			Result.put (new_triple (4366,4469,4545),114)
			Result.put (new_triple (4366,4469,4546),115)
			Result.put (new_pair (4367,4449),116)
			Result.put (new_triple (4367,4449,4520),117)
			Result.put (new_triple (4367,4449,4521),118)
			Result.put (new_triple (4367,4449,4522),119)
			Result.put (new_triple (4367,4449,4523),120)
			Result.put (new_triple (4367,4449,4524),121)
			Result.put (new_triple (4367,4449,4525),122)
			Result.put (new_triple (4367,4449,4526),123)
			Result.put (new_triple (4367,4449,4527),124)
			Result.put (new_triple (4367,4449,4528),125)
			Result.put (new_triple (4367,4449,4529),126)
			Result.put (new_triple (4367,4449,4530),127)
			Result.put (new_triple (4367,4449,4531),128)
			Result.put (new_triple (4367,4449,4532),129)
			Result.put (new_triple (4367,4449,4533),130)
			Result.put (new_triple (4367,4449,4534),131)
			Result.put (new_triple (4367,4449,4535),132)
			Result.put (new_triple (4367,4449,4536),133)
			Result.put (new_triple (4367,4449,4537),134)
			Result.put (new_triple (4367,4449,4538),135)
			Result.put (new_triple (4367,4449,4539),136)
			Result.put (new_triple (4367,4449,4540),137)
			Result.put (new_triple (4367,4449,4541),138)
			Result.put (new_triple (4367,4449,4542),139)
			Result.put (new_triple (4367,4449,4543),140)
			Result.put (new_triple (4367,4449,4544),141)
			Result.put (new_triple (4367,4449,4545),142)
			Result.put (new_triple (4367,4449,4546),143)
			Result.put (new_pair (4367,4450),144)
			Result.put (new_triple (4367,4450,4520),145)
			Result.put (new_triple (4367,4450,4521),146)
			Result.put (new_triple (4367,4450,4522),147)
			Result.put (new_triple (4367,4450,4523),148)
			Result.put (new_triple (4367,4450,4524),149)
			Result.put (new_triple (4367,4450,4525),150)
			Result.put (new_triple (4367,4450,4526),151)
			Result.put (new_triple (4367,4450,4527),152)
			Result.put (new_triple (4367,4450,4528),153)
			Result.put (new_triple (4367,4450,4529),154)
			Result.put (new_triple (4367,4450,4530),155)
			Result.put (new_triple (4367,4450,4531),156)
			Result.put (new_triple (4367,4450,4532),157)
			Result.put (new_triple (4367,4450,4533),158)
			Result.put (new_triple (4367,4450,4534),159)
			Result.put (new_triple (4367,4450,4535),160)
			Result.put (new_triple (4367,4450,4536),161)
			Result.put (new_triple (4367,4450,4537),162)
			Result.put (new_triple (4367,4450,4538),163)
			Result.put (new_triple (4367,4450,4539),164)
			Result.put (new_triple (4367,4450,4540),165)
			Result.put (new_triple (4367,4450,4541),166)
			Result.put (new_triple (4367,4450,4542),167)
			Result.put (new_triple (4367,4450,4543),168)
			Result.put (new_triple (4367,4450,4544),169)
			Result.put (new_triple (4367,4450,4545),170)
			Result.put (new_triple (4367,4450,4546),171)
			Result.put (new_pair (4367,4451),172)
			Result.put (new_triple (4367,4451,4520),173)
			Result.put (new_triple (4367,4451,4521),174)
			Result.put (new_triple (4367,4451,4522),175)
			Result.put (new_triple (4367,4451,4523),176)
			Result.put (new_triple (4367,4451,4524),177)
			Result.put (new_triple (4367,4451,4525),178)
			Result.put (new_triple (4367,4451,4526),179)
			Result.put (new_triple (4367,4451,4527),180)
			Result.put (new_triple (4367,4451,4528),181)
			Result.put (new_triple (4367,4451,4529),182)
			Result.put (new_triple (4367,4451,4530),183)
			Result.put (new_triple (4367,4451,4531),184)
			Result.put (new_triple (4367,4451,4532),185)
			Result.put (new_triple (4367,4451,4533),186)
			Result.put (new_triple (4367,4451,4534),187)
			Result.put (new_triple (4367,4451,4535),188)
			Result.put (new_triple (4367,4451,4536),189)
			Result.put (new_triple (4367,4451,4537),190)
			Result.put (new_triple (4367,4451,4538),191)
			Result.put (new_triple (4367,4451,4539),192)
			Result.put (new_triple (4367,4451,4540),193)
			Result.put (new_triple (4367,4451,4541),194)
			Result.put (new_triple (4367,4451,4542),195)
			Result.put (new_triple (4367,4451,4543),196)
			Result.put (new_triple (4367,4451,4544),197)
			Result.put (new_triple (4367,4451,4545),198)
			Result.put (new_triple (4367,4451,4546),199)
			Result.put (new_pair (4367,4452),200)
			Result.put (new_triple (4367,4452,4520),201)
			Result.put (new_triple (4367,4452,4521),202)
			Result.put (new_triple (4367,4452,4522),203)
			Result.put (new_triple (4367,4452,4523),204)
			Result.put (new_triple (4367,4452,4524),205)
			Result.put (new_triple (4367,4452,4525),206)
			Result.put (new_triple (4367,4452,4526),207)
			Result.put (new_triple (4367,4452,4527),208)
			Result.put (new_triple (4367,4452,4528),209)
			Result.put (new_triple (4367,4452,4529),210)
			Result.put (new_triple (4367,4452,4530),211)
			Result.put (new_triple (4367,4452,4531),212)
			Result.put (new_triple (4367,4452,4532),213)
			Result.put (new_triple (4367,4452,4533),214)
			Result.put (new_triple (4367,4452,4534),215)
			Result.put (new_triple (4367,4452,4535),216)
			Result.put (new_triple (4367,4452,4536),217)
			Result.put (new_triple (4367,4452,4537),218)
			Result.put (new_triple (4367,4452,4538),219)
			Result.put (new_triple (4367,4452,4539),220)
			Result.put (new_triple (4367,4452,4540),221)
			Result.put (new_triple (4367,4452,4541),222)
			Result.put (new_triple (4367,4452,4542),223)
			Result.put (new_triple (4367,4452,4543),224)
			Result.put (new_triple (4367,4452,4544),225)
			Result.put (new_triple (4367,4452,4545),226)
			Result.put (new_triple (4367,4452,4546),227)
			Result.put (new_pair (4367,4453),228)
			Result.put (new_triple (4367,4453,4520),229)
			Result.put (new_triple (4367,4453,4521),230)
			Result.put (new_triple (4367,4453,4522),231)
			Result.put (new_triple (4367,4453,4523),232)
			Result.put (new_triple (4367,4453,4524),233)
			Result.put (new_triple (4367,4453,4525),234)
			Result.put (new_triple (4367,4453,4526),235)
			Result.put (new_triple (4367,4453,4527),236)
			Result.put (new_triple (4367,4453,4528),237)
			Result.put (new_triple (4367,4453,4529),238)
			Result.put (new_triple (4367,4453,4530),239)
			Result.put (new_triple (4367,4453,4531),240)
			Result.put (new_triple (4367,4453,4532),241)
			Result.put (new_triple (4367,4453,4533),242)
			Result.put (new_triple (4367,4453,4534),243)
			Result.put (new_triple (4367,4453,4535),244)
			Result.put (new_triple (4367,4453,4536),245)
			Result.put (new_triple (4367,4453,4537),246)
			Result.put (new_triple (4367,4453,4538),247)
			Result.put (new_triple (4367,4453,4539),248)
			Result.put (new_triple (4367,4453,4540),249)
			Result.put (new_triple (4367,4453,4541),250)
			Result.put (new_triple (4367,4453,4542),251)
			Result.put (new_triple (4367,4453,4543),252)
			Result.put (new_triple (4367,4453,4544),253)
			Result.put (new_triple (4367,4453,4545),254)
			Result.put (new_triple (4367,4453,4546),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_207: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (4367,4454),0)
			Result.put (new_triple (4367,4454,4520),1)
			Result.put (new_triple (4367,4454,4521),2)
			Result.put (new_triple (4367,4454,4522),3)
			Result.put (new_triple (4367,4454,4523),4)
			Result.put (new_triple (4367,4454,4524),5)
			Result.put (new_triple (4367,4454,4525),6)
			Result.put (new_triple (4367,4454,4526),7)
			Result.put (new_triple (4367,4454,4527),8)
			Result.put (new_triple (4367,4454,4528),9)
			Result.put (new_triple (4367,4454,4529),10)
			Result.put (new_triple (4367,4454,4530),11)
			Result.put (new_triple (4367,4454,4531),12)
			Result.put (new_triple (4367,4454,4532),13)
			Result.put (new_triple (4367,4454,4533),14)
			Result.put (new_triple (4367,4454,4534),15)
			Result.put (new_triple (4367,4454,4535),16)
			Result.put (new_triple (4367,4454,4536),17)
			Result.put (new_triple (4367,4454,4537),18)
			Result.put (new_triple (4367,4454,4538),19)
			Result.put (new_triple (4367,4454,4539),20)
			Result.put (new_triple (4367,4454,4540),21)
			Result.put (new_triple (4367,4454,4541),22)
			Result.put (new_triple (4367,4454,4542),23)
			Result.put (new_triple (4367,4454,4543),24)
			Result.put (new_triple (4367,4454,4544),25)
			Result.put (new_triple (4367,4454,4545),26)
			Result.put (new_triple (4367,4454,4546),27)
			Result.put (new_pair (4367,4455),28)
			Result.put (new_triple (4367,4455,4520),29)
			Result.put (new_triple (4367,4455,4521),30)
			Result.put (new_triple (4367,4455,4522),31)
			Result.put (new_triple (4367,4455,4523),32)
			Result.put (new_triple (4367,4455,4524),33)
			Result.put (new_triple (4367,4455,4525),34)
			Result.put (new_triple (4367,4455,4526),35)
			Result.put (new_triple (4367,4455,4527),36)
			Result.put (new_triple (4367,4455,4528),37)
			Result.put (new_triple (4367,4455,4529),38)
			Result.put (new_triple (4367,4455,4530),39)
			Result.put (new_triple (4367,4455,4531),40)
			Result.put (new_triple (4367,4455,4532),41)
			Result.put (new_triple (4367,4455,4533),42)
			Result.put (new_triple (4367,4455,4534),43)
			Result.put (new_triple (4367,4455,4535),44)
			Result.put (new_triple (4367,4455,4536),45)
			Result.put (new_triple (4367,4455,4537),46)
			Result.put (new_triple (4367,4455,4538),47)
			Result.put (new_triple (4367,4455,4539),48)
			Result.put (new_triple (4367,4455,4540),49)
			Result.put (new_triple (4367,4455,4541),50)
			Result.put (new_triple (4367,4455,4542),51)
			Result.put (new_triple (4367,4455,4543),52)
			Result.put (new_triple (4367,4455,4544),53)
			Result.put (new_triple (4367,4455,4545),54)
			Result.put (new_triple (4367,4455,4546),55)
			Result.put (new_pair (4367,4456),56)
			Result.put (new_triple (4367,4456,4520),57)
			Result.put (new_triple (4367,4456,4521),58)
			Result.put (new_triple (4367,4456,4522),59)
			Result.put (new_triple (4367,4456,4523),60)
			Result.put (new_triple (4367,4456,4524),61)
			Result.put (new_triple (4367,4456,4525),62)
			Result.put (new_triple (4367,4456,4526),63)
			Result.put (new_triple (4367,4456,4527),64)
			Result.put (new_triple (4367,4456,4528),65)
			Result.put (new_triple (4367,4456,4529),66)
			Result.put (new_triple (4367,4456,4530),67)
			Result.put (new_triple (4367,4456,4531),68)
			Result.put (new_triple (4367,4456,4532),69)
			Result.put (new_triple (4367,4456,4533),70)
			Result.put (new_triple (4367,4456,4534),71)
			Result.put (new_triple (4367,4456,4535),72)
			Result.put (new_triple (4367,4456,4536),73)
			Result.put (new_triple (4367,4456,4537),74)
			Result.put (new_triple (4367,4456,4538),75)
			Result.put (new_triple (4367,4456,4539),76)
			Result.put (new_triple (4367,4456,4540),77)
			Result.put (new_triple (4367,4456,4541),78)
			Result.put (new_triple (4367,4456,4542),79)
			Result.put (new_triple (4367,4456,4543),80)
			Result.put (new_triple (4367,4456,4544),81)
			Result.put (new_triple (4367,4456,4545),82)
			Result.put (new_triple (4367,4456,4546),83)
			Result.put (new_pair (4367,4457),84)
			Result.put (new_triple (4367,4457,4520),85)
			Result.put (new_triple (4367,4457,4521),86)
			Result.put (new_triple (4367,4457,4522),87)
			Result.put (new_triple (4367,4457,4523),88)
			Result.put (new_triple (4367,4457,4524),89)
			Result.put (new_triple (4367,4457,4525),90)
			Result.put (new_triple (4367,4457,4526),91)
			Result.put (new_triple (4367,4457,4527),92)
			Result.put (new_triple (4367,4457,4528),93)
			Result.put (new_triple (4367,4457,4529),94)
			Result.put (new_triple (4367,4457,4530),95)
			Result.put (new_triple (4367,4457,4531),96)
			Result.put (new_triple (4367,4457,4532),97)
			Result.put (new_triple (4367,4457,4533),98)
			Result.put (new_triple (4367,4457,4534),99)
			Result.put (new_triple (4367,4457,4535),100)
			Result.put (new_triple (4367,4457,4536),101)
			Result.put (new_triple (4367,4457,4537),102)
			Result.put (new_triple (4367,4457,4538),103)
			Result.put (new_triple (4367,4457,4539),104)
			Result.put (new_triple (4367,4457,4540),105)
			Result.put (new_triple (4367,4457,4541),106)
			Result.put (new_triple (4367,4457,4542),107)
			Result.put (new_triple (4367,4457,4543),108)
			Result.put (new_triple (4367,4457,4544),109)
			Result.put (new_triple (4367,4457,4545),110)
			Result.put (new_triple (4367,4457,4546),111)
			Result.put (new_pair (4367,4458),112)
			Result.put (new_triple (4367,4458,4520),113)
			Result.put (new_triple (4367,4458,4521),114)
			Result.put (new_triple (4367,4458,4522),115)
			Result.put (new_triple (4367,4458,4523),116)
			Result.put (new_triple (4367,4458,4524),117)
			Result.put (new_triple (4367,4458,4525),118)
			Result.put (new_triple (4367,4458,4526),119)
			Result.put (new_triple (4367,4458,4527),120)
			Result.put (new_triple (4367,4458,4528),121)
			Result.put (new_triple (4367,4458,4529),122)
			Result.put (new_triple (4367,4458,4530),123)
			Result.put (new_triple (4367,4458,4531),124)
			Result.put (new_triple (4367,4458,4532),125)
			Result.put (new_triple (4367,4458,4533),126)
			Result.put (new_triple (4367,4458,4534),127)
			Result.put (new_triple (4367,4458,4535),128)
			Result.put (new_triple (4367,4458,4536),129)
			Result.put (new_triple (4367,4458,4537),130)
			Result.put (new_triple (4367,4458,4538),131)
			Result.put (new_triple (4367,4458,4539),132)
			Result.put (new_triple (4367,4458,4540),133)
			Result.put (new_triple (4367,4458,4541),134)
			Result.put (new_triple (4367,4458,4542),135)
			Result.put (new_triple (4367,4458,4543),136)
			Result.put (new_triple (4367,4458,4544),137)
			Result.put (new_triple (4367,4458,4545),138)
			Result.put (new_triple (4367,4458,4546),139)
			Result.put (new_pair (4367,4459),140)
			Result.put (new_triple (4367,4459,4520),141)
			Result.put (new_triple (4367,4459,4521),142)
			Result.put (new_triple (4367,4459,4522),143)
			Result.put (new_triple (4367,4459,4523),144)
			Result.put (new_triple (4367,4459,4524),145)
			Result.put (new_triple (4367,4459,4525),146)
			Result.put (new_triple (4367,4459,4526),147)
			Result.put (new_triple (4367,4459,4527),148)
			Result.put (new_triple (4367,4459,4528),149)
			Result.put (new_triple (4367,4459,4529),150)
			Result.put (new_triple (4367,4459,4530),151)
			Result.put (new_triple (4367,4459,4531),152)
			Result.put (new_triple (4367,4459,4532),153)
			Result.put (new_triple (4367,4459,4533),154)
			Result.put (new_triple (4367,4459,4534),155)
			Result.put (new_triple (4367,4459,4535),156)
			Result.put (new_triple (4367,4459,4536),157)
			Result.put (new_triple (4367,4459,4537),158)
			Result.put (new_triple (4367,4459,4538),159)
			Result.put (new_triple (4367,4459,4539),160)
			Result.put (new_triple (4367,4459,4540),161)
			Result.put (new_triple (4367,4459,4541),162)
			Result.put (new_triple (4367,4459,4542),163)
			Result.put (new_triple (4367,4459,4543),164)
			Result.put (new_triple (4367,4459,4544),165)
			Result.put (new_triple (4367,4459,4545),166)
			Result.put (new_triple (4367,4459,4546),167)
			Result.put (new_pair (4367,4460),168)
			Result.put (new_triple (4367,4460,4520),169)
			Result.put (new_triple (4367,4460,4521),170)
			Result.put (new_triple (4367,4460,4522),171)
			Result.put (new_triple (4367,4460,4523),172)
			Result.put (new_triple (4367,4460,4524),173)
			Result.put (new_triple (4367,4460,4525),174)
			Result.put (new_triple (4367,4460,4526),175)
			Result.put (new_triple (4367,4460,4527),176)
			Result.put (new_triple (4367,4460,4528),177)
			Result.put (new_triple (4367,4460,4529),178)
			Result.put (new_triple (4367,4460,4530),179)
			Result.put (new_triple (4367,4460,4531),180)
			Result.put (new_triple (4367,4460,4532),181)
			Result.put (new_triple (4367,4460,4533),182)
			Result.put (new_triple (4367,4460,4534),183)
			Result.put (new_triple (4367,4460,4535),184)
			Result.put (new_triple (4367,4460,4536),185)
			Result.put (new_triple (4367,4460,4537),186)
			Result.put (new_triple (4367,4460,4538),187)
			Result.put (new_triple (4367,4460,4539),188)
			Result.put (new_triple (4367,4460,4540),189)
			Result.put (new_triple (4367,4460,4541),190)
			Result.put (new_triple (4367,4460,4542),191)
			Result.put (new_triple (4367,4460,4543),192)
			Result.put (new_triple (4367,4460,4544),193)
			Result.put (new_triple (4367,4460,4545),194)
			Result.put (new_triple (4367,4460,4546),195)
			Result.put (new_pair (4367,4461),196)
			Result.put (new_triple (4367,4461,4520),197)
			Result.put (new_triple (4367,4461,4521),198)
			Result.put (new_triple (4367,4461,4522),199)
			Result.put (new_triple (4367,4461,4523),200)
			Result.put (new_triple (4367,4461,4524),201)
			Result.put (new_triple (4367,4461,4525),202)
			Result.put (new_triple (4367,4461,4526),203)
			Result.put (new_triple (4367,4461,4527),204)
			Result.put (new_triple (4367,4461,4528),205)
			Result.put (new_triple (4367,4461,4529),206)
			Result.put (new_triple (4367,4461,4530),207)
			Result.put (new_triple (4367,4461,4531),208)
			Result.put (new_triple (4367,4461,4532),209)
			Result.put (new_triple (4367,4461,4533),210)
			Result.put (new_triple (4367,4461,4534),211)
			Result.put (new_triple (4367,4461,4535),212)
			Result.put (new_triple (4367,4461,4536),213)
			Result.put (new_triple (4367,4461,4537),214)
			Result.put (new_triple (4367,4461,4538),215)
			Result.put (new_triple (4367,4461,4539),216)
			Result.put (new_triple (4367,4461,4540),217)
			Result.put (new_triple (4367,4461,4541),218)
			Result.put (new_triple (4367,4461,4542),219)
			Result.put (new_triple (4367,4461,4543),220)
			Result.put (new_triple (4367,4461,4544),221)
			Result.put (new_triple (4367,4461,4545),222)
			Result.put (new_triple (4367,4461,4546),223)
			Result.put (new_pair (4367,4462),224)
			Result.put (new_triple (4367,4462,4520),225)
			Result.put (new_triple (4367,4462,4521),226)
			Result.put (new_triple (4367,4462,4522),227)
			Result.put (new_triple (4367,4462,4523),228)
			Result.put (new_triple (4367,4462,4524),229)
			Result.put (new_triple (4367,4462,4525),230)
			Result.put (new_triple (4367,4462,4526),231)
			Result.put (new_triple (4367,4462,4527),232)
			Result.put (new_triple (4367,4462,4528),233)
			Result.put (new_triple (4367,4462,4529),234)
			Result.put (new_triple (4367,4462,4530),235)
			Result.put (new_triple (4367,4462,4531),236)
			Result.put (new_triple (4367,4462,4532),237)
			Result.put (new_triple (4367,4462,4533),238)
			Result.put (new_triple (4367,4462,4534),239)
			Result.put (new_triple (4367,4462,4535),240)
			Result.put (new_triple (4367,4462,4536),241)
			Result.put (new_triple (4367,4462,4537),242)
			Result.put (new_triple (4367,4462,4538),243)
			Result.put (new_triple (4367,4462,4539),244)
			Result.put (new_triple (4367,4462,4540),245)
			Result.put (new_triple (4367,4462,4541),246)
			Result.put (new_triple (4367,4462,4542),247)
			Result.put (new_triple (4367,4462,4543),248)
			Result.put (new_triple (4367,4462,4544),249)
			Result.put (new_triple (4367,4462,4545),250)
			Result.put (new_triple (4367,4462,4546),251)
			Result.put (new_pair (4367,4463),252)
			Result.put (new_triple (4367,4463,4520),253)
			Result.put (new_triple (4367,4463,4521),254)
			Result.put (new_triple (4367,4463,4522),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_208: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4367,4463,4523),0)
			Result.put (new_triple (4367,4463,4524),1)
			Result.put (new_triple (4367,4463,4525),2)
			Result.put (new_triple (4367,4463,4526),3)
			Result.put (new_triple (4367,4463,4527),4)
			Result.put (new_triple (4367,4463,4528),5)
			Result.put (new_triple (4367,4463,4529),6)
			Result.put (new_triple (4367,4463,4530),7)
			Result.put (new_triple (4367,4463,4531),8)
			Result.put (new_triple (4367,4463,4532),9)
			Result.put (new_triple (4367,4463,4533),10)
			Result.put (new_triple (4367,4463,4534),11)
			Result.put (new_triple (4367,4463,4535),12)
			Result.put (new_triple (4367,4463,4536),13)
			Result.put (new_triple (4367,4463,4537),14)
			Result.put (new_triple (4367,4463,4538),15)
			Result.put (new_triple (4367,4463,4539),16)
			Result.put (new_triple (4367,4463,4540),17)
			Result.put (new_triple (4367,4463,4541),18)
			Result.put (new_triple (4367,4463,4542),19)
			Result.put (new_triple (4367,4463,4543),20)
			Result.put (new_triple (4367,4463,4544),21)
			Result.put (new_triple (4367,4463,4545),22)
			Result.put (new_triple (4367,4463,4546),23)
			Result.put (new_pair (4367,4464),24)
			Result.put (new_triple (4367,4464,4520),25)
			Result.put (new_triple (4367,4464,4521),26)
			Result.put (new_triple (4367,4464,4522),27)
			Result.put (new_triple (4367,4464,4523),28)
			Result.put (new_triple (4367,4464,4524),29)
			Result.put (new_triple (4367,4464,4525),30)
			Result.put (new_triple (4367,4464,4526),31)
			Result.put (new_triple (4367,4464,4527),32)
			Result.put (new_triple (4367,4464,4528),33)
			Result.put (new_triple (4367,4464,4529),34)
			Result.put (new_triple (4367,4464,4530),35)
			Result.put (new_triple (4367,4464,4531),36)
			Result.put (new_triple (4367,4464,4532),37)
			Result.put (new_triple (4367,4464,4533),38)
			Result.put (new_triple (4367,4464,4534),39)
			Result.put (new_triple (4367,4464,4535),40)
			Result.put (new_triple (4367,4464,4536),41)
			Result.put (new_triple (4367,4464,4537),42)
			Result.put (new_triple (4367,4464,4538),43)
			Result.put (new_triple (4367,4464,4539),44)
			Result.put (new_triple (4367,4464,4540),45)
			Result.put (new_triple (4367,4464,4541),46)
			Result.put (new_triple (4367,4464,4542),47)
			Result.put (new_triple (4367,4464,4543),48)
			Result.put (new_triple (4367,4464,4544),49)
			Result.put (new_triple (4367,4464,4545),50)
			Result.put (new_triple (4367,4464,4546),51)
			Result.put (new_pair (4367,4465),52)
			Result.put (new_triple (4367,4465,4520),53)
			Result.put (new_triple (4367,4465,4521),54)
			Result.put (new_triple (4367,4465,4522),55)
			Result.put (new_triple (4367,4465,4523),56)
			Result.put (new_triple (4367,4465,4524),57)
			Result.put (new_triple (4367,4465,4525),58)
			Result.put (new_triple (4367,4465,4526),59)
			Result.put (new_triple (4367,4465,4527),60)
			Result.put (new_triple (4367,4465,4528),61)
			Result.put (new_triple (4367,4465,4529),62)
			Result.put (new_triple (4367,4465,4530),63)
			Result.put (new_triple (4367,4465,4531),64)
			Result.put (new_triple (4367,4465,4532),65)
			Result.put (new_triple (4367,4465,4533),66)
			Result.put (new_triple (4367,4465,4534),67)
			Result.put (new_triple (4367,4465,4535),68)
			Result.put (new_triple (4367,4465,4536),69)
			Result.put (new_triple (4367,4465,4537),70)
			Result.put (new_triple (4367,4465,4538),71)
			Result.put (new_triple (4367,4465,4539),72)
			Result.put (new_triple (4367,4465,4540),73)
			Result.put (new_triple (4367,4465,4541),74)
			Result.put (new_triple (4367,4465,4542),75)
			Result.put (new_triple (4367,4465,4543),76)
			Result.put (new_triple (4367,4465,4544),77)
			Result.put (new_triple (4367,4465,4545),78)
			Result.put (new_triple (4367,4465,4546),79)
			Result.put (new_pair (4367,4466),80)
			Result.put (new_triple (4367,4466,4520),81)
			Result.put (new_triple (4367,4466,4521),82)
			Result.put (new_triple (4367,4466,4522),83)
			Result.put (new_triple (4367,4466,4523),84)
			Result.put (new_triple (4367,4466,4524),85)
			Result.put (new_triple (4367,4466,4525),86)
			Result.put (new_triple (4367,4466,4526),87)
			Result.put (new_triple (4367,4466,4527),88)
			Result.put (new_triple (4367,4466,4528),89)
			Result.put (new_triple (4367,4466,4529),90)
			Result.put (new_triple (4367,4466,4530),91)
			Result.put (new_triple (4367,4466,4531),92)
			Result.put (new_triple (4367,4466,4532),93)
			Result.put (new_triple (4367,4466,4533),94)
			Result.put (new_triple (4367,4466,4534),95)
			Result.put (new_triple (4367,4466,4535),96)
			Result.put (new_triple (4367,4466,4536),97)
			Result.put (new_triple (4367,4466,4537),98)
			Result.put (new_triple (4367,4466,4538),99)
			Result.put (new_triple (4367,4466,4539),100)
			Result.put (new_triple (4367,4466,4540),101)
			Result.put (new_triple (4367,4466,4541),102)
			Result.put (new_triple (4367,4466,4542),103)
			Result.put (new_triple (4367,4466,4543),104)
			Result.put (new_triple (4367,4466,4544),105)
			Result.put (new_triple (4367,4466,4545),106)
			Result.put (new_triple (4367,4466,4546),107)
			Result.put (new_pair (4367,4467),108)
			Result.put (new_triple (4367,4467,4520),109)
			Result.put (new_triple (4367,4467,4521),110)
			Result.put (new_triple (4367,4467,4522),111)
			Result.put (new_triple (4367,4467,4523),112)
			Result.put (new_triple (4367,4467,4524),113)
			Result.put (new_triple (4367,4467,4525),114)
			Result.put (new_triple (4367,4467,4526),115)
			Result.put (new_triple (4367,4467,4527),116)
			Result.put (new_triple (4367,4467,4528),117)
			Result.put (new_triple (4367,4467,4529),118)
			Result.put (new_triple (4367,4467,4530),119)
			Result.put (new_triple (4367,4467,4531),120)
			Result.put (new_triple (4367,4467,4532),121)
			Result.put (new_triple (4367,4467,4533),122)
			Result.put (new_triple (4367,4467,4534),123)
			Result.put (new_triple (4367,4467,4535),124)
			Result.put (new_triple (4367,4467,4536),125)
			Result.put (new_triple (4367,4467,4537),126)
			Result.put (new_triple (4367,4467,4538),127)
			Result.put (new_triple (4367,4467,4539),128)
			Result.put (new_triple (4367,4467,4540),129)
			Result.put (new_triple (4367,4467,4541),130)
			Result.put (new_triple (4367,4467,4542),131)
			Result.put (new_triple (4367,4467,4543),132)
			Result.put (new_triple (4367,4467,4544),133)
			Result.put (new_triple (4367,4467,4545),134)
			Result.put (new_triple (4367,4467,4546),135)
			Result.put (new_pair (4367,4468),136)
			Result.put (new_triple (4367,4468,4520),137)
			Result.put (new_triple (4367,4468,4521),138)
			Result.put (new_triple (4367,4468,4522),139)
			Result.put (new_triple (4367,4468,4523),140)
			Result.put (new_triple (4367,4468,4524),141)
			Result.put (new_triple (4367,4468,4525),142)
			Result.put (new_triple (4367,4468,4526),143)
			Result.put (new_triple (4367,4468,4527),144)
			Result.put (new_triple (4367,4468,4528),145)
			Result.put (new_triple (4367,4468,4529),146)
			Result.put (new_triple (4367,4468,4530),147)
			Result.put (new_triple (4367,4468,4531),148)
			Result.put (new_triple (4367,4468,4532),149)
			Result.put (new_triple (4367,4468,4533),150)
			Result.put (new_triple (4367,4468,4534),151)
			Result.put (new_triple (4367,4468,4535),152)
			Result.put (new_triple (4367,4468,4536),153)
			Result.put (new_triple (4367,4468,4537),154)
			Result.put (new_triple (4367,4468,4538),155)
			Result.put (new_triple (4367,4468,4539),156)
			Result.put (new_triple (4367,4468,4540),157)
			Result.put (new_triple (4367,4468,4541),158)
			Result.put (new_triple (4367,4468,4542),159)
			Result.put (new_triple (4367,4468,4543),160)
			Result.put (new_triple (4367,4468,4544),161)
			Result.put (new_triple (4367,4468,4545),162)
			Result.put (new_triple (4367,4468,4546),163)
			Result.put (new_pair (4367,4469),164)
			Result.put (new_triple (4367,4469,4520),165)
			Result.put (new_triple (4367,4469,4521),166)
			Result.put (new_triple (4367,4469,4522),167)
			Result.put (new_triple (4367,4469,4523),168)
			Result.put (new_triple (4367,4469,4524),169)
			Result.put (new_triple (4367,4469,4525),170)
			Result.put (new_triple (4367,4469,4526),171)
			Result.put (new_triple (4367,4469,4527),172)
			Result.put (new_triple (4367,4469,4528),173)
			Result.put (new_triple (4367,4469,4529),174)
			Result.put (new_triple (4367,4469,4530),175)
			Result.put (new_triple (4367,4469,4531),176)
			Result.put (new_triple (4367,4469,4532),177)
			Result.put (new_triple (4367,4469,4533),178)
			Result.put (new_triple (4367,4469,4534),179)
			Result.put (new_triple (4367,4469,4535),180)
			Result.put (new_triple (4367,4469,4536),181)
			Result.put (new_triple (4367,4469,4537),182)
			Result.put (new_triple (4367,4469,4538),183)
			Result.put (new_triple (4367,4469,4539),184)
			Result.put (new_triple (4367,4469,4540),185)
			Result.put (new_triple (4367,4469,4541),186)
			Result.put (new_triple (4367,4469,4542),187)
			Result.put (new_triple (4367,4469,4543),188)
			Result.put (new_triple (4367,4469,4544),189)
			Result.put (new_triple (4367,4469,4545),190)
			Result.put (new_triple (4367,4469,4546),191)
			Result.put (new_pair (4368,4449),192)
			Result.put (new_triple (4368,4449,4520),193)
			Result.put (new_triple (4368,4449,4521),194)
			Result.put (new_triple (4368,4449,4522),195)
			Result.put (new_triple (4368,4449,4523),196)
			Result.put (new_triple (4368,4449,4524),197)
			Result.put (new_triple (4368,4449,4525),198)
			Result.put (new_triple (4368,4449,4526),199)
			Result.put (new_triple (4368,4449,4527),200)
			Result.put (new_triple (4368,4449,4528),201)
			Result.put (new_triple (4368,4449,4529),202)
			Result.put (new_triple (4368,4449,4530),203)
			Result.put (new_triple (4368,4449,4531),204)
			Result.put (new_triple (4368,4449,4532),205)
			Result.put (new_triple (4368,4449,4533),206)
			Result.put (new_triple (4368,4449,4534),207)
			Result.put (new_triple (4368,4449,4535),208)
			Result.put (new_triple (4368,4449,4536),209)
			Result.put (new_triple (4368,4449,4537),210)
			Result.put (new_triple (4368,4449,4538),211)
			Result.put (new_triple (4368,4449,4539),212)
			Result.put (new_triple (4368,4449,4540),213)
			Result.put (new_triple (4368,4449,4541),214)
			Result.put (new_triple (4368,4449,4542),215)
			Result.put (new_triple (4368,4449,4543),216)
			Result.put (new_triple (4368,4449,4544),217)
			Result.put (new_triple (4368,4449,4545),218)
			Result.put (new_triple (4368,4449,4546),219)
			Result.put (new_pair (4368,4450),220)
			Result.put (new_triple (4368,4450,4520),221)
			Result.put (new_triple (4368,4450,4521),222)
			Result.put (new_triple (4368,4450,4522),223)
			Result.put (new_triple (4368,4450,4523),224)
			Result.put (new_triple (4368,4450,4524),225)
			Result.put (new_triple (4368,4450,4525),226)
			Result.put (new_triple (4368,4450,4526),227)
			Result.put (new_triple (4368,4450,4527),228)
			Result.put (new_triple (4368,4450,4528),229)
			Result.put (new_triple (4368,4450,4529),230)
			Result.put (new_triple (4368,4450,4530),231)
			Result.put (new_triple (4368,4450,4531),232)
			Result.put (new_triple (4368,4450,4532),233)
			Result.put (new_triple (4368,4450,4533),234)
			Result.put (new_triple (4368,4450,4534),235)
			Result.put (new_triple (4368,4450,4535),236)
			Result.put (new_triple (4368,4450,4536),237)
			Result.put (new_triple (4368,4450,4537),238)
			Result.put (new_triple (4368,4450,4538),239)
			Result.put (new_triple (4368,4450,4539),240)
			Result.put (new_triple (4368,4450,4540),241)
			Result.put (new_triple (4368,4450,4541),242)
			Result.put (new_triple (4368,4450,4542),243)
			Result.put (new_triple (4368,4450,4543),244)
			Result.put (new_triple (4368,4450,4544),245)
			Result.put (new_triple (4368,4450,4545),246)
			Result.put (new_triple (4368,4450,4546),247)
			Result.put (new_pair (4368,4451),248)
			Result.put (new_triple (4368,4451,4520),249)
			Result.put (new_triple (4368,4451,4521),250)
			Result.put (new_triple (4368,4451,4522),251)
			Result.put (new_triple (4368,4451,4523),252)
			Result.put (new_triple (4368,4451,4524),253)
			Result.put (new_triple (4368,4451,4525),254)
			Result.put (new_triple (4368,4451,4526),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_209: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4368,4451,4527),0)
			Result.put (new_triple (4368,4451,4528),1)
			Result.put (new_triple (4368,4451,4529),2)
			Result.put (new_triple (4368,4451,4530),3)
			Result.put (new_triple (4368,4451,4531),4)
			Result.put (new_triple (4368,4451,4532),5)
			Result.put (new_triple (4368,4451,4533),6)
			Result.put (new_triple (4368,4451,4534),7)
			Result.put (new_triple (4368,4451,4535),8)
			Result.put (new_triple (4368,4451,4536),9)
			Result.put (new_triple (4368,4451,4537),10)
			Result.put (new_triple (4368,4451,4538),11)
			Result.put (new_triple (4368,4451,4539),12)
			Result.put (new_triple (4368,4451,4540),13)
			Result.put (new_triple (4368,4451,4541),14)
			Result.put (new_triple (4368,4451,4542),15)
			Result.put (new_triple (4368,4451,4543),16)
			Result.put (new_triple (4368,4451,4544),17)
			Result.put (new_triple (4368,4451,4545),18)
			Result.put (new_triple (4368,4451,4546),19)
			Result.put (new_pair (4368,4452),20)
			Result.put (new_triple (4368,4452,4520),21)
			Result.put (new_triple (4368,4452,4521),22)
			Result.put (new_triple (4368,4452,4522),23)
			Result.put (new_triple (4368,4452,4523),24)
			Result.put (new_triple (4368,4452,4524),25)
			Result.put (new_triple (4368,4452,4525),26)
			Result.put (new_triple (4368,4452,4526),27)
			Result.put (new_triple (4368,4452,4527),28)
			Result.put (new_triple (4368,4452,4528),29)
			Result.put (new_triple (4368,4452,4529),30)
			Result.put (new_triple (4368,4452,4530),31)
			Result.put (new_triple (4368,4452,4531),32)
			Result.put (new_triple (4368,4452,4532),33)
			Result.put (new_triple (4368,4452,4533),34)
			Result.put (new_triple (4368,4452,4534),35)
			Result.put (new_triple (4368,4452,4535),36)
			Result.put (new_triple (4368,4452,4536),37)
			Result.put (new_triple (4368,4452,4537),38)
			Result.put (new_triple (4368,4452,4538),39)
			Result.put (new_triple (4368,4452,4539),40)
			Result.put (new_triple (4368,4452,4540),41)
			Result.put (new_triple (4368,4452,4541),42)
			Result.put (new_triple (4368,4452,4542),43)
			Result.put (new_triple (4368,4452,4543),44)
			Result.put (new_triple (4368,4452,4544),45)
			Result.put (new_triple (4368,4452,4545),46)
			Result.put (new_triple (4368,4452,4546),47)
			Result.put (new_pair (4368,4453),48)
			Result.put (new_triple (4368,4453,4520),49)
			Result.put (new_triple (4368,4453,4521),50)
			Result.put (new_triple (4368,4453,4522),51)
			Result.put (new_triple (4368,4453,4523),52)
			Result.put (new_triple (4368,4453,4524),53)
			Result.put (new_triple (4368,4453,4525),54)
			Result.put (new_triple (4368,4453,4526),55)
			Result.put (new_triple (4368,4453,4527),56)
			Result.put (new_triple (4368,4453,4528),57)
			Result.put (new_triple (4368,4453,4529),58)
			Result.put (new_triple (4368,4453,4530),59)
			Result.put (new_triple (4368,4453,4531),60)
			Result.put (new_triple (4368,4453,4532),61)
			Result.put (new_triple (4368,4453,4533),62)
			Result.put (new_triple (4368,4453,4534),63)
			Result.put (new_triple (4368,4453,4535),64)
			Result.put (new_triple (4368,4453,4536),65)
			Result.put (new_triple (4368,4453,4537),66)
			Result.put (new_triple (4368,4453,4538),67)
			Result.put (new_triple (4368,4453,4539),68)
			Result.put (new_triple (4368,4453,4540),69)
			Result.put (new_triple (4368,4453,4541),70)
			Result.put (new_triple (4368,4453,4542),71)
			Result.put (new_triple (4368,4453,4543),72)
			Result.put (new_triple (4368,4453,4544),73)
			Result.put (new_triple (4368,4453,4545),74)
			Result.put (new_triple (4368,4453,4546),75)
			Result.put (new_pair (4368,4454),76)
			Result.put (new_triple (4368,4454,4520),77)
			Result.put (new_triple (4368,4454,4521),78)
			Result.put (new_triple (4368,4454,4522),79)
			Result.put (new_triple (4368,4454,4523),80)
			Result.put (new_triple (4368,4454,4524),81)
			Result.put (new_triple (4368,4454,4525),82)
			Result.put (new_triple (4368,4454,4526),83)
			Result.put (new_triple (4368,4454,4527),84)
			Result.put (new_triple (4368,4454,4528),85)
			Result.put (new_triple (4368,4454,4529),86)
			Result.put (new_triple (4368,4454,4530),87)
			Result.put (new_triple (4368,4454,4531),88)
			Result.put (new_triple (4368,4454,4532),89)
			Result.put (new_triple (4368,4454,4533),90)
			Result.put (new_triple (4368,4454,4534),91)
			Result.put (new_triple (4368,4454,4535),92)
			Result.put (new_triple (4368,4454,4536),93)
			Result.put (new_triple (4368,4454,4537),94)
			Result.put (new_triple (4368,4454,4538),95)
			Result.put (new_triple (4368,4454,4539),96)
			Result.put (new_triple (4368,4454,4540),97)
			Result.put (new_triple (4368,4454,4541),98)
			Result.put (new_triple (4368,4454,4542),99)
			Result.put (new_triple (4368,4454,4543),100)
			Result.put (new_triple (4368,4454,4544),101)
			Result.put (new_triple (4368,4454,4545),102)
			Result.put (new_triple (4368,4454,4546),103)
			Result.put (new_pair (4368,4455),104)
			Result.put (new_triple (4368,4455,4520),105)
			Result.put (new_triple (4368,4455,4521),106)
			Result.put (new_triple (4368,4455,4522),107)
			Result.put (new_triple (4368,4455,4523),108)
			Result.put (new_triple (4368,4455,4524),109)
			Result.put (new_triple (4368,4455,4525),110)
			Result.put (new_triple (4368,4455,4526),111)
			Result.put (new_triple (4368,4455,4527),112)
			Result.put (new_triple (4368,4455,4528),113)
			Result.put (new_triple (4368,4455,4529),114)
			Result.put (new_triple (4368,4455,4530),115)
			Result.put (new_triple (4368,4455,4531),116)
			Result.put (new_triple (4368,4455,4532),117)
			Result.put (new_triple (4368,4455,4533),118)
			Result.put (new_triple (4368,4455,4534),119)
			Result.put (new_triple (4368,4455,4535),120)
			Result.put (new_triple (4368,4455,4536),121)
			Result.put (new_triple (4368,4455,4537),122)
			Result.put (new_triple (4368,4455,4538),123)
			Result.put (new_triple (4368,4455,4539),124)
			Result.put (new_triple (4368,4455,4540),125)
			Result.put (new_triple (4368,4455,4541),126)
			Result.put (new_triple (4368,4455,4542),127)
			Result.put (new_triple (4368,4455,4543),128)
			Result.put (new_triple (4368,4455,4544),129)
			Result.put (new_triple (4368,4455,4545),130)
			Result.put (new_triple (4368,4455,4546),131)
			Result.put (new_pair (4368,4456),132)
			Result.put (new_triple (4368,4456,4520),133)
			Result.put (new_triple (4368,4456,4521),134)
			Result.put (new_triple (4368,4456,4522),135)
			Result.put (new_triple (4368,4456,4523),136)
			Result.put (new_triple (4368,4456,4524),137)
			Result.put (new_triple (4368,4456,4525),138)
			Result.put (new_triple (4368,4456,4526),139)
			Result.put (new_triple (4368,4456,4527),140)
			Result.put (new_triple (4368,4456,4528),141)
			Result.put (new_triple (4368,4456,4529),142)
			Result.put (new_triple (4368,4456,4530),143)
			Result.put (new_triple (4368,4456,4531),144)
			Result.put (new_triple (4368,4456,4532),145)
			Result.put (new_triple (4368,4456,4533),146)
			Result.put (new_triple (4368,4456,4534),147)
			Result.put (new_triple (4368,4456,4535),148)
			Result.put (new_triple (4368,4456,4536),149)
			Result.put (new_triple (4368,4456,4537),150)
			Result.put (new_triple (4368,4456,4538),151)
			Result.put (new_triple (4368,4456,4539),152)
			Result.put (new_triple (4368,4456,4540),153)
			Result.put (new_triple (4368,4456,4541),154)
			Result.put (new_triple (4368,4456,4542),155)
			Result.put (new_triple (4368,4456,4543),156)
			Result.put (new_triple (4368,4456,4544),157)
			Result.put (new_triple (4368,4456,4545),158)
			Result.put (new_triple (4368,4456,4546),159)
			Result.put (new_pair (4368,4457),160)
			Result.put (new_triple (4368,4457,4520),161)
			Result.put (new_triple (4368,4457,4521),162)
			Result.put (new_triple (4368,4457,4522),163)
			Result.put (new_triple (4368,4457,4523),164)
			Result.put (new_triple (4368,4457,4524),165)
			Result.put (new_triple (4368,4457,4525),166)
			Result.put (new_triple (4368,4457,4526),167)
			Result.put (new_triple (4368,4457,4527),168)
			Result.put (new_triple (4368,4457,4528),169)
			Result.put (new_triple (4368,4457,4529),170)
			Result.put (new_triple (4368,4457,4530),171)
			Result.put (new_triple (4368,4457,4531),172)
			Result.put (new_triple (4368,4457,4532),173)
			Result.put (new_triple (4368,4457,4533),174)
			Result.put (new_triple (4368,4457,4534),175)
			Result.put (new_triple (4368,4457,4535),176)
			Result.put (new_triple (4368,4457,4536),177)
			Result.put (new_triple (4368,4457,4537),178)
			Result.put (new_triple (4368,4457,4538),179)
			Result.put (new_triple (4368,4457,4539),180)
			Result.put (new_triple (4368,4457,4540),181)
			Result.put (new_triple (4368,4457,4541),182)
			Result.put (new_triple (4368,4457,4542),183)
			Result.put (new_triple (4368,4457,4543),184)
			Result.put (new_triple (4368,4457,4544),185)
			Result.put (new_triple (4368,4457,4545),186)
			Result.put (new_triple (4368,4457,4546),187)
			Result.put (new_pair (4368,4458),188)
			Result.put (new_triple (4368,4458,4520),189)
			Result.put (new_triple (4368,4458,4521),190)
			Result.put (new_triple (4368,4458,4522),191)
			Result.put (new_triple (4368,4458,4523),192)
			Result.put (new_triple (4368,4458,4524),193)
			Result.put (new_triple (4368,4458,4525),194)
			Result.put (new_triple (4368,4458,4526),195)
			Result.put (new_triple (4368,4458,4527),196)
			Result.put (new_triple (4368,4458,4528),197)
			Result.put (new_triple (4368,4458,4529),198)
			Result.put (new_triple (4368,4458,4530),199)
			Result.put (new_triple (4368,4458,4531),200)
			Result.put (new_triple (4368,4458,4532),201)
			Result.put (new_triple (4368,4458,4533),202)
			Result.put (new_triple (4368,4458,4534),203)
			Result.put (new_triple (4368,4458,4535),204)
			Result.put (new_triple (4368,4458,4536),205)
			Result.put (new_triple (4368,4458,4537),206)
			Result.put (new_triple (4368,4458,4538),207)
			Result.put (new_triple (4368,4458,4539),208)
			Result.put (new_triple (4368,4458,4540),209)
			Result.put (new_triple (4368,4458,4541),210)
			Result.put (new_triple (4368,4458,4542),211)
			Result.put (new_triple (4368,4458,4543),212)
			Result.put (new_triple (4368,4458,4544),213)
			Result.put (new_triple (4368,4458,4545),214)
			Result.put (new_triple (4368,4458,4546),215)
			Result.put (new_pair (4368,4459),216)
			Result.put (new_triple (4368,4459,4520),217)
			Result.put (new_triple (4368,4459,4521),218)
			Result.put (new_triple (4368,4459,4522),219)
			Result.put (new_triple (4368,4459,4523),220)
			Result.put (new_triple (4368,4459,4524),221)
			Result.put (new_triple (4368,4459,4525),222)
			Result.put (new_triple (4368,4459,4526),223)
			Result.put (new_triple (4368,4459,4527),224)
			Result.put (new_triple (4368,4459,4528),225)
			Result.put (new_triple (4368,4459,4529),226)
			Result.put (new_triple (4368,4459,4530),227)
			Result.put (new_triple (4368,4459,4531),228)
			Result.put (new_triple (4368,4459,4532),229)
			Result.put (new_triple (4368,4459,4533),230)
			Result.put (new_triple (4368,4459,4534),231)
			Result.put (new_triple (4368,4459,4535),232)
			Result.put (new_triple (4368,4459,4536),233)
			Result.put (new_triple (4368,4459,4537),234)
			Result.put (new_triple (4368,4459,4538),235)
			Result.put (new_triple (4368,4459,4539),236)
			Result.put (new_triple (4368,4459,4540),237)
			Result.put (new_triple (4368,4459,4541),238)
			Result.put (new_triple (4368,4459,4542),239)
			Result.put (new_triple (4368,4459,4543),240)
			Result.put (new_triple (4368,4459,4544),241)
			Result.put (new_triple (4368,4459,4545),242)
			Result.put (new_triple (4368,4459,4546),243)
			Result.put (new_pair (4368,4460),244)
			Result.put (new_triple (4368,4460,4520),245)
			Result.put (new_triple (4368,4460,4521),246)
			Result.put (new_triple (4368,4460,4522),247)
			Result.put (new_triple (4368,4460,4523),248)
			Result.put (new_triple (4368,4460,4524),249)
			Result.put (new_triple (4368,4460,4525),250)
			Result.put (new_triple (4368,4460,4526),251)
			Result.put (new_triple (4368,4460,4527),252)
			Result.put (new_triple (4368,4460,4528),253)
			Result.put (new_triple (4368,4460,4529),254)
			Result.put (new_triple (4368,4460,4530),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_210: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4368,4460,4531),0)
			Result.put (new_triple (4368,4460,4532),1)
			Result.put (new_triple (4368,4460,4533),2)
			Result.put (new_triple (4368,4460,4534),3)
			Result.put (new_triple (4368,4460,4535),4)
			Result.put (new_triple (4368,4460,4536),5)
			Result.put (new_triple (4368,4460,4537),6)
			Result.put (new_triple (4368,4460,4538),7)
			Result.put (new_triple (4368,4460,4539),8)
			Result.put (new_triple (4368,4460,4540),9)
			Result.put (new_triple (4368,4460,4541),10)
			Result.put (new_triple (4368,4460,4542),11)
			Result.put (new_triple (4368,4460,4543),12)
			Result.put (new_triple (4368,4460,4544),13)
			Result.put (new_triple (4368,4460,4545),14)
			Result.put (new_triple (4368,4460,4546),15)
			Result.put (new_pair (4368,4461),16)
			Result.put (new_triple (4368,4461,4520),17)
			Result.put (new_triple (4368,4461,4521),18)
			Result.put (new_triple (4368,4461,4522),19)
			Result.put (new_triple (4368,4461,4523),20)
			Result.put (new_triple (4368,4461,4524),21)
			Result.put (new_triple (4368,4461,4525),22)
			Result.put (new_triple (4368,4461,4526),23)
			Result.put (new_triple (4368,4461,4527),24)
			Result.put (new_triple (4368,4461,4528),25)
			Result.put (new_triple (4368,4461,4529),26)
			Result.put (new_triple (4368,4461,4530),27)
			Result.put (new_triple (4368,4461,4531),28)
			Result.put (new_triple (4368,4461,4532),29)
			Result.put (new_triple (4368,4461,4533),30)
			Result.put (new_triple (4368,4461,4534),31)
			Result.put (new_triple (4368,4461,4535),32)
			Result.put (new_triple (4368,4461,4536),33)
			Result.put (new_triple (4368,4461,4537),34)
			Result.put (new_triple (4368,4461,4538),35)
			Result.put (new_triple (4368,4461,4539),36)
			Result.put (new_triple (4368,4461,4540),37)
			Result.put (new_triple (4368,4461,4541),38)
			Result.put (new_triple (4368,4461,4542),39)
			Result.put (new_triple (4368,4461,4543),40)
			Result.put (new_triple (4368,4461,4544),41)
			Result.put (new_triple (4368,4461,4545),42)
			Result.put (new_triple (4368,4461,4546),43)
			Result.put (new_pair (4368,4462),44)
			Result.put (new_triple (4368,4462,4520),45)
			Result.put (new_triple (4368,4462,4521),46)
			Result.put (new_triple (4368,4462,4522),47)
			Result.put (new_triple (4368,4462,4523),48)
			Result.put (new_triple (4368,4462,4524),49)
			Result.put (new_triple (4368,4462,4525),50)
			Result.put (new_triple (4368,4462,4526),51)
			Result.put (new_triple (4368,4462,4527),52)
			Result.put (new_triple (4368,4462,4528),53)
			Result.put (new_triple (4368,4462,4529),54)
			Result.put (new_triple (4368,4462,4530),55)
			Result.put (new_triple (4368,4462,4531),56)
			Result.put (new_triple (4368,4462,4532),57)
			Result.put (new_triple (4368,4462,4533),58)
			Result.put (new_triple (4368,4462,4534),59)
			Result.put (new_triple (4368,4462,4535),60)
			Result.put (new_triple (4368,4462,4536),61)
			Result.put (new_triple (4368,4462,4537),62)
			Result.put (new_triple (4368,4462,4538),63)
			Result.put (new_triple (4368,4462,4539),64)
			Result.put (new_triple (4368,4462,4540),65)
			Result.put (new_triple (4368,4462,4541),66)
			Result.put (new_triple (4368,4462,4542),67)
			Result.put (new_triple (4368,4462,4543),68)
			Result.put (new_triple (4368,4462,4544),69)
			Result.put (new_triple (4368,4462,4545),70)
			Result.put (new_triple (4368,4462,4546),71)
			Result.put (new_pair (4368,4463),72)
			Result.put (new_triple (4368,4463,4520),73)
			Result.put (new_triple (4368,4463,4521),74)
			Result.put (new_triple (4368,4463,4522),75)
			Result.put (new_triple (4368,4463,4523),76)
			Result.put (new_triple (4368,4463,4524),77)
			Result.put (new_triple (4368,4463,4525),78)
			Result.put (new_triple (4368,4463,4526),79)
			Result.put (new_triple (4368,4463,4527),80)
			Result.put (new_triple (4368,4463,4528),81)
			Result.put (new_triple (4368,4463,4529),82)
			Result.put (new_triple (4368,4463,4530),83)
			Result.put (new_triple (4368,4463,4531),84)
			Result.put (new_triple (4368,4463,4532),85)
			Result.put (new_triple (4368,4463,4533),86)
			Result.put (new_triple (4368,4463,4534),87)
			Result.put (new_triple (4368,4463,4535),88)
			Result.put (new_triple (4368,4463,4536),89)
			Result.put (new_triple (4368,4463,4537),90)
			Result.put (new_triple (4368,4463,4538),91)
			Result.put (new_triple (4368,4463,4539),92)
			Result.put (new_triple (4368,4463,4540),93)
			Result.put (new_triple (4368,4463,4541),94)
			Result.put (new_triple (4368,4463,4542),95)
			Result.put (new_triple (4368,4463,4543),96)
			Result.put (new_triple (4368,4463,4544),97)
			Result.put (new_triple (4368,4463,4545),98)
			Result.put (new_triple (4368,4463,4546),99)
			Result.put (new_pair (4368,4464),100)
			Result.put (new_triple (4368,4464,4520),101)
			Result.put (new_triple (4368,4464,4521),102)
			Result.put (new_triple (4368,4464,4522),103)
			Result.put (new_triple (4368,4464,4523),104)
			Result.put (new_triple (4368,4464,4524),105)
			Result.put (new_triple (4368,4464,4525),106)
			Result.put (new_triple (4368,4464,4526),107)
			Result.put (new_triple (4368,4464,4527),108)
			Result.put (new_triple (4368,4464,4528),109)
			Result.put (new_triple (4368,4464,4529),110)
			Result.put (new_triple (4368,4464,4530),111)
			Result.put (new_triple (4368,4464,4531),112)
			Result.put (new_triple (4368,4464,4532),113)
			Result.put (new_triple (4368,4464,4533),114)
			Result.put (new_triple (4368,4464,4534),115)
			Result.put (new_triple (4368,4464,4535),116)
			Result.put (new_triple (4368,4464,4536),117)
			Result.put (new_triple (4368,4464,4537),118)
			Result.put (new_triple (4368,4464,4538),119)
			Result.put (new_triple (4368,4464,4539),120)
			Result.put (new_triple (4368,4464,4540),121)
			Result.put (new_triple (4368,4464,4541),122)
			Result.put (new_triple (4368,4464,4542),123)
			Result.put (new_triple (4368,4464,4543),124)
			Result.put (new_triple (4368,4464,4544),125)
			Result.put (new_triple (4368,4464,4545),126)
			Result.put (new_triple (4368,4464,4546),127)
			Result.put (new_pair (4368,4465),128)
			Result.put (new_triple (4368,4465,4520),129)
			Result.put (new_triple (4368,4465,4521),130)
			Result.put (new_triple (4368,4465,4522),131)
			Result.put (new_triple (4368,4465,4523),132)
			Result.put (new_triple (4368,4465,4524),133)
			Result.put (new_triple (4368,4465,4525),134)
			Result.put (new_triple (4368,4465,4526),135)
			Result.put (new_triple (4368,4465,4527),136)
			Result.put (new_triple (4368,4465,4528),137)
			Result.put (new_triple (4368,4465,4529),138)
			Result.put (new_triple (4368,4465,4530),139)
			Result.put (new_triple (4368,4465,4531),140)
			Result.put (new_triple (4368,4465,4532),141)
			Result.put (new_triple (4368,4465,4533),142)
			Result.put (new_triple (4368,4465,4534),143)
			Result.put (new_triple (4368,4465,4535),144)
			Result.put (new_triple (4368,4465,4536),145)
			Result.put (new_triple (4368,4465,4537),146)
			Result.put (new_triple (4368,4465,4538),147)
			Result.put (new_triple (4368,4465,4539),148)
			Result.put (new_triple (4368,4465,4540),149)
			Result.put (new_triple (4368,4465,4541),150)
			Result.put (new_triple (4368,4465,4542),151)
			Result.put (new_triple (4368,4465,4543),152)
			Result.put (new_triple (4368,4465,4544),153)
			Result.put (new_triple (4368,4465,4545),154)
			Result.put (new_triple (4368,4465,4546),155)
			Result.put (new_pair (4368,4466),156)
			Result.put (new_triple (4368,4466,4520),157)
			Result.put (new_triple (4368,4466,4521),158)
			Result.put (new_triple (4368,4466,4522),159)
			Result.put (new_triple (4368,4466,4523),160)
			Result.put (new_triple (4368,4466,4524),161)
			Result.put (new_triple (4368,4466,4525),162)
			Result.put (new_triple (4368,4466,4526),163)
			Result.put (new_triple (4368,4466,4527),164)
			Result.put (new_triple (4368,4466,4528),165)
			Result.put (new_triple (4368,4466,4529),166)
			Result.put (new_triple (4368,4466,4530),167)
			Result.put (new_triple (4368,4466,4531),168)
			Result.put (new_triple (4368,4466,4532),169)
			Result.put (new_triple (4368,4466,4533),170)
			Result.put (new_triple (4368,4466,4534),171)
			Result.put (new_triple (4368,4466,4535),172)
			Result.put (new_triple (4368,4466,4536),173)
			Result.put (new_triple (4368,4466,4537),174)
			Result.put (new_triple (4368,4466,4538),175)
			Result.put (new_triple (4368,4466,4539),176)
			Result.put (new_triple (4368,4466,4540),177)
			Result.put (new_triple (4368,4466,4541),178)
			Result.put (new_triple (4368,4466,4542),179)
			Result.put (new_triple (4368,4466,4543),180)
			Result.put (new_triple (4368,4466,4544),181)
			Result.put (new_triple (4368,4466,4545),182)
			Result.put (new_triple (4368,4466,4546),183)
			Result.put (new_pair (4368,4467),184)
			Result.put (new_triple (4368,4467,4520),185)
			Result.put (new_triple (4368,4467,4521),186)
			Result.put (new_triple (4368,4467,4522),187)
			Result.put (new_triple (4368,4467,4523),188)
			Result.put (new_triple (4368,4467,4524),189)
			Result.put (new_triple (4368,4467,4525),190)
			Result.put (new_triple (4368,4467,4526),191)
			Result.put (new_triple (4368,4467,4527),192)
			Result.put (new_triple (4368,4467,4528),193)
			Result.put (new_triple (4368,4467,4529),194)
			Result.put (new_triple (4368,4467,4530),195)
			Result.put (new_triple (4368,4467,4531),196)
			Result.put (new_triple (4368,4467,4532),197)
			Result.put (new_triple (4368,4467,4533),198)
			Result.put (new_triple (4368,4467,4534),199)
			Result.put (new_triple (4368,4467,4535),200)
			Result.put (new_triple (4368,4467,4536),201)
			Result.put (new_triple (4368,4467,4537),202)
			Result.put (new_triple (4368,4467,4538),203)
			Result.put (new_triple (4368,4467,4539),204)
			Result.put (new_triple (4368,4467,4540),205)
			Result.put (new_triple (4368,4467,4541),206)
			Result.put (new_triple (4368,4467,4542),207)
			Result.put (new_triple (4368,4467,4543),208)
			Result.put (new_triple (4368,4467,4544),209)
			Result.put (new_triple (4368,4467,4545),210)
			Result.put (new_triple (4368,4467,4546),211)
			Result.put (new_pair (4368,4468),212)
			Result.put (new_triple (4368,4468,4520),213)
			Result.put (new_triple (4368,4468,4521),214)
			Result.put (new_triple (4368,4468,4522),215)
			Result.put (new_triple (4368,4468,4523),216)
			Result.put (new_triple (4368,4468,4524),217)
			Result.put (new_triple (4368,4468,4525),218)
			Result.put (new_triple (4368,4468,4526),219)
			Result.put (new_triple (4368,4468,4527),220)
			Result.put (new_triple (4368,4468,4528),221)
			Result.put (new_triple (4368,4468,4529),222)
			Result.put (new_triple (4368,4468,4530),223)
			Result.put (new_triple (4368,4468,4531),224)
			Result.put (new_triple (4368,4468,4532),225)
			Result.put (new_triple (4368,4468,4533),226)
			Result.put (new_triple (4368,4468,4534),227)
			Result.put (new_triple (4368,4468,4535),228)
			Result.put (new_triple (4368,4468,4536),229)
			Result.put (new_triple (4368,4468,4537),230)
			Result.put (new_triple (4368,4468,4538),231)
			Result.put (new_triple (4368,4468,4539),232)
			Result.put (new_triple (4368,4468,4540),233)
			Result.put (new_triple (4368,4468,4541),234)
			Result.put (new_triple (4368,4468,4542),235)
			Result.put (new_triple (4368,4468,4543),236)
			Result.put (new_triple (4368,4468,4544),237)
			Result.put (new_triple (4368,4468,4545),238)
			Result.put (new_triple (4368,4468,4546),239)
			Result.put (new_pair (4368,4469),240)
			Result.put (new_triple (4368,4469,4520),241)
			Result.put (new_triple (4368,4469,4521),242)
			Result.put (new_triple (4368,4469,4522),243)
			Result.put (new_triple (4368,4469,4523),244)
			Result.put (new_triple (4368,4469,4524),245)
			Result.put (new_triple (4368,4469,4525),246)
			Result.put (new_triple (4368,4469,4526),247)
			Result.put (new_triple (4368,4469,4527),248)
			Result.put (new_triple (4368,4469,4528),249)
			Result.put (new_triple (4368,4469,4529),250)
			Result.put (new_triple (4368,4469,4530),251)
			Result.put (new_triple (4368,4469,4531),252)
			Result.put (new_triple (4368,4469,4532),253)
			Result.put (new_triple (4368,4469,4533),254)
			Result.put (new_triple (4368,4469,4534),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_211: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4368,4469,4535),0)
			Result.put (new_triple (4368,4469,4536),1)
			Result.put (new_triple (4368,4469,4537),2)
			Result.put (new_triple (4368,4469,4538),3)
			Result.put (new_triple (4368,4469,4539),4)
			Result.put (new_triple (4368,4469,4540),5)
			Result.put (new_triple (4368,4469,4541),6)
			Result.put (new_triple (4368,4469,4542),7)
			Result.put (new_triple (4368,4469,4543),8)
			Result.put (new_triple (4368,4469,4544),9)
			Result.put (new_triple (4368,4469,4545),10)
			Result.put (new_triple (4368,4469,4546),11)
			Result.put (new_pair (4369,4449),12)
			Result.put (new_triple (4369,4449,4520),13)
			Result.put (new_triple (4369,4449,4521),14)
			Result.put (new_triple (4369,4449,4522),15)
			Result.put (new_triple (4369,4449,4523),16)
			Result.put (new_triple (4369,4449,4524),17)
			Result.put (new_triple (4369,4449,4525),18)
			Result.put (new_triple (4369,4449,4526),19)
			Result.put (new_triple (4369,4449,4527),20)
			Result.put (new_triple (4369,4449,4528),21)
			Result.put (new_triple (4369,4449,4529),22)
			Result.put (new_triple (4369,4449,4530),23)
			Result.put (new_triple (4369,4449,4531),24)
			Result.put (new_triple (4369,4449,4532),25)
			Result.put (new_triple (4369,4449,4533),26)
			Result.put (new_triple (4369,4449,4534),27)
			Result.put (new_triple (4369,4449,4535),28)
			Result.put (new_triple (4369,4449,4536),29)
			Result.put (new_triple (4369,4449,4537),30)
			Result.put (new_triple (4369,4449,4538),31)
			Result.put (new_triple (4369,4449,4539),32)
			Result.put (new_triple (4369,4449,4540),33)
			Result.put (new_triple (4369,4449,4541),34)
			Result.put (new_triple (4369,4449,4542),35)
			Result.put (new_triple (4369,4449,4543),36)
			Result.put (new_triple (4369,4449,4544),37)
			Result.put (new_triple (4369,4449,4545),38)
			Result.put (new_triple (4369,4449,4546),39)
			Result.put (new_pair (4369,4450),40)
			Result.put (new_triple (4369,4450,4520),41)
			Result.put (new_triple (4369,4450,4521),42)
			Result.put (new_triple (4369,4450,4522),43)
			Result.put (new_triple (4369,4450,4523),44)
			Result.put (new_triple (4369,4450,4524),45)
			Result.put (new_triple (4369,4450,4525),46)
			Result.put (new_triple (4369,4450,4526),47)
			Result.put (new_triple (4369,4450,4527),48)
			Result.put (new_triple (4369,4450,4528),49)
			Result.put (new_triple (4369,4450,4529),50)
			Result.put (new_triple (4369,4450,4530),51)
			Result.put (new_triple (4369,4450,4531),52)
			Result.put (new_triple (4369,4450,4532),53)
			Result.put (new_triple (4369,4450,4533),54)
			Result.put (new_triple (4369,4450,4534),55)
			Result.put (new_triple (4369,4450,4535),56)
			Result.put (new_triple (4369,4450,4536),57)
			Result.put (new_triple (4369,4450,4537),58)
			Result.put (new_triple (4369,4450,4538),59)
			Result.put (new_triple (4369,4450,4539),60)
			Result.put (new_triple (4369,4450,4540),61)
			Result.put (new_triple (4369,4450,4541),62)
			Result.put (new_triple (4369,4450,4542),63)
			Result.put (new_triple (4369,4450,4543),64)
			Result.put (new_triple (4369,4450,4544),65)
			Result.put (new_triple (4369,4450,4545),66)
			Result.put (new_triple (4369,4450,4546),67)
			Result.put (new_pair (4369,4451),68)
			Result.put (new_triple (4369,4451,4520),69)
			Result.put (new_triple (4369,4451,4521),70)
			Result.put (new_triple (4369,4451,4522),71)
			Result.put (new_triple (4369,4451,4523),72)
			Result.put (new_triple (4369,4451,4524),73)
			Result.put (new_triple (4369,4451,4525),74)
			Result.put (new_triple (4369,4451,4526),75)
			Result.put (new_triple (4369,4451,4527),76)
			Result.put (new_triple (4369,4451,4528),77)
			Result.put (new_triple (4369,4451,4529),78)
			Result.put (new_triple (4369,4451,4530),79)
			Result.put (new_triple (4369,4451,4531),80)
			Result.put (new_triple (4369,4451,4532),81)
			Result.put (new_triple (4369,4451,4533),82)
			Result.put (new_triple (4369,4451,4534),83)
			Result.put (new_triple (4369,4451,4535),84)
			Result.put (new_triple (4369,4451,4536),85)
			Result.put (new_triple (4369,4451,4537),86)
			Result.put (new_triple (4369,4451,4538),87)
			Result.put (new_triple (4369,4451,4539),88)
			Result.put (new_triple (4369,4451,4540),89)
			Result.put (new_triple (4369,4451,4541),90)
			Result.put (new_triple (4369,4451,4542),91)
			Result.put (new_triple (4369,4451,4543),92)
			Result.put (new_triple (4369,4451,4544),93)
			Result.put (new_triple (4369,4451,4545),94)
			Result.put (new_triple (4369,4451,4546),95)
			Result.put (new_pair (4369,4452),96)
			Result.put (new_triple (4369,4452,4520),97)
			Result.put (new_triple (4369,4452,4521),98)
			Result.put (new_triple (4369,4452,4522),99)
			Result.put (new_triple (4369,4452,4523),100)
			Result.put (new_triple (4369,4452,4524),101)
			Result.put (new_triple (4369,4452,4525),102)
			Result.put (new_triple (4369,4452,4526),103)
			Result.put (new_triple (4369,4452,4527),104)
			Result.put (new_triple (4369,4452,4528),105)
			Result.put (new_triple (4369,4452,4529),106)
			Result.put (new_triple (4369,4452,4530),107)
			Result.put (new_triple (4369,4452,4531),108)
			Result.put (new_triple (4369,4452,4532),109)
			Result.put (new_triple (4369,4452,4533),110)
			Result.put (new_triple (4369,4452,4534),111)
			Result.put (new_triple (4369,4452,4535),112)
			Result.put (new_triple (4369,4452,4536),113)
			Result.put (new_triple (4369,4452,4537),114)
			Result.put (new_triple (4369,4452,4538),115)
			Result.put (new_triple (4369,4452,4539),116)
			Result.put (new_triple (4369,4452,4540),117)
			Result.put (new_triple (4369,4452,4541),118)
			Result.put (new_triple (4369,4452,4542),119)
			Result.put (new_triple (4369,4452,4543),120)
			Result.put (new_triple (4369,4452,4544),121)
			Result.put (new_triple (4369,4452,4545),122)
			Result.put (new_triple (4369,4452,4546),123)
			Result.put (new_pair (4369,4453),124)
			Result.put (new_triple (4369,4453,4520),125)
			Result.put (new_triple (4369,4453,4521),126)
			Result.put (new_triple (4369,4453,4522),127)
			Result.put (new_triple (4369,4453,4523),128)
			Result.put (new_triple (4369,4453,4524),129)
			Result.put (new_triple (4369,4453,4525),130)
			Result.put (new_triple (4369,4453,4526),131)
			Result.put (new_triple (4369,4453,4527),132)
			Result.put (new_triple (4369,4453,4528),133)
			Result.put (new_triple (4369,4453,4529),134)
			Result.put (new_triple (4369,4453,4530),135)
			Result.put (new_triple (4369,4453,4531),136)
			Result.put (new_triple (4369,4453,4532),137)
			Result.put (new_triple (4369,4453,4533),138)
			Result.put (new_triple (4369,4453,4534),139)
			Result.put (new_triple (4369,4453,4535),140)
			Result.put (new_triple (4369,4453,4536),141)
			Result.put (new_triple (4369,4453,4537),142)
			Result.put (new_triple (4369,4453,4538),143)
			Result.put (new_triple (4369,4453,4539),144)
			Result.put (new_triple (4369,4453,4540),145)
			Result.put (new_triple (4369,4453,4541),146)
			Result.put (new_triple (4369,4453,4542),147)
			Result.put (new_triple (4369,4453,4543),148)
			Result.put (new_triple (4369,4453,4544),149)
			Result.put (new_triple (4369,4453,4545),150)
			Result.put (new_triple (4369,4453,4546),151)
			Result.put (new_pair (4369,4454),152)
			Result.put (new_triple (4369,4454,4520),153)
			Result.put (new_triple (4369,4454,4521),154)
			Result.put (new_triple (4369,4454,4522),155)
			Result.put (new_triple (4369,4454,4523),156)
			Result.put (new_triple (4369,4454,4524),157)
			Result.put (new_triple (4369,4454,4525),158)
			Result.put (new_triple (4369,4454,4526),159)
			Result.put (new_triple (4369,4454,4527),160)
			Result.put (new_triple (4369,4454,4528),161)
			Result.put (new_triple (4369,4454,4529),162)
			Result.put (new_triple (4369,4454,4530),163)
			Result.put (new_triple (4369,4454,4531),164)
			Result.put (new_triple (4369,4454,4532),165)
			Result.put (new_triple (4369,4454,4533),166)
			Result.put (new_triple (4369,4454,4534),167)
			Result.put (new_triple (4369,4454,4535),168)
			Result.put (new_triple (4369,4454,4536),169)
			Result.put (new_triple (4369,4454,4537),170)
			Result.put (new_triple (4369,4454,4538),171)
			Result.put (new_triple (4369,4454,4539),172)
			Result.put (new_triple (4369,4454,4540),173)
			Result.put (new_triple (4369,4454,4541),174)
			Result.put (new_triple (4369,4454,4542),175)
			Result.put (new_triple (4369,4454,4543),176)
			Result.put (new_triple (4369,4454,4544),177)
			Result.put (new_triple (4369,4454,4545),178)
			Result.put (new_triple (4369,4454,4546),179)
			Result.put (new_pair (4369,4455),180)
			Result.put (new_triple (4369,4455,4520),181)
			Result.put (new_triple (4369,4455,4521),182)
			Result.put (new_triple (4369,4455,4522),183)
			Result.put (new_triple (4369,4455,4523),184)
			Result.put (new_triple (4369,4455,4524),185)
			Result.put (new_triple (4369,4455,4525),186)
			Result.put (new_triple (4369,4455,4526),187)
			Result.put (new_triple (4369,4455,4527),188)
			Result.put (new_triple (4369,4455,4528),189)
			Result.put (new_triple (4369,4455,4529),190)
			Result.put (new_triple (4369,4455,4530),191)
			Result.put (new_triple (4369,4455,4531),192)
			Result.put (new_triple (4369,4455,4532),193)
			Result.put (new_triple (4369,4455,4533),194)
			Result.put (new_triple (4369,4455,4534),195)
			Result.put (new_triple (4369,4455,4535),196)
			Result.put (new_triple (4369,4455,4536),197)
			Result.put (new_triple (4369,4455,4537),198)
			Result.put (new_triple (4369,4455,4538),199)
			Result.put (new_triple (4369,4455,4539),200)
			Result.put (new_triple (4369,4455,4540),201)
			Result.put (new_triple (4369,4455,4541),202)
			Result.put (new_triple (4369,4455,4542),203)
			Result.put (new_triple (4369,4455,4543),204)
			Result.put (new_triple (4369,4455,4544),205)
			Result.put (new_triple (4369,4455,4545),206)
			Result.put (new_triple (4369,4455,4546),207)
			Result.put (new_pair (4369,4456),208)
			Result.put (new_triple (4369,4456,4520),209)
			Result.put (new_triple (4369,4456,4521),210)
			Result.put (new_triple (4369,4456,4522),211)
			Result.put (new_triple (4369,4456,4523),212)
			Result.put (new_triple (4369,4456,4524),213)
			Result.put (new_triple (4369,4456,4525),214)
			Result.put (new_triple (4369,4456,4526),215)
			Result.put (new_triple (4369,4456,4527),216)
			Result.put (new_triple (4369,4456,4528),217)
			Result.put (new_triple (4369,4456,4529),218)
			Result.put (new_triple (4369,4456,4530),219)
			Result.put (new_triple (4369,4456,4531),220)
			Result.put (new_triple (4369,4456,4532),221)
			Result.put (new_triple (4369,4456,4533),222)
			Result.put (new_triple (4369,4456,4534),223)
			Result.put (new_triple (4369,4456,4535),224)
			Result.put (new_triple (4369,4456,4536),225)
			Result.put (new_triple (4369,4456,4537),226)
			Result.put (new_triple (4369,4456,4538),227)
			Result.put (new_triple (4369,4456,4539),228)
			Result.put (new_triple (4369,4456,4540),229)
			Result.put (new_triple (4369,4456,4541),230)
			Result.put (new_triple (4369,4456,4542),231)
			Result.put (new_triple (4369,4456,4543),232)
			Result.put (new_triple (4369,4456,4544),233)
			Result.put (new_triple (4369,4456,4545),234)
			Result.put (new_triple (4369,4456,4546),235)
			Result.put (new_pair (4369,4457),236)
			Result.put (new_triple (4369,4457,4520),237)
			Result.put (new_triple (4369,4457,4521),238)
			Result.put (new_triple (4369,4457,4522),239)
			Result.put (new_triple (4369,4457,4523),240)
			Result.put (new_triple (4369,4457,4524),241)
			Result.put (new_triple (4369,4457,4525),242)
			Result.put (new_triple (4369,4457,4526),243)
			Result.put (new_triple (4369,4457,4527),244)
			Result.put (new_triple (4369,4457,4528),245)
			Result.put (new_triple (4369,4457,4529),246)
			Result.put (new_triple (4369,4457,4530),247)
			Result.put (new_triple (4369,4457,4531),248)
			Result.put (new_triple (4369,4457,4532),249)
			Result.put (new_triple (4369,4457,4533),250)
			Result.put (new_triple (4369,4457,4534),251)
			Result.put (new_triple (4369,4457,4535),252)
			Result.put (new_triple (4369,4457,4536),253)
			Result.put (new_triple (4369,4457,4537),254)
			Result.put (new_triple (4369,4457,4538),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_212: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4369,4457,4539),0)
			Result.put (new_triple (4369,4457,4540),1)
			Result.put (new_triple (4369,4457,4541),2)
			Result.put (new_triple (4369,4457,4542),3)
			Result.put (new_triple (4369,4457,4543),4)
			Result.put (new_triple (4369,4457,4544),5)
			Result.put (new_triple (4369,4457,4545),6)
			Result.put (new_triple (4369,4457,4546),7)
			Result.put (new_pair (4369,4458),8)
			Result.put (new_triple (4369,4458,4520),9)
			Result.put (new_triple (4369,4458,4521),10)
			Result.put (new_triple (4369,4458,4522),11)
			Result.put (new_triple (4369,4458,4523),12)
			Result.put (new_triple (4369,4458,4524),13)
			Result.put (new_triple (4369,4458,4525),14)
			Result.put (new_triple (4369,4458,4526),15)
			Result.put (new_triple (4369,4458,4527),16)
			Result.put (new_triple (4369,4458,4528),17)
			Result.put (new_triple (4369,4458,4529),18)
			Result.put (new_triple (4369,4458,4530),19)
			Result.put (new_triple (4369,4458,4531),20)
			Result.put (new_triple (4369,4458,4532),21)
			Result.put (new_triple (4369,4458,4533),22)
			Result.put (new_triple (4369,4458,4534),23)
			Result.put (new_triple (4369,4458,4535),24)
			Result.put (new_triple (4369,4458,4536),25)
			Result.put (new_triple (4369,4458,4537),26)
			Result.put (new_triple (4369,4458,4538),27)
			Result.put (new_triple (4369,4458,4539),28)
			Result.put (new_triple (4369,4458,4540),29)
			Result.put (new_triple (4369,4458,4541),30)
			Result.put (new_triple (4369,4458,4542),31)
			Result.put (new_triple (4369,4458,4543),32)
			Result.put (new_triple (4369,4458,4544),33)
			Result.put (new_triple (4369,4458,4545),34)
			Result.put (new_triple (4369,4458,4546),35)
			Result.put (new_pair (4369,4459),36)
			Result.put (new_triple (4369,4459,4520),37)
			Result.put (new_triple (4369,4459,4521),38)
			Result.put (new_triple (4369,4459,4522),39)
			Result.put (new_triple (4369,4459,4523),40)
			Result.put (new_triple (4369,4459,4524),41)
			Result.put (new_triple (4369,4459,4525),42)
			Result.put (new_triple (4369,4459,4526),43)
			Result.put (new_triple (4369,4459,4527),44)
			Result.put (new_triple (4369,4459,4528),45)
			Result.put (new_triple (4369,4459,4529),46)
			Result.put (new_triple (4369,4459,4530),47)
			Result.put (new_triple (4369,4459,4531),48)
			Result.put (new_triple (4369,4459,4532),49)
			Result.put (new_triple (4369,4459,4533),50)
			Result.put (new_triple (4369,4459,4534),51)
			Result.put (new_triple (4369,4459,4535),52)
			Result.put (new_triple (4369,4459,4536),53)
			Result.put (new_triple (4369,4459,4537),54)
			Result.put (new_triple (4369,4459,4538),55)
			Result.put (new_triple (4369,4459,4539),56)
			Result.put (new_triple (4369,4459,4540),57)
			Result.put (new_triple (4369,4459,4541),58)
			Result.put (new_triple (4369,4459,4542),59)
			Result.put (new_triple (4369,4459,4543),60)
			Result.put (new_triple (4369,4459,4544),61)
			Result.put (new_triple (4369,4459,4545),62)
			Result.put (new_triple (4369,4459,4546),63)
			Result.put (new_pair (4369,4460),64)
			Result.put (new_triple (4369,4460,4520),65)
			Result.put (new_triple (4369,4460,4521),66)
			Result.put (new_triple (4369,4460,4522),67)
			Result.put (new_triple (4369,4460,4523),68)
			Result.put (new_triple (4369,4460,4524),69)
			Result.put (new_triple (4369,4460,4525),70)
			Result.put (new_triple (4369,4460,4526),71)
			Result.put (new_triple (4369,4460,4527),72)
			Result.put (new_triple (4369,4460,4528),73)
			Result.put (new_triple (4369,4460,4529),74)
			Result.put (new_triple (4369,4460,4530),75)
			Result.put (new_triple (4369,4460,4531),76)
			Result.put (new_triple (4369,4460,4532),77)
			Result.put (new_triple (4369,4460,4533),78)
			Result.put (new_triple (4369,4460,4534),79)
			Result.put (new_triple (4369,4460,4535),80)
			Result.put (new_triple (4369,4460,4536),81)
			Result.put (new_triple (4369,4460,4537),82)
			Result.put (new_triple (4369,4460,4538),83)
			Result.put (new_triple (4369,4460,4539),84)
			Result.put (new_triple (4369,4460,4540),85)
			Result.put (new_triple (4369,4460,4541),86)
			Result.put (new_triple (4369,4460,4542),87)
			Result.put (new_triple (4369,4460,4543),88)
			Result.put (new_triple (4369,4460,4544),89)
			Result.put (new_triple (4369,4460,4545),90)
			Result.put (new_triple (4369,4460,4546),91)
			Result.put (new_pair (4369,4461),92)
			Result.put (new_triple (4369,4461,4520),93)
			Result.put (new_triple (4369,4461,4521),94)
			Result.put (new_triple (4369,4461,4522),95)
			Result.put (new_triple (4369,4461,4523),96)
			Result.put (new_triple (4369,4461,4524),97)
			Result.put (new_triple (4369,4461,4525),98)
			Result.put (new_triple (4369,4461,4526),99)
			Result.put (new_triple (4369,4461,4527),100)
			Result.put (new_triple (4369,4461,4528),101)
			Result.put (new_triple (4369,4461,4529),102)
			Result.put (new_triple (4369,4461,4530),103)
			Result.put (new_triple (4369,4461,4531),104)
			Result.put (new_triple (4369,4461,4532),105)
			Result.put (new_triple (4369,4461,4533),106)
			Result.put (new_triple (4369,4461,4534),107)
			Result.put (new_triple (4369,4461,4535),108)
			Result.put (new_triple (4369,4461,4536),109)
			Result.put (new_triple (4369,4461,4537),110)
			Result.put (new_triple (4369,4461,4538),111)
			Result.put (new_triple (4369,4461,4539),112)
			Result.put (new_triple (4369,4461,4540),113)
			Result.put (new_triple (4369,4461,4541),114)
			Result.put (new_triple (4369,4461,4542),115)
			Result.put (new_triple (4369,4461,4543),116)
			Result.put (new_triple (4369,4461,4544),117)
			Result.put (new_triple (4369,4461,4545),118)
			Result.put (new_triple (4369,4461,4546),119)
			Result.put (new_pair (4369,4462),120)
			Result.put (new_triple (4369,4462,4520),121)
			Result.put (new_triple (4369,4462,4521),122)
			Result.put (new_triple (4369,4462,4522),123)
			Result.put (new_triple (4369,4462,4523),124)
			Result.put (new_triple (4369,4462,4524),125)
			Result.put (new_triple (4369,4462,4525),126)
			Result.put (new_triple (4369,4462,4526),127)
			Result.put (new_triple (4369,4462,4527),128)
			Result.put (new_triple (4369,4462,4528),129)
			Result.put (new_triple (4369,4462,4529),130)
			Result.put (new_triple (4369,4462,4530),131)
			Result.put (new_triple (4369,4462,4531),132)
			Result.put (new_triple (4369,4462,4532),133)
			Result.put (new_triple (4369,4462,4533),134)
			Result.put (new_triple (4369,4462,4534),135)
			Result.put (new_triple (4369,4462,4535),136)
			Result.put (new_triple (4369,4462,4536),137)
			Result.put (new_triple (4369,4462,4537),138)
			Result.put (new_triple (4369,4462,4538),139)
			Result.put (new_triple (4369,4462,4539),140)
			Result.put (new_triple (4369,4462,4540),141)
			Result.put (new_triple (4369,4462,4541),142)
			Result.put (new_triple (4369,4462,4542),143)
			Result.put (new_triple (4369,4462,4543),144)
			Result.put (new_triple (4369,4462,4544),145)
			Result.put (new_triple (4369,4462,4545),146)
			Result.put (new_triple (4369,4462,4546),147)
			Result.put (new_pair (4369,4463),148)
			Result.put (new_triple (4369,4463,4520),149)
			Result.put (new_triple (4369,4463,4521),150)
			Result.put (new_triple (4369,4463,4522),151)
			Result.put (new_triple (4369,4463,4523),152)
			Result.put (new_triple (4369,4463,4524),153)
			Result.put (new_triple (4369,4463,4525),154)
			Result.put (new_triple (4369,4463,4526),155)
			Result.put (new_triple (4369,4463,4527),156)
			Result.put (new_triple (4369,4463,4528),157)
			Result.put (new_triple (4369,4463,4529),158)
			Result.put (new_triple (4369,4463,4530),159)
			Result.put (new_triple (4369,4463,4531),160)
			Result.put (new_triple (4369,4463,4532),161)
			Result.put (new_triple (4369,4463,4533),162)
			Result.put (new_triple (4369,4463,4534),163)
			Result.put (new_triple (4369,4463,4535),164)
			Result.put (new_triple (4369,4463,4536),165)
			Result.put (new_triple (4369,4463,4537),166)
			Result.put (new_triple (4369,4463,4538),167)
			Result.put (new_triple (4369,4463,4539),168)
			Result.put (new_triple (4369,4463,4540),169)
			Result.put (new_triple (4369,4463,4541),170)
			Result.put (new_triple (4369,4463,4542),171)
			Result.put (new_triple (4369,4463,4543),172)
			Result.put (new_triple (4369,4463,4544),173)
			Result.put (new_triple (4369,4463,4545),174)
			Result.put (new_triple (4369,4463,4546),175)
			Result.put (new_pair (4369,4464),176)
			Result.put (new_triple (4369,4464,4520),177)
			Result.put (new_triple (4369,4464,4521),178)
			Result.put (new_triple (4369,4464,4522),179)
			Result.put (new_triple (4369,4464,4523),180)
			Result.put (new_triple (4369,4464,4524),181)
			Result.put (new_triple (4369,4464,4525),182)
			Result.put (new_triple (4369,4464,4526),183)
			Result.put (new_triple (4369,4464,4527),184)
			Result.put (new_triple (4369,4464,4528),185)
			Result.put (new_triple (4369,4464,4529),186)
			Result.put (new_triple (4369,4464,4530),187)
			Result.put (new_triple (4369,4464,4531),188)
			Result.put (new_triple (4369,4464,4532),189)
			Result.put (new_triple (4369,4464,4533),190)
			Result.put (new_triple (4369,4464,4534),191)
			Result.put (new_triple (4369,4464,4535),192)
			Result.put (new_triple (4369,4464,4536),193)
			Result.put (new_triple (4369,4464,4537),194)
			Result.put (new_triple (4369,4464,4538),195)
			Result.put (new_triple (4369,4464,4539),196)
			Result.put (new_triple (4369,4464,4540),197)
			Result.put (new_triple (4369,4464,4541),198)
			Result.put (new_triple (4369,4464,4542),199)
			Result.put (new_triple (4369,4464,4543),200)
			Result.put (new_triple (4369,4464,4544),201)
			Result.put (new_triple (4369,4464,4545),202)
			Result.put (new_triple (4369,4464,4546),203)
			Result.put (new_pair (4369,4465),204)
			Result.put (new_triple (4369,4465,4520),205)
			Result.put (new_triple (4369,4465,4521),206)
			Result.put (new_triple (4369,4465,4522),207)
			Result.put (new_triple (4369,4465,4523),208)
			Result.put (new_triple (4369,4465,4524),209)
			Result.put (new_triple (4369,4465,4525),210)
			Result.put (new_triple (4369,4465,4526),211)
			Result.put (new_triple (4369,4465,4527),212)
			Result.put (new_triple (4369,4465,4528),213)
			Result.put (new_triple (4369,4465,4529),214)
			Result.put (new_triple (4369,4465,4530),215)
			Result.put (new_triple (4369,4465,4531),216)
			Result.put (new_triple (4369,4465,4532),217)
			Result.put (new_triple (4369,4465,4533),218)
			Result.put (new_triple (4369,4465,4534),219)
			Result.put (new_triple (4369,4465,4535),220)
			Result.put (new_triple (4369,4465,4536),221)
			Result.put (new_triple (4369,4465,4537),222)
			Result.put (new_triple (4369,4465,4538),223)
			Result.put (new_triple (4369,4465,4539),224)
			Result.put (new_triple (4369,4465,4540),225)
			Result.put (new_triple (4369,4465,4541),226)
			Result.put (new_triple (4369,4465,4542),227)
			Result.put (new_triple (4369,4465,4543),228)
			Result.put (new_triple (4369,4465,4544),229)
			Result.put (new_triple (4369,4465,4545),230)
			Result.put (new_triple (4369,4465,4546),231)
			Result.put (new_pair (4369,4466),232)
			Result.put (new_triple (4369,4466,4520),233)
			Result.put (new_triple (4369,4466,4521),234)
			Result.put (new_triple (4369,4466,4522),235)
			Result.put (new_triple (4369,4466,4523),236)
			Result.put (new_triple (4369,4466,4524),237)
			Result.put (new_triple (4369,4466,4525),238)
			Result.put (new_triple (4369,4466,4526),239)
			Result.put (new_triple (4369,4466,4527),240)
			Result.put (new_triple (4369,4466,4528),241)
			Result.put (new_triple (4369,4466,4529),242)
			Result.put (new_triple (4369,4466,4530),243)
			Result.put (new_triple (4369,4466,4531),244)
			Result.put (new_triple (4369,4466,4532),245)
			Result.put (new_triple (4369,4466,4533),246)
			Result.put (new_triple (4369,4466,4534),247)
			Result.put (new_triple (4369,4466,4535),248)
			Result.put (new_triple (4369,4466,4536),249)
			Result.put (new_triple (4369,4466,4537),250)
			Result.put (new_triple (4369,4466,4538),251)
			Result.put (new_triple (4369,4466,4539),252)
			Result.put (new_triple (4369,4466,4540),253)
			Result.put (new_triple (4369,4466,4541),254)
			Result.put (new_triple (4369,4466,4542),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_213: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4369,4466,4543),0)
			Result.put (new_triple (4369,4466,4544),1)
			Result.put (new_triple (4369,4466,4545),2)
			Result.put (new_triple (4369,4466,4546),3)
			Result.put (new_pair (4369,4467),4)
			Result.put (new_triple (4369,4467,4520),5)
			Result.put (new_triple (4369,4467,4521),6)
			Result.put (new_triple (4369,4467,4522),7)
			Result.put (new_triple (4369,4467,4523),8)
			Result.put (new_triple (4369,4467,4524),9)
			Result.put (new_triple (4369,4467,4525),10)
			Result.put (new_triple (4369,4467,4526),11)
			Result.put (new_triple (4369,4467,4527),12)
			Result.put (new_triple (4369,4467,4528),13)
			Result.put (new_triple (4369,4467,4529),14)
			Result.put (new_triple (4369,4467,4530),15)
			Result.put (new_triple (4369,4467,4531),16)
			Result.put (new_triple (4369,4467,4532),17)
			Result.put (new_triple (4369,4467,4533),18)
			Result.put (new_triple (4369,4467,4534),19)
			Result.put (new_triple (4369,4467,4535),20)
			Result.put (new_triple (4369,4467,4536),21)
			Result.put (new_triple (4369,4467,4537),22)
			Result.put (new_triple (4369,4467,4538),23)
			Result.put (new_triple (4369,4467,4539),24)
			Result.put (new_triple (4369,4467,4540),25)
			Result.put (new_triple (4369,4467,4541),26)
			Result.put (new_triple (4369,4467,4542),27)
			Result.put (new_triple (4369,4467,4543),28)
			Result.put (new_triple (4369,4467,4544),29)
			Result.put (new_triple (4369,4467,4545),30)
			Result.put (new_triple (4369,4467,4546),31)
			Result.put (new_pair (4369,4468),32)
			Result.put (new_triple (4369,4468,4520),33)
			Result.put (new_triple (4369,4468,4521),34)
			Result.put (new_triple (4369,4468,4522),35)
			Result.put (new_triple (4369,4468,4523),36)
			Result.put (new_triple (4369,4468,4524),37)
			Result.put (new_triple (4369,4468,4525),38)
			Result.put (new_triple (4369,4468,4526),39)
			Result.put (new_triple (4369,4468,4527),40)
			Result.put (new_triple (4369,4468,4528),41)
			Result.put (new_triple (4369,4468,4529),42)
			Result.put (new_triple (4369,4468,4530),43)
			Result.put (new_triple (4369,4468,4531),44)
			Result.put (new_triple (4369,4468,4532),45)
			Result.put (new_triple (4369,4468,4533),46)
			Result.put (new_triple (4369,4468,4534),47)
			Result.put (new_triple (4369,4468,4535),48)
			Result.put (new_triple (4369,4468,4536),49)
			Result.put (new_triple (4369,4468,4537),50)
			Result.put (new_triple (4369,4468,4538),51)
			Result.put (new_triple (4369,4468,4539),52)
			Result.put (new_triple (4369,4468,4540),53)
			Result.put (new_triple (4369,4468,4541),54)
			Result.put (new_triple (4369,4468,4542),55)
			Result.put (new_triple (4369,4468,4543),56)
			Result.put (new_triple (4369,4468,4544),57)
			Result.put (new_triple (4369,4468,4545),58)
			Result.put (new_triple (4369,4468,4546),59)
			Result.put (new_pair (4369,4469),60)
			Result.put (new_triple (4369,4469,4520),61)
			Result.put (new_triple (4369,4469,4521),62)
			Result.put (new_triple (4369,4469,4522),63)
			Result.put (new_triple (4369,4469,4523),64)
			Result.put (new_triple (4369,4469,4524),65)
			Result.put (new_triple (4369,4469,4525),66)
			Result.put (new_triple (4369,4469,4526),67)
			Result.put (new_triple (4369,4469,4527),68)
			Result.put (new_triple (4369,4469,4528),69)
			Result.put (new_triple (4369,4469,4529),70)
			Result.put (new_triple (4369,4469,4530),71)
			Result.put (new_triple (4369,4469,4531),72)
			Result.put (new_triple (4369,4469,4532),73)
			Result.put (new_triple (4369,4469,4533),74)
			Result.put (new_triple (4369,4469,4534),75)
			Result.put (new_triple (4369,4469,4535),76)
			Result.put (new_triple (4369,4469,4536),77)
			Result.put (new_triple (4369,4469,4537),78)
			Result.put (new_triple (4369,4469,4538),79)
			Result.put (new_triple (4369,4469,4539),80)
			Result.put (new_triple (4369,4469,4540),81)
			Result.put (new_triple (4369,4469,4541),82)
			Result.put (new_triple (4369,4469,4542),83)
			Result.put (new_triple (4369,4469,4543),84)
			Result.put (new_triple (4369,4469,4544),85)
			Result.put (new_triple (4369,4469,4545),86)
			Result.put (new_triple (4369,4469,4546),87)
			Result.put (new_pair (4370,4449),88)
			Result.put (new_triple (4370,4449,4520),89)
			Result.put (new_triple (4370,4449,4521),90)
			Result.put (new_triple (4370,4449,4522),91)
			Result.put (new_triple (4370,4449,4523),92)
			Result.put (new_triple (4370,4449,4524),93)
			Result.put (new_triple (4370,4449,4525),94)
			Result.put (new_triple (4370,4449,4526),95)
			Result.put (new_triple (4370,4449,4527),96)
			Result.put (new_triple (4370,4449,4528),97)
			Result.put (new_triple (4370,4449,4529),98)
			Result.put (new_triple (4370,4449,4530),99)
			Result.put (new_triple (4370,4449,4531),100)
			Result.put (new_triple (4370,4449,4532),101)
			Result.put (new_triple (4370,4449,4533),102)
			Result.put (new_triple (4370,4449,4534),103)
			Result.put (new_triple (4370,4449,4535),104)
			Result.put (new_triple (4370,4449,4536),105)
			Result.put (new_triple (4370,4449,4537),106)
			Result.put (new_triple (4370,4449,4538),107)
			Result.put (new_triple (4370,4449,4539),108)
			Result.put (new_triple (4370,4449,4540),109)
			Result.put (new_triple (4370,4449,4541),110)
			Result.put (new_triple (4370,4449,4542),111)
			Result.put (new_triple (4370,4449,4543),112)
			Result.put (new_triple (4370,4449,4544),113)
			Result.put (new_triple (4370,4449,4545),114)
			Result.put (new_triple (4370,4449,4546),115)
			Result.put (new_pair (4370,4450),116)
			Result.put (new_triple (4370,4450,4520),117)
			Result.put (new_triple (4370,4450,4521),118)
			Result.put (new_triple (4370,4450,4522),119)
			Result.put (new_triple (4370,4450,4523),120)
			Result.put (new_triple (4370,4450,4524),121)
			Result.put (new_triple (4370,4450,4525),122)
			Result.put (new_triple (4370,4450,4526),123)
			Result.put (new_triple (4370,4450,4527),124)
			Result.put (new_triple (4370,4450,4528),125)
			Result.put (new_triple (4370,4450,4529),126)
			Result.put (new_triple (4370,4450,4530),127)
			Result.put (new_triple (4370,4450,4531),128)
			Result.put (new_triple (4370,4450,4532),129)
			Result.put (new_triple (4370,4450,4533),130)
			Result.put (new_triple (4370,4450,4534),131)
			Result.put (new_triple (4370,4450,4535),132)
			Result.put (new_triple (4370,4450,4536),133)
			Result.put (new_triple (4370,4450,4537),134)
			Result.put (new_triple (4370,4450,4538),135)
			Result.put (new_triple (4370,4450,4539),136)
			Result.put (new_triple (4370,4450,4540),137)
			Result.put (new_triple (4370,4450,4541),138)
			Result.put (new_triple (4370,4450,4542),139)
			Result.put (new_triple (4370,4450,4543),140)
			Result.put (new_triple (4370,4450,4544),141)
			Result.put (new_triple (4370,4450,4545),142)
			Result.put (new_triple (4370,4450,4546),143)
			Result.put (new_pair (4370,4451),144)
			Result.put (new_triple (4370,4451,4520),145)
			Result.put (new_triple (4370,4451,4521),146)
			Result.put (new_triple (4370,4451,4522),147)
			Result.put (new_triple (4370,4451,4523),148)
			Result.put (new_triple (4370,4451,4524),149)
			Result.put (new_triple (4370,4451,4525),150)
			Result.put (new_triple (4370,4451,4526),151)
			Result.put (new_triple (4370,4451,4527),152)
			Result.put (new_triple (4370,4451,4528),153)
			Result.put (new_triple (4370,4451,4529),154)
			Result.put (new_triple (4370,4451,4530),155)
			Result.put (new_triple (4370,4451,4531),156)
			Result.put (new_triple (4370,4451,4532),157)
			Result.put (new_triple (4370,4451,4533),158)
			Result.put (new_triple (4370,4451,4534),159)
			Result.put (new_triple (4370,4451,4535),160)
			Result.put (new_triple (4370,4451,4536),161)
			Result.put (new_triple (4370,4451,4537),162)
			Result.put (new_triple (4370,4451,4538),163)
			Result.put (new_triple (4370,4451,4539),164)
			Result.put (new_triple (4370,4451,4540),165)
			Result.put (new_triple (4370,4451,4541),166)
			Result.put (new_triple (4370,4451,4542),167)
			Result.put (new_triple (4370,4451,4543),168)
			Result.put (new_triple (4370,4451,4544),169)
			Result.put (new_triple (4370,4451,4545),170)
			Result.put (new_triple (4370,4451,4546),171)
			Result.put (new_pair (4370,4452),172)
			Result.put (new_triple (4370,4452,4520),173)
			Result.put (new_triple (4370,4452,4521),174)
			Result.put (new_triple (4370,4452,4522),175)
			Result.put (new_triple (4370,4452,4523),176)
			Result.put (new_triple (4370,4452,4524),177)
			Result.put (new_triple (4370,4452,4525),178)
			Result.put (new_triple (4370,4452,4526),179)
			Result.put (new_triple (4370,4452,4527),180)
			Result.put (new_triple (4370,4452,4528),181)
			Result.put (new_triple (4370,4452,4529),182)
			Result.put (new_triple (4370,4452,4530),183)
			Result.put (new_triple (4370,4452,4531),184)
			Result.put (new_triple (4370,4452,4532),185)
			Result.put (new_triple (4370,4452,4533),186)
			Result.put (new_triple (4370,4452,4534),187)
			Result.put (new_triple (4370,4452,4535),188)
			Result.put (new_triple (4370,4452,4536),189)
			Result.put (new_triple (4370,4452,4537),190)
			Result.put (new_triple (4370,4452,4538),191)
			Result.put (new_triple (4370,4452,4539),192)
			Result.put (new_triple (4370,4452,4540),193)
			Result.put (new_triple (4370,4452,4541),194)
			Result.put (new_triple (4370,4452,4542),195)
			Result.put (new_triple (4370,4452,4543),196)
			Result.put (new_triple (4370,4452,4544),197)
			Result.put (new_triple (4370,4452,4545),198)
			Result.put (new_triple (4370,4452,4546),199)
			Result.put (new_pair (4370,4453),200)
			Result.put (new_triple (4370,4453,4520),201)
			Result.put (new_triple (4370,4453,4521),202)
			Result.put (new_triple (4370,4453,4522),203)
			Result.put (new_triple (4370,4453,4523),204)
			Result.put (new_triple (4370,4453,4524),205)
			Result.put (new_triple (4370,4453,4525),206)
			Result.put (new_triple (4370,4453,4526),207)
			Result.put (new_triple (4370,4453,4527),208)
			Result.put (new_triple (4370,4453,4528),209)
			Result.put (new_triple (4370,4453,4529),210)
			Result.put (new_triple (4370,4453,4530),211)
			Result.put (new_triple (4370,4453,4531),212)
			Result.put (new_triple (4370,4453,4532),213)
			Result.put (new_triple (4370,4453,4533),214)
			Result.put (new_triple (4370,4453,4534),215)
			Result.put (new_triple (4370,4453,4535),216)
			Result.put (new_triple (4370,4453,4536),217)
			Result.put (new_triple (4370,4453,4537),218)
			Result.put (new_triple (4370,4453,4538),219)
			Result.put (new_triple (4370,4453,4539),220)
			Result.put (new_triple (4370,4453,4540),221)
			Result.put (new_triple (4370,4453,4541),222)
			Result.put (new_triple (4370,4453,4542),223)
			Result.put (new_triple (4370,4453,4543),224)
			Result.put (new_triple (4370,4453,4544),225)
			Result.put (new_triple (4370,4453,4545),226)
			Result.put (new_triple (4370,4453,4546),227)
			Result.put (new_pair (4370,4454),228)
			Result.put (new_triple (4370,4454,4520),229)
			Result.put (new_triple (4370,4454,4521),230)
			Result.put (new_triple (4370,4454,4522),231)
			Result.put (new_triple (4370,4454,4523),232)
			Result.put (new_triple (4370,4454,4524),233)
			Result.put (new_triple (4370,4454,4525),234)
			Result.put (new_triple (4370,4454,4526),235)
			Result.put (new_triple (4370,4454,4527),236)
			Result.put (new_triple (4370,4454,4528),237)
			Result.put (new_triple (4370,4454,4529),238)
			Result.put (new_triple (4370,4454,4530),239)
			Result.put (new_triple (4370,4454,4531),240)
			Result.put (new_triple (4370,4454,4532),241)
			Result.put (new_triple (4370,4454,4533),242)
			Result.put (new_triple (4370,4454,4534),243)
			Result.put (new_triple (4370,4454,4535),244)
			Result.put (new_triple (4370,4454,4536),245)
			Result.put (new_triple (4370,4454,4537),246)
			Result.put (new_triple (4370,4454,4538),247)
			Result.put (new_triple (4370,4454,4539),248)
			Result.put (new_triple (4370,4454,4540),249)
			Result.put (new_triple (4370,4454,4541),250)
			Result.put (new_triple (4370,4454,4542),251)
			Result.put (new_triple (4370,4454,4543),252)
			Result.put (new_triple (4370,4454,4544),253)
			Result.put (new_triple (4370,4454,4545),254)
			Result.put (new_triple (4370,4454,4546),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_214: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (4370,4455),0)
			Result.put (new_triple (4370,4455,4520),1)
			Result.put (new_triple (4370,4455,4521),2)
			Result.put (new_triple (4370,4455,4522),3)
			Result.put (new_triple (4370,4455,4523),4)
			Result.put (new_triple (4370,4455,4524),5)
			Result.put (new_triple (4370,4455,4525),6)
			Result.put (new_triple (4370,4455,4526),7)
			Result.put (new_triple (4370,4455,4527),8)
			Result.put (new_triple (4370,4455,4528),9)
			Result.put (new_triple (4370,4455,4529),10)
			Result.put (new_triple (4370,4455,4530),11)
			Result.put (new_triple (4370,4455,4531),12)
			Result.put (new_triple (4370,4455,4532),13)
			Result.put (new_triple (4370,4455,4533),14)
			Result.put (new_triple (4370,4455,4534),15)
			Result.put (new_triple (4370,4455,4535),16)
			Result.put (new_triple (4370,4455,4536),17)
			Result.put (new_triple (4370,4455,4537),18)
			Result.put (new_triple (4370,4455,4538),19)
			Result.put (new_triple (4370,4455,4539),20)
			Result.put (new_triple (4370,4455,4540),21)
			Result.put (new_triple (4370,4455,4541),22)
			Result.put (new_triple (4370,4455,4542),23)
			Result.put (new_triple (4370,4455,4543),24)
			Result.put (new_triple (4370,4455,4544),25)
			Result.put (new_triple (4370,4455,4545),26)
			Result.put (new_triple (4370,4455,4546),27)
			Result.put (new_pair (4370,4456),28)
			Result.put (new_triple (4370,4456,4520),29)
			Result.put (new_triple (4370,4456,4521),30)
			Result.put (new_triple (4370,4456,4522),31)
			Result.put (new_triple (4370,4456,4523),32)
			Result.put (new_triple (4370,4456,4524),33)
			Result.put (new_triple (4370,4456,4525),34)
			Result.put (new_triple (4370,4456,4526),35)
			Result.put (new_triple (4370,4456,4527),36)
			Result.put (new_triple (4370,4456,4528),37)
			Result.put (new_triple (4370,4456,4529),38)
			Result.put (new_triple (4370,4456,4530),39)
			Result.put (new_triple (4370,4456,4531),40)
			Result.put (new_triple (4370,4456,4532),41)
			Result.put (new_triple (4370,4456,4533),42)
			Result.put (new_triple (4370,4456,4534),43)
			Result.put (new_triple (4370,4456,4535),44)
			Result.put (new_triple (4370,4456,4536),45)
			Result.put (new_triple (4370,4456,4537),46)
			Result.put (new_triple (4370,4456,4538),47)
			Result.put (new_triple (4370,4456,4539),48)
			Result.put (new_triple (4370,4456,4540),49)
			Result.put (new_triple (4370,4456,4541),50)
			Result.put (new_triple (4370,4456,4542),51)
			Result.put (new_triple (4370,4456,4543),52)
			Result.put (new_triple (4370,4456,4544),53)
			Result.put (new_triple (4370,4456,4545),54)
			Result.put (new_triple (4370,4456,4546),55)
			Result.put (new_pair (4370,4457),56)
			Result.put (new_triple (4370,4457,4520),57)
			Result.put (new_triple (4370,4457,4521),58)
			Result.put (new_triple (4370,4457,4522),59)
			Result.put (new_triple (4370,4457,4523),60)
			Result.put (new_triple (4370,4457,4524),61)
			Result.put (new_triple (4370,4457,4525),62)
			Result.put (new_triple (4370,4457,4526),63)
			Result.put (new_triple (4370,4457,4527),64)
			Result.put (new_triple (4370,4457,4528),65)
			Result.put (new_triple (4370,4457,4529),66)
			Result.put (new_triple (4370,4457,4530),67)
			Result.put (new_triple (4370,4457,4531),68)
			Result.put (new_triple (4370,4457,4532),69)
			Result.put (new_triple (4370,4457,4533),70)
			Result.put (new_triple (4370,4457,4534),71)
			Result.put (new_triple (4370,4457,4535),72)
			Result.put (new_triple (4370,4457,4536),73)
			Result.put (new_triple (4370,4457,4537),74)
			Result.put (new_triple (4370,4457,4538),75)
			Result.put (new_triple (4370,4457,4539),76)
			Result.put (new_triple (4370,4457,4540),77)
			Result.put (new_triple (4370,4457,4541),78)
			Result.put (new_triple (4370,4457,4542),79)
			Result.put (new_triple (4370,4457,4543),80)
			Result.put (new_triple (4370,4457,4544),81)
			Result.put (new_triple (4370,4457,4545),82)
			Result.put (new_triple (4370,4457,4546),83)
			Result.put (new_pair (4370,4458),84)
			Result.put (new_triple (4370,4458,4520),85)
			Result.put (new_triple (4370,4458,4521),86)
			Result.put (new_triple (4370,4458,4522),87)
			Result.put (new_triple (4370,4458,4523),88)
			Result.put (new_triple (4370,4458,4524),89)
			Result.put (new_triple (4370,4458,4525),90)
			Result.put (new_triple (4370,4458,4526),91)
			Result.put (new_triple (4370,4458,4527),92)
			Result.put (new_triple (4370,4458,4528),93)
			Result.put (new_triple (4370,4458,4529),94)
			Result.put (new_triple (4370,4458,4530),95)
			Result.put (new_triple (4370,4458,4531),96)
			Result.put (new_triple (4370,4458,4532),97)
			Result.put (new_triple (4370,4458,4533),98)
			Result.put (new_triple (4370,4458,4534),99)
			Result.put (new_triple (4370,4458,4535),100)
			Result.put (new_triple (4370,4458,4536),101)
			Result.put (new_triple (4370,4458,4537),102)
			Result.put (new_triple (4370,4458,4538),103)
			Result.put (new_triple (4370,4458,4539),104)
			Result.put (new_triple (4370,4458,4540),105)
			Result.put (new_triple (4370,4458,4541),106)
			Result.put (new_triple (4370,4458,4542),107)
			Result.put (new_triple (4370,4458,4543),108)
			Result.put (new_triple (4370,4458,4544),109)
			Result.put (new_triple (4370,4458,4545),110)
			Result.put (new_triple (4370,4458,4546),111)
			Result.put (new_pair (4370,4459),112)
			Result.put (new_triple (4370,4459,4520),113)
			Result.put (new_triple (4370,4459,4521),114)
			Result.put (new_triple (4370,4459,4522),115)
			Result.put (new_triple (4370,4459,4523),116)
			Result.put (new_triple (4370,4459,4524),117)
			Result.put (new_triple (4370,4459,4525),118)
			Result.put (new_triple (4370,4459,4526),119)
			Result.put (new_triple (4370,4459,4527),120)
			Result.put (new_triple (4370,4459,4528),121)
			Result.put (new_triple (4370,4459,4529),122)
			Result.put (new_triple (4370,4459,4530),123)
			Result.put (new_triple (4370,4459,4531),124)
			Result.put (new_triple (4370,4459,4532),125)
			Result.put (new_triple (4370,4459,4533),126)
			Result.put (new_triple (4370,4459,4534),127)
			Result.put (new_triple (4370,4459,4535),128)
			Result.put (new_triple (4370,4459,4536),129)
			Result.put (new_triple (4370,4459,4537),130)
			Result.put (new_triple (4370,4459,4538),131)
			Result.put (new_triple (4370,4459,4539),132)
			Result.put (new_triple (4370,4459,4540),133)
			Result.put (new_triple (4370,4459,4541),134)
			Result.put (new_triple (4370,4459,4542),135)
			Result.put (new_triple (4370,4459,4543),136)
			Result.put (new_triple (4370,4459,4544),137)
			Result.put (new_triple (4370,4459,4545),138)
			Result.put (new_triple (4370,4459,4546),139)
			Result.put (new_pair (4370,4460),140)
			Result.put (new_triple (4370,4460,4520),141)
			Result.put (new_triple (4370,4460,4521),142)
			Result.put (new_triple (4370,4460,4522),143)
			Result.put (new_triple (4370,4460,4523),144)
			Result.put (new_triple (4370,4460,4524),145)
			Result.put (new_triple (4370,4460,4525),146)
			Result.put (new_triple (4370,4460,4526),147)
			Result.put (new_triple (4370,4460,4527),148)
			Result.put (new_triple (4370,4460,4528),149)
			Result.put (new_triple (4370,4460,4529),150)
			Result.put (new_triple (4370,4460,4530),151)
			Result.put (new_triple (4370,4460,4531),152)
			Result.put (new_triple (4370,4460,4532),153)
			Result.put (new_triple (4370,4460,4533),154)
			Result.put (new_triple (4370,4460,4534),155)
			Result.put (new_triple (4370,4460,4535),156)
			Result.put (new_triple (4370,4460,4536),157)
			Result.put (new_triple (4370,4460,4537),158)
			Result.put (new_triple (4370,4460,4538),159)
			Result.put (new_triple (4370,4460,4539),160)
			Result.put (new_triple (4370,4460,4540),161)
			Result.put (new_triple (4370,4460,4541),162)
			Result.put (new_triple (4370,4460,4542),163)
			Result.put (new_triple (4370,4460,4543),164)
			Result.put (new_triple (4370,4460,4544),165)
			Result.put (new_triple (4370,4460,4545),166)
			Result.put (new_triple (4370,4460,4546),167)
			Result.put (new_pair (4370,4461),168)
			Result.put (new_triple (4370,4461,4520),169)
			Result.put (new_triple (4370,4461,4521),170)
			Result.put (new_triple (4370,4461,4522),171)
			Result.put (new_triple (4370,4461,4523),172)
			Result.put (new_triple (4370,4461,4524),173)
			Result.put (new_triple (4370,4461,4525),174)
			Result.put (new_triple (4370,4461,4526),175)
			Result.put (new_triple (4370,4461,4527),176)
			Result.put (new_triple (4370,4461,4528),177)
			Result.put (new_triple (4370,4461,4529),178)
			Result.put (new_triple (4370,4461,4530),179)
			Result.put (new_triple (4370,4461,4531),180)
			Result.put (new_triple (4370,4461,4532),181)
			Result.put (new_triple (4370,4461,4533),182)
			Result.put (new_triple (4370,4461,4534),183)
			Result.put (new_triple (4370,4461,4535),184)
			Result.put (new_triple (4370,4461,4536),185)
			Result.put (new_triple (4370,4461,4537),186)
			Result.put (new_triple (4370,4461,4538),187)
			Result.put (new_triple (4370,4461,4539),188)
			Result.put (new_triple (4370,4461,4540),189)
			Result.put (new_triple (4370,4461,4541),190)
			Result.put (new_triple (4370,4461,4542),191)
			Result.put (new_triple (4370,4461,4543),192)
			Result.put (new_triple (4370,4461,4544),193)
			Result.put (new_triple (4370,4461,4545),194)
			Result.put (new_triple (4370,4461,4546),195)
			Result.put (new_pair (4370,4462),196)
			Result.put (new_triple (4370,4462,4520),197)
			Result.put (new_triple (4370,4462,4521),198)
			Result.put (new_triple (4370,4462,4522),199)
			Result.put (new_triple (4370,4462,4523),200)
			Result.put (new_triple (4370,4462,4524),201)
			Result.put (new_triple (4370,4462,4525),202)
			Result.put (new_triple (4370,4462,4526),203)
			Result.put (new_triple (4370,4462,4527),204)
			Result.put (new_triple (4370,4462,4528),205)
			Result.put (new_triple (4370,4462,4529),206)
			Result.put (new_triple (4370,4462,4530),207)
			Result.put (new_triple (4370,4462,4531),208)
			Result.put (new_triple (4370,4462,4532),209)
			Result.put (new_triple (4370,4462,4533),210)
			Result.put (new_triple (4370,4462,4534),211)
			Result.put (new_triple (4370,4462,4535),212)
			Result.put (new_triple (4370,4462,4536),213)
			Result.put (new_triple (4370,4462,4537),214)
			Result.put (new_triple (4370,4462,4538),215)
			Result.put (new_triple (4370,4462,4539),216)
			Result.put (new_triple (4370,4462,4540),217)
			Result.put (new_triple (4370,4462,4541),218)
			Result.put (new_triple (4370,4462,4542),219)
			Result.put (new_triple (4370,4462,4543),220)
			Result.put (new_triple (4370,4462,4544),221)
			Result.put (new_triple (4370,4462,4545),222)
			Result.put (new_triple (4370,4462,4546),223)
			Result.put (new_pair (4370,4463),224)
			Result.put (new_triple (4370,4463,4520),225)
			Result.put (new_triple (4370,4463,4521),226)
			Result.put (new_triple (4370,4463,4522),227)
			Result.put (new_triple (4370,4463,4523),228)
			Result.put (new_triple (4370,4463,4524),229)
			Result.put (new_triple (4370,4463,4525),230)
			Result.put (new_triple (4370,4463,4526),231)
			Result.put (new_triple (4370,4463,4527),232)
			Result.put (new_triple (4370,4463,4528),233)
			Result.put (new_triple (4370,4463,4529),234)
			Result.put (new_triple (4370,4463,4530),235)
			Result.put (new_triple (4370,4463,4531),236)
			Result.put (new_triple (4370,4463,4532),237)
			Result.put (new_triple (4370,4463,4533),238)
			Result.put (new_triple (4370,4463,4534),239)
			Result.put (new_triple (4370,4463,4535),240)
			Result.put (new_triple (4370,4463,4536),241)
			Result.put (new_triple (4370,4463,4537),242)
			Result.put (new_triple (4370,4463,4538),243)
			Result.put (new_triple (4370,4463,4539),244)
			Result.put (new_triple (4370,4463,4540),245)
			Result.put (new_triple (4370,4463,4541),246)
			Result.put (new_triple (4370,4463,4542),247)
			Result.put (new_triple (4370,4463,4543),248)
			Result.put (new_triple (4370,4463,4544),249)
			Result.put (new_triple (4370,4463,4545),250)
			Result.put (new_triple (4370,4463,4546),251)
			Result.put (new_pair (4370,4464),252)
			Result.put (new_triple (4370,4464,4520),253)
			Result.put (new_triple (4370,4464,4521),254)
			Result.put (new_triple (4370,4464,4522),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_215: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_triple (4370,4464,4523),0)
			Result.put (new_triple (4370,4464,4524),1)
			Result.put (new_triple (4370,4464,4525),2)
			Result.put (new_triple (4370,4464,4526),3)
			Result.put (new_triple (4370,4464,4527),4)
			Result.put (new_triple (4370,4464,4528),5)
			Result.put (new_triple (4370,4464,4529),6)
			Result.put (new_triple (4370,4464,4530),7)
			Result.put (new_triple (4370,4464,4531),8)
			Result.put (new_triple (4370,4464,4532),9)
			Result.put (new_triple (4370,4464,4533),10)
			Result.put (new_triple (4370,4464,4534),11)
			Result.put (new_triple (4370,4464,4535),12)
			Result.put (new_triple (4370,4464,4536),13)
			Result.put (new_triple (4370,4464,4537),14)
			Result.put (new_triple (4370,4464,4538),15)
			Result.put (new_triple (4370,4464,4539),16)
			Result.put (new_triple (4370,4464,4540),17)
			Result.put (new_triple (4370,4464,4541),18)
			Result.put (new_triple (4370,4464,4542),19)
			Result.put (new_triple (4370,4464,4543),20)
			Result.put (new_triple (4370,4464,4544),21)
			Result.put (new_triple (4370,4464,4545),22)
			Result.put (new_triple (4370,4464,4546),23)
			Result.put (new_pair (4370,4465),24)
			Result.put (new_triple (4370,4465,4520),25)
			Result.put (new_triple (4370,4465,4521),26)
			Result.put (new_triple (4370,4465,4522),27)
			Result.put (new_triple (4370,4465,4523),28)
			Result.put (new_triple (4370,4465,4524),29)
			Result.put (new_triple (4370,4465,4525),30)
			Result.put (new_triple (4370,4465,4526),31)
			Result.put (new_triple (4370,4465,4527),32)
			Result.put (new_triple (4370,4465,4528),33)
			Result.put (new_triple (4370,4465,4529),34)
			Result.put (new_triple (4370,4465,4530),35)
			Result.put (new_triple (4370,4465,4531),36)
			Result.put (new_triple (4370,4465,4532),37)
			Result.put (new_triple (4370,4465,4533),38)
			Result.put (new_triple (4370,4465,4534),39)
			Result.put (new_triple (4370,4465,4535),40)
			Result.put (new_triple (4370,4465,4536),41)
			Result.put (new_triple (4370,4465,4537),42)
			Result.put (new_triple (4370,4465,4538),43)
			Result.put (new_triple (4370,4465,4539),44)
			Result.put (new_triple (4370,4465,4540),45)
			Result.put (new_triple (4370,4465,4541),46)
			Result.put (new_triple (4370,4465,4542),47)
			Result.put (new_triple (4370,4465,4543),48)
			Result.put (new_triple (4370,4465,4544),49)
			Result.put (new_triple (4370,4465,4545),50)
			Result.put (new_triple (4370,4465,4546),51)
			Result.put (new_pair (4370,4466),52)
			Result.put (new_triple (4370,4466,4520),53)
			Result.put (new_triple (4370,4466,4521),54)
			Result.put (new_triple (4370,4466,4522),55)
			Result.put (new_triple (4370,4466,4523),56)
			Result.put (new_triple (4370,4466,4524),57)
			Result.put (new_triple (4370,4466,4525),58)
			Result.put (new_triple (4370,4466,4526),59)
			Result.put (new_triple (4370,4466,4527),60)
			Result.put (new_triple (4370,4466,4528),61)
			Result.put (new_triple (4370,4466,4529),62)
			Result.put (new_triple (4370,4466,4530),63)
			Result.put (new_triple (4370,4466,4531),64)
			Result.put (new_triple (4370,4466,4532),65)
			Result.put (new_triple (4370,4466,4533),66)
			Result.put (new_triple (4370,4466,4534),67)
			Result.put (new_triple (4370,4466,4535),68)
			Result.put (new_triple (4370,4466,4536),69)
			Result.put (new_triple (4370,4466,4537),70)
			Result.put (new_triple (4370,4466,4538),71)
			Result.put (new_triple (4370,4466,4539),72)
			Result.put (new_triple (4370,4466,4540),73)
			Result.put (new_triple (4370,4466,4541),74)
			Result.put (new_triple (4370,4466,4542),75)
			Result.put (new_triple (4370,4466,4543),76)
			Result.put (new_triple (4370,4466,4544),77)
			Result.put (new_triple (4370,4466,4545),78)
			Result.put (new_triple (4370,4466,4546),79)
			Result.put (new_pair (4370,4467),80)
			Result.put (new_triple (4370,4467,4520),81)
			Result.put (new_triple (4370,4467,4521),82)
			Result.put (new_triple (4370,4467,4522),83)
			Result.put (new_triple (4370,4467,4523),84)
			Result.put (new_triple (4370,4467,4524),85)
			Result.put (new_triple (4370,4467,4525),86)
			Result.put (new_triple (4370,4467,4526),87)
			Result.put (new_triple (4370,4467,4527),88)
			Result.put (new_triple (4370,4467,4528),89)
			Result.put (new_triple (4370,4467,4529),90)
			Result.put (new_triple (4370,4467,4530),91)
			Result.put (new_triple (4370,4467,4531),92)
			Result.put (new_triple (4370,4467,4532),93)
			Result.put (new_triple (4370,4467,4533),94)
			Result.put (new_triple (4370,4467,4534),95)
			Result.put (new_triple (4370,4467,4535),96)
			Result.put (new_triple (4370,4467,4536),97)
			Result.put (new_triple (4370,4467,4537),98)
			Result.put (new_triple (4370,4467,4538),99)
			Result.put (new_triple (4370,4467,4539),100)
			Result.put (new_triple (4370,4467,4540),101)
			Result.put (new_triple (4370,4467,4541),102)
			Result.put (new_triple (4370,4467,4542),103)
			Result.put (new_triple (4370,4467,4543),104)
			Result.put (new_triple (4370,4467,4544),105)
			Result.put (new_triple (4370,4467,4545),106)
			Result.put (new_triple (4370,4467,4546),107)
			Result.put (new_pair (4370,4468),108)
			Result.put (new_triple (4370,4468,4520),109)
			Result.put (new_triple (4370,4468,4521),110)
			Result.put (new_triple (4370,4468,4522),111)
			Result.put (new_triple (4370,4468,4523),112)
			Result.put (new_triple (4370,4468,4524),113)
			Result.put (new_triple (4370,4468,4525),114)
			Result.put (new_triple (4370,4468,4526),115)
			Result.put (new_triple (4370,4468,4527),116)
			Result.put (new_triple (4370,4468,4528),117)
			Result.put (new_triple (4370,4468,4529),118)
			Result.put (new_triple (4370,4468,4530),119)
			Result.put (new_triple (4370,4468,4531),120)
			Result.put (new_triple (4370,4468,4532),121)
			Result.put (new_triple (4370,4468,4533),122)
			Result.put (new_triple (4370,4468,4534),123)
			Result.put (new_triple (4370,4468,4535),124)
			Result.put (new_triple (4370,4468,4536),125)
			Result.put (new_triple (4370,4468,4537),126)
			Result.put (new_triple (4370,4468,4538),127)
			Result.put (new_triple (4370,4468,4539),128)
			Result.put (new_triple (4370,4468,4540),129)
			Result.put (new_triple (4370,4468,4541),130)
			Result.put (new_triple (4370,4468,4542),131)
			Result.put (new_triple (4370,4468,4543),132)
			Result.put (new_triple (4370,4468,4544),133)
			Result.put (new_triple (4370,4468,4545),134)
			Result.put (new_triple (4370,4468,4546),135)
			Result.put (new_pair (4370,4469),136)
			Result.put (new_triple (4370,4469,4520),137)
			Result.put (new_triple (4370,4469,4521),138)
			Result.put (new_triple (4370,4469,4522),139)
			Result.put (new_triple (4370,4469,4523),140)
			Result.put (new_triple (4370,4469,4524),141)
			Result.put (new_triple (4370,4469,4525),142)
			Result.put (new_triple (4370,4469,4526),143)
			Result.put (new_triple (4370,4469,4527),144)
			Result.put (new_triple (4370,4469,4528),145)
			Result.put (new_triple (4370,4469,4529),146)
			Result.put (new_triple (4370,4469,4530),147)
			Result.put (new_triple (4370,4469,4531),148)
			Result.put (new_triple (4370,4469,4532),149)
			Result.put (new_triple (4370,4469,4533),150)
			Result.put (new_triple (4370,4469,4534),151)
			Result.put (new_triple (4370,4469,4535),152)
			Result.put (new_triple (4370,4469,4536),153)
			Result.put (new_triple (4370,4469,4537),154)
			Result.put (new_triple (4370,4469,4538),155)
			Result.put (new_triple (4370,4469,4539),156)
			Result.put (new_triple (4370,4469,4540),157)
			Result.put (new_triple (4370,4469,4541),158)
			Result.put (new_triple (4370,4469,4542),159)
			Result.put (new_triple (4370,4469,4543),160)
			Result.put (new_triple (4370,4469,4544),161)
			Result.put (new_triple (4370,4469,4545),162)
			Result.put (new_triple (4370,4469,4546),163)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_249: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (35912),0)
			Result.put (new_singleton (26356),1)
			Result.put (new_singleton (36554),2)
			Result.put (new_singleton (36040),3)
			Result.put (new_singleton (28369),4)
			Result.put (new_singleton (20018),5)
			Result.put (new_singleton (21477),6)
			Result.put (new_singleton (40860),7)
			Result.put (new_singleton (40860),8)
			Result.put (new_singleton (22865),9)
			Result.put (new_singleton (37329),10)
			Result.put (new_singleton (21895),11)
			Result.put (new_singleton (22856),12)
			Result.put (new_singleton (25078),13)
			Result.put (new_singleton (30313),14)
			Result.put (new_singleton (32645),15)
			Result.put (new_singleton (34367),16)
			Result.put (new_singleton (34746),17)
			Result.put (new_singleton (35064),18)
			Result.put (new_singleton (37007),19)
			Result.put (new_singleton (27138),20)
			Result.put (new_singleton (27931),21)
			Result.put (new_singleton (28889),22)
			Result.put (new_singleton (29662),23)
			Result.put (new_singleton (33853),24)
			Result.put (new_singleton (37226),25)
			Result.put (new_singleton (39409),26)
			Result.put (new_singleton (20098),27)
			Result.put (new_singleton (21365),28)
			Result.put (new_singleton (27396),29)
			Result.put (new_singleton (29211),30)
			Result.put (new_singleton (34349),31)
			Result.put (new_singleton (40478),32)
			Result.put (new_singleton (23888),33)
			Result.put (new_singleton (28651),34)
			Result.put (new_singleton (34253),35)
			Result.put (new_singleton (35172),36)
			Result.put (new_singleton (25289),37)
			Result.put (new_singleton (33240),38)
			Result.put (new_singleton (34847),39)
			Result.put (new_singleton (24266),40)
			Result.put (new_singleton (26391),41)
			Result.put (new_singleton (28010),42)
			Result.put (new_singleton (29436),43)
			Result.put (new_singleton (37070),44)
			Result.put (new_singleton (20358),45)
			Result.put (new_singleton (20919),46)
			Result.put (new_singleton (21214),47)
			Result.put (new_singleton (25796),48)
			Result.put (new_singleton (27347),49)
			Result.put (new_singleton (29200),50)
			Result.put (new_singleton (30439),51)
			Result.put (new_singleton (32769),52)
			Result.put (new_singleton (34310),53)
			Result.put (new_singleton (34396),54)
			Result.put (new_singleton (36335),55)
			Result.put (new_singleton (38706),56)
			Result.put (new_singleton (39791),57)
			Result.put (new_singleton (40442),58)
			Result.put (new_singleton (30860),59)
			Result.put (new_singleton (31103),60)
			Result.put (new_singleton (32160),61)
			Result.put (new_singleton (33737),62)
			Result.put (new_singleton (37636),63)
			Result.put (new_singleton (40575),64)
			Result.put (new_singleton (35542),65)
			Result.put (new_singleton (22751),66)
			Result.put (new_singleton (24324),67)
			Result.put (new_singleton (31840),68)
			Result.put (new_singleton (32894),69)
			Result.put (new_singleton (29282),70)
			Result.put (new_singleton (30922),71)
			Result.put (new_singleton (36034),72)
			Result.put (new_singleton (38647),73)
			Result.put (new_singleton (22744),74)
			Result.put (new_singleton (23650),75)
			Result.put (new_singleton (27155),76)
			Result.put (new_singleton (28122),77)
			Result.put (new_singleton (28431),78)
			Result.put (new_singleton (32047),79)
			Result.put (new_singleton (32311),80)
			Result.put (new_singleton (38475),81)
			Result.put (new_singleton (21202),82)
			Result.put (new_singleton (32907),83)
			Result.put (new_singleton (20956),84)
			Result.put (new_singleton (20940),85)
			Result.put (new_singleton (31260),86)
			Result.put (new_singleton (32190),87)
			Result.put (new_singleton (33777),88)
			Result.put (new_singleton (38517),89)
			Result.put (new_singleton (35712),90)
			Result.put (new_singleton (25295),91)
			Result.put (new_singleton (27138),92)
			Result.put (new_singleton (35582),93)
			Result.put (new_singleton (20025),94)
			Result.put (new_singleton (23527),95)
			Result.put (new_singleton (24594),96)
			Result.put (new_singleton (29575),97)
			Result.put (new_singleton (30064),98)
			Result.put (new_singleton (21271),99)
			Result.put (new_singleton (30971),100)
			Result.put (new_singleton (20415),101)
			Result.put (new_singleton (24489),102)
			Result.put (new_singleton (19981),103)
			Result.put (new_singleton (27852),104)
			Result.put (new_singleton (25976),105)
			Result.put (new_singleton (32034),106)
			Result.put (new_singleton (21443),107)
			Result.put (new_singleton (22622),108)
			Result.put (new_singleton (30465),109)
			Result.put (new_singleton (33865),110)
			Result.put (new_singleton (35498),111)
			Result.put (new_singleton (27578),112)
			Result.put (new_singleton (36784),113)
			Result.put (new_singleton (27784),114)
			Result.put (new_singleton (25342),115)
			Result.put (new_singleton (33509),116)
			Result.put (new_singleton (25504),117)
			Result.put (new_singleton (30053),118)
			Result.put (new_singleton (20142),119)
			Result.put (new_singleton (20841),120)
			Result.put (new_singleton (20937),121)
			Result.put (new_singleton (26753),122)
			Result.put (new_singleton (31975),123)
			Result.put (new_singleton (33391),124)
			Result.put (new_singleton (35538),125)
			Result.put (new_singleton (37327),126)
			Result.put (new_singleton (21237),127)
			Result.put (new_singleton (21570),128)
			Result.put (new_singleton (22899),129)
			Result.put (new_singleton (24300),130)
			Result.put (new_singleton (26053),131)
			Result.put (new_singleton (28670),132)
			Result.put (new_singleton (31018),133)
			Result.put (new_singleton (38317),134)
			Result.put (new_singleton (39530),135)
			Result.put (new_singleton (40599),136)
			Result.put (new_singleton (40654),137)
			Result.put (new_singleton (21147),138)
			Result.put (new_singleton (26310),139)
			Result.put (new_singleton (27511),140)
			Result.put (new_singleton (36706),141)
			Result.put (new_singleton (24180),142)
			Result.put (new_singleton (24976),143)
			Result.put (new_singleton (25088),144)
			Result.put (new_singleton (25754),145)
			Result.put (new_singleton (28451),146)
			Result.put (new_singleton (29001),147)
			Result.put (new_singleton (29833),148)
			Result.put (new_singleton (31178),149)
			Result.put (new_singleton (32244),150)
			Result.put (new_singleton (32879),151)
			Result.put (new_singleton (36646),152)
			Result.put (new_singleton (34030),153)
			Result.put (new_singleton (36899),154)
			Result.put (new_singleton (37706),155)
			Result.put (new_singleton (21015),156)
			Result.put (new_singleton (21155),157)
			Result.put (new_singleton (21693),158)
			Result.put (new_singleton (28872),159)
			Result.put (new_singleton (35010),160)
			Result.put (new_singleton (35498),161)
			Result.put (new_singleton (24265),162)
			Result.put (new_singleton (24565),163)
			Result.put (new_singleton (25467),164)
			Result.put (new_singleton (27566),165)
			Result.put (new_singleton (31806),166)
			Result.put (new_singleton (29557),167)
			Result.put (new_singleton (20196),168)
			Result.put (new_singleton (22265),169)
			Result.put (new_singleton (23527),170)
			Result.put (new_singleton (23994),171)
			Result.put (new_singleton (24604),172)
			Result.put (new_singleton (29618),173)
			Result.put (new_singleton (29801),174)
			Result.put (new_singleton (32666),175)
			Result.put (new_singleton (32838),176)
			Result.put (new_singleton (37428),177)
			Result.put (new_singleton (38646),178)
			Result.put (new_singleton (38728),179)
			Result.put (new_singleton (38936),180)
			Result.put (new_singleton (20363),181)
			Result.put (new_singleton (31150),182)
			Result.put (new_singleton (37300),183)
			Result.put (new_singleton (38584),184)
			Result.put (new_singleton (24801),185)
			Result.put (new_singleton (20102),186)
			Result.put (new_singleton (20698),187)
			Result.put (new_singleton (23534),188)
			Result.put (new_singleton (23615),189)
			Result.put (new_singleton (26009),190)
			Result.put (new_singleton (27138),191)
			Result.put (new_singleton (29134),192)
			Result.put (new_singleton (30274),193)
			Result.put (new_singleton (34044),194)
			Result.put (new_singleton (36988),195)
			Result.put (new_singleton (40845),196)
			Result.put (new_singleton (26248),197)
			Result.put (new_singleton (38446),198)
			Result.put (new_singleton (21129),199)
			Result.put (new_singleton (26491),200)
			Result.put (new_singleton (26611),201)
			Result.put (new_singleton (27969),202)
			Result.put (new_singleton (28316),203)
			Result.put (new_singleton (29705),204)
			Result.put (new_singleton (30041),205)
			Result.put (new_singleton (30827),206)
			Result.put (new_singleton (32016),207)
			Result.put (new_singleton (39006),208)
			Result.put (new_singleton (20845),209)
			Result.put (new_singleton (25134),210)
			Result.put (new_singleton (38520),211)
			Result.put (new_singleton (20523),212)
			Result.put (new_singleton (23833),213)
			Result.put (new_singleton (28138),214)
			Result.put (new_singleton (36650),215)
			Result.put (new_singleton (24459),216)
			Result.put (new_singleton (24900),217)
			Result.put (new_singleton (26647),218)
			Result.put (new_singleton (29575),219)
			Result.put (new_singleton (38534),220)
			Result.put (new_singleton (21033),221)
			Result.put (new_singleton (21519),222)
			Result.put (new_singleton (23653),223)
			Result.put (new_singleton (26131),224)
			Result.put (new_singleton (26446),225)
			Result.put (new_singleton (26792),226)
			Result.put (new_singleton (27877),227)
			Result.put (new_singleton (29702),228)
			Result.put (new_singleton (30178),229)
			Result.put (new_singleton (32633),230)
			Result.put (new_singleton (35023),231)
			Result.put (new_singleton (35041),232)
			Result.put (new_singleton (37324),233)
			Result.put (new_singleton (38626),234)
			Result.put (new_singleton (21311),235)
			Result.put (new_singleton (28346),236)
			Result.put (new_singleton (21533),237)
			Result.put (new_singleton (29136),238)
			Result.put (new_singleton (29848),239)
			Result.put (new_singleton (34298),240)
			Result.put (new_singleton (38563),241)
			Result.put (new_singleton (40023),242)
			Result.put (new_singleton (40607),243)
			Result.put (new_singleton (26519),244)
			Result.put (new_singleton (28107),245)
			Result.put (new_singleton (33256),246)
			Result.put (new_singleton (31435),247)
			Result.put (new_singleton (31520),248)
			Result.put (new_singleton (31890),249)
			Result.put (new_singleton (29376),250)
			Result.put (new_singleton (28825),251)
			Result.put (new_singleton (35672),252)
			Result.put (new_singleton (20160),253)
			Result.put (new_singleton (33590),254)
			Result.put (new_singleton (21050),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_250: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (20999),0)
			Result.put (new_singleton (24230),1)
			Result.put (new_singleton (25299),2)
			Result.put (new_singleton (31958),3)
			Result.put (new_singleton (23429),4)
			Result.put (new_singleton (27934),5)
			Result.put (new_singleton (26292),6)
			Result.put (new_singleton (36667),7)
			Result.put (new_singleton (34892),8)
			Result.put (new_singleton (38477),9)
			Result.put (new_singleton (35211),10)
			Result.put (new_singleton (24275),11)
			Result.put (new_singleton (20800),12)
			Result.put (new_singleton (21952),13)
			Result.put (new_singleton (22618),16)
			Result.put (new_singleton (26228),18)
			Result.put (new_singleton (20958),21)
			Result.put (new_singleton (29482),22)
			Result.put (new_singleton (30410),23)
			Result.put (new_singleton (31036),24)
			Result.put (new_singleton (31070),25)
			Result.put (new_singleton (31077),26)
			Result.put (new_singleton (31119),27)
			Result.put (new_singleton (38742),28)
			Result.put (new_singleton (31934),29)
			Result.put (new_singleton (32701),30)
			Result.put (new_singleton (34322),32)
			Result.put (new_singleton (35576),34)
			Result.put (new_singleton (36920),37)
			Result.put (new_singleton (37117),38)
			Result.put (new_singleton (39151),42)
			Result.put (new_singleton (39164),43)
			Result.put (new_singleton (39208),44)
			Result.put (new_singleton (40372),45)
			Result.put (new_singleton (20398),48)
			Result.put (new_singleton (20711),49)
			Result.put (new_singleton (20813),50)
			Result.put (new_singleton (21193),51)
			Result.put (new_singleton (21220),52)
			Result.put (new_singleton (21329),53)
			Result.put (new_singleton (21917),54)
			Result.put (new_singleton (22022),55)
			Result.put (new_singleton (22120),56)
			Result.put (new_singleton (22592),57)
			Result.put (new_singleton (22696),58)
			Result.put (new_singleton (23652),59)
			Result.put (new_singleton (23662),60)
			Result.put (new_singleton (24724),61)
			Result.put (new_singleton (24936),62)
			Result.put (new_singleton (24974),63)
			Result.put (new_singleton (25074),64)
			Result.put (new_singleton (25935),65)
			Result.put (new_singleton (26082),66)
			Result.put (new_singleton (26257),67)
			Result.put (new_singleton (26757),68)
			Result.put (new_singleton (28023),69)
			Result.put (new_singleton (28186),70)
			Result.put (new_singleton (28450),71)
			Result.put (new_singleton (29038),72)
			Result.put (new_singleton (29227),73)
			Result.put (new_singleton (29730),74)
			Result.put (new_singleton (30865),75)
			Result.put (new_singleton (31038),76)
			Result.put (new_singleton (31049),77)
			Result.put (new_singleton (31048),78)
			Result.put (new_singleton (31056),79)
			Result.put (new_singleton (31062),80)
			Result.put (new_singleton (31069),81)
			Result.put (new_singleton (31117),82)
			Result.put (new_singleton (31118),83)
			Result.put (new_singleton (31296),84)
			Result.put (new_singleton (31361),85)
			Result.put (new_singleton (31680),86)
			Result.put (new_singleton (32244),87)
			Result.put (new_singleton (32265),88)
			Result.put (new_singleton (32321),89)
			Result.put (new_singleton (32626),90)
			Result.put (new_singleton (32773),91)
			Result.put (new_singleton (33261),92)
			Result.put (new_singleton (33401),93)
			Result.put (new_singleton (33401),94)
			Result.put (new_singleton (33879),95)
			Result.put (new_singleton (35088),96)
			Result.put (new_singleton (35222),97)
			Result.put (new_singleton (35585),98)
			Result.put (new_singleton (35641),99)
			Result.put (new_singleton (36051),100)
			Result.put (new_singleton (36104),101)
			Result.put (new_singleton (36790),102)
			Result.put (new_singleton (36920),103)
			Result.put (new_singleton (38627),104)
			Result.put (new_singleton (38911),105)
			Result.put (new_singleton (38971),106)
			Result.put (new_singleton (20006),112)
			Result.put (new_singleton (20917),113)
			Result.put (new_singleton (20840),114)
			Result.put (new_singleton (20352),115)
			Result.put (new_singleton (20805),116)
			Result.put (new_singleton (20864),117)
			Result.put (new_singleton (21191),118)
			Result.put (new_singleton (21242),119)
			Result.put (new_singleton (21917),120)
			Result.put (new_singleton (21845),121)
			Result.put (new_singleton (21913),122)
			Result.put (new_singleton (21986),123)
			Result.put (new_singleton (22618),124)
			Result.put (new_singleton (22707),125)
			Result.put (new_singleton (22852),126)
			Result.put (new_singleton (22868),127)
			Result.put (new_singleton (23138),128)
			Result.put (new_singleton (23336),129)
			Result.put (new_singleton (24274),130)
			Result.put (new_singleton (24281),131)
			Result.put (new_singleton (24425),132)
			Result.put (new_singleton (24493),133)
			Result.put (new_singleton (24792),134)
			Result.put (new_singleton (24910),135)
			Result.put (new_singleton (24840),136)
			Result.put (new_singleton (24974),137)
			Result.put (new_singleton (24928),138)
			Result.put (new_singleton (25074),139)
			Result.put (new_singleton (25140),140)
			Result.put (new_singleton (25540),141)
			Result.put (new_singleton (25628),142)
			Result.put (new_singleton (25682),143)
			Result.put (new_singleton (25942),144)
			Result.put (new_singleton (26228),145)
			Result.put (new_singleton (26391),146)
			Result.put (new_singleton (26395),147)
			Result.put (new_singleton (26454),148)
			Result.put (new_singleton (27513),149)
			Result.put (new_singleton (27578),150)
			Result.put (new_singleton (27969),151)
			Result.put (new_singleton (28379),152)
			Result.put (new_singleton (28363),153)
			Result.put (new_singleton (28450),154)
			Result.put (new_singleton (28702),155)
			Result.put (new_singleton (29038),156)
			Result.put (new_singleton (30631),157)
			Result.put (new_singleton (29237),158)
			Result.put (new_singleton (29359),159)
			Result.put (new_singleton (29482),160)
			Result.put (new_singleton (29809),161)
			Result.put (new_singleton (29958),162)
			Result.put (new_singleton (30011),163)
			Result.put (new_singleton (30237),164)
			Result.put (new_singleton (30239),165)
			Result.put (new_singleton (30410),166)
			Result.put (new_singleton (30427),167)
			Result.put (new_singleton (30452),168)
			Result.put (new_singleton (30538),169)
			Result.put (new_singleton (30528),170)
			Result.put (new_singleton (30924),171)
			Result.put (new_singleton (31409),172)
			Result.put (new_singleton (31680),173)
			Result.put (new_singleton (31867),174)
			Result.put (new_singleton (32091),175)
			Result.put (new_singleton (32244),176)
			Result.put (new_singleton (32574),177)
			Result.put (new_singleton (32773),178)
			Result.put (new_singleton (33618),179)
			Result.put (new_singleton (33775),180)
			Result.put (new_singleton (34681),181)
			Result.put (new_singleton (35137),182)
			Result.put (new_singleton (35206),183)
			Result.put (new_singleton (35222),184)
			Result.put (new_singleton (35519),185)
			Result.put (new_singleton (35576),186)
			Result.put (new_singleton (35531),187)
			Result.put (new_singleton (35585),188)
			Result.put (new_singleton (35582),189)
			Result.put (new_singleton (35565),190)
			Result.put (new_singleton (35641),191)
			Result.put (new_singleton (35722),192)
			Result.put (new_singleton (36104),193)
			Result.put (new_singleton (36664),194)
			Result.put (new_singleton (36978),195)
			Result.put (new_singleton (37273),196)
			Result.put (new_singleton (37494),197)
			Result.put (new_singleton (38524),198)
			Result.put (new_singleton (38627),199)
			Result.put (new_singleton (38742),200)
			Result.put (new_singleton (38875),201)
			Result.put (new_singleton (38911),202)
			Result.put (new_singleton (38923),203)
			Result.put (new_singleton (38971),204)
			Result.put (new_singleton (39698),205)
			Result.put (new_singleton (40860),206)
			Result.put (new_singleton (141386),207)
			Result.put (new_singleton (141380),208)
			Result.put (new_singleton (144341),209)
			Result.put (new_singleton (15261),210)
			Result.put (new_singleton (16408),211)
			Result.put (new_singleton (16441),212)
			Result.put (new_singleton (152137),213)
			Result.put (new_singleton (154832),214)
			Result.put (new_singleton (163539),215)
			Result.put (new_singleton (40771),216)
			Result.put (new_singleton (40846),217)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_251: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (102,102),0)
			Result.put (new_pair (102,105),1)
			Result.put (new_pair (102,108),2)
			Result.put (new_triple (102,102,105),3)
			Result.put (new_triple (102,102,108),4)
			Result.put (new_pair (383,116),5)
			Result.put (new_pair (115,116),6)
			Result.put (new_pair (1396,1398),19)
			Result.put (new_pair (1396,1381),20)
			Result.put (new_pair (1396,1387),21)
			Result.put (new_pair (1406,1398),22)
			Result.put (new_pair (1396,1389),23)
			Result.put (new_pair (1497,1460),29)
			Result.put (new_pair (1522,1463),31)
			Result.put (new_singleton (1506),32)
			Result.put (new_singleton (1488),33)
			Result.put (new_singleton (1491),34)
			Result.put (new_singleton (1492),35)
			Result.put (new_singleton (1499),36)
			Result.put (new_singleton (1500),37)
			Result.put (new_singleton (1501),38)
			Result.put (new_singleton (1512),39)
			Result.put (new_singleton (1514),40)
			Result.put (new_singleton (43),41)
			Result.put (new_pair (1513,1473),42)
			Result.put (new_pair (1513,1474),43)
			Result.put (new_pair (64329,1473),44)
			Result.put (new_pair (64329,1474),45)
			Result.put (new_pair (1488,1463),46)
			Result.put (new_pair (1488,1464),47)
			Result.put (new_pair (1488,1468),48)
			Result.put (new_pair (1489,1468),49)
			Result.put (new_pair (1490,1468),50)
			Result.put (new_pair (1491,1468),51)
			Result.put (new_pair (1492,1468),52)
			Result.put (new_pair (1493,1468),53)
			Result.put (new_pair (1494,1468),54)
			Result.put (new_pair (1496,1468),56)
			Result.put (new_pair (1497,1468),57)
			Result.put (new_pair (1498,1468),58)
			Result.put (new_pair (1499,1468),59)
			Result.put (new_pair (1500,1468),60)
			Result.put (new_pair (1502,1468),62)
			Result.put (new_pair (1504,1468),64)
			Result.put (new_pair (1505,1468),65)
			Result.put (new_pair (1507,1468),67)
			Result.put (new_pair (1508,1468),68)
			Result.put (new_pair (1510,1468),70)
			Result.put (new_pair (1511,1468),71)
			Result.put (new_pair (1512,1468),72)
			Result.put (new_pair (1513,1468),73)
			Result.put (new_pair (1514,1468),74)
			Result.put (new_pair (1493,1465),75)
			Result.put (new_pair (1489,1471),76)
			Result.put (new_pair (1499,1471),77)
			Result.put (new_pair (1508,1471),78)
			Result.put (new_pair (1488,1500),79)
			Result.put (new_singleton (1649),80)
			Result.put (new_singleton (1649),81)
			Result.put (new_singleton (1659),82)
			Result.put (new_singleton (1659),83)
			Result.put (new_singleton (1659),84)
			Result.put (new_singleton (1659),85)
			Result.put (new_singleton (1662),86)
			Result.put (new_singleton (1662),87)
			Result.put (new_singleton (1662),88)
			Result.put (new_singleton (1662),89)
			Result.put (new_singleton (1664),90)
			Result.put (new_singleton (1664),91)
			Result.put (new_singleton (1664),92)
			Result.put (new_singleton (1664),93)
			Result.put (new_singleton (1658),94)
			Result.put (new_singleton (1658),95)
			Result.put (new_singleton (1658),96)
			Result.put (new_singleton (1658),97)
			Result.put (new_singleton (1663),98)
			Result.put (new_singleton (1663),99)
			Result.put (new_singleton (1663),100)
			Result.put (new_singleton (1663),101)
			Result.put (new_singleton (1657),102)
			Result.put (new_singleton (1657),103)
			Result.put (new_singleton (1657),104)
			Result.put (new_singleton (1657),105)
			Result.put (new_singleton (1700),106)
			Result.put (new_singleton (1700),107)
			Result.put (new_singleton (1700),108)
			Result.put (new_singleton (1700),109)
			Result.put (new_singleton (1702),110)
			Result.put (new_singleton (1702),111)
			Result.put (new_singleton (1702),112)
			Result.put (new_singleton (1702),113)
			Result.put (new_singleton (1668),114)
			Result.put (new_singleton (1668),115)
			Result.put (new_singleton (1668),116)
			Result.put (new_singleton (1668),117)
			Result.put (new_singleton (1667),118)
			Result.put (new_singleton (1667),119)
			Result.put (new_singleton (1667),120)
			Result.put (new_singleton (1667),121)
			Result.put (new_singleton (1670),122)
			Result.put (new_singleton (1670),123)
			Result.put (new_singleton (1670),124)
			Result.put (new_singleton (1670),125)
			Result.put (new_singleton (1671),126)
			Result.put (new_singleton (1671),127)
			Result.put (new_singleton (1671),128)
			Result.put (new_singleton (1671),129)
			Result.put (new_singleton (1677),130)
			Result.put (new_singleton (1677),131)
			Result.put (new_singleton (1676),132)
			Result.put (new_singleton (1676),133)
			Result.put (new_singleton (1678),134)
			Result.put (new_singleton (1678),135)
			Result.put (new_singleton (1672),136)
			Result.put (new_singleton (1672),137)
			Result.put (new_singleton (1688),138)
			Result.put (new_singleton (1688),139)
			Result.put (new_singleton (1681),140)
			Result.put (new_singleton (1681),141)
			Result.put (new_singleton (1705),142)
			Result.put (new_singleton (1705),143)
			Result.put (new_singleton (1705),144)
			Result.put (new_singleton (1705),145)
			Result.put (new_singleton (1711),146)
			Result.put (new_singleton (1711),147)
			Result.put (new_singleton (1711),148)
			Result.put (new_singleton (1711),149)
			Result.put (new_singleton (1715),150)
			Result.put (new_singleton (1715),151)
			Result.put (new_singleton (1715),152)
			Result.put (new_singleton (1715),153)
			Result.put (new_singleton (1713),154)
			Result.put (new_singleton (1713),155)
			Result.put (new_singleton (1713),156)
			Result.put (new_singleton (1713),157)
			Result.put (new_singleton (1722),158)
			Result.put (new_singleton (1722),159)
			Result.put (new_singleton (1723),160)
			Result.put (new_singleton (1723),161)
			Result.put (new_singleton (1723),162)
			Result.put (new_singleton (1723),163)
			Result.put (new_singleton (1728),164)
			Result.put (new_singleton (1728),165)
			Result.put (new_singleton (1729),166)
			Result.put (new_singleton (1729),167)
			Result.put (new_singleton (1729),168)
			Result.put (new_singleton (1729),169)
			Result.put (new_singleton (1726),170)
			Result.put (new_singleton (1726),171)
			Result.put (new_singleton (1726),172)
			Result.put (new_singleton (1726),173)
			Result.put (new_singleton (1746),174)
			Result.put (new_singleton (1746),175)
			Result.put (new_singleton (1747),176)
			Result.put (new_singleton (1747),177)
			Result.put (new_singleton (1709),211)
			Result.put (new_singleton (1709),212)
			Result.put (new_singleton (1709),213)
			Result.put (new_singleton (1709),214)
			Result.put (new_singleton (1735),215)
			Result.put (new_singleton (1735),216)
			Result.put (new_singleton (1734),217)
			Result.put (new_singleton (1734),218)
			Result.put (new_singleton (1736),219)
			Result.put (new_singleton (1736),220)
			Result.put (new_singleton (1655),221)
			Result.put (new_singleton (1739),222)
			Result.put (new_singleton (1739),223)
			Result.put (new_singleton (1733),224)
			Result.put (new_singleton (1733),225)
			Result.put (new_singleton (1737),226)
			Result.put (new_singleton (1737),227)
			Result.put (new_singleton (1744),228)
			Result.put (new_singleton (1744),229)
			Result.put (new_singleton (1744),230)
			Result.put (new_singleton (1744),231)
			Result.put (new_singleton (1609),232)
			Result.put (new_singleton (1609),233)
			Result.put (new_pair (1574,1575),234)
			Result.put (new_pair (1574,1575),235)
			Result.put (new_pair (1574,1749),236)
			Result.put (new_pair (1574,1749),237)
			Result.put (new_pair (1574,1608),238)
			Result.put (new_pair (1574,1608),239)
			Result.put (new_pair (1574,1735),240)
			Result.put (new_pair (1574,1735),241)
			Result.put (new_pair (1574,1734),242)
			Result.put (new_pair (1574,1734),243)
			Result.put (new_pair (1574,1736),244)
			Result.put (new_pair (1574,1736),245)
			Result.put (new_pair (1574,1744),246)
			Result.put (new_pair (1574,1744),247)
			Result.put (new_pair (1574,1744),248)
			Result.put (new_pair (1574,1609),249)
			Result.put (new_pair (1574,1609),250)
			Result.put (new_pair (1574,1609),251)
			Result.put (new_singleton (1740),252)
			Result.put (new_singleton (1740),253)
			Result.put (new_singleton (1740),254)
			Result.put (new_singleton (1740),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_252: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (1574,1580),0)
			Result.put (new_pair (1574,1581),1)
			Result.put (new_pair (1574,1605),2)
			Result.put (new_pair (1574,1609),3)
			Result.put (new_pair (1574,1610),4)
			Result.put (new_pair (1576,1580),5)
			Result.put (new_pair (1576,1581),6)
			Result.put (new_pair (1576,1582),7)
			Result.put (new_pair (1576,1605),8)
			Result.put (new_pair (1576,1609),9)
			Result.put (new_pair (1576,1610),10)
			Result.put (new_pair (1578,1580),11)
			Result.put (new_pair (1578,1581),12)
			Result.put (new_pair (1578,1582),13)
			Result.put (new_pair (1578,1605),14)
			Result.put (new_pair (1578,1609),15)
			Result.put (new_pair (1578,1610),16)
			Result.put (new_pair (1579,1580),17)
			Result.put (new_pair (1579,1605),18)
			Result.put (new_pair (1579,1609),19)
			Result.put (new_pair (1579,1610),20)
			Result.put (new_pair (1580,1581),21)
			Result.put (new_pair (1580,1605),22)
			Result.put (new_pair (1581,1580),23)
			Result.put (new_pair (1581,1605),24)
			Result.put (new_pair (1582,1580),25)
			Result.put (new_pair (1582,1581),26)
			Result.put (new_pair (1582,1605),27)
			Result.put (new_pair (1587,1580),28)
			Result.put (new_pair (1587,1581),29)
			Result.put (new_pair (1587,1582),30)
			Result.put (new_pair (1587,1605),31)
			Result.put (new_pair (1589,1581),32)
			Result.put (new_pair (1589,1605),33)
			Result.put (new_pair (1590,1580),34)
			Result.put (new_pair (1590,1581),35)
			Result.put (new_pair (1590,1582),36)
			Result.put (new_pair (1590,1605),37)
			Result.put (new_pair (1591,1581),38)
			Result.put (new_pair (1591,1605),39)
			Result.put (new_pair (1592,1605),40)
			Result.put (new_pair (1593,1580),41)
			Result.put (new_pair (1593,1605),42)
			Result.put (new_pair (1594,1580),43)
			Result.put (new_pair (1594,1605),44)
			Result.put (new_pair (1601,1580),45)
			Result.put (new_pair (1601,1581),46)
			Result.put (new_pair (1601,1582),47)
			Result.put (new_pair (1601,1605),48)
			Result.put (new_pair (1601,1609),49)
			Result.put (new_pair (1601,1610),50)
			Result.put (new_pair (1602,1581),51)
			Result.put (new_pair (1602,1605),52)
			Result.put (new_pair (1602,1609),53)
			Result.put (new_pair (1602,1610),54)
			Result.put (new_pair (1603,1575),55)
			Result.put (new_pair (1603,1580),56)
			Result.put (new_pair (1603,1581),57)
			Result.put (new_pair (1603,1582),58)
			Result.put (new_pair (1603,1604),59)
			Result.put (new_pair (1603,1605),60)
			Result.put (new_pair (1603,1609),61)
			Result.put (new_pair (1603,1610),62)
			Result.put (new_pair (1604,1580),63)
			Result.put (new_pair (1604,1581),64)
			Result.put (new_pair (1604,1582),65)
			Result.put (new_pair (1604,1605),66)
			Result.put (new_pair (1604,1609),67)
			Result.put (new_pair (1604,1610),68)
			Result.put (new_pair (1605,1580),69)
			Result.put (new_pair (1605,1581),70)
			Result.put (new_pair (1605,1582),71)
			Result.put (new_pair (1605,1605),72)
			Result.put (new_pair (1605,1609),73)
			Result.put (new_pair (1605,1610),74)
			Result.put (new_pair (1606,1580),75)
			Result.put (new_pair (1606,1581),76)
			Result.put (new_pair (1606,1582),77)
			Result.put (new_pair (1606,1605),78)
			Result.put (new_pair (1606,1609),79)
			Result.put (new_pair (1606,1610),80)
			Result.put (new_pair (1607,1580),81)
			Result.put (new_pair (1607,1605),82)
			Result.put (new_pair (1607,1609),83)
			Result.put (new_pair (1607,1610),84)
			Result.put (new_pair (1610,1580),85)
			Result.put (new_pair (1610,1581),86)
			Result.put (new_pair (1610,1582),87)
			Result.put (new_pair (1610,1605),88)
			Result.put (new_pair (1610,1609),89)
			Result.put (new_pair (1610,1610),90)
			Result.put (new_pair (1584,1648),91)
			Result.put (new_pair (1585,1648),92)
			Result.put (new_pair (1609,1648),93)
			Result.put (new_triple (32,1612,1617),94)
			Result.put (new_triple (32,1613,1617),95)
			Result.put (new_triple (32,1614,1617),96)
			Result.put (new_triple (32,1615,1617),97)
			Result.put (new_triple (32,1616,1617),98)
			Result.put (new_triple (32,1617,1648),99)
			Result.put (new_pair (1574,1585),100)
			Result.put (new_pair (1574,1586),101)
			Result.put (new_pair (1574,1605),102)
			Result.put (new_pair (1574,1606),103)
			Result.put (new_pair (1574,1609),104)
			Result.put (new_pair (1574,1610),105)
			Result.put (new_pair (1576,1585),106)
			Result.put (new_pair (1576,1586),107)
			Result.put (new_pair (1576,1605),108)
			Result.put (new_pair (1576,1606),109)
			Result.put (new_pair (1576,1609),110)
			Result.put (new_pair (1576,1610),111)
			Result.put (new_pair (1578,1585),112)
			Result.put (new_pair (1578,1586),113)
			Result.put (new_pair (1578,1605),114)
			Result.put (new_pair (1578,1606),115)
			Result.put (new_pair (1578,1609),116)
			Result.put (new_pair (1578,1610),117)
			Result.put (new_pair (1579,1585),118)
			Result.put (new_pair (1579,1586),119)
			Result.put (new_pair (1579,1605),120)
			Result.put (new_pair (1579,1606),121)
			Result.put (new_pair (1579,1609),122)
			Result.put (new_pair (1579,1610),123)
			Result.put (new_pair (1601,1609),124)
			Result.put (new_pair (1601,1610),125)
			Result.put (new_pair (1602,1609),126)
			Result.put (new_pair (1602,1610),127)
			Result.put (new_pair (1603,1575),128)
			Result.put (new_pair (1603,1604),129)
			Result.put (new_pair (1603,1605),130)
			Result.put (new_pair (1603,1609),131)
			Result.put (new_pair (1603,1610),132)
			Result.put (new_pair (1604,1605),133)
			Result.put (new_pair (1604,1609),134)
			Result.put (new_pair (1604,1610),135)
			Result.put (new_pair (1605,1575),136)
			Result.put (new_pair (1605,1605),137)
			Result.put (new_pair (1606,1585),138)
			Result.put (new_pair (1606,1586),139)
			Result.put (new_pair (1606,1605),140)
			Result.put (new_pair (1606,1606),141)
			Result.put (new_pair (1606,1609),142)
			Result.put (new_pair (1606,1610),143)
			Result.put (new_pair (1609,1648),144)
			Result.put (new_pair (1610,1585),145)
			Result.put (new_pair (1610,1586),146)
			Result.put (new_pair (1610,1605),147)
			Result.put (new_pair (1610,1606),148)
			Result.put (new_pair (1610,1609),149)
			Result.put (new_pair (1610,1610),150)
			Result.put (new_pair (1574,1580),151)
			Result.put (new_pair (1574,1581),152)
			Result.put (new_pair (1574,1582),153)
			Result.put (new_pair (1574,1605),154)
			Result.put (new_pair (1574,1607),155)
			Result.put (new_pair (1576,1580),156)
			Result.put (new_pair (1576,1581),157)
			Result.put (new_pair (1576,1582),158)
			Result.put (new_pair (1576,1605),159)
			Result.put (new_pair (1576,1607),160)
			Result.put (new_pair (1578,1580),161)
			Result.put (new_pair (1578,1581),162)
			Result.put (new_pair (1578,1582),163)
			Result.put (new_pair (1578,1605),164)
			Result.put (new_pair (1578,1607),165)
			Result.put (new_pair (1579,1605),166)
			Result.put (new_pair (1580,1581),167)
			Result.put (new_pair (1580,1605),168)
			Result.put (new_pair (1581,1580),169)
			Result.put (new_pair (1581,1605),170)
			Result.put (new_pair (1582,1580),171)
			Result.put (new_pair (1582,1605),172)
			Result.put (new_pair (1587,1580),173)
			Result.put (new_pair (1587,1581),174)
			Result.put (new_pair (1587,1582),175)
			Result.put (new_pair (1587,1605),176)
			Result.put (new_pair (1589,1581),177)
			Result.put (new_pair (1589,1582),178)
			Result.put (new_pair (1589,1605),179)
			Result.put (new_pair (1590,1580),180)
			Result.put (new_pair (1590,1581),181)
			Result.put (new_pair (1590,1582),182)
			Result.put (new_pair (1590,1605),183)
			Result.put (new_pair (1591,1581),184)
			Result.put (new_pair (1592,1605),185)
			Result.put (new_pair (1593,1580),186)
			Result.put (new_pair (1593,1605),187)
			Result.put (new_pair (1594,1580),188)
			Result.put (new_pair (1594,1605),189)
			Result.put (new_pair (1601,1580),190)
			Result.put (new_pair (1601,1581),191)
			Result.put (new_pair (1601,1582),192)
			Result.put (new_pair (1601,1605),193)
			Result.put (new_pair (1602,1581),194)
			Result.put (new_pair (1602,1605),195)
			Result.put (new_pair (1603,1580),196)
			Result.put (new_pair (1603,1581),197)
			Result.put (new_pair (1603,1582),198)
			Result.put (new_pair (1603,1604),199)
			Result.put (new_pair (1603,1605),200)
			Result.put (new_pair (1604,1580),201)
			Result.put (new_pair (1604,1581),202)
			Result.put (new_pair (1604,1582),203)
			Result.put (new_pair (1604,1605),204)
			Result.put (new_pair (1604,1607),205)
			Result.put (new_pair (1605,1580),206)
			Result.put (new_pair (1605,1581),207)
			Result.put (new_pair (1605,1582),208)
			Result.put (new_pair (1605,1605),209)
			Result.put (new_pair (1606,1580),210)
			Result.put (new_pair (1606,1581),211)
			Result.put (new_pair (1606,1582),212)
			Result.put (new_pair (1606,1605),213)
			Result.put (new_pair (1606,1607),214)
			Result.put (new_pair (1607,1580),215)
			Result.put (new_pair (1607,1605),216)
			Result.put (new_pair (1607,1648),217)
			Result.put (new_pair (1610,1580),218)
			Result.put (new_pair (1610,1581),219)
			Result.put (new_pair (1610,1582),220)
			Result.put (new_pair (1610,1605),221)
			Result.put (new_pair (1610,1607),222)
			Result.put (new_pair (1574,1605),223)
			Result.put (new_pair (1574,1607),224)
			Result.put (new_pair (1576,1605),225)
			Result.put (new_pair (1576,1607),226)
			Result.put (new_pair (1578,1605),227)
			Result.put (new_pair (1578,1607),228)
			Result.put (new_pair (1579,1605),229)
			Result.put (new_pair (1579,1607),230)
			Result.put (new_pair (1587,1605),231)
			Result.put (new_pair (1587,1607),232)
			Result.put (new_pair (1588,1605),233)
			Result.put (new_pair (1588,1607),234)
			Result.put (new_pair (1603,1604),235)
			Result.put (new_pair (1603,1605),236)
			Result.put (new_pair (1604,1605),237)
			Result.put (new_pair (1606,1605),238)
			Result.put (new_pair (1606,1607),239)
			Result.put (new_pair (1610,1605),240)
			Result.put (new_pair (1610,1607),241)
			Result.put (new_triple (1600,1614,1617),242)
			Result.put (new_triple (1600,1615,1617),243)
			Result.put (new_triple (1600,1616,1617),244)
			Result.put (new_pair (1591,1609),245)
			Result.put (new_pair (1591,1610),246)
			Result.put (new_pair (1593,1609),247)
			Result.put (new_pair (1593,1610),248)
			Result.put (new_pair (1594,1609),249)
			Result.put (new_pair (1594,1610),250)
			Result.put (new_pair (1587,1609),251)
			Result.put (new_pair (1587,1610),252)
			Result.put (new_pair (1588,1609),253)
			Result.put (new_pair (1588,1610),254)
			Result.put (new_pair (1581,1609),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_253: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (1581,1610),0)
			Result.put (new_pair (1580,1609),1)
			Result.put (new_pair (1580,1610),2)
			Result.put (new_pair (1582,1609),3)
			Result.put (new_pair (1582,1610),4)
			Result.put (new_pair (1589,1609),5)
			Result.put (new_pair (1589,1610),6)
			Result.put (new_pair (1590,1609),7)
			Result.put (new_pair (1590,1610),8)
			Result.put (new_pair (1588,1580),9)
			Result.put (new_pair (1588,1581),10)
			Result.put (new_pair (1588,1582),11)
			Result.put (new_pair (1588,1605),12)
			Result.put (new_pair (1588,1585),13)
			Result.put (new_pair (1587,1585),14)
			Result.put (new_pair (1589,1585),15)
			Result.put (new_pair (1590,1585),16)
			Result.put (new_pair (1591,1609),17)
			Result.put (new_pair (1591,1610),18)
			Result.put (new_pair (1593,1609),19)
			Result.put (new_pair (1593,1610),20)
			Result.put (new_pair (1594,1609),21)
			Result.put (new_pair (1594,1610),22)
			Result.put (new_pair (1587,1609),23)
			Result.put (new_pair (1587,1610),24)
			Result.put (new_pair (1588,1609),25)
			Result.put (new_pair (1588,1610),26)
			Result.put (new_pair (1581,1609),27)
			Result.put (new_pair (1581,1610),28)
			Result.put (new_pair (1580,1609),29)
			Result.put (new_pair (1580,1610),30)
			Result.put (new_pair (1582,1609),31)
			Result.put (new_pair (1582,1610),32)
			Result.put (new_pair (1589,1609),33)
			Result.put (new_pair (1589,1610),34)
			Result.put (new_pair (1590,1609),35)
			Result.put (new_pair (1590,1610),36)
			Result.put (new_pair (1588,1580),37)
			Result.put (new_pair (1588,1581),38)
			Result.put (new_pair (1588,1582),39)
			Result.put (new_pair (1588,1605),40)
			Result.put (new_pair (1588,1585),41)
			Result.put (new_pair (1587,1585),42)
			Result.put (new_pair (1589,1585),43)
			Result.put (new_pair (1590,1585),44)
			Result.put (new_pair (1588,1580),45)
			Result.put (new_pair (1588,1581),46)
			Result.put (new_pair (1588,1582),47)
			Result.put (new_pair (1588,1605),48)
			Result.put (new_pair (1587,1607),49)
			Result.put (new_pair (1588,1607),50)
			Result.put (new_pair (1591,1605),51)
			Result.put (new_pair (1587,1580),52)
			Result.put (new_pair (1587,1581),53)
			Result.put (new_pair (1587,1582),54)
			Result.put (new_pair (1588,1580),55)
			Result.put (new_pair (1588,1581),56)
			Result.put (new_pair (1588,1582),57)
			Result.put (new_pair (1591,1605),58)
			Result.put (new_pair (1592,1605),59)
			Result.put (new_pair (1575,1611),60)
			Result.put (new_pair (1575,1611),61)
			Result.put (new_triple (1578,1580,1605),80)
			Result.put (new_triple (1578,1581,1580),81)
			Result.put (new_triple (1578,1581,1580),82)
			Result.put (new_triple (1578,1581,1605),83)
			Result.put (new_triple (1578,1582,1605),84)
			Result.put (new_triple (1578,1605,1580),85)
			Result.put (new_triple (1578,1605,1581),86)
			Result.put (new_triple (1578,1605,1582),87)
			Result.put (new_triple (1580,1605,1581),88)
			Result.put (new_triple (1580,1605,1581),89)
			Result.put (new_triple (1581,1605,1610),90)
			Result.put (new_triple (1581,1605,1609),91)
			Result.put (new_triple (1587,1581,1580),92)
			Result.put (new_triple (1587,1580,1581),93)
			Result.put (new_triple (1587,1580,1609),94)
			Result.put (new_triple (1587,1605,1581),95)
			Result.put (new_triple (1587,1605,1581),96)
			Result.put (new_triple (1587,1605,1580),97)
			Result.put (new_triple (1587,1605,1605),98)
			Result.put (new_triple (1587,1605,1605),99)
			Result.put (new_triple (1589,1581,1581),100)
			Result.put (new_triple (1589,1581,1581),101)
			Result.put (new_triple (1589,1605,1605),102)
			Result.put (new_triple (1588,1581,1605),103)
			Result.put (new_triple (1588,1581,1605),104)
			Result.put (new_triple (1588,1580,1610),105)
			Result.put (new_triple (1588,1605,1582),106)
			Result.put (new_triple (1588,1605,1582),107)
			Result.put (new_triple (1588,1605,1605),108)
			Result.put (new_triple (1588,1605,1605),109)
			Result.put (new_triple (1590,1581,1609),110)
			Result.put (new_triple (1590,1582,1605),111)
			Result.put (new_triple (1590,1582,1605),112)
			Result.put (new_triple (1591,1605,1581),113)
			Result.put (new_triple (1591,1605,1581),114)
			Result.put (new_triple (1591,1605,1605),115)
			Result.put (new_triple (1591,1605,1610),116)
			Result.put (new_triple (1593,1580,1605),117)
			Result.put (new_triple (1593,1605,1605),118)
			Result.put (new_triple (1593,1605,1605),119)
			Result.put (new_triple (1593,1605,1609),120)
			Result.put (new_triple (1594,1605,1605),121)
			Result.put (new_triple (1594,1605,1610),122)
			Result.put (new_triple (1594,1605,1609),123)
			Result.put (new_triple (1601,1582,1605),124)
			Result.put (new_triple (1601,1582,1605),125)
			Result.put (new_triple (1602,1605,1581),126)
			Result.put (new_triple (1602,1605,1605),127)
			Result.put (new_triple (1604,1581,1605),128)
			Result.put (new_triple (1604,1581,1610),129)
			Result.put (new_triple (1604,1581,1609),130)
			Result.put (new_triple (1604,1580,1580),131)
			Result.put (new_triple (1604,1580,1580),132)
			Result.put (new_triple (1604,1582,1605),133)
			Result.put (new_triple (1604,1582,1605),134)
			Result.put (new_triple (1604,1605,1581),135)
			Result.put (new_triple (1604,1605,1581),136)
			Result.put (new_triple (1605,1581,1580),137)
			Result.put (new_triple (1605,1581,1605),138)
			Result.put (new_triple (1605,1581,1610),139)
			Result.put (new_triple (1605,1580,1581),140)
			Result.put (new_triple (1605,1580,1605),141)
			Result.put (new_triple (1605,1582,1580),142)
			Result.put (new_triple (1605,1582,1605),143)
			Result.put (new_triple (1605,1580,1582),146)
			Result.put (new_triple (1607,1605,1580),147)
			Result.put (new_triple (1607,1605,1605),148)
			Result.put (new_triple (1606,1581,1605),149)
			Result.put (new_triple (1606,1581,1609),150)
			Result.put (new_triple (1606,1580,1605),151)
			Result.put (new_triple (1606,1580,1605),152)
			Result.put (new_triple (1606,1580,1609),153)
			Result.put (new_triple (1606,1605,1610),154)
			Result.put (new_triple (1606,1605,1609),155)
			Result.put (new_triple (1610,1605,1605),156)
			Result.put (new_triple (1610,1605,1605),157)
			Result.put (new_triple (1576,1582,1610),158)
			Result.put (new_triple (1578,1580,1610),159)
			Result.put (new_triple (1578,1580,1609),160)
			Result.put (new_triple (1578,1582,1610),161)
			Result.put (new_triple (1578,1582,1609),162)
			Result.put (new_triple (1578,1605,1610),163)
			Result.put (new_triple (1578,1605,1609),164)
			Result.put (new_triple (1580,1605,1610),165)
			Result.put (new_triple (1580,1581,1609),166)
			Result.put (new_triple (1580,1605,1609),167)
			Result.put (new_triple (1587,1582,1609),168)
			Result.put (new_triple (1589,1581,1610),169)
			Result.put (new_triple (1588,1581,1610),170)
			Result.put (new_triple (1590,1581,1610),171)
			Result.put (new_triple (1604,1580,1610),172)
			Result.put (new_triple (1604,1605,1610),173)
			Result.put (new_triple (1610,1581,1610),174)
			Result.put (new_triple (1610,1580,1610),175)
			Result.put (new_triple (1610,1605,1610),176)
			Result.put (new_triple (1605,1605,1610),177)
			Result.put (new_triple (1602,1605,1610),178)
			Result.put (new_triple (1606,1581,1610),179)
			Result.put (new_triple (1602,1605,1581),180)
			Result.put (new_triple (1604,1581,1605),181)
			Result.put (new_triple (1593,1605,1610),182)
			Result.put (new_triple (1603,1605,1610),183)
			Result.put (new_triple (1606,1580,1581),184)
			Result.put (new_triple (1605,1582,1610),185)
			Result.put (new_triple (1604,1580,1605),186)
			Result.put (new_triple (1603,1605,1605),187)
			Result.put (new_triple (1604,1580,1605),188)
			Result.put (new_triple (1606,1580,1581),189)
			Result.put (new_triple (1580,1581,1610),190)
			Result.put (new_triple (1581,1580,1610),191)
			Result.put (new_triple (1605,1580,1610),192)
			Result.put (new_triple (1601,1605,1610),193)
			Result.put (new_triple (1576,1581,1610),194)
			Result.put (new_triple (1603,1605,1605),195)
			Result.put (new_triple (1593,1580,1605),196)
			Result.put (new_triple (1589,1605,1605),197)
			Result.put (new_triple (1587,1582,1610),198)
			Result.put (new_triple (1606,1580,1610),199)
			Result.put (new_triple (1589,1604,1746),240)
			Result.put (new_triple (1602,1604,1746),241)
			Result.put (new_quadruple (1575,1604,1604,1607),242)
			Result.put (new_quadruple (1575,1603,1576,1585),243)
			Result.put (new_quadruple (1605,1581,1605,1583),244)
			Result.put (new_quadruple (1589,1604,1593,1605),245)
			Result.put (new_quadruple (1585,1587,1608,1604),246)
			Result.put (new_quadruple (1593,1604,1610,1607),247)
			Result.put (new_quadruple (1608,1587,1604,1605),248)
			Result.put (new_triple (1589,1604,1609),249)
			Result.put (new_eighteen_tuple (1589,1604,1609,32,1575,1604,1604,1607,32,1593,1604,1610,1607,32,1608,1587,1604,1605),250)
			Result.put (new_octuple (1580,1604,32,1580,1604,1575,1604,1607),251)
			Result.put (new_quadruple (1585,1740,1575,1604),252)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_254: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (44),16)
			Result.put (new_singleton (12289),17)
			Result.put (new_singleton (12290),18)
			Result.put (new_singleton (58),19)
			Result.put (new_singleton (59),20)
			Result.put (new_singleton (33),21)
			Result.put (new_singleton (63),22)
			Result.put (new_singleton (12310),23)
			Result.put (new_singleton (12311),24)
			Result.put (new_singleton (8230),25)
			Result.put (new_singleton (8229),48)
			Result.put (new_singleton (8212),49)
			Result.put (new_singleton (8211),50)
			Result.put (new_singleton (95),51)
			Result.put (new_singleton (95),52)
			Result.put (new_singleton (40),53)
			Result.put (new_singleton (41),54)
			Result.put (new_singleton (123),55)
			Result.put (new_singleton (125),56)
			Result.put (new_singleton (12308),57)
			Result.put (new_singleton (12309),58)
			Result.put (new_singleton (12304),59)
			Result.put (new_singleton (12305),60)
			Result.put (new_singleton (12298),61)
			Result.put (new_singleton (12299),62)
			Result.put (new_singleton (12296),63)
			Result.put (new_singleton (12297),64)
			Result.put (new_singleton (12300),65)
			Result.put (new_singleton (12301),66)
			Result.put (new_singleton (12302),67)
			Result.put (new_singleton (12303),68)
			Result.put (new_singleton (91),71)
			Result.put (new_singleton (93),72)
			Result.put (new_singleton (8254),73)
			Result.put (new_singleton (8254),74)
			Result.put (new_singleton (8254),75)
			Result.put (new_singleton (8254),76)
			Result.put (new_singleton (95),77)
			Result.put (new_singleton (95),78)
			Result.put (new_singleton (95),79)
			Result.put (new_singleton (44),80)
			Result.put (new_singleton (12289),81)
			Result.put (new_singleton (46),82)
			Result.put (new_singleton (59),84)
			Result.put (new_singleton (58),85)
			Result.put (new_singleton (63),86)
			Result.put (new_singleton (33),87)
			Result.put (new_singleton (8212),88)
			Result.put (new_singleton (40),89)
			Result.put (new_singleton (41),90)
			Result.put (new_singleton (123),91)
			Result.put (new_singleton (125),92)
			Result.put (new_singleton (12308),93)
			Result.put (new_singleton (12309),94)
			Result.put (new_singleton (35),95)
			Result.put (new_singleton (38),96)
			Result.put (new_singleton (42),97)
			Result.put (new_singleton (43),98)
			Result.put (new_singleton (45),99)
			Result.put (new_singleton (60),100)
			Result.put (new_singleton (62),101)
			Result.put (new_singleton (61),102)
			Result.put (new_singleton (92),104)
			Result.put (new_singleton (36),105)
			Result.put (new_singleton (37),106)
			Result.put (new_singleton (64),107)
			Result.put (new_pair (32,1611),112)
			Result.put (new_pair (1600,1611),113)
			Result.put (new_pair (32,1612),114)
			Result.put (new_pair (32,1613),116)
			Result.put (new_pair (32,1614),118)
			Result.put (new_pair (1600,1614),119)
			Result.put (new_pair (32,1615),120)
			Result.put (new_pair (1600,1615),121)
			Result.put (new_pair (32,1616),122)
			Result.put (new_pair (1600,1616),123)
			Result.put (new_pair (32,1617),124)
			Result.put (new_pair (1600,1617),125)
			Result.put (new_pair (32,1618),126)
			Result.put (new_pair (1600,1618),127)
			Result.put (new_singleton (1569),128)
			Result.put (new_singleton (1570),129)
			Result.put (new_singleton (1570),130)
			Result.put (new_singleton (1571),131)
			Result.put (new_singleton (1571),132)
			Result.put (new_singleton (1572),133)
			Result.put (new_singleton (1572),134)
			Result.put (new_singleton (1573),135)
			Result.put (new_singleton (1573),136)
			Result.put (new_singleton (1574),137)
			Result.put (new_singleton (1574),138)
			Result.put (new_singleton (1574),139)
			Result.put (new_singleton (1574),140)
			Result.put (new_singleton (1575),141)
			Result.put (new_singleton (1575),142)
			Result.put (new_singleton (1576),143)
			Result.put (new_singleton (1576),144)
			Result.put (new_singleton (1576),145)
			Result.put (new_singleton (1576),146)
			Result.put (new_singleton (1577),147)
			Result.put (new_singleton (1577),148)
			Result.put (new_singleton (1578),149)
			Result.put (new_singleton (1578),150)
			Result.put (new_singleton (1578),151)
			Result.put (new_singleton (1578),152)
			Result.put (new_singleton (1579),153)
			Result.put (new_singleton (1579),154)
			Result.put (new_singleton (1579),155)
			Result.put (new_singleton (1579),156)
			Result.put (new_singleton (1580),157)
			Result.put (new_singleton (1580),158)
			Result.put (new_singleton (1580),159)
			Result.put (new_singleton (1580),160)
			Result.put (new_singleton (1581),161)
			Result.put (new_singleton (1581),162)
			Result.put (new_singleton (1581),163)
			Result.put (new_singleton (1581),164)
			Result.put (new_singleton (1582),165)
			Result.put (new_singleton (1582),166)
			Result.put (new_singleton (1582),167)
			Result.put (new_singleton (1582),168)
			Result.put (new_singleton (1583),169)
			Result.put (new_singleton (1583),170)
			Result.put (new_singleton (1584),171)
			Result.put (new_singleton (1584),172)
			Result.put (new_singleton (1585),173)
			Result.put (new_singleton (1585),174)
			Result.put (new_singleton (1586),175)
			Result.put (new_singleton (1586),176)
			Result.put (new_singleton (1587),177)
			Result.put (new_singleton (1587),178)
			Result.put (new_singleton (1587),179)
			Result.put (new_singleton (1587),180)
			Result.put (new_singleton (1588),181)
			Result.put (new_singleton (1588),182)
			Result.put (new_singleton (1588),183)
			Result.put (new_singleton (1588),184)
			Result.put (new_singleton (1589),185)
			Result.put (new_singleton (1589),186)
			Result.put (new_singleton (1589),187)
			Result.put (new_singleton (1589),188)
			Result.put (new_singleton (1590),189)
			Result.put (new_singleton (1590),190)
			Result.put (new_singleton (1590),191)
			Result.put (new_singleton (1590),192)
			Result.put (new_singleton (1591),193)
			Result.put (new_singleton (1591),194)
			Result.put (new_singleton (1591),195)
			Result.put (new_singleton (1591),196)
			Result.put (new_singleton (1592),197)
			Result.put (new_singleton (1592),198)
			Result.put (new_singleton (1592),199)
			Result.put (new_singleton (1592),200)
			Result.put (new_singleton (1593),201)
			Result.put (new_singleton (1593),202)
			Result.put (new_singleton (1593),203)
			Result.put (new_singleton (1593),204)
			Result.put (new_singleton (1594),205)
			Result.put (new_singleton (1594),206)
			Result.put (new_singleton (1594),207)
			Result.put (new_singleton (1594),208)
			Result.put (new_singleton (1601),209)
			Result.put (new_singleton (1601),210)
			Result.put (new_singleton (1601),211)
			Result.put (new_singleton (1601),212)
			Result.put (new_singleton (1602),213)
			Result.put (new_singleton (1602),214)
			Result.put (new_singleton (1602),215)
			Result.put (new_singleton (1602),216)
			Result.put (new_singleton (1603),217)
			Result.put (new_singleton (1603),218)
			Result.put (new_singleton (1603),219)
			Result.put (new_singleton (1603),220)
			Result.put (new_singleton (1604),221)
			Result.put (new_singleton (1604),222)
			Result.put (new_singleton (1604),223)
			Result.put (new_singleton (1604),224)
			Result.put (new_singleton (1605),225)
			Result.put (new_singleton (1605),226)
			Result.put (new_singleton (1605),227)
			Result.put (new_singleton (1605),228)
			Result.put (new_singleton (1606),229)
			Result.put (new_singleton (1606),230)
			Result.put (new_singleton (1606),231)
			Result.put (new_singleton (1606),232)
			Result.put (new_singleton (1607),233)
			Result.put (new_singleton (1607),234)
			Result.put (new_singleton (1607),235)
			Result.put (new_singleton (1607),236)
			Result.put (new_singleton (1608),237)
			Result.put (new_singleton (1608),238)
			Result.put (new_singleton (1609),239)
			Result.put (new_singleton (1609),240)
			Result.put (new_singleton (1610),241)
			Result.put (new_singleton (1610),242)
			Result.put (new_singleton (1610),243)
			Result.put (new_singleton (1610),244)
			Result.put (new_pair (1604,1570),245)
			Result.put (new_pair (1604,1570),246)
			Result.put (new_pair (1604,1571),247)
			Result.put (new_pair (1604,1571),248)
			Result.put (new_pair (1604,1573),249)
			Result.put (new_pair (1604,1573),250)
			Result.put (new_pair (1604,1575),251)
			Result.put (new_pair (1604,1575),252)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0_segment_255: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (33),1)
			Result.put (new_singleton (34),2)
			Result.put (new_singleton (35),3)
			Result.put (new_singleton (36),4)
			Result.put (new_singleton (37),5)
			Result.put (new_singleton (38),6)
			Result.put (new_singleton (39),7)
			Result.put (new_singleton (40),8)
			Result.put (new_singleton (41),9)
			Result.put (new_singleton (42),10)
			Result.put (new_singleton (43),11)
			Result.put (new_singleton (44),12)
			Result.put (new_singleton (45),13)
			Result.put (new_singleton (46),14)
			Result.put (new_singleton (47),15)
			Result.put (new_singleton (48),16)
			Result.put (new_singleton (49),17)
			Result.put (new_singleton (50),18)
			Result.put (new_singleton (51),19)
			Result.put (new_singleton (52),20)
			Result.put (new_singleton (53),21)
			Result.put (new_singleton (54),22)
			Result.put (new_singleton (55),23)
			Result.put (new_singleton (56),24)
			Result.put (new_singleton (57),25)
			Result.put (new_singleton (58),26)
			Result.put (new_singleton (59),27)
			Result.put (new_singleton (60),28)
			Result.put (new_singleton (61),29)
			Result.put (new_singleton (62),30)
			Result.put (new_singleton (63),31)
			Result.put (new_singleton (64),32)
			Result.put (new_singleton (65),33)
			Result.put (new_singleton (66),34)
			Result.put (new_singleton (67),35)
			Result.put (new_singleton (68),36)
			Result.put (new_singleton (69),37)
			Result.put (new_singleton (70),38)
			Result.put (new_singleton (71),39)
			Result.put (new_singleton (72),40)
			Result.put (new_singleton (73),41)
			Result.put (new_singleton (74),42)
			Result.put (new_singleton (75),43)
			Result.put (new_singleton (76),44)
			Result.put (new_singleton (77),45)
			Result.put (new_singleton (78),46)
			Result.put (new_singleton (79),47)
			Result.put (new_singleton (80),48)
			Result.put (new_singleton (81),49)
			Result.put (new_singleton (82),50)
			Result.put (new_singleton (83),51)
			Result.put (new_singleton (84),52)
			Result.put (new_singleton (85),53)
			Result.put (new_singleton (86),54)
			Result.put (new_singleton (87),55)
			Result.put (new_singleton (88),56)
			Result.put (new_singleton (89),57)
			Result.put (new_singleton (90),58)
			Result.put (new_singleton (91),59)
			Result.put (new_singleton (92),60)
			Result.put (new_singleton (93),61)
			Result.put (new_singleton (94),62)
			Result.put (new_singleton (95),63)
			Result.put (new_singleton (96),64)
			Result.put (new_singleton (97),65)
			Result.put (new_singleton (98),66)
			Result.put (new_singleton (99),67)
			Result.put (new_singleton (100),68)
			Result.put (new_singleton (101),69)
			Result.put (new_singleton (102),70)
			Result.put (new_singleton (103),71)
			Result.put (new_singleton (104),72)
			Result.put (new_singleton (105),73)
			Result.put (new_singleton (106),74)
			Result.put (new_singleton (107),75)
			Result.put (new_singleton (108),76)
			Result.put (new_singleton (109),77)
			Result.put (new_singleton (110),78)
			Result.put (new_singleton (111),79)
			Result.put (new_singleton (112),80)
			Result.put (new_singleton (113),81)
			Result.put (new_singleton (114),82)
			Result.put (new_singleton (115),83)
			Result.put (new_singleton (116),84)
			Result.put (new_singleton (117),85)
			Result.put (new_singleton (118),86)
			Result.put (new_singleton (119),87)
			Result.put (new_singleton (120),88)
			Result.put (new_singleton (121),89)
			Result.put (new_singleton (122),90)
			Result.put (new_singleton (123),91)
			Result.put (new_singleton (124),92)
			Result.put (new_singleton (125),93)
			Result.put (new_singleton (126),94)
			Result.put (new_singleton (10629),95)
			Result.put (new_singleton (10630),96)
			Result.put (new_singleton (12290),97)
			Result.put (new_singleton (12300),98)
			Result.put (new_singleton (12301),99)
			Result.put (new_singleton (12289),100)
			Result.put (new_singleton (12539),101)
			Result.put (new_singleton (12530),102)
			Result.put (new_singleton (12449),103)
			Result.put (new_singleton (12451),104)
			Result.put (new_singleton (12453),105)
			Result.put (new_singleton (12455),106)
			Result.put (new_singleton (12457),107)
			Result.put (new_singleton (12515),108)
			Result.put (new_singleton (12517),109)
			Result.put (new_singleton (12519),110)
			Result.put (new_singleton (12483),111)
			Result.put (new_singleton (12540),112)
			Result.put (new_singleton (12450),113)
			Result.put (new_singleton (12452),114)
			Result.put (new_singleton (12454),115)
			Result.put (new_singleton (12456),116)
			Result.put (new_singleton (12458),117)
			Result.put (new_singleton (12459),118)
			Result.put (new_singleton (12461),119)
			Result.put (new_singleton (12463),120)
			Result.put (new_singleton (12465),121)
			Result.put (new_singleton (12467),122)
			Result.put (new_singleton (12469),123)
			Result.put (new_singleton (12471),124)
			Result.put (new_singleton (12473),125)
			Result.put (new_singleton (12475),126)
			Result.put (new_singleton (12477),127)
			Result.put (new_singleton (12479),128)
			Result.put (new_singleton (12481),129)
			Result.put (new_singleton (12484),130)
			Result.put (new_singleton (12486),131)
			Result.put (new_singleton (12488),132)
			Result.put (new_singleton (12490),133)
			Result.put (new_singleton (12491),134)
			Result.put (new_singleton (12492),135)
			Result.put (new_singleton (12493),136)
			Result.put (new_singleton (12494),137)
			Result.put (new_singleton (12495),138)
			Result.put (new_singleton (12498),139)
			Result.put (new_singleton (12501),140)
			Result.put (new_singleton (12504),141)
			Result.put (new_singleton (12507),142)
			Result.put (new_singleton (12510),143)
			Result.put (new_singleton (12511),144)
			Result.put (new_singleton (12512),145)
			Result.put (new_singleton (12513),146)
			Result.put (new_singleton (12514),147)
			Result.put (new_singleton (12516),148)
			Result.put (new_singleton (12518),149)
			Result.put (new_singleton (12520),150)
			Result.put (new_singleton (12521),151)
			Result.put (new_singleton (12522),152)
			Result.put (new_singleton (12523),153)
			Result.put (new_singleton (12524),154)
			Result.put (new_singleton (12525),155)
			Result.put (new_singleton (12527),156)
			Result.put (new_singleton (12531),157)
			Result.put (new_singleton (12441),158)
			Result.put (new_singleton (12442),159)
			Result.put (new_singleton (12644),160)
			Result.put (new_singleton (12593),161)
			Result.put (new_singleton (12594),162)
			Result.put (new_singleton (12595),163)
			Result.put (new_singleton (12596),164)
			Result.put (new_singleton (12597),165)
			Result.put (new_singleton (12598),166)
			Result.put (new_singleton (12599),167)
			Result.put (new_singleton (12600),168)
			Result.put (new_singleton (12601),169)
			Result.put (new_singleton (12602),170)
			Result.put (new_singleton (12603),171)
			Result.put (new_singleton (12604),172)
			Result.put (new_singleton (12605),173)
			Result.put (new_singleton (12606),174)
			Result.put (new_singleton (12607),175)
			Result.put (new_singleton (12608),176)
			Result.put (new_singleton (12609),177)
			Result.put (new_singleton (12610),178)
			Result.put (new_singleton (12611),179)
			Result.put (new_singleton (12612),180)
			Result.put (new_singleton (12613),181)
			Result.put (new_singleton (12614),182)
			Result.put (new_singleton (12615),183)
			Result.put (new_singleton (12616),184)
			Result.put (new_singleton (12617),185)
			Result.put (new_singleton (12618),186)
			Result.put (new_singleton (12619),187)
			Result.put (new_singleton (12620),188)
			Result.put (new_singleton (12621),189)
			Result.put (new_singleton (12622),190)
			Result.put (new_singleton (12623),194)
			Result.put (new_singleton (12624),195)
			Result.put (new_singleton (12625),196)
			Result.put (new_singleton (12626),197)
			Result.put (new_singleton (12627),198)
			Result.put (new_singleton (12628),199)
			Result.put (new_singleton (12629),202)
			Result.put (new_singleton (12630),203)
			Result.put (new_singleton (12631),204)
			Result.put (new_singleton (12632),205)
			Result.put (new_singleton (12633),206)
			Result.put (new_singleton (12634),207)
			Result.put (new_singleton (12635),210)
			Result.put (new_singleton (12636),211)
			Result.put (new_singleton (12637),212)
			Result.put (new_singleton (12638),213)
			Result.put (new_singleton (12639),214)
			Result.put (new_singleton (12640),215)
			Result.put (new_singleton (12641),218)
			Result.put (new_singleton (12642),219)
			Result.put (new_singleton (12643),220)
			Result.put (new_singleton (162),224)
			Result.put (new_singleton (163),225)
			Result.put (new_singleton (172),226)
			Result.put (new_singleton (175),227)
			Result.put (new_singleton (166),228)
			Result.put (new_singleton (165),229)
			Result.put (new_singleton (8361),230)
			Result.put (new_singleton (9474),232)
			Result.put (new_singleton (8592),233)
			Result.put (new_singleton (8593),234)
			Result.put (new_singleton (8594),235)
			Result.put (new_singleton (8595),236)
			Result.put (new_singleton (9632),237)
			Result.put (new_singleton (9675),238)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_0: SPECIAL [ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]]
			-- Generated array plane
		once
			create Result.make_filled (decomposition_mapping_plane_0_segment_0, 256)
			Result.put (decomposition_mapping_plane_0_segment_1, 1)
			Result.put (decomposition_mapping_plane_0_segment_2, 2)
			Result.put (decomposition_mapping_plane_0_segment_3, 3)
			Result.put (decomposition_mapping_plane_0_segment_4, 4)
			Result.put (decomposition_mapping_plane_0_segment_5, 5)
			Result.put (decomposition_mapping_plane_0_segment_6, 6)
			Result.put (all_empty_decomposition_mapping_segment, 7)
			Result.put (all_empty_decomposition_mapping_segment, 8)
			Result.put (decomposition_mapping_plane_0_segment_9, 9)
			Result.put (decomposition_mapping_plane_0_segment_10, 10)
			Result.put (decomposition_mapping_plane_0_segment_11, 11)
			Result.put (decomposition_mapping_plane_0_segment_12, 12)
			Result.put (decomposition_mapping_plane_0_segment_13, 13)
			Result.put (decomposition_mapping_plane_0_segment_14, 14)
			Result.put (decomposition_mapping_plane_0_segment_15, 15)
			Result.put (decomposition_mapping_plane_0_segment_16, 16)
			Result.put (all_empty_decomposition_mapping_segment, 17)
			Result.put (all_empty_decomposition_mapping_segment, 18)
			Result.put (all_empty_decomposition_mapping_segment, 19)
			Result.put (all_empty_decomposition_mapping_segment, 20)
			Result.put (all_empty_decomposition_mapping_segment, 21)
			Result.put (all_empty_decomposition_mapping_segment, 22)
			Result.put (all_empty_decomposition_mapping_segment, 23)
			Result.put (all_empty_decomposition_mapping_segment, 24)
			Result.put (all_empty_decomposition_mapping_segment, 25)
			Result.put (all_empty_decomposition_mapping_segment, 26)
			Result.put (decomposition_mapping_plane_0_segment_27, 27)
			Result.put (all_empty_decomposition_mapping_segment, 28)
			Result.put (decomposition_mapping_plane_0_segment_29, 29)
			Result.put (decomposition_mapping_plane_0_segment_30, 30)
			Result.put (decomposition_mapping_plane_0_segment_31, 31)
			Result.put (decomposition_mapping_plane_0_segment_32, 32)
			Result.put (decomposition_mapping_plane_0_segment_33, 33)
			Result.put (decomposition_mapping_plane_0_segment_34, 34)
			Result.put (decomposition_mapping_plane_0_segment_35, 35)
			Result.put (decomposition_mapping_plane_0_segment_36, 36)
			Result.put (all_empty_decomposition_mapping_segment, 37)
			Result.put (all_empty_decomposition_mapping_segment, 38)
			Result.put (all_empty_decomposition_mapping_segment, 39)
			Result.put (all_empty_decomposition_mapping_segment, 40)
			Result.put (all_empty_decomposition_mapping_segment, 41)
			Result.put (decomposition_mapping_plane_0_segment_42, 42)
			Result.put (all_empty_decomposition_mapping_segment, 43)
			Result.put (decomposition_mapping_plane_0_segment_44, 44)
			Result.put (decomposition_mapping_plane_0_segment_45, 45)
			Result.put (decomposition_mapping_plane_0_segment_46, 46)
			Result.put (decomposition_mapping_plane_0_segment_47, 47)
			Result.put (decomposition_mapping_plane_0_segment_48, 48)
			Result.put (decomposition_mapping_plane_0_segment_49, 49)
			Result.put (decomposition_mapping_plane_0_segment_50, 50)
			Result.put (decomposition_mapping_plane_0_segment_51, 51)
			Result.put (all_empty_decomposition_mapping_segment, 52)
			Result.put (all_empty_decomposition_mapping_segment, 53)
			Result.put (all_empty_decomposition_mapping_segment, 54)
			Result.put (all_empty_decomposition_mapping_segment, 55)
			Result.put (all_empty_decomposition_mapping_segment, 56)
			Result.put (all_empty_decomposition_mapping_segment, 57)
			Result.put (all_empty_decomposition_mapping_segment, 58)
			Result.put (all_empty_decomposition_mapping_segment, 59)
			Result.put (all_empty_decomposition_mapping_segment, 60)
			Result.put (all_empty_decomposition_mapping_segment, 61)
			Result.put (all_empty_decomposition_mapping_segment, 62)
			Result.put (all_empty_decomposition_mapping_segment, 63)
			Result.put (all_empty_decomposition_mapping_segment, 64)
			Result.put (all_empty_decomposition_mapping_segment, 65)
			Result.put (all_empty_decomposition_mapping_segment, 66)
			Result.put (all_empty_decomposition_mapping_segment, 67)
			Result.put (all_empty_decomposition_mapping_segment, 68)
			Result.put (all_empty_decomposition_mapping_segment, 69)
			Result.put (all_empty_decomposition_mapping_segment, 70)
			Result.put (all_empty_decomposition_mapping_segment, 71)
			Result.put (all_empty_decomposition_mapping_segment, 72)
			Result.put (all_empty_decomposition_mapping_segment, 73)
			Result.put (all_empty_decomposition_mapping_segment, 74)
			Result.put (all_empty_decomposition_mapping_segment, 75)
			Result.put (all_empty_decomposition_mapping_segment, 76)
			Result.put (all_empty_decomposition_mapping_segment, 77)
			Result.put (all_empty_decomposition_mapping_segment, 78)
			Result.put (all_empty_decomposition_mapping_segment, 79)
			Result.put (all_empty_decomposition_mapping_segment, 80)
			Result.put (all_empty_decomposition_mapping_segment, 81)
			Result.put (all_empty_decomposition_mapping_segment, 82)
			Result.put (all_empty_decomposition_mapping_segment, 83)
			Result.put (all_empty_decomposition_mapping_segment, 84)
			Result.put (all_empty_decomposition_mapping_segment, 85)
			Result.put (all_empty_decomposition_mapping_segment, 86)
			Result.put (all_empty_decomposition_mapping_segment, 87)
			Result.put (all_empty_decomposition_mapping_segment, 88)
			Result.put (all_empty_decomposition_mapping_segment, 89)
			Result.put (all_empty_decomposition_mapping_segment, 90)
			Result.put (all_empty_decomposition_mapping_segment, 91)
			Result.put (all_empty_decomposition_mapping_segment, 92)
			Result.put (all_empty_decomposition_mapping_segment, 93)
			Result.put (all_empty_decomposition_mapping_segment, 94)
			Result.put (all_empty_decomposition_mapping_segment, 95)
			Result.put (all_empty_decomposition_mapping_segment, 96)
			Result.put (all_empty_decomposition_mapping_segment, 97)
			Result.put (all_empty_decomposition_mapping_segment, 98)
			Result.put (all_empty_decomposition_mapping_segment, 99)
			Result.put (all_empty_decomposition_mapping_segment, 100)
			Result.put (all_empty_decomposition_mapping_segment, 101)
			Result.put (all_empty_decomposition_mapping_segment, 102)
			Result.put (all_empty_decomposition_mapping_segment, 103)
			Result.put (all_empty_decomposition_mapping_segment, 104)
			Result.put (all_empty_decomposition_mapping_segment, 105)
			Result.put (all_empty_decomposition_mapping_segment, 106)
			Result.put (all_empty_decomposition_mapping_segment, 107)
			Result.put (all_empty_decomposition_mapping_segment, 108)
			Result.put (all_empty_decomposition_mapping_segment, 109)
			Result.put (all_empty_decomposition_mapping_segment, 110)
			Result.put (all_empty_decomposition_mapping_segment, 111)
			Result.put (all_empty_decomposition_mapping_segment, 112)
			Result.put (all_empty_decomposition_mapping_segment, 113)
			Result.put (all_empty_decomposition_mapping_segment, 114)
			Result.put (all_empty_decomposition_mapping_segment, 115)
			Result.put (all_empty_decomposition_mapping_segment, 116)
			Result.put (all_empty_decomposition_mapping_segment, 117)
			Result.put (all_empty_decomposition_mapping_segment, 118)
			Result.put (all_empty_decomposition_mapping_segment, 119)
			Result.put (all_empty_decomposition_mapping_segment, 120)
			Result.put (all_empty_decomposition_mapping_segment, 121)
			Result.put (all_empty_decomposition_mapping_segment, 122)
			Result.put (all_empty_decomposition_mapping_segment, 123)
			Result.put (all_empty_decomposition_mapping_segment, 124)
			Result.put (all_empty_decomposition_mapping_segment, 125)
			Result.put (all_empty_decomposition_mapping_segment, 126)
			Result.put (all_empty_decomposition_mapping_segment, 127)
			Result.put (all_empty_decomposition_mapping_segment, 128)
			Result.put (all_empty_decomposition_mapping_segment, 129)
			Result.put (all_empty_decomposition_mapping_segment, 130)
			Result.put (all_empty_decomposition_mapping_segment, 131)
			Result.put (all_empty_decomposition_mapping_segment, 132)
			Result.put (all_empty_decomposition_mapping_segment, 133)
			Result.put (all_empty_decomposition_mapping_segment, 134)
			Result.put (all_empty_decomposition_mapping_segment, 135)
			Result.put (all_empty_decomposition_mapping_segment, 136)
			Result.put (all_empty_decomposition_mapping_segment, 137)
			Result.put (all_empty_decomposition_mapping_segment, 138)
			Result.put (all_empty_decomposition_mapping_segment, 139)
			Result.put (all_empty_decomposition_mapping_segment, 140)
			Result.put (all_empty_decomposition_mapping_segment, 141)
			Result.put (all_empty_decomposition_mapping_segment, 142)
			Result.put (all_empty_decomposition_mapping_segment, 143)
			Result.put (all_empty_decomposition_mapping_segment, 144)
			Result.put (all_empty_decomposition_mapping_segment, 145)
			Result.put (all_empty_decomposition_mapping_segment, 146)
			Result.put (all_empty_decomposition_mapping_segment, 147)
			Result.put (all_empty_decomposition_mapping_segment, 148)
			Result.put (all_empty_decomposition_mapping_segment, 149)
			Result.put (all_empty_decomposition_mapping_segment, 150)
			Result.put (all_empty_decomposition_mapping_segment, 151)
			Result.put (all_empty_decomposition_mapping_segment, 152)
			Result.put (all_empty_decomposition_mapping_segment, 153)
			Result.put (all_empty_decomposition_mapping_segment, 154)
			Result.put (all_empty_decomposition_mapping_segment, 155)
			Result.put (all_empty_decomposition_mapping_segment, 156)
			Result.put (all_empty_decomposition_mapping_segment, 157)
			Result.put (all_empty_decomposition_mapping_segment, 158)
			Result.put (all_empty_decomposition_mapping_segment, 159)
			Result.put (all_empty_decomposition_mapping_segment, 160)
			Result.put (all_empty_decomposition_mapping_segment, 161)
			Result.put (all_empty_decomposition_mapping_segment, 162)
			Result.put (all_empty_decomposition_mapping_segment, 163)
			Result.put (all_empty_decomposition_mapping_segment, 164)
			Result.put (all_empty_decomposition_mapping_segment, 165)
			Result.put (all_empty_decomposition_mapping_segment, 166)
			Result.put (decomposition_mapping_plane_0_segment_167, 167)
			Result.put (all_empty_decomposition_mapping_segment, 168)
			Result.put (all_empty_decomposition_mapping_segment, 169)
			Result.put (all_empty_decomposition_mapping_segment, 170)
			Result.put (all_empty_decomposition_mapping_segment, 171)
			Result.put (decomposition_mapping_plane_0_segment_172, 172)
			Result.put (decomposition_mapping_plane_0_segment_173, 173)
			Result.put (decomposition_mapping_plane_0_segment_174, 174)
			Result.put (decomposition_mapping_plane_0_segment_175, 175)
			Result.put (decomposition_mapping_plane_0_segment_176, 176)
			Result.put (decomposition_mapping_plane_0_segment_177, 177)
			Result.put (decomposition_mapping_plane_0_segment_178, 178)
			Result.put (decomposition_mapping_plane_0_segment_179, 179)
			Result.put (decomposition_mapping_plane_0_segment_180, 180)
			Result.put (decomposition_mapping_plane_0_segment_181, 181)
			Result.put (decomposition_mapping_plane_0_segment_182, 182)
			Result.put (decomposition_mapping_plane_0_segment_183, 183)
			Result.put (decomposition_mapping_plane_0_segment_184, 184)
			Result.put (decomposition_mapping_plane_0_segment_185, 185)
			Result.put (decomposition_mapping_plane_0_segment_186, 186)
			Result.put (decomposition_mapping_plane_0_segment_187, 187)
			Result.put (decomposition_mapping_plane_0_segment_188, 188)
			Result.put (decomposition_mapping_plane_0_segment_189, 189)
			Result.put (decomposition_mapping_plane_0_segment_190, 190)
			Result.put (decomposition_mapping_plane_0_segment_191, 191)
			Result.put (decomposition_mapping_plane_0_segment_192, 192)
			Result.put (decomposition_mapping_plane_0_segment_193, 193)
			Result.put (decomposition_mapping_plane_0_segment_194, 194)
			Result.put (decomposition_mapping_plane_0_segment_195, 195)
			Result.put (decomposition_mapping_plane_0_segment_196, 196)
			Result.put (decomposition_mapping_plane_0_segment_197, 197)
			Result.put (decomposition_mapping_plane_0_segment_198, 198)
			Result.put (decomposition_mapping_plane_0_segment_199, 199)
			Result.put (decomposition_mapping_plane_0_segment_200, 200)
			Result.put (decomposition_mapping_plane_0_segment_201, 201)
			Result.put (decomposition_mapping_plane_0_segment_202, 202)
			Result.put (decomposition_mapping_plane_0_segment_203, 203)
			Result.put (decomposition_mapping_plane_0_segment_204, 204)
			Result.put (decomposition_mapping_plane_0_segment_205, 205)
			Result.put (decomposition_mapping_plane_0_segment_206, 206)
			Result.put (decomposition_mapping_plane_0_segment_207, 207)
			Result.put (decomposition_mapping_plane_0_segment_208, 208)
			Result.put (decomposition_mapping_plane_0_segment_209, 209)
			Result.put (decomposition_mapping_plane_0_segment_210, 210)
			Result.put (decomposition_mapping_plane_0_segment_211, 211)
			Result.put (decomposition_mapping_plane_0_segment_212, 212)
			Result.put (decomposition_mapping_plane_0_segment_213, 213)
			Result.put (decomposition_mapping_plane_0_segment_214, 214)
			Result.put (decomposition_mapping_plane_0_segment_215, 215)
			Result.put (all_empty_decomposition_mapping_segment, 216)
			Result.put (all_empty_decomposition_mapping_segment, 217)
			Result.put (all_empty_decomposition_mapping_segment, 218)
			Result.put (all_empty_decomposition_mapping_segment, 219)
			Result.put (all_empty_decomposition_mapping_segment, 220)
			Result.put (all_empty_decomposition_mapping_segment, 221)
			Result.put (all_empty_decomposition_mapping_segment, 222)
			Result.put (all_empty_decomposition_mapping_segment, 223)
			Result.put (all_empty_decomposition_mapping_segment, 224)
			Result.put (all_empty_decomposition_mapping_segment, 225)
			Result.put (all_empty_decomposition_mapping_segment, 226)
			Result.put (all_empty_decomposition_mapping_segment, 227)
			Result.put (all_empty_decomposition_mapping_segment, 228)
			Result.put (all_empty_decomposition_mapping_segment, 229)
			Result.put (all_empty_decomposition_mapping_segment, 230)
			Result.put (all_empty_decomposition_mapping_segment, 231)
			Result.put (all_empty_decomposition_mapping_segment, 232)
			Result.put (all_empty_decomposition_mapping_segment, 233)
			Result.put (all_empty_decomposition_mapping_segment, 234)
			Result.put (all_empty_decomposition_mapping_segment, 235)
			Result.put (all_empty_decomposition_mapping_segment, 236)
			Result.put (all_empty_decomposition_mapping_segment, 237)
			Result.put (all_empty_decomposition_mapping_segment, 238)
			Result.put (all_empty_decomposition_mapping_segment, 239)
			Result.put (all_empty_decomposition_mapping_segment, 240)
			Result.put (all_empty_decomposition_mapping_segment, 241)
			Result.put (all_empty_decomposition_mapping_segment, 242)
			Result.put (all_empty_decomposition_mapping_segment, 243)
			Result.put (all_empty_decomposition_mapping_segment, 244)
			Result.put (all_empty_decomposition_mapping_segment, 245)
			Result.put (all_empty_decomposition_mapping_segment, 246)
			Result.put (all_empty_decomposition_mapping_segment, 247)
			Result.put (all_empty_decomposition_mapping_segment, 248)
			Result.put (decomposition_mapping_plane_0_segment_249, 249)
			Result.put (decomposition_mapping_plane_0_segment_250, 250)
			Result.put (decomposition_mapping_plane_0_segment_251, 251)
			Result.put (decomposition_mapping_plane_0_segment_252, 252)
			Result.put (decomposition_mapping_plane_0_segment_253, 253)
			Result.put (decomposition_mapping_plane_0_segment_254, 254)
			Result.put (decomposition_mapping_plane_0_segment_255, 255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	decomposition_mapping_plane_1_segment_209: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_pair (119127,119141),94)
			Result.put (new_pair (119128,119141),95)
			Result.put (new_pair (119135,119150),96)
			Result.put (new_pair (119135,119151),97)
			Result.put (new_pair (119135,119152),98)
			Result.put (new_pair (119135,119153),99)
			Result.put (new_pair (119135,119154),100)
			Result.put (new_pair (119225,119141),187)
			Result.put (new_pair (119226,119141),188)
			Result.put (new_pair (119227,119150),189)
			Result.put (new_pair (119228,119150),190)
			Result.put (new_pair (119227,119151),191)
			Result.put (new_pair (119228,119151),192)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_1_segment_212: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (65),0)
			Result.put (new_singleton (66),1)
			Result.put (new_singleton (67),2)
			Result.put (new_singleton (68),3)
			Result.put (new_singleton (69),4)
			Result.put (new_singleton (70),5)
			Result.put (new_singleton (71),6)
			Result.put (new_singleton (72),7)
			Result.put (new_singleton (73),8)
			Result.put (new_singleton (74),9)
			Result.put (new_singleton (75),10)
			Result.put (new_singleton (76),11)
			Result.put (new_singleton (77),12)
			Result.put (new_singleton (78),13)
			Result.put (new_singleton (79),14)
			Result.put (new_singleton (80),15)
			Result.put (new_singleton (81),16)
			Result.put (new_singleton (82),17)
			Result.put (new_singleton (83),18)
			Result.put (new_singleton (84),19)
			Result.put (new_singleton (85),20)
			Result.put (new_singleton (86),21)
			Result.put (new_singleton (87),22)
			Result.put (new_singleton (88),23)
			Result.put (new_singleton (89),24)
			Result.put (new_singleton (90),25)
			Result.put (new_singleton (97),26)
			Result.put (new_singleton (98),27)
			Result.put (new_singleton (99),28)
			Result.put (new_singleton (100),29)
			Result.put (new_singleton (101),30)
			Result.put (new_singleton (102),31)
			Result.put (new_singleton (103),32)
			Result.put (new_singleton (104),33)
			Result.put (new_singleton (105),34)
			Result.put (new_singleton (106),35)
			Result.put (new_singleton (107),36)
			Result.put (new_singleton (108),37)
			Result.put (new_singleton (109),38)
			Result.put (new_singleton (110),39)
			Result.put (new_singleton (111),40)
			Result.put (new_singleton (112),41)
			Result.put (new_singleton (113),42)
			Result.put (new_singleton (114),43)
			Result.put (new_singleton (115),44)
			Result.put (new_singleton (116),45)
			Result.put (new_singleton (117),46)
			Result.put (new_singleton (118),47)
			Result.put (new_singleton (119),48)
			Result.put (new_singleton (120),49)
			Result.put (new_singleton (121),50)
			Result.put (new_singleton (122),51)
			Result.put (new_singleton (65),52)
			Result.put (new_singleton (66),53)
			Result.put (new_singleton (67),54)
			Result.put (new_singleton (68),55)
			Result.put (new_singleton (69),56)
			Result.put (new_singleton (70),57)
			Result.put (new_singleton (71),58)
			Result.put (new_singleton (72),59)
			Result.put (new_singleton (73),60)
			Result.put (new_singleton (74),61)
			Result.put (new_singleton (75),62)
			Result.put (new_singleton (76),63)
			Result.put (new_singleton (77),64)
			Result.put (new_singleton (78),65)
			Result.put (new_singleton (79),66)
			Result.put (new_singleton (80),67)
			Result.put (new_singleton (81),68)
			Result.put (new_singleton (82),69)
			Result.put (new_singleton (83),70)
			Result.put (new_singleton (84),71)
			Result.put (new_singleton (85),72)
			Result.put (new_singleton (86),73)
			Result.put (new_singleton (87),74)
			Result.put (new_singleton (88),75)
			Result.put (new_singleton (89),76)
			Result.put (new_singleton (90),77)
			Result.put (new_singleton (97),78)
			Result.put (new_singleton (98),79)
			Result.put (new_singleton (99),80)
			Result.put (new_singleton (100),81)
			Result.put (new_singleton (101),82)
			Result.put (new_singleton (102),83)
			Result.put (new_singleton (103),84)
			Result.put (new_singleton (105),86)
			Result.put (new_singleton (106),87)
			Result.put (new_singleton (107),88)
			Result.put (new_singleton (108),89)
			Result.put (new_singleton (109),90)
			Result.put (new_singleton (110),91)
			Result.put (new_singleton (111),92)
			Result.put (new_singleton (112),93)
			Result.put (new_singleton (113),94)
			Result.put (new_singleton (114),95)
			Result.put (new_singleton (115),96)
			Result.put (new_singleton (116),97)
			Result.put (new_singleton (117),98)
			Result.put (new_singleton (118),99)
			Result.put (new_singleton (119),100)
			Result.put (new_singleton (120),101)
			Result.put (new_singleton (121),102)
			Result.put (new_singleton (122),103)
			Result.put (new_singleton (65),104)
			Result.put (new_singleton (66),105)
			Result.put (new_singleton (67),106)
			Result.put (new_singleton (68),107)
			Result.put (new_singleton (69),108)
			Result.put (new_singleton (70),109)
			Result.put (new_singleton (71),110)
			Result.put (new_singleton (72),111)
			Result.put (new_singleton (73),112)
			Result.put (new_singleton (74),113)
			Result.put (new_singleton (75),114)
			Result.put (new_singleton (76),115)
			Result.put (new_singleton (77),116)
			Result.put (new_singleton (78),117)
			Result.put (new_singleton (79),118)
			Result.put (new_singleton (80),119)
			Result.put (new_singleton (81),120)
			Result.put (new_singleton (82),121)
			Result.put (new_singleton (83),122)
			Result.put (new_singleton (84),123)
			Result.put (new_singleton (85),124)
			Result.put (new_singleton (86),125)
			Result.put (new_singleton (87),126)
			Result.put (new_singleton (88),127)
			Result.put (new_singleton (89),128)
			Result.put (new_singleton (90),129)
			Result.put (new_singleton (97),130)
			Result.put (new_singleton (98),131)
			Result.put (new_singleton (99),132)
			Result.put (new_singleton (100),133)
			Result.put (new_singleton (101),134)
			Result.put (new_singleton (102),135)
			Result.put (new_singleton (103),136)
			Result.put (new_singleton (104),137)
			Result.put (new_singleton (105),138)
			Result.put (new_singleton (106),139)
			Result.put (new_singleton (107),140)
			Result.put (new_singleton (108),141)
			Result.put (new_singleton (109),142)
			Result.put (new_singleton (110),143)
			Result.put (new_singleton (111),144)
			Result.put (new_singleton (112),145)
			Result.put (new_singleton (113),146)
			Result.put (new_singleton (114),147)
			Result.put (new_singleton (115),148)
			Result.put (new_singleton (116),149)
			Result.put (new_singleton (117),150)
			Result.put (new_singleton (118),151)
			Result.put (new_singleton (119),152)
			Result.put (new_singleton (120),153)
			Result.put (new_singleton (121),154)
			Result.put (new_singleton (122),155)
			Result.put (new_singleton (65),156)
			Result.put (new_singleton (67),158)
			Result.put (new_singleton (68),159)
			Result.put (new_singleton (71),162)
			Result.put (new_singleton (74),165)
			Result.put (new_singleton (75),166)
			Result.put (new_singleton (78),169)
			Result.put (new_singleton (79),170)
			Result.put (new_singleton (80),171)
			Result.put (new_singleton (81),172)
			Result.put (new_singleton (83),174)
			Result.put (new_singleton (84),175)
			Result.put (new_singleton (85),176)
			Result.put (new_singleton (86),177)
			Result.put (new_singleton (87),178)
			Result.put (new_singleton (88),179)
			Result.put (new_singleton (89),180)
			Result.put (new_singleton (90),181)
			Result.put (new_singleton (97),182)
			Result.put (new_singleton (98),183)
			Result.put (new_singleton (99),184)
			Result.put (new_singleton (100),185)
			Result.put (new_singleton (102),187)
			Result.put (new_singleton (104),189)
			Result.put (new_singleton (105),190)
			Result.put (new_singleton (106),191)
			Result.put (new_singleton (107),192)
			Result.put (new_singleton (108),193)
			Result.put (new_singleton (109),194)
			Result.put (new_singleton (110),195)
			Result.put (new_singleton (112),197)
			Result.put (new_singleton (113),198)
			Result.put (new_singleton (114),199)
			Result.put (new_singleton (115),200)
			Result.put (new_singleton (116),201)
			Result.put (new_singleton (117),202)
			Result.put (new_singleton (118),203)
			Result.put (new_singleton (119),204)
			Result.put (new_singleton (120),205)
			Result.put (new_singleton (121),206)
			Result.put (new_singleton (122),207)
			Result.put (new_singleton (65),208)
			Result.put (new_singleton (66),209)
			Result.put (new_singleton (67),210)
			Result.put (new_singleton (68),211)
			Result.put (new_singleton (69),212)
			Result.put (new_singleton (70),213)
			Result.put (new_singleton (71),214)
			Result.put (new_singleton (72),215)
			Result.put (new_singleton (73),216)
			Result.put (new_singleton (74),217)
			Result.put (new_singleton (75),218)
			Result.put (new_singleton (76),219)
			Result.put (new_singleton (77),220)
			Result.put (new_singleton (78),221)
			Result.put (new_singleton (79),222)
			Result.put (new_singleton (80),223)
			Result.put (new_singleton (81),224)
			Result.put (new_singleton (82),225)
			Result.put (new_singleton (83),226)
			Result.put (new_singleton (84),227)
			Result.put (new_singleton (85),228)
			Result.put (new_singleton (86),229)
			Result.put (new_singleton (87),230)
			Result.put (new_singleton (88),231)
			Result.put (new_singleton (89),232)
			Result.put (new_singleton (90),233)
			Result.put (new_singleton (97),234)
			Result.put (new_singleton (98),235)
			Result.put (new_singleton (99),236)
			Result.put (new_singleton (100),237)
			Result.put (new_singleton (101),238)
			Result.put (new_singleton (102),239)
			Result.put (new_singleton (103),240)
			Result.put (new_singleton (104),241)
			Result.put (new_singleton (105),242)
			Result.put (new_singleton (106),243)
			Result.put (new_singleton (107),244)
			Result.put (new_singleton (108),245)
			Result.put (new_singleton (109),246)
			Result.put (new_singleton (110),247)
			Result.put (new_singleton (111),248)
			Result.put (new_singleton (112),249)
			Result.put (new_singleton (113),250)
			Result.put (new_singleton (114),251)
			Result.put (new_singleton (115),252)
			Result.put (new_singleton (116),253)
			Result.put (new_singleton (117),254)
			Result.put (new_singleton (118),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_1_segment_213: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (119),0)
			Result.put (new_singleton (120),1)
			Result.put (new_singleton (121),2)
			Result.put (new_singleton (122),3)
			Result.put (new_singleton (65),4)
			Result.put (new_singleton (66),5)
			Result.put (new_singleton (68),7)
			Result.put (new_singleton (69),8)
			Result.put (new_singleton (70),9)
			Result.put (new_singleton (71),10)
			Result.put (new_singleton (74),13)
			Result.put (new_singleton (75),14)
			Result.put (new_singleton (76),15)
			Result.put (new_singleton (77),16)
			Result.put (new_singleton (78),17)
			Result.put (new_singleton (79),18)
			Result.put (new_singleton (80),19)
			Result.put (new_singleton (81),20)
			Result.put (new_singleton (83),22)
			Result.put (new_singleton (84),23)
			Result.put (new_singleton (85),24)
			Result.put (new_singleton (86),25)
			Result.put (new_singleton (87),26)
			Result.put (new_singleton (88),27)
			Result.put (new_singleton (89),28)
			Result.put (new_singleton (97),30)
			Result.put (new_singleton (98),31)
			Result.put (new_singleton (99),32)
			Result.put (new_singleton (100),33)
			Result.put (new_singleton (101),34)
			Result.put (new_singleton (102),35)
			Result.put (new_singleton (103),36)
			Result.put (new_singleton (104),37)
			Result.put (new_singleton (105),38)
			Result.put (new_singleton (106),39)
			Result.put (new_singleton (107),40)
			Result.put (new_singleton (108),41)
			Result.put (new_singleton (109),42)
			Result.put (new_singleton (110),43)
			Result.put (new_singleton (111),44)
			Result.put (new_singleton (112),45)
			Result.put (new_singleton (113),46)
			Result.put (new_singleton (114),47)
			Result.put (new_singleton (115),48)
			Result.put (new_singleton (116),49)
			Result.put (new_singleton (117),50)
			Result.put (new_singleton (118),51)
			Result.put (new_singleton (119),52)
			Result.put (new_singleton (120),53)
			Result.put (new_singleton (121),54)
			Result.put (new_singleton (122),55)
			Result.put (new_singleton (65),56)
			Result.put (new_singleton (66),57)
			Result.put (new_singleton (68),59)
			Result.put (new_singleton (69),60)
			Result.put (new_singleton (70),61)
			Result.put (new_singleton (71),62)
			Result.put (new_singleton (73),64)
			Result.put (new_singleton (74),65)
			Result.put (new_singleton (75),66)
			Result.put (new_singleton (76),67)
			Result.put (new_singleton (77),68)
			Result.put (new_singleton (79),70)
			Result.put (new_singleton (83),74)
			Result.put (new_singleton (84),75)
			Result.put (new_singleton (85),76)
			Result.put (new_singleton (86),77)
			Result.put (new_singleton (87),78)
			Result.put (new_singleton (88),79)
			Result.put (new_singleton (89),80)
			Result.put (new_singleton (97),82)
			Result.put (new_singleton (98),83)
			Result.put (new_singleton (99),84)
			Result.put (new_singleton (100),85)
			Result.put (new_singleton (101),86)
			Result.put (new_singleton (102),87)
			Result.put (new_singleton (103),88)
			Result.put (new_singleton (104),89)
			Result.put (new_singleton (105),90)
			Result.put (new_singleton (106),91)
			Result.put (new_singleton (107),92)
			Result.put (new_singleton (108),93)
			Result.put (new_singleton (109),94)
			Result.put (new_singleton (110),95)
			Result.put (new_singleton (111),96)
			Result.put (new_singleton (112),97)
			Result.put (new_singleton (113),98)
			Result.put (new_singleton (114),99)
			Result.put (new_singleton (115),100)
			Result.put (new_singleton (116),101)
			Result.put (new_singleton (117),102)
			Result.put (new_singleton (118),103)
			Result.put (new_singleton (119),104)
			Result.put (new_singleton (120),105)
			Result.put (new_singleton (121),106)
			Result.put (new_singleton (122),107)
			Result.put (new_singleton (65),108)
			Result.put (new_singleton (66),109)
			Result.put (new_singleton (67),110)
			Result.put (new_singleton (68),111)
			Result.put (new_singleton (69),112)
			Result.put (new_singleton (70),113)
			Result.put (new_singleton (71),114)
			Result.put (new_singleton (72),115)
			Result.put (new_singleton (73),116)
			Result.put (new_singleton (74),117)
			Result.put (new_singleton (75),118)
			Result.put (new_singleton (76),119)
			Result.put (new_singleton (77),120)
			Result.put (new_singleton (78),121)
			Result.put (new_singleton (79),122)
			Result.put (new_singleton (80),123)
			Result.put (new_singleton (81),124)
			Result.put (new_singleton (82),125)
			Result.put (new_singleton (83),126)
			Result.put (new_singleton (84),127)
			Result.put (new_singleton (85),128)
			Result.put (new_singleton (86),129)
			Result.put (new_singleton (87),130)
			Result.put (new_singleton (88),131)
			Result.put (new_singleton (89),132)
			Result.put (new_singleton (90),133)
			Result.put (new_singleton (97),134)
			Result.put (new_singleton (98),135)
			Result.put (new_singleton (99),136)
			Result.put (new_singleton (100),137)
			Result.put (new_singleton (101),138)
			Result.put (new_singleton (102),139)
			Result.put (new_singleton (103),140)
			Result.put (new_singleton (104),141)
			Result.put (new_singleton (105),142)
			Result.put (new_singleton (106),143)
			Result.put (new_singleton (107),144)
			Result.put (new_singleton (108),145)
			Result.put (new_singleton (109),146)
			Result.put (new_singleton (110),147)
			Result.put (new_singleton (111),148)
			Result.put (new_singleton (112),149)
			Result.put (new_singleton (113),150)
			Result.put (new_singleton (114),151)
			Result.put (new_singleton (115),152)
			Result.put (new_singleton (116),153)
			Result.put (new_singleton (117),154)
			Result.put (new_singleton (118),155)
			Result.put (new_singleton (119),156)
			Result.put (new_singleton (120),157)
			Result.put (new_singleton (121),158)
			Result.put (new_singleton (122),159)
			Result.put (new_singleton (65),160)
			Result.put (new_singleton (66),161)
			Result.put (new_singleton (67),162)
			Result.put (new_singleton (68),163)
			Result.put (new_singleton (69),164)
			Result.put (new_singleton (70),165)
			Result.put (new_singleton (71),166)
			Result.put (new_singleton (72),167)
			Result.put (new_singleton (73),168)
			Result.put (new_singleton (74),169)
			Result.put (new_singleton (75),170)
			Result.put (new_singleton (76),171)
			Result.put (new_singleton (77),172)
			Result.put (new_singleton (78),173)
			Result.put (new_singleton (79),174)
			Result.put (new_singleton (80),175)
			Result.put (new_singleton (81),176)
			Result.put (new_singleton (82),177)
			Result.put (new_singleton (83),178)
			Result.put (new_singleton (84),179)
			Result.put (new_singleton (85),180)
			Result.put (new_singleton (86),181)
			Result.put (new_singleton (87),182)
			Result.put (new_singleton (88),183)
			Result.put (new_singleton (89),184)
			Result.put (new_singleton (90),185)
			Result.put (new_singleton (97),186)
			Result.put (new_singleton (98),187)
			Result.put (new_singleton (99),188)
			Result.put (new_singleton (100),189)
			Result.put (new_singleton (101),190)
			Result.put (new_singleton (102),191)
			Result.put (new_singleton (103),192)
			Result.put (new_singleton (104),193)
			Result.put (new_singleton (105),194)
			Result.put (new_singleton (106),195)
			Result.put (new_singleton (107),196)
			Result.put (new_singleton (108),197)
			Result.put (new_singleton (109),198)
			Result.put (new_singleton (110),199)
			Result.put (new_singleton (111),200)
			Result.put (new_singleton (112),201)
			Result.put (new_singleton (113),202)
			Result.put (new_singleton (114),203)
			Result.put (new_singleton (115),204)
			Result.put (new_singleton (116),205)
			Result.put (new_singleton (117),206)
			Result.put (new_singleton (118),207)
			Result.put (new_singleton (119),208)
			Result.put (new_singleton (120),209)
			Result.put (new_singleton (121),210)
			Result.put (new_singleton (122),211)
			Result.put (new_singleton (65),212)
			Result.put (new_singleton (66),213)
			Result.put (new_singleton (67),214)
			Result.put (new_singleton (68),215)
			Result.put (new_singleton (69),216)
			Result.put (new_singleton (70),217)
			Result.put (new_singleton (71),218)
			Result.put (new_singleton (72),219)
			Result.put (new_singleton (73),220)
			Result.put (new_singleton (74),221)
			Result.put (new_singleton (75),222)
			Result.put (new_singleton (76),223)
			Result.put (new_singleton (77),224)
			Result.put (new_singleton (78),225)
			Result.put (new_singleton (79),226)
			Result.put (new_singleton (80),227)
			Result.put (new_singleton (81),228)
			Result.put (new_singleton (82),229)
			Result.put (new_singleton (83),230)
			Result.put (new_singleton (84),231)
			Result.put (new_singleton (85),232)
			Result.put (new_singleton (86),233)
			Result.put (new_singleton (87),234)
			Result.put (new_singleton (88),235)
			Result.put (new_singleton (89),236)
			Result.put (new_singleton (90),237)
			Result.put (new_singleton (97),238)
			Result.put (new_singleton (98),239)
			Result.put (new_singleton (99),240)
			Result.put (new_singleton (100),241)
			Result.put (new_singleton (101),242)
			Result.put (new_singleton (102),243)
			Result.put (new_singleton (103),244)
			Result.put (new_singleton (104),245)
			Result.put (new_singleton (105),246)
			Result.put (new_singleton (106),247)
			Result.put (new_singleton (107),248)
			Result.put (new_singleton (108),249)
			Result.put (new_singleton (109),250)
			Result.put (new_singleton (110),251)
			Result.put (new_singleton (111),252)
			Result.put (new_singleton (112),253)
			Result.put (new_singleton (113),254)
			Result.put (new_singleton (114),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_1_segment_214: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (115),0)
			Result.put (new_singleton (116),1)
			Result.put (new_singleton (117),2)
			Result.put (new_singleton (118),3)
			Result.put (new_singleton (119),4)
			Result.put (new_singleton (120),5)
			Result.put (new_singleton (121),6)
			Result.put (new_singleton (122),7)
			Result.put (new_singleton (65),8)
			Result.put (new_singleton (66),9)
			Result.put (new_singleton (67),10)
			Result.put (new_singleton (68),11)
			Result.put (new_singleton (69),12)
			Result.put (new_singleton (70),13)
			Result.put (new_singleton (71),14)
			Result.put (new_singleton (72),15)
			Result.put (new_singleton (73),16)
			Result.put (new_singleton (74),17)
			Result.put (new_singleton (75),18)
			Result.put (new_singleton (76),19)
			Result.put (new_singleton (77),20)
			Result.put (new_singleton (78),21)
			Result.put (new_singleton (79),22)
			Result.put (new_singleton (80),23)
			Result.put (new_singleton (81),24)
			Result.put (new_singleton (82),25)
			Result.put (new_singleton (83),26)
			Result.put (new_singleton (84),27)
			Result.put (new_singleton (85),28)
			Result.put (new_singleton (86),29)
			Result.put (new_singleton (87),30)
			Result.put (new_singleton (88),31)
			Result.put (new_singleton (89),32)
			Result.put (new_singleton (90),33)
			Result.put (new_singleton (97),34)
			Result.put (new_singleton (98),35)
			Result.put (new_singleton (99),36)
			Result.put (new_singleton (100),37)
			Result.put (new_singleton (101),38)
			Result.put (new_singleton (102),39)
			Result.put (new_singleton (103),40)
			Result.put (new_singleton (104),41)
			Result.put (new_singleton (105),42)
			Result.put (new_singleton (106),43)
			Result.put (new_singleton (107),44)
			Result.put (new_singleton (108),45)
			Result.put (new_singleton (109),46)
			Result.put (new_singleton (110),47)
			Result.put (new_singleton (111),48)
			Result.put (new_singleton (112),49)
			Result.put (new_singleton (113),50)
			Result.put (new_singleton (114),51)
			Result.put (new_singleton (115),52)
			Result.put (new_singleton (116),53)
			Result.put (new_singleton (117),54)
			Result.put (new_singleton (118),55)
			Result.put (new_singleton (119),56)
			Result.put (new_singleton (120),57)
			Result.put (new_singleton (121),58)
			Result.put (new_singleton (122),59)
			Result.put (new_singleton (65),60)
			Result.put (new_singleton (66),61)
			Result.put (new_singleton (67),62)
			Result.put (new_singleton (68),63)
			Result.put (new_singleton (69),64)
			Result.put (new_singleton (70),65)
			Result.put (new_singleton (71),66)
			Result.put (new_singleton (72),67)
			Result.put (new_singleton (73),68)
			Result.put (new_singleton (74),69)
			Result.put (new_singleton (75),70)
			Result.put (new_singleton (76),71)
			Result.put (new_singleton (77),72)
			Result.put (new_singleton (78),73)
			Result.put (new_singleton (79),74)
			Result.put (new_singleton (80),75)
			Result.put (new_singleton (81),76)
			Result.put (new_singleton (82),77)
			Result.put (new_singleton (83),78)
			Result.put (new_singleton (84),79)
			Result.put (new_singleton (85),80)
			Result.put (new_singleton (86),81)
			Result.put (new_singleton (87),82)
			Result.put (new_singleton (88),83)
			Result.put (new_singleton (89),84)
			Result.put (new_singleton (90),85)
			Result.put (new_singleton (97),86)
			Result.put (new_singleton (98),87)
			Result.put (new_singleton (99),88)
			Result.put (new_singleton (100),89)
			Result.put (new_singleton (101),90)
			Result.put (new_singleton (102),91)
			Result.put (new_singleton (103),92)
			Result.put (new_singleton (104),93)
			Result.put (new_singleton (105),94)
			Result.put (new_singleton (106),95)
			Result.put (new_singleton (107),96)
			Result.put (new_singleton (108),97)
			Result.put (new_singleton (109),98)
			Result.put (new_singleton (110),99)
			Result.put (new_singleton (111),100)
			Result.put (new_singleton (112),101)
			Result.put (new_singleton (113),102)
			Result.put (new_singleton (114),103)
			Result.put (new_singleton (115),104)
			Result.put (new_singleton (116),105)
			Result.put (new_singleton (117),106)
			Result.put (new_singleton (118),107)
			Result.put (new_singleton (119),108)
			Result.put (new_singleton (120),109)
			Result.put (new_singleton (121),110)
			Result.put (new_singleton (122),111)
			Result.put (new_singleton (65),112)
			Result.put (new_singleton (66),113)
			Result.put (new_singleton (67),114)
			Result.put (new_singleton (68),115)
			Result.put (new_singleton (69),116)
			Result.put (new_singleton (70),117)
			Result.put (new_singleton (71),118)
			Result.put (new_singleton (72),119)
			Result.put (new_singleton (73),120)
			Result.put (new_singleton (74),121)
			Result.put (new_singleton (75),122)
			Result.put (new_singleton (76),123)
			Result.put (new_singleton (77),124)
			Result.put (new_singleton (78),125)
			Result.put (new_singleton (79),126)
			Result.put (new_singleton (80),127)
			Result.put (new_singleton (81),128)
			Result.put (new_singleton (82),129)
			Result.put (new_singleton (83),130)
			Result.put (new_singleton (84),131)
			Result.put (new_singleton (85),132)
			Result.put (new_singleton (86),133)
			Result.put (new_singleton (87),134)
			Result.put (new_singleton (88),135)
			Result.put (new_singleton (89),136)
			Result.put (new_singleton (90),137)
			Result.put (new_singleton (97),138)
			Result.put (new_singleton (98),139)
			Result.put (new_singleton (99),140)
			Result.put (new_singleton (100),141)
			Result.put (new_singleton (101),142)
			Result.put (new_singleton (102),143)
			Result.put (new_singleton (103),144)
			Result.put (new_singleton (104),145)
			Result.put (new_singleton (105),146)
			Result.put (new_singleton (106),147)
			Result.put (new_singleton (107),148)
			Result.put (new_singleton (108),149)
			Result.put (new_singleton (109),150)
			Result.put (new_singleton (110),151)
			Result.put (new_singleton (111),152)
			Result.put (new_singleton (112),153)
			Result.put (new_singleton (113),154)
			Result.put (new_singleton (114),155)
			Result.put (new_singleton (115),156)
			Result.put (new_singleton (116),157)
			Result.put (new_singleton (117),158)
			Result.put (new_singleton (118),159)
			Result.put (new_singleton (119),160)
			Result.put (new_singleton (120),161)
			Result.put (new_singleton (121),162)
			Result.put (new_singleton (122),163)
			Result.put (new_singleton (305),164)
			Result.put (new_singleton (567),165)
			Result.put (new_singleton (913),168)
			Result.put (new_singleton (914),169)
			Result.put (new_singleton (915),170)
			Result.put (new_singleton (916),171)
			Result.put (new_singleton (917),172)
			Result.put (new_singleton (918),173)
			Result.put (new_singleton (919),174)
			Result.put (new_singleton (920),175)
			Result.put (new_singleton (921),176)
			Result.put (new_singleton (922),177)
			Result.put (new_singleton (923),178)
			Result.put (new_singleton (924),179)
			Result.put (new_singleton (925),180)
			Result.put (new_singleton (926),181)
			Result.put (new_singleton (927),182)
			Result.put (new_singleton (928),183)
			Result.put (new_singleton (929),184)
			Result.put (new_singleton (1012),185)
			Result.put (new_singleton (931),186)
			Result.put (new_singleton (932),187)
			Result.put (new_singleton (933),188)
			Result.put (new_singleton (934),189)
			Result.put (new_singleton (935),190)
			Result.put (new_singleton (936),191)
			Result.put (new_singleton (937),192)
			Result.put (new_singleton (8711),193)
			Result.put (new_singleton (945),194)
			Result.put (new_singleton (946),195)
			Result.put (new_singleton (947),196)
			Result.put (new_singleton (948),197)
			Result.put (new_singleton (949),198)
			Result.put (new_singleton (950),199)
			Result.put (new_singleton (951),200)
			Result.put (new_singleton (952),201)
			Result.put (new_singleton (953),202)
			Result.put (new_singleton (954),203)
			Result.put (new_singleton (955),204)
			Result.put (new_singleton (956),205)
			Result.put (new_singleton (957),206)
			Result.put (new_singleton (958),207)
			Result.put (new_singleton (959),208)
			Result.put (new_singleton (960),209)
			Result.put (new_singleton (961),210)
			Result.put (new_singleton (962),211)
			Result.put (new_singleton (963),212)
			Result.put (new_singleton (964),213)
			Result.put (new_singleton (965),214)
			Result.put (new_singleton (966),215)
			Result.put (new_singleton (967),216)
			Result.put (new_singleton (968),217)
			Result.put (new_singleton (969),218)
			Result.put (new_singleton (8706),219)
			Result.put (new_singleton (1013),220)
			Result.put (new_singleton (977),221)
			Result.put (new_singleton (1008),222)
			Result.put (new_singleton (981),223)
			Result.put (new_singleton (1009),224)
			Result.put (new_singleton (982),225)
			Result.put (new_singleton (913),226)
			Result.put (new_singleton (914),227)
			Result.put (new_singleton (915),228)
			Result.put (new_singleton (916),229)
			Result.put (new_singleton (917),230)
			Result.put (new_singleton (918),231)
			Result.put (new_singleton (919),232)
			Result.put (new_singleton (920),233)
			Result.put (new_singleton (921),234)
			Result.put (new_singleton (922),235)
			Result.put (new_singleton (923),236)
			Result.put (new_singleton (924),237)
			Result.put (new_singleton (925),238)
			Result.put (new_singleton (926),239)
			Result.put (new_singleton (927),240)
			Result.put (new_singleton (928),241)
			Result.put (new_singleton (929),242)
			Result.put (new_singleton (1012),243)
			Result.put (new_singleton (931),244)
			Result.put (new_singleton (932),245)
			Result.put (new_singleton (933),246)
			Result.put (new_singleton (934),247)
			Result.put (new_singleton (935),248)
			Result.put (new_singleton (936),249)
			Result.put (new_singleton (937),250)
			Result.put (new_singleton (8711),251)
			Result.put (new_singleton (945),252)
			Result.put (new_singleton (946),253)
			Result.put (new_singleton (947),254)
			Result.put (new_singleton (948),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_1_segment_215: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (949),0)
			Result.put (new_singleton (950),1)
			Result.put (new_singleton (951),2)
			Result.put (new_singleton (952),3)
			Result.put (new_singleton (953),4)
			Result.put (new_singleton (954),5)
			Result.put (new_singleton (955),6)
			Result.put (new_singleton (956),7)
			Result.put (new_singleton (957),8)
			Result.put (new_singleton (958),9)
			Result.put (new_singleton (959),10)
			Result.put (new_singleton (960),11)
			Result.put (new_singleton (961),12)
			Result.put (new_singleton (962),13)
			Result.put (new_singleton (963),14)
			Result.put (new_singleton (964),15)
			Result.put (new_singleton (965),16)
			Result.put (new_singleton (966),17)
			Result.put (new_singleton (967),18)
			Result.put (new_singleton (968),19)
			Result.put (new_singleton (969),20)
			Result.put (new_singleton (8706),21)
			Result.put (new_singleton (1013),22)
			Result.put (new_singleton (977),23)
			Result.put (new_singleton (1008),24)
			Result.put (new_singleton (981),25)
			Result.put (new_singleton (1009),26)
			Result.put (new_singleton (982),27)
			Result.put (new_singleton (913),28)
			Result.put (new_singleton (914),29)
			Result.put (new_singleton (915),30)
			Result.put (new_singleton (916),31)
			Result.put (new_singleton (917),32)
			Result.put (new_singleton (918),33)
			Result.put (new_singleton (919),34)
			Result.put (new_singleton (920),35)
			Result.put (new_singleton (921),36)
			Result.put (new_singleton (922),37)
			Result.put (new_singleton (923),38)
			Result.put (new_singleton (924),39)
			Result.put (new_singleton (925),40)
			Result.put (new_singleton (926),41)
			Result.put (new_singleton (927),42)
			Result.put (new_singleton (928),43)
			Result.put (new_singleton (929),44)
			Result.put (new_singleton (1012),45)
			Result.put (new_singleton (931),46)
			Result.put (new_singleton (932),47)
			Result.put (new_singleton (933),48)
			Result.put (new_singleton (934),49)
			Result.put (new_singleton (935),50)
			Result.put (new_singleton (936),51)
			Result.put (new_singleton (937),52)
			Result.put (new_singleton (8711),53)
			Result.put (new_singleton (945),54)
			Result.put (new_singleton (946),55)
			Result.put (new_singleton (947),56)
			Result.put (new_singleton (948),57)
			Result.put (new_singleton (949),58)
			Result.put (new_singleton (950),59)
			Result.put (new_singleton (951),60)
			Result.put (new_singleton (952),61)
			Result.put (new_singleton (953),62)
			Result.put (new_singleton (954),63)
			Result.put (new_singleton (955),64)
			Result.put (new_singleton (956),65)
			Result.put (new_singleton (957),66)
			Result.put (new_singleton (958),67)
			Result.put (new_singleton (959),68)
			Result.put (new_singleton (960),69)
			Result.put (new_singleton (961),70)
			Result.put (new_singleton (962),71)
			Result.put (new_singleton (963),72)
			Result.put (new_singleton (964),73)
			Result.put (new_singleton (965),74)
			Result.put (new_singleton (966),75)
			Result.put (new_singleton (967),76)
			Result.put (new_singleton (968),77)
			Result.put (new_singleton (969),78)
			Result.put (new_singleton (8706),79)
			Result.put (new_singleton (1013),80)
			Result.put (new_singleton (977),81)
			Result.put (new_singleton (1008),82)
			Result.put (new_singleton (981),83)
			Result.put (new_singleton (1009),84)
			Result.put (new_singleton (982),85)
			Result.put (new_singleton (913),86)
			Result.put (new_singleton (914),87)
			Result.put (new_singleton (915),88)
			Result.put (new_singleton (916),89)
			Result.put (new_singleton (917),90)
			Result.put (new_singleton (918),91)
			Result.put (new_singleton (919),92)
			Result.put (new_singleton (920),93)
			Result.put (new_singleton (921),94)
			Result.put (new_singleton (922),95)
			Result.put (new_singleton (923),96)
			Result.put (new_singleton (924),97)
			Result.put (new_singleton (925),98)
			Result.put (new_singleton (926),99)
			Result.put (new_singleton (927),100)
			Result.put (new_singleton (928),101)
			Result.put (new_singleton (929),102)
			Result.put (new_singleton (1012),103)
			Result.put (new_singleton (931),104)
			Result.put (new_singleton (932),105)
			Result.put (new_singleton (933),106)
			Result.put (new_singleton (934),107)
			Result.put (new_singleton (935),108)
			Result.put (new_singleton (936),109)
			Result.put (new_singleton (937),110)
			Result.put (new_singleton (8711),111)
			Result.put (new_singleton (945),112)
			Result.put (new_singleton (946),113)
			Result.put (new_singleton (947),114)
			Result.put (new_singleton (948),115)
			Result.put (new_singleton (949),116)
			Result.put (new_singleton (950),117)
			Result.put (new_singleton (951),118)
			Result.put (new_singleton (952),119)
			Result.put (new_singleton (953),120)
			Result.put (new_singleton (954),121)
			Result.put (new_singleton (955),122)
			Result.put (new_singleton (956),123)
			Result.put (new_singleton (957),124)
			Result.put (new_singleton (958),125)
			Result.put (new_singleton (959),126)
			Result.put (new_singleton (960),127)
			Result.put (new_singleton (961),128)
			Result.put (new_singleton (962),129)
			Result.put (new_singleton (963),130)
			Result.put (new_singleton (964),131)
			Result.put (new_singleton (965),132)
			Result.put (new_singleton (966),133)
			Result.put (new_singleton (967),134)
			Result.put (new_singleton (968),135)
			Result.put (new_singleton (969),136)
			Result.put (new_singleton (8706),137)
			Result.put (new_singleton (1013),138)
			Result.put (new_singleton (977),139)
			Result.put (new_singleton (1008),140)
			Result.put (new_singleton (981),141)
			Result.put (new_singleton (1009),142)
			Result.put (new_singleton (982),143)
			Result.put (new_singleton (913),144)
			Result.put (new_singleton (914),145)
			Result.put (new_singleton (915),146)
			Result.put (new_singleton (916),147)
			Result.put (new_singleton (917),148)
			Result.put (new_singleton (918),149)
			Result.put (new_singleton (919),150)
			Result.put (new_singleton (920),151)
			Result.put (new_singleton (921),152)
			Result.put (new_singleton (922),153)
			Result.put (new_singleton (923),154)
			Result.put (new_singleton (924),155)
			Result.put (new_singleton (925),156)
			Result.put (new_singleton (926),157)
			Result.put (new_singleton (927),158)
			Result.put (new_singleton (928),159)
			Result.put (new_singleton (929),160)
			Result.put (new_singleton (1012),161)
			Result.put (new_singleton (931),162)
			Result.put (new_singleton (932),163)
			Result.put (new_singleton (933),164)
			Result.put (new_singleton (934),165)
			Result.put (new_singleton (935),166)
			Result.put (new_singleton (936),167)
			Result.put (new_singleton (937),168)
			Result.put (new_singleton (8711),169)
			Result.put (new_singleton (945),170)
			Result.put (new_singleton (946),171)
			Result.put (new_singleton (947),172)
			Result.put (new_singleton (948),173)
			Result.put (new_singleton (949),174)
			Result.put (new_singleton (950),175)
			Result.put (new_singleton (951),176)
			Result.put (new_singleton (952),177)
			Result.put (new_singleton (953),178)
			Result.put (new_singleton (954),179)
			Result.put (new_singleton (955),180)
			Result.put (new_singleton (956),181)
			Result.put (new_singleton (957),182)
			Result.put (new_singleton (958),183)
			Result.put (new_singleton (959),184)
			Result.put (new_singleton (960),185)
			Result.put (new_singleton (961),186)
			Result.put (new_singleton (962),187)
			Result.put (new_singleton (963),188)
			Result.put (new_singleton (964),189)
			Result.put (new_singleton (965),190)
			Result.put (new_singleton (966),191)
			Result.put (new_singleton (967),192)
			Result.put (new_singleton (968),193)
			Result.put (new_singleton (969),194)
			Result.put (new_singleton (8706),195)
			Result.put (new_singleton (1013),196)
			Result.put (new_singleton (977),197)
			Result.put (new_singleton (1008),198)
			Result.put (new_singleton (981),199)
			Result.put (new_singleton (1009),200)
			Result.put (new_singleton (982),201)
			Result.put (new_singleton (988),202)
			Result.put (new_singleton (989),203)
			Result.put (new_singleton (48),206)
			Result.put (new_singleton (49),207)
			Result.put (new_singleton (50),208)
			Result.put (new_singleton (51),209)
			Result.put (new_singleton (52),210)
			Result.put (new_singleton (53),211)
			Result.put (new_singleton (54),212)
			Result.put (new_singleton (55),213)
			Result.put (new_singleton (56),214)
			Result.put (new_singleton (57),215)
			Result.put (new_singleton (48),216)
			Result.put (new_singleton (49),217)
			Result.put (new_singleton (50),218)
			Result.put (new_singleton (51),219)
			Result.put (new_singleton (52),220)
			Result.put (new_singleton (53),221)
			Result.put (new_singleton (54),222)
			Result.put (new_singleton (55),223)
			Result.put (new_singleton (56),224)
			Result.put (new_singleton (57),225)
			Result.put (new_singleton (48),226)
			Result.put (new_singleton (49),227)
			Result.put (new_singleton (50),228)
			Result.put (new_singleton (51),229)
			Result.put (new_singleton (52),230)
			Result.put (new_singleton (53),231)
			Result.put (new_singleton (54),232)
			Result.put (new_singleton (55),233)
			Result.put (new_singleton (56),234)
			Result.put (new_singleton (57),235)
			Result.put (new_singleton (48),236)
			Result.put (new_singleton (49),237)
			Result.put (new_singleton (50),238)
			Result.put (new_singleton (51),239)
			Result.put (new_singleton (52),240)
			Result.put (new_singleton (53),241)
			Result.put (new_singleton (54),242)
			Result.put (new_singleton (55),243)
			Result.put (new_singleton (56),244)
			Result.put (new_singleton (57),245)
			Result.put (new_singleton (48),246)
			Result.put (new_singleton (49),247)
			Result.put (new_singleton (50),248)
			Result.put (new_singleton (51),249)
			Result.put (new_singleton (52),250)
			Result.put (new_singleton (53),251)
			Result.put (new_singleton (54),252)
			Result.put (new_singleton (55),253)
			Result.put (new_singleton (56),254)
			Result.put (new_singleton (57),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_1: SPECIAL [ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]]
			-- Generated array plane
		once
			create Result.make_filled (all_empty_decomposition_mapping_segment, 256)
			Result.put (all_empty_decomposition_mapping_segment, 1)
			Result.put (all_empty_decomposition_mapping_segment, 2)
			Result.put (all_empty_decomposition_mapping_segment, 3)
			Result.put (all_empty_decomposition_mapping_segment, 4)
			Result.put (all_empty_decomposition_mapping_segment, 5)
			Result.put (all_empty_decomposition_mapping_segment, 6)
			Result.put (all_empty_decomposition_mapping_segment, 7)
			Result.put (all_empty_decomposition_mapping_segment, 8)
			Result.put (all_empty_decomposition_mapping_segment, 9)
			Result.put (all_empty_decomposition_mapping_segment, 10)
			Result.put (all_empty_decomposition_mapping_segment, 11)
			Result.put (all_empty_decomposition_mapping_segment, 12)
			Result.put (all_empty_decomposition_mapping_segment, 13)
			Result.put (all_empty_decomposition_mapping_segment, 14)
			Result.put (all_empty_decomposition_mapping_segment, 15)
			Result.put (all_empty_decomposition_mapping_segment, 16)
			Result.put (all_empty_decomposition_mapping_segment, 17)
			Result.put (all_empty_decomposition_mapping_segment, 18)
			Result.put (all_empty_decomposition_mapping_segment, 19)
			Result.put (all_empty_decomposition_mapping_segment, 20)
			Result.put (all_empty_decomposition_mapping_segment, 21)
			Result.put (all_empty_decomposition_mapping_segment, 22)
			Result.put (all_empty_decomposition_mapping_segment, 23)
			Result.put (all_empty_decomposition_mapping_segment, 24)
			Result.put (all_empty_decomposition_mapping_segment, 25)
			Result.put (all_empty_decomposition_mapping_segment, 26)
			Result.put (all_empty_decomposition_mapping_segment, 27)
			Result.put (all_empty_decomposition_mapping_segment, 28)
			Result.put (all_empty_decomposition_mapping_segment, 29)
			Result.put (all_empty_decomposition_mapping_segment, 30)
			Result.put (all_empty_decomposition_mapping_segment, 31)
			Result.put (all_empty_decomposition_mapping_segment, 32)
			Result.put (all_empty_decomposition_mapping_segment, 33)
			Result.put (all_empty_decomposition_mapping_segment, 34)
			Result.put (all_empty_decomposition_mapping_segment, 35)
			Result.put (all_empty_decomposition_mapping_segment, 36)
			Result.put (all_empty_decomposition_mapping_segment, 37)
			Result.put (all_empty_decomposition_mapping_segment, 38)
			Result.put (all_empty_decomposition_mapping_segment, 39)
			Result.put (all_empty_decomposition_mapping_segment, 40)
			Result.put (all_empty_decomposition_mapping_segment, 41)
			Result.put (all_empty_decomposition_mapping_segment, 42)
			Result.put (all_empty_decomposition_mapping_segment, 43)
			Result.put (all_empty_decomposition_mapping_segment, 44)
			Result.put (all_empty_decomposition_mapping_segment, 45)
			Result.put (all_empty_decomposition_mapping_segment, 46)
			Result.put (all_empty_decomposition_mapping_segment, 47)
			Result.put (all_empty_decomposition_mapping_segment, 48)
			Result.put (all_empty_decomposition_mapping_segment, 49)
			Result.put (all_empty_decomposition_mapping_segment, 50)
			Result.put (all_empty_decomposition_mapping_segment, 51)
			Result.put (all_empty_decomposition_mapping_segment, 52)
			Result.put (all_empty_decomposition_mapping_segment, 53)
			Result.put (all_empty_decomposition_mapping_segment, 54)
			Result.put (all_empty_decomposition_mapping_segment, 55)
			Result.put (all_empty_decomposition_mapping_segment, 56)
			Result.put (all_empty_decomposition_mapping_segment, 57)
			Result.put (all_empty_decomposition_mapping_segment, 58)
			Result.put (all_empty_decomposition_mapping_segment, 59)
			Result.put (all_empty_decomposition_mapping_segment, 60)
			Result.put (all_empty_decomposition_mapping_segment, 61)
			Result.put (all_empty_decomposition_mapping_segment, 62)
			Result.put (all_empty_decomposition_mapping_segment, 63)
			Result.put (all_empty_decomposition_mapping_segment, 64)
			Result.put (all_empty_decomposition_mapping_segment, 65)
			Result.put (all_empty_decomposition_mapping_segment, 66)
			Result.put (all_empty_decomposition_mapping_segment, 67)
			Result.put (all_empty_decomposition_mapping_segment, 68)
			Result.put (all_empty_decomposition_mapping_segment, 69)
			Result.put (all_empty_decomposition_mapping_segment, 70)
			Result.put (all_empty_decomposition_mapping_segment, 71)
			Result.put (all_empty_decomposition_mapping_segment, 72)
			Result.put (all_empty_decomposition_mapping_segment, 73)
			Result.put (all_empty_decomposition_mapping_segment, 74)
			Result.put (all_empty_decomposition_mapping_segment, 75)
			Result.put (all_empty_decomposition_mapping_segment, 76)
			Result.put (all_empty_decomposition_mapping_segment, 77)
			Result.put (all_empty_decomposition_mapping_segment, 78)
			Result.put (all_empty_decomposition_mapping_segment, 79)
			Result.put (all_empty_decomposition_mapping_segment, 80)
			Result.put (all_empty_decomposition_mapping_segment, 81)
			Result.put (all_empty_decomposition_mapping_segment, 82)
			Result.put (all_empty_decomposition_mapping_segment, 83)
			Result.put (all_empty_decomposition_mapping_segment, 84)
			Result.put (all_empty_decomposition_mapping_segment, 85)
			Result.put (all_empty_decomposition_mapping_segment, 86)
			Result.put (all_empty_decomposition_mapping_segment, 87)
			Result.put (all_empty_decomposition_mapping_segment, 88)
			Result.put (all_empty_decomposition_mapping_segment, 89)
			Result.put (all_empty_decomposition_mapping_segment, 90)
			Result.put (all_empty_decomposition_mapping_segment, 91)
			Result.put (all_empty_decomposition_mapping_segment, 92)
			Result.put (all_empty_decomposition_mapping_segment, 93)
			Result.put (all_empty_decomposition_mapping_segment, 94)
			Result.put (all_empty_decomposition_mapping_segment, 95)
			Result.put (all_empty_decomposition_mapping_segment, 96)
			Result.put (all_empty_decomposition_mapping_segment, 97)
			Result.put (all_empty_decomposition_mapping_segment, 98)
			Result.put (all_empty_decomposition_mapping_segment, 99)
			Result.put (all_empty_decomposition_mapping_segment, 100)
			Result.put (all_empty_decomposition_mapping_segment, 101)
			Result.put (all_empty_decomposition_mapping_segment, 102)
			Result.put (all_empty_decomposition_mapping_segment, 103)
			Result.put (all_empty_decomposition_mapping_segment, 104)
			Result.put (all_empty_decomposition_mapping_segment, 105)
			Result.put (all_empty_decomposition_mapping_segment, 106)
			Result.put (all_empty_decomposition_mapping_segment, 107)
			Result.put (all_empty_decomposition_mapping_segment, 108)
			Result.put (all_empty_decomposition_mapping_segment, 109)
			Result.put (all_empty_decomposition_mapping_segment, 110)
			Result.put (all_empty_decomposition_mapping_segment, 111)
			Result.put (all_empty_decomposition_mapping_segment, 112)
			Result.put (all_empty_decomposition_mapping_segment, 113)
			Result.put (all_empty_decomposition_mapping_segment, 114)
			Result.put (all_empty_decomposition_mapping_segment, 115)
			Result.put (all_empty_decomposition_mapping_segment, 116)
			Result.put (all_empty_decomposition_mapping_segment, 117)
			Result.put (all_empty_decomposition_mapping_segment, 118)
			Result.put (all_empty_decomposition_mapping_segment, 119)
			Result.put (all_empty_decomposition_mapping_segment, 120)
			Result.put (all_empty_decomposition_mapping_segment, 121)
			Result.put (all_empty_decomposition_mapping_segment, 122)
			Result.put (all_empty_decomposition_mapping_segment, 123)
			Result.put (all_empty_decomposition_mapping_segment, 124)
			Result.put (all_empty_decomposition_mapping_segment, 125)
			Result.put (all_empty_decomposition_mapping_segment, 126)
			Result.put (all_empty_decomposition_mapping_segment, 127)
			Result.put (all_empty_decomposition_mapping_segment, 128)
			Result.put (all_empty_decomposition_mapping_segment, 129)
			Result.put (all_empty_decomposition_mapping_segment, 130)
			Result.put (all_empty_decomposition_mapping_segment, 131)
			Result.put (all_empty_decomposition_mapping_segment, 132)
			Result.put (all_empty_decomposition_mapping_segment, 133)
			Result.put (all_empty_decomposition_mapping_segment, 134)
			Result.put (all_empty_decomposition_mapping_segment, 135)
			Result.put (all_empty_decomposition_mapping_segment, 136)
			Result.put (all_empty_decomposition_mapping_segment, 137)
			Result.put (all_empty_decomposition_mapping_segment, 138)
			Result.put (all_empty_decomposition_mapping_segment, 139)
			Result.put (all_empty_decomposition_mapping_segment, 140)
			Result.put (all_empty_decomposition_mapping_segment, 141)
			Result.put (all_empty_decomposition_mapping_segment, 142)
			Result.put (all_empty_decomposition_mapping_segment, 143)
			Result.put (all_empty_decomposition_mapping_segment, 144)
			Result.put (all_empty_decomposition_mapping_segment, 145)
			Result.put (all_empty_decomposition_mapping_segment, 146)
			Result.put (all_empty_decomposition_mapping_segment, 147)
			Result.put (all_empty_decomposition_mapping_segment, 148)
			Result.put (all_empty_decomposition_mapping_segment, 149)
			Result.put (all_empty_decomposition_mapping_segment, 150)
			Result.put (all_empty_decomposition_mapping_segment, 151)
			Result.put (all_empty_decomposition_mapping_segment, 152)
			Result.put (all_empty_decomposition_mapping_segment, 153)
			Result.put (all_empty_decomposition_mapping_segment, 154)
			Result.put (all_empty_decomposition_mapping_segment, 155)
			Result.put (all_empty_decomposition_mapping_segment, 156)
			Result.put (all_empty_decomposition_mapping_segment, 157)
			Result.put (all_empty_decomposition_mapping_segment, 158)
			Result.put (all_empty_decomposition_mapping_segment, 159)
			Result.put (all_empty_decomposition_mapping_segment, 160)
			Result.put (all_empty_decomposition_mapping_segment, 161)
			Result.put (all_empty_decomposition_mapping_segment, 162)
			Result.put (all_empty_decomposition_mapping_segment, 163)
			Result.put (all_empty_decomposition_mapping_segment, 164)
			Result.put (all_empty_decomposition_mapping_segment, 165)
			Result.put (all_empty_decomposition_mapping_segment, 166)
			Result.put (all_empty_decomposition_mapping_segment, 167)
			Result.put (all_empty_decomposition_mapping_segment, 168)
			Result.put (all_empty_decomposition_mapping_segment, 169)
			Result.put (all_empty_decomposition_mapping_segment, 170)
			Result.put (all_empty_decomposition_mapping_segment, 171)
			Result.put (all_empty_decomposition_mapping_segment, 172)
			Result.put (all_empty_decomposition_mapping_segment, 173)
			Result.put (all_empty_decomposition_mapping_segment, 174)
			Result.put (all_empty_decomposition_mapping_segment, 175)
			Result.put (all_empty_decomposition_mapping_segment, 176)
			Result.put (all_empty_decomposition_mapping_segment, 177)
			Result.put (all_empty_decomposition_mapping_segment, 178)
			Result.put (all_empty_decomposition_mapping_segment, 179)
			Result.put (all_empty_decomposition_mapping_segment, 180)
			Result.put (all_empty_decomposition_mapping_segment, 181)
			Result.put (all_empty_decomposition_mapping_segment, 182)
			Result.put (all_empty_decomposition_mapping_segment, 183)
			Result.put (all_empty_decomposition_mapping_segment, 184)
			Result.put (all_empty_decomposition_mapping_segment, 185)
			Result.put (all_empty_decomposition_mapping_segment, 186)
			Result.put (all_empty_decomposition_mapping_segment, 187)
			Result.put (all_empty_decomposition_mapping_segment, 188)
			Result.put (all_empty_decomposition_mapping_segment, 189)
			Result.put (all_empty_decomposition_mapping_segment, 190)
			Result.put (all_empty_decomposition_mapping_segment, 191)
			Result.put (all_empty_decomposition_mapping_segment, 192)
			Result.put (all_empty_decomposition_mapping_segment, 193)
			Result.put (all_empty_decomposition_mapping_segment, 194)
			Result.put (all_empty_decomposition_mapping_segment, 195)
			Result.put (all_empty_decomposition_mapping_segment, 196)
			Result.put (all_empty_decomposition_mapping_segment, 197)
			Result.put (all_empty_decomposition_mapping_segment, 198)
			Result.put (all_empty_decomposition_mapping_segment, 199)
			Result.put (all_empty_decomposition_mapping_segment, 200)
			Result.put (all_empty_decomposition_mapping_segment, 201)
			Result.put (all_empty_decomposition_mapping_segment, 202)
			Result.put (all_empty_decomposition_mapping_segment, 203)
			Result.put (all_empty_decomposition_mapping_segment, 204)
			Result.put (all_empty_decomposition_mapping_segment, 205)
			Result.put (all_empty_decomposition_mapping_segment, 206)
			Result.put (all_empty_decomposition_mapping_segment, 207)
			Result.put (all_empty_decomposition_mapping_segment, 208)
			Result.put (decomposition_mapping_plane_1_segment_209, 209)
			Result.put (all_empty_decomposition_mapping_segment, 210)
			Result.put (all_empty_decomposition_mapping_segment, 211)
			Result.put (decomposition_mapping_plane_1_segment_212, 212)
			Result.put (decomposition_mapping_plane_1_segment_213, 213)
			Result.put (decomposition_mapping_plane_1_segment_214, 214)
			Result.put (decomposition_mapping_plane_1_segment_215, 215)
			Result.put (all_empty_decomposition_mapping_segment, 216)
			Result.put (all_empty_decomposition_mapping_segment, 217)
			Result.put (all_empty_decomposition_mapping_segment, 218)
			Result.put (all_empty_decomposition_mapping_segment, 219)
			Result.put (all_empty_decomposition_mapping_segment, 220)
			Result.put (all_empty_decomposition_mapping_segment, 221)
			Result.put (all_empty_decomposition_mapping_segment, 222)
			Result.put (all_empty_decomposition_mapping_segment, 223)
			Result.put (all_empty_decomposition_mapping_segment, 224)
			Result.put (all_empty_decomposition_mapping_segment, 225)
			Result.put (all_empty_decomposition_mapping_segment, 226)
			Result.put (all_empty_decomposition_mapping_segment, 227)
			Result.put (all_empty_decomposition_mapping_segment, 228)
			Result.put (all_empty_decomposition_mapping_segment, 229)
			Result.put (all_empty_decomposition_mapping_segment, 230)
			Result.put (all_empty_decomposition_mapping_segment, 231)
			Result.put (all_empty_decomposition_mapping_segment, 232)
			Result.put (all_empty_decomposition_mapping_segment, 233)
			Result.put (all_empty_decomposition_mapping_segment, 234)
			Result.put (all_empty_decomposition_mapping_segment, 235)
			Result.put (all_empty_decomposition_mapping_segment, 236)
			Result.put (all_empty_decomposition_mapping_segment, 237)
			Result.put (all_empty_decomposition_mapping_segment, 238)
			Result.put (all_empty_decomposition_mapping_segment, 239)
			Result.put (all_empty_decomposition_mapping_segment, 240)
			Result.put (all_empty_decomposition_mapping_segment, 241)
			Result.put (all_empty_decomposition_mapping_segment, 242)
			Result.put (all_empty_decomposition_mapping_segment, 243)
			Result.put (all_empty_decomposition_mapping_segment, 244)
			Result.put (all_empty_decomposition_mapping_segment, 245)
			Result.put (all_empty_decomposition_mapping_segment, 246)
			Result.put (all_empty_decomposition_mapping_segment, 247)
			Result.put (all_empty_decomposition_mapping_segment, 248)
			Result.put (all_empty_decomposition_mapping_segment, 249)
			Result.put (all_empty_decomposition_mapping_segment, 250)
			Result.put (all_empty_decomposition_mapping_segment, 251)
			Result.put (all_empty_decomposition_mapping_segment, 252)
			Result.put (all_empty_decomposition_mapping_segment, 253)
			Result.put (all_empty_decomposition_mapping_segment, 254)
			Result.put (all_empty_decomposition_mapping_segment, 255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	decomposition_mapping_plane_2_segment_248: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (20029),0)
			Result.put (new_singleton (20024),1)
			Result.put (new_singleton (20033),2)
			Result.put (new_singleton (131362),3)
			Result.put (new_singleton (20320),4)
			Result.put (new_singleton (20398),5)
			Result.put (new_singleton (20411),6)
			Result.put (new_singleton (20482),7)
			Result.put (new_singleton (20602),8)
			Result.put (new_singleton (20633),9)
			Result.put (new_singleton (20711),10)
			Result.put (new_singleton (20687),11)
			Result.put (new_singleton (13470),12)
			Result.put (new_singleton (132666),13)
			Result.put (new_singleton (20813),14)
			Result.put (new_singleton (20820),15)
			Result.put (new_singleton (20836),16)
			Result.put (new_singleton (20855),17)
			Result.put (new_singleton (132380),18)
			Result.put (new_singleton (13497),19)
			Result.put (new_singleton (20839),20)
			Result.put (new_singleton (20877),21)
			Result.put (new_singleton (132427),22)
			Result.put (new_singleton (20887),23)
			Result.put (new_singleton (20900),24)
			Result.put (new_singleton (20172),25)
			Result.put (new_singleton (20908),26)
			Result.put (new_singleton (20917),27)
			Result.put (new_singleton (168415),28)
			Result.put (new_singleton (20981),29)
			Result.put (new_singleton (20995),30)
			Result.put (new_singleton (13535),31)
			Result.put (new_singleton (21051),32)
			Result.put (new_singleton (21062),33)
			Result.put (new_singleton (21106),34)
			Result.put (new_singleton (21111),35)
			Result.put (new_singleton (13589),36)
			Result.put (new_singleton (21191),37)
			Result.put (new_singleton (21193),38)
			Result.put (new_singleton (21220),39)
			Result.put (new_singleton (21242),40)
			Result.put (new_singleton (21253),41)
			Result.put (new_singleton (21254),42)
			Result.put (new_singleton (21271),43)
			Result.put (new_singleton (21321),44)
			Result.put (new_singleton (21329),45)
			Result.put (new_singleton (21338),46)
			Result.put (new_singleton (21363),47)
			Result.put (new_singleton (21373),48)
			Result.put (new_singleton (21375),49)
			Result.put (new_singleton (21375),50)
			Result.put (new_singleton (21375),51)
			Result.put (new_singleton (133676),52)
			Result.put (new_singleton (28784),53)
			Result.put (new_singleton (21450),54)
			Result.put (new_singleton (21471),55)
			Result.put (new_singleton (133987),56)
			Result.put (new_singleton (21483),57)
			Result.put (new_singleton (21489),58)
			Result.put (new_singleton (21510),59)
			Result.put (new_singleton (21662),60)
			Result.put (new_singleton (21560),61)
			Result.put (new_singleton (21576),62)
			Result.put (new_singleton (21608),63)
			Result.put (new_singleton (21666),64)
			Result.put (new_singleton (21750),65)
			Result.put (new_singleton (21776),66)
			Result.put (new_singleton (21843),67)
			Result.put (new_singleton (21859),68)
			Result.put (new_singleton (21892),69)
			Result.put (new_singleton (21892),70)
			Result.put (new_singleton (21913),71)
			Result.put (new_singleton (21931),72)
			Result.put (new_singleton (21939),73)
			Result.put (new_singleton (21954),74)
			Result.put (new_singleton (22294),75)
			Result.put (new_singleton (22022),76)
			Result.put (new_singleton (22295),77)
			Result.put (new_singleton (22097),78)
			Result.put (new_singleton (22132),79)
			Result.put (new_singleton (20999),80)
			Result.put (new_singleton (22766),81)
			Result.put (new_singleton (22478),82)
			Result.put (new_singleton (22516),83)
			Result.put (new_singleton (22541),84)
			Result.put (new_singleton (22411),85)
			Result.put (new_singleton (22578),86)
			Result.put (new_singleton (22577),87)
			Result.put (new_singleton (22700),88)
			Result.put (new_singleton (136420),89)
			Result.put (new_singleton (22770),90)
			Result.put (new_singleton (22775),91)
			Result.put (new_singleton (22790),92)
			Result.put (new_singleton (22810),93)
			Result.put (new_singleton (22818),94)
			Result.put (new_singleton (22882),95)
			Result.put (new_singleton (136872),96)
			Result.put (new_singleton (136938),97)
			Result.put (new_singleton (23020),98)
			Result.put (new_singleton (23067),99)
			Result.put (new_singleton (23079),100)
			Result.put (new_singleton (23000),101)
			Result.put (new_singleton (23142),102)
			Result.put (new_singleton (14062),103)
			Result.put (new_singleton (14076),104)
			Result.put (new_singleton (23304),105)
			Result.put (new_singleton (23358),106)
			Result.put (new_singleton (23358),107)
			Result.put (new_singleton (137672),108)
			Result.put (new_singleton (23491),109)
			Result.put (new_singleton (23512),110)
			Result.put (new_singleton (23527),111)
			Result.put (new_singleton (23539),112)
			Result.put (new_singleton (138008),113)
			Result.put (new_singleton (23551),114)
			Result.put (new_singleton (23558),115)
			Result.put (new_singleton (24403),116)
			Result.put (new_singleton (23586),117)
			Result.put (new_singleton (14209),118)
			Result.put (new_singleton (23648),119)
			Result.put (new_singleton (23662),120)
			Result.put (new_singleton (23744),121)
			Result.put (new_singleton (23693),122)
			Result.put (new_singleton (138724),123)
			Result.put (new_singleton (23875),124)
			Result.put (new_singleton (138726),125)
			Result.put (new_singleton (23918),126)
			Result.put (new_singleton (23915),127)
			Result.put (new_singleton (23932),128)
			Result.put (new_singleton (24033),129)
			Result.put (new_singleton (24034),130)
			Result.put (new_singleton (14383),131)
			Result.put (new_singleton (24061),132)
			Result.put (new_singleton (24104),133)
			Result.put (new_singleton (24125),134)
			Result.put (new_singleton (24169),135)
			Result.put (new_singleton (14434),136)
			Result.put (new_singleton (139651),137)
			Result.put (new_singleton (14460),138)
			Result.put (new_singleton (24240),139)
			Result.put (new_singleton (24243),140)
			Result.put (new_singleton (24246),141)
			Result.put (new_singleton (24266),142)
			Result.put (new_singleton (172946),143)
			Result.put (new_singleton (24318),144)
			Result.put (new_singleton (140081),145)
			Result.put (new_singleton (140081),146)
			Result.put (new_singleton (33281),147)
			Result.put (new_singleton (24354),148)
			Result.put (new_singleton (24354),149)
			Result.put (new_singleton (14535),150)
			Result.put (new_singleton (144056),151)
			Result.put (new_singleton (156122),152)
			Result.put (new_singleton (24418),153)
			Result.put (new_singleton (24427),154)
			Result.put (new_singleton (14563),155)
			Result.put (new_singleton (24474),156)
			Result.put (new_singleton (24525),157)
			Result.put (new_singleton (24535),158)
			Result.put (new_singleton (24569),159)
			Result.put (new_singleton (24705),160)
			Result.put (new_singleton (14650),161)
			Result.put (new_singleton (14620),162)
			Result.put (new_singleton (24724),163)
			Result.put (new_singleton (141012),164)
			Result.put (new_singleton (24775),165)
			Result.put (new_singleton (24904),166)
			Result.put (new_singleton (24908),167)
			Result.put (new_singleton (24910),168)
			Result.put (new_singleton (24908),169)
			Result.put (new_singleton (24954),170)
			Result.put (new_singleton (24974),171)
			Result.put (new_singleton (25010),172)
			Result.put (new_singleton (24996),173)
			Result.put (new_singleton (25007),174)
			Result.put (new_singleton (25054),175)
			Result.put (new_singleton (25074),176)
			Result.put (new_singleton (25078),177)
			Result.put (new_singleton (25104),178)
			Result.put (new_singleton (25115),179)
			Result.put (new_singleton (25181),180)
			Result.put (new_singleton (25265),181)
			Result.put (new_singleton (25300),182)
			Result.put (new_singleton (25424),183)
			Result.put (new_singleton (142092),184)
			Result.put (new_singleton (25405),185)
			Result.put (new_singleton (25340),186)
			Result.put (new_singleton (25448),187)
			Result.put (new_singleton (25475),188)
			Result.put (new_singleton (25572),189)
			Result.put (new_singleton (142321),190)
			Result.put (new_singleton (25634),191)
			Result.put (new_singleton (25541),192)
			Result.put (new_singleton (25513),193)
			Result.put (new_singleton (14894),194)
			Result.put (new_singleton (25705),195)
			Result.put (new_singleton (25726),196)
			Result.put (new_singleton (25757),197)
			Result.put (new_singleton (25719),198)
			Result.put (new_singleton (14956),199)
			Result.put (new_singleton (25935),200)
			Result.put (new_singleton (25964),201)
			Result.put (new_singleton (143370),202)
			Result.put (new_singleton (26083),203)
			Result.put (new_singleton (26360),204)
			Result.put (new_singleton (26185),205)
			Result.put (new_singleton (15129),206)
			Result.put (new_singleton (26257),207)
			Result.put (new_singleton (15112),208)
			Result.put (new_singleton (15076),209)
			Result.put (new_singleton (20882),210)
			Result.put (new_singleton (20885),211)
			Result.put (new_singleton (26368),212)
			Result.put (new_singleton (26268),213)
			Result.put (new_singleton (32941),214)
			Result.put (new_singleton (17369),215)
			Result.put (new_singleton (26391),216)
			Result.put (new_singleton (26395),217)
			Result.put (new_singleton (26401),218)
			Result.put (new_singleton (26462),219)
			Result.put (new_singleton (26451),220)
			Result.put (new_singleton (144323),221)
			Result.put (new_singleton (15177),222)
			Result.put (new_singleton (26618),223)
			Result.put (new_singleton (26501),224)
			Result.put (new_singleton (26706),225)
			Result.put (new_singleton (26757),226)
			Result.put (new_singleton (144493),227)
			Result.put (new_singleton (26766),228)
			Result.put (new_singleton (26655),229)
			Result.put (new_singleton (26900),230)
			Result.put (new_singleton (15261),231)
			Result.put (new_singleton (26946),232)
			Result.put (new_singleton (27043),233)
			Result.put (new_singleton (27114),234)
			Result.put (new_singleton (27304),235)
			Result.put (new_singleton (145059),236)
			Result.put (new_singleton (27355),237)
			Result.put (new_singleton (15384),238)
			Result.put (new_singleton (27425),239)
			Result.put (new_singleton (145575),240)
			Result.put (new_singleton (27476),241)
			Result.put (new_singleton (15438),242)
			Result.put (new_singleton (27506),243)
			Result.put (new_singleton (27551),244)
			Result.put (new_singleton (27578),245)
			Result.put (new_singleton (27579),246)
			Result.put (new_singleton (146061),247)
			Result.put (new_singleton (138507),248)
			Result.put (new_singleton (146170),249)
			Result.put (new_singleton (27726),250)
			Result.put (new_singleton (146620),251)
			Result.put (new_singleton (27839),252)
			Result.put (new_singleton (27853),253)
			Result.put (new_singleton (27751),254)
			Result.put (new_singleton (27926),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_2_segment_249: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (27966),0)
			Result.put (new_singleton (28023),1)
			Result.put (new_singleton (27969),2)
			Result.put (new_singleton (28009),3)
			Result.put (new_singleton (28024),4)
			Result.put (new_singleton (28037),5)
			Result.put (new_singleton (146718),6)
			Result.put (new_singleton (27956),7)
			Result.put (new_singleton (28207),8)
			Result.put (new_singleton (28270),9)
			Result.put (new_singleton (15667),10)
			Result.put (new_singleton (28363),11)
			Result.put (new_singleton (28359),12)
			Result.put (new_singleton (147153),13)
			Result.put (new_singleton (28153),14)
			Result.put (new_singleton (28526),15)
			Result.put (new_singleton (147294),16)
			Result.put (new_singleton (147342),17)
			Result.put (new_singleton (28614),18)
			Result.put (new_singleton (28729),19)
			Result.put (new_singleton (28702),20)
			Result.put (new_singleton (28699),21)
			Result.put (new_singleton (15766),22)
			Result.put (new_singleton (28746),23)
			Result.put (new_singleton (28797),24)
			Result.put (new_singleton (28791),25)
			Result.put (new_singleton (28845),26)
			Result.put (new_singleton (132389),27)
			Result.put (new_singleton (28997),28)
			Result.put (new_singleton (148067),29)
			Result.put (new_singleton (29084),30)
			Result.put (new_singleton (148395),31)
			Result.put (new_singleton (29224),32)
			Result.put (new_singleton (29237),33)
			Result.put (new_singleton (29264),34)
			Result.put (new_singleton (149000),35)
			Result.put (new_singleton (29312),36)
			Result.put (new_singleton (29333),37)
			Result.put (new_singleton (149301),38)
			Result.put (new_singleton (149524),39)
			Result.put (new_singleton (29562),40)
			Result.put (new_singleton (29579),41)
			Result.put (new_singleton (16044),42)
			Result.put (new_singleton (29605),43)
			Result.put (new_singleton (16056),44)
			Result.put (new_singleton (16056),45)
			Result.put (new_singleton (29767),46)
			Result.put (new_singleton (29788),47)
			Result.put (new_singleton (29809),48)
			Result.put (new_singleton (29829),49)
			Result.put (new_singleton (29898),50)
			Result.put (new_singleton (16155),51)
			Result.put (new_singleton (29988),52)
			Result.put (new_singleton (150582),53)
			Result.put (new_singleton (30014),54)
			Result.put (new_singleton (150674),55)
			Result.put (new_singleton (30064),56)
			Result.put (new_singleton (139679),57)
			Result.put (new_singleton (30224),58)
			Result.put (new_singleton (151457),59)
			Result.put (new_singleton (151480),60)
			Result.put (new_singleton (151620),61)
			Result.put (new_singleton (16380),62)
			Result.put (new_singleton (16392),63)
			Result.put (new_singleton (30452),64)
			Result.put (new_singleton (151795),65)
			Result.put (new_singleton (151794),66)
			Result.put (new_singleton (151833),67)
			Result.put (new_singleton (151859),68)
			Result.put (new_singleton (30494),69)
			Result.put (new_singleton (30495),70)
			Result.put (new_singleton (30495),71)
			Result.put (new_singleton (30538),72)
			Result.put (new_singleton (16441),73)
			Result.put (new_singleton (30603),74)
			Result.put (new_singleton (16454),75)
			Result.put (new_singleton (16534),76)
			Result.put (new_singleton (152605),77)
			Result.put (new_singleton (30798),78)
			Result.put (new_singleton (30860),79)
			Result.put (new_singleton (30924),80)
			Result.put (new_singleton (16611),81)
			Result.put (new_singleton (153126),82)
			Result.put (new_singleton (31062),83)
			Result.put (new_singleton (153242),84)
			Result.put (new_singleton (153285),85)
			Result.put (new_singleton (31119),86)
			Result.put (new_singleton (31211),87)
			Result.put (new_singleton (16687),88)
			Result.put (new_singleton (31296),89)
			Result.put (new_singleton (31306),90)
			Result.put (new_singleton (31311),91)
			Result.put (new_singleton (153980),92)
			Result.put (new_singleton (154279),93)
			Result.put (new_singleton (154279),94)
			Result.put (new_singleton (31470),95)
			Result.put (new_singleton (16898),96)
			Result.put (new_singleton (154539),97)
			Result.put (new_singleton (31686),98)
			Result.put (new_singleton (31689),99)
			Result.put (new_singleton (16935),100)
			Result.put (new_singleton (154752),101)
			Result.put (new_singleton (31954),102)
			Result.put (new_singleton (17056),103)
			Result.put (new_singleton (31976),104)
			Result.put (new_singleton (31971),105)
			Result.put (new_singleton (32000),106)
			Result.put (new_singleton (155526),107)
			Result.put (new_singleton (32099),108)
			Result.put (new_singleton (17153),109)
			Result.put (new_singleton (32199),110)
			Result.put (new_singleton (32258),111)
			Result.put (new_singleton (32325),112)
			Result.put (new_singleton (17204),113)
			Result.put (new_singleton (156200),114)
			Result.put (new_singleton (156231),115)
			Result.put (new_singleton (17241),116)
			Result.put (new_singleton (156377),117)
			Result.put (new_singleton (32634),118)
			Result.put (new_singleton (156478),119)
			Result.put (new_singleton (32661),120)
			Result.put (new_singleton (32762),121)
			Result.put (new_singleton (32773),122)
			Result.put (new_singleton (156890),123)
			Result.put (new_singleton (156963),124)
			Result.put (new_singleton (32864),125)
			Result.put (new_singleton (157096),126)
			Result.put (new_singleton (32880),127)
			Result.put (new_singleton (144223),128)
			Result.put (new_singleton (17365),129)
			Result.put (new_singleton (32946),130)
			Result.put (new_singleton (33027),131)
			Result.put (new_singleton (17419),132)
			Result.put (new_singleton (33086),133)
			Result.put (new_singleton (23221),134)
			Result.put (new_singleton (157607),135)
			Result.put (new_singleton (157621),136)
			Result.put (new_singleton (144275),137)
			Result.put (new_singleton (144284),138)
			Result.put (new_singleton (33281),139)
			Result.put (new_singleton (33284),140)
			Result.put (new_singleton (36766),141)
			Result.put (new_singleton (17515),142)
			Result.put (new_singleton (33425),143)
			Result.put (new_singleton (33419),144)
			Result.put (new_singleton (33437),145)
			Result.put (new_singleton (21171),146)
			Result.put (new_singleton (33457),147)
			Result.put (new_singleton (33459),148)
			Result.put (new_singleton (33469),149)
			Result.put (new_singleton (33510),150)
			Result.put (new_singleton (158524),151)
			Result.put (new_singleton (33509),152)
			Result.put (new_singleton (33565),153)
			Result.put (new_singleton (33635),154)
			Result.put (new_singleton (33709),155)
			Result.put (new_singleton (33571),156)
			Result.put (new_singleton (33725),157)
			Result.put (new_singleton (33767),158)
			Result.put (new_singleton (33879),159)
			Result.put (new_singleton (33619),160)
			Result.put (new_singleton (33738),161)
			Result.put (new_singleton (33740),162)
			Result.put (new_singleton (33756),163)
			Result.put (new_singleton (158774),164)
			Result.put (new_singleton (159083),165)
			Result.put (new_singleton (158933),166)
			Result.put (new_singleton (17707),167)
			Result.put (new_singleton (34033),168)
			Result.put (new_singleton (34035),169)
			Result.put (new_singleton (34070),170)
			Result.put (new_singleton (160714),171)
			Result.put (new_singleton (34148),172)
			Result.put (new_singleton (159532),173)
			Result.put (new_singleton (17757),174)
			Result.put (new_singleton (17761),175)
			Result.put (new_singleton (159665),176)
			Result.put (new_singleton (159954),177)
			Result.put (new_singleton (17771),178)
			Result.put (new_singleton (34384),179)
			Result.put (new_singleton (34396),180)
			Result.put (new_singleton (34407),181)
			Result.put (new_singleton (34409),182)
			Result.put (new_singleton (34473),183)
			Result.put (new_singleton (34440),184)
			Result.put (new_singleton (34574),185)
			Result.put (new_singleton (34530),186)
			Result.put (new_singleton (34681),187)
			Result.put (new_singleton (34600),188)
			Result.put (new_singleton (34667),189)
			Result.put (new_singleton (34694),190)
			Result.put (new_singleton (17879),191)
			Result.put (new_singleton (34785),192)
			Result.put (new_singleton (34817),193)
			Result.put (new_singleton (17913),194)
			Result.put (new_singleton (34912),195)
			Result.put (new_singleton (34915),196)
			Result.put (new_singleton (161383),197)
			Result.put (new_singleton (35031),198)
			Result.put (new_singleton (35038),199)
			Result.put (new_singleton (17973),200)
			Result.put (new_singleton (35066),201)
			Result.put (new_singleton (13499),202)
			Result.put (new_singleton (161966),203)
			Result.put (new_singleton (162150),204)
			Result.put (new_singleton (18110),205)
			Result.put (new_singleton (18119),206)
			Result.put (new_singleton (35488),207)
			Result.put (new_singleton (35565),208)
			Result.put (new_singleton (35722),209)
			Result.put (new_singleton (35925),210)
			Result.put (new_singleton (162984),211)
			Result.put (new_singleton (36011),212)
			Result.put (new_singleton (36033),213)
			Result.put (new_singleton (36123),214)
			Result.put (new_singleton (36215),215)
			Result.put (new_singleton (163631),216)
			Result.put (new_singleton (133124),217)
			Result.put (new_singleton (36299),218)
			Result.put (new_singleton (36284),219)
			Result.put (new_singleton (36336),220)
			Result.put (new_singleton (133342),221)
			Result.put (new_singleton (36564),222)
			Result.put (new_singleton (36664),223)
			Result.put (new_singleton (165330),224)
			Result.put (new_singleton (165357),225)
			Result.put (new_singleton (37012),226)
			Result.put (new_singleton (37105),227)
			Result.put (new_singleton (37137),228)
			Result.put (new_singleton (165678),229)
			Result.put (new_singleton (37147),230)
			Result.put (new_singleton (37432),231)
			Result.put (new_singleton (37591),232)
			Result.put (new_singleton (37592),233)
			Result.put (new_singleton (37500),234)
			Result.put (new_singleton (37881),235)
			Result.put (new_singleton (37909),236)
			Result.put (new_singleton (166906),237)
			Result.put (new_singleton (38283),238)
			Result.put (new_singleton (18837),239)
			Result.put (new_singleton (38327),240)
			Result.put (new_singleton (167287),241)
			Result.put (new_singleton (18918),242)
			Result.put (new_singleton (38595),243)
			Result.put (new_singleton (23986),244)
			Result.put (new_singleton (38691),245)
			Result.put (new_singleton (168261),246)
			Result.put (new_singleton (168474),247)
			Result.put (new_singleton (19054),248)
			Result.put (new_singleton (19062),249)
			Result.put (new_singleton (38880),250)
			Result.put (new_singleton (168970),251)
			Result.put (new_singleton (19122),252)
			Result.put (new_singleton (169110),253)
			Result.put (new_singleton (38923),254)
			Result.put (new_singleton (38923),255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_2_segment_250: ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]
			-- Generated arrayed_list segment
		once
			create Result.make_filled (Void, 0, 255)
			Result.put (new_singleton (38953),0)
			Result.put (new_singleton (169398),1)
			Result.put (new_singleton (39138),2)
			Result.put (new_singleton (19251),3)
			Result.put (new_singleton (39209),4)
			Result.put (new_singleton (39335),5)
			Result.put (new_singleton (39362),6)
			Result.put (new_singleton (39422),7)
			Result.put (new_singleton (19406),8)
			Result.put (new_singleton (170800),9)
			Result.put (new_singleton (39698),10)
			Result.put (new_singleton (40000),11)
			Result.put (new_singleton (40189),12)
			Result.put (new_singleton (19662),13)
			Result.put (new_singleton (19693),14)
			Result.put (new_singleton (40295),15)
			Result.put (new_singleton (172238),16)
			Result.put (new_singleton (19704),17)
			Result.put (new_singleton (172293),18)
			Result.put (new_singleton (172558),19)
			Result.put (new_singleton (172689),20)
			Result.put (new_singleton (40635),21)
			Result.put (new_singleton (19798),22)
			Result.put (new_singleton (40697),23)
			Result.put (new_singleton (40702),24)
			Result.put (new_singleton (40709),25)
			Result.put (new_singleton (40719),26)
			Result.put (new_singleton (40726),27)
			Result.put (new_singleton (40763),28)
			Result.put (new_singleton (173568),29)
		ensure
			instance_free: class
			result_not_void: Result /= Void
		end

	decomposition_mapping_plane_2: SPECIAL [ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]]
			-- Generated array plane
		once
			create Result.make_filled (all_empty_decomposition_mapping_segment, 256)
			Result.put (all_empty_decomposition_mapping_segment, 1)
			Result.put (all_empty_decomposition_mapping_segment, 2)
			Result.put (all_empty_decomposition_mapping_segment, 3)
			Result.put (all_empty_decomposition_mapping_segment, 4)
			Result.put (all_empty_decomposition_mapping_segment, 5)
			Result.put (all_empty_decomposition_mapping_segment, 6)
			Result.put (all_empty_decomposition_mapping_segment, 7)
			Result.put (all_empty_decomposition_mapping_segment, 8)
			Result.put (all_empty_decomposition_mapping_segment, 9)
			Result.put (all_empty_decomposition_mapping_segment, 10)
			Result.put (all_empty_decomposition_mapping_segment, 11)
			Result.put (all_empty_decomposition_mapping_segment, 12)
			Result.put (all_empty_decomposition_mapping_segment, 13)
			Result.put (all_empty_decomposition_mapping_segment, 14)
			Result.put (all_empty_decomposition_mapping_segment, 15)
			Result.put (all_empty_decomposition_mapping_segment, 16)
			Result.put (all_empty_decomposition_mapping_segment, 17)
			Result.put (all_empty_decomposition_mapping_segment, 18)
			Result.put (all_empty_decomposition_mapping_segment, 19)
			Result.put (all_empty_decomposition_mapping_segment, 20)
			Result.put (all_empty_decomposition_mapping_segment, 21)
			Result.put (all_empty_decomposition_mapping_segment, 22)
			Result.put (all_empty_decomposition_mapping_segment, 23)
			Result.put (all_empty_decomposition_mapping_segment, 24)
			Result.put (all_empty_decomposition_mapping_segment, 25)
			Result.put (all_empty_decomposition_mapping_segment, 26)
			Result.put (all_empty_decomposition_mapping_segment, 27)
			Result.put (all_empty_decomposition_mapping_segment, 28)
			Result.put (all_empty_decomposition_mapping_segment, 29)
			Result.put (all_empty_decomposition_mapping_segment, 30)
			Result.put (all_empty_decomposition_mapping_segment, 31)
			Result.put (all_empty_decomposition_mapping_segment, 32)
			Result.put (all_empty_decomposition_mapping_segment, 33)
			Result.put (all_empty_decomposition_mapping_segment, 34)
			Result.put (all_empty_decomposition_mapping_segment, 35)
			Result.put (all_empty_decomposition_mapping_segment, 36)
			Result.put (all_empty_decomposition_mapping_segment, 37)
			Result.put (all_empty_decomposition_mapping_segment, 38)
			Result.put (all_empty_decomposition_mapping_segment, 39)
			Result.put (all_empty_decomposition_mapping_segment, 40)
			Result.put (all_empty_decomposition_mapping_segment, 41)
			Result.put (all_empty_decomposition_mapping_segment, 42)
			Result.put (all_empty_decomposition_mapping_segment, 43)
			Result.put (all_empty_decomposition_mapping_segment, 44)
			Result.put (all_empty_decomposition_mapping_segment, 45)
			Result.put (all_empty_decomposition_mapping_segment, 46)
			Result.put (all_empty_decomposition_mapping_segment, 47)
			Result.put (all_empty_decomposition_mapping_segment, 48)
			Result.put (all_empty_decomposition_mapping_segment, 49)
			Result.put (all_empty_decomposition_mapping_segment, 50)
			Result.put (all_empty_decomposition_mapping_segment, 51)
			Result.put (all_empty_decomposition_mapping_segment, 52)
			Result.put (all_empty_decomposition_mapping_segment, 53)
			Result.put (all_empty_decomposition_mapping_segment, 54)
			Result.put (all_empty_decomposition_mapping_segment, 55)
			Result.put (all_empty_decomposition_mapping_segment, 56)
			Result.put (all_empty_decomposition_mapping_segment, 57)
			Result.put (all_empty_decomposition_mapping_segment, 58)
			Result.put (all_empty_decomposition_mapping_segment, 59)
			Result.put (all_empty_decomposition_mapping_segment, 60)
			Result.put (all_empty_decomposition_mapping_segment, 61)
			Result.put (all_empty_decomposition_mapping_segment, 62)
			Result.put (all_empty_decomposition_mapping_segment, 63)
			Result.put (all_empty_decomposition_mapping_segment, 64)
			Result.put (all_empty_decomposition_mapping_segment, 65)
			Result.put (all_empty_decomposition_mapping_segment, 66)
			Result.put (all_empty_decomposition_mapping_segment, 67)
			Result.put (all_empty_decomposition_mapping_segment, 68)
			Result.put (all_empty_decomposition_mapping_segment, 69)
			Result.put (all_empty_decomposition_mapping_segment, 70)
			Result.put (all_empty_decomposition_mapping_segment, 71)
			Result.put (all_empty_decomposition_mapping_segment, 72)
			Result.put (all_empty_decomposition_mapping_segment, 73)
			Result.put (all_empty_decomposition_mapping_segment, 74)
			Result.put (all_empty_decomposition_mapping_segment, 75)
			Result.put (all_empty_decomposition_mapping_segment, 76)
			Result.put (all_empty_decomposition_mapping_segment, 77)
			Result.put (all_empty_decomposition_mapping_segment, 78)
			Result.put (all_empty_decomposition_mapping_segment, 79)
			Result.put (all_empty_decomposition_mapping_segment, 80)
			Result.put (all_empty_decomposition_mapping_segment, 81)
			Result.put (all_empty_decomposition_mapping_segment, 82)
			Result.put (all_empty_decomposition_mapping_segment, 83)
			Result.put (all_empty_decomposition_mapping_segment, 84)
			Result.put (all_empty_decomposition_mapping_segment, 85)
			Result.put (all_empty_decomposition_mapping_segment, 86)
			Result.put (all_empty_decomposition_mapping_segment, 87)
			Result.put (all_empty_decomposition_mapping_segment, 88)
			Result.put (all_empty_decomposition_mapping_segment, 89)
			Result.put (all_empty_decomposition_mapping_segment, 90)
			Result.put (all_empty_decomposition_mapping_segment, 91)
			Result.put (all_empty_decomposition_mapping_segment, 92)
			Result.put (all_empty_decomposition_mapping_segment, 93)
			Result.put (all_empty_decomposition_mapping_segment, 94)
			Result.put (all_empty_decomposition_mapping_segment, 95)
			Result.put (all_empty_decomposition_mapping_segment, 96)
			Result.put (all_empty_decomposition_mapping_segment, 97)
			Result.put (all_empty_decomposition_mapping_segment, 98)
			Result.put (all_empty_decomposition_mapping_segment, 99)
			Result.put (all_empty_decomposition_mapping_segment, 100)
			Result.put (all_empty_decomposition_mapping_segment, 101)
			Result.put (all_empty_decomposition_mapping_segment, 102)
			Result.put (all_empty_decomposition_mapping_segment, 103)
			Result.put (all_empty_decomposition_mapping_segment, 104)
			Result.put (all_empty_decomposition_mapping_segment, 105)
			Result.put (all_empty_decomposition_mapping_segment, 106)
			Result.put (all_empty_decomposition_mapping_segment, 107)
			Result.put (all_empty_decomposition_mapping_segment, 108)
			Result.put (all_empty_decomposition_mapping_segment, 109)
			Result.put (all_empty_decomposition_mapping_segment, 110)
			Result.put (all_empty_decomposition_mapping_segment, 111)
			Result.put (all_empty_decomposition_mapping_segment, 112)
			Result.put (all_empty_decomposition_mapping_segment, 113)
			Result.put (all_empty_decomposition_mapping_segment, 114)
			Result.put (all_empty_decomposition_mapping_segment, 115)
			Result.put (all_empty_decomposition_mapping_segment, 116)
			Result.put (all_empty_decomposition_mapping_segment, 117)
			Result.put (all_empty_decomposition_mapping_segment, 118)
			Result.put (all_empty_decomposition_mapping_segment, 119)
			Result.put (all_empty_decomposition_mapping_segment, 120)
			Result.put (all_empty_decomposition_mapping_segment, 121)
			Result.put (all_empty_decomposition_mapping_segment, 122)
			Result.put (all_empty_decomposition_mapping_segment, 123)
			Result.put (all_empty_decomposition_mapping_segment, 124)
			Result.put (all_empty_decomposition_mapping_segment, 125)
			Result.put (all_empty_decomposition_mapping_segment, 126)
			Result.put (all_empty_decomposition_mapping_segment, 127)
			Result.put (all_empty_decomposition_mapping_segment, 128)
			Result.put (all_empty_decomposition_mapping_segment, 129)
			Result.put (all_empty_decomposition_mapping_segment, 130)
			Result.put (all_empty_decomposition_mapping_segment, 131)
			Result.put (all_empty_decomposition_mapping_segment, 132)
			Result.put (all_empty_decomposition_mapping_segment, 133)
			Result.put (all_empty_decomposition_mapping_segment, 134)
			Result.put (all_empty_decomposition_mapping_segment, 135)
			Result.put (all_empty_decomposition_mapping_segment, 136)
			Result.put (all_empty_decomposition_mapping_segment, 137)
			Result.put (all_empty_decomposition_mapping_segment, 138)
			Result.put (all_empty_decomposition_mapping_segment, 139)
			Result.put (all_empty_decomposition_mapping_segment, 140)
			Result.put (all_empty_decomposition_mapping_segment, 141)
			Result.put (all_empty_decomposition_mapping_segment, 142)
			Result.put (all_empty_decomposition_mapping_segment, 143)
			Result.put (all_empty_decomposition_mapping_segment, 144)
			Result.put (all_empty_decomposition_mapping_segment, 145)
			Result.put (all_empty_decomposition_mapping_segment, 146)
			Result.put (all_empty_decomposition_mapping_segment, 147)
			Result.put (all_empty_decomposition_mapping_segment, 148)
			Result.put (all_empty_decomposition_mapping_segment, 149)
			Result.put (all_empty_decomposition_mapping_segment, 150)
			Result.put (all_empty_decomposition_mapping_segment, 151)
			Result.put (all_empty_decomposition_mapping_segment, 152)
			Result.put (all_empty_decomposition_mapping_segment, 153)
			Result.put (all_empty_decomposition_mapping_segment, 154)
			Result.put (all_empty_decomposition_mapping_segment, 155)
			Result.put (all_empty_decomposition_mapping_segment, 156)
			Result.put (all_empty_decomposition_mapping_segment, 157)
			Result.put (all_empty_decomposition_mapping_segment, 158)
			Result.put (all_empty_decomposition_mapping_segment, 159)
			Result.put (all_empty_decomposition_mapping_segment, 160)
			Result.put (all_empty_decomposition_mapping_segment, 161)
			Result.put (all_empty_decomposition_mapping_segment, 162)
			Result.put (all_empty_decomposition_mapping_segment, 163)
			Result.put (all_empty_decomposition_mapping_segment, 164)
			Result.put (all_empty_decomposition_mapping_segment, 165)
			Result.put (all_empty_decomposition_mapping_segment, 166)
			Result.put (all_empty_decomposition_mapping_segment, 167)
			Result.put (all_empty_decomposition_mapping_segment, 168)
			Result.put (all_empty_decomposition_mapping_segment, 169)
			Result.put (all_empty_decomposition_mapping_segment, 170)
			Result.put (all_empty_decomposition_mapping_segment, 171)
			Result.put (all_empty_decomposition_mapping_segment, 172)
			Result.put (all_empty_decomposition_mapping_segment, 173)
			Result.put (all_empty_decomposition_mapping_segment, 174)
			Result.put (all_empty_decomposition_mapping_segment, 175)
			Result.put (all_empty_decomposition_mapping_segment, 176)
			Result.put (all_empty_decomposition_mapping_segment, 177)
			Result.put (all_empty_decomposition_mapping_segment, 178)
			Result.put (all_empty_decomposition_mapping_segment, 179)
			Result.put (all_empty_decomposition_mapping_segment, 180)
			Result.put (all_empty_decomposition_mapping_segment, 181)
			Result.put (all_empty_decomposition_mapping_segment, 182)
			Result.put (all_empty_decomposition_mapping_segment, 183)
			Result.put (all_empty_decomposition_mapping_segment, 184)
			Result.put (all_empty_decomposition_mapping_segment, 185)
			Result.put (all_empty_decomposition_mapping_segment, 186)
			Result.put (all_empty_decomposition_mapping_segment, 187)
			Result.put (all_empty_decomposition_mapping_segment, 188)
			Result.put (all_empty_decomposition_mapping_segment, 189)
			Result.put (all_empty_decomposition_mapping_segment, 190)
			Result.put (all_empty_decomposition_mapping_segment, 191)
			Result.put (all_empty_decomposition_mapping_segment, 192)
			Result.put (all_empty_decomposition_mapping_segment, 193)
			Result.put (all_empty_decomposition_mapping_segment, 194)
			Result.put (all_empty_decomposition_mapping_segment, 195)
			Result.put (all_empty_decomposition_mapping_segment, 196)
			Result.put (all_empty_decomposition_mapping_segment, 197)
			Result.put (all_empty_decomposition_mapping_segment, 198)
			Result.put (all_empty_decomposition_mapping_segment, 199)
			Result.put (all_empty_decomposition_mapping_segment, 200)
			Result.put (all_empty_decomposition_mapping_segment, 201)
			Result.put (all_empty_decomposition_mapping_segment, 202)
			Result.put (all_empty_decomposition_mapping_segment, 203)
			Result.put (all_empty_decomposition_mapping_segment, 204)
			Result.put (all_empty_decomposition_mapping_segment, 205)
			Result.put (all_empty_decomposition_mapping_segment, 206)
			Result.put (all_empty_decomposition_mapping_segment, 207)
			Result.put (all_empty_decomposition_mapping_segment, 208)
			Result.put (all_empty_decomposition_mapping_segment, 209)
			Result.put (all_empty_decomposition_mapping_segment, 210)
			Result.put (all_empty_decomposition_mapping_segment, 211)
			Result.put (all_empty_decomposition_mapping_segment, 212)
			Result.put (all_empty_decomposition_mapping_segment, 213)
			Result.put (all_empty_decomposition_mapping_segment, 214)
			Result.put (all_empty_decomposition_mapping_segment, 215)
			Result.put (all_empty_decomposition_mapping_segment, 216)
			Result.put (all_empty_decomposition_mapping_segment, 217)
			Result.put (all_empty_decomposition_mapping_segment, 218)
			Result.put (all_empty_decomposition_mapping_segment, 219)
			Result.put (all_empty_decomposition_mapping_segment, 220)
			Result.put (all_empty_decomposition_mapping_segment, 221)
			Result.put (all_empty_decomposition_mapping_segment, 222)
			Result.put (all_empty_decomposition_mapping_segment, 223)
			Result.put (all_empty_decomposition_mapping_segment, 224)
			Result.put (all_empty_decomposition_mapping_segment, 225)
			Result.put (all_empty_decomposition_mapping_segment, 226)
			Result.put (all_empty_decomposition_mapping_segment, 227)
			Result.put (all_empty_decomposition_mapping_segment, 228)
			Result.put (all_empty_decomposition_mapping_segment, 229)
			Result.put (all_empty_decomposition_mapping_segment, 230)
			Result.put (all_empty_decomposition_mapping_segment, 231)
			Result.put (all_empty_decomposition_mapping_segment, 232)
			Result.put (all_empty_decomposition_mapping_segment, 233)
			Result.put (all_empty_decomposition_mapping_segment, 234)
			Result.put (all_empty_decomposition_mapping_segment, 235)
			Result.put (all_empty_decomposition_mapping_segment, 236)
			Result.put (all_empty_decomposition_mapping_segment, 237)
			Result.put (all_empty_decomposition_mapping_segment, 238)
			Result.put (all_empty_decomposition_mapping_segment, 239)
			Result.put (all_empty_decomposition_mapping_segment, 240)
			Result.put (all_empty_decomposition_mapping_segment, 241)
			Result.put (all_empty_decomposition_mapping_segment, 242)
			Result.put (all_empty_decomposition_mapping_segment, 243)
			Result.put (all_empty_decomposition_mapping_segment, 244)
			Result.put (all_empty_decomposition_mapping_segment, 245)
			Result.put (all_empty_decomposition_mapping_segment, 246)
			Result.put (all_empty_decomposition_mapping_segment, 247)
			Result.put (decomposition_mapping_plane_2_segment_248, 248)
			Result.put (decomposition_mapping_plane_2_segment_249, 249)
			Result.put (decomposition_mapping_plane_2_segment_250, 250)
			Result.put (all_empty_decomposition_mapping_segment, 251)
			Result.put (all_empty_decomposition_mapping_segment, 252)
			Result.put (all_empty_decomposition_mapping_segment, 253)
			Result.put (all_empty_decomposition_mapping_segment, 254)
			Result.put (all_empty_decomposition_mapping_segment, 255)
		ensure
			instance_free: class
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	all_empty_decomposition_mapping_plane: SPECIAL [ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]]
			-- Generated array plane
		once
			create Result.make_filled (all_empty_decomposition_mapping_segment, 256)
		ensure
			instance_free: class
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	decomposition_mapping_properties: SPECIAL [SPECIAL [ARRAY [detachable DS_ARRAYED_LIST [INTEGER]]]]
			-- Decomposition mapping for each code point
		once
			create Result.make_filled (decomposition_mapping_plane_0, 17)
			Result.put (decomposition_mapping_plane_1, 1)
			Result.put (decomposition_mapping_plane_2, 2)
			Result.put (all_empty_decomposition_mapping_plane, 3)
			Result.put (all_empty_decomposition_mapping_plane, 4)
			Result.put (all_empty_decomposition_mapping_plane, 5)
			Result.put (all_empty_decomposition_mapping_plane, 6)
			Result.put (all_empty_decomposition_mapping_plane, 7)
			Result.put (all_empty_decomposition_mapping_plane, 8)
			Result.put (all_empty_decomposition_mapping_plane, 9)
			Result.put (all_empty_decomposition_mapping_plane, 10)
			Result.put (all_empty_decomposition_mapping_plane, 11)
			Result.put (all_empty_decomposition_mapping_plane, 12)
			Result.put (all_empty_decomposition_mapping_plane, 13)
			Result.put (all_empty_decomposition_mapping_plane, 14)
			Result.put (all_empty_decomposition_mapping_plane, 15)
			Result.put (all_empty_decomposition_mapping_plane, 16)
		end


	composition_map_first_integer_1: STRING = "ᄀ가가가가가가가가가가가가가가가가가가가가가가가가가가가ᄀ개개개개개개개개개개개개개개개개개개개개개개개개개개개ᄀ갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸갸ᄀ걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔걔ᄀ거거거거거거거거거거거거거거거거거거거거거거거거거거거ᄀ게게게게게게게게게게게게게게게게게게게게게게게게게게게ᄀ겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨겨ᄀ계계계계계계계계계계계계계계계계계계계계계계계계계계계ᄀ고고고고고고고고고고고고고고고고고고고고고고고고고고고ᄀ과과과과과과과과과과과과과과과과과과과과과과과과과과과ᄀ괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘괘ᄀ괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴괴ᄀ교교교교교교교교교교교교교교교교교교교교교교교교교교교ᄀ구구구구구구구구구구구구구구구구구구구구구구구구구구구ᄀ궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈궈ᄀ궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤궤ᄀ귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀귀ᄀ규규규규규규규규규규규규규규규규규규규규규규규규규규규ᄀ그그그그그그그그그그그그그그그그그그그그그그그그그그그ᄀ긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔긔ᄀ기기기기기기기기기기기기기기기기기기기기기기기기기기기ᄁ까까까까까까까까까까까까까까까까까까까까까까까까까까까ᄁ깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨깨ᄁ꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄꺄ᄁ꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠꺠ᄁ꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼꺼ᄁ께께께께께께께께께께께께께께께께께께께께께께께께께께께ᄁ껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴껴ᄁ꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐꼐ᄁ꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬꼬ᄁ꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈꽈ᄁ꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤꽤ᄁ꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀꾀ᄁ꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜꾜ᄁ꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸꾸ᄁ꿔꿔꿔꿔꿔꿔꿔꿔꿔꿔꿔꿔꿔꿔꿔꿔꿔꿔꿔꿔"


	composition_map_second_integer_1: STRING = "ᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻ"


	composition_map_third_integer_1: STRING = "가각갂갃간갅갆갇갈갉갊갋갌갍갎갏감갑값갓갔강갖갗갘같갚갛개객갞갟갠갡갢갣갤갥갦갧갨갩갪갫갬갭갮갯갰갱갲갳갴갵갶갷갸갹갺갻갼갽갾갿걀걁걂걃걄걅걆걇걈걉걊걋걌걍걎걏걐걑걒걓걔걕걖걗걘걙걚걛걜걝걞걟걠걡걢걣걤걥걦걧걨걩걪걫걬걭걮걯거걱걲걳건걵걶걷걸걹걺걻걼걽걾걿검겁겂것겄겅겆겇겈겉겊겋게겍겎겏겐겑겒겓겔겕겖겗겘겙겚겛겜겝겞겟겠겡겢겣겤겥겦겧겨격겪겫견겭겮겯결겱겲겳겴겵겶겷겸겹겺겻겼경겾겿곀곁곂곃계곅곆곇곈곉곊곋곌곍곎곏곐곑곒곓곔곕곖곗곘곙곚곛곜곝곞곟고곡곢곣곤곥곦곧골곩곪곫곬곭곮곯곰곱곲곳곴공곶곷곸곹곺곻과곽곾곿관괁괂괃괄괅괆괇괈괉괊괋괌괍괎괏괐광괒괓괔괕괖괗괘괙괚괛괜괝괞괟괠괡괢괣괤괥괦괧괨괩괪괫괬괭괮괯괰괱괲괳괴괵괶괷괸괹괺괻괼괽괾괿굀굁굂굃굄굅굆굇굈굉굊굋굌굍굎굏교굑굒굓굔굕굖굗굘굙굚굛굜굝굞굟굠굡굢굣굤굥굦굧굨굩굪굫구국굮굯군굱굲굳굴굵굶굷굸굹굺굻굼굽굾굿궀궁궂궃궄궅궆궇궈궉궊궋권궍궎궏궐궑궒궓궔궕궖궗궘궙궚궛궜궝궞궟궠궡궢궣궤궥궦궧궨궩궪궫궬궭궮궯궰궱궲궳궴궵궶궷궸궹궺궻궼궽궾궿귀귁귂귃귄귅귆귇귈귉귊귋귌귍귎귏귐귑귒귓귔귕귖귗귘귙귚귛규귝귞귟균귡귢귣귤귥귦귧귨귩귪귫귬귭귮귯귰귱귲귳귴귵귶귷그극귺귻근귽귾귿글긁긂긃긄긅긆긇금급긊긋긌긍긎긏긐긑긒긓긔긕긖긗긘긙긚긛긜긝긞긟긠긡긢긣긤긥긦긧긨긩긪긫긬긭긮긯기긱긲긳긴긵긶긷길긹긺긻긼긽긾긿김깁깂깃깄깅깆깇깈깉깊깋까깍깎깏깐깑깒깓깔깕깖깗깘깙깚깛깜깝깞깟깠깡깢깣깤깥깦깧깨깩깪깫깬깭깮깯깰깱깲깳깴깵깶깷깸깹깺깻깼깽깾깿꺀꺁꺂꺃꺄꺅꺆꺇꺈꺉꺊꺋꺌꺍꺎꺏꺐꺑꺒꺓꺔꺕꺖꺗꺘꺙꺚꺛꺜꺝꺞꺟꺠꺡꺢꺣꺤꺥꺦꺧꺨꺩꺪꺫꺬꺭꺮꺯꺰꺱꺲꺳꺴꺵꺶꺷꺸꺹꺺꺻꺼꺽꺾꺿껀껁껂껃껄껅껆껇껈껉껊껋껌껍껎껏껐껑껒껓껔껕껖껗께껙껚껛껜껝껞껟껠껡껢껣껤껥껦껧껨껩껪껫껬껭껮껯껰껱껲껳껴껵껶껷껸껹껺껻껼껽껾껿꼀꼁꼂꼃꼄꼅꼆꼇꼈꼉꼊꼋꼌꼍꼎꼏꼐꼑꼒꼓꼔꼕꼖꼗꼘꼙꼚꼛꼜꼝꼞꼟꼠꼡꼢꼣꼤꼥꼦꼧꼨꼩꼪꼫꼬꼭꼮꼯꼰꼱꼲꼳꼴꼵꼶꼷꼸꼹꼺꼻꼼꼽꼾꼿꽀꽁꽂꽃꽄꽅꽆꽇꽈꽉꽊꽋꽌꽍꽎꽏꽐꽑꽒꽓꽔꽕꽖꽗꽘꽙꽚꽛꽜꽝꽞꽟꽠꽡꽢꽣꽤꽥꽦꽧꽨꽩꽪꽫꽬꽭꽮꽯꽰꽱꽲꽳꽴꽵꽶꽷꽸꽹꽺꽻꽼꽽꽾꽿꾀꾁꾂꾃꾄꾅꾆꾇꾈꾉꾊꾋꾌꾍꾎꾏꾐꾑꾒꾓꾔꾕꾖꾗꾘꾙꾚꾛꾜꾝꾞꾟꾠꾡꾢꾣꾤꾥꾦꾧꾨꾩꾪꾫꾬꾭꾮꾯꾰꾱꾲꾳꾴꾵꾶꾷꾸꾹꾺꾻꾼꾽꾾꾿꿀꿁꿂꿃꿄꿅꿆꿇꿈꿉꿊꿋꿌꿍꿎꿏꿐꿑꿒꿓꿔꿕꿖꿗꿘꿙꿚꿛꿜꿝꿞꿟꿠꿡꿢꿣꿤꿥꿦꿧꿨"


	composition_map_first_integer_2: STRING = "꿔꿔꿔꿔꿔꿔꿔ᄁ꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰꿰ᄁ뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌뀌ᄁ뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨뀨ᄁ끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄끄ᄁ끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠끠ᄁ끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼끼ᄂ나나나나나나나나나나나나나나나나나나나나나나나나나나나ᄂ내내내내내내내내내내내내내내내내내내내내내내내내내내내ᄂ냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐냐ᄂ냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬냬ᄂ너너너너너너너너너너너너너너너너너너너너너너너너너너너ᄂ네네네네네네네네네네네네네네네네네네네네네네네네네네네ᄂ녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀녀ᄂ녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜녜ᄂ노노노노노노노노노노노노노노노노노노노노노노노노노노노ᄂ놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔놔ᄂ놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰놰ᄂ뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌뇌ᄂ뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨뇨ᄂ누누누누누누누누누누누누누누누누누누누누누누누누누누누ᄂ눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠눠ᄂ눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼눼ᄂ뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘뉘ᄂ뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴뉴ᄂ느느느느느느느느느느느느느느느느느느느느느느느느느느느ᄂ늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬늬ᄂ니니니니니니니니니니니니니니니니니니니니니니니니니니니ᄃ다다다다다다다다다다다다다다다다다다다다다다다다다다다ᄃ대대대대대대대대대대대대대대대대대대대대대대대대대대대ᄃ댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜댜ᄃ댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸댸ᄃ더더더더더더더더더더더더더더더더더더더더더더더더더더더ᄃ데데데데데데데데데데데데데데데데데데데데데데데데데데데ᄃ뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌뎌ᄃ뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨뎨ᄃ도도도도도도도도도도도도도"


	composition_map_second_integer_2: STRING = "ᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴ"


	composition_map_third_integer_2: STRING = "꿩꿪꿫꿬꿭꿮꿯꿰꿱꿲꿳꿴꿵꿶꿷꿸꿹꿺꿻꿼꿽꿾꿿뀀뀁뀂뀃뀄뀅뀆뀇뀈뀉뀊뀋뀌뀍뀎뀏뀐뀑뀒뀓뀔뀕뀖뀗뀘뀙뀚뀛뀜뀝뀞뀟뀠뀡뀢뀣뀤뀥뀦뀧뀨뀩뀪뀫뀬뀭뀮뀯뀰뀱뀲뀳뀴뀵뀶뀷뀸뀹뀺뀻뀼뀽뀾뀿끀끁끂끃끄끅끆끇끈끉끊끋끌끍끎끏끐끑끒끓끔끕끖끗끘끙끚끛끜끝끞끟끠끡끢끣끤끥끦끧끨끩끪끫끬끭끮끯끰끱끲끳끴끵끶끷끸끹끺끻끼끽끾끿낀낁낂낃낄낅낆낇낈낉낊낋낌낍낎낏낐낑낒낓낔낕낖낗나낙낚낛난낝낞낟날낡낢낣낤낥낦낧남납낪낫났낭낮낯낰낱낲낳내낵낶낷낸낹낺낻낼낽낾낿냀냁냂냃냄냅냆냇냈냉냊냋냌냍냎냏냐냑냒냓냔냕냖냗냘냙냚냛냜냝냞냟냠냡냢냣냤냥냦냧냨냩냪냫냬냭냮냯냰냱냲냳냴냵냶냷냸냹냺냻냼냽냾냿넀넁넂넃넄넅넆넇너넉넊넋넌넍넎넏널넑넒넓넔넕넖넗넘넙넚넛넜넝넞넟넠넡넢넣네넥넦넧넨넩넪넫넬넭넮넯넰넱넲넳넴넵넶넷넸넹넺넻넼넽넾넿녀녁녂녃년녅녆녇녈녉녊녋녌녍녎녏념녑녒녓녔녕녖녗녘녙녚녛녜녝녞녟녠녡녢녣녤녥녦녧녨녩녪녫녬녭녮녯녰녱녲녳녴녵녶녷노녹녺녻논녽녾녿놀놁놂놃놄놅놆놇놈놉놊놋놌농놎놏놐놑높놓놔놕놖놗놘놙놚놛놜놝놞놟놠놡놢놣놤놥놦놧놨놩놪놫놬놭놮놯놰놱놲놳놴놵놶놷놸놹놺놻놼놽놾놿뇀뇁뇂뇃뇄뇅뇆뇇뇈뇉뇊뇋뇌뇍뇎뇏뇐뇑뇒뇓뇔뇕뇖뇗뇘뇙뇚뇛뇜뇝뇞뇟뇠뇡뇢뇣뇤뇥뇦뇧뇨뇩뇪뇫뇬뇭뇮뇯뇰뇱뇲뇳뇴뇵뇶뇷뇸뇹뇺뇻뇼뇽뇾뇿눀눁눂눃누눅눆눇눈눉눊눋눌눍눎눏눐눑눒눓눔눕눖눗눘눙눚눛눜눝눞눟눠눡눢눣눤눥눦눧눨눩눪눫눬눭눮눯눰눱눲눳눴눵눶눷눸눹눺눻눼눽눾눿뉀뉁뉂뉃뉄뉅뉆뉇뉈뉉뉊뉋뉌뉍뉎뉏뉐뉑뉒뉓뉔뉕뉖뉗뉘뉙뉚뉛뉜뉝뉞뉟뉠뉡뉢뉣뉤뉥뉦뉧뉨뉩뉪뉫뉬뉭뉮뉯뉰뉱뉲뉳뉴뉵뉶뉷뉸뉹뉺뉻뉼뉽뉾뉿늀늁늂늃늄늅늆늇늈늉늊늋늌늍늎늏느늑늒늓는늕늖늗늘늙늚늛늜늝늞늟늠늡늢늣늤능늦늧늨늩늪늫늬늭늮늯늰늱늲늳늴늵늶늷늸늹늺늻늼늽늾늿닀닁닂닃닄닅닆닇니닉닊닋닌닍닎닏닐닑닒닓닔닕닖닗님닙닚닛닜닝닞닟닠닡닢닣다닥닦닧단닩닪닫달닭닮닯닰닱닲닳담답닶닷닸당닺닻닼닽닾닿대댁댂댃댄댅댆댇댈댉댊댋댌댍댎댏댐댑댒댓댔댕댖댗댘댙댚댛댜댝댞댟댠댡댢댣댤댥댦댧댨댩댪댫댬댭댮댯댰댱댲댳댴댵댶댷댸댹댺댻댼댽댾댿덀덁덂덃덄덅덆덇덈덉덊덋덌덍덎덏덐덑덒덓더덕덖덗던덙덚덛덜덝덞덟덠덡덢덣덤덥덦덧덨덩덪덫덬덭덮덯데덱덲덳덴덵덶덷델덹덺덻덼덽덾덿뎀뎁뎂뎃뎄뎅뎆뎇뎈뎉뎊뎋뎌뎍뎎뎏뎐뎑뎒뎓뎔뎕뎖뎗뎘뎙뎚뎛뎜뎝뎞뎟뎠뎡뎢뎣뎤뎥뎦뎧뎨뎩뎪뎫뎬뎭뎮뎯뎰뎱뎲뎳뎴뎵뎶뎷뎸뎹뎺뎻뎼뎽뎾뎿돀돁돂돃도독돆돇돈돉돊돋돌돍돎돏돐돑"


	composition_map_first_integer_3: STRING = "도도도도도도도도도도도도도도ᄃ돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠돠ᄃ돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼돼ᄃ되되되되되되되되되되되되되되되되되되되되되되되되되되되ᄃ됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴됴ᄃ두두두두두두두두두두두두두두두두두두두두두두두두두두두ᄃ둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬둬ᄃ뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈뒈ᄃ뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤뒤ᄃ듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀듀ᄃ드드드드드드드드드드드드드드드드드드드드드드드드드드드ᄃ듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸듸ᄃ디디디디디디디디디디디디디디디디디디디디디디디디디디디ᄄ따따따따따따따따따따따따따따따따따따따따따따따따따따따ᄄ때때때때때때때때때때때때때때때때때때때때때때때때때때때ᄄ땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨땨ᄄ떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄떄ᄄ떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠떠ᄄ떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼떼ᄄ뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘뗘ᄄ뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴뗴ᄄ또또또또또또또또또또또또또또또또또또또또또또또또또또또ᄄ똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬똬ᄄ뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈뙈ᄄ뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤뙤ᄄ뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀뚀ᄄ뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜뚜ᄄ뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸뚸ᄄ뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔뛔ᄄ뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰뛰ᄄ뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌뜌ᄄ뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨뜨ᄄ띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄띄ᄄ띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠띠ᄅ라라라라라라라라라라라라라라라라라라라라라라라라라라라ᄅ래래래래래래래래래래래래래래래래래래래래래래래래래래래ᄅ랴랴랴랴랴랴"


	composition_map_second_integer_3: STRING = "ᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭ"


	composition_map_third_integer_3: STRING = "돒돓돔돕돖돗돘동돚돛돜돝돞돟돠돡돢돣돤돥돦돧돨돩돪돫돬돭돮돯돰돱돲돳돴돵돶돷돸돹돺돻돼돽돾돿됀됁됂됃됄됅됆됇됈됉됊됋됌됍됎됏됐됑됒됓됔됕됖됗되됙됚됛된됝됞됟될됡됢됣됤됥됦됧됨됩됪됫됬됭됮됯됰됱됲됳됴됵됶됷됸됹됺됻됼됽됾됿둀둁둂둃둄둅둆둇둈둉둊둋둌둍둎둏두둑둒둓둔둕둖둗둘둙둚둛둜둝둞둟둠둡둢둣둤둥둦둧둨둩둪둫둬둭둮둯둰둱둲둳둴둵둶둷둸둹둺둻둼둽둾둿뒀뒁뒂뒃뒄뒅뒆뒇뒈뒉뒊뒋뒌뒍뒎뒏뒐뒑뒒뒓뒔뒕뒖뒗뒘뒙뒚뒛뒜뒝뒞뒟뒠뒡뒢뒣뒤뒥뒦뒧뒨뒩뒪뒫뒬뒭뒮뒯뒰뒱뒲뒳뒴뒵뒶뒷뒸뒹뒺뒻뒼뒽뒾뒿듀듁듂듃듄듅듆듇듈듉듊듋듌듍듎듏듐듑듒듓듔듕듖듗듘듙듚듛드득듞듟든듡듢듣들듥듦듧듨듩듪듫듬듭듮듯듰등듲듳듴듵듶듷듸듹듺듻듼듽듾듿딀딁딂딃딄딅딆딇딈딉딊딋딌딍딎딏딐딑딒딓디딕딖딗딘딙딚딛딜딝딞딟딠딡딢딣딤딥딦딧딨딩딪딫딬딭딮딯따딱딲딳딴딵딶딷딸딹딺딻딼딽딾딿땀땁땂땃땄땅땆땇땈땉땊땋때땍땎땏땐땑땒땓땔땕땖땗땘땙땚땛땜땝땞땟땠땡땢땣땤땥땦땧땨땩땪땫땬땭땮땯땰땱땲땳땴땵땶땷땸땹땺땻땼땽땾땿떀떁떂떃떄떅떆떇떈떉떊떋떌떍떎떏떐떑떒떓떔떕떖떗떘떙떚떛떜떝떞떟떠떡떢떣떤떥떦떧떨떩떪떫떬떭떮떯떰떱떲떳떴떵떶떷떸떹떺떻떼떽떾떿뗀뗁뗂뗃뗄뗅뗆뗇뗈뗉뗊뗋뗌뗍뗎뗏뗐뗑뗒뗓뗔뗕뗖뗗뗘뗙뗚뗛뗜뗝뗞뗟뗠뗡뗢뗣뗤뗥뗦뗧뗨뗩뗪뗫뗬뗭뗮뗯뗰뗱뗲뗳뗴뗵뗶뗷뗸뗹뗺뗻뗼뗽뗾뗿똀똁똂똃똄똅똆똇똈똉똊똋똌똍똎똏또똑똒똓똔똕똖똗똘똙똚똛똜똝똞똟똠똡똢똣똤똥똦똧똨똩똪똫똬똭똮똯똰똱똲똳똴똵똶똷똸똹똺똻똼똽똾똿뙀뙁뙂뙃뙄뙅뙆뙇뙈뙉뙊뙋뙌뙍뙎뙏뙐뙑뙒뙓뙔뙕뙖뙗뙘뙙뙚뙛뙜뙝뙞뙟뙠뙡뙢뙣뙤뙥뙦뙧뙨뙩뙪뙫뙬뙭뙮뙯뙰뙱뙲뙳뙴뙵뙶뙷뙸뙹뙺뙻뙼뙽뙾뙿뚀뚁뚂뚃뚄뚅뚆뚇뚈뚉뚊뚋뚌뚍뚎뚏뚐뚑뚒뚓뚔뚕뚖뚗뚘뚙뚚뚛뚜뚝뚞뚟뚠뚡뚢뚣뚤뚥뚦뚧뚨뚩뚪뚫뚬뚭뚮뚯뚰뚱뚲뚳뚴뚵뚶뚷뚸뚹뚺뚻뚼뚽뚾뚿뛀뛁뛂뛃뛄뛅뛆뛇뛈뛉뛊뛋뛌뛍뛎뛏뛐뛑뛒뛓뛔뛕뛖뛗뛘뛙뛚뛛뛜뛝뛞뛟뛠뛡뛢뛣뛤뛥뛦뛧뛨뛩뛪뛫뛬뛭뛮뛯뛰뛱뛲뛳뛴뛵뛶뛷뛸뛹뛺뛻뛼뛽뛾뛿뜀뜁뜂뜃뜄뜅뜆뜇뜈뜉뜊뜋뜌뜍뜎뜏뜐뜑뜒뜓뜔뜕뜖뜗뜘뜙뜚뜛뜜뜝뜞뜟뜠뜡뜢뜣뜤뜥뜦뜧뜨뜩뜪뜫뜬뜭뜮뜯뜰뜱뜲뜳뜴뜵뜶뜷뜸뜹뜺뜻뜼뜽뜾뜿띀띁띂띃띄띅띆띇띈띉띊띋띌띍띎띏띐띑띒띓띔띕띖띗띘띙띚띛띜띝띞띟띠띡띢띣띤띥띦띧띨띩띪띫띬띭띮띯띰띱띲띳띴띵띶띷띸띹띺띻라락띾띿란랁랂랃랄랅랆랇랈랉랊랋람랍랎랏랐랑랒랓랔랕랖랗래랙랚랛랜랝랞랟랠랡랢랣랤랥랦랧램랩랪랫랬랭랮랯랰랱랲랳랴략랶랷랸랹랺"


	composition_map_first_integer_4: STRING = "랴랴랴랴랴랴랴랴랴랴랴랴랴랴랴랴랴랴랴랴랴ᄅ럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐럐ᄅ러러러러러러러러러러러러러러러러러러러러러러러러러러러ᄅ레레레레레레레레레레레레레레레레레레레레레레레레레레레ᄅ려려려려려려려려려려려려려려려려려려려려려려려려려려려ᄅ례례례례례례례례례례례례례례례례례례례례례례례례례례례ᄅ로로로로로로로로로로로로로로로로로로로로로로로로로로로ᄅ롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸롸ᄅ뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔뢔ᄅ뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰뢰ᄅ료료료료료료료료료료료료료료료료료료료료료료료료료료료ᄅ루루루루루루루루루루루루루루루루루루루루루루루루루루루ᄅ뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄뤄ᄅ뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠뤠ᄅ뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼뤼ᄅ류류류류류류류류류류류류류류류류류류류류류류류류류류류ᄅ르르르르르르르르르르르르르르르르르르르르르르르르르르르ᄅ릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐릐ᄅ리리리리리리리리리리리리리리리리리리리리리리리리리리리ᄆ마마마마마마마마마마마마마마마마마마마마마마마마마마마ᄆ매매매매매매매매매매매매매매매매매매매매매매매매매매매ᄆ먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀먀ᄆ먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜먜ᄆ머머머머머머머머머머머머머머머머머머머머머머머머머머머ᄆ메메메메메메메메메메메메메메메메메메메메메메메메메메메ᄆ며며며며며며며며며며며며며며며며며며며며며며며며며며며ᄆ몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌몌ᄆ모모모모모모모모모모모모모모모모모모모모모모모모모모모ᄆ뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄뫄ᄆ뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠뫠ᄆ뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼뫼ᄆ묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘묘ᄆ무무무무무무무무무무무무무무무무무무무무무무무무무무무ᄆ뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐뭐ᄆ뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬뭬ᄆ뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈뮈"


	composition_map_second_integer_4: STRING = "ᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂ"


	composition_map_third_integer_4: STRING = "랻랼랽랾랿럀럁럂럃럄럅럆럇럈량럊럋럌럍럎럏럐럑럒럓럔럕럖럗럘럙럚럛럜럝럞럟럠럡럢럣럤럥럦럧럨럩럪럫러럭럮럯런럱럲럳럴럵럶럷럸럹럺럻럼럽럾럿렀렁렂렃렄렅렆렇레렉렊렋렌렍렎렏렐렑렒렓렔렕렖렗렘렙렚렛렜렝렞렟렠렡렢렣려력렦렧련렩렪렫렬렭렮렯렰렱렲렳렴렵렶렷렸령렺렻렼렽렾렿례롁롂롃롄롅롆롇롈롉롊롋롌롍롎롏롐롑롒롓롔롕롖롗롘롙롚롛로록롞롟론롡롢롣롤롥롦롧롨롩롪롫롬롭롮롯롰롱롲롳롴롵롶롷롸롹롺롻롼롽롾롿뢀뢁뢂뢃뢄뢅뢆뢇뢈뢉뢊뢋뢌뢍뢎뢏뢐뢑뢒뢓뢔뢕뢖뢗뢘뢙뢚뢛뢜뢝뢞뢟뢠뢡뢢뢣뢤뢥뢦뢧뢨뢩뢪뢫뢬뢭뢮뢯뢰뢱뢲뢳뢴뢵뢶뢷뢸뢹뢺뢻뢼뢽뢾뢿룀룁룂룃룄룅룆룇룈룉룊룋료룍룎룏룐룑룒룓룔룕룖룗룘룙룚룛룜룝룞룟룠룡룢룣룤룥룦룧루룩룪룫룬룭룮룯룰룱룲룳룴룵룶룷룸룹룺룻룼룽룾룿뤀뤁뤂뤃뤄뤅뤆뤇뤈뤉뤊뤋뤌뤍뤎뤏뤐뤑뤒뤓뤔뤕뤖뤗뤘뤙뤚뤛뤜뤝뤞뤟뤠뤡뤢뤣뤤뤥뤦뤧뤨뤩뤪뤫뤬뤭뤮뤯뤰뤱뤲뤳뤴뤵뤶뤷뤸뤹뤺뤻뤼뤽뤾뤿륀륁륂륃륄륅륆륇륈륉륊륋륌륍륎륏륐륑륒륓륔륕륖륗류륙륚륛륜륝륞륟률륡륢륣륤륥륦륧륨륩륪륫륬륭륮륯륰륱륲륳르륵륶륷른륹륺륻를륽륾륿릀릁릂릃름릅릆릇릈릉릊릋릌릍릎릏릐릑릒릓릔릕릖릗릘릙릚릛릜릝릞릟릠릡릢릣릤릥릦릧릨릩릪릫리릭릮릯린릱릲릳릴릵릶릷릸릹릺릻림립릾릿맀링맂맃맄맅맆맇마막맊맋만맍많맏말맑맒맓맔맕맖맗맘맙맚맛맜망맞맟맠맡맢맣매맥맦맧맨맩맪맫맬맭맮맯맰맱맲맳맴맵맶맷맸맹맺맻맼맽맾맿먀먁먂먃먄먅먆먇먈먉먊먋먌먍먎먏먐먑먒먓먔먕먖먗먘먙먚먛먜먝먞먟먠먡먢먣먤먥먦먧먨먩먪먫먬먭먮먯먰먱먲먳먴먵먶먷머먹먺먻먼먽먾먿멀멁멂멃멄멅멆멇멈멉멊멋멌멍멎멏멐멑멒멓메멕멖멗멘멙멚멛멜멝멞멟멠멡멢멣멤멥멦멧멨멩멪멫멬멭멮멯며멱멲멳면멵멶멷멸멹멺멻멼멽멾멿몀몁몂몃몄명몆몇몈몉몊몋몌몍몎몏몐몑몒몓몔몕몖몗몘몙몚몛몜몝몞몟몠몡몢몣몤몥몦몧모목몪몫몬몭몮몯몰몱몲몳몴몵몶몷몸몹몺못몼몽몾몿뫀뫁뫂뫃뫄뫅뫆뫇뫈뫉뫊뫋뫌뫍뫎뫏뫐뫑뫒뫓뫔뫕뫖뫗뫘뫙뫚뫛뫜뫝뫞뫟뫠뫡뫢뫣뫤뫥뫦뫧뫨뫩뫪뫫뫬뫭뫮뫯뫰뫱뫲뫳뫴뫵뫶뫷뫸뫹뫺뫻뫼뫽뫾뫿묀묁묂묃묄묅묆묇묈묉묊묋묌묍묎묏묐묑묒묓묔묕묖묗묘묙묚묛묜묝묞묟묠묡묢묣묤묥묦묧묨묩묪묫묬묭묮묯묰묱묲묳무묵묶묷문묹묺묻물묽묾묿뭀뭁뭂뭃뭄뭅뭆뭇뭈뭉뭊뭋뭌뭍뭎뭏뭐뭑뭒뭓뭔뭕뭖뭗뭘뭙뭚뭛뭜뭝뭞뭟뭠뭡뭢뭣뭤뭥뭦뭧뭨뭩뭪뭫뭬뭭뭮뭯뭰뭱뭲뭳뭴뭵뭶뭷뭸뭹뭺뭻뭼뭽뭾뭿뮀뮁뮂뮃뮄뮅뮆뮇뮈뮉뮊뮋뮌뮍뮎뮏뮐뮑뮒뮓뮔뮕뮖뮗뮘뮙뮚뮛뮜뮝뮞뮟뮠뮡뮢뮣"


	composition_map_first_integer_5: STRING = "ᄆ뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤뮤ᄆ므므므므므므므므므므므므므므므므므므므므므므므므므므므ᄆ믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜믜ᄆ미미미미미미미미미미미미미미미미미미미미미미미미미미미ᄇ바바바바바바바바바바바바바바바바바바바바바바바바바바바ᄇ배배배배배배배배배배배배배배배배배배배배배배배배배배배ᄇ뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌뱌ᄇ뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨뱨ᄇ버버버버버버버버버버버버버버버버버버버버버버버버버버버ᄇ베베베베베베베베베베베베베베베베베베베베베베베베베베베ᄇ벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼벼ᄇ볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘볘ᄇ보보보보보보보보보보보보보보보보보보보보보보보보보보보ᄇ봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐봐ᄇ봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬봬ᄇ뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈뵈ᄇ뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤뵤ᄇ부부부부부부부부부부부부부부부부부부부부부부부부부부부ᄇ붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜붜ᄇ붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸붸ᄇ뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔뷔ᄇ뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰뷰ᄇ브브브브브브브브브브브브브브브브브브브브브브브브브브브ᄇ븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨븨ᄇ비비비비비비비비비비비비비비비비비비비비비비비비비비비ᄈ빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠빠ᄈ빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼빼ᄈ뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘뺘ᄈ뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴뺴ᄈ뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐뻐ᄈ뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬뻬ᄈ뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈뼈ᄈ뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤뼤ᄈ뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀뽀ᄈ뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜뽜ᄈ뽸뽸뽸뽸뽸뽸뽸뽸뽸뽸뽸뽸뽸뽸뽸뽸뽸뽸뽸뽸"


	composition_map_second_integer_5: STRING = "ᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻ"


	composition_map_third_integer_5: STRING = "뮤뮥뮦뮧뮨뮩뮪뮫뮬뮭뮮뮯뮰뮱뮲뮳뮴뮵뮶뮷뮸뮹뮺뮻뮼뮽뮾뮿므믁믂믃믄믅믆믇믈믉믊믋믌믍믎믏믐믑믒믓믔믕믖믗믘믙믚믛믜믝믞믟믠믡믢믣믤믥믦믧믨믩믪믫믬믭믮믯믰믱믲믳믴믵믶믷미믹믺믻민믽믾믿밀밁밂밃밄밅밆밇밈밉밊밋밌밍밎및밐밑밒밓바박밖밗반밙밚받발밝밞밟밠밡밢밣밤밥밦밧밨방밪밫밬밭밮밯배백밲밳밴밵밶밷밸밹밺밻밼밽밾밿뱀뱁뱂뱃뱄뱅뱆뱇뱈뱉뱊뱋뱌뱍뱎뱏뱐뱑뱒뱓뱔뱕뱖뱗뱘뱙뱚뱛뱜뱝뱞뱟뱠뱡뱢뱣뱤뱥뱦뱧뱨뱩뱪뱫뱬뱭뱮뱯뱰뱱뱲뱳뱴뱵뱶뱷뱸뱹뱺뱻뱼뱽뱾뱿벀벁벂벃버벅벆벇번벉벊벋벌벍벎벏벐벑벒벓범법벖벗벘벙벚벛벜벝벞벟베벡벢벣벤벥벦벧벨벩벪벫벬벭벮벯벰벱벲벳벴벵벶벷벸벹벺벻벼벽벾벿변볁볂볃별볅볆볇볈볉볊볋볌볍볎볏볐병볒볓볔볕볖볗볘볙볚볛볜볝볞볟볠볡볢볣볤볥볦볧볨볩볪볫볬볭볮볯볰볱볲볳보복볶볷본볹볺볻볼볽볾볿봀봁봂봃봄봅봆봇봈봉봊봋봌봍봎봏봐봑봒봓봔봕봖봗봘봙봚봛봜봝봞봟봠봡봢봣봤봥봦봧봨봩봪봫봬봭봮봯봰봱봲봳봴봵봶봷봸봹봺봻봼봽봾봿뵀뵁뵂뵃뵄뵅뵆뵇뵈뵉뵊뵋뵌뵍뵎뵏뵐뵑뵒뵓뵔뵕뵖뵗뵘뵙뵚뵛뵜뵝뵞뵟뵠뵡뵢뵣뵤뵥뵦뵧뵨뵩뵪뵫뵬뵭뵮뵯뵰뵱뵲뵳뵴뵵뵶뵷뵸뵹뵺뵻뵼뵽뵾뵿부북붂붃분붅붆붇불붉붊붋붌붍붎붏붐붑붒붓붔붕붖붗붘붙붚붛붜붝붞붟붠붡붢붣붤붥붦붧붨붩붪붫붬붭붮붯붰붱붲붳붴붵붶붷붸붹붺붻붼붽붾붿뷀뷁뷂뷃뷄뷅뷆뷇뷈뷉뷊뷋뷌뷍뷎뷏뷐뷑뷒뷓뷔뷕뷖뷗뷘뷙뷚뷛뷜뷝뷞뷟뷠뷡뷢뷣뷤뷥뷦뷧뷨뷩뷪뷫뷬뷭뷮뷯뷰뷱뷲뷳뷴뷵뷶뷷뷸뷹뷺뷻뷼뷽뷾뷿븀븁븂븃븄븅븆븇븈븉븊븋브븍븎븏븐븑븒븓블븕븖븗븘븙븚븛븜븝븞븟븠븡븢븣븤븥븦븧븨븩븪븫븬븭븮븯븰븱븲븳븴븵븶븷븸븹븺븻븼븽븾븿빀빁빂빃비빅빆빇빈빉빊빋빌빍빎빏빐빑빒빓빔빕빖빗빘빙빚빛빜빝빞빟빠빡빢빣빤빥빦빧빨빩빪빫빬빭빮빯빰빱빲빳빴빵빶빷빸빹빺빻빼빽빾빿뺀뺁뺂뺃뺄뺅뺆뺇뺈뺉뺊뺋뺌뺍뺎뺏뺐뺑뺒뺓뺔뺕뺖뺗뺘뺙뺚뺛뺜뺝뺞뺟뺠뺡뺢뺣뺤뺥뺦뺧뺨뺩뺪뺫뺬뺭뺮뺯뺰뺱뺲뺳뺴뺵뺶뺷뺸뺹뺺뺻뺼뺽뺾뺿뻀뻁뻂뻃뻄뻅뻆뻇뻈뻉뻊뻋뻌뻍뻎뻏뻐뻑뻒뻓뻔뻕뻖뻗뻘뻙뻚뻛뻜뻝뻞뻟뻠뻡뻢뻣뻤뻥뻦뻧뻨뻩뻪뻫뻬뻭뻮뻯뻰뻱뻲뻳뻴뻵뻶뻷뻸뻹뻺뻻뻼뻽뻾뻿뼀뼁뼂뼃뼄뼅뼆뼇뼈뼉뼊뼋뼌뼍뼎뼏뼐뼑뼒뼓뼔뼕뼖뼗뼘뼙뼚뼛뼜뼝뼞뼟뼠뼡뼢뼣뼤뼥뼦뼧뼨뼩뼪뼫뼬뼭뼮뼯뼰뼱뼲뼳뼴뼵뼶뼷뼸뼹뼺뼻뼼뼽뼾뼿뽀뽁뽂뽃뽄뽅뽆뽇뽈뽉뽊뽋뽌뽍뽎뽏뽐뽑뽒뽓뽔뽕뽖뽗뽘뽙뽚뽛뽜뽝뽞뽟뽠뽡뽢뽣뽤뽥뽦뽧뽨뽩뽪뽫뽬뽭뽮뽯뽰뽱뽲뽳뽴뽵뽶뽷뽸뽹뽺뽻뽼뽽뽾뽿뾀뾁뾂뾃뾄뾅뾆뾇뾈뾉뾊뾋뾌"


	composition_map_first_integer_6: STRING = "뽸뽸뽸뽸뽸뽸뽸ᄈ뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔뾔ᄈ뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰뾰ᄈ뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌뿌ᄈ뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨뿨ᄈ쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄쀄ᄈ쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠쀠ᄈ쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼쀼ᄈ쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘쁘ᄈ쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴쁴ᄈ삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐삐ᄉ사사사사사사사사사사사사사사사사사사사사사사사사사사사ᄉ새새새새새새새새새새새새새새새새새새새새새새새새새새새ᄉ샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤샤ᄉ섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀섀ᄉ서서서서서서서서서서서서서서서서서서서서서서서서서서서ᄉ세세세세세세세세세세세세세세세세세세세세세세세세세세세ᄉ셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔셔ᄉ셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰셰ᄉ소소소소소소소소소소소소소소소소소소소소소소소소소소소ᄉ솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨솨ᄉ쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄쇄ᄉ쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠쇠ᄉ쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼쇼ᄉ수수수수수수수수수수수수수수수수수수수수수수수수수수수ᄉ숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴숴ᄉ쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐쉐ᄉ쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬쉬ᄉ슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈슈ᄉ스스스스스스스스스스스스스스스스스스스스스스스스스스스ᄉ싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀싀ᄉ시시시시시시시시시시시시시시시시시시시시시시시시시시시ᄊ싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸싸ᄊ쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔쌔ᄊ쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰쌰ᄊ썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌썌ᄊ써써써써써써써써써써써써써"


	composition_map_second_integer_6: STRING = "ᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴ"


	composition_map_third_integer_6: STRING = "뾍뾎뾏뾐뾑뾒뾓뾔뾕뾖뾗뾘뾙뾚뾛뾜뾝뾞뾟뾠뾡뾢뾣뾤뾥뾦뾧뾨뾩뾪뾫뾬뾭뾮뾯뾰뾱뾲뾳뾴뾵뾶뾷뾸뾹뾺뾻뾼뾽뾾뾿뿀뿁뿂뿃뿄뿅뿆뿇뿈뿉뿊뿋뿌뿍뿎뿏뿐뿑뿒뿓뿔뿕뿖뿗뿘뿙뿚뿛뿜뿝뿞뿟뿠뿡뿢뿣뿤뿥뿦뿧뿨뿩뿪뿫뿬뿭뿮뿯뿰뿱뿲뿳뿴뿵뿶뿷뿸뿹뿺뿻뿼뿽뿾뿿쀀쀁쀂쀃쀄쀅쀆쀇쀈쀉쀊쀋쀌쀍쀎쀏쀐쀑쀒쀓쀔쀕쀖쀗쀘쀙쀚쀛쀜쀝쀞쀟쀠쀡쀢쀣쀤쀥쀦쀧쀨쀩쀪쀫쀬쀭쀮쀯쀰쀱쀲쀳쀴쀵쀶쀷쀸쀹쀺쀻쀼쀽쀾쀿쁀쁁쁂쁃쁄쁅쁆쁇쁈쁉쁊쁋쁌쁍쁎쁏쁐쁑쁒쁓쁔쁕쁖쁗쁘쁙쁚쁛쁜쁝쁞쁟쁠쁡쁢쁣쁤쁥쁦쁧쁨쁩쁪쁫쁬쁭쁮쁯쁰쁱쁲쁳쁴쁵쁶쁷쁸쁹쁺쁻쁼쁽쁾쁿삀삁삂삃삄삅삆삇삈삉삊삋삌삍삎삏삐삑삒삓삔삕삖삗삘삙삚삛삜삝삞삟삠삡삢삣삤삥삦삧삨삩삪삫사삭삮삯산삱삲삳살삵삶삷삸삹삺삻삼삽삾삿샀상샂샃샄샅샆샇새색샊샋샌샍샎샏샐샑샒샓샔샕샖샗샘샙샚샛샜생샞샟샠샡샢샣샤샥샦샧샨샩샪샫샬샭샮샯샰샱샲샳샴샵샶샷샸샹샺샻샼샽샾샿섀섁섂섃섄섅섆섇섈섉섊섋섌섍섎섏섐섑섒섓섔섕섖섗섘섙섚섛서석섞섟선섡섢섣설섥섦섧섨섩섪섫섬섭섮섯섰성섲섳섴섵섶섷세섹섺섻센섽섾섿셀셁셂셃셄셅셆셇셈셉셊셋셌셍셎셏셐셑셒셓셔셕셖셗션셙셚셛셜셝셞셟셠셡셢셣셤셥셦셧셨셩셪셫셬셭셮셯셰셱셲셳셴셵셶셷셸셹셺셻셼셽셾셿솀솁솂솃솄솅솆솇솈솉솊솋소속솎솏손솑솒솓솔솕솖솗솘솙솚솛솜솝솞솟솠송솢솣솤솥솦솧솨솩솪솫솬솭솮솯솰솱솲솳솴솵솶솷솸솹솺솻솼솽솾솿쇀쇁쇂쇃쇄쇅쇆쇇쇈쇉쇊쇋쇌쇍쇎쇏쇐쇑쇒쇓쇔쇕쇖쇗쇘쇙쇚쇛쇜쇝쇞쇟쇠쇡쇢쇣쇤쇥쇦쇧쇨쇩쇪쇫쇬쇭쇮쇯쇰쇱쇲쇳쇴쇵쇶쇷쇸쇹쇺쇻쇼쇽쇾쇿숀숁숂숃숄숅숆숇숈숉숊숋숌숍숎숏숐숑숒숓숔숕숖숗수숙숚숛순숝숞숟술숡숢숣숤숥숦숧숨숩숪숫숬숭숮숯숰숱숲숳숴숵숶숷숸숹숺숻숼숽숾숿쉀쉁쉂쉃쉄쉅쉆쉇쉈쉉쉊쉋쉌쉍쉎쉏쉐쉑쉒쉓쉔쉕쉖쉗쉘쉙쉚쉛쉜쉝쉞쉟쉠쉡쉢쉣쉤쉥쉦쉧쉨쉩쉪쉫쉬쉭쉮쉯쉰쉱쉲쉳쉴쉵쉶쉷쉸쉹쉺쉻쉼쉽쉾쉿슀슁슂슃슄슅슆슇슈슉슊슋슌슍슎슏슐슑슒슓슔슕슖슗슘슙슚슛슜슝슞슟슠슡슢슣스슥슦슧슨슩슪슫슬슭슮슯슰슱슲슳슴습슶슷슸승슺슻슼슽슾슿싀싁싂싃싄싅싆싇싈싉싊싋싌싍싎싏싐싑싒싓싔싕싖싗싘싙싚싛시식싞싟신싡싢싣실싥싦싧싨싩싪싫심십싮싯싰싱싲싳싴싵싶싷싸싹싺싻싼싽싾싿쌀쌁쌂쌃쌄쌅쌆쌇쌈쌉쌊쌋쌌쌍쌎쌏쌐쌑쌒쌓쌔쌕쌖쌗쌘쌙쌚쌛쌜쌝쌞쌟쌠쌡쌢쌣쌤쌥쌦쌧쌨쌩쌪쌫쌬쌭쌮쌯쌰쌱쌲쌳쌴쌵쌶쌷쌸쌹쌺쌻쌼쌽쌾쌿썀썁썂썃썄썅썆썇썈썉썊썋썌썍썎썏썐썑썒썓썔썕썖썗썘썙썚썛썜썝썞썟썠썡썢썣썤썥썦썧써썩썪썫썬썭썮썯썰썱썲썳썴썵"


	composition_map_first_integer_7: STRING = "써써써써써써써써써써써써써써ᄊ쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄쎄ᄊ쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠쎠ᄊ쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼쎼ᄊ쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘쏘ᄊ쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴쏴ᄊ쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐쐐ᄊ쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬쐬ᄊ쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈쑈ᄊ쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤쑤ᄊ쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀쒀ᄊ쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜쒜ᄊ쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸쒸ᄊ쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔쓔ᄊ쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰쓰ᄊ씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌씌ᄊ씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨씨ᄋ아아아아아아아아아아아아아아아아아아아아아아아아아아아ᄋ애애애애애애애애애애애애애애애애애애애애애애애애애애애ᄋ야야야야야야야야야야야야야야야야야야야야야야야야야야야ᄋ얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘얘ᄋ어어어어어어어어어어어어어어어어어어어어어어어어어어어ᄋ에에에에에에에에에에에에에에에에에에에에에에에에에에에ᄋ여여여여여여여여여여여여여여여여여여여여여여여여여여여ᄋ예예예예예예예예예예예예예예예예예예예예예예예예예예예ᄋ오오오오오오오오오오오오오오오오오오오오오오오오오오오ᄋ와와와와와와와와와와와와와와와와와와와와와와와와와와와ᄋ왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜왜ᄋ외외외외외외외외외외외외외외외외외외외외외외외외외외외ᄋ요요요요요요요요요요요요요요요요요요요요요요요요요요요ᄋ우우우우우우우우우우우우우우우우우우우우우우우우우우우ᄋ워워워워워워워워워워워워워워워워워워워워워워워워워워워ᄋ웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨웨ᄋ위위위위위위위위위위위위위위위위위위위위위위위위위위위ᄋ유유유유유유유유유유유유유유유유유유유유유유유유유유유ᄋ으으으으으으으으으으으으으으으으으으으으으으으으으으으ᄋ의의의의의의"


	composition_map_second_integer_7: STRING = "ᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅬᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅭᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅮᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅯᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅰᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅱᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅲᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅳᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅴᆨᆩᆪᆫᆬᆭ"


	composition_map_third_integer_7: STRING = "썶썷썸썹썺썻썼썽썾썿쎀쎁쎂쎃쎄쎅쎆쎇쎈쎉쎊쎋쎌쎍쎎쎏쎐쎑쎒쎓쎔쎕쎖쎗쎘쎙쎚쎛쎜쎝쎞쎟쎠쎡쎢쎣쎤쎥쎦쎧쎨쎩쎪쎫쎬쎭쎮쎯쎰쎱쎲쎳쎴쎵쎶쎷쎸쎹쎺쎻쎼쎽쎾쎿쏀쏁쏂쏃쏄쏅쏆쏇쏈쏉쏊쏋쏌쏍쏎쏏쏐쏑쏒쏓쏔쏕쏖쏗쏘쏙쏚쏛쏜쏝쏞쏟쏠쏡쏢쏣쏤쏥쏦쏧쏨쏩쏪쏫쏬쏭쏮쏯쏰쏱쏲쏳쏴쏵쏶쏷쏸쏹쏺쏻쏼쏽쏾쏿쐀쐁쐂쐃쐄쐅쐆쐇쐈쐉쐊쐋쐌쐍쐎쐏쐐쐑쐒쐓쐔쐕쐖쐗쐘쐙쐚쐛쐜쐝쐞쐟쐠쐡쐢쐣쐤쐥쐦쐧쐨쐩쐪쐫쐬쐭쐮쐯쐰쐱쐲쐳쐴쐵쐶쐷쐸쐹쐺쐻쐼쐽쐾쐿쑀쑁쑂쑃쑄쑅쑆쑇쑈쑉쑊쑋쑌쑍쑎쑏쑐쑑쑒쑓쑔쑕쑖쑗쑘쑙쑚쑛쑜쑝쑞쑟쑠쑡쑢쑣쑤쑥쑦쑧쑨쑩쑪쑫쑬쑭쑮쑯쑰쑱쑲쑳쑴쑵쑶쑷쑸쑹쑺쑻쑼쑽쑾쑿쒀쒁쒂쒃쒄쒅쒆쒇쒈쒉쒊쒋쒌쒍쒎쒏쒐쒑쒒쒓쒔쒕쒖쒗쒘쒙쒚쒛쒜쒝쒞쒟쒠쒡쒢쒣쒤쒥쒦쒧쒨쒩쒪쒫쒬쒭쒮쒯쒰쒱쒲쒳쒴쒵쒶쒷쒸쒹쒺쒻쒼쒽쒾쒿쓀쓁쓂쓃쓄쓅쓆쓇쓈쓉쓊쓋쓌쓍쓎쓏쓐쓑쓒쓓쓔쓕쓖쓗쓘쓙쓚쓛쓜쓝쓞쓟쓠쓡쓢쓣쓤쓥쓦쓧쓨쓩쓪쓫쓬쓭쓮쓯쓰쓱쓲쓳쓴쓵쓶쓷쓸쓹쓺쓻쓼쓽쓾쓿씀씁씂씃씄씅씆씇씈씉씊씋씌씍씎씏씐씑씒씓씔씕씖씗씘씙씚씛씜씝씞씟씠씡씢씣씤씥씦씧씨씩씪씫씬씭씮씯씰씱씲씳씴씵씶씷씸씹씺씻씼씽씾씿앀앁앂앃아악앆앇안앉않앋알앍앎앏앐앑앒앓암압앖앗았앙앚앛앜앝앞앟애액앢앣앤앥앦앧앨앩앪앫앬앭앮앯앰앱앲앳앴앵앶앷앸앹앺앻야약앾앿얀얁얂얃얄얅얆얇얈얉얊얋얌얍얎얏얐양얒얓얔얕얖얗얘얙얚얛얜얝얞얟얠얡얢얣얤얥얦얧얨얩얪얫얬얭얮얯얰얱얲얳어억얶얷언얹얺얻얼얽얾얿엀엁엂엃엄업없엇었엉엊엋엌엍엎엏에엑엒엓엔엕엖엗엘엙엚엛엜엝엞엟엠엡엢엣엤엥엦엧엨엩엪엫여역엮엯연엱엲엳열엵엶엷엸엹엺엻염엽엾엿였영옂옃옄옅옆옇예옉옊옋옌옍옎옏옐옑옒옓옔옕옖옗옘옙옚옛옜옝옞옟옠옡옢옣오옥옦옧온옩옪옫올옭옮옯옰옱옲옳옴옵옶옷옸옹옺옻옼옽옾옿와왁왂왃완왅왆왇왈왉왊왋왌왍왎왏왐왑왒왓왔왕왖왗왘왙왚왛왜왝왞왟왠왡왢왣왤왥왦왧왨왩왪왫왬왭왮왯왰왱왲왳왴왵왶왷외왹왺왻왼왽왾왿욀욁욂욃욄욅욆욇욈욉욊욋욌욍욎욏욐욑욒욓요욕욖욗욘욙욚욛욜욝욞욟욠욡욢욣욤욥욦욧욨용욪욫욬욭욮욯우욱욲욳운욵욶욷울욹욺욻욼욽욾욿움웁웂웃웄웅웆웇웈웉웊웋워웍웎웏원웑웒웓월웕웖웗웘웙웚웛웜웝웞웟웠웡웢웣웤웥웦웧웨웩웪웫웬웭웮웯웰웱웲웳웴웵웶웷웸웹웺웻웼웽웾웿윀윁윂윃위윅윆윇윈윉윊윋윌윍윎윏윐윑윒윓윔윕윖윗윘윙윚윛윜윝윞윟유육윢윣윤윥윦윧율윩윪윫윬윭윮윯윰윱윲윳윴융윶윷윸윹윺윻으윽윾윿은읁읂읃을읅읆읇읈읉읊읋음읍읎읏읐응읒읓읔읕읖읗의읙읚읛읜읝읞"


	composition_map_first_integer_8: STRING = "의의의의의의의의의의의의의의의의의의의의의ᄋ이이이이이이이이이이이이이이이이이이이이이이이이이이이ᄌ자자자자자자자자자자자자자자자자자자자자자자자자자자자ᄌ재재재재재재재재재재재재재재재재재재재재재재재재재재재ᄌ쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈쟈ᄌ쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤쟤ᄌ저저저저저저저저저저저저저저저저저저저저저저저저저저저ᄌ제제제제제제제제제제제제제제제제제제제제제제제제제제제ᄌ져져져져져져져져져져져져져져져져져져져져져져져져져져져ᄌ졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔졔ᄌ조조조조조조조조조조조조조조조조조조조조조조조조조조조ᄌ좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌좌ᄌ좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨좨ᄌ죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄죄ᄌ죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠죠ᄌ주주주주주주주주주주주주주주주주주주주주주주주주주주주ᄌ줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘줘ᄌ줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴줴ᄌ쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐쥐ᄌ쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬쥬ᄌ즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈즈ᄌ즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤즤ᄌ지지지지지지지지지지지지지지지지지지지지지지지지지지지ᄍ짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜짜ᄍ째째째째째째째째째째째째째째째째째째째째째째째째째째째ᄍ쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔쨔ᄍ쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰쨰ᄍ쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌쩌ᄍ쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨쩨ᄍ쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄쪄ᄍ쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠쪠ᄍ쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼쪼ᄍ쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘쫘ᄍ쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴쫴ᄍ쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐쬐ᄍ쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬쬬"


	composition_map_second_integer_8: STRING = "ᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅵᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅡᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅢᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅣᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅤᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅥᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅦᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅧᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅨᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅩᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅪᆨᆩᆪᆫᆬᆭᆮᆯᆰᆱᆲᆳᆴᆵᆶᆷᆸᆹᆺᆻᆼᆽᆾᆿᇀᇁᇂᅫᆨᆩᆪᆫᆬᆭ