note
	description:
		"Eiffel Vision sensitive. Implementation interface."
	legal: "See notice at end of class."
	status: "See notice at end of class."
	keywords: "sensitive, input"
	date: "$Date: 2013-05-20 16:15:17 -0700 (Mon, 20 May 2013) $"
	revision: "$Revision: 92557 $"

deferred class
	EV_SENSITIVE_I

inherit
	EV_ANY_I
		redefine
			interface
		end

feature -- Status report

	user_is_sensitive: BOOLEAN
			-- Is the object sensitive to user input.
		do
			if not has_parent or else parent_is_sensitive then
				Result := is_sensitive
			end
		end

	internal_non_sensitive: BOOLEAN
		-- Is `Current' not sensitive to input as seen
		-- from `interface'?

feature -- Status setting

	user_enable_sensitive
			-- Make object sensitive to user input.
		do
			internal_non_sensitive := False
			enable_sensitive
		ensure
			is_sensitive_if_parent_sensitive:
				(has_parent and then parent_is_sensitive) implies attached_interface.implementation.is_sensitive
			is_sensitive_if_orphaned: not has_parent implies attached_interface.implementation.is_sensitive
		end

	user_disable_sensitive
			-- Make object desensitive to user input.
		do
			internal_non_sensitive := True
			disable_sensitive
		ensure
			is_desensitive: not user_is_sensitive
		end

feature {EV_ANY_I} -- Implementation

	enable_sensitive
			-- Make object sensitive to user input.
		deferred
		end

	disable_sensitive
			-- Make object desensitive to user input.
		deferred
		end

	parent_is_sensitive: BOOLEAN
		deferred
		end

	has_parent: BOOLEAN
		deferred
		end

	is_sensitive: BOOLEAN
			-- Is the object sensitive to user input.
		deferred
		end

feature {EV_ANY, EV_ANY_I} -- Implementation

	interface: detachable EV_SENSITIVE note option: stable attribute end;
			-- Provides a common user interface to platform dependent
			-- functionality implemented by `Current'.

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class EV_SENSITIVE_I









