note
	description: "Summary description for {SSL_ERROR}."
	author: ""
	date: "$Date: 2018-03-23 10:30:37 -0700 (Fri, 23 Mar 2018) $"
	revision: "$Revision: 101557 $"

class
	SSL_ERROR

create
	make

feature {NONE} -- Initialization

	make (a_code:NATURAL_64)
		do
			code := a_code
		end

feature -- Access

	code: NATURAL_64

	error_lib_code: INTEGER
		do
			Result := {SSL_ERROR_EXTERNALS}.c_error_get_lib (code)
		end

	error_function_code: INTEGER
		do
			Result := {SSL_ERROR_EXTERNALS}.c_error_get_func (code)
		end

	error_reason_code: INTEGER
		do
			Result := {SSL_ERROR_EXTERNALS}.c_error_get_reason (code)
		end

	error_lib: STRING
		local
			c_string: C_STRING
			l_pointer: POINTER
		do
			create Result.make_empty
			l_pointer := {SSL_ERROR_EXTERNALS}.c_err_lib_error_string (code)
			if l_pointer /= default_pointer then
				create c_string.make_by_pointer (l_pointer)
				Result.append (c_string.string)
			end
		end

	error_function: STRING
		local
			c_string: C_STRING
			l_pointer: POINTER
		do
			create Result.make_empty
			l_pointer := {SSL_ERROR_EXTERNALS}.c_err_func_error_string (code)
			if l_pointer /= default_pointer then
				create c_string.make_by_pointer (l_pointer)
				Result.append (c_string.string)
			end
		end

	error_reason: STRING
		local
			c_string: C_STRING
			l_pointer: POINTER
		do
			create Result.make_empty
			l_pointer := {SSL_ERROR_EXTERNALS}.c_err_reason_error_string (code)
			if l_pointer /= default_pointer then
				create c_string.make_by_pointer (l_pointer)
				Result.append (c_string.string)
			end
		end

feature -- Status Report

	lib_and_reason_match (a_lib, a_reason: INTEGER): BOOLEAN
			-- Does 'a_lib' match with 'error_lib_code' and
			-- 'a_reason' with 'error_reason_code'?
		do
			Result := a_lib = error_lib_code and then a_reason = error_reason_code
		end

end
