note
	description: "Objects to synthesize keystrokes, mouse motions %
				  %and button clicks."
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2013-11-19 17:34:28 -0800 (Tue, 19 Nov 2013) $"
	revision: "$Revision: 93466 $"

class
	WEL_INPUT_EVENT

inherit
	ANY

	WEL_INPUT_CONSTANTS
		export
			{NONE} all
		end

feature -- Keyboard events

	send_keyboard_key_down (virtual_key_code: INTEGER)
			-- The keybd_event function synthesizes a keystroke. The system
			-- can use such a synthesized keystroke to generate a
			-- WM_KEYDOWN message.
			--
			-- An application can simulate a press of the PRINTSCRN key in
			-- order to obtain a screen snapshot and save it to the
			-- clipboard.
			-- To do this, call `send_keyboard_key_down(Vk_snapshot)'.
			--
			-- Windows NT: The `send_keyboard_key_down' can toggle the
			-- NUM LOCK, CAPS LOCK, and SCROLL LOCK keys.
			--
			-- Windows 95: The `send_keyboard_key_down' function can toggle
			-- only the CAPS LOCK and SCROLL LOCK keys. It cannot toggle
			-- the NUM LOCK key.
		do
			cwin_keybd_event (virtual_key_code, 0, 0, Default_pointer)
		end

	send_keyboard_key_up (virtual_key_code: INTEGER)
			-- The keybd_event function synthesizes a keystroke. The system
			-- can use such a synthesized keystroke to generate a
			-- WM_KEYUP message.
			--
			-- Windows NT: The `send_keyboard_key_down' can toggle the
			-- NUM LOCK, CAPS LOCK, and SCROLL LOCK keys.
			--
			-- Windows 95: The `send_keyboard_key_down' function can toggle
			-- only the CAPS LOCK and SCROLL LOCK keys. It cannot toggle
			-- the NUM LOCK key.
		do
			cwin_keybd_event (virtual_key_code, 0, Keyeventf_keyup, Default_pointer)
		end

feature -- Mouse events

	send_mouse_absolute_move (a_x, a_y: INTEGER)
			-- Synthesize a fake mouse move to absolute
			-- screen position `a_x', `a_y'.
			--
			-- `a_x' and `a_y' contain normalized absolute coordinates
			-- between 0 and 65,535. The event procedure maps these
			-- coordinates onto the display surface. Coordinate (0,0)
			-- maps onto the upper-left corner of the display surface,
			-- (65535,65535) maps onto the lower-right corner.
			--
			-- To determine the size of the screen use
			-- {WEL_SYSTEM_METRICS}.screen_width and
			-- {WEL_SYSTEM_METRICS}.screen_height.
		do
			cwin_mouse_event (
				Mouseeventf_move + Mouseeventf_absolute,
				a_x,
				a_y,
				0,
				Default_pointer
				)
		end

	send_mouse_relative_move (a_x, a_y: INTEGER)
			-- Synthesize a fake mouse move.
			-- `a_x' and `a_y' are the number of mickeys moved.
			--
			-- A mickey is the amount that a mouse has to move
			-- for it to report that it has moved.
		do
			cwin_mouse_event (
				Mouseeventf_move,
				a_x,
				a_y,
				0,
				Default_pointer
				)
		end

	send_mouse_left_button_down
			-- Synthesize a fake press on the left button of the
			-- mouse.
		do
			cwin_mouse_event (Mouseeventf_leftdown, 0, 0, 0, Default_pointer);
		end

	send_mouse_left_button_up
			-- Synthesize a fake press on the left button of the
			-- mouse.
		do
			cwin_mouse_event (Mouseeventf_leftup, 0, 0, 0, Default_pointer);
		end

	send_mouse_right_button_down
			-- Synthesize a fake press on the right button of the
			-- mouse.
		do
			cwin_mouse_event (Mouseeventf_rightdown, 0, 0, 0, Default_pointer);
		end

	send_mouse_right_button_up
			-- Synthesize a fake press on the right button of the
			-- mouse.
		do
			cwin_mouse_event (Mouseeventf_rightup, 0, 0, 0, Default_pointer);
		end

	send_mouse_middle_button_down
			-- Synthesize a fake press on the middle button of the
			-- mouse.
		do
			cwin_mouse_event (Mouseeventf_middledown, 0, 0, 0, Default_pointer);
		end

	send_mouse_middle_button_up
			-- Synthesize a fake press on the middle button of the
			-- mouse.
		do
			cwin_mouse_event (Mouseeventf_middleup, 0, 0, 0, Default_pointer);
		end

	send_mouse_wheel_up
			-- Synthesize a fake mouse wheel rotation forward.
		do
			cwin_mouse_event (Mouseeventf_wheel, 0, 0, Wheel_delta, Default_pointer)
		end

	send_mouse_wheel_down
			-- Synthesize a fake mouse wheel rotation backward.
		do
			cwin_mouse_event (Mouseeventf_wheel, 0, 0, -Wheel_delta, Default_pointer)
		end

feature {NONE} -- External

	cwin_mouse_event (
		dwFlags	: INTEGER -- motion and click options
  		dx		: INTEGER -- horizontal position or change
  		dy		: INTEGER -- vertical position or change
  		dwData	: INTEGER -- wheel movement
  		dwExtraInfo: POINTER -- application-defined information
	)
			-- The mouse_event function synthesizes mouse motion and button
			-- clicks.
		external
			"C [macro %"wel.h%"] (DWORD, DWORD, DWORD, DWORD, ULONG_PTR)"
		alias
			"mouse_event"
		end

	cwin_keybd_event (
		bVk		: INTEGER -- virtual-key code
		bScan	: INTEGER -- hardware scan code
		dwFlags	: INTEGER -- function options
  		dwExtraInfo: POINTER -- application-defined information
	)
			-- The keybd_event function synthesizes a keystroke. The system
			-- can use such a synthesized keystroke to generate a WM_KEYUP or
			-- WM_KEYDOWN message. The keyboard driver's interrupt handler
			-- calls the keybd_event function.
		external
			"C [macro %"wel.h%"] (BYTE, BYTE, DWORD, ULONG_PTR)"
		alias
			"keybd_event"
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class WEL_INPUT_EVENT

