note
	description: "Objects that represent an EV_TITLED_WINDOW.%
		%The original version of this class was generated by EiffelBuild."
	generator: "EiffelBuild"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2017-04-18 06:09:50 -0700 (Tue, 18 Apr 2017) $"
	revision: "$Revision: 100213 $"

class
	MAIN_WINDOW

inherit
	MAIN_WINDOW_IMP

create
	make

feature {NONE} -- Initialization

	make
			-- Creation method.
		do
			create_objects
--			build_initialize

			default_create
		end

	create_objects
			-- Create objects.
		do
			create back_button.make_with_text ("Back")
			create forth_button.make_with_text ("Forth")
			create refresh_button.make_with_text ("Refresh")
			create stop_button.make_with_text ("Stop")
			create url_text_field.make_with_text ("http://www.eiffel.com")
			create go_button.make_with_text ("Go")

			create web_browser
		end
	user_initialization
			-- Called by `initialize'.
			-- Any custom user initialization that
			-- could not be performed in `initialize',
			-- (due to regeneration of implementation class)
			-- can be added here.
		local
			l_vertical_box: EV_VERTICAL_BOX
			l_hor_box: EV_HORIZONTAL_BOX
		do
			set_size (800, 600)

			create l_vertical_box
			extend (l_vertical_box)

			create l_hor_box
			l_vertical_box.extend (l_hor_box)
			l_vertical_box.disable_item_expand (l_hor_box)

			back_button.select_actions.extend (agent on_back_button_action)
			l_hor_box.extend (back_button)
			l_hor_box.disable_item_expand (back_button)

			forth_button.select_actions.extend (agent on_forth_button_action)
			l_hor_box.extend (forth_button)
			l_hor_box.disable_item_expand (forth_button)

			refresh_button.select_actions.extend (agent on_refresh_button_action)
			l_hor_box.extend (refresh_button)
			l_hor_box.disable_item_expand (refresh_button)

			stop_button.select_actions.extend (agent on_stop_button_action)
			l_hor_box.extend (stop_button)
			l_hor_box.disable_item_expand (stop_button)

			l_hor_box.extend (url_text_field)

			go_button.select_actions.extend (agent on_go_button_action)
			l_hor_box.extend (go_button)
			l_hor_box.disable_item_expand (go_button)

			----------------------------------
			l_vertical_box.extend (web_browser)

		end

feature {NONE} -- Implementation

	go_button, back_button, forth_button, stop_button, refresh_button: EV_BUTTON
			-- Buttons.

	url_text_field: EV_TEXT_FIELD
			-- URL text field.

	on_go_button_action
			-- Action for `go_button'.
		local
			l_uri: STRING_32
		do
			l_uri := url_text_field.text
			if l_uri /= Void and then not l_uri.is_empty then
				web_browser.load_uri (l_uri)
			else
				web_browser.load_uri ("http://dev.eiffel.com")
			end

		end

	on_back_button_action
			-- Action for `back_button'.
		do
			web_browser.back
		end

	on_forth_button_action
			-- Action for `forth_button'.
		do
			web_browser.forth
		end

	on_refresh_button_action
			-- Action for `refresh_button'.
		do
			web_browser.refresh
		end

	on_stop_button_action
			-- Action for `stop_button'.
		do
			web_browser.stop
		end

	web_browser: EV_WEB_BROWSER
			-- Web browser widget.

;note
	copyright:	"Copyright (c) 1984-2009, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"


end
