note

	description:

		"Objects that implement the XPath timezone-from-date() function"

	library: "Gobo Eiffel XPath Library"
	copyright: "Copyright (c) 2005-2015, Colin Adams and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class XM_XPATH_TIMEZONE_FROM_DATE

inherit

	XM_XPATH_SYSTEM_FUNCTION
		redefine
			evaluate_item
		end

create

	make

feature {NONE} -- Initialization

	make
			-- Establish invariant
		do
			name := "timezone-from-date"
			namespace_uri := Xpath_standard_functions_uri
			fingerprint := Timezone_from_date_function_type_code
			minimum_argument_count := 1
			maximum_argument_count := 1
			create arguments.make (1)
			arguments.set_equality_tester (expression_tester)
			initialized := True
		end

feature -- Access

	item_type: XM_XPATH_ITEM_TYPE
			-- Data type of the expression, where known
		do
			Result := type_factory.day_time_duration_type
			if Result /= Void then
				-- Bug in SE 1.0 and 1.1: Make sure that
				-- that `Result' is not optimized away.
			end
		end

feature -- Status report

	required_type (argument_number: INTEGER): XM_XPATH_SEQUENCE_TYPE
			-- Type of argument number `argument_number'
		do
			create Result.make_optional_date
		end

feature -- Evaluation

	evaluate_item (a_result: DS_CELL [detachable XM_XPATH_ITEM]; a_context: XM_XPATH_CONTEXT)
			-- Evaluate as a single item to `a_result'.
		local
			l_date_value: XM_XPATH_DATE_VALUE
			l_dt_duration: DT_DATE_TIME_DURATION
			l_date_duration: DT_DATE_DURATION
		do
			arguments.item (1).evaluate_item (a_result, a_context)
			if attached a_result.item as a_result_item and then not a_result_item.is_error then
				l_date_value := a_result_item.as_atomic_value.as_date_value
				if l_date_value.zoned then
					check zoned: attached l_date_value.zoned_date as l_zoned_date then
						create l_date_duration.make (0, 0, 0)
						create l_dt_duration.make_from_date_time_duration (l_date_duration, l_zoned_date.time_zone.fixed_offset)
						a_result.put (create {XM_XPATH_SECONDS_DURATION_VALUE}.make_from_duration (l_dt_duration))
					end
				else
					a_result.put (Void)
				end
			end
		end

feature {XM_XPATH_EXPRESSION} -- Restricted

	compute_cardinality
			-- Compute cardinality.
		do
			set_cardinality_optional
		end

end

