note

	description:

		"Eiffel 'free-operator' feature names"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2005-2017, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2017-04-11 11:34:55 -0700 (Tue, 11 Apr 2017) $"
	revision: "$Revision: 100137 $"

deferred class ET_FREE_NAME

inherit

	ET_CALL_NAME

	KL_IMPORTED_STRING_ROUTINES
		export {NONE} all end

feature -- Access

	lower_name: STRING
			-- Lower-name of feature call
			-- (May return the same object as `name' if already in lower case.)
		local
			i, nb: INTEGER
			c: CHARACTER
		do
			Result := name
			nb := Result.count
			from i := 1 until i > nb loop
				c := Result.item (i)
				if c >= 'A' and c <= 'Z' then
					Result := Result.as_lower
					i := nb + 1 -- Jump out of the loop.
				else
					i := i + 1
				end
			end
		end

	operator_name: STRING
			-- Name of operator
		deferred
		ensure
			operator_name_not_void: Result /= Void
			operator_name_not_empty: Result.count > 0
		end

	operator_lower_name: STRING
			-- Lower-name of operator
			-- (May return the same object as `operator_name' if already in lower case.)
		do
			Result := operator_name
		ensure
			operator_lower_name_not_void: Result /= Void
			operator_lower_name_not_empty: Result.count > 0
			definition: Result.is_equal (operator_name.as_lower)
		end

	hash_code: INTEGER
			-- Hash code value

feature -- Comparison

	same_call_name (other: ET_CALL_NAME): BOOLEAN
			-- Are feature name and `other' the same feature call name?
			-- (case insensitive)
		do
			if other = Current then
				Result := True
			elseif attached {ET_FREE_NAME} other as op then
				if hash_code = op.hash_code then
					if is_infix_freeop /= op.is_infix_freeop then
						Result := False
					elseif op.operator_name = operator_name then
						Result := True
					else
						Result := STRING_.same_case_insensitive (operator_name, op.operator_name)
					end
				end
			end
		end

invariant

	is_freeop: is_infix_freeop xor is_prefix_freeop

end
