note

	description:

		"Eiffel expressions changing the target type of infix expressions"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2004-2014, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class ET_INFIX_CAST_EXPRESSION

inherit

	ET_EXPRESSION

create

	make

feature {NONE} -- Initialization

	make (e: like expression; a_type: like type)
			-- Create a new infix cast expression.
		require
			e_not_void: e /= Void
			a_type_not_void: a_type /= Void
		do
			expression := e
			type := a_type
		ensure
			expression_set: expression = e
			type_set: type = a_type
		end

feature -- Access

	expression: ET_EXPRESSION
			-- Expression to be casted, already converted to the expected type

	type: ET_TYPE
			-- Cast type

	position: ET_POSITION
			-- Position of first character of
			-- current node in source code
		do
			Result := expression.position
		end

	first_leaf: ET_AST_LEAF
			-- First leaf node in current node
		do
			Result := expression.first_leaf
		end

	last_leaf: ET_AST_LEAF
			-- Last leaf node in current node
		do
			Result := expression.last_leaf
		end

feature -- Processing

	process (a_processor: ET_AST_PROCESSOR)
			-- Process current node.
		do
			a_processor.process_infix_cast_expression (Current)
		end

invariant

	expression_not_void: expression /= Void
	type_not_void: type /= Void

end
