note

	description:

		"Unicode routines which apply to a specific version"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2006, Colin Adams and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

deferred class UC_UNICODE_VERSIONING

feature -- Access

	major_version: INTEGER
			-- Major version number of Unicode
		deferred
		ensure
			major_version_strictly_positive: Result > 0
		end

	minor_version: INTEGER
			-- Minor version number of Unicode
		deferred
		ensure
			minor_version_non_negative: Result >= 0
			single_digit: Result < 10
		end

	update_version: INTEGER
			-- Update version number of Unicode
		deferred
		ensure
			update_version_non_negative: Result >= 0
			single_digit: Result < 10
		end

end
