﻿note
	description: "Externals used by the argument parser library"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2017-12-25 01:53:13 -0800 (Mon, 25 Dec 2017) $"
	revision: "$Revision: 101206 $"

class
	ARGUMENT_EXTERNALS

feature -- Externals

	c_get_term_columns: INTEGER
			-- Retrieves the number of columns in the active terminal.
		external
			"C inline use <windows.h>, <stdio.h>"
		alias
			"[
				CONSOLE_SCREEN_BUFFER_INFO csbInfo;
				
				if (GetConsoleScreenBufferInfo (GetStdHandle(STD_OUTPUT_HANDLE), &csbInfo)) {
					return csbInfo.dwSize.X;
				} else {
					return 0;
				}
			]"
		ensure
			is_class: class
		end

note
	copyright: "Copyright (c) 1984-2017, Eiffel Software and others"
	license:   "Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	licensing_options: "http://www.eiffel.com/licensing"
	copying: "[
			This file is part of Eiffel Software's Eiffel Development Environment.
			
			Eiffel Software's Eiffel Development Environment is free
			software; you can redistribute it and/or modify it under
			the terms of the GNU General Public License as published
			by the Free Software Foundation, version 2 of the License
			(available at the URL listed under "license" above).
			
			Eiffel Software's Eiffel Development Environment is
			distributed in the hope that it will be useful, but
			WITHOUT ANY WARRANTY; without even the implied warranty
			of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
			See the GNU General Public License for more details.
			
			You should have received a copy of the GNU General Public
			License along with Eiffel Software's Eiffel Development
			Environment; if not, write to the Free Software Foundation,
			Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
		]"
	source: "[
			Eiffel Software
			5949 Hollister Ave., Goleta, CA 93117 USA
			Telephone 805-685-1006, Fax 805-685-6869
			Website http://www.eiffel.com
			Customer support http://support.eiffel.com
		]"

end
