note
	description: "Protection mechanism constants"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2018-07-05 05:40:01 -0700 (Thu, 05 Jul 2018) $"
	revision: "$Revision: 96785 $"

class
	KG_CONSTANTS

inherit
	EIFFEL_LAYOUT

feature -- Status Report

	has_valid_cd_key_format (s: STRING): BOOLEAN
			-- Do `s' have a valid CD key format?
		require
			non_void_s: s /= Void
		do
			if s.count = Cd_key_length then
				Result := s.substring (1, 5).is_integer and s.substring (6, 6).is_equal (Key_separator) and
							s.substring (7, 11).is_integer and s.substring (12, 12).is_equal (Key_separator) and
							s.substring (13, 17).is_integer and s.substring (18, 18).is_equal (Key_separator) and
							s.substring (19, 23).is_integer and s.substring (24, 24).is_equal (Key_separator) and
							s.substring (25, 29).is_integer and s.substring (30, 30).is_equal (Key_separator) and
							s.substring (31, 35).is_integer
			end
		end

	has_valid_activation_key_format (s: STRING): BOOLEAN
			-- Do `s' have a valid activation key format?
		require
			non_void_s: s /= Void
		do
			if s.count = Activation_key_length then
				Result := s.substring (1, 5).is_integer and s.substring (6, 6).is_equal (Key_separator) and
							s.substring (7, 11).is_integer and s.substring (12, 12).is_equal (Key_separator) and
							s.substring (13, 17).is_integer and s.substring (18, 18).is_equal (Key_separator) and
							s.substring (19, 23).is_integer and s.substring (24, 24).is_equal (Key_separator) and
							s.substring (25, 29).is_integer
			end
		end

feature -- Access

	Trial_days_count: INTEGER = 60
			-- Number of days allowed for using product unactivated

	Left_image_path: PATH
			-- Activation image path
		once
			if is_eiffel_layout_defined then
				Result := eiffel_layout.bitmaps_path
			else
				create Result.make_current
			end
			Result := Result.extended ("png").extended ("activation.png")
		end

	Logo_path: PATH
			-- Logo image path
		once
			if is_eiffel_layout_defined then
				Result := eiffel_layout.bitmaps_path
			else
				create Result.make_current
			end
			Result := Result.extended ("png").extended ("logo.png")
		end

	Default_max_number_of_execution: INTEGER = 500
			-- Max number of execution before registration is required

	Protection_key_path: STRING = "Software\ISE\Eiffel_18.07"
			-- Path to environment variables in registry

	Protection_username: STRING = "eiffelstudio_username"
			-- User name variable name

	Protection_cd_key_name: STRING = "eiffelstudio_key"
			-- CD key variable name

	Protection_data_name: STRING = "data"
			-- Private info data

	Seed_file_name: STRING = "seed.txt"
			-- CD key seed file name

	Cd_key_length: INTEGER = 35
			-- CD Key character count

	Activation_key_length: INTEGER = 29
			-- Activation key character count

	Key_separator: STRING = "-"
			-- Keys codes separator

	Default_activation_key: STRING
			-- Default activation key used for initialization (without '-')
			--| Do not hard-code value
		once
			create Result.make (25)
			Result.append_character ('2')
			Result.append_character ('4')
			Result.append_character ('8')
			Result.append_character ('9')
			Result.append_character ('1')
			Result.append (Key_separator)
			Result.append_character ('7')
			Result.append_character ('3')
			Result.append_character ('9')
			Result.append_character ('0')
			Result.append_character ('4')
			Result.append (Key_separator)
			Result.append_character ('6')
			Result.append_character ('2')
			Result.append_character ('3')
			Result.append_character ('1')
			Result.append_character ('8')
			Result.append (Key_separator)
			Result.append_character ('5')
			Result.append_character ('4')
			Result.append_character ('6')
			Result.append_character ('2')
			Result.append_character ('9')
			Result.append (Key_separator)
			Result.append_character ('6')
			Result.append_character ('5')
			Result.append_character ('4')
			Result.append_character ('6')
			Result.append_character ('5')
		end

invariant
	valid_default_max_number_of_execution: Default_max_number_of_execution > 9

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class KG_CONSTANTS
