/*
 * Code for class PROCESS_UNIX_PROCESS_MANAGER
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pr338.h"
#include <string.h>
#include "eif_memory.h"
#include "eif_built_in.h"
#include "eif_main.h"
#include <unistd.h>
#include "eif_except.h"
#include "eif_process.h"
#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F214_2845
static void inline_F214_2845 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	{
  pid_t rc;
  int status;
  
  rc = waitpid((pid_t) arg1, &status, (arg2 ? 0 : WNOHANG) | WUNTRACED);
  *(EIF_BOOLEAN *) arg5 = (rc != -1);
  if (rc != -1) {				    
	  if (rc == 0) { /* No process has status to report yet */
	    *(EIF_BOOLEAN *) arg3 = EIF_FALSE;
	  } else { /* Process reported status */
	    *(EIF_BOOLEAN *) arg3 = EIF_TRUE;
	  }
	  *(EIF_INTEGER *) arg4 = (EIF_INTEGER) status;
  }
}
	;
}
#define INLINE_F214_2845
#endif
#ifndef INLINE_F620_5219
static int inline_F620_5219 (EIF_INTEGER_32 arg1)
{
	return (int) (WIFEXITED(arg1))
	;
}
#define INLINE_F620_5219
#endif
#ifndef INLINE_F620_5220
static int inline_F620_5220 (EIF_INTEGER_32 arg1)
{
	return (int) (WIFSIGNALED(arg1))
	;
}
#define INLINE_F620_5220
#endif
#ifndef INLINE_F147_2046
static int inline_F147_2046 (void)
{
	#ifdef WORKBENCH
	return EIF_TEST(is_debug_mode());
#else
	return EIF_FALSE;
#endif
	;
}
#define INLINE_F147_2046
#endif
#ifndef INLINE_F147_2045
static void inline_F147_2045 (EIF_BOOLEAN arg1)
{
	#ifdef WORKBENCH
	set_debug_mode (arg1 ? 1 : 0);
#endif
	;
}
#define INLINE_F147_2045
#endif
#ifndef INLINE_F214_2835
static void inline_F214_2835 (void)
{
	{
	setpgid (0, 0);
}
	;
}
#define INLINE_F214_2835
#endif
#ifndef INLINE_F214_2850
static void inline_F214_2850 (EIF_INTEGER_32 arg1)
{
	{
	pid_t pgid = getpgid (arg1);
	tcsetpgrp (1, pgid);
	tcsetpgrp (2, pgid);
}
	;
}
#define INLINE_F214_2850
#endif
#ifndef INLINE_F214_2831
static void inline_F214_2831 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
  int rc;
  rc = dup2(arg1, arg2);
  if (rc < 0) {
	    eraise(Strerror(errno), EN_SYS);
  }
}
	;
}
#define INLINE_F214_2831
#endif
#ifndef INLINE_F214_2832
static void inline_F214_2832 (EIF_INTEGER_32 arg1)
{
	{
	 int rc;
	  rc = close(arg1);
	  if (rc != 0) {
	    eraise(Strerror(errno), EN_SYS);
	  }
}
	;
}
#define INLINE_F214_2832
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PROCESS_UNIX_PROCESS_MANAGER}.make */
void F620_5161 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_REFERENCE arg3)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg3);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLR(4,arg2);
	RTLIU(5);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg3 != NULL)) {
		tr1 = RTLNSMART(eif_new_type(1020, 0).id);
		F1021_8459(RTCW(tr1), arg3);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	} else {
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) NULL;
	}
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_4_) = (EIF_REFERENCE) arg1;
	F620_5173(Current, arg2);
	*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	tr1 = RTMS_EX_H("",0,0);
	F620_5175(Current, tr1);
	tr1 = RTMS_EX_H("",0,0);
	F620_5176(Current, tr1);
	tr1 = RTMS_EX_H("",0,0);
	F620_5177(Current, tr1);
	F620_5223(Current, (EIF_BOOLEAN) 0);
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.working_directory */
EIF_REFERENCE F620_5165 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.arguments_for_exec */
EIF_REFERENCE F620_5166 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_1_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.set_arguments */
void F620_5173 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,loc1);
	RTLR(2,Current);
	RTLR(3,tr1);
	RTLR(4,loc2);
	RTLIU(5);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != NULL)) {
		{
			static EIF_TYPE_INDEX typarr0[] = {860,0xFF01,996,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
			tr1 = RTLNSMART(typres0.id);
		}
		F861_6356(RTCW(tr1), ((EIF_INTEGER_32) 0L));
		loc1 = (EIF_REFERENCE) tr1;
		loc2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R5090[Dtype(arg1)-643])(RTCW(arg1));
		for (;;) {
			tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R3749[Dtype(loc2)-557])(loc2);
			if (tb1) break;
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R3748[Dtype(loc2)-557])(loc2);
			tr1 = F1_14(tr1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R3185[Dtype(loc1)-392])(RTCW(loc1), tr1);
			(FUNCTION_CAST(void, (EIF_REFERENCE)) R3750[Dtype(loc2)-557])(loc2);
		}
	}
	RTAR(Current, loc1);
	*(EIF_REFERENCE *)(Current + _REFACS_5_) = (EIF_REFERENCE) loc1;
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_close_nonstandard_files */
void F620_5174 (EIF_REFERENCE Current, EIF_BOOLEAN arg1)
{
	GTCX
	
	
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_6_) = (EIF_BOOLEAN) arg1;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_input_file_name */
void F620_5175 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_6_) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_7_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_output_file_name */
void F620_5176 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_7_) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_8_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_error_file_name */
void F620_5177 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_8_) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_error_same_as_output */
void F620_5178 (EIF_REFERENCE Current)
{
	GTCX
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
	*(EIF_REFERENCE *)(Current + _REFACS_8_) = (EIF_REFERENCE) NULL;
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.wait_for_process */
void F620_5179 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc2 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc3 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	inline_F214_2845(arg1, arg2, (EIF_BOOLEAN *) &(loc2), (EIF_INTEGER_32 *) &(loc1), (EIF_BOOLEAN *) &(loc3));
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_0_) = (EIF_BOOLEAN) loc3;
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_0_)) {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_) = (EIF_BOOLEAN) loc2;
		*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_) = (EIF_INTEGER_32) loc1;
		tb1 = '\0';
		if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_)) {
			tb2 = '\01';
			ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_);
			if (!EIF_TEST (inline_F620_5219(ti4_1))) {
				ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_);
				tb2 = EIF_TEST (inline_F620_5220(ti4_1));
			}
			tb1 = tb2;
		}
		if (tb1) {
			F620_5223(Current, (EIF_BOOLEAN) 0);
		} else {
			F620_5223(Current, (EIF_BOOLEAN) 1);
		}
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
		F620_5223(Current, (EIF_BOOLEAN) 0);
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.close_pipes */
void F620_5180 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLIU(5);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		F625_5365(loc1);
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		F625_5364(loc2);
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		F625_5364(loc3);
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.spawn_nowait */
#undef EIF_VOLATILE
#define EIF_VOLATILE volatile
void F620_5181 (EIF_REFERENCE Current, EIF_BOOLEAN arg1, EIF_REFERENCE arg2, EIF_BOOLEAN arg3)
{
	GTCX
	RTEX;
	RTED;
	EIF_REFERENCE EIF_VOLATILE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE loc2 = (EIF_REFERENCE) 0;
	EIF_BOOLEAN EIF_VOLATILE loc3 = (EIF_BOOLEAN) 0;
	EIF_REFERENCE EIF_VOLATILE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE saved_except = (EIF_REFERENCE) 0;
	EIF_POINTER  EIF_VOLATILE tp1;
	EIF_REFERENCE  EIF_VOLATILE tr1 = NULL;
	EIF_INTEGER_32  EIF_VOLATILE ti4_1;
	EIF_BOOLEAN  EIF_VOLATILE tb1;
	RTLD;
	RTXD;
	
	RTLI(8);
	RTLR(0,loc5);
	RTLR(1,Current);
	RTLR(2,loc1);
	RTLR(3,tr1);
	RTLR(4,loc4);
	RTLR(5,loc2);
	RTLR(6,arg2);
	RTLR(7,saved_except);
	RTLIU(8);
	RTXSLS;
	
	RTEV;
	RTGC;
	RTE_T
	loc5 = F620_5203(Current);
	RTAR(Current, loc5);
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) loc5;
	F620_5204(Current);
	tr1 = RTLNS(eif_new_type(615, 0x01).id, 615, _OBJSIZ_0_0_0_1_0_0_0_0_);
	loc1 = (EIF_REFERENCE) tr1;
	loc4 = *(EIF_REFERENCE *)(Current);
	if ((EIF_BOOLEAN)(loc4 != NULL)) {
		loc2 = F616_5122(RTCW(loc1));
		F616_5137(RTCW(loc1), loc4);
	}
	loc3 = EIF_TEST (inline_F147_2046());
	F147_2044(Current);
	ti4_1 = F214_2834(Current);
	*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) = (EIF_INTEGER_32) ti4_1;
	switch (*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_)) {
		case -1L:
			inline_F147_2045(loc3);
			if ((EIF_BOOLEAN)(loc2 != NULL)) {
				F616_5137(RTCW(loc1), loc2);
			}
			break;
		case 0L:
			eif_gc_stop();
			if (arg3) {
				inline_F214_2835();
				if (arg1) {
					ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_);
					inline_F214_2850(ti4_1);
				}
			}
			F620_5206(Current);
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_4_);
			tb1 = *(EIF_BOOLEAN *)(Current+ _CHROFF_15_6_);
			tp1 = F620_5214(Current, arg2);
			F214_2836(Current, tr1, loc5, tb1, tp1);
			break;
		default:
			inline_F147_2045(loc3);
			F620_5205(Current);
			*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
			F620_5223(Current, (EIF_BOOLEAN) 1);
			if ((EIF_BOOLEAN)(loc2 != NULL)) {
				F616_5137(RTCW(loc1), loc2);
			}
			break;
	}
	RTE_E
	RTXSC;
	if ((EIF_BOOLEAN)(*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) == ((EIF_INTEGER_32) 0L))) {
		tr1 = RTLNS(eif_new_type(485, 0x01).id, 485, _OBJSIZ_0_0_0_0_0_0_0_0_);
		esdie(((EIF_INTEGER_32) 1L));
	}
	inline_F147_2045(loc3);
	/* NOTREACHED */
	RTE_EE
	RTEOK;
	RTLE;
}
#undef EIF_VOLATILE
#define EIF_VOLATILE

/* {PROCESS_UNIX_PROCESS_MANAGER}.program_file_name */
EIF_REFERENCE F620_5193 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_4_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.arguments */
EIF_REFERENCE F620_5194 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_5_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.input_file_name */
EIF_REFERENCE F620_5196 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_6_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.output_file_name */
EIF_REFERENCE F620_5197 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_7_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.error_file_name */
EIF_REFERENCE F620_5198 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_8_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.built_argument_list */
EIF_REFERENCE F620_5203 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTCFDT;
	RTLD;
	
	RTLI(6);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,Result);
	RTLR(5,loc3);
	RTLIU(6);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_5_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		{
			static EIF_TYPE_INDEX typarr0[] = {791,0xFF01,996,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(dftype, typarr0)));
			tr1 = RTLNSMART(typres0.id);
		}
		tr2 = *(EIF_REFERENCE *)(Current + _REFACS_4_);
		ti4_1 = F861_6376(loc2);
		F792_6170(RTCW(tr1), tr2, ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
		Result = (EIF_REFERENCE) tr1;
		loc3 = F861_6369(loc2);
		loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		for (;;) {
			tb1 = F693_5925(loc3);
			if (tb1) break;
			tr1 = F693_5916(loc3);
			F792_6194(RTCW(Result), tr1, loc1);
			loc1++;
			F693_5931(loc3);
		}
	} else {
		{
			static EIF_TYPE_INDEX typarr0[] = {791,0xFF01,996,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(dftype, typarr0)));
			tr1 = RTLNSMART(typres0.id);
		}
		tr2 = *(EIF_REFERENCE *)(Current + _REFACS_4_);
		F792_6170(RTCW(tr1), tr2, ((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 1L));
		RTLE;
		return (EIF_REFERENCE) tr1;
	}
	RTLE;
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.open_files_and_pipes */
void F620_5204 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(6);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLIU(6);
	
	RTGC;
	tr1 = RTLNS(eif_new_type(214, 0x01).id, 214, _OBJSIZ_0_0_0_0_0_0_0_0_);
	loc1 = (EIF_REFERENCE) tr1;
	*(EIF_REFERENCE *)(Current + _REFACS_12_) = (EIF_REFERENCE) NULL;
	*(EIF_REFERENCE *)(Current + _REFACS_9_) = (EIF_REFERENCE) NULL;
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_7_)) {
		tr1 = F215_2851(RTCW(loc1));
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current + _REFACS_12_) = (EIF_REFERENCE) tr1;
	} else {
		loc2 = *(EIF_REFERENCE *)(Current + _REFACS_6_);
		tb1 = '\0';
		if ((EIF_BOOLEAN)(loc2 != NULL)) {
			tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R6430[Dtype(loc2)-999])(RTCW(loc2));
			tb1 = (EIF_BOOLEAN) !tb2;
		}
		if (tb1) {
			tr1 = RTLNSMART(eif_new_type(627, 0).id);
			F626_5436(RTCW(tr1), loc2);
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_9_) = (EIF_REFERENCE) tr1;
		}
	}
	*(EIF_REFERENCE *)(Current + _REFACS_13_) = (EIF_REFERENCE) NULL;
	*(EIF_REFERENCE *)(Current + _REFACS_10_) = (EIF_REFERENCE) NULL;
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_8_)) {
		tr1 = F215_2851(RTCW(loc1));
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current + _REFACS_13_) = (EIF_REFERENCE) tr1;
	} else {
		loc3 = *(EIF_REFERENCE *)(Current + _REFACS_7_);
		tb1 = '\0';
		if ((EIF_BOOLEAN)(loc3 != NULL)) {
			tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R6430[Dtype(loc3)-999])(RTCW(loc3));
			tb1 = (EIF_BOOLEAN) !tb2;
		}
		if (tb1) {
			tr1 = RTLNSMART(eif_new_type(627, 0).id);
			F626_5438(RTCW(tr1), loc3);
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_10_) = (EIF_REFERENCE) tr1;
		}
	}
	*(EIF_REFERENCE *)(Current + _REFACS_14_) = (EIF_REFERENCE) NULL;
	*(EIF_REFERENCE *)(Current + _REFACS_11_) = (EIF_REFERENCE) NULL;
	if ((EIF_BOOLEAN) !*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_)) {
			tr1 = F215_2851(RTCW(loc1));
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_14_) = (EIF_REFERENCE) tr1;
		} else {
			loc4 = *(EIF_REFERENCE *)(Current + _REFACS_8_);
			tb1 = '\0';
			if ((EIF_BOOLEAN)(loc4 != NULL)) {
				tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R6430[Dtype(loc4)-999])(RTCW(loc4));
				tb1 = (EIF_BOOLEAN) !tb2;
			}
			if (tb1) {
				tr1 = RTLNSMART(eif_new_type(627, 0).id);
				F626_5438(RTCW(tr1), loc4);
				RTAR(Current, tr1);
				*(EIF_REFERENCE *)(Current + _REFACS_11_) = (EIF_REFERENCE) tr1;
			}
		}
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.setup_parent_process_files */
void F620_5205 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLR(6,loc5);
	RTLR(7,loc6);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		F625_5364(loc1);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_9_);
		loc2 = tr1;
		if (EIF_TEST(loc2)) {
			F626_5517(loc2);
		}
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		F625_5365(loc3);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_10_);
		loc4 = tr1;
		if (EIF_TEST(loc4)) {
			F626_5517(loc4);
		}
	}
	if ((EIF_BOOLEAN) !*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
		loc5 = tr1;
		if (EIF_TEST(loc5)) {
			F625_5365(loc5);
		} else {
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_11_);
			loc6 = tr1;
			if (EIF_TEST(loc6)) {
				F626_5517(loc6);
			}
		}
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.setup_child_process_files */
void F620_5206 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLR(6,loc5);
	RTLR(7,loc6);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		ti4_1 = *(EIF_INTEGER_32 *)(loc1+ _LNGOFF_2_7_2_1_);
		F620_5207(Current, ti4_1, ((EIF_INTEGER_32) 0L));
		F625_5365(loc1);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_9_);
		loc2 = tr1;
		if (EIF_TEST(loc2)) {
			ti4_1 = F626_5446(loc2);
			F620_5207(Current, ti4_1, ((EIF_INTEGER_32) 0L));
		}
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		ti4_1 = *(EIF_INTEGER_32 *)(loc3+ _LNGOFF_2_7_2_2_);
		F620_5207(Current, ti4_1, ((EIF_INTEGER_32) 1L));
		F625_5364(loc3);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_10_);
		loc4 = tr1;
		if (EIF_TEST(loc4)) {
			ti4_1 = F626_5446(loc4);
			F620_5207(Current, ti4_1, ((EIF_INTEGER_32) 1L));
		}
	}
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		inline_F214_2831(((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 2L));
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
		loc5 = tr1;
		if (EIF_TEST(loc5)) {
			ti4_1 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_7_2_2_);
			F620_5207(Current, ti4_1, ((EIF_INTEGER_32) 2L));
			F625_5364(loc5);
		} else {
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_11_);
			loc6 = tr1;
			if (EIF_TEST(loc6)) {
				ti4_1 = F626_5446(loc6);
				F620_5207(Current, ti4_1, ((EIF_INTEGER_32) 2L));
			}
		}
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.move_desc */
void F620_5207 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != arg2)) {
		inline_F214_2831(arg1, arg2);
		inline_F214_2832(arg1);
	}
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.in_file */
EIF_REFERENCE F620_5208 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_9_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.out_file */
EIF_REFERENCE F620_5209 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_10_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.err_file */
EIF_REFERENCE F620_5210 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_11_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.environment_table_as_pointer */
EIF_POINTER F620_5214 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc8 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc9 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc10 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_CHARACTER_32 tw1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(10);
	RTLR(0,arg1);
	RTLR(1,loc7);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,loc8);
	RTLR(5,loc9);
	RTLR(6,loc10);
	RTLR(7,loc6);
	RTLR(8,loc2);
	RTLR(9,Current);
	RTLIU(10);
	
	RTGC;
	tb1 = '\0';
	if ((EIF_BOOLEAN)(arg1 != NULL)) {
		tb2 = F396_3519(RTCW(arg1));
		tb1 = (EIF_BOOLEAN) !tb2;
	}
	if (tb1) {
		loc7 = F765_6013(RTCW(arg1));
		for (;;) {
			tb1 = F685_5913(loc7);
			if (tb1) break;
			tb2 = '\0';
			tr1 = F685_5911(loc7);
			if ((EIF_BOOLEAN)(tr1 != NULL)) {
				tr1 = F685_5910(loc7);
				tb2 = (EIF_BOOLEAN)(tr1 != NULL);
			}
			if (tb2) {
				loc5++;
			}
			F685_5914(loc7);
		}
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes;
		Result = malloc((size_t)(EIF_INTEGER_32) ((EIF_INTEGER_32) (loc5 + ((EIF_INTEGER_32) 1L)) * ti4_1));
		tr1 = RTLNS(eif_new_type(578, 0x01).id, 578, _OBJSIZ_0_1_0_1_0_1_1_0_);
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes;
		F579_4510(RTCW(tr1), Result, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc5 + ((EIF_INTEGER_32) 1L)) * ti4_1));
		loc1 = (EIF_REFERENCE) tr1;
		loc8 = F765_6013(RTCW(arg1));
		for (;;) {
			tb2 = F685_5913(loc8);
			if (tb2) break;
			tb3 = '\0';
			tr1 = F685_5911(loc8);
			loc9 = tr1;
			if (EIF_TEST(loc9)) {
				tr1 = F685_5910(loc8);
				loc10 = tr1;
				tb3 = EIF_TEST(loc10);
			}
			if (tb3) {
				tr1 = RTLNS(eif_new_type(1005, 0x01).id, 1005, _OBJSIZ_1_1_0_3_0_0_0_0_);
				ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R6452[Dtype(loc9)-998])(loc9);
				ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R6452[Dtype(loc10)-998])(loc10);
				F1004_7855(RTCW(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ((EIF_INTEGER_32) 1L)));
				loc6 = (EIF_REFERENCE) tr1;
				F1006_7967(RTCW(loc6), loc9);
				tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '=';
				F1006_7982(RTCW(loc6), tw1);
				F1006_7967(RTCW(loc6), loc10);
				tr1 = RTLNS(eif_new_type(611, 0x01).id, 611, _OBJSIZ_1_0_0_1_0_0_0_0_);
				F612_4981(RTCW(tr1), loc6);
				loc2 = (EIF_REFERENCE) tr1;
				ti4_1 = F612_4992(RTCW(loc2));
				loc3 = malloc((size_t)(EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
				tp1 = F612_4988(RTCW(loc2));
				ti4_1 = F612_4992(RTCW(loc2));
				memcpy((void *)loc3, (const void *) tp1, (size_t) (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
				ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes;
				F579_4546(RTCW(loc1), loc3, (EIF_INTEGER_32) (loc4 * ti4_1));
				loc4++;
			}
			F685_5914(loc8);
		}
		{
			/* INLINED CODE (default_pointer) */
			tp1 = (EIF_POINTER)  0;
			/* END INLINED CODE */
		}
		tp2 = tp1;
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes;
		F579_4546(RTCW(loc1), tp2, (EIF_INTEGER_32) (loc4 * ti4_1));
	}
	RTLE;
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.shared_input_unnamed_pipe */
EIF_REFERENCE F620_5215 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_12_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.shared_output_unnamed_pipe */
EIF_REFERENCE F620_5216 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_13_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.shared_error_unnamed_pipe */
EIF_REFERENCE F620_5217 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_14_);
}


/* {PROCESS_UNIX_PROCESS_MANAGER}.terminate_flag_from_status */
EIF_BOOLEAN F620_5219 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F620_5219 ((EIF_INTEGER_32) arg1));
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.signaled_flag_from_status */
EIF_BOOLEAN F620_5220 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F620_5220 ((EIF_INTEGER_32) arg1));
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_is_executing */
void F620_5223 (EIF_REFERENCE Current, EIF_BOOLEAN arg1)
{
	GTCX
	
	
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_1_) = (EIF_BOOLEAN) arg1;
}

void EIF_Minit338 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
