note
	description: "Class which returns the name the user entered, in upper case."
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2009-02-03 11:29:22 -0800 (Tue, 03 Feb 2009) $"
	revision: "$Revision: 76951 $"

class
	SAMPLE

inherit
	CGI_INTERFACE

create
	make

feature -- Access

	Debug_mode: BOOLEAN = True
			-- Should exception trace be displayed in case a crash occurs?


feature -- Basic Operations

	execute
			-- Perform form entries processing, and send back the answer
			-- to the browser.
		local
			return_message: HTML_PAGE
		do
			create return_message.make
			if field_defined ("name") then
					-- Add the <head> and <title> tags.
				return_message.add_html_code ("<HEAD><TITLE>EiffelWEB Example</TITLE></HEAD>")
					-- Display the name entered in the body of the page.
				return_message.add_html_code ("<BODY><H1>Hello " + text_field_value ("name") +
					"</H1><P>You have just processed a web form using EiffelWEB!</P></BODY>")
			end
			response_header.generate_text_header
			response_header.send_to_browser
			response_header.Output.put_string (return_message.out)
		rescue
			io.error.putstring ("crash in `compute' from DOWNLOAD_INTERACTION%N")
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"


end -- class SAMPLE
