/*
 * Code for class I18N_UNIX_C_FUNCTIONS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "i199.h"
#include <locale.h>
#include <eif_langinfo.h>
#include <iconv.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F123_1697
static EIF_INTEGER_32 inline_F123_1697 (void)
{
	return LC_ALL;
	;
}
#define INLINE_F123_1697
#endif
#ifndef INLINE_F123_1696
static EIF_POINTER inline_F123_1696 (EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	return setlocale((int) arg1, (const char *) arg2);
	;
}
#define INLINE_F123_1696
#endif
#ifndef INLINE_F123_1691
static EIF_POINTER inline_F123_1691 (EIF_INTEGER_32 arg1)
{
	char *dname;
				wchar_t *out = NULL;
				size_t insize, outsize = 0;

				dname = nl_langinfo(arg1);
				insize = strlen(dname) + 1;
				
				{
					iconv_t cd;
					size_t nconv, avail, alloc;
					char *res, *tres, *wrptr, *inptr;
					char **l_inptr = &inptr;

					alloc = avail = insize + insize/4;
					if (!(res = malloc(alloc))) {
					  perror("malloc");
					  return NULL;
					}

					wrptr = res;   /* duplicate pointers because they */
					inptr = dname; /* get modified by iconv */
					
					/*get charset used by current locale */
					#if EIF_OS == EIF_OS_OPENBSD
						char *charset = locale_charset ();
					#else
						char *charset = nl_langinfo (CODESET);
					#endif
					
					cd = iconv_open ("UTF-8", charset);
					if (cd == (iconv_t)(-1)) {
							perror("iconv_open");
							free(res);
							return NULL;
					}

					do {
							nconv = iconv (cd, l_inptr, &insize, &wrptr, &avail); /*convertions */
							if (nconv == (size_t)(-1)) {
									if (errno == E2BIG) { /* need more room for result */
											tres = realloc(res, alloc += 20);
											avail += 20;
											if (!tres) {
													perror("realloc");
													break;
											}
											wrptr = tres + (wrptr - res);
											res = tres;
									}
									else /* something wrong with input */
											break;
							}
					} while (insize);

					if (iconv_close(cd))
							perror("iconv_close");
				   
					out = (wchar_t*) res;
					outsize = wrptr - res; /* should be == to (alloc - avail + 1) */
					/* TODO: should possibly null-terminate the result */
				}
				return out;
	;
}
#define INLINE_F123_1691
#endif
#ifndef INLINE_F123_1693
static EIF_POINTER inline_F123_1693 (void)
{
	#if EIF_OS == EIF_OS_OPENBSD
	return locale_charset ();
#else
	return nl_langinfo (CODESET);
#endif
	;
}
#define INLINE_F123_1693
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {I18N_UNIX_C_FUNCTIONS}.unix_set_locale */
void F123_1689 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,Current);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTEAA("unix_set_locale", 122, Current, 3, 1, 1912);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(eif_new_type(657, 0x00).id, 657, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F658_5321(RTCW(tr1), arg1);
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	ti4_1 = inline_F123_1697();
	tp1 = F658_5340(RTCW(loc1));
	loc2 = inline_F123_1696(ti4_1, tp1);
	RTHOOK(3);
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		RTHOOK(4);
		tr1 = RTLNS(eif_new_type(657, 0x00).id, 657, _OBJSIZ_1_0_0_1_0_0_0_0_);
		F658_5325(RTCW(tr1), loc2);
		loc1 = (EIF_REFERENCE) tr1;
		RTHOOK(5);
		tr1 = RTOUCR(641,F123_1695,(Current));
		tr2 = F658_5334(RTCW(loc1));
		F185_2457(RTCW(tr1), tr2);
	} else {
		RTHOOK(6);
		tr1 = RTOUCR(641,F123_1695,(Current));
		tr2 = RTMS_EX_H("POSIX",5,1331472728);
		F185_2457(RTCW(tr1), tr2);
	}
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_get_locale_info_managed */
EIF_REFERENCE F123_1690 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,tr1);
	RTLR(1,Result);
	RTLR(2,Current);
	RTLIU(3);
	
	RTEAA("unix_get_locale_info_managed", 122, Current, 0, 1, 1913);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(eif_new_type(651, 0x00).id, 651, _OBJSIZ_0_1_0_1_0_1_1_0_);
	tp1 = inline_F123_1691(arg1);
	F652_5060(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
	Result = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_get_locale_info */
EIF_POINTER F123_1691 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_get_locale_info", 122, Current, 0, 1, 1914);
	Result = inline_F123_1691 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_is_available */
EIF_BOOLEAN F123_1692 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,Current);
	RTLIU(4);
	
	RTEAA("unix_is_available", 122, Current, 2, 1, 1915);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(eif_new_type(657, 0x00).id, 657, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F658_5321(RTCW(tr1), arg1);
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	ti4_1 = inline_F123_1697();
	tp1 = F658_5340(RTCW(loc1));
	tp1 = inline_F123_1696(ti4_1, tp1);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tp1 != loc2);
	RTHOOK(3);
	tr1 = F123_1694(Current);
	F123_1689(Current, tr1);
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.c_current_codeset */
EIF_POINTER F123_1693 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_current_codeset", 122, Current, 0, 0, 1916);
	Result = inline_F123_1693 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_locale_name */
EIF_REFERENCE F123_1694 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLIU(2);
	
	RTEAA("unix_locale_name", 122, Current, 0, 0, 1917);
	RTGC;
	RTHOOK(1);
	Result = *(EIF_REFERENCE *)(RTCV(RTOUCR(641,F123_1695,(Current))));
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_locale_name_cell */
static EIF_REFERENCE F123_1695_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	RTLD;
	
#define Result RTOTRR
	RTOUDR(641)

	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLIU(3);
	
	RTEAA("unix_locale_name_cell", 122, Current, 0, 0, 1918);
	RTGC;
	RTOTP;
	RTHOOK(1);
	{
		static EIF_TYPE_INDEX typarr0[] = {184,1038,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		tr1 = RTLNS(typres0.id, 184, _OBJSIZ_1_0_0_0_0_0_0_0_);
	}
	tr2 = RTMS_EX_H("POSIX",5,1331472728);
	F185_2457(RTCW(tr1), tr2);
	Result = (EIF_REFERENCE) tr1;
	RTOTE;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F123_1695 (EIF_REFERENCE Current)
{
	GTCX
	return RTOUCR(641,F123_1695_body,(Current));
}

/* {I18N_UNIX_C_FUNCTIONS}.c_setlocale */
EIF_POINTER F123_1696 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_setlocale", 122, Current, 0, 2, 1919);
	Result = inline_F123_1696 ((EIF_INTEGER_32) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.c_lc_all */
EIF_INTEGER_32 F123_1697 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_lc_all", 122, Current, 0, 0, 1920);
	Result = inline_F123_1697 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit99 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
