note
	description: "Generate private keys"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2012-12-15 00:14:51 -0800 (Sat, 15 Dec 2012) $"
	revision: "$Revision: 96460 $"

class
	KG_ACTIVATION_KEY_GENERATOR

inherit
	KG_CONSTANTS

create
	make

feature {NONE} -- Initialization

	make (date: like registration_date; l_product, l_version, name, key, l_platform: STRING)
			-- Initialize encoder
		require
			non_void_date: date /= Void
			non_void_product_name: l_product /= Void
			valid_product_name: not l_product.is_empty
			non_void_version: l_version /= Void
			valid_version: not l_version.is_empty
			non_void_user_name: name /= Void
			valid_user_name: not name.is_empty
			non_void_key: key /= Void
			valid_key_character_count: key.count = Cd_key_length
			valid_key: (create {KG_CD_KEY_GENERATOR}.make (l_product, l_version)).is_valid_cd_key (key)
			non_void_platform: l_platform /= Void
			valid_platform: not l_platform.is_empty
		do
			registration_date := date
			user_name := name
			cd_key := key
			product := l_product
			version := l_version
			platform := l_platform
		ensure
			registration_date_set: registration_date = date
			user_name_set: user_name = name
			cd_key_set: cd_key = key
			product_set: product = l_product
			version_set: version = l_version
			platform_set: platform = l_platform
		end

feature -- Access

	product: STRING
			-- Product for which to generate key
	
	platform: STRING
			-- Platform for which to generate key

	version: STRING
			-- Version of product for which to generate key

	registration_date: DATE
			-- Registration date used to produce activation key
		
	user_name: STRING
			-- User name used to produce activation key
	
	cd_key: STRING
			-- CD key used to produce activation key

	activation_key: STRING
			-- Newly generated activation key
			-- 34532-35325-76256-79245-23249
		local
			l_c36, l_c914, l_c1518, l_c1923: STRING
		do
			create Result.make (5 * 4 + 4)
			Result.append (c12)
			l_c36 := c36
			Result.append (l_c36.substring (1, 3))
			Result.append (Key_separator)
			Result.append (l_c36.substring (4, 4))
			Result.append (c78)
			l_c914 := c914
			Result.append (l_c914.substring (1, 2))
			Result.append (Key_separator)
			Result.append (l_c914.substring (3, 6))
			l_c1518 := c1518
			Result.append (l_c1518.substring (1, 1))
			Result.append (Key_separator)
			Result.append (l_c1518.substring (2, 4))
			l_c1923 := c1923
			Result.append (l_c1923.substring (1, 2))
			Result.append (Key_separator)
			Result.append (l_c1923.substring (3, 5))
			Result.append (c2425)
		ensure
			non_void_key: Result /= Void
			valid_key_character_count: Result.count = Activation_key_length
			valid_key: is_valid_activation_key (Result)
		end
		
feature -- Status Report

	is_valid_activation_key (key: STRING): BOOLEAN
			-- Is `key' a valid public key?
		require
			non_void_key: key /= Void
			valid_key: key.count = Activation_key_length
			numeric_key: key.substring (1, 5).is_integer and key.substring (7, 11).is_integer and
							key.substring (13, 17).is_integer and key.substring (19, 23).is_integer and
							key.substring (25, 29).is_integer
		local
			s: STRING
		do
			s := key.twin
			s.prune_all (Key_separator.item (1))
			Result := s.substring (1, 2).is_equal (c12)
			if Result then
				Result := s.substring (3, 6).is_equal (c36)
				if Result then
					Result := s.substring (7, 8).is_equal (c78)
					if Result then
						Result := s.substring (9, 14).is_equal (c914)
						if Result then
							Result := s.substring (15, 18).is_equal (c1518)
							if Result then
								Result := s.substring (19, 23).is_equal (c1923)
								if Result then
									Result := s.substring (24, 25).is_equal (c2425)
								end
							end
						end
					end
				end
			end
		end

feature {NONE} -- Implementation

	c12: STRING
			-- Component c12
		do
			Result := registration_date.day.out
			if Result.count = 1 then
				Result.prepend ("0")
			end
		ensure
			non_void_c12: Result /= Void
			valid_c12: Result.count = 2
		end

	c36: STRING
			-- Component c36
		do
			if cd_key.substring (1, 5).is_equal ("00000") then
				Result := ((registration_date.day * user_name.count * user_name.item (1).code * registration_date.month * registration_date.year) // 54902).out
			else
				Result := ((registration_date.day * user_name.count * user_name.item (1).code * registration_date.month * registration_date.year) // cd_key.substring (1, 5).to_integer).out
			end
			if Result.count = 1 then
				Result.prepend ("453")
			elseif Result.count = 2 then
				Result.prepend ("50")
			elseif Result.count = 3 then
				Result.prepend ("2")
			elseif Result.count > 4 then
				Result.keep_tail (4)
			end
		ensure
			non_void_c36: Result /= Void
			valid_c36: Result.count = 4
		end

	c78: STRING
			-- Component c78
		do
			if cd_key.substring (7, 9).is_equal ("000") then
				Result := (registration_date.day + registration_date.year * 3 // 58).out
			else
				Result := (registration_date.day + registration_date.year * 3 // cd_key.substring (7, 9).to_integer).out
			end
			if Result.count = 1 then
				Result.prepend ("3")
			elseif Result.count > 2 then
				Result.keep_tail (2)
			end
		ensure
			non_void_c78: Result /= Void
			valid_c78: Result.count = 2
		end

	c914: STRING
			-- Component c914
		do
			Result := (user_name.hash_code - registration_date.month * cd_key.substring (10, 11).to_integer + product.hash_code).abs.out
			if Result.count = 1 then
				Result.append ("26592")
			elseif Result.count = 2 then
				Result.append ("3254")
			elseif Result.count = 3 then
				Result.append ("892")
			elseif Result.count = 4 then
				Result.append ("45")
			elseif Result.count = 5 then
				Result.append ("7")
			elseif Result.count > 6 then
				Result.keep_tail (6)
			end
		ensure
			non_void_c914: Result /= Void
			valid_c914: Result.count = 6
		end

	c1518: STRING
			-- Component c1518
		do
			if cd_key.substring (19, 20).is_equal ("00") then
				Result := (cd_key.substring (13, 17).to_integer // 34 + platform.hash_code).out
			else
				Result := (cd_key.substring (13, 17).to_integer // cd_key.substring (19, 20).to_integer + platform.hash_code).out
			end
			if Result.count = 1 then
				Result.append ("690")
			elseif Result.count = 2 then
				Result.append ("31")
			elseif Result.count = 3 then
				Result.prepend ("7")
			elseif Result.count > 4 then
				Result.keep_head (4)
			end
		ensure
			non_void_c1518: Result /= Void
			valid_c1518: Result.count = 4
		end

	c1923: STRING
			-- Component c1923
		do
			Result := ((cd_key.substring (21, 23).to_integer * cd_key.substring (25, 28).to_integer) // registration_date.day + version.hash_code // 100).out
			if Result.count = 1 then
				Result.prepend ("4294")
			elseif Result.count = 2 then
				Result.prepend ("320")
			elseif Result.count = 3 then
				Result.append ("65")
			elseif Result.count = 4 then
				Result.append ("0")
			elseif Result.count > 5 then
				Result.keep_head (5)
			end
		ensure
			non_void_c1923: Result /= Void
			valid_c1923: Result.count = 5
		end

	c2425: STRING
			-- Component c2425
		do
			Result := cd_key.substring (29, 29) + cd_key.substring (31, 31)
		ensure
			non_void_c2425: Result /= Void
			valid_c2425: Result.count = 2
		end

invariant
	non_void_user_name: user_name /= Void
	valid_user_name: not user_name.is_empty
	non_void_registration_date: registration_date /= Void
	valid_registration_date: registration_date <= (create {DATE}.make_now) and registration_date > (create {DATE}.make (2002, 8, 6))
	non_void_cd_key: cd_key /= Void
	valid_cd_key_character_count: cd_key.count = Cd_key_length
	valid_cd_key: (create {KG_CD_KEY_GENERATOR}.make (product, version)).is_valid_cd_key (cd_key)

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class KG_ACTIVATION_KEY_GENERATOR
