note
	description:
		"Facility to access a standard output medium"
	legal: "See notice at end of class."

	status: "See notice at end of class."
	date: "$Date: 2008-12-29 20:27:11 +0000 (Mon, 29 Dec 2008) $"
	revision: "$Revision: 76420 $"

class 
	STANDARD_OUTPUT_FACILITY

feature -- Status report

	has_standard_output: BOOLEAN
			-- Has a standard output been set?
		do
			Result := (standard_output /= Void)
		end
		
feature -- Status setting

	set_standard_output (o: IO_MEDIUM)
			-- Set standard output to `o'.
		do
			standard_output := o
		ensure
			medium_set: standard_output = o
		end
		
feature {NONE} -- Implementation

	standard_output: IO_MEDIUM;
			-- Standard output medium

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class STANDARD_OUTPUT_FACILITY

