note
	description: "Task. Task Scheduler."
	generator: "Automatically generated by the EiffelCOM Wizard."

class
	CTASK_PROXY

inherit
	ITASK_INTERFACE

	IPROVIDE_TASK_PAGE_INTERFACE

	IPERSIST_FILE_INTERFACE

	ECOM_QUERIABLE

create
	make_from_other,
	make_from_pointer

feature {NONE}  -- Initialization

	make_from_pointer (a_object: POINTER)
			-- Make from pointer
		do
			initializer := ccom_create_ctask_coclass_from_pointer(a_object)
			item := ccom_item (initializer)
		end

feature -- Basic Operations

	create_trigger (pi_new_trigger: INTEGER_REF; pp_trigger: CELL [ITASK_TRIGGER_INTERFACE])
			-- Creates a trigger using a work item object.
			-- `pi_new_trigger' [out].  
			-- `pp_trigger' [out].  
		do
			ccom_create_trigger (initializer, pi_new_trigger, pp_trigger)
		end

	delete_trigger (i_trigger: INTEGER)
			-- Deletes a trigger from a work item. 
			-- `i_trigger' [in].  
		do
			ccom_delete_trigger (initializer, i_trigger)
		end

	get_trigger_count (pw_count: INTEGER_REF)
			-- Retrieves the number of triggers associated with a work item.
			-- `pw_count' [out].  
		do
			ccom_get_trigger_count (initializer, pw_count)
		end

	get_trigger (i_trigger: INTEGER; pp_trigger: CELL [ITASK_TRIGGER_INTERFACE])
			-- Retrieves a trigger structure.
			-- `i_trigger' [in].  
			-- `pp_trigger' [out].  
		do
			ccom_get_trigger (initializer, i_trigger, pp_trigger)
		end

	get_trigger_string (i_trigger: INTEGER; ppwsz_trigger: CELL [STRING])
			-- Retrieves a trigger string.
			-- `i_trigger' [in].  
			-- `ppwsz_trigger' [out].  
		do
			ccom_get_trigger_string (initializer, i_trigger, ppwsz_trigger)
		end

	get_run_times (pst_begin: X_SYSTEMTIME_RECORD; pst_end: X_SYSTEMTIME_RECORD; p_count: INTEGER_REF; rgst_task_times: CELL [X_SYSTEMTIME_RECORD])
			-- Retrieves the work item run times for a specified time period.
			-- `pst_begin' [in].  
			-- `pst_end' [in].  
			-- `p_count' [in, out].  
			-- `rgst_task_times' [out].  
		do
			ccom_get_run_times (initializer, pst_begin.item, pst_end.item, p_count, rgst_task_times)
		end

	get_next_run_time (pst_next_run: X_SYSTEMTIME_RECORD)
			-- Retrieves the next time the work item will run.
			-- `pst_next_run' [in, out].  
		do
			ccom_get_next_run_time (initializer, pst_next_run.item)
		end

	set_idle_wait (w_idle_minutes: INTEGER; w_deadline_minutes: INTEGER)
			-- Sets the idle wait time for the work item.
			-- `w_idle_minutes' [in].  
			-- `w_deadline_minutes' [in].  
		do
			ccom_set_idle_wait (initializer, w_idle_minutes, w_deadline_minutes)
		end

	get_idle_wait (pw_idle_minutes: INTEGER_REF; pw_deadline_minutes: INTEGER_REF)
			-- Retrieves the idle wait time for the work item.
			-- `pw_idle_minutes' [out].  
			-- `pw_deadline_minutes' [out].  
		do
			ccom_get_idle_wait (initializer, pw_idle_minutes, pw_deadline_minutes)
		end

	run
			-- Runs the work item.
		do
			ccom_run (initializer)
		end

	terminate
			-- Ends the execution of the work item.
		do
			ccom_terminate (initializer)
		end

	edit_work_item (h_parent: POINTER; dw_reserved: INTEGER)
			-- Opens the configuration properties for the work item.
			-- `h_parent' [in].  
			-- `dw_reserved' [in].  
		do
			ccom_edit_work_item (initializer, h_parent, dw_reserved)
		end

	get_most_recent_run_time (pst_last_run: X_SYSTEMTIME_RECORD)
			-- Retrieves the most recent time the work item began running.
			-- `pst_last_run' [out].  
		do
			ccom_get_most_recent_run_time (initializer, pst_last_run.item)
		end

	get_status (phr_status: ECOM_HRESULT)
			-- Retrieves the status of the work item.
			-- `phr_status' [out].  
		do
			ccom_get_status (initializer, phr_status)
		end

	get_exit_code (pdw_exit_code: INTEGER_REF)
			-- Retrieves the work item's last exit code.
			-- `pdw_exit_code' [out].  
		do
			ccom_get_exit_code (initializer, pdw_exit_code)
		end

	set_comment (pwsz_comment: STRING)
			-- Sets the comment for the work item.
			-- `pwsz_comment' [in].  
		do
			ccom_set_comment (initializer, pwsz_comment)
		end

	get_comment (ppwsz_comment: CELL [STRING])
			-- Retrieves the comment for the work item.
			-- `ppwsz_comment' [out].  
		do
			ccom_get_comment (initializer, ppwsz_comment)
		end

	set_creator (pwsz_creator: STRING)
			-- Sets the creator of the work item.
			-- `pwsz_creator' [in].  
		do
			ccom_set_creator (initializer, pwsz_creator)
		end

	get_creator (ppwsz_creator: CELL [STRING])
			-- Retrieves the creator of the work item.
			-- `ppwsz_creator' [out].  
		do
			ccom_get_creator (initializer, ppwsz_creator)
		end

	set_work_item_data (cb_data: INTEGER; rgb_data: CHARACTER_REF)
			-- Stores application-defined data associated with the work item.
			-- `cb_data' [in].  
			-- `rgb_data' [in].  
		do
			ccom_set_work_item_data (initializer, cb_data, rgb_data)
		end

	get_work_item_data (pcb_data: INTEGER_REF; prgb_data: CELL [CHARACTER_REF])
			-- Retrieves application-defined data associated with the work item.
			-- `pcb_data' [out].  
			-- `prgb_data' [out].  
		do
			ccom_get_work_item_data (initializer, pcb_data, prgb_data)
		end

	set_error_retry_count (w_retry_count: INTEGER)
			-- Not currently implemented.
			-- `w_retry_count' [in].  
		do
			ccom_set_error_retry_count (initializer, w_retry_count)
		end

	get_error_retry_count (pw_retry_count: INTEGER_REF)
			-- Not currently implemented.
			-- `pw_retry_count' [out].  
		do
			ccom_get_error_retry_count (initializer, pw_retry_count)
		end

	set_error_retry_interval (w_retry_interval: INTEGER)
			-- Not currently implemented.
			-- `w_retry_interval' [in].  
		do
			ccom_set_error_retry_interval (initializer, w_retry_interval)
		end

	get_error_retry_interval (pw_retry_interval: INTEGER_REF)
			-- Not currently implemented.
			-- `pw_retry_interval' [out].  
		do
			ccom_get_error_retry_interval (initializer, pw_retry_interval)
		end

	set_flags (dw_flags: INTEGER)
			-- Sets the flags that modify the behavior of the work item.
			-- `dw_flags' [in].  
		do
			ccom_set_flags (initializer, dw_flags)
		end

	get_flags (pdw_flags: INTEGER_REF)
			-- Retrieves the flags that modify the behavior of the work item.
			-- `pdw_flags' [out].  
		do
			ccom_get_flags (initializer, pdw_flags)
		end

	set_account_information (pwsz_account_name: STRING; pwsz_password: STRING)
			-- Sets the account name and password for the work item.
			-- `pwsz_account_name' [in].  
			-- `pwsz_password' [in].  
		do
			ccom_set_account_information (initializer, pwsz_account_name, pwsz_password)
		end

	get_account_information (ppwsz_account_name: CELL [STRING])
			-- Retrieves the account name for the work item.
			-- `ppwsz_account_name' [out].  
		do
			ccom_get_account_information (initializer, ppwsz_account_name)
		end

	set_application_name (pwsz_application_name: STRING)
			-- Assigns a specific application to the current task.
			-- `pwsz_application_name' [in].  
		do
			ccom_set_application_name (initializer, pwsz_application_name)
		end

	get_application_name (ppwsz_application_name: CELL [STRING])
			-- Retrieves the name of the application that the task is associated with.
			-- `ppwsz_application_name' [out].  
		do
			ccom_get_application_name (initializer, ppwsz_application_name)
		end

	set_parameters (pwsz_parameters: STRING)
			-- Sets the command-line parameters for the task.
			-- `pwsz_parameters' [in].  
		do
			ccom_set_parameters (initializer, pwsz_parameters)
		end

	get_parameters (ppwsz_parameters: CELL [STRING])
			-- Retrieves the command-line parameters of a task.
			-- `ppwsz_parameters' [out].  
		do
			ccom_get_parameters (initializer, ppwsz_parameters)
		end

	set_working_directory (pwsz_working_directory: STRING)
			-- Sets the working directory for the task.
			-- `pwsz_working_directory' [in].  
		do
			ccom_set_working_directory (initializer, pwsz_working_directory)
		end

	get_working_directory (ppwsz_working_directory: CELL [STRING])
			-- Retrieves the working directory of the task.
			-- `ppwsz_working_directory' [out].  
		do
			ccom_get_working_directory (initializer, ppwsz_working_directory)
		end

	set_priority (dw_priority: INTEGER)
			-- Sets the priority for the task.
			-- `dw_priority' [in].  
		do
			ccom_set_priority (initializer, dw_priority)
		end

	get_priority (pdw_priority: INTEGER_REF)
			-- Retrieves the priority for the task.
			-- `pdw_priority' [out].  
		do
			ccom_get_priority (initializer, pdw_priority)
		end

	set_task_flags (dw_flags: INTEGER)
			-- Sets the flags that modify the behavior of the task.
			-- `dw_flags' [in].  
		do
			ccom_set_task_flags (initializer, dw_flags)
		end

	get_task_flags (pdw_flags: INTEGER_REF)
			-- Returns the flags used to modify the behavior of the task.
			-- `pdw_flags' [out].  
		do
			ccom_get_task_flags (initializer, pdw_flags)
		end

	set_max_run_time (dw_max_run_time_ms: INTEGER)
			-- Sets the maximum length of time the task can run.
			-- `dw_max_run_time_ms' [in].  
		do
			ccom_set_max_run_time (initializer, dw_max_run_time_ms)
		end

	get_max_run_time (pdw_max_run_time_ms: INTEGER_REF)
			-- Retrieves the maximum length of time the task can run.
			-- `pdw_max_run_time_ms' [out].  
		do
			ccom_get_max_run_time (initializer, pdw_max_run_time_ms)
		end

	get_page (tp_type: INTEGER; f_persist_changes: INTEGER; ph_page: CELL [POINTER])
			-- Retrieves the property sheet pages associated with a task.
			-- `tp_type' [in]. See ECOM_X_TASKPAGE_ENUM for possible `tp_type' values. 
			-- `f_persist_changes' [in].  
			-- `ph_page' [out].  
		do
			ccom_get_page (initializer, tp_type, f_persist_changes, ph_page)
		end

	get_class_id (p_class_id: ECOM_GUID)
			-- `p_class_id' [out].  
		do
			ccom_get_class_id (initializer, p_class_id.item)
		end

	is_dirty
			-- 
		do
			ccom_is_dirty (initializer)
		end

	load (psz_file_name: STRING; dw_mode: INTEGER)
			-- `psz_file_name' [in].  
			-- `dw_mode' [in].  
		do
			ccom_load (initializer, psz_file_name, dw_mode)
		end

	save (psz_file_name: STRING; f_remember: INTEGER)
			-- `psz_file_name' [in].  
			-- `f_remember' [in].  
		do
			ccom_save (initializer, psz_file_name, f_remember)
		end

	save_completed (psz_file_name: STRING)
			-- `psz_file_name' [in].  
		do
			ccom_save_completed (initializer, psz_file_name)
		end

	get_cur_file (ppsz_file_name: CELL [STRING])
			-- `ppsz_file_name' [out].  
		do
			ccom_get_cur_file (initializer, ppsz_file_name)
		end

feature {NONE}  -- Implementation

	delete_wrapper
			-- Delete wrapper
		do
			ccom_delete_ctask_coclass(initializer)
		end

feature {NONE}  -- Externals

	ccom_create_trigger (a_object: POINTER; pi_new_trigger: INTEGER_REF; pp_trigger: CELL [ITASK_TRIGGER_INTERFACE])
			-- Creates a trigger using a work item object.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT,EIF_OBJECT)"
		end

	ccom_delete_trigger (a_object: POINTER; i_trigger: INTEGER)
			-- Deletes a trigger from a work item. 
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER)"
		end

	ccom_get_trigger_count (a_object: POINTER; pw_count: INTEGER_REF)
			-- Retrieves the number of triggers associated with a work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_get_trigger (a_object: POINTER; i_trigger: INTEGER; pp_trigger: CELL [ITASK_TRIGGER_INTERFACE])
			-- Retrieves a trigger structure.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER,EIF_OBJECT)"
		end

	ccom_get_trigger_string (a_object: POINTER; i_trigger: INTEGER; ppwsz_trigger: CELL [STRING])
			-- Retrieves a trigger string.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER,EIF_OBJECT)"
		end

	ccom_get_run_times (a_object: POINTER; pst_begin: POINTER; pst_end: POINTER; p_count: INTEGER_REF; rgst_task_times: CELL [X_SYSTEMTIME_RECORD])
			-- Retrieves the work item run times for a specified time period.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](ecom_MS_TaskSched_lib::_SYSTEMTIME *,ecom_MS_TaskSched_lib::_SYSTEMTIME *,EIF_OBJECT,EIF_OBJECT)"
		end

	ccom_get_next_run_time (a_object: POINTER; pst_next_run: POINTER)
			-- Retrieves the next time the work item will run.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](ecom_MS_TaskSched_lib::_SYSTEMTIME *)"
		end

	ccom_set_idle_wait (a_object: POINTER; w_idle_minutes: INTEGER; w_deadline_minutes: INTEGER)
			-- Sets the idle wait time for the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER,EIF_INTEGER)"
		end

	ccom_get_idle_wait (a_object: POINTER; pw_idle_minutes: INTEGER_REF; pw_deadline_minutes: INTEGER_REF)
			-- Retrieves the idle wait time for the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT,EIF_OBJECT)"
		end

	ccom_run (a_object: POINTER)
			-- Runs the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"]()"
		end

	ccom_terminate (a_object: POINTER)
			-- Ends the execution of the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"]()"
		end

	ccom_edit_work_item (a_object: POINTER; h_parent: POINTER; dw_reserved: INTEGER)
			-- Opens the configuration properties for the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_POINTER,EIF_INTEGER)"
		end

	ccom_get_most_recent_run_time (a_object: POINTER; pst_last_run: POINTER)
			-- Retrieves the most recent time the work item began running.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](ecom_MS_TaskSched_lib::_SYSTEMTIME *)"
		end

	ccom_get_status (a_object: POINTER; phr_status: ECOM_HRESULT)
			-- Retrieves the status of the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_get_exit_code (a_object: POINTER; pdw_exit_code: INTEGER_REF)
			-- Retrieves the work item's last exit code.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_comment (a_object: POINTER; pwsz_comment: STRING)
			-- Sets the comment for the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_get_comment (a_object: POINTER; ppwsz_comment: CELL [STRING])
			-- Retrieves the comment for the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_creator (a_object: POINTER; pwsz_creator: STRING)
			-- Sets the creator of the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_get_creator (a_object: POINTER; ppwsz_creator: CELL [STRING])
			-- Retrieves the creator of the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_work_item_data (a_object: POINTER; cb_data: INTEGER; rgb_data: CHARACTER_REF)
			-- Stores application-defined data associated with the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER,EIF_OBJECT)"
		end

	ccom_get_work_item_data (a_object: POINTER; pcb_data: INTEGER_REF; prgb_data: CELL [CHARACTER_REF])
			-- Retrieves application-defined data associated with the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT,EIF_OBJECT)"
		end

	ccom_set_error_retry_count (a_object: POINTER; w_retry_count: INTEGER)
			-- Not currently implemented.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER)"
		end

	ccom_get_error_retry_count (a_object: POINTER; pw_retry_count: INTEGER_REF)
			-- Not currently implemented.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_error_retry_interval (a_object: POINTER; w_retry_interval: INTEGER)
			-- Not currently implemented.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER)"
		end

	ccom_get_error_retry_interval (a_object: POINTER; pw_retry_interval: INTEGER_REF)
			-- Not currently implemented.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_flags (a_object: POINTER; dw_flags: INTEGER)
			-- Sets the flags that modify the behavior of the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER)"
		end

	ccom_get_flags (a_object: POINTER; pdw_flags: INTEGER_REF)
			-- Retrieves the flags that modify the behavior of the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_account_information (a_object: POINTER; pwsz_account_name: STRING; pwsz_password: STRING)
			-- Sets the account name and password for the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT,EIF_OBJECT)"
		end

	ccom_get_account_information (a_object: POINTER; ppwsz_account_name: CELL [STRING])
			-- Retrieves the account name for the work item.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_application_name (a_object: POINTER; pwsz_application_name: STRING)
			-- Assigns a specific application to the current task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_get_application_name (a_object: POINTER; ppwsz_application_name: CELL [STRING])
			-- Retrieves the name of the application that the task is associated with.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_parameters (a_object: POINTER; pwsz_parameters: STRING)
			-- Sets the command-line parameters for the task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_get_parameters (a_object: POINTER; ppwsz_parameters: CELL [STRING])
			-- Retrieves the command-line parameters of a task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_working_directory (a_object: POINTER; pwsz_working_directory: STRING)
			-- Sets the working directory for the task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_get_working_directory (a_object: POINTER; ppwsz_working_directory: CELL [STRING])
			-- Retrieves the working directory of the task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_priority (a_object: POINTER; dw_priority: INTEGER)
			-- Sets the priority for the task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER)"
		end

	ccom_get_priority (a_object: POINTER; pdw_priority: INTEGER_REF)
			-- Retrieves the priority for the task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_task_flags (a_object: POINTER; dw_flags: INTEGER)
			-- Sets the flags that modify the behavior of the task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER)"
		end

	ccom_get_task_flags (a_object: POINTER; pdw_flags: INTEGER_REF)
			-- Returns the flags used to modify the behavior of the task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_set_max_run_time (a_object: POINTER; dw_max_run_time_ms: INTEGER)
			-- Sets the maximum length of time the task can run.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER)"
		end

	ccom_get_max_run_time (a_object: POINTER; pdw_max_run_time_ms: INTEGER_REF)
			-- Retrieves the maximum length of time the task can run.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_get_page (a_object: POINTER; tp_type: INTEGER; f_persist_changes: INTEGER; ph_page: CELL [POINTER])
			-- Retrieves the property sheet pages associated with a task.
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_INTEGER,EIF_INTEGER,EIF_OBJECT)"
		end

	ccom_get_class_id (a_object: POINTER; p_class_id: POINTER)
			-- 
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](GUID *)"
		end

	ccom_is_dirty (a_object: POINTER)
			-- 
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"]()"
		end

	ccom_load (a_object: POINTER; psz_file_name: STRING; dw_mode: INTEGER)
			-- 
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT,EIF_INTEGER)"
		end

	ccom_save (a_object: POINTER; psz_file_name: STRING; f_remember: INTEGER)
			-- 
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT,EIF_INTEGER)"
		end

	ccom_save_completed (a_object: POINTER; psz_file_name: STRING)
			-- 
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_get_cur_file (a_object: POINTER; ppsz_file_name: CELL [STRING])
			-- 
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](EIF_OBJECT)"
		end

	ccom_delete_ctask_coclass (a_pointer: POINTER)
			-- Release resource
		external
			"C++ [delete ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"]()"
		end

	ccom_create_ctask_coclass_from_pointer (a_pointer: POINTER): POINTER
			-- Create from pointer
		external
			"C++ [new ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](IUnknown *)"
		end

	ccom_item (a_object: POINTER): POINTER
			-- Item
		external
			"C++ [ecom_MS_TaskSched_lib::CTask %"ecom_MS_TaskSched_lib_CTask.h%"](): EIF_POINTER"
		end

end -- CTASK_PROXY


