/*
 * Code for class PROCESS_UNIX_PROCESS_MANAGER
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pr254.h"
#include <string.h>
#include "eif_built_in.h"
#include <unistd.h>
#include "eif_process.h"
#include <sys/types.h>
#include "eif_except.h"
#include "eif_memory.h"
#include "eif_main.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F331_3329
static EIF_INTEGER_32 inline_F331_3329 (EIF_INTEGER_32 arg1)
{
	return (EIF_INTEGER_32) (WEXITSTATUS(arg1))
	;
}
#define INLINE_F331_3329
#endif
#ifndef INLINE_F132_1588
static void inline_F132_1588 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	{
  pid_t rc;
  int status;
  
  rc = waitpid((pid_t) arg1, &status, (arg2 ? 0 : WNOHANG) | WUNTRACED);
  *(EIF_BOOLEAN *) arg5 = (rc != -1);
  if (rc != -1) {				    
	  if (rc == 0) { /* No process has status to report yet */
	    *(EIF_BOOLEAN *) arg3 = EIF_FALSE;
	  } else { /* Process reported status */
	    *(EIF_BOOLEAN *) arg3 = EIF_TRUE;
	  }
	  *(EIF_INTEGER *) arg4 = (EIF_INTEGER) status;
  }
}
	;
}
#define INLINE_F132_1588
#endif
#ifndef INLINE_F331_3330
static int inline_F331_3330 (EIF_INTEGER_32 arg1)
{
	return (int) (WIFEXITED(arg1))
	;
}
#define INLINE_F331_3330
#endif
#ifndef INLINE_F331_3331
static int inline_F331_3331 (EIF_INTEGER_32 arg1)
{
	return (int) (WIFSIGNALED(arg1))
	;
}
#define INLINE_F331_3331
#endif
#ifndef INLINE_F65_759
static int inline_F65_759 (void)
{
	#ifdef WORKBENCH
	return EIF_TEST(is_debug_mode());
#else
	return EIF_FALSE;
#endif
	;
}
#define INLINE_F65_759
#endif
#ifndef INLINE_F65_758
static void inline_F65_758 (EIF_BOOLEAN arg1)
{
	#ifdef WORKBENCH
	set_debug_mode (arg1 ? 1 : 0);
#endif
	;
}
#define INLINE_F65_758
#endif
#ifndef INLINE_F132_1578
static void inline_F132_1578 (void)
{
	{
	setpgid (0, 0);
}
	;
}
#define INLINE_F132_1578
#endif
#ifndef INLINE_F132_1593
static void inline_F132_1593 (EIF_INTEGER_32 arg1)
{
	{
	pid_t pgid = getpgid (arg1);
	tcsetpgrp (1, pgid);
	tcsetpgrp (2, pgid);
}
	;
}
#define INLINE_F132_1593
#endif
#ifndef INLINE_F132_1574
static void inline_F132_1574 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
  int rc;
  rc = dup2(arg1, arg2);
  if (rc < 0) {
	    eraise(Strerror(errno), EN_SYS);
  }
}
	;
}
#define INLINE_F132_1574
#endif
#ifndef INLINE_F132_1575
static void inline_F132_1575 (EIF_INTEGER_32 arg1)
{
	{
	 int rc;
	  rc = close(arg1);
	  if (rc != 0) {
	    eraise(Strerror(errno), EN_SYS);
	  }
}
	;
}
#define INLINE_F132_1575
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PROCESS_UNIX_PROCESS_MANAGER}.make */
void F331_3272 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_REFERENCE arg3)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg3);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLR(4,arg2);
	RTLIU(5);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg3 != NULL)) {
		tr1 = RTLNSMART(eif_new_type(866, 0).id);
		F867_4977(RTCW(tr1), arg3);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	} else {
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) NULL;
	}
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_4_) = (EIF_REFERENCE) arg1;
	F331_3284(Current, arg2);
	*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	tr1 = RTMS_EX_H("",0,0);
	F331_3286(Current, tr1);
	tr1 = RTMS_EX_H("",0,0);
	F331_3287(Current, tr1);
	tr1 = RTMS_EX_H("",0,0);
	F331_3288(Current, tr1);
	F331_3334(Current, (EIF_BOOLEAN) 0);
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.exit_code */
EIF_INTEGER_32 F331_3275 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	if ((EIF_BOOLEAN) ((EIF_BOOLEAN) ((EIF_BOOLEAN) !*(EIF_BOOLEAN *)(Current+ _CHROFF_15_1_) && *(EIF_BOOLEAN *)(Current+ _CHROFF_15_0_)) && *(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_))) {
		ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_);
		RTLE;
		return (EIF_INTEGER_32) inline_F331_3329(ti4_1);
	}
	RTLE;
	return (EIF_INTEGER_32) 0;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_arguments */
void F331_3284 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,loc1);
	RTLR(2,Current);
	RTLR(3,loc2);
	RTLR(4,tr1);
	RTLIU(5);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != NULL)) {
		{
			static EIF_TYPE_INDEX typarr0[] = {842,0xFF01,978,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
			loc1 = RTLNSMART(typres0.id);
		}
		F843_4769(RTCW(loc1), ((EIF_INTEGER_32) 0L));
		loc2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R3398[Dtype(RTCW(arg1))-424])(arg1);
		for (;;) {
			tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R3321[Dtype(loc2)-401])(loc2);
			if (tb1) break;
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R3320[Dtype(loc2)-401])(loc2);
			tr1 = F1_14(tr1);
			F843_4810(RTCW(loc1), tr1);
			(FUNCTION_CAST(void, (EIF_REFERENCE)) R3322[Dtype(loc2)-401])(loc2);
		}
	}
	RTAR(Current, loc1);
	*(EIF_REFERENCE *)(Current + _REFACS_5_) = (EIF_REFERENCE) loc1;
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_close_nonstandard_files */
void F331_3285 (EIF_REFERENCE Current, EIF_BOOLEAN arg1)
{
	GTCX
	
	
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_6_) = (EIF_BOOLEAN) arg1;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_input_file_name */
void F331_3286 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_6_) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_7_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_output_file_name */
void F331_3287 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_7_) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_8_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_error_file_name */
void F331_3288 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_8_) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_error_same_as_output */
void F331_3289 (EIF_REFERENCE Current)
{
	GTCX
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
	*(EIF_REFERENCE *)(Current + _REFACS_8_) = (EIF_REFERENCE) NULL;
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.wait_for_process */
void F331_3290 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc2 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc3 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	inline_F132_1588(arg1, arg2, (EIF_BOOLEAN *) &(loc2), (EIF_INTEGER_32 *) &(loc1), (EIF_BOOLEAN *) &(loc3));
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_0_) = (EIF_BOOLEAN) loc3;
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_0_)) {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_) = (EIF_BOOLEAN) loc2;
		*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_) = (EIF_INTEGER_32) loc1;
		tb1 = '\0';
		if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_)) {
			tb2 = '\01';
			ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_);
			if (!EIF_TEST (inline_F331_3330(ti4_1))) {
				ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_);
				tb2 = EIF_TEST (inline_F331_3331(ti4_1));
			}
			tb1 = tb2;
		}
		if (tb1) {
			F331_3334(Current, (EIF_BOOLEAN) 0);
		} else {
			F331_3334(Current, (EIF_BOOLEAN) 1);
		}
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
		F331_3334(Current, (EIF_BOOLEAN) 0);
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.close_pipes */
void F331_3291 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLIU(5);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		F339_3554(loc1);
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		F339_3553(loc2);
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		F339_3553(loc3);
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.spawn_nowait */
#undef EIF_VOLATILE
#define EIF_VOLATILE volatile
void F331_3292 (EIF_REFERENCE Current, EIF_BOOLEAN arg1, EIF_REFERENCE arg2, EIF_BOOLEAN arg3)
{
	GTCX
	RTEX;
	RTED;
	EIF_REFERENCE EIF_VOLATILE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE loc2 = (EIF_REFERENCE) 0;
	EIF_BOOLEAN EIF_VOLATILE loc3 = (EIF_BOOLEAN) 0;
	EIF_REFERENCE EIF_VOLATILE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE saved_except = (EIF_REFERENCE) 0;
	EIF_POINTER  EIF_VOLATILE tp1;
	EIF_REFERENCE  EIF_VOLATILE tr1 = NULL;
	EIF_INTEGER_32  EIF_VOLATILE ti4_1;
	EIF_BOOLEAN  EIF_VOLATILE tb1;
	RTLD;
	RTXD;
	
	RTLI(8);
	RTLR(0,loc5);
	RTLR(1,Current);
	RTLR(2,loc1);
	RTLR(3,loc4);
	RTLR(4,loc2);
	RTLR(5,tr1);
	RTLR(6,arg2);
	RTLR(7,saved_except);
	RTLIU(8);
	RTXSLS;
	
	RTEV;
	RTGC;
	RTE_T
	loc5 = F331_3314(Current);
	RTAR(Current, loc5);
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) loc5;
	F331_3315(Current);
	loc1 = RTLNS(eif_new_type(327, 0x01).id, 327, _OBJSIZ_0_0_0_1_0_0_0_0_);
	loc4 = *(EIF_REFERENCE *)(Current);
	if ((EIF_BOOLEAN)(loc4 != NULL)) {
		loc2 = F328_3234(RTCW(loc1));
		F328_3250(RTCW(loc1), loc4);
	}
	loc3 = EIF_TEST (inline_F65_759());
	F65_757(Current);
	ti4_1 = F132_1577(Current);
	*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) = (EIF_INTEGER_32) ti4_1;
	switch (*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_)) {
		case -1L:
			inline_F65_758(loc3);
			if ((EIF_BOOLEAN)(loc2 != NULL)) {
				F328_3250(RTCW(loc1), loc2);
			}
			break;
		case 0L:
			eif_gc_stop();
			if (arg3) {
				inline_F132_1578();
				if (arg1) {
					ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_);
					inline_F132_1593(ti4_1);
				}
			}
			F331_3317(Current);
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_4_);
			tb1 = *(EIF_BOOLEAN *)(Current+ _CHROFF_15_6_);
			tp1 = F331_3325(Current, arg2);
			F132_1579(Current, tr1, loc5, tb1, tp1);
			break;
		default:
			inline_F65_758(loc3);
			F331_3316(Current);
			*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
			F331_3334(Current, (EIF_BOOLEAN) 1);
			if ((EIF_BOOLEAN)(loc2 != NULL)) {
				F328_3250(RTCW(loc1), loc2);
			}
			break;
	}
	RTE_E
	RTXSC;
	if ((EIF_BOOLEAN)(*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) == ((EIF_INTEGER_32) 0L))) {
		tr1 = RTLNS(eif_new_type(229, 0x01).id, 229, _OBJSIZ_0_0_0_0_0_0_0_0_);
		esdie(((EIF_INTEGER_32) 1L));
	}
	inline_F65_758(loc3);
	/* NOTREACHED */
	RTE_EE
	RTEOK;
	RTLE;
}
#undef EIF_VOLATILE
#define EIF_VOLATILE

/* {PROCESS_UNIX_PROCESS_MANAGER}.read_output_to_special */
void F331_3295 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		F339_3580(loc1, arg1);
		tb1 = *(EIF_BOOLEAN *)(loc1+ _CHROFF_2_1_);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_4_) = (EIF_BOOLEAN) (EIF_BOOLEAN) !tb1;
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_4_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		F754_4528(RTCW(arg1));
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.read_error_to_special */
void F331_3297 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		F339_3580(loc1, arg1);
		tb1 = *(EIF_BOOLEAN *)(loc1+ _CHROFF_2_1_);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_5_) = (EIF_BOOLEAN) (EIF_BOOLEAN) !tb1;
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_5_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		F754_4528(RTCW(arg1));
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.built_argument_list */
EIF_REFERENCE F331_3314 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTCFDT;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLR(4,loc3);
	RTLIU(5);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_5_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		{
			static EIF_TYPE_INDEX typarr0[] = {771,0xFF01,978,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(dftype, typarr0)));
			Result = RTLNSMART(typres0.id);
		}
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_4_);
		ti4_1 = F843_4790(loc2);
		F772_4579(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
		loc3 = F843_4783(loc2);
		loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		for (;;) {
			tb1 = F477_3971(loc3);
			if (tb1) break;
			tr1 = F477_3962(loc3);
			F772_4603(RTCW(Result), tr1, loc1);
			loc1++;
			F477_3977(loc3);
		}
	} else {
		{
			static EIF_TYPE_INDEX typarr0[] = {771,0xFF01,978,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(dftype, typarr0)));
			Result = RTLNSMART(typres0.id);
		}
		F772_4579(RTCW(Result), *(EIF_REFERENCE *)(Current + _REFACS_4_), ((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 1L));
		RTLE;
		return (EIF_REFERENCE) Result;
	}
	RTLE;
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.open_files_and_pipes */
void F331_3315 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(6);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLIU(6);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(132, 0x01).id, 132, _OBJSIZ_0_0_0_0_0_0_0_0_);
	*(EIF_REFERENCE *)(Current + _REFACS_12_) = (EIF_REFERENCE) NULL;
	*(EIF_REFERENCE *)(Current + _REFACS_9_) = (EIF_REFERENCE) NULL;
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_7_)) {
		tr1 = F133_1594(RTCW(loc1));
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current + _REFACS_12_) = (EIF_REFERENCE) tr1;
	} else {
		loc2 = *(EIF_REFERENCE *)(Current + _REFACS_6_);
		tb1 = '\0';
		if ((EIF_BOOLEAN)(loc2 != NULL)) {
			tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R4938[Dtype(RTCW(loc2))-982])(loc2);
			tb1 = (EIF_BOOLEAN) !tb2;
		}
		if (tb1) {
			tr1 = RTLNSMART(eif_new_type(732, 0).id);
			F732_4141(RTCW(tr1), loc2);
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_9_) = (EIF_REFERENCE) tr1;
		}
	}
	*(EIF_REFERENCE *)(Current + _REFACS_13_) = (EIF_REFERENCE) NULL;
	*(EIF_REFERENCE *)(Current + _REFACS_10_) = (EIF_REFERENCE) NULL;
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_8_)) {
		tr1 = F133_1594(RTCW(loc1));
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current + _REFACS_13_) = (EIF_REFERENCE) tr1;
	} else {
		loc3 = *(EIF_REFERENCE *)(Current + _REFACS_7_);
		tb1 = '\0';
		if ((EIF_BOOLEAN)(loc3 != NULL)) {
			tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R4938[Dtype(RTCW(loc3))-982])(loc3);
			tb1 = (EIF_BOOLEAN) !tb2;
		}
		if (tb1) {
			tr1 = RTLNSMART(eif_new_type(732, 0).id);
			F732_4143(RTCW(tr1), loc3);
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_10_) = (EIF_REFERENCE) tr1;
		}
	}
	*(EIF_REFERENCE *)(Current + _REFACS_14_) = (EIF_REFERENCE) NULL;
	*(EIF_REFERENCE *)(Current + _REFACS_11_) = (EIF_REFERENCE) NULL;
	if ((EIF_BOOLEAN) !*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_)) {
			tr1 = F133_1594(RTCW(loc1));
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_14_) = (EIF_REFERENCE) tr1;
		} else {
			loc4 = *(EIF_REFERENCE *)(Current + _REFACS_8_);
			tb1 = '\0';
			if ((EIF_BOOLEAN)(loc4 != NULL)) {
				tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R4938[Dtype(RTCW(loc4))-982])(loc4);
				tb1 = (EIF_BOOLEAN) !tb2;
			}
			if (tb1) {
				tr1 = RTLNSMART(eif_new_type(732, 0).id);
				F732_4143(RTCW(tr1), loc4);
				RTAR(Current, tr1);
				*(EIF_REFERENCE *)(Current + _REFACS_11_) = (EIF_REFERENCE) tr1;
			}
		}
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.setup_parent_process_files */
void F331_3316 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLR(6,loc5);
	RTLR(7,loc6);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		F339_3553(loc1);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_9_);
		loc2 = tr1;
		if (EIF_TEST(loc2)) {
			F732_4226(loc2);
		}
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		F339_3554(loc3);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_10_);
		loc4 = tr1;
		if (EIF_TEST(loc4)) {
			F732_4226(loc4);
		}
	}
	if ((EIF_BOOLEAN) !*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
		loc5 = tr1;
		if (EIF_TEST(loc5)) {
			F339_3554(loc5);
		} else {
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_11_);
			loc6 = tr1;
			if (EIF_TEST(loc6)) {
				F732_4226(loc6);
			}
		}
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.setup_child_process_files */
void F331_3317 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLR(6,loc5);
	RTLR(7,loc6);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		ti4_1 = *(EIF_INTEGER_32 *)(loc1+ _LNGOFF_2_7_2_1_);
		F331_3318(Current, ti4_1, ((EIF_INTEGER_32) 0L));
		F339_3554(loc1);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_9_);
		loc2 = tr1;
		if (EIF_TEST(loc2)) {
			ti4_1 = F732_4153(loc2);
			F331_3318(Current, ti4_1, ((EIF_INTEGER_32) 0L));
		}
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		ti4_1 = *(EIF_INTEGER_32 *)(loc3+ _LNGOFF_2_7_2_2_);
		F331_3318(Current, ti4_1, ((EIF_INTEGER_32) 1L));
		F339_3553(loc3);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_10_);
		loc4 = tr1;
		if (EIF_TEST(loc4)) {
			ti4_1 = F732_4153(loc4);
			F331_3318(Current, ti4_1, ((EIF_INTEGER_32) 1L));
		}
	}
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		inline_F132_1574(((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 2L));
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
		loc5 = tr1;
		if (EIF_TEST(loc5)) {
			ti4_1 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_7_2_2_);
			F331_3318(Current, ti4_1, ((EIF_INTEGER_32) 2L));
			F339_3553(loc5);
		} else {
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_11_);
			loc6 = tr1;
			if (EIF_TEST(loc6)) {
				ti4_1 = F732_4153(loc6);
				F331_3318(Current, ti4_1, ((EIF_INTEGER_32) 2L));
			}
		}
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.move_desc */
void F331_3318 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != arg2)) {
		inline_F132_1574(arg1, arg2);
		inline_F132_1575(arg1);
	}
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.environment_table_as_pointer */
EIF_POINTER F331_3325 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc8 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc9 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc10 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_CHARACTER_32 tw1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(10);
	RTLR(0,arg1);
	RTLR(1,loc7);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,loc8);
	RTLR(5,loc9);
	RTLR(6,loc10);
	RTLR(7,loc6);
	RTLR(8,loc2);
	RTLR(9,Current);
	RTLIU(10);
	
	RTGC;
	tb1 = '\0';
	if ((EIF_BOOLEAN)(arg1 != NULL)) {
		tb2 = F670_4113(RTCW(arg1));
		tb1 = (EIF_BOOLEAN) !tb2;
	}
	if (tb1) {
		loc7 = F855_4850(RTCW(arg1));
		for (;;) {
			tb1 = F472_3959(loc7);
			if (tb1) break;
			tb2 = '\0';
			tr1 = F472_3957(loc7);
			if ((EIF_BOOLEAN)(tr1 != NULL)) {
				tr1 = F472_3956(loc7);
				tb2 = (EIF_BOOLEAN)(tr1 != NULL);
			}
			if (tb2) {
				loc5++;
			}
			F472_3960(loc7);
		}
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
		tp1 = malloc((size_t)(EIF_INTEGER_32) ((EIF_INTEGER_32) (loc5 + ((EIF_INTEGER_32) 1L)) * ti4_1));
		Result = (EIF_POINTER) tp1;
		loc1 = RTLNS(eif_new_type(319, 0x01).id, 319, _OBJSIZ_0_1_0_1_0_1_1_0_);
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
		F320_2951(RTCW(loc1), Result, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc5 + ((EIF_INTEGER_32) 1L)) * ti4_1));
		loc8 = F855_4850(RTCW(arg1));
		for (;;) {
			tb2 = F472_3959(loc8);
			if (tb2) break;
			tb3 = '\0';
			tr1 = F472_3957(loc8);
			loc9 = tr1;
			if ((EIF_TRUE)) {
				tr1 = F472_3956(loc8);
				loc10 = tr1;
				tb3 = (EIF_TRUE);
			}
			if (tb3) {
				loc6 = RTLNS(eif_new_type(983, 0x01).id, 983, _OBJSIZ_1_1_0_3_0_0_0_0_);
				ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R4960[Dtype(loc9)-982])(loc9);
				ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R4960[Dtype(loc10)-982])(loc10);
				F982_6445(RTCW(loc6), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ((EIF_INTEGER_32) 1L)));
				F984_6559(RTCW(loc6), loc9);
				tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '=';
				F984_6573(RTCW(loc6), tw1);
				F984_6559(RTCW(loc6), loc10);
				loc2 = RTLNS(eif_new_type(323, 0x01).id, 323, _OBJSIZ_1_0_0_1_0_0_0_0_);
				F324_3093(RTCW(loc2), loc6);
				ti4_1 = F324_3104(RTCW(loc2));
				tp1 = malloc((size_t)(EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
				loc3 = (EIF_POINTER) tp1;
				tp1 = F324_3100(RTCW(loc2));
				ti4_1 = F324_3104(RTCW(loc2));
				memcpy((void *)loc3, (const void *) tp1, (size_t) (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
				ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
				F320_2987(RTCW(loc1), loc3, (EIF_INTEGER_32) (loc4 * ti4_1));
				loc4++;
			}
			F472_3960(loc8);
		}
		{
			/* INLINED CODE (ANY.default_pointer) */
			tp1 = (EIF_POINTER)  0;
			/* END INLINED CODE */
		}
		tp2 = tp1;
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
		F320_2987(RTCW(loc1), tp2, (EIF_INTEGER_32) (loc4 * ti4_1));
	}
	RTLE;
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.exit_code_from_status */
EIF_INTEGER_32 F331_3329 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F331_3329 ((EIF_INTEGER_32) arg1);
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.terminate_flag_from_status */
EIF_BOOLEAN F331_3330 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F331_3330 ((EIF_INTEGER_32) arg1));
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.signaled_flag_from_status */
EIF_BOOLEAN F331_3331 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F331_3331 ((EIF_INTEGER_32) arg1));
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_is_executing */
void F331_3334 (EIF_REFERENCE Current, EIF_BOOLEAN arg1)
{
	GTCX
	
	
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_1_) = (EIF_BOOLEAN) arg1;
}

void EIF_Minit254 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
