note
	description: "A shell under the control %
		%of the Window manager - always %
		%so for Windows"
	legal: "See notice at end of class."
	status: "See notice at end of class.";
	date: "$Date: 2008-12-29 20:27:11 +0000 (Mon, 29 Dec 2008) $";
	revision: "$Revision: 76420 $"

class
	WM_SHELL_IMP

inherit
	WM_SHELL_I

	SHELL_IMP
		redefine
			default_style,
			on_menu_command,
			on_accelerator_command,
			on_paint,
			on_size,
			on_get_min_max_info,
			realize,
			class_name
		end

	WEL_DIB_COLORS_CONSTANTS
		export
			{NONE} all
		end

	WM_CONTROL_WINDOWS

feature -- Initialization

	realize
			-- Realize current widget
		do
			if not realized then
				realize_current
				realize_children
				set_enclosing_size
			end
		end

feature -- Access

	bar: BAR_IMP
			-- Menu bar

feature -- Status setting

	set_title (a_title: STRING)
			-- Set `title' to `a_title'.
		do
			if exists then
				wel_set_text (a_title)
			end
			private_title := a_title.twin
		end

	associate_bar (new_bar: BAR_IMP)
			-- Associate a menu bar to the widget.
		require
			bar_exists: new_bar /= Void
		do
			if bar = Void then
				shell_height := shell_height + menu_bar_height
			end
			bar := new_bar
			if exists then
				wel_set_menu (bar)
			end
		end

feature -- Removal

	remove_bar
			-- Remove the menu bar from the widget.
		require
			bar_present: bar /= Void
		do
			bar := Void
			if exists then
				unset_menu
			end
			shell_height := shell_height - menu_bar_height
		ensure
			bar_void: bar = Void
		end

feature {NONE} -- Implementation

	on_paint (paint_dc: WEL_PAINT_DC; invalid_rect: WEL_RECT)
			-- Wm_paint message.
			-- The invalid rectangle of the client area,
			-- `invalid_rect', needs repainting.
		local
			pixmap_windows: PIXMAP_IMP
			wel_dib: WEL_DIB
			wel_icon: WEL_ICON
			wel_bitmap: WEL_BITMAP
			draw_x, draw_y, h, w: INTEGER
		do
			if minimized then
				if icon_pixmap /= Void then
					pixmap_windows ?= icon_pixmap.implementation
					wel_dib := pixmap_windows.dib
					if wel_dib /= Void then
						create wel_bitmap.make_by_dib (paint_dc, wel_dib, dib_rgb_colors)
						h := icon_height - wel_dib.height
						if h > 0 then
							draw_y := h // 2
							h := wel_dib.height
						else
							h := icon_height
						end
						w := icon_width - wel_dib.width
						if w > 0 then
							draw_x := w // 2
							w := wel_dib.width
						else
							w := icon_width
						end
						paint_dc.draw_bitmap (wel_bitmap, draw_x, draw_y, w, h)
					else
						wel_icon := pixmap_windows.icon
						if wel_icon /= Void then
							paint_dc.draw_icon (wel_icon, 0, 0)
						end
					end
				end
			else
				expose_actions.execute (Current, Void)
			end
		end

	on_menu_command (menu_id: INTEGER)
			-- The `menu_id' has been choosen from the menu.
		do
			if popup_menu /= Void then
				popup_menu.execute (menu_id)
			else
				bar.execute (menu_id)
			end
		end

	on_accelerator_command (accelerator_id: INTEGER)
			-- The `acelerator_id' has been activated.
		do
			on_menu_command (accelerator_id)
		end

	on_size (size_type: INTEGER; a_width, a_height: INTEGER)
			-- Wm_size message
			-- See class WEL_SIZE_CONSTANTS for `size_type' value
		do
			resize_shell_children (a_width, a_height)
		end

	on_get_min_max_info (min_max_info: WEL_MIN_MAX_INFO)
		local
		 	track: WEL_POINT
		do
			create track.make (min_width + shell_width, min_height + shell_height)
			min_max_info.set_min_track_size (track)
			create track.make (max_width + shell_width, max_height + shell_height)
			min_max_info.set_max_track_size (track)
			Precursor (min_max_info)
		end


	default_style: INTEGER
			-- Default style for creation
		once
			Result := Ws_overlappedwindow + ws_visible
		end

	class_name: STRING_32
			-- Class name
		once
			Result := "EvisionWmShell"
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class WM_SHELL_IMP

