note
	description: "This class provides a mapping between Java and Eiffel objects"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2009-02-24 23:44:31 +0000 (Tue, 24 Feb 2009) $"
	revision: "$Revision: 77298 $"

class JAVA_OBJECT_TABLE

create
	make

feature {NONE} -- Initialization

	make
			-- Create a table for Eiffel proxies of Java object
		do
			create table.make (511)
		end

feature -- Access

	item (object: POINTER): detachable JAVA_OBJECT
			-- find a Eiffel proxy for an Java object
		require
			object_not_void: object /= default_pointer
		do
			Result := table.item (object)
		end

feature -- Element change

	put (object: JAVA_OBJECT)
			-- Add a new object to the table
		require
			object_not_void: object /= Void
			object_alive: object.exists
		local
			it: detachable JAVA_OBJECT
			ex: EXCEPTIONS
		do
			it := table.item (object.java_object_id)
			if it = Void then
				table.put (object, object.java_object_id)
			elseif (it /= object) then
				create ex
				ex.raise ("Attempted to insert duplicate Eiffel object")
			end
		ensure
			inserted: table.has (object.java_object_id)
		end

feature {NONE}

	table: HASH_TABLE [JAVA_OBJECT, POINTER]
			-- Table of objects

invariant
	table_not_void: table /= Void

note
	copyright:	"Copyright (c) 1984-2009, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			Eiffel Software
			5949 Hollister Ave., Goleta, CA 93117 USA
			Telephone 805-685-1006, Fax 805-685-6869
			Website http://www.eiffel.com
			Customer support http://support.eiffel.com
		]"




end

