note
	description: "Defines the invocation schedule of the trigger. Task Scheduler."
	generator: "Automatically generated by the EiffelCOM Wizard."

class
	X_TRIGGER_TYPE_UNION_UNION

inherit
	ECOM_STRUCTURE
		redefine
			make
		end

create
	make,
	make_from_pointer

feature {NONE}  -- Initialization

	make
			-- Make.
		do
			Precursor {ECOM_STRUCTURE}
		end

	make_from_pointer (a_pointer: POINTER)
			-- Make from pointer.
		do
			make_by_pointer (a_pointer)
		end

feature -- Access

	monthly_dow: X_MONTHLYDOW_RECORD
			-- 
		do
			Result := ccom_x_trigger_type_union_monthly_dow (item)
		ensure
			valid_monthly_dow: Result.item /= default_pointer
		end

	monthlyd_date: X_MONTHLYDATE_RECORD
			-- 
		do
			Result := ccom_x_trigger_type_union_monthlyd_date (item)
		ensure
			valid_monthlyd_date: Result.item /= default_pointer
		end

	weekly_interval: X_WEEKLY_RECORD
			-- 
		do
			Result := ccom_x_trigger_type_union_weekly_interval (item)
		ensure
			valid_weekly_interval: Result.item /= default_pointer
		end

	daily_interval: X_DAILY_RECORD
			-- 
		do
			Result := ccom_x_trigger_type_union_daily_interval (item)
		ensure
			valid_daily_interval: Result.item /= default_pointer
		end

feature -- Measurement

	structure_size: INTEGER
			-- Size of structure
		do
			Result := c_size_of_x_trigger_type_union
		end

feature -- Basic Operations

	set_monthly_dow (a_monthly_dow: X_MONTHLYDOW_RECORD)
			-- Set `monthly_dow' with `a_monthly_dow'.
		require
			attached_a_monthly_dow: a_monthly_dow /= Void
			valid_a_monthly_dow: a_monthly_dow.item /= default_pointer
		do
			ccom_x_trigger_type_union_set_monthly_dow (item, a_monthly_dow.item)
		end

	set_monthlyd_date (a_monthlyd_date: X_MONTHLYDATE_RECORD)
			-- Set `monthlyd_date' with `a_monthlyd_date'.
		require
			attached_a_monthlyd_date: a_monthlyd_date /= Void
			valid_a_monthlyd_date: a_monthlyd_date.item /= default_pointer
		do
			ccom_x_trigger_type_union_set_monthlyd_date (item, a_monthlyd_date.item)
		end

	set_weekly_interval (a_weekly_interval: X_WEEKLY_RECORD)
			-- Set `weekly_interval' with `a_weekly_interval'.
		require
			attached_a_weekly_interval: a_weekly_interval /= Void
			valid_a_weekly_interval: a_weekly_interval.item /= default_pointer
		do
			ccom_x_trigger_type_union_set_weekly_interval (item, a_weekly_interval.item)
		end

	set_daily_interval (a_daily_interval: X_DAILY_RECORD)
			-- Set `daily_interval' with `a_daily_interval'.
		require
			attached_a_daily_interval: a_daily_interval /= Void
			valid_a_daily_interval: a_daily_interval.item /= default_pointer
		do
			ccom_x_trigger_type_union_set_daily_interval (item, a_daily_interval.item)
		end

feature {NONE}  -- Externals

	c_size_of_x_trigger_type_union: INTEGER
			-- Size of structure
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__TRIGGER_TYPE_UNION.h%"]"
		alias 
			"sizeof (ecom_MS_TaskSched_lib::_TRIGGER_TYPE_UNION)"
		end

	ccom_x_trigger_type_union_monthly_dow (a_pointer: POINTER): X_MONTHLYDOW_RECORD
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__TRIGGER_TYPE_UNION_impl.h%"](ecom_MS_TaskSched_lib::_TRIGGER_TYPE_UNION *):EIF_REFERENCE"
		end

	ccom_x_trigger_type_union_set_monthly_dow (a_pointer: POINTER; arg2: POINTER)
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__TRIGGER_TYPE_UNION_impl.h%"](ecom_MS_TaskSched_lib::_TRIGGER_TYPE_UNION *, ecom_MS_TaskSched_lib::_MONTHLYDOW *)"
		end

	ccom_x_trigger_type_union_monthlyd_date (a_pointer: POINTER): X_MONTHLYDATE_RECORD
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__TRIGGER_TYPE_UNION_impl.h%"](ecom_MS_TaskSched_lib::_TRIGGER_TYPE_UNION *):EIF_REFERENCE"
		end

	ccom_x_trigger_type_union_set_monthlyd_date (a_pointer: POINTER; arg2: POINTER)
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__TRIGGER_TYPE_UNION_impl.h%"](ecom_MS_TaskSched_lib::_TRIGGER_TYPE_UNION *, ecom_MS_TaskSched_lib::_MONTHLYDATE *)"
		end

	ccom_x_trigger_type_union_weekly_interval (a_pointer: POINTER): X_WEEKLY_RECORD
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__TRIGGER_TYPE_UNION_impl.h%"](ecom_MS_TaskSched_lib::_TRIGGER_TYPE_UNION *):EIF_REFERENCE"
		end

	ccom_x_trigger_type_union_set_weekly_interval (a_pointer: POINTER; arg2: POINTER)
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__TRIGGER_TYPE_UNION_impl.h%"](ecom_MS_TaskSched_lib::_TRIGGER_TYPE_UNION *, ecom_MS_TaskSched_lib::_WEEKLY *)"
		end

	ccom_x_trigger_type_union_daily_interval (a_pointer: POINTER): X_DAILY_RECORD
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__TRIGGER_TYPE_UNION_impl.h%"](ecom_MS_TaskSched_lib::_TRIGGER_TYPE_UNION *):EIF_REFERENCE"
		end

	ccom_x_trigger_type_union_set_daily_interval (a_pointer: POINTER; arg2: POINTER)
			-- 
		external
			"C++ [macro %"ecom_MS_TaskSched_lib__TRIGGER_TYPE_UNION_impl.h%"](ecom_MS_TaskSched_lib::_TRIGGER_TYPE_UNION *, ecom_MS_TaskSched_lib::_DAILY *)"
		end

end -- X_TRIGGER_TYPE_UNION_UNION


