note
	description: "Work item object enumerator. Enumerates the work item objects within the Tasks folder. Task Scheduler."
	generator: "Automatically generated by the EiffelCOM Wizard."

deferred class
	IENUM_WORK_ITEMS_INTERFACE

inherit
	ECOM_INTERFACE

feature -- Basic Operations

	next (celt: INTEGER; rgpwsz_names: CELL [CELL [STRING]]; pcelt_fetched: INTEGER_REF)
			-- Retrieves the next set of tasks in the enumeration sequence.
			-- `celt' [in].  
			-- `rgpwsz_names' [out].  
			-- `pcelt_fetched' [out].  
		require
			attached_rgpwsz_names: rgpwsz_names /= Void
			attached_pcelt_fetched: pcelt_fetched /= Void
		deferred

		ensure
			valid_rgpwsz_names: rgpwsz_names.item /= Void
		end

	skip (celt: INTEGER)
			-- Skips the next set of tasks in the enumeration sequence.
			-- `celt' [in].  
		deferred

		end

	reset
			-- Resets the enumeration sequence to the beginning. 
		deferred

		end

	clone1 (pp_enum_work_items: CELL [IENUM_WORK_ITEMS_INTERFACE])
			-- Creates a new enumeration object in the same state as the current enumeration object: the new object points to the same place in the enumeration sequence.
			-- `pp_enum_work_items' [out].  
		require
			attached_pp_enum_work_items: pp_enum_work_items /= Void
		deferred

		ensure
			valid_pp_enum_work_items: pp_enum_work_items.item /= Void
		end

end -- IENUM_WORK_ITEMS_INTERFACE


