note

	description:

		"Eiffel class marks (e.g. 'attached', 'detachable', 'expanded', 'reference', 'separate', 'deferred', '!' or '?')"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2008-2019, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2019-07-29 16:31:53 +0000 (Mon, 29 Jul 2019) $"
	revision: "$Revision: 103358 $"

deferred class ET_CLASS_MARK

inherit

	ET_TYPE_MARK
		undefine
			first_position,
			last_position,
			break
		end

	ET_AST_LEAF

feature -- Status report

	is_deferred: BOOLEAN
			-- Is current type mark 'deferred'?
		do
			-- Result := False
		end

feature -- Access

	text: STRING
			-- Textual representation
			-- (using UTF-8 encoding)
		deferred
		ensure
			text_not_void: Result /= Void
			text_not_empty: not Result.is_empty
			text_is_string: {KL_ANY_ROUTINES}.same_types (Result, "")
			valid_utf8_text: {UC_UTF8_ROUTINES}.valid_utf8 (Result)
		end

end
