note

	description:

		"Test features of class UC_UTF32_ROUTINES"

	test_status: "ok_to_run"
	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2005, Colin Adams and others"
	license: "MIT License"
	date: "$Date: 2019-02-05 23:54:36 +0000 (Tue, 05 Feb 2019) $"
	revision: "$Revision: 102790 $"

class UC_TEST_UTF32_ROUTINES

inherit

	KL_TEST_CASE
	UC_IMPORTED_UTF32_ROUTINES

create

	make_default

feature -- Tests

	test_valid
			-- Test feature `valid_utf32' when valid.
		do
			assert ("empty", utf32.valid_utf32 (""))
			assert ("valid_big_endian", utf32.valid_utf32 (utf32.bom_be + "%/0/%/0/%/0/M"))
			assert ("valid_little_endian", utf32.valid_utf32 (utf32.bom_le + "M%/0/%/0/%/0/"))
			assert ("valid_no_byte_order_marker", utf32.valid_utf32 ("%/0/%/0/%/0/M"))
		end

	test_invalid
			-- Test feature `valid_utf32' when invalid.
		do
			assert ("only_3_bytes_be", not utf32.valid_utf32 (utf32.bom_be + "%/0/%/0/M"))
			assert ("only_3_bytes_le", not utf32.valid_utf32 (utf32.bom_le + "M%/0/%/0/"))
			assert ("surrogate", not utf32.valid_utf32 (utf32.bom_be + "%/0/%/0/%/216/%/223/"))
			assert ("code_too_large", not utf32.valid_utf32 (utf32.bom_be + "%/127/%/0/%/0/%/0/"))
		end

end
