note
	description: "Control interfaces. Help file: "
	legal: "See notice at end of class."
	status: "See notice at end of class."
	generator: "Automatically generated by the EiffelCOM Wizard."

class
	TAG_RECT_RECORD

inherit
	ECOM_STRUCTURE
		redefine
			make
		end

create
	make,
	make_from_pointer,
	make_from_wel_rect

feature {NONE}  -- Initialization

	make
			-- Make.
		do
			Precursor {ECOM_STRUCTURE}
		end

	make_from_pointer (a_pointer: POINTER)
			-- Make from pointer.
		do
			make_by_pointer (a_pointer)
		end

	make_from_wel_rect (a_rect: WEL_RECT)
			-- Make from WEL_RECT.
		require
			non_void_rect: a_rect /= Void
		do
			make
			set_from_rect (a_rect)
		end
		
feature -- Access

	left: INTEGER
			-- No description available.
		do
			Result := ccom_tag_rect_left (item)
		end

	top: INTEGER
			-- No description available.
		do
			Result := ccom_tag_rect_top (item)
		end

	right: INTEGER
			-- No description available.
		do
			Result := ccom_tag_rect_right (item)
		end

	bottom: INTEGER
			-- No description available.
		do
			Result := ccom_tag_rect_bottom (item)
		end

	wel_rect: WEL_RECT
			-- Equivalent WEL_RECT
		require
			exists: exists
		do
			create Result.make (left, top, right, bottom)
		ensure
			valid_rect: Result /= Void
		end
		
feature -- Measurement

	structure_size: INTEGER
			-- Size of structure
		do
			Result := c_size_of_tag_rect
		end

feature -- Basic Operations

	set_from_rect (a_rect: WEL_RECT)
			-- Set from WEL_RECT.
		require
			non_void_rect: a_rect /= Void
		do
			set_left (a_rect.left)
			set_top (a_rect.top)
			set_right (a_rect.right)
			set_bottom (a_rect.bottom)
		end

	set_left (a_left: INTEGER)
			-- Set `left' with `a_left'.
		do
			ccom_tag_rect_set_left (item, a_left)
		end

	set_top (a_top: INTEGER)
			-- Set `top' with `a_top'.
		do
			ccom_tag_rect_set_top (item, a_top)
		end

	set_right (a_right: INTEGER)
			-- Set `right' with `a_right'.
		do
			ccom_tag_rect_set_right (item, a_right)
		end

	set_bottom (a_bottom: INTEGER)
			-- Set `bottom' with `a_bottom'.
		do
			ccom_tag_rect_set_bottom (item, a_bottom)
		end

feature {NONE}  -- Externals

	c_size_of_tag_rect: INTEGER
			-- Size of structure
		external
			"C [macro %"ecom_control_library_tagRECT_s.h%"]"
		alias
			"sizeof(ecom_control_library::tagRECT)"
		end

	ccom_tag_rect_left (a_pointer: POINTER): INTEGER
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagRECT_s_impl.h%"](ecom_control_library::tagRECT *):EIF_INTEGER"
		end

	ccom_tag_rect_set_left (a_pointer: POINTER; arg2: INTEGER)
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagRECT_s_impl.h%"](ecom_control_library::tagRECT *, LONG)"
		end

	ccom_tag_rect_top (a_pointer: POINTER): INTEGER
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagRECT_s_impl.h%"](ecom_control_library::tagRECT *):EIF_INTEGER"
		end

	ccom_tag_rect_set_top (a_pointer: POINTER; arg2: INTEGER)
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagRECT_s_impl.h%"](ecom_control_library::tagRECT *, LONG)"
		end

	ccom_tag_rect_right (a_pointer: POINTER): INTEGER
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagRECT_s_impl.h%"](ecom_control_library::tagRECT *):EIF_INTEGER"
		end

	ccom_tag_rect_set_right (a_pointer: POINTER; arg2: INTEGER)
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagRECT_s_impl.h%"](ecom_control_library::tagRECT *, LONG)"
		end

	ccom_tag_rect_bottom (a_pointer: POINTER): INTEGER
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagRECT_s_impl.h%"](ecom_control_library::tagRECT *):EIF_INTEGER"
		end

	ccom_tag_rect_set_bottom (a_pointer: POINTER; arg2: INTEGER)
			-- No description available.
		external
			"C++ [macro %"ecom_control_library_tagRECT_s_impl.h%"](ecom_control_library::tagRECT *, LONG)"
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- TAG_RECT_RECORD

