#ifndef LIBLBFGS_PARSER_LEARNER_HPP_
#define LIBLBFGS_PARSER_LEARNER_HPP_

#include <vector>
#include <lbfgs.h>
#include "parser_learner_interface.hpp"

namespace maeda {

// weight_map_training
class LibLBFGSParserLearner : public ParserLearnerInterface {
public:
  LibLBFGSParserLearner(const double &C);

  void Learn(
    const std::vector<FeatureVectorList > *feature_vector_list_list,
    const std::vector<int> *gold_standard_index_list,
    WeightMap *weight);

private:
  // ѥ᡼
  double C_;
  // ٥ȥ
  const std::vector<FeatureVectorList>* feature_vector_list_list_;
  // б٥
  const std::vector<int>* gold_standard_index_list_;
  // ؽǡ׻٥ȥνŤ
  WeightMap weight_by_training_data_;

  //liblfgsΤcallback
  friend lbfgsfloatval_t lbfgs_evaluate(void *instance,
                                        const lbfgsfloatval_t *x,
                                        lbfgsfloatval_t *grad,
                                        const int n,
                                        const lbfgsfloatval_t step);

  friend int lbfgs_progress(void *instance,
                            const lbfgsfloatval_t *x,
                            const lbfgsfloatval_t *g,
                            const lbfgsfloatval_t fx,
                            const lbfgsfloatval_t xnorm,
                            const lbfgsfloatval_t gnorm,
                            const lbfgsfloatval_t step,
                            int n,
                            int k,
                            int ls);

};


} // maeda


#endif // LIBLBFGS_LEARNER_HPP_
