#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include "LBFGS.hpp"
#include "lbfgs_hpp_parser_learner.hpp"


namespace maeda {

LBFGS_HPP_ParserLearner::LBFGS_HPP_ParserLearner(const double &C)
  : C_(C), solver_(NULL) {}


void LBFGS_HPP_ParserLearner::Learn(
    const std::vector<FeatureVectorList > *feature_vector_list_list,
    const std::vector<int> *gold_standard_index_list,
    WeightMap *weight) {
  const size_t feature_space_dimension = weight->size();

  weight_by_training_data_.resize(feature_space_dimension);
  for (size_t n = 0; n < gold_standard_index_list->size(); n++) {
    const FeatureVector &gold_feature_vector =
        feature_vector_list_list->at(n)[gold_standard_index_list->at(n)];
    for (FeatureVector::const_iterator it = gold_feature_vector.begin();
         it != gold_feature_vector.end(); ++it) {
      weight_by_training_data_[it->id] += it->value;
    }
  }
  solver_ =
      new LBFGS<LBFGS_HPP_ParserLearner, double>(*this, weight->size());

  feature_vector_list_list_ = feature_vector_list_list;

  gold_standard_index_list_ = gold_standard_index_list;

  weight_ = weight;

  const double C_saved = C_;
  C_ = C_saved / gold_standard_index_list_->size();

  for (int i = 0; i < 30; i++) {
    solver_->iteration();
    ShowStatistics();
    if (solver_->isConverged()) { break; }
  }

  C_ = C_saved;
}

void LBFGS_HPP_ParserLearner::ShowStatistics() const {
  std::cerr << "obj=" << solver_->funcVal()
            << ", norm=" << solver_->gradNorm()
            << std::endl;
}

// LBFGSɬ
double LBFGS_HPP_ParserLearner::operator()(
    const std::vector<double> &x, std::vector<double> &grad) {
  if ((weight_->size() != x.size()) ||
      (weight_->size() != grad.size())) {
    std::cerr << "Internal Error!!" << std::endl;
    exit(1);
  }

  for (FeatureID f = 0; f < FeatureID(weight_->size()); f++) {
    // Ť߹
    weight_->at(f) = x[f];
  }

  double obj_func = 0.0;
  // iterationǻȤweight
  WeightMap tmp_weight(weight_by_training_data_.size());
  for (size_t i = 0; i < gold_standard_index_list_->size(); i++) {
    const std::vector<FeatureVector> &feature_vector_list =
        feature_vector_list_list_->at(i);
    const size_t num_feature_vectors = feature_vector_list.size();

    double scores[num_feature_vectors];
    double sum = 0.0;

    for (size_t t = 0; t < num_feature_vectors; t++) {
      scores[t] = exp(feature_vector_list[t].Product(*weight_));
      sum += scores[t];
    }

    for (size_t t = 0; t < num_feature_vectors; t++) {
      for (FeatureVector::const_iterator it = feature_vector_list[t].begin();
           it != feature_vector_list[t].end(); ++it) {
        tmp_weight[it->id] += it->value * (scores[t] / sum);
      }
    }

    const int gold_index = gold_standard_index_list_->at(i);
    obj_func -=
        feature_vector_list[gold_index].Product(*weight_) - log(sum);
  }

  obj_func /= gold_standard_index_list_->size();

  for (FeatureID f = 0; f < FeatureID(weight_->size()); f++) {
    grad[f] = tmp_weight[f] - weight_by_training_data_[f];
    grad[f] /= gold_standard_index_list_->size();
    double lambda = weight_->at(f);
    grad[f] += lambda * C_;
    obj_func += lambda * lambda * 0.5 * C_;
  }

  return obj_func;
}

} // maeda
