#ifndef YACC_GEN_VISITOR2_H_
#define YACC_GEN_VISITOR2_H_

#include "visitor.h"
#include <fstream>
#include <string>
#include <set>
#include <vector>
#include <map>

class yaccgenvisitor2 : public visitor
{
public:
	yaccgenvisitor2(const char* yaccFilename, const char* astFilename);
	virtual ~yaccgenvisitor2();

	virtual void visit_lhs_IDENT_SEPARATOR(const lhs_IDENT_SEPARATOR *plhs_IDENT_SEPARATOR) ;
	virtual void visit_grammar_grammar_production(const grammar_grammar_production *pgrammar_grammar_production) ;
	virtual void visit_grammar_grammar_COMMENT(const grammar_grammar_COMMENT *pgrammar_grammar_COMMENT) ;
	virtual void visit_expression_base_OPT(const expression_base_OPT *pexpression_base_OPT) ;
	virtual void visit_production_lhs_expressionListList_TERMINATOR(const production_lhs_expressionListList_TERMINATOR *pproduction_lhs_expressionListList_TERMINATOR) ;
	virtual void visit_expression_base_PLUS(const expression_base_PLUS *pexpression_base_PLUS) ;
	virtual void visit_expression_base(const expression_base *pexpression_base) ;
	virtual void visit_base_LITERAL(const base_LITERAL *pbase_LITERAL) ;
	virtual void visit_expression_base_STAR(const expression_base_STAR *pexpression_base_STAR) ;
	virtual void visit_base_LPAREN_expressionList_RPAREN(const base_LPAREN_expressionList_RPAREN *pbase_LPAREN_expressionList_RPAREN) ;
	virtual void visit_expression_COMMENT(const expression_COMMENT *pexpression_COMMENT) ;
	virtual void visit_alternation_expression_OR_expression(const alternation_expression_OR_expression *palternation_expression_OR_expression) ;
	virtual void visit_base_IDENT(const base_IDENT *pbase_IDENT) ;
	virtual void visit_base_LPAREN_alternation_RPAREN(const base_LPAREN_alternation_RPAREN *pbase_LPAREN_alternation_RPAREN) ;
	virtual void visit_alternation_alternation_OR_expression(const alternation_alternation_OR_expression *palternation_alternation_OR_expression) ;

private:
	std::ofstream m_out;
	std::string m_yaccFilename;
	std::string m_astFilename;
	std::string m_rulename;
	std::string m_literal;
	std::string m_ident;
	std::map<std::string, std::string> m_listTypes;

	std::string getListType(const std::string& rule)
	{
		return m_listTypes[rule];
	}

	void addListType(const std::string& rule, const std::string& type)
	{
		m_listTypes[rule] = type;
	}


	void output_production(const std::vector<std::vector<expression*>*>::const_iterator i, bool simple);
};


#endif

