#include "yaccgenvisitor2.h"
#include "ast.h"
#include "strutils.h"

#include <assert.h>

using std::vector;
using std::string;
using std::set;
using std::ios;

yaccgenvisitor2::yaccgenvisitor2(const char* yaccFilename, const char* astFilename)
	: m_out(yaccFilename, ios::app)
	, m_yaccFilename(yaccFilename)
	, m_astFilename(astFilename)
{
}

yaccgenvisitor2::~yaccgenvisitor2()
{
}

void yaccgenvisitor2::visit_lhs_IDENT_SEPARATOR(const lhs_IDENT_SEPARATOR *plhs_IDENT_SEPARATOR)
{
	m_rulename = *plhs_IDENT_SEPARATOR->m_IDENT;
	m_out << "\n\n" << m_rulename << ":\n";
}

void yaccgenvisitor2::visit_grammar_grammar_production(const grammar_grammar_production *pgrammar_grammar_production)
{
	if (pgrammar_grammar_production->m_grammar.get() == 0) // start of the AST
	{
	}
	else
	{
		pgrammar_grammar_production->m_grammar->accept(this);
	}
	pgrammar_grammar_production->m_production->accept(this);

}

void yaccgenvisitor2::visit_grammar_grammar_COMMENT(const grammar_grammar_COMMENT *pgrammar_grammar_COMMENT)
{
	return;
}

void yaccgenvisitor2::visit_expression_base_OPT(const expression_base_OPT *pexpression_base_OPT)
{
	// not yet implemented
	assert(0);
	pexpression_base_OPT->m_base->accept(this);
}

void yaccgenvisitor2::visit_production_lhs_expressionListList_TERMINATOR(const production_lhs_expressionListList_TERMINATOR *pproduction_lhs_expressionListList_TERMINATOR)
{
	pproduction_lhs_expressionListList_TERMINATOR->m_lhs->accept(this);
	if (pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList.get() != 0)
	{
		vector<vector<expression*>*>::const_iterator i = pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->begin();
		if (endsWithList(m_rulename))
		{
			if (*i)
			{
				vector<expression*>::const_iterator j = (*i)->begin();
				if (j != (*i)->end())
				{
					(*j)->accept(this); // fills out m_ident
					if (beginsWithStr(m_ident))
						addListType(m_rulename, "std::string");
					else
						addListType(m_rulename, m_ident);
				}
			}
		}
		for (; i != pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->end();
			  ++i)
		{
			if (*i)
			{
				if (i != pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->begin())
				{
					m_out << "\t| ";
				}
				else
				{
					m_out << "\t";
				}
				bool simple = pproduction_lhs_expressionListList_TERMINATOR->m_expressionListList->size() <= 1;
				output_production(i, simple);
			}
		}
	}
}

void yaccgenvisitor2::output_production(const vector<vector<expression*>*>::const_iterator i, bool simple)
{
	string productionClassName = m_rulename;
		if ((*i)->size() > 0)
		{
			for (vector<expression*>::const_iterator j = (*i)->begin();
				  j != (*i)->end();
				  ++j)
			{
				(*j)->accept(this);
				m_out << m_ident << " ";
				if (!simple)
				{
					productionClassName += "_";
					productionClassName += m_ident;
				}
			}
		}
		else
			m_out << "/* EMPTY */";

	m_out << "\n";

	if (beginsWithStr(productionClassName))
	{
		if ((*i)->size() > 0)
			m_out << "\t  { $$ = $1 }\n";
		else
			m_out << "\t  { $$ = 0 }\n";
	}
	else if (endsWithList(m_rulename))
	{
		if ((*i)->size() == 0)
			m_out << "\t  { $$ = new std::list<" << getListType(m_rulename) <<
				"*>() }\n";
		else if ((*i)->size() == 1)
			m_out << "\t  { $$ = new std::list<" << getListType(m_rulename) <<
				"*>(1, $1) }\n";
		else
		{
			m_out << "\t  { $1->push_back($" << (*i)->size() << "); ";
		  	for (unsigned int x = 2; x < (*i)->size(); ++x)
			{
				m_out << "delete $" << x << "; ";
			}
			m_out << "$$ = $1; }\n";
		}
	}
	else
	{
		if ((*i)->size() > 0)
		{
			m_out << "\t  { $$ = new " << productionClassName << "(";
			int count = 1;
			for (vector<expression*>::const_iterator j = (*i)->begin();
				  j != (*i)->end();
				  ++j)
			{
				if (j != (*i)->begin())
				{
					m_out << ", ";
				}
				m_out << "$" << count;
				++count;
			}
			m_out << ") }\n";
		}
		else
			m_out << "\t  { $$ = 0 }\n";
	}

}

void yaccgenvisitor2::visit_expression_base_PLUS(const expression_base_PLUS *pexpression_base_PLUS)
{
	// not yet implemented
	assert(0);
	pexpression_base_PLUS->m_base->accept(this);
}

void yaccgenvisitor2::visit_expression_base(const expression_base *pexpression_base)
{
	pexpression_base->m_base->accept(this);
}

void yaccgenvisitor2::visit_base_LITERAL(const base_LITERAL *pbase_LITERAL)
{
	m_literal = *pbase_LITERAL->m_LITERAL;
}

void yaccgenvisitor2::visit_expression_base_STAR(const expression_base_STAR *pexpression_base_STAR)
{
	// not yet implemented
	assert(0);
	pexpression_base_STAR->m_base->accept(this);
}

void yaccgenvisitor2::visit_base_LPAREN_expressionList_RPAREN(const base_LPAREN_expressionList_RPAREN *pbase_LPAREN_expressionList_RPAREN)
{
	// not yet implemented
	assert(0);
	if (pbase_LPAREN_expressionList_RPAREN->m_expressionList.get() != 0)
	{
		for (vector<expression*>::const_iterator i = pbase_LPAREN_expressionList_RPAREN->m_expressionList->begin();
			  i != pbase_LPAREN_expressionList_RPAREN->m_expressionList->end();
			  ++i)
		{
			(*i)->accept(this);
		}
	}
}

void yaccgenvisitor2::visit_expression_COMMENT(const expression_COMMENT *pexpression_COMMENT)
{
	// not yet implemented
	assert(0);
	(void)pexpression_COMMENT->m_COMMENT;
}

void yaccgenvisitor2::visit_alternation_expression_OR_expression(const alternation_expression_OR_expression *palternation_expression_OR_expression)
{
	// not yet implemented
	assert(0);
	palternation_expression_OR_expression->m_expression1->accept(this);
	palternation_expression_OR_expression->m_expression2->accept(this);
}

void yaccgenvisitor2::visit_base_IDENT(const base_IDENT *pbase_IDENT)
{
	m_ident = *pbase_IDENT->m_IDENT;
}

void yaccgenvisitor2::visit_base_LPAREN_alternation_RPAREN(const base_LPAREN_alternation_RPAREN *pbase_LPAREN_alternation_RPAREN)
{
	// not yet implemented
	assert(0);
	pbase_LPAREN_alternation_RPAREN->m_alternation->accept(this);
}

void yaccgenvisitor2::visit_alternation_alternation_OR_expression(const alternation_alternation_OR_expression *palternation_alternation_OR_expression)
{
	// not yet implemented
	assert(0);
	palternation_alternation_OR_expression->m_alternation->accept(this);
	palternation_alternation_OR_expression->m_expression->accept(this);
}


