#ifndef TEST2AST_H_HPP_GUARD_
#define TEST2AST_H_HPP_GUARD_
#include <string>
#include <list>
#include "test2visitor.h"

class node
{
	public:
		virtual ~node() {}
		virtual void accept( Visitor * ) const = 0;
};

class grammar: public node
{
	public:
		grammar()
			{}
		virtual ~grammar() {}

};

class grammar_production : public grammar
{
	public:
		grammar_production(
			production* pNewproduction1
		)
			: grammar()
			, m_pproduction1(pNewproduction1)
		{}

		virtual ~grammar_production();

		void accept( Visitor* v ) const
		{
			v->visit_grammar_production( this );
		}

		production* m_pproduction1;
};

class grammar_grammar_production : public grammar
{
	public:
		grammar_grammar_production(
			grammar* pNewgrammar1,
			production* pNewproduction2
		)
			: grammar()
			, m_pgrammar1(pNewgrammar1)
			, m_pproduction2(pNewproduction2)
		{}

		virtual ~grammar_grammar_production();

		void accept( Visitor* v ) const
		{
			v->visit_grammar_grammar_production( this );
		}

		grammar* m_pgrammar1;
		production* m_pproduction2;
};

class grammar_grammar_COMMENT : public grammar
{
	public:
		grammar_grammar_COMMENT(
			grammar* pNewgrammar1,
			std::string* pNewCOMMENT2
		)
			: grammar()
			, m_pgrammar1(pNewgrammar1)
			, m_pCOMMENT2(pNewCOMMENT2)
		{}

		virtual ~grammar_grammar_COMMENT();

		void accept( Visitor* v ) const
		{
			v->visit_grammar_grammar_COMMENT( this );
		}

		grammar* m_pgrammar1;
		std::string* m_pCOMMENT2;
};

class production : public node
{
	public:
		production(
			lhs* pNewlhs1,
			std::list< * >* pNewexpressionListList2,
			std::string* pNewTERMINATOR3
		)
			: m_plhs1(pNewlhs1)
			, m_pexpressionListList2(pNewexpressionListList2)
			, m_pTERMINATOR3(pNewTERMINATOR3)
		{}

		virtual ~production();

		void accept( Visitor* v ) const
		{
			v->visit_production( this );
		}

		lhs* m_plhs1;
		std::list< * >* m_pexpressionListList2;
		std::string* m_pTERMINATOR3;
};

class lhs : public node
{
	public:
		lhs(
			std::string* pNewIDENT1,
			std::string* pNewSEPARATOR2
		)
			: m_pIDENT1(pNewIDENT1)
			, m_pSEPARATOR2(pNewSEPARATOR2)
		{}

		virtual ~lhs();

		void accept( Visitor* v ) const
		{
			v->visit_lhs( this );
		}

		std::string* m_pIDENT1;
		std::string* m_pSEPARATOR2;
};

class expression: public node
{
	public:
		expression()
			{}
		virtual ~expression() {}

};

class expression_base : public expression
{
	public:
		expression_base(
			base* pNewbase1
		)
			: expression()
			, m_pbase1(pNewbase1)
		{}

		virtual ~expression_base();

		void accept( Visitor* v ) const
		{
			v->visit_expression_base( this );
		}

		base* m_pbase1;
};

class expression_base_OPT : public expression
{
	public:
		expression_base_OPT(
			base* pNewbase1,
			std::string* pNewOPT2
		)
			: expression()
			, m_pbase1(pNewbase1)
			, m_pOPT2(pNewOPT2)
		{}

		virtual ~expression_base_OPT();

		void accept( Visitor* v ) const
		{
			v->visit_expression_base_OPT( this );
		}

		base* m_pbase1;
		std::string* m_pOPT2;
};

class expression_base_STAR : public expression
{
	public:
		expression_base_STAR(
			base* pNewbase1,
			std::string* pNewSTAR2
		)
			: expression()
			, m_pbase1(pNewbase1)
			, m_pSTAR2(pNewSTAR2)
		{}

		virtual ~expression_base_STAR();

		void accept( Visitor* v ) const
		{
			v->visit_expression_base_STAR( this );
		}

		base* m_pbase1;
		std::string* m_pSTAR2;
};

class expression_base_PLUS : public expression
{
	public:
		expression_base_PLUS(
			base* pNewbase1,
			std::string* pNewPLUS2
		)
			: expression()
			, m_pbase1(pNewbase1)
			, m_pPLUS2(pNewPLUS2)
		{}

		virtual ~expression_base_PLUS();

		void accept( Visitor* v ) const
		{
			v->visit_expression_base_PLUS( this );
		}

		base* m_pbase1;
		std::string* m_pPLUS2;
};

class expression_COMMENT : public expression
{
	public:
		expression_COMMENT(
			std::string* pNewCOMMENT1
		)
			: expression()
			, m_pCOMMENT1(pNewCOMMENT1)
		{}

		virtual ~expression_COMMENT();

		void accept( Visitor* v ) const
		{
			v->visit_expression_COMMENT( this );
		}

		std::string* m_pCOMMENT1;
};

class base: public node
{
	public:
		base()
			{}
		virtual ~base() {}

};

class base_LITERAL : public base
{
	public:
		base_LITERAL(
			std::string* pNewLITERAL1
		)
			: base()
			, m_pLITERAL1(pNewLITERAL1)
		{}

		virtual ~base_LITERAL();

		void accept( Visitor* v ) const
		{
			v->visit_base_LITERAL( this );
		}

		std::string* m_pLITERAL1;
};

class base_IDENT : public base
{
	public:
		base_IDENT(
			std::string* pNewIDENT1
		)
			: base()
			, m_pIDENT1(pNewIDENT1)
		{}

		virtual ~base_IDENT();

		void accept( Visitor* v ) const
		{
			v->visit_base_IDENT( this );
		}

		std::string* m_pIDENT1;
};

class base_LPAREN_expressionList_RPAREN : public base
{
	public:
		base_LPAREN_expressionList_RPAREN(
			std::string* pNewLPAREN1,
			std::list< * >* pNewexpressionList2,
			std::string* pNewRPAREN3
		)
			: base()
			, m_pLPAREN1(pNewLPAREN1)
			, m_pexpressionList2(pNewexpressionList2)
			, m_pRPAREN3(pNewRPAREN3)
		{}

		virtual ~base_LPAREN_expressionList_RPAREN();

		void accept( Visitor* v ) const
		{
			v->visit_base_LPAREN_expressionList_RPAREN( this );
		}

		std::string* m_pLPAREN1;
		std::list< * >* m_pexpressionList2;
		std::string* m_pRPAREN3;
};

class base_LPAREN_alternation_RPAREN : public base
{
	public:
		base_LPAREN_alternation_RPAREN(
			std::string* pNewLPAREN1,
			alternation* pNewalternation2,
			std::string* pNewRPAREN3
		)
			: base()
			, m_pLPAREN1(pNewLPAREN1)
			, m_palternation2(pNewalternation2)
			, m_pRPAREN3(pNewRPAREN3)
		{}

		virtual ~base_LPAREN_alternation_RPAREN();

		void accept( Visitor* v ) const
		{
			v->visit_base_LPAREN_alternation_RPAREN( this );
		}

		std::string* m_pLPAREN1;
		alternation* m_palternation2;
		std::string* m_pRPAREN3;
};

class alternation: public node
{
	public:
		alternation()
			{}
		virtual ~alternation() {}

};

class alternation_expression_OR_expression : public alternation
{
	public:
		alternation_expression_OR_expression(
			expression* pNewexpression1,
			std::string* pNewOR2,
			expression* pNewexpression3
		)
			: alternation()
			, m_pexpression1(pNewexpression1)
			, m_pOR2(pNewOR2)
			, m_pexpression3(pNewexpression3)
		{}

		virtual ~alternation_expression_OR_expression();

		void accept( Visitor* v ) const
		{
			v->visit_alternation_expression_OR_expression( this );
		}

		expression* m_pexpression1;
		std::string* m_pOR2;
		expression* m_pexpression3;
};

class alternation_alternation_OR_expression : public alternation
{
	public:
		alternation_alternation_OR_expression(
			alternation* pNewalternation1,
			std::string* pNewOR2,
			expression* pNewexpression3
		)
			: alternation()
			, m_palternation1(pNewalternation1)
			, m_pOR2(pNewOR2)
			, m_pexpression3(pNewexpression3)
		{}

		virtual ~alternation_alternation_OR_expression();

		void accept( Visitor* v ) const
		{
			v->visit_alternation_alternation_OR_expression( this );
		}

		alternation* m_palternation1;
		std::string* m_pOR2;
		expression* m_pexpression3;
};

inline grammar_production::~grammar_production()
{
	delete m_pproduction1;
}

inline grammar_grammar_production::~grammar_grammar_production()
{
	delete m_pgrammar1;
	delete m_pproduction2;
}

inline grammar_grammar_COMMENT::~grammar_grammar_COMMENT()
{
	delete m_pgrammar1;
	delete m_pCOMMENT2;
}

inline production::~production()
{
	delete m_plhs1;
	while(!m_pexpressionListList2->empty())
	{
		delete m_pexpressionListList2->front();
		m_pexpressionListList2->pop_front();
	}
	delete m_pexpressionListList2;
	delete m_pTERMINATOR3;
}

inline lhs::~lhs()
{
	delete m_pIDENT1;
	delete m_pSEPARATOR2;
}

inline expression_base::~expression_base()
{
	delete m_pbase1;
}

inline expression_base_OPT::~expression_base_OPT()
{
	delete m_pbase1;
	delete m_pOPT2;
}

inline expression_base_STAR::~expression_base_STAR()
{
	delete m_pbase1;
	delete m_pSTAR2;
}

inline expression_base_PLUS::~expression_base_PLUS()
{
	delete m_pbase1;
	delete m_pPLUS2;
}

inline expression_COMMENT::~expression_COMMENT()
{
	delete m_pCOMMENT1;
}

inline base_LITERAL::~base_LITERAL()
{
	delete m_pLITERAL1;
}

inline base_IDENT::~base_IDENT()
{
	delete m_pIDENT1;
}

inline base_LPAREN_expressionList_RPAREN::~base_LPAREN_expressionList_RPAREN()
{
	delete m_pLPAREN1;
	while(!m_pexpressionList2->empty())
	{
		delete m_pexpressionList2->front();
		m_pexpressionList2->pop_front();
	}
	delete m_pexpressionList2;
	delete m_pRPAREN3;
}

inline base_LPAREN_alternation_RPAREN::~base_LPAREN_alternation_RPAREN()
{
	delete m_pLPAREN1;
	delete m_palternation2;
	delete m_pRPAREN3;
}

inline alternation_expression_OR_expression::~alternation_expression_OR_expression()
{
	delete m_pexpression1;
	delete m_pOR2;
	delete m_pexpression3;
}

inline alternation_alternation_OR_expression::~alternation_alternation_OR_expression()
{
	delete m_palternation1;
	delete m_pOR2;
	delete m_pexpression3;
}

#endif
