#include "strutils.h"
#include <ctype.h> // for isupper

using std::string;

bool isAllCaps(const string& s)
{
	for (string::size_type i = 0; i < s.length(); ++i)
	{
		if (!isupper(s[i]))
		{
			return false;
		}
	}
	return true;
}

string strToIdentifier(const string& s)
{
	string rval;
	for (string::size_type i = 0; i < s.length(); ++i)
	{
		if (isalnum(s[i]))
		{
			rval += toupper(s[i]);
		}
		else
		{
			rval += "_";
		}
	}
	return rval;
}

bool beginsWithStr(const string& s)
{
	return s.substr(0,3) == "str";
}

bool beginsWithOpt(const string& s)
{
	return s.substr(0,3) == "opt";
}

bool endsWithList(const string& s)
{
	if (s.length() < 4)
		return false;

	return s.substr(s.length() - 4, 4) == "List";
}

bool isSpecialRule(const string& s)
{
	return beginsWithStr(s) || endsWithList(s);
}

