
%{
/* ebnf2yacc parser code */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ast.h"

using std::vector;

extern int line_num;
#define YYERROR_VERBOSE 1
int yyerror(char* s);
int yylex();
extern grammar* g_grammar;
%}

%token IDENT LITERAL SEPARATOR TERMINATOR
%token OR OPT STAR PLUS LPAREN RPAREN
%token COMMENT

/* here is the stuff to make our C++ AST work */
%union {
	grammar*							pGrammar;
	production*						pProduction;
	lhs*								pLhs;
	std::vector<std::vector<expression*>*>*	pExpressionListList;
	std::vector<expression*>*			pExpressionList;
	expression*						pExpression;
	base*								pBase;
	alternation*					pAlternation;
	std::string*					pString;
}


%type <pGrammar> grammar
%type <pProduction> production
%type <pLhs> lhs
%type <pExpressionListList> expressionListList
%type <pExpressionList> expressionList
%type <pExpression> expression
%type <pBase> base
%type <pAlternation> alternation
%type <pString> COMMENT IDENT LITERAL

%%

grammar : production
		{ $$ = g_grammar = new grammar_grammar_production(0, $1) }
	| grammar production
		{ $$ = g_grammar = new grammar_grammar_production($1, $2) }
	| grammar COMMENT
		{ $$ = g_grammar = new grammar_grammar_COMMENT($1, $2) }
	;

production : lhs expressionListList TERMINATOR
		{ $$ = new production_lhs_expressionListList_TERMINATOR($1, $2) }
	;

lhs : IDENT SEPARATOR
		{ $$ = new lhs_IDENT_SEPARATOR($1) }
	;

expressionListList : expressionList
		{ $$ = new vector<vector<expression*>*>(1, $1) }
	| expressionListList OR expressionList
		{ $1->push_back($3); $$ = $1; }
	;

expressionList : /* empty */
		{ $$ = new vector<expression*>() }
	| expressionList expression
		{ $1->push_back($2); $$ = $1; }
	;

expression : base
		{ $$ = new expression_base($1) }
	| base OPT
		{ $$ = new expression_base_OPT($1) }
	| base STAR
		{ $$ = new expression_base_STAR($1) }
	| base PLUS
		{ $$ = new expression_base_PLUS($1) }
	| COMMENT
		{ $$ = new expression_COMMENT($1) }
	;

base : LITERAL
		{ $$ = new base_LITERAL($1) }
	| IDENT
		{ $$ = new base_IDENT($1) }
	| LPAREN expressionList RPAREN
		{ $$ = new base_LPAREN_expressionList_RPAREN($2) }
	| LPAREN alternation RPAREN
		{ $$ = new base_LPAREN_alternation_RPAREN($2) }
	;

alternation : expression OR expression
		{ $$ = new alternation_expression_OR_expression($1, $3) }
	| alternation OR expression
		{ $$ = new alternation_alternation_OR_expression($1, $3) }
	;

%%

int yyerror(char* s)
{
	fprintf(stderr, "%s at line num %d\n", s, line_num);
}
