%{
#include "ast.h"
#include "parser.h"
using std::string;
extern int line_num;
void addLineNumbers();
%}

%option noyywrap

Separator		":"|"::="
Semicolon		";"
Name				[a-zA-Z][a-zA-Z0-9_]*
Whitespace		[ \t]
Or					"|"
Opt				"?"
Star				"*"
Plus				"+"
LParen			"("
RParen			")"
SQuote			"'"
DQuote			"\""
SQLit				{SQuote}[^\'\r\n]*{SQuote}
DQLit				{DQuote}[^\"\r\n]*{DQuote}
Literal			{SQLit}|{DQLit}
BeginComment	"/*"
CommentData		(([^\*]|("*"+[^\*\/]))*)
EndComment		"*/"


%%
"\r\n"		{ ++line_num; }
"\n"			{ ++line_num; }
"\r"			{ ++line_num; }
{Whitespace} {
	addLineNumbers();
}

{Separator}	{ yylval.pString = new string(yytext); return (SEPARATOR); }
{Semicolon}	{ yylval.pString = new string(yytext); return (TERMINATOR); }
{Name}		{ yylval.pString = new string(yytext); return (IDENT); }
{Or}			{ yylval.pString = new string(yytext); return (OR); }
{Opt}			{ yylval.pString = new string(yytext); return (OPT); }
{Star}		{ yylval.pString = new string(yytext); return (STAR); }
{Plus}		{ yylval.pString = new string(yytext); return (PLUS); }
{LParen}		{ yylval.pString = new string(yytext); return (LPAREN); }
{RParen}		{ yylval.pString = new string(yytext); return (RPAREN); }
{Literal}	{ yylval.pString = new string(yytext); return (LITERAL); }
{BeginComment}{CommentData}{EndComment} {
	addLineNumbers();
	yylval.pString = new string(yytext);
	return (COMMENT);
}


%%

void addLineNumbers()
{
	/* figure out how many lines we passed over */
	int i;
	for (i = 0; i < yyleng; ++i)
	{
		if (yytext[i] == '\r' || yytext[i] == '\n' )
		{
			++line_num;
			if ((i + 1) < yyleng )
				if (yytext[i] == '\r' && yytext[i + 1] == '\n')
					++i;
		}
	}

}
