CREATE TABLE Route          (id int NOT NULL, active int, entry int, exit int, PRIMARY KEY (id));
CREATE TABLE Region         (id int NOT NULL, PRIMARY KEY (id));
CREATE TABLE Segment        (id int NOT NULL, length int NOT NULL DEFAULT 1, PRIMARY KEY (id));
CREATE TABLE Sensor         (id int NOT NULL, region int NOT NULL, PRIMARY KEY (id));
CREATE TABLE Semaphore      (id int NOT NULL, segment int NOT NULL, signal int NOT NULL, PRIMARY KEY (id));
CREATE TABLE Switch         (id int NOT NULL, currentPosition int NOT NULL, PRIMARY KEY (id));
CREATE TABLE SwitchPosition (id int NOT NULL, route int, target int, position int NOT NULL, PRIMARY KEY (id));
CREATE TABLE TrackElement   (id int NOT NULL, region int NOT NULL, PRIMARY KEY (id));
CREATE TABLE connectsTo     (TrackElement1_id int NOT NULL, TrackElement2_id int NOT NULL, PRIMARY KEY (TrackElement1_id, TrackElement2_id));
CREATE TABLE monitoredBy    (TrackElement_id int NOT NULL, Sensor_id int NOT NULL, PRIMARY KEY (TrackElement_id, Sensor_id));
CREATE TABLE requires       (Route_id int NOT NULL, Sensor_id int NOT NULL, PRIMARY KEY (Route_id, Sensor_id));
COPY connectsTo     FROM 'benchmark/trainbenchmark/sf1/connectsTo.csv';
COPY monitoredBy    FROM 'benchmark/trainbenchmark/sf1/monitoredBy.csv';
COPY Region         FROM 'benchmark/trainbenchmark/sf1/Region.csv';
COPY requires       FROM 'benchmark/trainbenchmark/sf1/requires.csv';
COPY Route          FROM 'benchmark/trainbenchmark/sf1/Route.csv';
COPY Segment        FROM 'benchmark/trainbenchmark/sf1/Segment.csv';
COPY Semaphore      FROM 'benchmark/trainbenchmark/sf1/Semaphore.csv';
COPY Sensor         FROM 'benchmark/trainbenchmark/sf1/Sensor.csv';
COPY Switch         FROM 'benchmark/trainbenchmark/sf1/Switch.csv';
COPY SwitchPosition FROM 'benchmark/trainbenchmark/sf1/SwitchPosition.csv';
COPY TrackElement   FROM 'benchmark/trainbenchmark/sf1/TrackElement.csv';